/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     BlobInputStream.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.kulla@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 *
 *\par History:
 * See history of revision control system
 ***************************************************************************/

#ifndef ASF_STREAM_BLOBINPUTSTREAM_H
#define ASF_STREAM_BLOBINPUTSTREAM_H

#include "asf/core/Blob.h"
#include "asf/stream/InputStreamIF.h"

#include <cstring>

#include <cassert>

namespace asf {
namespace stream {

/**
 * A stream which reads data from a memory buffer.
 *
 * TODO: Rename Blob into Buffer
 */
class BlobInputStream : public InputStreamIF {
public:
    BlobInputStream(::asf::core::Blob& blob, size_t offset = 0) : _offset(offset), _blob(blob) {}

    virtual size_t read(void* buffer, size_t size) {
        assert(_offset + size <= _blob.getSize());
        // FIXME: optimize: get rid of calling getBytes()
        // remember the pointer in the blob where we have read
        memcpy(buffer, &_blob.getBytes()[_offset], size);
        _offset += size;
        return size;
    }

    size_t getOffset() const { return _offset; }

private:
    size_t _offset;

    ::asf::core::Blob& _blob;
};
}  // namespace stream
}  // namespace asf

#endif
