/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     DBusUniqueIdRegistry.h
 *\brief
 *
 *\author   CM-AI/PJ-G31
 *          stefan.baron3@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/

#ifndef ASF_DBUS_DBUSUNIQUEIDREGISTRY_H
#define ASF_DBUS_DBUSUNIQUEIDREGISTRY_H

#include <boost/smart_ptr.hpp>
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/threading/Mutex.h"

#include <map>
#include <string>
#include <vector>

class DBusUniqueIdRegistryTest;

namespace asf {
namespace dbus {

/**
 * DBus signal don't provide the busname but the unique connection id.
 * Regarding this, a map is needed for translation to find the right proxy
 */
class DBusUniqueIdRegistry {
public:
    typedef std::vector< std::string > RegisteredBusNameList;

    bool registerUniqueId(const std::string& uniqueId, const std::string& busname);

    bool deregisterUniqueId(const std::string& uniqueId);

    ::boost::shared_ptr< RegisteredBusNameList > findRegisteredBusnames(
        const std::string& uniqueId);

    static DBusUniqueIdRegistry& getInstance();

private:
    typedef std::multimap< std::string, std::string > UniqueIdToBusNameMultiMap;

    UniqueIdToBusNameMultiMap _uniqueIdToBusNameMultiMap;

    ::asf::threading::Mutex _lock;

    friend class ::DBusUniqueIdRegistryTest;

    DECLARE_CLASS_LOGGER();
};

}  // namespace dbus
}  // namespace asf

#endif
