#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ASF_DBUS_DBUSTYPES_H
#define ASF_DBUS_DBUSTYPES_H

#include "asf/core/Internal.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "DBusTypes" isn't clear, then there should be a description here.
 */

namespace asf {
namespace dbus {
namespace DBusTypes {

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class DBusMessageHeaderLog;

class DBusError;

class DefaultMessage;


/**
 * If the meaning of "DBusMessageHeaderLog" isn't clear, then there should be a description here.
 */
class DBusMessageHeaderLog {
public:

    /**
     * Default constructor
     */
    inline  DBusMessageHeaderLog ();

    /**
     * Copy constructor
     */
    inline  DBusMessageHeaderLog (const DBusMessageHeaderLog &rhs);

    /**
     * All fields constructor
     */
    inline  DBusMessageHeaderLog (const ::std::string& msgType_, const ::std::string& destination_, const ::std::string& sender_, const ::std::string& interface_, const ::std::string& objectpath_, const ::std::string& member_, const ::std::string& signature_, uint32 serial_, uint32 replySerial_, const ::std::string& errorName_);

    /**
     * Destructor
     */
    inline  ~DBusMessageHeaderLog();

    /**
     * Assignment operator
     */
    inline DBusMessageHeaderLog& operator = (const DBusMessageHeaderLog& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DBusMessageHeaderLog& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DBusMessageHeaderLog& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DBusMessageHeaderLog& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DBusMessageHeaderLog& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "msgType"

    static const int kMsgType = 0;

    /**
     * Clears the field "msgType".
     *
     * The field will be set to its default value. The hasMsgType()
     * method will return false.
     */
    inline void clearMsgType();

    /**
     * Checks whether the field "msgType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsgType()). Otherwise it will return false.
     */
    inline bool hasMsgType () const;

    /**
     * Returns the value of the member "msgType".
     *
     * If the meaning of "msgType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "msgType"
     */
    inline const ::std::string& getMsgType () const;

    /**
     * Retrieves the value of the field "msgType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "msgType".
     */
    inline ::std::string& getMsgTypeMutable ();

    /**
     * Sets the value of the member "msgType".
     *
     * If the meaning of "msgType" isn't clear, then there should be a description here.
     *
     * @param msgType The value which will be set
     */
    inline void setMsgType (const ::std::string& msgType_);

    /**
     * Sets the value of the member "msgType".
     *
     * If the meaning of "msgType" isn't clear, then there should be a description here.
     *
     * @param msgType The value which will be set
     */
    inline void setMsgType (const char* msgType_);

    /**
     * Sets the value of the member "msgType".
     *
     * If the meaning of "msgType" isn't clear, then there should be a description here.
     *
     * @param msgType The value which will be set
     */
    inline void setMsgType (const char* value, size_t size);

    /**
     * Release the object stored in the field "msgType".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "msgType"
     */
    inline ::std::string* releaseMsgType();

    /**
     * Replace the field "msgType".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceMsgType (::std::string* msgType_);

    // API of field "destination"

    static const int kDestination = 1;

    /**
     * Clears the field "destination".
     *
     * The field will be set to its default value. The hasDestination()
     * method will return false.
     */
    inline void clearDestination();

    /**
     * Checks whether the field "destination" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestination()). Otherwise it will return false.
     */
    inline bool hasDestination () const;

    /**
     * Returns the value of the member "destination".
     *
     * If the meaning of "destination" isn't clear, then there should be a description here.
     *
     * @return The value of the field "destination"
     */
    inline const ::std::string& getDestination () const;

    /**
     * Retrieves the value of the field "destination" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "destination".
     */
    inline ::std::string& getDestinationMutable ();

    /**
     * Sets the value of the member "destination".
     *
     * If the meaning of "destination" isn't clear, then there should be a description here.
     *
     * @param destination The value which will be set
     */
    inline void setDestination (const ::std::string& destination_);

    /**
     * Sets the value of the member "destination".
     *
     * If the meaning of "destination" isn't clear, then there should be a description here.
     *
     * @param destination The value which will be set
     */
    inline void setDestination (const char* destination_);

    /**
     * Sets the value of the member "destination".
     *
     * If the meaning of "destination" isn't clear, then there should be a description here.
     *
     * @param destination The value which will be set
     */
    inline void setDestination (const char* value, size_t size);

    /**
     * Release the object stored in the field "destination".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "destination"
     */
    inline ::std::string* releaseDestination();

    /**
     * Replace the field "destination".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceDestination (::std::string* destination_);

    // API of field "sender"

    static const int kSender = 2;

    /**
     * Clears the field "sender".
     *
     * The field will be set to its default value. The hasSender()
     * method will return false.
     */
    inline void clearSender();

    /**
     * Checks whether the field "sender" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSender()). Otherwise it will return false.
     */
    inline bool hasSender () const;

    /**
     * Returns the value of the member "sender".
     *
     * If the meaning of "sender" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sender"
     */
    inline const ::std::string& getSender () const;

    /**
     * Retrieves the value of the field "sender" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sender".
     */
    inline ::std::string& getSenderMutable ();

    /**
     * Sets the value of the member "sender".
     *
     * If the meaning of "sender" isn't clear, then there should be a description here.
     *
     * @param sender The value which will be set
     */
    inline void setSender (const ::std::string& sender_);

    /**
     * Sets the value of the member "sender".
     *
     * If the meaning of "sender" isn't clear, then there should be a description here.
     *
     * @param sender The value which will be set
     */
    inline void setSender (const char* sender_);

    /**
     * Sets the value of the member "sender".
     *
     * If the meaning of "sender" isn't clear, then there should be a description here.
     *
     * @param sender The value which will be set
     */
    inline void setSender (const char* value, size_t size);

    /**
     * Release the object stored in the field "sender".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sender"
     */
    inline ::std::string* releaseSender();

    /**
     * Replace the field "sender".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSender (::std::string* sender_);

    // API of field "interface"

    static const int kInterface = 3;

    /**
     * Clears the field "interface".
     *
     * The field will be set to its default value. The hasInterface()
     * method will return false.
     */
    inline void clearInterface();

    /**
     * Checks whether the field "interface" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInterface()). Otherwise it will return false.
     */
    inline bool hasInterface () const;

    /**
     * Returns the value of the member "interface".
     *
     * If the meaning of "interface" isn't clear, then there should be a description here.
     *
     * @return The value of the field "interface"
     */
    inline const ::std::string& getInterface () const;

    /**
     * Retrieves the value of the field "interface" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "interface".
     */
    inline ::std::string& getInterfaceMutable ();

    /**
     * Sets the value of the member "interface".
     *
     * If the meaning of "interface" isn't clear, then there should be a description here.
     *
     * @param interface The value which will be set
     */
    inline void setInterface (const ::std::string& interface_);

    /**
     * Sets the value of the member "interface".
     *
     * If the meaning of "interface" isn't clear, then there should be a description here.
     *
     * @param interface The value which will be set
     */
    inline void setInterface (const char* interface_);

    /**
     * Sets the value of the member "interface".
     *
     * If the meaning of "interface" isn't clear, then there should be a description here.
     *
     * @param interface The value which will be set
     */
    inline void setInterface (const char* value, size_t size);

    /**
     * Release the object stored in the field "interface".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "interface"
     */
    inline ::std::string* releaseInterface();

    /**
     * Replace the field "interface".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceInterface (::std::string* interface_);

    // API of field "objectpath"

    static const int kObjectpath = 4;

    /**
     * Clears the field "objectpath".
     *
     * The field will be set to its default value. The hasObjectpath()
     * method will return false.
     */
    inline void clearObjectpath();

    /**
     * Checks whether the field "objectpath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setObjectpath()). Otherwise it will return false.
     */
    inline bool hasObjectpath () const;

    /**
     * Returns the value of the member "objectpath".
     *
     * If the meaning of "objectpath" isn't clear, then there should be a description here.
     *
     * @return The value of the field "objectpath"
     */
    inline const ::std::string& getObjectpath () const;

    /**
     * Retrieves the value of the field "objectpath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "objectpath".
     */
    inline ::std::string& getObjectpathMutable ();

    /**
     * Sets the value of the member "objectpath".
     *
     * If the meaning of "objectpath" isn't clear, then there should be a description here.
     *
     * @param objectpath The value which will be set
     */
    inline void setObjectpath (const ::std::string& objectpath_);

    /**
     * Sets the value of the member "objectpath".
     *
     * If the meaning of "objectpath" isn't clear, then there should be a description here.
     *
     * @param objectpath The value which will be set
     */
    inline void setObjectpath (const char* objectpath_);

    /**
     * Sets the value of the member "objectpath".
     *
     * If the meaning of "objectpath" isn't clear, then there should be a description here.
     *
     * @param objectpath The value which will be set
     */
    inline void setObjectpath (const char* value, size_t size);

    /**
     * Release the object stored in the field "objectpath".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "objectpath"
     */
    inline ::std::string* releaseObjectpath();

    /**
     * Replace the field "objectpath".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceObjectpath (::std::string* objectpath_);

    // API of field "member"

    static const int kMember = 5;

    /**
     * Clears the field "member".
     *
     * The field will be set to its default value. The hasMember()
     * method will return false.
     */
    inline void clearMember();

    /**
     * Checks whether the field "member" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMember()). Otherwise it will return false.
     */
    inline bool hasMember () const;

    /**
     * Returns the value of the member "member".
     *
     * If the meaning of "member" isn't clear, then there should be a description here.
     *
     * @return The value of the field "member"
     */
    inline const ::std::string& getMember () const;

    /**
     * Retrieves the value of the field "member" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "member".
     */
    inline ::std::string& getMemberMutable ();

    /**
     * Sets the value of the member "member".
     *
     * If the meaning of "member" isn't clear, then there should be a description here.
     *
     * @param member The value which will be set
     */
    inline void setMember (const ::std::string& member_);

    /**
     * Sets the value of the member "member".
     *
     * If the meaning of "member" isn't clear, then there should be a description here.
     *
     * @param member The value which will be set
     */
    inline void setMember (const char* member_);

    /**
     * Sets the value of the member "member".
     *
     * If the meaning of "member" isn't clear, then there should be a description here.
     *
     * @param member The value which will be set
     */
    inline void setMember (const char* value, size_t size);

    /**
     * Release the object stored in the field "member".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "member"
     */
    inline ::std::string* releaseMember();

    /**
     * Replace the field "member".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceMember (::std::string* member_);

    // API of field "signature"

    static const int kSignature = 6;

    /**
     * Clears the field "signature".
     *
     * The field will be set to its default value. The hasSignature()
     * method will return false.
     */
    inline void clearSignature();

    /**
     * Checks whether the field "signature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSignature()). Otherwise it will return false.
     */
    inline bool hasSignature () const;

    /**
     * Returns the value of the member "signature".
     *
     * If the meaning of "signature" isn't clear, then there should be a description here.
     *
     * @return The value of the field "signature"
     */
    inline const ::std::string& getSignature () const;

    /**
     * Retrieves the value of the field "signature" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "signature".
     */
    inline ::std::string& getSignatureMutable ();

    /**
     * Sets the value of the member "signature".
     *
     * If the meaning of "signature" isn't clear, then there should be a description here.
     *
     * @param signature The value which will be set
     */
    inline void setSignature (const ::std::string& signature_);

    /**
     * Sets the value of the member "signature".
     *
     * If the meaning of "signature" isn't clear, then there should be a description here.
     *
     * @param signature The value which will be set
     */
    inline void setSignature (const char* signature_);

    /**
     * Sets the value of the member "signature".
     *
     * If the meaning of "signature" isn't clear, then there should be a description here.
     *
     * @param signature The value which will be set
     */
    inline void setSignature (const char* value, size_t size);

    /**
     * Release the object stored in the field "signature".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "signature"
     */
    inline ::std::string* releaseSignature();

    /**
     * Replace the field "signature".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSignature (::std::string* signature_);

    // API of field "serial"

    static const int kSerial = 7;

    /**
     * Clears the field "serial".
     *
     * The field will be set to its default value. The hasSerial()
     * method will return false.
     */
    inline void clearSerial();

    /**
     * Checks whether the field "serial" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSerial()). Otherwise it will return false.
     */
    inline bool hasSerial () const;

    /**
     * Returns the value of the member "serial".
     *
     * If the meaning of "serial" isn't clear, then there should be a description here.
     *
     * @return The value of the field "serial"
     */
    inline uint32 getSerial () const;

    /**
     * Sets the value of the member "serial".
     *
     * If the meaning of "serial" isn't clear, then there should be a description here.
     *
     * @param serial The value which will be set
     */
    inline void setSerial (uint32 serial_);

    // API of field "replySerial"

    static const int kReplySerial = 8;

    /**
     * Clears the field "replySerial".
     *
     * The field will be set to its default value. The hasReplySerial()
     * method will return false.
     */
    inline void clearReplySerial();

    /**
     * Checks whether the field "replySerial" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReplySerial()). Otherwise it will return false.
     */
    inline bool hasReplySerial () const;

    /**
     * Returns the value of the member "replySerial".
     *
     * If the meaning of "replySerial" isn't clear, then there should be a description here.
     *
     * @return The value of the field "replySerial"
     */
    inline uint32 getReplySerial () const;

    /**
     * Sets the value of the member "replySerial".
     *
     * If the meaning of "replySerial" isn't clear, then there should be a description here.
     *
     * @param replySerial The value which will be set
     */
    inline void setReplySerial (uint32 replySerial_);

    // API of field "errorName"

    static const int kErrorName = 9;

    /**
     * Clears the field "errorName".
     *
     * The field will be set to its default value. The hasErrorName()
     * method will return false.
     */
    inline void clearErrorName();

    /**
     * Checks whether the field "errorName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorName()). Otherwise it will return false.
     */
    inline bool hasErrorName () const;

    /**
     * Returns the value of the member "errorName".
     *
     * If the meaning of "errorName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "errorName"
     */
    inline const ::std::string& getErrorName () const;

    /**
     * Retrieves the value of the field "errorName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "errorName".
     */
    inline ::std::string& getErrorNameMutable ();

    /**
     * Sets the value of the member "errorName".
     *
     * If the meaning of "errorName" isn't clear, then there should be a description here.
     *
     * @param errorName The value which will be set
     */
    inline void setErrorName (const ::std::string& errorName_);

    /**
     * Sets the value of the member "errorName".
     *
     * If the meaning of "errorName" isn't clear, then there should be a description here.
     *
     * @param errorName The value which will be set
     */
    inline void setErrorName (const char* errorName_);

    /**
     * Sets the value of the member "errorName".
     *
     * If the meaning of "errorName" isn't clear, then there should be a description here.
     *
     * @param errorName The value which will be set
     */
    inline void setErrorName (const char* value, size_t size);

    /**
     * Release the object stored in the field "errorName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "errorName"
     */
    inline ::std::string* releaseErrorName();

    /**
     * Replace the field "errorName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceErrorName (::std::string* errorName_);

    static const DBusMessageHeaderLog &getDefaultInstance();

private:

    inline void set_has_msgType ();

    inline void clear_has_msgType ();

    inline void set_has_destination ();

    inline void clear_has_destination ();

    inline void set_has_sender ();

    inline void clear_has_sender ();

    inline void set_has_interface ();

    inline void clear_has_interface ();

    inline void set_has_objectpath ();

    inline void clear_has_objectpath ();

    inline void set_has_member ();

    inline void clear_has_member ();

    inline void set_has_signature ();

    inline void clear_has_signature ();

    inline void set_has_serial ();

    inline void clear_has_serial ();

    inline void set_has_replySerial ();

    inline void clear_has_replySerial ();

    inline void set_has_errorName ();

    inline void clear_has_errorName ();

    uint32 _has_bits_[ (10 + 31) / 32];

    ::std::string* _msgType;

    ::std::string* _destination;

    ::std::string* _sender;

    ::std::string* _interface;

    ::std::string* _objectpath;

    ::std::string* _member;

    ::std::string* _signature;

    uint32 _serial;

    uint32 _replySerial;

    ::std::string* _errorName;

};

/**
 * If the meaning of "DBusError" isn't clear, then there should be a description here.
 */
class DBusError  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DBusError ();

    /**
     * Copy constructor
     */
    inline  DBusError (const DBusError &rhs);

    /**
     * All fields constructor
     */
    inline  DBusError (const ::std::string& name_, const ::std::string& message_);

    /**
     * Destructor
     */
    inline virtual  ~DBusError();

    /**
     * Assignment operator
     */
    inline DBusError& operator = (const DBusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DBusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DBusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DBusError& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DBusError& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    /**
     * Release the object stored in the field "name".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "name"
     */
    inline ::std::string* releaseName();

    /**
     * Replace the field "name".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceName (::std::string* name_);

    // API of field "message"

    static const int kMessage = 1;

    /**
     * Clears the field "message".
     *
     * The field will be set to its default value. The hasMessage()
     * method will return false.
     */
    inline void clearMessage();

    /**
     * Checks whether the field "message" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMessage()). Otherwise it will return false.
     */
    inline bool hasMessage () const;

    /**
     * Returns the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @return The value of the field "message"
     */
    inline const ::std::string& getMessage () const;

    /**
     * Retrieves the value of the field "message" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "message".
     */
    inline ::std::string& getMessageMutable ();

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const ::std::string& message_);

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const char* message_);

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const char* value, size_t size);

    /**
     * Release the object stored in the field "message".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "message"
     */
    inline ::std::string* releaseMessage();

    /**
     * Replace the field "message".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceMessage (::std::string* message_);

    static const DBusError &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_message ();

    inline void clear_has_message ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string* _name;

    ::std::string* _message;

};

/**
 * DefaultMessage is used for messages without parameters. ASF creates typedefs from
 * a message without parameters to DefaultMessage.
 */
class DefaultMessage  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DefaultMessage ();

    /**
     * Copy constructor
     */
    inline  DefaultMessage (const DefaultMessage &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DefaultMessage();

    /**
     * Assignment operator
     */
    inline DefaultMessage& operator = (const DefaultMessage& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DefaultMessage& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DefaultMessage& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DefaultMessage& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DefaultMessage& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DefaultMessage &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  DBusMessageHeaderLog::DBusMessageHeaderLog ()  :
    _msgType (NULL),
    _destination (NULL),
    _sender (NULL),
    _interface (NULL),
    _objectpath (NULL),
    _member (NULL),
    _signature (NULL),
    _serial (0u),
    _replySerial (0u),
    _errorName (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DBusMessageHeaderLog::DBusMessageHeaderLog (const DBusMessageHeaderLog &rhs)  :
    _msgType (NULL),
    _destination (NULL),
    _sender (NULL),
    _interface (NULL),
    _objectpath (NULL),
    _member (NULL),
    _signature (NULL),
    _serial (0u),
    _replySerial (0u),
    _errorName (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DBusMessageHeaderLog::DBusMessageHeaderLog (const ::std::string& msgType_, const ::std::string& destination_, const ::std::string& sender_, const ::std::string& interface_, const ::std::string& objectpath_, const ::std::string& member_, const ::std::string& signature_, uint32 serial_, uint32 replySerial_, const ::std::string& errorName_)  :
    _msgType (new ::std::string(msgType_)),
    _destination (new ::std::string(destination_)),
    _sender (new ::std::string(sender_)),
    _interface (new ::std::string(interface_)),
    _objectpath (new ::std::string(objectpath_)),
    _member (new ::std::string(member_)),
    _signature (new ::std::string(signature_)),
    _serial (serial_),
    _replySerial (replySerial_),
    _errorName (new ::std::string(errorName_))
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (msgType_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (destination_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sender_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (interface_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (objectpath_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (member_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (signature_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (errorName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DBusMessageHeaderLog::~DBusMessageHeaderLog() {
    delete _msgType;
    delete _destination;
    delete _sender;
    delete _interface;
    delete _objectpath;
    delete _member;
    delete _signature;
    delete _errorName;
}

inline DBusMessageHeaderLog& DBusMessageHeaderLog::operator = (const DBusMessageHeaderLog& rhs) {
    if( this != &rhs ) {
        if (rhs.hasMsgType()) {
            setMsgType(rhs.getMsgType());
        } else {
            clearMsgType();
        }
        if (rhs.hasDestination()) {
            setDestination(rhs.getDestination());
        } else {
            clearDestination();
        }
        if (rhs.hasSender()) {
            setSender(rhs.getSender());
        } else {
            clearSender();
        }
        if (rhs.hasInterface()) {
            setInterface(rhs.getInterface());
        } else {
            clearInterface();
        }
        if (rhs.hasObjectpath()) {
            setObjectpath(rhs.getObjectpath());
        } else {
            clearObjectpath();
        }
        if (rhs.hasMember()) {
            setMember(rhs.getMember());
        } else {
            clearMember();
        }
        if (rhs.hasSignature()) {
            setSignature(rhs.getSignature());
        } else {
            clearSignature();
        }
        if (rhs.hasSerial()) {
            setSerial(rhs.getSerial());
        } else {
            clearSerial();
        }
        if (rhs.hasReplySerial()) {
            setReplySerial(rhs.getReplySerial());
        } else {
            clearReplySerial();
        }
        if (rhs.hasErrorName()) {
            setErrorName(rhs.getErrorName());
        } else {
            clearErrorName();
        }
    }
    return *this;
}

inline bool DBusMessageHeaderLog::operator == (const DBusMessageHeaderLog& rhs) const {
    return (((!hasMsgType() && !rhs.hasMsgType()) || getMsgType() == rhs.getMsgType()) &&
        ((!hasDestination() && !rhs.hasDestination()) || getDestination() == rhs.getDestination()) &&
        ((!hasSender() && !rhs.hasSender()) || getSender() == rhs.getSender()) &&
        ((!hasInterface() && !rhs.hasInterface()) || getInterface() == rhs.getInterface()) &&
        ((!hasObjectpath() && !rhs.hasObjectpath()) || getObjectpath() == rhs.getObjectpath()) &&
        ((!hasMember() && !rhs.hasMember()) || getMember() == rhs.getMember()) &&
        ((!hasSignature() && !rhs.hasSignature()) || getSignature() == rhs.getSignature()) &&
        ((!hasSerial() && !rhs.hasSerial()) || getSerial() == rhs.getSerial()) &&
        ((!hasReplySerial() && !rhs.hasReplySerial()) || getReplySerial() == rhs.getReplySerial()) &&
        ((!hasErrorName() && !rhs.hasErrorName()) || getErrorName() == rhs.getErrorName()));
}

inline bool DBusMessageHeaderLog::operator != (const DBusMessageHeaderLog& rhs) const {
    return ! (*this == rhs);
}

inline bool DBusMessageHeaderLog::operator < (const DBusMessageHeaderLog& rhs) const {
    if (hasMsgType() || rhs.hasMsgType()) {
        if (getMsgType() < rhs.getMsgType()) return true;
        if (getMsgType() > rhs.getMsgType()) return false;
    }
    if (hasDestination() || rhs.hasDestination()) {
        if (getDestination() < rhs.getDestination()) return true;
        if (getDestination() > rhs.getDestination()) return false;
    }
    if (hasSender() || rhs.hasSender()) {
        if (getSender() < rhs.getSender()) return true;
        if (getSender() > rhs.getSender()) return false;
    }
    if (hasInterface() || rhs.hasInterface()) {
        if (getInterface() < rhs.getInterface()) return true;
        if (getInterface() > rhs.getInterface()) return false;
    }
    if (hasObjectpath() || rhs.hasObjectpath()) {
        if (getObjectpath() < rhs.getObjectpath()) return true;
        if (getObjectpath() > rhs.getObjectpath()) return false;
    }
    if (hasMember() || rhs.hasMember()) {
        if (getMember() < rhs.getMember()) return true;
        if (getMember() > rhs.getMember()) return false;
    }
    if (hasSignature() || rhs.hasSignature()) {
        if (getSignature() < rhs.getSignature()) return true;
        if (getSignature() > rhs.getSignature()) return false;
    }
    if (hasSerial() || rhs.hasSerial()) {
        if (getSerial() < rhs.getSerial()) return true;
        if (getSerial() > rhs.getSerial()) return false;
    }
    if (hasReplySerial() || rhs.hasReplySerial()) {
        if (getReplySerial() < rhs.getReplySerial()) return true;
        if (getReplySerial() > rhs.getReplySerial()) return false;
    }
    if (hasErrorName() || rhs.hasErrorName()) {
        if (getErrorName() < rhs.getErrorName()) return true;
        if (getErrorName() > rhs.getErrorName()) return false;
    }
    return false;
}

inline bool DBusMessageHeaderLog::operator > (const DBusMessageHeaderLog& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DBusMessageHeaderLog::clear() {
    clearMsgType();
    clearDestination();
    clearSender();
    clearInterface();
    clearObjectpath();
    clearMember();
    clearSignature();
    clearSerial();
    clearReplySerial();
    clearErrorName();
}

inline void DBusMessageHeaderLog::clearMsgType() {
    if (hasMsgType()) {
         clear_has_msgType();
        if (_msgType != NULL) {
            _msgType->clear();
        }
     }
}

inline bool DBusMessageHeaderLog::hasMsgType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DBusMessageHeaderLog::getMsgType () const {
    if (_msgType == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_msgType;
}

inline ::std::string& DBusMessageHeaderLog::getMsgTypeMutable () {
    set_has_msgType();
    if (_msgType == NULL) {
        _msgType = new ::std::string ();
        CHECK_ALLOCATION( _msgType );
    }
    return *_msgType;
}

inline void DBusMessageHeaderLog::setMsgType (const ::std::string& msgType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (msgType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_msgType();
    if (this->_msgType == NULL) {
        this->_msgType = new ::std::string (msgType_);
        CHECK_ALLOCATION( this->_msgType );
    } else {
        *this->_msgType = msgType_;
    }
}

inline void DBusMessageHeaderLog::setMsgType (const char* msgType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (msgType_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_msgType();
    if (this->_msgType == NULL) {
        this->_msgType = new ::std::string (msgType_);
        CHECK_ALLOCATION( this->_msgType );
    } else {
        this->_msgType->assign(msgType_);
    }
}

inline void DBusMessageHeaderLog::setMsgType (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_msgType();
    if (this->_msgType == NULL) {
        this->_msgType = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_msgType );
    } else {
        this->_msgType->assign(value, size);
    }
}

inline ::std::string* DBusMessageHeaderLog::releaseMsgType() {
    clear_has_msgType();
    ::std::string* temp = _msgType;
    this->_msgType = NULL;
    return temp;
}

inline void DBusMessageHeaderLog::replaceMsgType (::std::string* msgType_) {
    set_has_msgType();
    if (this->_msgType != msgType_) {
        if (this->_msgType != NULL) {
            delete this->_msgType;
        }
        this->_msgType = msgType_;
    }
}

inline void DBusMessageHeaderLog::clearDestination() {
    if (hasDestination()) {
         clear_has_destination();
        if (_destination != NULL) {
            _destination->clear();
        }
     }
}

inline bool DBusMessageHeaderLog::hasDestination () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& DBusMessageHeaderLog::getDestination () const {
    if (_destination == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_destination;
}

inline ::std::string& DBusMessageHeaderLog::getDestinationMutable () {
    set_has_destination();
    if (_destination == NULL) {
        _destination = new ::std::string ();
        CHECK_ALLOCATION( _destination );
    }
    return *_destination;
}

inline void DBusMessageHeaderLog::setDestination (const ::std::string& destination_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (destination_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_destination();
    if (this->_destination == NULL) {
        this->_destination = new ::std::string (destination_);
        CHECK_ALLOCATION( this->_destination );
    } else {
        *this->_destination = destination_;
    }
}

inline void DBusMessageHeaderLog::setDestination (const char* destination_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (destination_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_destination();
    if (this->_destination == NULL) {
        this->_destination = new ::std::string (destination_);
        CHECK_ALLOCATION( this->_destination );
    } else {
        this->_destination->assign(destination_);
    }
}

inline void DBusMessageHeaderLog::setDestination (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_destination();
    if (this->_destination == NULL) {
        this->_destination = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_destination );
    } else {
        this->_destination->assign(value, size);
    }
}

inline ::std::string* DBusMessageHeaderLog::releaseDestination() {
    clear_has_destination();
    ::std::string* temp = _destination;
    this->_destination = NULL;
    return temp;
}

inline void DBusMessageHeaderLog::replaceDestination (::std::string* destination_) {
    set_has_destination();
    if (this->_destination != destination_) {
        if (this->_destination != NULL) {
            delete this->_destination;
        }
        this->_destination = destination_;
    }
}

inline void DBusMessageHeaderLog::clearSender() {
    if (hasSender()) {
         clear_has_sender();
        if (_sender != NULL) {
            _sender->clear();
        }
     }
}

inline bool DBusMessageHeaderLog::hasSender () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& DBusMessageHeaderLog::getSender () const {
    if (_sender == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_sender;
}

inline ::std::string& DBusMessageHeaderLog::getSenderMutable () {
    set_has_sender();
    if (_sender == NULL) {
        _sender = new ::std::string ();
        CHECK_ALLOCATION( _sender );
    }
    return *_sender;
}

inline void DBusMessageHeaderLog::setSender (const ::std::string& sender_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sender_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sender();
    if (this->_sender == NULL) {
        this->_sender = new ::std::string (sender_);
        CHECK_ALLOCATION( this->_sender );
    } else {
        *this->_sender = sender_;
    }
}

inline void DBusMessageHeaderLog::setSender (const char* sender_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sender_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sender();
    if (this->_sender == NULL) {
        this->_sender = new ::std::string (sender_);
        CHECK_ALLOCATION( this->_sender );
    } else {
        this->_sender->assign(sender_);
    }
}

inline void DBusMessageHeaderLog::setSender (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sender();
    if (this->_sender == NULL) {
        this->_sender = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_sender );
    } else {
        this->_sender->assign(value, size);
    }
}

inline ::std::string* DBusMessageHeaderLog::releaseSender() {
    clear_has_sender();
    ::std::string* temp = _sender;
    this->_sender = NULL;
    return temp;
}

inline void DBusMessageHeaderLog::replaceSender (::std::string* sender_) {
    set_has_sender();
    if (this->_sender != sender_) {
        if (this->_sender != NULL) {
            delete this->_sender;
        }
        this->_sender = sender_;
    }
}

inline void DBusMessageHeaderLog::clearInterface() {
    if (hasInterface()) {
         clear_has_interface();
        if (_interface != NULL) {
            _interface->clear();
        }
     }
}

inline bool DBusMessageHeaderLog::hasInterface () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& DBusMessageHeaderLog::getInterface () const {
    if (_interface == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_interface;
}

inline ::std::string& DBusMessageHeaderLog::getInterfaceMutable () {
    set_has_interface();
    if (_interface == NULL) {
        _interface = new ::std::string ();
        CHECK_ALLOCATION( _interface );
    }
    return *_interface;
}

inline void DBusMessageHeaderLog::setInterface (const ::std::string& interface_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (interface_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_interface();
    if (this->_interface == NULL) {
        this->_interface = new ::std::string (interface_);
        CHECK_ALLOCATION( this->_interface );
    } else {
        *this->_interface = interface_;
    }
}

inline void DBusMessageHeaderLog::setInterface (const char* interface_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (interface_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_interface();
    if (this->_interface == NULL) {
        this->_interface = new ::std::string (interface_);
        CHECK_ALLOCATION( this->_interface );
    } else {
        this->_interface->assign(interface_);
    }
}

inline void DBusMessageHeaderLog::setInterface (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_interface();
    if (this->_interface == NULL) {
        this->_interface = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_interface );
    } else {
        this->_interface->assign(value, size);
    }
}

inline ::std::string* DBusMessageHeaderLog::releaseInterface() {
    clear_has_interface();
    ::std::string* temp = _interface;
    this->_interface = NULL;
    return temp;
}

inline void DBusMessageHeaderLog::replaceInterface (::std::string* interface_) {
    set_has_interface();
    if (this->_interface != interface_) {
        if (this->_interface != NULL) {
            delete this->_interface;
        }
        this->_interface = interface_;
    }
}

inline void DBusMessageHeaderLog::clearObjectpath() {
    if (hasObjectpath()) {
         clear_has_objectpath();
        if (_objectpath != NULL) {
            _objectpath->clear();
        }
     }
}

inline bool DBusMessageHeaderLog::hasObjectpath () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& DBusMessageHeaderLog::getObjectpath () const {
    if (_objectpath == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_objectpath;
}

inline ::std::string& DBusMessageHeaderLog::getObjectpathMutable () {
    set_has_objectpath();
    if (_objectpath == NULL) {
        _objectpath = new ::std::string ();
        CHECK_ALLOCATION( _objectpath );
    }
    return *_objectpath;
}

inline void DBusMessageHeaderLog::setObjectpath (const ::std::string& objectpath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (objectpath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_objectpath();
    if (this->_objectpath == NULL) {
        this->_objectpath = new ::std::string (objectpath_);
        CHECK_ALLOCATION( this->_objectpath );
    } else {
        *this->_objectpath = objectpath_;
    }
}

inline void DBusMessageHeaderLog::setObjectpath (const char* objectpath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (objectpath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_objectpath();
    if (this->_objectpath == NULL) {
        this->_objectpath = new ::std::string (objectpath_);
        CHECK_ALLOCATION( this->_objectpath );
    } else {
        this->_objectpath->assign(objectpath_);
    }
}

inline void DBusMessageHeaderLog::setObjectpath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_objectpath();
    if (this->_objectpath == NULL) {
        this->_objectpath = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_objectpath );
    } else {
        this->_objectpath->assign(value, size);
    }
}

inline ::std::string* DBusMessageHeaderLog::releaseObjectpath() {
    clear_has_objectpath();
    ::std::string* temp = _objectpath;
    this->_objectpath = NULL;
    return temp;
}

inline void DBusMessageHeaderLog::replaceObjectpath (::std::string* objectpath_) {
    set_has_objectpath();
    if (this->_objectpath != objectpath_) {
        if (this->_objectpath != NULL) {
            delete this->_objectpath;
        }
        this->_objectpath = objectpath_;
    }
}

inline void DBusMessageHeaderLog::clearMember() {
    if (hasMember()) {
         clear_has_member();
        if (_member != NULL) {
            _member->clear();
        }
     }
}

inline bool DBusMessageHeaderLog::hasMember () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& DBusMessageHeaderLog::getMember () const {
    if (_member == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_member;
}

inline ::std::string& DBusMessageHeaderLog::getMemberMutable () {
    set_has_member();
    if (_member == NULL) {
        _member = new ::std::string ();
        CHECK_ALLOCATION( _member );
    }
    return *_member;
}

inline void DBusMessageHeaderLog::setMember (const ::std::string& member_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (member_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_member();
    if (this->_member == NULL) {
        this->_member = new ::std::string (member_);
        CHECK_ALLOCATION( this->_member );
    } else {
        *this->_member = member_;
    }
}

inline void DBusMessageHeaderLog::setMember (const char* member_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (member_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_member();
    if (this->_member == NULL) {
        this->_member = new ::std::string (member_);
        CHECK_ALLOCATION( this->_member );
    } else {
        this->_member->assign(member_);
    }
}

inline void DBusMessageHeaderLog::setMember (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_member();
    if (this->_member == NULL) {
        this->_member = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_member );
    } else {
        this->_member->assign(value, size);
    }
}

inline ::std::string* DBusMessageHeaderLog::releaseMember() {
    clear_has_member();
    ::std::string* temp = _member;
    this->_member = NULL;
    return temp;
}

inline void DBusMessageHeaderLog::replaceMember (::std::string* member_) {
    set_has_member();
    if (this->_member != member_) {
        if (this->_member != NULL) {
            delete this->_member;
        }
        this->_member = member_;
    }
}

inline void DBusMessageHeaderLog::clearSignature() {
    if (hasSignature()) {
         clear_has_signature();
        if (_signature != NULL) {
            _signature->clear();
        }
     }
}

inline bool DBusMessageHeaderLog::hasSignature () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& DBusMessageHeaderLog::getSignature () const {
    if (_signature == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_signature;
}

inline ::std::string& DBusMessageHeaderLog::getSignatureMutable () {
    set_has_signature();
    if (_signature == NULL) {
        _signature = new ::std::string ();
        CHECK_ALLOCATION( _signature );
    }
    return *_signature;
}

inline void DBusMessageHeaderLog::setSignature (const ::std::string& signature_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (signature_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_signature();
    if (this->_signature == NULL) {
        this->_signature = new ::std::string (signature_);
        CHECK_ALLOCATION( this->_signature );
    } else {
        *this->_signature = signature_;
    }
}

inline void DBusMessageHeaderLog::setSignature (const char* signature_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (signature_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_signature();
    if (this->_signature == NULL) {
        this->_signature = new ::std::string (signature_);
        CHECK_ALLOCATION( this->_signature );
    } else {
        this->_signature->assign(signature_);
    }
}

inline void DBusMessageHeaderLog::setSignature (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_signature();
    if (this->_signature == NULL) {
        this->_signature = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_signature );
    } else {
        this->_signature->assign(value, size);
    }
}

inline ::std::string* DBusMessageHeaderLog::releaseSignature() {
    clear_has_signature();
    ::std::string* temp = _signature;
    this->_signature = NULL;
    return temp;
}

inline void DBusMessageHeaderLog::replaceSignature (::std::string* signature_) {
    set_has_signature();
    if (this->_signature != signature_) {
        if (this->_signature != NULL) {
            delete this->_signature;
        }
        this->_signature = signature_;
    }
}

inline void DBusMessageHeaderLog::clearSerial() {
    if (hasSerial()) {
         clear_has_serial();
        _serial = 0u;
     }
}

inline bool DBusMessageHeaderLog::hasSerial () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint32 DBusMessageHeaderLog::getSerial () const {
    return _serial;
}

inline void DBusMessageHeaderLog::setSerial (uint32 serial_) {
    set_has_serial();
    this->_serial = serial_;
}

inline void DBusMessageHeaderLog::clearReplySerial() {
    if (hasReplySerial()) {
         clear_has_replySerial();
        _replySerial = 0u;
     }
}

inline bool DBusMessageHeaderLog::hasReplySerial () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint32 DBusMessageHeaderLog::getReplySerial () const {
    return _replySerial;
}

inline void DBusMessageHeaderLog::setReplySerial (uint32 replySerial_) {
    set_has_replySerial();
    this->_replySerial = replySerial_;
}

inline void DBusMessageHeaderLog::clearErrorName() {
    if (hasErrorName()) {
         clear_has_errorName();
        if (_errorName != NULL) {
            _errorName->clear();
        }
     }
}

inline bool DBusMessageHeaderLog::hasErrorName () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::std::string& DBusMessageHeaderLog::getErrorName () const {
    if (_errorName == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_errorName;
}

inline ::std::string& DBusMessageHeaderLog::getErrorNameMutable () {
    set_has_errorName();
    if (_errorName == NULL) {
        _errorName = new ::std::string ();
        CHECK_ALLOCATION( _errorName );
    }
    return *_errorName;
}

inline void DBusMessageHeaderLog::setErrorName (const ::std::string& errorName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (errorName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_errorName();
    if (this->_errorName == NULL) {
        this->_errorName = new ::std::string (errorName_);
        CHECK_ALLOCATION( this->_errorName );
    } else {
        *this->_errorName = errorName_;
    }
}

inline void DBusMessageHeaderLog::setErrorName (const char* errorName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (errorName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_errorName();
    if (this->_errorName == NULL) {
        this->_errorName = new ::std::string (errorName_);
        CHECK_ALLOCATION( this->_errorName );
    } else {
        this->_errorName->assign(errorName_);
    }
}

inline void DBusMessageHeaderLog::setErrorName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_errorName();
    if (this->_errorName == NULL) {
        this->_errorName = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_errorName );
    } else {
        this->_errorName->assign(value, size);
    }
}

inline ::std::string* DBusMessageHeaderLog::releaseErrorName() {
    clear_has_errorName();
    ::std::string* temp = _errorName;
    this->_errorName = NULL;
    return temp;
}

inline void DBusMessageHeaderLog::replaceErrorName (::std::string* errorName_) {
    set_has_errorName();
    if (this->_errorName != errorName_) {
        if (this->_errorName != NULL) {
            delete this->_errorName;
        }
        this->_errorName = errorName_;
    }
}

inline void DBusMessageHeaderLog::set_has_msgType () {
    _has_bits_[0] |= 1u << 0;
}

inline void DBusMessageHeaderLog::clear_has_msgType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DBusMessageHeaderLog::set_has_destination () {
    _has_bits_[0] |= 1u << 1;
}

inline void DBusMessageHeaderLog::clear_has_destination () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DBusMessageHeaderLog::set_has_sender () {
    _has_bits_[0] |= 1u << 2;
}

inline void DBusMessageHeaderLog::clear_has_sender () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void DBusMessageHeaderLog::set_has_interface () {
    _has_bits_[0] |= 1u << 3;
}

inline void DBusMessageHeaderLog::clear_has_interface () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void DBusMessageHeaderLog::set_has_objectpath () {
    _has_bits_[0] |= 1u << 4;
}

inline void DBusMessageHeaderLog::clear_has_objectpath () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void DBusMessageHeaderLog::set_has_member () {
    _has_bits_[0] |= 1u << 5;
}

inline void DBusMessageHeaderLog::clear_has_member () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void DBusMessageHeaderLog::set_has_signature () {
    _has_bits_[0] |= 1u << 6;
}

inline void DBusMessageHeaderLog::clear_has_signature () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void DBusMessageHeaderLog::set_has_serial () {
    _has_bits_[0] |= 1u << 7;
}

inline void DBusMessageHeaderLog::clear_has_serial () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void DBusMessageHeaderLog::set_has_replySerial () {
    _has_bits_[0] |= 1u << 8;
}

inline void DBusMessageHeaderLog::clear_has_replySerial () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void DBusMessageHeaderLog::set_has_errorName () {
    _has_bits_[0] |= 1u << 9;
}

inline void DBusMessageHeaderLog::clear_has_errorName () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline  DBusError::DBusError ()  :
    _name (NULL),
    _message (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DBusError::DBusError (const DBusError &rhs)  :
    ::asf::core::Payload(rhs),
    _name (NULL),
    _message (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DBusError::DBusError (const ::std::string& name_, const ::std::string& message_)  :
    _name (new ::std::string(name_)),
    _message (new ::std::string(message_))
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DBusError::~DBusError() {
    delete _name;
    delete _message;
}

inline DBusError& DBusError::operator = (const DBusError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasMessage()) {
            setMessage(rhs.getMessage());
        } else {
            clearMessage();
        }
    }
    return *this;
}

inline bool DBusError::operator == (const DBusError& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasMessage() && !rhs.hasMessage()) || getMessage() == rhs.getMessage()));
}

inline bool DBusError::operator != (const DBusError& rhs) const {
    return ! (*this == rhs);
}

inline bool DBusError::operator < (const DBusError& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasMessage() || rhs.hasMessage()) {
        if (getMessage() < rhs.getMessage()) return true;
        if (getMessage() > rhs.getMessage()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DBusError::clone() {
    return new DBusError(*this);
}

inline bool DBusError::operator > (const DBusError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DBusError::clear() {
    clearName();
    clearMessage();
}

inline void DBusError::clearName() {
    if (hasName()) {
         clear_has_name();
        if (_name != NULL) {
            _name->clear();
        }
     }
}

inline bool DBusError::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DBusError::getName () const {
    if (_name == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_name;
}

inline ::std::string& DBusError::getNameMutable () {
    set_has_name();
    if (_name == NULL) {
        _name = new ::std::string ();
        CHECK_ALLOCATION( _name );
    }
    return *_name;
}

inline void DBusError::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    if (this->_name == NULL) {
        this->_name = new ::std::string (name_);
        CHECK_ALLOCATION( this->_name );
    } else {
        *this->_name = name_;
    }
}

inline void DBusError::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    if (this->_name == NULL) {
        this->_name = new ::std::string (name_);
        CHECK_ALLOCATION( this->_name );
    } else {
        this->_name->assign(name_);
    }
}

inline void DBusError::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    if (this->_name == NULL) {
        this->_name = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_name );
    } else {
        this->_name->assign(value, size);
    }
}

inline ::std::string* DBusError::releaseName() {
    clear_has_name();
    ::std::string* temp = _name;
    this->_name = NULL;
    return temp;
}

inline void DBusError::replaceName (::std::string* name_) {
    set_has_name();
    if (this->_name != name_) {
        if (this->_name != NULL) {
            delete this->_name;
        }
        this->_name = name_;
    }
}

inline void DBusError::clearMessage() {
    if (hasMessage()) {
         clear_has_message();
        if (_message != NULL) {
            _message->clear();
        }
     }
}

inline bool DBusError::hasMessage () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& DBusError::getMessage () const {
    if (_message == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_message;
}

inline ::std::string& DBusError::getMessageMutable () {
    set_has_message();
    if (_message == NULL) {
        _message = new ::std::string ();
        CHECK_ALLOCATION( _message );
    }
    return *_message;
}

inline void DBusError::setMessage (const ::std::string& message_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    if (this->_message == NULL) {
        this->_message = new ::std::string (message_);
        CHECK_ALLOCATION( this->_message );
    } else {
        *this->_message = message_;
    }
}

inline void DBusError::setMessage (const char* message_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    if (this->_message == NULL) {
        this->_message = new ::std::string (message_);
        CHECK_ALLOCATION( this->_message );
    } else {
        this->_message->assign(message_);
    }
}

inline void DBusError::setMessage (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    if (this->_message == NULL) {
        this->_message = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_message );
    } else {
        this->_message->assign(value, size);
    }
}

inline ::std::string* DBusError::releaseMessage() {
    clear_has_message();
    ::std::string* temp = _message;
    this->_message = NULL;
    return temp;
}

inline void DBusError::replaceMessage (::std::string* message_) {
    set_has_message();
    if (this->_message != message_) {
        if (this->_message != NULL) {
            delete this->_message;
        }
        this->_message = message_;
    }
}

inline void DBusError::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void DBusError::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DBusError::set_has_message () {
    _has_bits_[0] |= 1u << 1;
}

inline void DBusError::clear_has_message () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DefaultMessage::DefaultMessage () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DefaultMessage::DefaultMessage (const DefaultMessage &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DefaultMessage::~DefaultMessage() {
}

inline DefaultMessage& DefaultMessage::operator = (const DefaultMessage& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DefaultMessage::operator == (const DefaultMessage& ) const {
    return true;
}

inline bool DefaultMessage::operator != (const DefaultMessage& rhs) const {
    return ! (*this == rhs);
}

inline bool DefaultMessage::operator < (const DefaultMessage& ) const {
    return false;
}

inline ::asf::core::Payload* DefaultMessage::clone() {
    return new DefaultMessage(*this);
}

inline bool DefaultMessage::operator > (const DefaultMessage& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DefaultMessage::clear() {
}

} // namespace DBusTypes
} // namespace dbus
} // namespace asf

#endif // ASF_DBUS_DBUSTYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
