/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     DBusStubDelegate.h
 *\brief
 *
 *\author   CM-AI/PJ-G31
 *          stefan.baron3@de.bosch.com
 *
 *\par Copyright:
 *(c) 2013-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_DBUS_DBUSSTUBDELEGATE_H
#define ASF_DBUS_DBUSSTUBDELEGATE_H

#include "asf/core/ComponentDescription.h"
#include "asf/core/IncomingOutgoingIF.h"
#include "asf/core/Message.h"
#include "asf/core/Payload.h"
#include "asf/core/StubDelegateBase.h"

#include "asf/threading/Mutex.h"

#include "asf/dbus/DBusExportedPort.h"
#include "asf/dbus/DBusStub.h"

#include "asf/dbus/org/freedesktop/DBus/PropertiesStub.h"

#include "dbus/dbus.h"

#include <map>

class DBusMessageFactoryTest;
class DBusStubTest;
class DBusStubRegistryTest;

namespace asf {
namespace core {

class CommunicationStack;
class ServiceMessage;
}  // namespace core
}  // namespace asf

namespace asf {
namespace dbus {

class DBusIntrospectableImpl;
class DBusVariant;
class DBusPropertiesImpl;
class DBusConnector;

class DBusStubDelegate : public ::asf::core::StubDelegateBase {
public:
    DBusStubDelegate(DBusStub* stub, ::asf::core::Logger& logger);

    DBusStubDelegate(DBusStub* stub, ::asf::core::Logger& logger, const std::string& objectPath);

    DBusStubDelegate(DBusStub* stub,
                     ::asf::core::Logger& logger,
                     DBusConnector& connector,
                     const std::string& objectPath,
                     const std::string& interfaceName);

    virtual ~DBusStubDelegate();

    virtual void process(::asf::core::ServiceMessage& msg) = 0;

    // introspection api
    virtual const char* introspect() const = 0;

    // properties api
    virtual void getAllProperties(
        ::std::map< ::std::string, ::asf::dbus::DBusVariant >& /*properties*/){};

    virtual void setProperty(const ::std::string& /*property*/,
                             const ::asf::dbus::DBusVariant& /*value*/,
                             const act_t& /*act*/){};

    virtual void getProperty(const ::std::string& /*property*/, const act_t& /*act*/){};

    void sendPropertiesChangedSignal(
        const ::std::string& interface_name,
        const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& changed_properties,
        const ::std::vector< ::std::string >& invalidated_properties);

    void sendSetResponse(act_t act);

    void sendSetError(const std::string& errorName, const std::string& errorMessage, act_t act);

    void sendGetResponse(const ::asf::dbus::DBusVariant& value, act_t act);

    void sendGetError(const std::string& errorName, const std::string& errorMessage, act_t act);

    const std::string& getDBusBusName() const { return _busName; }

    const std::string& getDBusObjectPath() const { return _objectPath; }

    const std::string& getInterfaceName() const { return _interfaceName; }

    ::asf::core::ConnectionIFSharedPtr getRemoteConnection() const { return _connection; }

    ::asf::core::CommunicationStack* getCommunicationStack() { return _communicationStack; }

    ::asf::identifier_t getClientComponentId() const { return _clientComponentId; }

    // This method checks for a server side representation of the stub.
    // In case of internal tests no server side representation is available
    // and 0 will be returned.
    ::asf::core::ComponentDescription* getComponentDescription() {
        if (0 != getStub()) {
            return StubDelegateBase::getComponentDescription();
        }
        return 0;
    }

    void registerMessage(act_t act, const ::asf::core::MessageSharedPtr& msg);

    void deregisterMessage(act_t act);

    ::asf::core::MessageSharedPtr getRegisteredMessage(act_t& act,
                                                       const std::string& interfaceName,
                                                       const std::string& member);

    ::asf::dbus::org::freedesktop::DBus::Properties::PropertiesStub* getPropertiesStub();

    bool isConnected() const;

    const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& getConnectorOptions();

    DBusConnector& getConnector() {
        LOG_ASSERT(_connector);
        return *_connector;
    }

    void init();

private:
    DBusStubDelegate(const std::string& busName,
                     const std::string& objectPath,
                     const std::string& interfaceName,
                     DBusConnector* connector,
                     ::asf::core::CommunicationStack* comStack,
                     ::asf::core::Logger& logger);

    bool hasProvidedPort() const;

    DBusExportedPort& getDBusExportedPort();

    DBusConnector* getConnector(
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& options);

    ::asf::core::CommunicationStack* getCommunicationStack(::asf::dbus::DBusConnector* connector);

    ::asf::core::ConnectionIFSharedPtr getConnection(::asf::dbus::DBusConnector* connector);

    const std::string getObjectPath();

    const std::string getObjectPath(const std::string& op);

    ::asf::identifier_t initClientComponentId();

    DBusConnector* _connector;

    ::asf::core::CommunicationStack* _communicationStack;

    ::asf::core::ConnectionIFSharedPtr _connection;

    std::string _objectPath;

    std::string _interfaceName;

    std::string _busName;

    ::asf::identifier_t _clientComponentId;

    ::asf::core::Logger& _logger;

    typedef std::map< act_t, ::asf::core::MessageSharedPtr > ActToDBusMessageMap;

    ActToDBusMessageMap _actToMessageMap;

    ::asf::threading::Mutex _lock;

    friend class DBusStub;

    friend class ::DBusStubTest;

    friend class ::DBusMessageFactoryTest;

    friend class ::DBusStubRegistryTest;
};

}  // namespace dbus
}  // namespace asf

#endif  // ASF_DBUS_DBUSSTUBDELEGATE_H
