/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     DBusStub.h
 *\brief
 *
 *\author   CM-AI/PJ-G31
 *          stefan.baron3@de.bosch.com
 *
 *\par Copyright:
 *(c) 2013-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_DBUS_DBUSSTUB_H
#define ASF_DBUS_DBUSSTUB_H

#include "asf/core/Stub.h"
#include "asf/core/Types.h"

#include "com/bosch/cm/asf/lang/dbus/Connectors.h"

#include <dbus/dbus.h>

class DBusStubTest;
class DBusConnectorTest;

namespace asf {
namespace dbus {

class DBusDaemonProxy;
class DBusStubDelegate;
class DBusMessage;

class DBusStub : public ::asf::core::Stub {
public:
    DBusStub(::asf::core::Logger& logger);

    DBusStub(const std::string& portName, ::asf::core::Logger& logger);

    virtual ~DBusStub() {}

    const std::string& getDBusBusName() const;

    const std::string& getDBusObjectPath() const;

    const std::string& getDBusInterfaceName() const;

    /**
     * Get the D-Bus connector options
     *
     * @return The D-Bus connector options defined in the application manifest
     */
    const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& getDBusConnectorOptions()
        const;

protected:
    DBusStubDelegate* _stubDelegate;

private:
    ::asf::core::Logger& _logger;

    friend class ::DBusStubTest;

    friend class ::DBusConnectorTest;
};

}  // namespace dbus
}  // namespace asf

#endif  // ASF_DBUS_DBUSSTUB_H
