/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     DBusSerialRegistry.h
 *\brief
 *
 *\author   CM-AI/PJ-G31
 *          stefan.baron3@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/

#ifndef ASF_DBUS_DBUSSERIALREGISTRY_H
#define ASF_DBUS_DBUSSERIALREGISTRY_H

#include <boost/smart_ptr.hpp>
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/threading/Mutex.h"

#include <map>
#include <string>

namespace asf {
namespace dbus {

class DBusProxyDelegate;
class DBusProxyCallback;

/**
 * DBus message replies don't provide information like bus_name, object path, interface name nor
 * method name.
 * Regarding this a translation from provided reply serial number to originated method call is done
 * via this registration.
 * Alternative solution would be using pending calls.
 */
class DBusSerialRegistry {
public:
    DBusSerialRegistry();

    ~DBusSerialRegistry();

    struct DBusAsyncObject {
        ::boost::weak_ptr< DBusProxyDelegate > _dbusProxyDelegate;
        ::boost::shared_ptr< DBusProxyCallback > _dbusProxyCallback;
        ::std::string _memberName;
        DBusAsyncObject() : _dbusProxyDelegate(), _dbusProxyCallback(), _memberName() {}
        DBusAsyncObject(::boost::shared_ptr< DBusProxyDelegate > dbusProxyDelegate,
                        ::boost::shared_ptr< DBusProxyCallback > dbusProxyCallback,
                        ::std::string memberName)
            : _dbusProxyDelegate(dbusProxyDelegate),
              _dbusProxyCallback(dbusProxyCallback),
              _memberName(memberName) {}
    };

    bool registerSerial(uint32 serial, const DBusAsyncObject& cb);

    bool deregisterSerial(uint32 serial);

    bool findSerial(uint32 serial, DBusAsyncObject& cb);

private:
    typedef std::map< uint32, DBusAsyncObject > SerialToAsyncCallbackObjectMap;

    SerialToAsyncCallbackObjectMap _serialMap;

    ::asf::threading::Mutex _lock;

    DECLARE_CLASS_LOGGER();
};

}  // namespace dbus
}  // namespace asf

#endif
