/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     DBusExports.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2013-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_DBUS_DBUSEXPORTS_H
#define ASF_DBUS_DBUSEXPORTS_H

#include "asf/core/ProvidedPort.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusExportedPort.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"

#include <map>
#include <vector>

namespace asf {
namespace dbus {

class DBusExports {
public:
    DBusExports() {}

    virtual ~DBusExports() {}

    DBusExportedPort& addExport(
        ::asf::core::ProvidedPort& providedPort,
        const std::string& serviceName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& options);

    bool hasExports() const { return !_exports.empty(); }

    void getExportedObjectPaths(::std::vector< std::string >& objectList);

private:
    typedef ::asf::core::ProvidedPort* ExportKey;

    typedef std::map< ExportKey, DBusExportedPort > ExportMap;

    typedef std::pair< ExportKey, DBusExportedPort > ExportPair;

    ExportMap _exports;

    DECLARE_CLASS_LOGGER();
};

}  // namespace dbus
}  // namespace asf

#endif  // ASF_DBUS_DBUSEXPORTS_H
