/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     DBusExportedPort.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2013-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_DBUS_DBUSEXPORTEDPORT_H
#define ASF_DBUS_DBUSEXPORTEDPORT_H

#include <dbus/dbus.h>
#include <set>
#include <string>
#include "asf/core/ExportedPort.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"

namespace asf {
namespace dbus {

class DBusExportedPort : public ::asf::core::ExportedPort {
public:
    typedef std::set< std::string > ObjectPaths;

    DBusExportedPort(const std::string& serviceName,
                     const std::string& busName,
                     const std::string& objectPath,
                     const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& options);

    virtual ~DBusExportedPort();

    const std::string& getBusName() const;

    void addObjectPath(const std::string& objectPath);

    void removeObjectPath(const std::string& objectPath);

    const ObjectPaths& getObjectPaths() const;

    const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& getConnectorOptions() const;

private:
    std::string _busName;

    ObjectPaths _objectPaths;

    const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector _connectorOptions;

    DECLARE_CLASS_LOGGER();
};

}  // namespace dbus
}  // namespace asf

#endif  // ASF_DBUS_DBUSEXPORTEDPORT_H
