/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     DBusDaemonProxy.h
 *\brief
 *
 *\author   CM-AI/PJ-G31
 *          stefan.baron3@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef DBUSDAEMONPROXY_H
#define DBUSDAEMONPROXY_H

#include "asf/core/Logger.h"

#include "asf/dbus/org/freedesktop/DBus.h"

#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusUniqueIdRegistry.h"
#include "asf/dbus/DBusUtils.h"

#include <string>

class DBusProxyRegistryTest;

namespace asf {
namespace dbus {

class NameAcquiredCallbackIF {
public:
    virtual ~NameAcquiredCallbackIF() {}

    virtual void onNameAcquiredError(
        const ::boost::shared_ptr< DBusProxy >& proxy,
        const ::boost::shared_ptr< ::asf::dbus::org::freedesktop::DBus::NameAcquiredError >&
            error) = 0;

    virtual void onNameAcquiredSignal(
        const ::boost::shared_ptr< DBusProxy >& proxy,
        const ::boost::shared_ptr< ::asf::dbus::org::freedesktop::DBus::NameAcquiredSignal >&
            signal) = 0;
};

class NameHasOwnerCallbackIF {
public:
    virtual ~NameHasOwnerCallbackIF() {}

    virtual void onNameHasOwnerError(
        const ::boost::shared_ptr< DBusProxy >& proxy,
        const ::boost::shared_ptr< ::asf::dbus::org::freedesktop::DBus::NameHasOwnerError >&
            error) = 0;

    virtual void onNameHasOwnerResponse(
        const ::boost::shared_ptr< DBusProxy >& proxy,
        const ::boost::shared_ptr< ::asf::dbus::org::freedesktop::DBus::NameHasOwnerResponse >&
            response) = 0;
};

class NameOwnerChangedCallbackIF {
public:
    virtual ~NameOwnerChangedCallbackIF() {}

    virtual void onNameOwnerChangedError(
        const ::boost::shared_ptr< DBusProxy >& proxy,
        const ::boost::shared_ptr< ::asf::dbus::org::freedesktop::DBus::NameOwnerChangedError >&
            error) = 0;

    virtual void onNameOwnerChangedSignal(
        const ::boost::shared_ptr< DBusProxy >& proxy,
        const ::boost::shared_ptr< ::asf::dbus::org::freedesktop::DBus::NameOwnerChangedSignal >&
            signal) = 0;
};

class GetNameOwnerCallbackIF {
public:
    virtual ~GetNameOwnerCallbackIF() {}

    virtual void onGetNameOwnerError(
        const ::boost::shared_ptr< DBusProxy >& proxy,
        const ::boost::shared_ptr< ::asf::dbus::org::freedesktop::DBus::GetNameOwnerError >&
            error) = 0;

    virtual void onGetNameOwnerResponse(
        const ::boost::shared_ptr< DBusProxy >& proxy,
        const ::boost::shared_ptr< ::asf::dbus::org::freedesktop::DBus::GetNameOwnerResponse >&
            response) = 0;
};

class DBusDaemonProxy : public ::asf::core::Proxy,
                        public NameOwnerChangedCallbackIF,
                        public NameHasOwnerCallbackIF,
                        public GetNameOwnerCallbackIF {
public:
    static ::boost::shared_ptr< DBusDaemonProxy > createProxy(
        const std::string& objectPath,
        const std::string& interfaceName,
        const ::asf::core::ServiceAvailableIF& serviceAvailable,
        DBusProxyDelegate* parentProxy);

    DBusDaemonProxy(const std::string& objectPath,
                    const std::string& interfaceName,
                    const ::asf::core::ServiceAvailableIF& serviceAvailable,
                    DBusProxyDelegate* parentProxy);

    virtual ~DBusDaemonProxy();

    /**
     * Add the match rule in the dbus-daemon
     * @param type the message type, e.g. signal, method_call
     * @param path object path
     * @param interface
     * @param member valid message or signal name
     *
     * @return act
     */
    act_t addMatch(const std::string& type,
                   const std::string& path,
                   const std::string& interface,
                   const std::string& member);

    /**
     * Remove the match rule in the dbus-daemon
     * @param type the message type, e.g. signal, method_call
     * @param path object path
     * @param interface
     * @param member valid message or signal name
     *
     * @return act
     */
    act_t removeMatch(const std::string& type,
                      const std::string& path,
                      const std::string& interface,
                      const std::string& member);

    /**
     * Starts the sequence for getting the bus name owner
     */
    void startServiceDiscovery();

protected:
    // NameHasOwnerCallbackIF implementation
    virtual void onNameHasOwnerResponse(
        const ::boost::shared_ptr< DBusProxy >& proxy,
        const ::boost::shared_ptr< ::asf::dbus::org::freedesktop::DBus::NameHasOwnerResponse >&
            response);
    virtual void onNameHasOwnerError(
        const ::boost::shared_ptr< DBusProxy >& proxy,
        const ::boost::shared_ptr< ::asf::dbus::org::freedesktop::DBus::NameHasOwnerError >& error);

    // NameOwnerChangedCallbackIF implementation
    virtual void onNameOwnerChangedSignal(
        const ::boost::shared_ptr< DBusProxy >& proxy,
        const ::boost::shared_ptr< ::asf::dbus::org::freedesktop::DBus::NameOwnerChangedSignal >&
            signal);
    virtual void onNameOwnerChangedError(
        const ::boost::shared_ptr< DBusProxy >& proxy,
        const ::boost::shared_ptr< ::asf::dbus::org::freedesktop::DBus::NameOwnerChangedError >&
            error);

    // GetNameOwnerCallbackIF implementation
    virtual void onGetNameOwnerResponse(
        const ::boost::shared_ptr< DBusProxy >& proxy,
        const ::boost::shared_ptr< ::asf::dbus::org::freedesktop::DBus::GetNameOwnerResponse >&
            response);
    virtual void onGetNameOwnerError(
        const ::boost::shared_ptr< DBusProxy >& proxy,
        const ::boost::shared_ptr< ::asf::dbus::org::freedesktop::DBus::GetNameOwnerError >& error);

private:
    ::boost::shared_ptr< DBusProxyDelegate > _dbusProxyDelegate;

    act_t sendNameOwnerChangedRegister(NameOwnerChangedCallbackIF& cb,
                                       const ::std::string& busname);

    void sendNameOwnerChangedDeregister(act_t registerId = 0);

    act_t sendAddMatch(const ::std::string& data);

    act_t sendRemoveMatch(const ::std::string& data);

    act_t sendNameHasOwner(NameHasOwnerCallbackIF& cb, const ::std::string& name) const;

    act_t sendGetNameOwner(GetNameOwnerCallbackIF& cb, const ::std::string& name) const;

    // Used by DBusProxyTest
    boost::shared_ptr< DBusProxyDelegate > getDBusDaemonDelegate() const {
        return _dbusProxyDelegate;
    }

    DBusProxyDelegate* _parentProxy;

    DBusUniqueIdRegistry& _uniqueIdRegistry;

    std::string _uniqueId;

    DECLARE_CLASS_LOGGER();

    friend class ::DBusProxyTest;
    friend class ::DBusProxyRegistryTest;
    friend class DBusPropertiesProxyWrapper;
};

}  // namespace dbus
}  // namespace asf

#endif  // DBUSDAEMONPROXY_H
