/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/

/*!
 *\file     StartStopWaitIF.h
 *\brief
 *
 *\author   CM-PS/ETC1-PEC2HI
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2013 Robert Bosch Car Multimedia GmbH
 *
 *\par History:
 * See history of revision control system
 ***************************************************************************/
#ifndef ASF_CORE_STARTSTOPWAITIF_H
#define ASF_CORE_STARTSTOPWAITIF_H

#include <boost/shared_ptr.hpp>

namespace asf {
namespace core {

class StartStopWaitIF {
public:
    StartStopWaitIF() : _started(false) {}

    virtual ~StartStopWaitIF() {}

    virtual void start() = 0;

    virtual void stop() = 0;

    virtual void waitForCompletion() = 0;

    bool isStarted() const { return _started; }

protected:
    void setIsStarted(bool started) { _started = started; }

private:
    bool _started;
};

typedef ::boost::shared_ptr< StartStopWaitIF > StartStopWaitIFSharedPtr;

}  // namespace core
}  // namespace asf

#endif  // ASF_CORE_STARTSTOPWAITIF_H
