/*********************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2019
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *********************************************************************/

#ifndef ASF_CORE_SIGNALHANDLER_H
#define ASF_CORE_SIGNALHANDLER_H

#include <boost/shared_ptr.hpp>
#include "asf/threading/Thread.h"

namespace asf {
namespace core {

void InstallFailureSignalHandler();

class SignalHandler {
public:
    SignalHandler();
    ~SignalHandler();

    static int getEventFd() { return _eventFd; };

private:
    static int _eventFd;
    boost::shared_ptr< ::asf::threading::Thread >
        _pThread;  // change to unique_ptr if it is available (C++11 or extend boost subset)
};
}  // namespace core
}  // namespace asf

#endif
