/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2014
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     ProvidedPort.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2013-2014 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CORE_PROVIDEDPORT_H
#define ASF_CORE_PROVIDEDPORT_H

#include <string>
#include "asf/core/ComponentPort.h"
#include "asf/core/Logger.h"
#include "asf/core/ServiceMessage.h"
#include "asf/core/Types.h"

namespace asf {
namespace core {

class StubDelegateBase;

class ExportedPort;

class ComponentDescription;

class ProvidedPort;

class ConnectionIF;

class ProvidedPortListener {
public:
    virtual ~ProvidedPortListener() {}

    virtual void onServiceMessage(::asf::core::ServiceMessage& msg,
                                  ::asf::core::ProvidedPort& providedPort) = 0;

    virtual void onStubConnected() = 0;

    virtual void onStubDisconnected() = 0;

    virtual void onClientDisconnected(::asf::core::ConnectionIFSharedPtr connection) = 0;
};

class ProvidedPort : public ComponentPort {
public:
    ProvidedPort(const std::string& serviceName, const std::string& portName);

    ProvidedPort(const std::string& serviceName,
                 const std::string& portName,
                 bool runtimePort,
                 bool multiplicity);

    ProvidedPort(const std::string& serviceName,
                 const std::string& portName,
                 ::boost::shared_ptr< ProvidedPortListener > listener);

    virtual ~ProvidedPort();

    void setStubDelegateBase(StubDelegateBase* stubDelegate);

    StubDelegateBase* getStubDelegateBase() { return _stubDelegate; }

    void setComponentDescription(ComponentDescription* componentDescription) {
        _componentDescription = componentDescription;
    }

    ComponentDescription* getComponentDescription() { return _componentDescription; }

    void setExportedPort(::asf::core::ExportedPort* exportedPort);

    bool isExportedPort() const;

    bool isRuntimePort() const;

    bool isMultiplicityPort() const;

    ExportedPort* getExportedPort() { return _exportedPort; }

    ::boost::shared_ptr< ProvidedPortListener > getProvidedPortListener() const {
        return _listener;
    }

    bool hasProvidedPortListener() const { return !(_listener == 0); }

    void process(::asf::core::ServiceMessage& msg) { _listener->onServiceMessage(msg, *this); };

private:
    ComponentDescription* _componentDescription;

    StubDelegateBase* _stubDelegate;

    ExportedPort* _exportedPort;

    ::boost::shared_ptr< ProvidedPortListener > _listener;

    bool _isRuntimePort;

    bool _isMultiplicityPort;

    DECLARE_CLASS_LOGGER();
};

}  // namespace core
}  // namespace asf

#endif  // ASF_CORE_PROVIDEDPORT_H
