/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2017
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     LocalMessageToken.h
 *\brief
 *
 *\author   CM/ESA2
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2016-2017 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CORE_LOCALMESSAGETOKEN_H
#define ASF_CORE_LOCALMESSAGETOKEN_H

#include "asf/core/TokenPool.h"
#include "asf/core/Types.h"
#include "asf/threading/Mutex.h"

namespace asf {
namespace core {

class LocalMessageToken {
public:
    static act_t getAct();

    static void returnAct(act_t act);

    static void deleteInstance();

private:
    LocalMessageToken();

    virtual ~LocalMessageToken();

    static LocalMessageToken& instance();

    static LocalMessageToken* _instance;

    static ::asf::threading::Mutex _lockInstance;

    ::asf::core::TokenPool< act_t > _actTokenPool;
};

}  // namespace core
}  // namespace asf

#endif
