/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     ExportedPort.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2013-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CORE_EXPORTEDPORT_H
#define ASF_CORE_EXPORTEDPORT_H

#include <string>
#include "asf/core/ComponentPort.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"

namespace asf {
namespace core {

class ProvidedPort;

class ComponentDescription;
class StubDelegateBase;

class ExportedPort : public ComponentPort {
public:
    ExportedPort(const std::string& serviceName, const std::string& portName);

    virtual ~ExportedPort();

    void setProvidedPort(ProvidedPort* providedPort);

    ProvidedPort* getProvidedPort() { return _providedPort; };

    StubDelegateBase* getStubDelegateBase();

    ComponentDescription* getComponentDescription();

private:
    ProvidedPort* _providedPort;

    DECLARE_CLASS_LOGGER();
};

}  // namespace core
}  // namespace asf

#endif  // ASF_CORE_EXPORTEDPORT_H
