/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2016
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     CpuArchitecture.h
 *\brief    CPU architecture dependent defines
 *
 *\par Copyright:
 *(c) 2012-2016 Robert Bosch Car Multimedia GmbH
 *
 ***************************************************************************/

#ifndef ASF_CORE_CPU_ARCHITECTURE_H
#define ASF_CORE_CPU_ARCHITECTURE_H

// ASF_CPU_WIDTH represents the number of bits of the CPU word size (32 or 64)
// ASF_CPU_WIDTH can be set from the outside (e.g. via a cmake toolchain).
// If not this file will perform a best guess.
#ifndef ASF_CPU_WIDTH
#include <stdint.h>

#ifdef UINTPTR_MAX
#if UINTPTR_MAX == 0xffffffff || UINTPTR_MAX == UINT32_MAX
#define ASF_CPU_WIDTH 32
#elif UINTPTR_MAX == 0xffffffffffffffff || UINTPTR_MAX == UINT64_MAX
#define ASF_CPU_WIDTH 64
#else
#error "UINTPTR_MAX <" UINTPTR_MAX "> doesn't match"
#endif
#else
#error "UINTPTR_MAX is not defined"
#endif
#endif

// ASF_32: Symbol is defined when the target architecture is 32-bit
// ASF_64: Symbol is defined when the target architecture is 64-bit
#ifdef ASF_CPU_WIDTH
#if ASF_CPU_WIDTH == 32
#define ASF_32
#elif ASF_CPU_WIDTH == 64
#define ASF_64
#else
#error "Invalid setting <" ASF_CPU_WIDTH "> of ASF_CPU_WIDTH"
#endif
#else
#error "Symbol ASF_CPU_WIDTH not defined. Could not detect your CPU type (32 or 64 bit)."
#error "Please extend asf/core/CpuArchitecture.h or configure ASF_CPU_WIDTH in your toolchain."
#endif

#endif
