
/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     ContextData.h
 *\brief
 *
 *\author   CM-AI/PJ-CF11.1
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2013-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CORE_CONTEXTDATA_H
#define ASF_CORE_CONTEXTDATA_H

#include "asf/core/Message.h"
#include "asf/core/Types.h"
#include "asf/threading/Thread.h"

namespace asf {
namespace core {

class Application;
class ComponentDescription;
class Message;

class ContextData {
public:
    ContextData();

    ~ContextData();

    void incrementActivityIndex() { ++_activityIndex; }

    size_t getActivityIndex() const { return _activityIndex; }

    ComponentDescription* getComponentDescription() { return _componentDescription; }

    void setComponentDescription(ComponentDescription* componentDescription) {
        _componentDescription = componentDescription;
    }

    void setMessage(MessageSharedPtr message) { _message = message; }

    MessageSharedPtr getMessage() const { return _message; }

    void setAct(act_t act) { _act = act; }

    act_t getAct() const { return _act; }

    const ::asf::threading::Thread* getThread() const { return _thread; }

    void setThread(const ::asf::threading::Thread* thread) { _thread = thread; }

    static ContextData* getThreadLocal();

    static bool isAvailable() { return (0 != getThreadLocal()); }

private:
    ComponentDescription* _componentDescription;

    MessageSharedPtr _message;

    act_t _act;

    const ::asf::threading::Thread* _thread;

    size_t _activityIndex;
};

}  // namespace core
}  // namespace asf

#endif  // ASF_CORE_CONTEXTDATA_H
