/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     ComponentPort.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2013-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CORE_COMPONENTPORT_H
#define ASF_CORE_COMPONENTPORT_H

#include <string>

namespace asf {
namespace core {

class ComponentPort {
public:
    ComponentPort(const std::string& serviceName, const std::string& portName)
        : _serviceName(serviceName),
          _portName(portName),
          _serviceNameLength(_serviceName.size()),
          _portNameLength(_portName.size()) {}

    virtual ~ComponentPort() {}

    void setServiceName(const std::string& serviceName) { _serviceName = serviceName; }

    void setPortName(const std::string& portName) { _portName = portName; }

    const std::string& getServiceName() const { return _serviceName; }

    const std::string& getPortName() const { return _portName; }

    bool operator<(const ComponentPort& rhs) const {
        if ((_serviceNameLength < rhs._serviceNameLength) &&
            (_portNameLength < rhs._portNameLength)) {
            return true;
        } else if ((_serviceNameLength > rhs._serviceNameLength) &&
                   (_portNameLength > rhs._portNameLength)) {
            return false;
        }
        return ((_serviceName.compare(rhs._serviceName) < 0) &&
                (_portName.compare(rhs._portName) < 0));
    }

    bool operator==(const ComponentPort& rhs) const {
        return (_serviceNameLength == rhs._serviceNameLength &&
                _portNameLength == rhs._portNameLength &&
                _serviceName.compare(rhs._serviceName) == 0 &&
                _portName.compare(rhs._portName) == 0);
    }

private:
    std::string _serviceName;

    std::string _portName;

    std::string::size_type _serviceNameLength;

    std::string::size_type _portNameLength;
};

class ComponentPortCompare {
    bool operator()(const ComponentPort& lhs, const ComponentPort& rhs) const { return lhs < rhs; }
};

}  // namespace core
}  // namespace asf

#endif  // ASF_CORE_COMPONENTPORT_H
