/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     ComponentMessage.cpp
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CORE_COMPONENTMESSAGE_H
#define ASF_CORE_COMPONENTMESSAGE_H

#include "asf/core/Logger.h"
#include "asf/core/Message.h"
#include "asf/core/Types.h"

namespace asf {
namespace core {

class ComponentDescription;
class ComponentMessage;

const std::string noServiceId;

class ComponentMessage : public Message {
public:
    ComponentMessage() : _componentId(0), _componentDescription(0), _isLoopBack(false) {}

    virtual ~ComponentMessage() { _componentDescription = 0; }

    ::asf::identifier_t getComponentId() const { return _componentId; }

    void setComponentId(::asf::identifier_t componentId) { _componentId = componentId; }

    void setComponentDescription(ComponentDescription* componentDescription) {
        _componentDescription = componentDescription;
    }

    ComponentDescription* getComponentDescription() const { return _componentDescription; }

    virtual const ::std::string& getServiceId() const { return noServiceId; }

    virtual void process();

    virtual void processMessage() = 0;

    virtual MessageSharedPtr clone() const = 0;

    virtual bool isRemote() const = 0;

    virtual bool sendRemote() = 0;

    virtual bool isLoopBack() { return _isLoopBack; }

    void setLoopBack(bool loopBack) { _isLoopBack = loopBack; }

private:
    DECLARE_CLASS_LOGGER();

    ::asf::identifier_t _componentId;

    ComponentDescription* _componentDescription;

    bool _isLoopBack;
};

}  // namespace core
}  // namespace asf

#endif  // ASF_CORE_COMPONENTMESSAGE_H
