/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     CmsStubDelegate.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2017 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CMS_CMSSTUBDELEGATE_H
#define ASF_CMS_CMSSTUBDELEGATE_H

#include "asf/cms/CmsMessage.h"
#include "asf/cms/CmsStubProperties.h"
#include "asf/cms/CmsStubRequests.h"
#include "asf/cms/CmsTypes.h"
#include "asf/core/Stub.h"
#include "asf/core/StubDelegateBase.h"
#include "asf/core/Types.h"
#include "asf/threading/Mutex.h"

namespace asf {
namespace cms {

class CmsServiceConnector;

class CmsStubDelegate : public ::asf::core::StubDelegateBase, public CmsSystemErrorIF {
public:
    CmsStubDelegate(std::string serviceId,
                    ::asf::core::Stub* stub,
                    CmsServiceConnector* stubConnector);

    virtual ~CmsStubDelegate() { _stubConnector = 0; }

    const std::string& getServiceId() const { return _serviceId; }

    void process(CmsMessage& msg);

    virtual void disconnected(::asf::core::ConnectionIFSharedPtr remote);

    void sendNotifyAll(const std::string& functionId, const ::asf::core::PayloadSharedPtr& para);

    void sendNotify(const std::string& functionId,
                    const ::asf::core::PayloadSharedPtr& para,
                    act_t act = 0);

    void sendRegisterNotify(const std::string& functionId,
                            const ::asf::core::PayloadSharedPtr& para,
                            act_t act = 0);

    void sendRegisterConfirmation(const std::string& functionId, act_t act = 0);

    void sendResponse(const std::string& functionId,
                      const ::asf::core::PayloadSharedPtr& para,
                      act_t act = 0);

    void sendProgress(const std::string& functionId,
                      const ::asf::core::PayloadSharedPtr& para,
                      act_t act = 0);

    void sendRequestError(const std::string& functionId,
                          const ::asf::core::PayloadSharedPtr& para,
                          act_t act = 0);

    void sendRegisterError(const std::string& functionId,
                           const ::asf::core::PayloadSharedPtr& para,
                           act_t act = 0);

    void sendGetError(const std::string& functionId,
                      const ::asf::core::PayloadSharedPtr& para,
                      act_t act = 0);

    void sendSetError(const std::string& functionId,
                      const ::asf::core::PayloadSharedPtr& para,
                      act_t act = 0);

    virtual void sendSystemError(const CmsMessage& msg, CmsTypes::SystemError systemError) {
        sendSystemErrorMessageBack(msg, systemError);
    }

    static void sendMessageBack(CmsMessage& msg);

    static void sendServiceDisconnectedMessageBack(const CmsMessage& msg);

    static void sendServiceAvailableMessageBack(const CmsMessage& msg);

    static void sendSystemErrorMessageBack(const CmsMessage& msg,
                                           CmsTypes::SystemError systemError);

private:
    std::string _serviceId;

    CmsServiceConnector* _stubConnector;

    ::asf::threading::Mutex _msgMutex;

    CmsStubProperties _msgProperties;

    CmsStubRequests _msgActiveRequests;

    DECLARE_CLASS_LOGGER();
};

}  // namespace cms
}  // namespace asf

#endif  // ASF_CMS_CMSSTUBDELEGATE_H
