/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     CmsSocketServerConnector.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2013-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CMS_CMSSOCKETSERVERCONNECTOR_H
#define ASF_CMS_CMSSOCKETSERVERCONNECTOR_H

#include "asf/cms/CmsHeaderEncoderIF.h"
#include "asf/cms/CmsMessageAdapter.h"
#include "asf/connection/SocketServer.h"
#include "asf/core/Application.h"
#include "asf/core/CommunicationStack.h"
#include "asf/core/Logger.h"
#include "asf/core/StartStopWaitIF.h"
#include "asf/protocol/ProtocolFramingAbstract.h"
#include "com/bosch/cm/asf/lang/cms/Connectors.h"

#include <string>

class CmsSocketServerConnectorTest;

namespace asf {
namespace cms {

class CmsExportedPort;
class CmsImportedPort;

class CmsSocketServerConnector : public ::asf::core::StartStopWaitIF {
public:
    CmsSocketServerConnector(
        ::asf::core::Application& app,
        ::com::bosch::cm::asf::lang::cms::Connectors::CmsSocketServerConnector& options);

    ~CmsSocketServerConnector();

    virtual CmsMessageAdapter& getMessageAdapter();

    virtual void start();

    virtual void stop();

    virtual void waitForCompletion();

    CmsExportedPort& exportByName(::asf::core::ProvidedPort& providedPort,
                                  const std::string& exportName);

    CmsExportedPort* getExport(const std::string& exportName);

private:
    // This constructor is implemented just for testing purpuses. Just keep it private!
    CmsSocketServerConnector()
        : _headerEncoder(0), _messageAdapter(0), _comStack(0), _framing(0), _socketServer(0){};

    CmsSocketServerConnector(const CmsSocketServerConnector&);

    CmsSocketServerConnector& operator=(const CmsSocketServerConnector&);

    void createServerStack(
        ::asf::core::Application& app,
        ::com::bosch::cm::asf::lang::cms::Connectors::CmsSocketServerConnector& options);

    void updateOptionsFromAddress(
        ::com::bosch::cm::asf::lang::cms::Connectors::CmsSocketServerConnector& options);

    void createCmsJsonStack(
        ::asf::core::Application& app,
        ::com::bosch::cm::asf::lang::cms::Connectors::CmsSocketServerConnector& options);

    void createCmsBinStack(
        ::asf::core::Application& app,
        ::com::bosch::cm::asf::lang::cms::Connectors::CmsSocketServerConnector& options);

    CmsHeaderEncoderIF* _headerEncoder;

    CmsMessageAdapter* _messageAdapter;

    ::asf::core::StubCommunicationStack* _comStack;

    ::asf::protocol::ProtocolFramingAbstract* _framing;

    ::asf::connection::SocketServer* _socketServer;

    friend class ::CmsSocketServerConnectorTest;
    DECLARE_CLASS_LOGGER();
};

}  // namespace cms
}  // namespace asf

#endif  // ASF_CMS_CMSSOCKETSERVERCONNECTOR_H
