/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     CmsProxyRegistry.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2018 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CMS_CMSPROXYREGISTRY_H
#define ASF_CMS_CMSPROXYREGISTRY_H

#include <boost/shared_ptr.hpp>
#include <boost/weak_ptr.hpp>
#include <map>
#include "asf/cms/CmsImportedPort.h"
#include "asf/cms/CmsMessage.h"
#include "asf/cms/CmsProxyDelegate.h"
#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"
#include "asf/core/ProxyDelegateBase.h"
#include "asf/core/Types.h"
#include "asf/threading/Mutex.h"

namespace asf {
namespace cms {

class CmsMessageAdapter;

class CmsProxyRegistry {
public:
    typedef std::map< uint32, ::boost::weak_ptr< CmsProxy > > ProxyMap;

    typedef std::pair< uint32, ::boost::weak_ptr< CmsProxy > > ProxyPair;

    typedef std::map< std::string, std::string > AddressMap;

    typedef std::pair< std::string, std::string > AddressPair;

    static CmsProxyRegistry& getInstance();

    static void deleteInstance();

    virtual ~CmsProxyRegistry() {}

    ::boost::shared_ptr< ::asf::core::Proxy > getProxy(
        const std::string& portName, const ::asf::core::ServiceAvailableIF& serviceAvailable) const;

    bool registerProxy(const ::boost::shared_ptr< CmsProxy >& proxy);

    bool registerProxy(const ::boost::shared_ptr< CmsProxy >& proxy, const std::string& uriAddress);

    bool deregisterProxy(uint32 proxyId);

    void onConnected(::asf::core::ConnectionIFSharedPtr connection,
                     uint32 contextCompId,
                     bool bConnected);

    uint32 connectProxyInfo(CmsMessage& msg);

    void process(CmsMessage& msg);

private:
    bool registerProxyCommon(const ::boost::shared_ptr< CmsProxy >& proxy);

    CmsProxyRegistry() {}

    static CmsProxyRegistry* _instance;

    ProxyMap _proxies;

    ::asf::threading::Mutex _mapMutex;

    DECLARE_CLASS_LOGGER();
};

}  // namespace cms
}  // namespace asf

#endif  // ASF_CMS_CMSPROXYREGISTRY_H
