/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     CmsHeaderEncoderIF.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 **************************************************************************/
#ifndef ASF_CORE_CMSHEADERENCODERIF_H
#define ASF_CORE_CMSHEADERENCODERIF_H

#include "CmsMessage.h"

namespace asf {
namespace cms {

class CmsHeaderEncoderIF {
public:
    virtual ~CmsHeaderEncoderIF() {}

    virtual bool deserialize(CmsMessage& msg) = 0;

    virtual bool serialize(CmsMessage& msg) = 0;

    virtual bool serializeEnd(CmsMessage& /*msg*/) { return true; };
};

}  // namespace cms
}  // namespace asf

#endif  // ASF_CORE_CMSHEADERENCODERIF_H
