/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     CmsBinPrimitivesWriter.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.kulla@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CMS_CMSBINPRIMITIVESWRITER
#define ASF_CMS_CMSBINPRIMITIVESWRITER

#include "asf/stream/BlobOutputStream.h"
#include "asf/stream/FourBytePaddingOutputStream.h"
#include "asf/stream/PrimitivesWriter.h"

namespace asf {
namespace cms {

/**
 * This is a helper class which represents the output streaming configuration
 * for the cms bin format.
 */
class CmsBinPrimitivesWriter {
public:
    CmsBinPrimitivesWriter(::asf::core::Blob& blob)
        : _writer(_fourBytePaddingOutputStream),
          _blobOutputStream(blob),
          _fourBytePaddingOutputStream(_blobOutputStream) {}

    ::asf::stream::PrimitivesWriter& getWriter() { return _writer; }

    ::asf::stream::PrimitivesWriter _writer;

private:
    ::asf::stream::BlobOutputStream _blobOutputStream;

    ::asf::stream::FourBytePaddingOutputStream _fourBytePaddingOutputStream;
};
}  // namespace cms
}  // namespace asf

#endif
