/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     CcaStubDelegate.h
 *\brief
 *
 *\author   CM-AI/PJ-CF12.2
 *          denys.barankevych@de.bosch.com
 *
 *\par Copyright:
 *(c) 2013-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CCA_CCASTUBDELEGATE_H
#define ASF_CCA_CCASTUBDELEGATE_H

#include "asf/core/Stub.h"
#include "asf/core/StubDelegateBase.h"
#include "asf/core/Types.h"

namespace asf {
namespace cca {

class CcaMessage;

class CcaStubDelegate : public ::asf::core::StubDelegateBase {
public:
    CcaStubDelegate(std::string serviceId, ::asf::core::Stub* stub, bool verifyPort = true);

    virtual ~CcaStubDelegate() {}

    const std::string& getServiceId() const { return _serviceId; }

    void process(CcaMessage& msg);

private:
    std::string _serviceId;

    DECLARE_CLASS_LOGGER();
};

}  // namespace cca
}  // namespace asf

#endif  // ASF_CCA_CCASTUBDELEGATE_H
