/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2012
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     CCaMessageFactory.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.kulla@de.bosch.com
 *
 *\par Copyright:
 *(c) 2012-2012 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/

#ifndef ASF_CCA_CCAMESSAGEFACTORY_H
#define ASF_CCA_CCAMESSAGEFACTORY_H

#include "asf/core/Blob.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/ServiceMessage.h"
#include "asf/core/Types.h"

namespace asf {
namespace cca {

namespace CcaTypes {
class ServiceData;
}

class CcaProxyRegistry;

/**
 * The CcaMessagFactory creates CcaMessage objects out of the data
 * typically received by a OSAL Queue.
 */
class CcaMessageFactory : public ::asf::core::ComponentMessageAdapter {
public:
    CcaMessageFactory();

    virtual ::asf::core::ServiceMessage* createServiceMessage(
        const ::boost::shared_ptr< ::asf::core::Blob >& blobMessage,
        ::asf::core::CommunicationStack* comStack,
        ::asf::core::ConnectionIFSharedPtr connection);

    virtual ::asf::core::ConnectionMessage* createConnectionMessage(
        ::asf::core::ConnectionIFSharedPtr, bool, bool);

    bool isProxyAnswer(const ::asf::cca::CcaTypes::ServiceData& sd) const;

private:
    CcaProxyRegistry& _proxyRegistry;

    DECLARE_CLASS_LOGGER();
};
}  // namespace cca
}  // namespace asf

#endif
