/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     CcaImportedPort.h
 *\brief
 *
 *\author   CM-AI/PJ-CF12.2
 *          denys.barankevych@de.bosch.com
 *
 *\par Copyright:
 *(c) 2013-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/
#ifndef ASF_CCA_CCAIMPORTEDPORT_H
#define ASF_CCA_CCAIMPORTEDPORT_H

#include <string>
#include "asf/core/ImportedPort.h"
#include "asf/core/Types.h"

namespace asf {
namespace cca {

class CcaImportedPort : public ::asf::core::ImportedPort {
public:
    CcaImportedPort(uint16 appId, uint16 majorVersion, uint16 minorVersion, uint32 flags)
        : ImportedPort("", ""),
          _appId(appId),
          _majorVersion(majorVersion),
          _minorVersion(minorVersion),
          _flags(flags) {}

    virtual ~CcaImportedPort() {}

    uint16 getAppId() const { return _appId; }

    uint16 getMajorVersion() const { return _majorVersion; }

    uint16 getMinorVersion() const { return _minorVersion; }

    uint32 getFlags() const { return _flags; }

private:
    uint16 _appId;
    uint16 _majorVersion;
    uint16 _minorVersion;
    uint32 _flags;
};

}  // namespace cca
}  // namespace asf

#endif  // ASF_CCA_CCAIMPORTEDPORT_H
