/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     CcaConnector.h
 *\brief
 *
 *\author   CM-AI/PJ-CF15
 *          christoph.perick@de.bosch.com
 *
 *\par Copyright:
 *(c) 2013-2013 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/

#ifndef ASF_CCA_CCACONNECTOR_H
#define ASF_CCA_CCACONNECTOR_H

#include "asf/cca/CcaImportedPort.h"
#include "asf/cca/CcaMessageFactory.h"
#include "asf/cca/CcaQueueTransport.h"
#include "asf/core/Application.h"
#include "asf/core/CommunicationStack.h"
#include "asf/core/Logger.h"
#include "asf/core/StartStopWaitIF.h"

#include <list>
#include "com/bosch/cm/asf/lang/cca/Connectors.h"

namespace asf {
namespace cca {

class CcaImportedPort;

class CcaConnector : public ::asf::core::StartStopWaitIF {
public:
    CcaConnector(::asf::core::Application& app,
                 const ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector& options);

    virtual ~CcaConnector();

    ::asf::cca::CcaMessageFactory& getAdapter();

    virtual void start();

    virtual void stop();

    virtual void waitForCompletion();

    CcaImportedPort& importByName(uint16 appId,
                                  uint16 majorVersion,
                                  uint16 minorVersion,
                                  uint32 flags);

    uint16 getMaxMessages() const;

private:
    CcaConnector(const CcaConnector&);
    CcaConnector& operator=(const CcaConnector&);

    ::asf::cca::CcaMessageFactory* _adapter;
    ::asf::core::ProxyCommunicationStack* _comStack;
    ::asf::cca::CcaQueueTransport* _ccaClient;
    std::list< CcaImportedPort > _imports;

    DECLARE_CLASS_LOGGER();
};

}  // namespace cca
}  // namespace asf

#endif  // ASF_DBUS_DBUSCONNECTOR_H
