#ifndef VIDEOMANAGER_MAINFILANGUAGE_HEADER
#define VIDEOMANAGER_MAINFILANGUAGE_HEADER

class videomanager_mainfi_tclInContext;
class videomanager_mainfi_tclOutContext;
class videomanager_mainfi_tclVisitorBase;

class MY_DECL videomanager_mainfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  videomanager_mainfi_tclDescription(fi_tclInContext* poIn, videomanager_mainfi_tclVisitorBase* poVisit);
  videomanager_mainfi_tclDescription(fi_tclOutContext* poOut, videomanager_mainfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(videomanager_mainfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(videomanager_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ videomanager_mainfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  videomanager_mainfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<videomanager_mainfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<videomanager_mainfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline videomanager_mainfi_tclDescription::videomanager_mainfi_tclDescription(fi_tclInContext* poIn, videomanager_mainfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline videomanager_mainfi_tclDescription::videomanager_mainfi_tclDescription(fi_tclOutContext* poOut, videomanager_mainfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

