#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define VIDEOMANAGER_FI_S_IMPORT_INTERFACE_VIDEOMANAGER_MAINFI_STDVISITORS
#include "videomanager_fi_if.h"

tBool videomanager_mainfi_tclDescription::bInitMessage(videomanager_mainfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case videomanager_mainfi_tclToken::EN_LAST_TOKEN:
   case videomanager_mainfi_tclToken::EN_LIST:
   case videomanager_mainfi_tclToken::EN_END_OF_STRUCT:
   case videomanager_mainfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case videomanager_mainfi_tclToken::EN_MSG_REQUESTVIDEOSOURCESTATEMETHODSTART:
   {
      bResult = oPath.bGoDown(videomanager_mainfi_tclKnot(videomanager_mainfi_tclToken::EN_E8_VDMREQUESTEDSOURCESTATE,videomanager_mainfi_tclSemanticDomain::EN_MSG_TREQUESTEDSTATE)) && bResult;
      bResult = oPath.bGoDown(videomanager_mainfi_tclKnot(videomanager_mainfi_tclToken::EN_E8_VDMVIDEOSOURCE,videomanager_mainfi_tclSemanticDomain::EN_MSG_TVIDEOSOURCE)) && bResult;
   } break;
   case videomanager_mainfi_tclToken::EN_MSG_REQUESTVIDEOSOURCESTATEMETHODRESULT:
   {
      bResult = oPath.bGoDown(videomanager_mainfi_tclKnot(videomanager_mainfi_tclToken::EN_BOOL,videomanager_mainfi_tclSemanticDomain::EN_MSG_BSOURCECHANGEGRANTED)) && bResult;
   } break;
   case videomanager_mainfi_tclToken::EN_MSG_REQUESTACCESSTODESERIALIZERMETHODSTART:
   {
      bResult = oPath.bGoDown(videomanager_mainfi_tclKnot(videomanager_mainfi_tclToken::EN_E8_VDMVIDEOSOURCE,videomanager_mainfi_tclSemanticDomain::EN_MSG_TVIDEOSOURCE)) && bResult;
   } break;
   case videomanager_mainfi_tclToken::EN_MSG_REQUESTACCESSTODESERIALIZERMETHODRESULT:
   {
      bResult = oPath.bGoDown(videomanager_mainfi_tclKnot(videomanager_mainfi_tclToken::EN_BOOL,videomanager_mainfi_tclSemanticDomain::EN_MSG_BACCESSISGRANTED)) && bResult;
   } break;
   case videomanager_mainfi_tclToken::EN_MSG_ACKNOWLEDGESTATEMETHODSTART:
   {
      bResult = oPath.bGoDown(videomanager_mainfi_tclKnot(videomanager_mainfi_tclToken::EN_E8_VDMSOURCESTATE,videomanager_mainfi_tclSemanticDomain::EN_MSG_TVIDEOSTATE)) && bResult;
      bResult = oPath.bGoDown(videomanager_mainfi_tclKnot(videomanager_mainfi_tclToken::EN_E8_VDMVIDEOSOURCE,videomanager_mainfi_tclSemanticDomain::EN_MSG_TVIDEOSOURCE)) && bResult;
   } break;
   case videomanager_mainfi_tclToken::EN_MSG_RVCASTATUS:
   {
      bResult = oPath.bGoDown(videomanager_mainfi_tclKnot(videomanager_mainfi_tclToken::EN_E8_VDMSOURCESTATE,videomanager_mainfi_tclSemanticDomain::EN_MSG_RVCA_STATEINFO)) && bResult;
   } break;
   case videomanager_mainfi_tclToken::EN_MSG_RVCDSTATUS:
   {
      bResult = oPath.bGoDown(videomanager_mainfi_tclKnot(videomanager_mainfi_tclToken::EN_E8_VDMSOURCESTATE,videomanager_mainfi_tclSemanticDomain::EN_MSG_RVCD_STATEINFO)) && bResult;
   } break;
   case videomanager_mainfi_tclToken::EN_MSG_DTVSTATUS:
   {
      bResult = oPath.bGoDown(videomanager_mainfi_tclKnot(videomanager_mainfi_tclToken::EN_E8_VDMSOURCESTATE,videomanager_mainfi_tclSemanticDomain::EN_MSG_DTV_STATEINFO)) && bResult;
   } break;
   case videomanager_mainfi_tclToken::EN_MSG_SPCXSTATUS:
   {
      bResult = oPath.bGoDown(videomanager_mainfi_tclKnot(videomanager_mainfi_tclToken::EN_E8_VDMSOURCESTATE,videomanager_mainfi_tclSemanticDomain::EN_MSG_SPCX_STATEINFO)) && bResult;
   } break;
   case videomanager_mainfi_tclToken::EN_MSG_DVDSTATUS:
   {
      bResult = oPath.bGoDown(videomanager_mainfi_tclKnot(videomanager_mainfi_tclToken::EN_E8_VDMSOURCESTATE,videomanager_mainfi_tclSemanticDomain::EN_MSG_DVD_STATEINFO)) && bResult;
   } break;
   case videomanager_mainfi_tclToken::EN_MSG_USBSTATUS:
   {
      bResult = oPath.bGoDown(videomanager_mainfi_tclKnot(videomanager_mainfi_tclToken::EN_E8_VDMSOURCESTATE,videomanager_mainfi_tclSemanticDomain::EN_MSG_USB_STATEINFO)) && bResult;
   } break;
   case videomanager_mainfi_tclToken::EN_MSG_DESERIALIZERUSEDBYSTATUS:
   {
      bResult = oPath.bGoDown(videomanager_mainfi_tclKnot(videomanager_mainfi_tclToken::EN_E8_VDMVIDEOSOURCE,videomanager_mainfi_tclSemanticDomain::EN_MSG_DESERIALIZER_SOURCEINFO)) && bResult;
   } break;
   case videomanager_mainfi_tclToken::EN_MSG_REQUESTVIDEOSOURCESTATEMETHODABORT:
   case videomanager_mainfi_tclToken::EN_MSG_REQUESTACCESSTODESERIALIZERMETHODABORT:
   case videomanager_mainfi_tclToken::EN_MSG_ACKNOWLEDGESTATEMETHODRESULT:
   case videomanager_mainfi_tclToken::EN_MSG_ACKNOWLEDGESTATEMETHODABORT:
   case videomanager_mainfi_tclToken::EN_MSG_RVCAUPREG:
   case videomanager_mainfi_tclToken::EN_MSG_RVCARELUPREG:
   case videomanager_mainfi_tclToken::EN_MSG_RVCAGET:
   case videomanager_mainfi_tclToken::EN_MSG_RVCASET:
   case videomanager_mainfi_tclToken::EN_MSG_RVCDUPREG:
   case videomanager_mainfi_tclToken::EN_MSG_RVCDRELUPREG:
   case videomanager_mainfi_tclToken::EN_MSG_RVCDGET:
   case videomanager_mainfi_tclToken::EN_MSG_RVCDSET:
   case videomanager_mainfi_tclToken::EN_MSG_DTVUPREG:
   case videomanager_mainfi_tclToken::EN_MSG_DTVRELUPREG:
   case videomanager_mainfi_tclToken::EN_MSG_DTVGET:
   case videomanager_mainfi_tclToken::EN_MSG_DTVSET:
   case videomanager_mainfi_tclToken::EN_MSG_SPCXUPREG:
   case videomanager_mainfi_tclToken::EN_MSG_SPCXRELUPREG:
   case videomanager_mainfi_tclToken::EN_MSG_SPCXGET:
   case videomanager_mainfi_tclToken::EN_MSG_SPCXSET:
   case videomanager_mainfi_tclToken::EN_MSG_DVDUPREG:
   case videomanager_mainfi_tclToken::EN_MSG_DVDRELUPREG:
   case videomanager_mainfi_tclToken::EN_MSG_DVDGET:
   case videomanager_mainfi_tclToken::EN_MSG_DVDSET:
   case videomanager_mainfi_tclToken::EN_MSG_USBUPREG:
   case videomanager_mainfi_tclToken::EN_MSG_USBRELUPREG:
   case videomanager_mainfi_tclToken::EN_MSG_USBGET:
   case videomanager_mainfi_tclToken::EN_MSG_USBSET:
   case videomanager_mainfi_tclToken::EN_MSG_DESERIALIZERUSEDBYUPREG:
   case videomanager_mainfi_tclToken::EN_MSG_DESERIALIZERUSEDBYRELUPREG:
   case videomanager_mainfi_tclToken::EN_MSG_DESERIALIZERUSEDBYGET:
   case videomanager_mainfi_tclToken::EN_MSG_DESERIALIZERUSEDBYSET:
   case videomanager_mainfi_tclToken::EN_BINCONTAINER:
   case videomanager_mainfi_tclToken::EN_E8_VDMSOURCESTATE:
   case videomanager_mainfi_tclToken::EN_E8_VDMREQUESTEDSOURCESTATE:
   case videomanager_mainfi_tclToken::EN_E8_VDMVIDEOSOURCE:
   case videomanager_mainfi_tclToken::EN_U8:   
   case videomanager_mainfi_tclToken::EN_S8:   
   case videomanager_mainfi_tclToken::EN_U16:   
   case videomanager_mainfi_tclToken::EN_S16:   
   case videomanager_mainfi_tclToken::EN_U24:   
   case videomanager_mainfi_tclToken::EN_S24:   
   case videomanager_mainfi_tclToken::EN_U32:   
   case videomanager_mainfi_tclToken::EN_S32:   
   case videomanager_mainfi_tclToken::EN_U64:   
   case videomanager_mainfi_tclToken::EN_S64:   
   case videomanager_mainfi_tclToken::EN_F32:   
   case videomanager_mainfi_tclToken::EN_F64:   
   case videomanager_mainfi_tclToken::EN_BOOL:   
   case videomanager_mainfi_tclToken::EN_STRING:   
   case videomanager_mainfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(videomanager_mainfi_tclKnot(enMsgToken,videomanager_mainfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool videomanager_mainfi_tclDescription::bDoIt(videomanager_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool videomanager_mainfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      videomanager_mainfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      videomanager_mainfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      videomanager_mainfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == videomanager_mainfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(videomanager_mainfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(videomanager_mainfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(videomanager_mainfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case videomanager_mainfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == videomanager_mainfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case videomanager_mainfi_tclToken::EN_LIST: 
      {
         videomanager_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            videomanager_mainfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(videomanager_mainfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            videomanager_mainfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(videomanager_mainfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case videomanager_mainfi_tclToken::EN_U8: 
      {
         videomanager_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case videomanager_mainfi_tclToken::EN_U16: 
      {
         videomanager_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case videomanager_mainfi_tclToken::EN_U24: 
      {
         videomanager_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case videomanager_mainfi_tclToken::EN_U32: 
      {
         videomanager_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case videomanager_mainfi_tclToken::EN_U64: 
      {
         videomanager_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case videomanager_mainfi_tclToken::EN_S8: 
      {
         videomanager_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case videomanager_mainfi_tclToken::EN_S16: 
      {
         videomanager_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case videomanager_mainfi_tclToken::EN_S24: 
      {
         videomanager_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case videomanager_mainfi_tclToken::EN_S32: 
      {
         videomanager_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case videomanager_mainfi_tclToken::EN_S64: 
      {
         videomanager_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case videomanager_mainfi_tclToken::EN_F32: 
      {
         videomanager_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case videomanager_mainfi_tclToken::EN_F64: 
      {
         videomanager_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case videomanager_mainfi_tclToken::EN_BOOL: 
      {
         videomanager_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case videomanager_mainfi_tclToken::EN_STRING: 
      {
         videomanager_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case videomanager_mainfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         videomanager_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case videomanager_mainfi_tclToken::EN_MSG_REQUESTVIDEOSOURCESTATEMETHODSTART:
      case videomanager_mainfi_tclToken::EN_MSG_REQUESTVIDEOSOURCESTATEMETHODRESULT:
      case videomanager_mainfi_tclToken::EN_MSG_REQUESTVIDEOSOURCESTATEMETHODABORT:
      case videomanager_mainfi_tclToken::EN_MSG_REQUESTACCESSTODESERIALIZERMETHODSTART:
      case videomanager_mainfi_tclToken::EN_MSG_REQUESTACCESSTODESERIALIZERMETHODRESULT:
      case videomanager_mainfi_tclToken::EN_MSG_REQUESTACCESSTODESERIALIZERMETHODABORT:
      case videomanager_mainfi_tclToken::EN_MSG_ACKNOWLEDGESTATEMETHODSTART:
      case videomanager_mainfi_tclToken::EN_MSG_ACKNOWLEDGESTATEMETHODRESULT:
      case videomanager_mainfi_tclToken::EN_MSG_ACKNOWLEDGESTATEMETHODABORT:
      case videomanager_mainfi_tclToken::EN_MSG_RVCAUPREG:
      case videomanager_mainfi_tclToken::EN_MSG_RVCARELUPREG:
      case videomanager_mainfi_tclToken::EN_MSG_RVCAGET:
      case videomanager_mainfi_tclToken::EN_MSG_RVCASET:
      case videomanager_mainfi_tclToken::EN_MSG_RVCASTATUS:
      case videomanager_mainfi_tclToken::EN_MSG_RVCDUPREG:
      case videomanager_mainfi_tclToken::EN_MSG_RVCDRELUPREG:
      case videomanager_mainfi_tclToken::EN_MSG_RVCDGET:
      case videomanager_mainfi_tclToken::EN_MSG_RVCDSET:
      case videomanager_mainfi_tclToken::EN_MSG_RVCDSTATUS:
      case videomanager_mainfi_tclToken::EN_MSG_DTVUPREG:
      case videomanager_mainfi_tclToken::EN_MSG_DTVRELUPREG:
      case videomanager_mainfi_tclToken::EN_MSG_DTVGET:
      case videomanager_mainfi_tclToken::EN_MSG_DTVSET:
      case videomanager_mainfi_tclToken::EN_MSG_DTVSTATUS:
      case videomanager_mainfi_tclToken::EN_MSG_SPCXUPREG:
      case videomanager_mainfi_tclToken::EN_MSG_SPCXRELUPREG:
      case videomanager_mainfi_tclToken::EN_MSG_SPCXGET:
      case videomanager_mainfi_tclToken::EN_MSG_SPCXSET:
      case videomanager_mainfi_tclToken::EN_MSG_SPCXSTATUS:
      case videomanager_mainfi_tclToken::EN_MSG_DVDUPREG:
      case videomanager_mainfi_tclToken::EN_MSG_DVDRELUPREG:
      case videomanager_mainfi_tclToken::EN_MSG_DVDGET:
      case videomanager_mainfi_tclToken::EN_MSG_DVDSET:
      case videomanager_mainfi_tclToken::EN_MSG_DVDSTATUS:
      case videomanager_mainfi_tclToken::EN_MSG_USBUPREG:
      case videomanager_mainfi_tclToken::EN_MSG_USBRELUPREG:
      case videomanager_mainfi_tclToken::EN_MSG_USBGET:
      case videomanager_mainfi_tclToken::EN_MSG_USBSET:
      case videomanager_mainfi_tclToken::EN_MSG_USBSTATUS:
      case videomanager_mainfi_tclToken::EN_MSG_DESERIALIZERUSEDBYUPREG:
      case videomanager_mainfi_tclToken::EN_MSG_DESERIALIZERUSEDBYRELUPREG:
      case videomanager_mainfi_tclToken::EN_MSG_DESERIALIZERUSEDBYGET:
      case videomanager_mainfi_tclToken::EN_MSG_DESERIALIZERUSEDBYSET:
      case videomanager_mainfi_tclToken::EN_MSG_DESERIALIZERUSEDBYSTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case videomanager_mainfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(videomanager_mainfi_tclKnot(videomanager_mainfi_tclToken::EN_END_OF_STRUCT,videomanager_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(videomanager_mainfi_tclKnot(videomanager_mainfi_tclToken::EN_U8,videomanager_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(videomanager_mainfi_tclKnot(videomanager_mainfi_tclToken::EN_LIST,videomanager_mainfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         videomanager_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case videomanager_mainfi_tclToken::EN_E8_VDMSOURCESTATE:
      {
         videomanager_fi_tcl_e8_vdmSourceState o_e8_vdmSourceState;
         if (!bDoIt(o_e8_vdmSourceState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case videomanager_mainfi_tclToken::EN_E8_VDMREQUESTEDSOURCESTATE:
      {
         videomanager_fi_tcl_e8_vdmRequestedSourceState o_e8_vdmRequestedSourceState;
         if (!bDoIt(o_e8_vdmRequestedSourceState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case videomanager_mainfi_tclToken::EN_E8_VDMVIDEOSOURCE:
      {
         videomanager_fi_tcl_e8_vdmVideoSource o_e8_vdmVideoSource;
         if (!bDoIt(o_e8_vdmVideoSource))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case videomanager_mainfi_tclToken::EN_UNKNOWN:
      case videomanager_mainfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

