/*****************************************************************************
* FILE:         UnitMapping.h
* PROJECT:      RN A-IVI
* SW-COMPONENT: vd_VehicleData
*----------------------------------------------------------------------------
*
* DESCRIPTION: Generated from genLang.py using LanguageMapping.xml as the input
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
*****************************************************************************/
#ifndef _UNITMAPPING_H_
#define _UNITMAPPING_H_

#define UNITMAPPING_H_VERSION 1

//! Macro Defines for all the Regions
#define USA  0
#define CAN  1
#define MEX  2
#define UK  3
#define TKY  4
#define RUS  5
#define OTHER_EUR  6
#define PRC  7
#define TWN  8
#define HKG  9
#define GCC  10
#define EGP  11
#define ASNZ  12
#define BRA  13
#define AGT  14
#define OTHER_LAC  15
#define SAF  16
#define THI  17
#define SGP  18
#define MLY  19
#define BRN  20
#define INN  21
#define VNM  22
#define PHL  23
#define IND  24
#define JPN  25
#define KOR  26
#define OTHER_GOM  27
#define ISR  28


//! Macro Defines for all the Units
#define MILES  1
#define KM  2

#define KM_PER_L  1
#define L_PER_100KM  2
#define US_MPG  3
#define UK_MPG  4

#define DEG_F  1
#define DEG_C  2


typedef struct 
{
   const tU8 u8Region;
   const tU8 u8DefaultFuelUnit;
   const tU8* const pu8FuelList;
   const tU8 u8SizeOfList;
}sMapRegionFuelUnit;

typedef struct 
{
   const tU8 u8Region;
   const tU8 u8DefaultTempUnit;
   const tU8* const pu8TempList;
   const tU8 u8SizeOfList;
}sMapRegionTempUnit;

typedef struct 
{
   const tU8 u8Region;
   const tU8 u8DefaultDistUnit;
   const tU8* const pu8DistList;
   const tU8 u8SizeOfList;
}sMapRegionDistUnit;

//! Region wise Supported Distance Units

const tU8 u8DistUnitListForRegionUSA[] = { 
        MILES, 
        KM
    };

const tU8 u8DistUnitListForRegionCAN[] = { 
        MILES, 
        KM
    };

const tU8 u8DistUnitListForRegionMEX[] = { 
        MILES, 
        KM
    };

const tU8 u8DistUnitListForRegionUK[] = { 
        MILES, 
        KM
    };

const tU8 u8DistUnitListForRegionTKY[] = { 
        MILES, 
        KM
    };

const tU8 u8DistUnitListForRegionRUS[] = { 
        MILES, 
        KM
    };

const tU8 u8DistUnitListForRegionOTHER_EUR[] = { 
        MILES, 
        KM
    };

const tU8 u8DistUnitListForRegionPRC[] = { 
        KM
    };

const tU8 u8DistUnitListForRegionTWN[] = { 
        KM
    };

const tU8 u8DistUnitListForRegionHKG[] = { 
        KM
    };

const tU8 u8DistUnitListForRegionGCC[] = { 
        KM
    };

const tU8 u8DistUnitListForRegionEGP[] = { 
        KM
    };

const tU8 u8DistUnitListForRegionASNZ[] = { 
        KM
    };

const tU8 u8DistUnitListForRegionBRA[] = { 
        KM
    };

const tU8 u8DistUnitListForRegionAGT[] = { 
        KM
    };

const tU8 u8DistUnitListForRegionOTHER_LAC[] = { 
        KM
    };

const tU8 u8DistUnitListForRegionSAF[] = { 
        KM
    };

const tU8 u8DistUnitListForRegionTHI[] = { 
        KM
    };

const tU8 u8DistUnitListForRegionSGP[] = { 
        KM
    };

const tU8 u8DistUnitListForRegionMLY[] = { 
        KM
    };

const tU8 u8DistUnitListForRegionBRN[] = { 
        KM
    };

const tU8 u8DistUnitListForRegionINN[] = { 
        KM
    };

const tU8 u8DistUnitListForRegionVNM[] = { 
        KM
    };

const tU8 u8DistUnitListForRegionPHL[] = { 
        KM
    };

const tU8 u8DistUnitListForRegionIND[] = { 
        KM
    };

const tU8 u8DistUnitListForRegionJPN[] = { 
        KM
    };

const tU8 u8DistUnitListForRegionKOR[] = { 
        KM
    };

const tU8 u8DistUnitListForRegionOTHER_GOM[] = { 
        KM
    };

const tU8 u8DistUnitListForRegionISR[] = { 

    };


//! Region wise Supported Fuel Consumption Units

const tU8 u8FuelUnitListForRegionUSA[] = { 
        US_MPG, 
        L_PER_100KM
    };

const tU8 u8FuelUnitListForRegionCAN[] = { 
        US_MPG, 
        L_PER_100KM
    };

const tU8 u8FuelUnitListForRegionMEX[] = { 
        US_MPG, 
        L_PER_100KM, 
        KM_PER_L
    };

const tU8 u8FuelUnitListForRegionUK[] = { 
        UK_MPG, 
        L_PER_100KM
    };

const tU8 u8FuelUnitListForRegionTKY[] = { 
        L_PER_100KM, 
        KM_PER_L
    };

const tU8 u8FuelUnitListForRegionRUS[] = { 
        UK_MPG, 
        L_PER_100KM, 
        KM_PER_L
    };

const tU8 u8FuelUnitListForRegionOTHER_EUR[] = { 
        UK_MPG, 
        L_PER_100KM
    };

const tU8 u8FuelUnitListForRegionPRC[] = { 
        L_PER_100KM, 
        KM_PER_L
    };

const tU8 u8FuelUnitListForRegionTWN[] = { 
        L_PER_100KM, 
        KM_PER_L
    };

const tU8 u8FuelUnitListForRegionHKG[] = { 
        L_PER_100KM, 
        KM_PER_L
    };

const tU8 u8FuelUnitListForRegionGCC[] = { 
        L_PER_100KM, 
        KM_PER_L
    };

const tU8 u8FuelUnitListForRegionEGP[] = { 
        L_PER_100KM, 
        KM_PER_L
    };

const tU8 u8FuelUnitListForRegionASNZ[] = { 
        L_PER_100KM, 
        KM_PER_L
    };

const tU8 u8FuelUnitListForRegionBRA[] = { 
        L_PER_100KM, 
        KM_PER_L
    };

const tU8 u8FuelUnitListForRegionAGT[] = { 
        L_PER_100KM, 
        KM_PER_L
    };

const tU8 u8FuelUnitListForRegionOTHER_LAC[] = { 
        L_PER_100KM, 
        KM_PER_L
    };

const tU8 u8FuelUnitListForRegionSAF[] = { 
        L_PER_100KM, 
        KM_PER_L
    };

const tU8 u8FuelUnitListForRegionTHI[] = { 
        L_PER_100KM, 
        KM_PER_L
    };

const tU8 u8FuelUnitListForRegionSGP[] = { 
        L_PER_100KM, 
        KM_PER_L
    };

const tU8 u8FuelUnitListForRegionMLY[] = { 
        L_PER_100KM, 
        KM_PER_L
    };

const tU8 u8FuelUnitListForRegionBRN[] = { 
        L_PER_100KM, 
        KM_PER_L
    };

const tU8 u8FuelUnitListForRegionINN[] = { 
        L_PER_100KM, 
        KM_PER_L
    };

const tU8 u8FuelUnitListForRegionVNM[] = { 
        L_PER_100KM, 
        KM_PER_L
    };

const tU8 u8FuelUnitListForRegionPHL[] = { 
        L_PER_100KM, 
        KM_PER_L
    };

const tU8 u8FuelUnitListForRegionIND[] = { 
        L_PER_100KM, 
        KM_PER_L
    };

const tU8 u8FuelUnitListForRegionJPN[] = { 
        L_PER_100KM, 
        KM_PER_L
    };

const tU8 u8FuelUnitListForRegionKOR[] = { 
        L_PER_100KM, 
        KM_PER_L
    };

const tU8 u8FuelUnitListForRegionOTHER_GOM[] = { 
        L_PER_100KM, 
        KM_PER_L
    };

const tU8 u8FuelUnitListForRegionISR[] = { 

    };


//! Region wise Supported Temperature Units

const tU8 u8TempUnitListForRegionUSA[] = { 
        DEG_F, 
        DEG_C
    };

const tU8 u8TempUnitListForRegionCAN[] = { 
        DEG_F, 
        DEG_C
    };

const tU8 u8TempUnitListForRegionMEX[] = { 
        DEG_F, 
        DEG_C
    };

const tU8 u8TempUnitListForRegionUK[] = { 
        DEG_F, 
        DEG_C
    };

const tU8 u8TempUnitListForRegionTKY[] = { 
        DEG_C
    };

const tU8 u8TempUnitListForRegionRUS[] = { 
        DEG_C
    };

const tU8 u8TempUnitListForRegionOTHER_EUR[] = { 
        DEG_F, 
        DEG_C
    };

const tU8 u8TempUnitListForRegionPRC[] = { 
        DEG_C
    };

const tU8 u8TempUnitListForRegionTWN[] = { 
        DEG_C
    };

const tU8 u8TempUnitListForRegionHKG[] = { 
        DEG_C
    };

const tU8 u8TempUnitListForRegionGCC[] = { 
        DEG_C
    };

const tU8 u8TempUnitListForRegionEGP[] = { 
        DEG_C
    };

const tU8 u8TempUnitListForRegionASNZ[] = { 
        DEG_C
    };

const tU8 u8TempUnitListForRegionBRA[] = { 
        DEG_C
    };

const tU8 u8TempUnitListForRegionAGT[] = { 
        DEG_C
    };

const tU8 u8TempUnitListForRegionOTHER_LAC[] = { 
        DEG_C
    };

const tU8 u8TempUnitListForRegionSAF[] = { 
        DEG_C
    };

const tU8 u8TempUnitListForRegionTHI[] = { 
        DEG_C
    };

const tU8 u8TempUnitListForRegionSGP[] = { 
        DEG_C
    };

const tU8 u8TempUnitListForRegionMLY[] = { 
        DEG_C
    };

const tU8 u8TempUnitListForRegionBRN[] = { 
        DEG_C
    };

const tU8 u8TempUnitListForRegionINN[] = { 
        DEG_C
    };

const tU8 u8TempUnitListForRegionVNM[] = { 
        DEG_C
    };

const tU8 u8TempUnitListForRegionPHL[] = { 
        DEG_C
    };

const tU8 u8TempUnitListForRegionIND[] = { 
        DEG_C
    };

const tU8 u8TempUnitListForRegionJPN[] = { 
        DEG_C
    };

const tU8 u8TempUnitListForRegionKOR[] = { 
        DEG_C
    };

const tU8 u8TempUnitListForRegionOTHER_GOM[] = { 
        DEG_C
    };

const tU8 u8TempUnitListForRegionISR[] = { 

    };


//! Region wise mapping of Distance Units

const sMapRegionDistUnit mapRegionAndDist[] = {
    // Region    //DefaultUnit  // Pointer To Unit Table     // Size Of Array
    { USA,      MILES,      u8DistUnitListForRegionUSA,      2 }, 
    { CAN,      KM,      u8DistUnitListForRegionCAN,      2 }, 
    { MEX,      KM,      u8DistUnitListForRegionMEX,      2 }, 
    { UK,      MILES,      u8DistUnitListForRegionUK,      2 }, 
    { TKY,      KM,      u8DistUnitListForRegionTKY,      2 }, 
    { RUS,      KM,      u8DistUnitListForRegionRUS,      2 }, 
    { OTHER_EUR,      KM,      u8DistUnitListForRegionOTHER_EUR,      2 }, 
    { PRC,      KM,      u8DistUnitListForRegionPRC,      1 }, 
    { TWN,      KM,      u8DistUnitListForRegionTWN,      1 }, 
    { HKG,      KM,      u8DistUnitListForRegionHKG,      1 }, 
    { GCC,      KM,      u8DistUnitListForRegionGCC,      1 }, 
    { EGP,      KM,      u8DistUnitListForRegionEGP,      1 }, 
    { ASNZ,      KM,      u8DistUnitListForRegionASNZ,      1 }, 
    { BRA,      KM,      u8DistUnitListForRegionBRA,      1 }, 
    { AGT,      KM,      u8DistUnitListForRegionAGT,      1 }, 
    { OTHER_LAC,      KM,      u8DistUnitListForRegionOTHER_LAC,      1 }, 
    { SAF,      KM,      u8DistUnitListForRegionSAF,      1 }, 
    { THI,      KM,      u8DistUnitListForRegionTHI,      1 }, 
    { SGP,      KM,      u8DistUnitListForRegionSGP,      1 }, 
    { MLY,      KM,      u8DistUnitListForRegionMLY,      1 }, 
    { BRN,      KM,      u8DistUnitListForRegionBRN,      1 }, 
    { INN,      KM,      u8DistUnitListForRegionINN,      1 }, 
    { VNM,      KM,      u8DistUnitListForRegionVNM,      1 }, 
    { PHL,      KM,      u8DistUnitListForRegionPHL,      1 }, 
    { IND,      KM,      u8DistUnitListForRegionIND,      1 }, 
    { JPN,      KM,      u8DistUnitListForRegionJPN,      1 }, 
    { KOR,      KM,      u8DistUnitListForRegionKOR,      1 }, 
    { OTHER_GOM,      KM,      u8DistUnitListForRegionOTHER_GOM,      1 }, 
    { ISR,      KM,      u8DistUnitListForRegionISR,      0 }, 

};


//! Region wise mapping of Fuel Consumption Units

const sMapRegionFuelUnit mapRegionAndFuel[] = {
    // Region    //DefaultUnit  // Pointer To Unit Table     // Size Of Array
    { USA,      US_MPG,      u8FuelUnitListForRegionUSA,      2 }, 
    { CAN,      L_PER_100KM,      u8FuelUnitListForRegionCAN,      2 }, 
    { MEX,      L_PER_100KM,      u8FuelUnitListForRegionMEX,      3 }, 
    { UK,      UK_MPG,      u8FuelUnitListForRegionUK,      2 }, 
    { TKY,      L_PER_100KM,      u8FuelUnitListForRegionTKY,      2 }, 
    { RUS,      L_PER_100KM,      u8FuelUnitListForRegionRUS,      3 }, 
    { OTHER_EUR,      L_PER_100KM,      u8FuelUnitListForRegionOTHER_EUR,      2 }, 
    { PRC,      L_PER_100KM,      u8FuelUnitListForRegionPRC,      2 }, 
    { TWN,      L_PER_100KM,      u8FuelUnitListForRegionTWN,      2 }, 
    { HKG,      L_PER_100KM,      u8FuelUnitListForRegionHKG,      2 }, 
    { GCC,      L_PER_100KM,      u8FuelUnitListForRegionGCC,      2 }, 
    { EGP,      L_PER_100KM,      u8FuelUnitListForRegionEGP,      2 }, 
    { ASNZ,      L_PER_100KM,      u8FuelUnitListForRegionASNZ,      2 }, 
    { BRA,      KM_PER_L,      u8FuelUnitListForRegionBRA,      2 }, 
    { AGT,      L_PER_100KM,      u8FuelUnitListForRegionAGT,      2 }, 
    { OTHER_LAC,      L_PER_100KM,      u8FuelUnitListForRegionOTHER_LAC,      2 }, 
    { SAF,      L_PER_100KM,      u8FuelUnitListForRegionSAF,      2 }, 
    { THI,      L_PER_100KM,      u8FuelUnitListForRegionTHI,      2 }, 
    { SGP,      L_PER_100KM,      u8FuelUnitListForRegionSGP,      2 }, 
    { MLY,      L_PER_100KM,      u8FuelUnitListForRegionMLY,      2 }, 
    { BRN,      L_PER_100KM,      u8FuelUnitListForRegionBRN,      2 }, 
    { INN,      L_PER_100KM,      u8FuelUnitListForRegionINN,      2 }, 
    { VNM,      L_PER_100KM,      u8FuelUnitListForRegionVNM,      2 }, 
    { PHL,      L_PER_100KM,      u8FuelUnitListForRegionPHL,      2 }, 
    { IND,      L_PER_100KM,      u8FuelUnitListForRegionIND,      2 }, 
    { JPN,      L_PER_100KM,      u8FuelUnitListForRegionJPN,      2 }, 
    { KOR,      L_PER_100KM,      u8FuelUnitListForRegionKOR,      2 }, 
    { OTHER_GOM,      L_PER_100KM,      u8FuelUnitListForRegionOTHER_GOM,      2 }, 
    { ISR,      L_PER_100KM,      u8FuelUnitListForRegionISR,      0 }, 

};


//! Region wise mapping of Temperature Units

const sMapRegionTempUnit mapRegionAndTemp[] = {
    // Region    //DefaultUnit  // Pointer To Unit Table     // Size Of Array
    { USA,      DEG_F,      u8TempUnitListForRegionUSA,      2 }, 
    { CAN,      DEG_C,      u8TempUnitListForRegionCAN,      2 }, 
    { MEX,      DEG_C,      u8TempUnitListForRegionMEX,      2 }, 
    { UK,      DEG_C,      u8TempUnitListForRegionUK,      2 }, 
    { TKY,      DEG_C,      u8TempUnitListForRegionTKY,      1 }, 
    { RUS,      DEG_C,      u8TempUnitListForRegionRUS,      1 }, 
    { OTHER_EUR,      DEG_C,      u8TempUnitListForRegionOTHER_EUR,      2 }, 
    { PRC,      DEG_C,      u8TempUnitListForRegionPRC,      1 }, 
    { TWN,      DEG_C,      u8TempUnitListForRegionTWN,      1 }, 
    { HKG,      DEG_C,      u8TempUnitListForRegionHKG,      1 }, 
    { GCC,      DEG_C,      u8TempUnitListForRegionGCC,      1 }, 
    { EGP,      DEG_C,      u8TempUnitListForRegionEGP,      1 }, 
    { ASNZ,      DEG_C,      u8TempUnitListForRegionASNZ,      1 }, 
    { BRA,      DEG_C,      u8TempUnitListForRegionBRA,      1 }, 
    { AGT,      DEG_C,      u8TempUnitListForRegionAGT,      1 }, 
    { OTHER_LAC,      DEG_C,      u8TempUnitListForRegionOTHER_LAC,      1 }, 
    { SAF,      DEG_C,      u8TempUnitListForRegionSAF,      1 }, 
    { THI,      DEG_C,      u8TempUnitListForRegionTHI,      1 }, 
    { SGP,      DEG_C,      u8TempUnitListForRegionSGP,      1 }, 
    { MLY,      DEG_C,      u8TempUnitListForRegionMLY,      1 }, 
    { BRN,      DEG_C,      u8TempUnitListForRegionBRN,      1 }, 
    { INN,      DEG_C,      u8TempUnitListForRegionINN,      1 }, 
    { VNM,      DEG_C,      u8TempUnitListForRegionVNM,      1 }, 
    { PHL,      DEG_C,      u8TempUnitListForRegionPHL,      1 }, 
    { IND,      DEG_C,      u8TempUnitListForRegionIND,      1 }, 
    { JPN,      DEG_C,      u8TempUnitListForRegionJPN,      1 }, 
    { KOR,      DEG_C,      u8TempUnitListForRegionKOR,      1 }, 
    { OTHER_GOM,      DEG_C,      u8TempUnitListForRegionOTHER_GOM,      1 }, 
    { ISR,      DEG_C,      u8TempUnitListForRegionISR,      0 }, 

};



#endif // _UNITMAPPING_H_

