#ifndef TIMESTAMPSYNC_FIVISITOR_HEADER
#define TIMESTAMPSYNC_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class timestampsync_fi_tclOutput {
public:
   timestampsync_fi_tclOutput();
   virtual ~timestampsync_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class timestampsync_fi_tclFileOutput : public timestampsync_fi_tclOutput 
{
public:
   timestampsync_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   timestampsync_fi_tclFileOutput(); //lint !e1704
   timestampsync_fi_tclFileOutput& operator=(const timestampsync_fi_tclFileOutput& coRef);
   timestampsync_fi_tclFileOutput(const timestampsync_fi_tclFileOutput& coRef); //lint !e1704
};

class timestampsync_fi_tclMemOutput : public timestampsync_fi_tclOutput
{
public:
   timestampsync_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~timestampsync_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   timestampsync_fi_tclMemOutput(); //lint !e1704
   timestampsync_fi_tclMemOutput(const timestampsync_fi_tclMemOutput& coRef); //lint !e1704
   timestampsync_fi_tclMemOutput& operator=(const timestampsync_fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL timestampsync_fi_tclVisitorBase {
public:

   // --Konstruktor
   timestampsync_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~timestampsync_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(timestampsync_fi_tclU8& oU8);
   virtual tVoid vVisitS8(timestampsync_fi_tclS8& oS8);
   virtual tVoid vVisitU16(timestampsync_fi_tclU16& oU16);
   virtual tVoid vVisitS16(timestampsync_fi_tclS16& oS16);
   virtual tVoid vVisitU24(timestampsync_fi_tclU24& oU24);
   virtual tVoid vVisitS24(timestampsync_fi_tclS24& oS24);
   virtual tVoid vVisitU32(timestampsync_fi_tclU32& oU32);
   virtual tVoid vVisitS32(timestampsync_fi_tclS32& oS32);
   virtual tVoid vVisitU64(timestampsync_fi_tclU64& oU64);
   virtual tVoid vVisitS64(timestampsync_fi_tclS64& oS64);
   virtual tVoid vVisitF32(timestampsync_fi_tclF32& oF32);
   virtual tVoid vVisitF64(timestampsync_fi_tclF64& oF64);
   virtual tVoid vVisitBool(timestampsync_fi_tclBool& oBool);
   virtual tVoid vVisitString(timestampsync_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(timestampsync_fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(timestampsync_fi_tclList& oList);
   virtual tVoid vVisit_BinContainer(timestampsync_fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_Reserved(timestampsync_fi_tcl_Reserved& oReserved);

   virtual tVoid vVisit_u8_Percent(timestampsync_fi_tcl_u8_Percent& ou8_Percent);

   virtual tVoid vVisit_s16_PerThousand(timestampsync_fi_tcl_s16_PerThousand& os16_PerThousand);

   virtual tVoid vVisit_u16_IndexInReferenceList(timestampsync_fi_tcl_u16_IndexInReferenceList& ou16_IndexInReferenceList);

   virtual tVoid vVisit_u16_ErrorCode(timestampsync_fi_tcl_u16_ErrorCode& ou16_ErrorCode);

   virtual tVoid vVisit_u16_RPM(timestampsync_fi_tcl_u16_RPM& ou16_RPM);

   virtual tVoid vVisit_s32_Kilogram(timestampsync_fi_tcl_s32_Kilogram& os32_Kilogram);

   virtual tVoid vVisit_s32_Pound(timestampsync_fi_tcl_s32_Pound& os32_Pound);

   virtual tVoid vVisit_s16_Meter(timestampsync_fi_tcl_s16_Meter& os16_Meter);

   virtual tVoid vVisit_s32_Meter(timestampsync_fi_tcl_s32_Meter& os32_Meter);

   virtual tVoid vVisit_s32_Yards(timestampsync_fi_tcl_s32_Yards& os32_Yards);

   virtual tVoid vVisit_s32_Foot(timestampsync_fi_tcl_s32_Foot& os32_Foot);

   virtual tVoid vVisit_s32_Centimeter(timestampsync_fi_tcl_s32_Centimeter& os32_Centimeter);

   virtual tVoid vVisit_s32_Inch(timestampsync_fi_tcl_s32_Inch& os32_Inch);

   virtual tVoid vVisit_s32_Millimeter(timestampsync_fi_tcl_s32_Millimeter& os32_Millimeter);

   virtual tVoid vVisit_s32_Microliter(timestampsync_fi_tcl_s32_Microliter& os32_Microliter);

   virtual tVoid vVisit_s32_Second(timestampsync_fi_tcl_s32_Second& os32_Second);

   virtual tVoid vVisit_u16_MilliSecond(timestampsync_fi_tcl_u16_MilliSecond& ou16_MilliSecond);

   virtual tVoid vVisit_s32_MilliSecond(timestampsync_fi_tcl_s32_MilliSecond& os32_MilliSecond);

   virtual tVoid vVisit_POSIXTime(timestampsync_fi_tcl_POSIXTime& oPOSIXTime);

   virtual tVoid vVisit_e8_DST_State(timestampsync_fi_tcl_e8_DST_State& oe8_DST_State);

   virtual tVoid vVisit_TimeZoneElement(timestampsync_fi_tcl_TimeZoneElement& oTimeZoneElement);

   virtual tVoid vVisit_s16_KmPerHour(timestampsync_fi_tcl_s16_KmPerHour& os16_KmPerHour);

   virtual tVoid vVisit_s16_MilesPerHour(timestampsync_fi_tcl_s16_MilesPerHour& os16_MilesPerHour);

   virtual tVoid vVisit_s16_Knot(timestampsync_fi_tcl_s16_Knot& os16_Knot);

   virtual tVoid vVisit_s16_CentimeterSecond(timestampsync_fi_tcl_s16_CentimeterSecond& os16_CentimeterSecond);

   virtual tVoid vVisit_s16_Kelvin(timestampsync_fi_tcl_s16_Kelvin& os16_Kelvin);

   virtual tVoid vVisit_s16_Fahrenheit(timestampsync_fi_tcl_s16_Fahrenheit& os16_Fahrenheit);

   virtual tVoid vVisit_s32_Pascal(timestampsync_fi_tcl_s32_Pascal& os32_Pascal);

   virtual tVoid vVisit_s32_Watt(timestampsync_fi_tcl_s32_Watt& os32_Watt);

   virtual tVoid vVisit_FIVersion(timestampsync_fi_tcl_FIVersion& oFIVersion);

   virtual tVoid vVisit_s32_Longitude(timestampsync_fi_tcl_s32_Longitude& os32_Longitude);

   virtual tVoid vVisit_s32_Latitude(timestampsync_fi_tcl_s32_Latitude& os32_Latitude);

   virtual tVoid vVisit_PositionWGS84(timestampsync_fi_tcl_PositionWGS84& oPositionWGS84);

   virtual tVoid vVisit_RectangleWGS84(timestampsync_fi_tcl_RectangleWGS84& oRectangleWGS84);

   virtual tVoid vVisit_e16_ISOCountryCode(timestampsync_fi_tcl_e16_ISOCountryCode& oe16_ISOCountryCode);

   virtual tVoid vVisit_e16_ISOLanguageCode(timestampsync_fi_tcl_e16_ISOLanguageCode& oe16_ISOLanguageCode);

   virtual tVoid vVisit_LanguageID(timestampsync_fi_tcl_LanguageID& oLanguageID);

   virtual tVoid vVisit_u8_DirectionAbsolute(timestampsync_fi_tcl_u8_DirectionAbsolute& ou8_DirectionAbsolute);

   virtual tVoid vVisit_u8_DirectionRelative(timestampsync_fi_tcl_u8_DirectionRelative& ou8_DirectionRelative);

   virtual tVoid vVisit_s16_CentiDegree(timestampsync_fi_tcl_s16_CentiDegree& os16_CentiDegree);

   virtual tVoid vVisit_s16_Degree(timestampsync_fi_tcl_s16_Degree& os16_Degree);

   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(timestampsync_fi_tcl_u16_DirectionAbsolute_CentiDegree& ou16_DirectionAbsolute_CentiDegree);

   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(timestampsync_fi_tcl_s16_DirectionRelative_CentiDegree& os16_DirectionRelative_CentiDegree);

   virtual tVoid vVisit_e8_FuelType(timestampsync_fi_tcl_e8_FuelType& oe8_FuelType);

   virtual tVoid vVisit_DistTimeFuel(timestampsync_fi_tcl_DistTimeFuel& oDistTimeFuel);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
