/************************************************************************
 
 *FILE:           alltypes.h
 
 *SW-COMPONENT:   FI, framework for Functional Interface
 
 *DESCRIPTION:    Interface for all types defined in the different FIs
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           $ Log $
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef TCU_USB_ALLFITYPES_HEADER
#define TCU_USB_ALLFITYPES_HEADER

#include <vector>

class tcu_usb_fi_tclVisitorBase;

const tU16 TCU_USB_FI_C_U16_ERROR_INTERNALFAILURE = 1;
const tU16 TCU_USB_FI_C_U16_ERROR_INVALIDBINCONTAINERWRONGVERSION = 2;
const tU16 TCU_USB_FI_C_U16_ERROR_INVALIDBINCONTAINERUNEXPECTEDDATA = 3;

class tcu_usb_fi_tclTypeBase : public fi_tclTypeBase
{
public:
  tcu_usb_fi_tclTypeBase() {}
  virtual ~tcu_usb_fi_tclTypeBase() {}
   
  virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& /*oVisitor*/) {}
};

class tcu_usb_fi_tclVisitableTypeBase :public tcu_usb_fi_tclTypeBase
{
public:
   virtual void vTakeVisitor(tcu_usb_fi_tclVisitorBase& /*oVisitor*/) {}
};

class tcu_usb_fi_tclU8 : public tcu_usb_fi_tclVisitableTypeBase
{
public:
   tcu_usb_fi_tclU8():u8Value(0) {}
   tU8 u8Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const tcu_usb_fi_tclU8& roRef) const
      { return (u8Value == roRef.u8Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(tcu_usb_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return tcu_usb_typesfi_tclToken::EN_U8;}
};

class tcu_usb_fi_tclS8 : public tcu_usb_fi_tclVisitableTypeBase
{
public:
   tcu_usb_fi_tclS8():s8Value(0) {}
   tS8 s8Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const tcu_usb_fi_tclS8& roRef) const
      { return (s8Value == roRef.s8Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(tcu_usb_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return tcu_usb_typesfi_tclToken::EN_S8;}
};

class tcu_usb_fi_tclU16 : public tcu_usb_fi_tclVisitableTypeBase
{
public:
   tcu_usb_fi_tclU16():u16Value(0) {}
   tU16 u16Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const tcu_usb_fi_tclU16& roRef) const
      { return (u16Value == roRef.u16Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(tcu_usb_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return tcu_usb_typesfi_tclToken::EN_U16;}
};

class tcu_usb_fi_tclS16 : public tcu_usb_fi_tclVisitableTypeBase
{
public:
   tcu_usb_fi_tclS16():s16Value(0) {}
   tS16 s16Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const tcu_usb_fi_tclS16& roRef) const
      { return (s16Value == roRef.s16Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(tcu_usb_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return tcu_usb_typesfi_tclToken::EN_S16;}
};

class tcu_usb_fi_tclU24 : public tcu_usb_fi_tclVisitableTypeBase
{
public:
   tcu_usb_fi_tclU24():u24Value(0) {}
   tU24 u24Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const tcu_usb_fi_tclU24& roRef) const
      { return (u24Value == roRef.u24Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(tcu_usb_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return tcu_usb_typesfi_tclToken::EN_U24;}
};

class tcu_usb_fi_tclS24 : public tcu_usb_fi_tclVisitableTypeBase
{
public:
   tcu_usb_fi_tclS24():s24Value(0) {}
   tS24 s24Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const tcu_usb_fi_tclS24& roRef) const
      { return (s24Value == roRef.s24Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(tcu_usb_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return tcu_usb_typesfi_tclToken::EN_S24;}
};

class tcu_usb_fi_tclU32 : public tcu_usb_fi_tclVisitableTypeBase
{
public:
   tcu_usb_fi_tclU32():u32Value(0) {}
   tU32 u32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const tcu_usb_fi_tclU32& roRef) const
      { return (u32Value == roRef.u32Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(tcu_usb_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return tcu_usb_typesfi_tclToken::EN_U32;}
};

class tcu_usb_fi_tclS32 : public tcu_usb_fi_tclVisitableTypeBase
{
public:
   tcu_usb_fi_tclS32():s32Value(0) {}
   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const tcu_usb_fi_tclS32& roRef) const
      { return (s32Value == roRef.s32Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(tcu_usb_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return tcu_usb_typesfi_tclToken::EN_S32;}
};

class tcu_usb_fi_tclU64 : public tcu_usb_fi_tclVisitableTypeBase
{
public:
   tcu_usb_fi_tclU64():u64Value(0) {}
   tU64 u64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const tcu_usb_fi_tclU64& roRef) const
      { return (u64Value == roRef.u64Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(tcu_usb_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return tcu_usb_typesfi_tclToken::EN_U64;}
};

class tcu_usb_fi_tclS64 : public tcu_usb_fi_tclVisitableTypeBase
{
public:
   tcu_usb_fi_tclS64():s64Value(0) {}
   tS64 s64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const tcu_usb_fi_tclS64& roRef) const
      { return (s64Value == roRef.s64Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(tcu_usb_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return tcu_usb_typesfi_tclToken::EN_S64;}
};

class tcu_usb_fi_tclF32 : public tcu_usb_fi_tclVisitableTypeBase
{
public:
   tcu_usb_fi_tclF32():f32Value(0) {}
   tFloat f32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const tcu_usb_fi_tclF32& roRef) const
      { return (f32Value == roRef.f32Value);  } //lint !e777
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(tcu_usb_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return tcu_usb_typesfi_tclToken::EN_F32;}
};

class tcu_usb_fi_tclF64 : public tcu_usb_fi_tclVisitableTypeBase
{
public:
   tcu_usb_fi_tclF64():f64Value(0) {}
   tDouble f64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const tcu_usb_fi_tclF64& roRef) const
      { return (f64Value == roRef.f64Value); } //lint !e777
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(tcu_usb_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return tcu_usb_typesfi_tclToken::EN_F64;}
};

class tcu_usb_fi_tclBool : public tcu_usb_fi_tclVisitableTypeBase
{
public:
   tcu_usb_fi_tclBool():bValue(0) {}
   tBool bValue;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const tcu_usb_fi_tclBool& roRef) const
      { return (bValue == roRef.bValue); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(tcu_usb_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return tcu_usb_typesfi_tclToken::EN_BOOL;}
};

class tcu_usb_fi_tclString : public tcu_usb_fi_tclVisitableTypeBase
{
public:
   tcu_usb_fi_tclString():szValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tclString(const tcu_usb_fi_tclString& coRef);
   tcu_usb_fi_tclString& operator=(const tcu_usb_fi_tclString& coRef);
   virtual ~tcu_usb_fi_tclString();
#endif

   tString szValue;

   virtual void vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const tcu_usb_fi_tclString& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(tcu_usb_fi_tclVisitorBase& oVisitor);
#ifndef FI_DO_NOT_USE_TSTRING
   tcu_usb_fi_tclString& operator=(tCString coszString); // ADDED
   tcu_usb_fi_tclString(tCString coszInit); //ADDED
   tBool operator==(tCString coszString) const; // ADDED
   operator const tChar* () const; // ADDED
   operator tString&(); // ADDED
   tBool operator!=(intptr_t iNULL) const; // ADDED
   tChar* operator+(int iOffset); // ADDED
   tChar* operator+(tU8  u8Offset); // ADDED
   tChar* operator+(tU32 u32Offset); // ADDED
   tChar& operator[](tU16 u16Index); //ADDED
   tChar& operator[](tU32 u32Index); //ADDED
   tChar& operator[](tS32 s32Index); //ADDED
#endif
   enum tenCharSet {
      FI_EN_UNDEFINED = 0,
      FI_EN_ISO8859_15M,
      FI_EN_UTF8,
      FI_EN_ISO8859_1M
   };
   virtual tS32 s32GetTypeId() const { return tcu_usb_typesfi_tclToken::EN_STRING;}
   /* The following functions are used to import string values into FI-objects
    * and to export strings from FI-Objects.
    * The character encoding (ISO-Modified or UTF8) is provided as parameter
    * Attention: string values are copied by these functions, thus incoming and/or
    * outgoing strings have to be deleted externally.
    */
   tBool bSet(const tcu_usb_fi_tclString& corfoInit, tenCharSet enCharSet);
   tBool bSet(tCString coszInit, tenCharSet enCharSet);
   tString szGet(tenCharSet enCharSet) const;
};

class tcu_usb_fi_tclList : public tcu_usb_fi_tclVisitableTypeBase
{
public:
   tcu_usb_fi_tclList():u32ListSize(0) {}
   tU32 u32ListSize;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const tcu_usb_fi_tclList& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oIn);
   virtual void vTakeVisitor(tcu_usb_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return tcu_usb_typesfi_tclToken::EN_LIST;}
};

class tcu_usb_fi_tclMultiLanguageString : public tcu_usb_fi_tclVisitableTypeBase
{
public:
   tcu_usb_fi_tclMultiLanguageString():szValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tclMultiLanguageString(const tcu_usb_fi_tclMultiLanguageString& coRef);
   tcu_usb_fi_tclMultiLanguageString& operator=(const tcu_usb_fi_tclMultiLanguageString& coRef);
   virtual ~tcu_usb_fi_tclMultiLanguageString();
#endif

   tString szValue;

   virtual void vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const tcu_usb_fi_tclMultiLanguageString& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(tcu_usb_fi_tclVisitorBase& oVisitor);
#ifndef FI_DO_NOT_USE_TSTRING
   tcu_usb_fi_tclMultiLanguageString& operator=(tCString coszString); // ADDED
   tcu_usb_fi_tclMultiLanguageString(tCString coszInit); //ADDED
   tBool operator==(tCString coszString) const; // ADDED
   operator const tChar* () const; // ADDED
   operator tString&(); // ADDED
   tBool operator!=(intptr_t iNULL) const; // ADDED
   tChar* operator+(int iOffset); // ADDED
   tChar* operator+(tU8  u8Offset); // ADDED
   tChar* operator+(tU32 u32Offset); // ADDED
   tChar& operator[](tU16 u16Index); //ADDED
   tChar& operator[](tU32 u32Index); //ADDED
   tChar& operator[](tS32 s32Index); //ADDED
#endif
   enum tenCharSet {
      FI_EN_UNDEFINED = 0,
      FI_EN_ISO8859_15M,
      FI_EN_UTF8
   };
   virtual tS32 s32GetTypeId() const { return tcu_usb_typesfi_tclToken::EN_STRING;}
   /* The following functions are used to import string values into FI-objects
    * and to export strings from FI-Objects.
    * The character encoding (ISO-Modified or UTF8) is provided as parameter
    * Attention: string values are copied by these functions, thus incoming and/or
    * outgoing strings have to be deleted externally.
    */
   tBool bSet(const tcu_usb_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet);
   tBool bSet(tCString coszInit, tenCharSet enCharSet);
   tString szGet(tenCharSet enCharSet) const;
};
class tcu_usb_fi_tcl_BinContainer;
class tcu_usb_fi_tcl_Reserved;
class tcu_usb_fi_tcl_u8_Percent;
class tcu_usb_fi_tcl_s16_PerThousand;
class tcu_usb_fi_tcl_u16_IndexInReferenceList;
class tcu_usb_fi_tcl_u16_ErrorCode;
class tcu_usb_fi_tcl_u16_RPM;
class tcu_usb_fi_tcl_s32_Kilogram;
class tcu_usb_fi_tcl_s32_Pound;
class tcu_usb_fi_tcl_s16_Meter;
class tcu_usb_fi_tcl_s32_Meter;
class tcu_usb_fi_tcl_s32_Yards;
class tcu_usb_fi_tcl_s32_Foot;
class tcu_usb_fi_tcl_s32_Centimeter;
class tcu_usb_fi_tcl_s32_Inch;
class tcu_usb_fi_tcl_s32_Millimeter;
class tcu_usb_fi_tcl_s32_Microliter;
class tcu_usb_fi_tcl_s32_Second;
class tcu_usb_fi_tcl_u16_MilliSecond;
class tcu_usb_fi_tcl_s32_MilliSecond;
class tcu_usb_fi_tcl_POSIXTime;
class tcu_usb_fi_tcl_e8_DST_State;
class tcu_usb_fi_tcl_TimeZoneElement;
class tcu_usb_fi_tcl_s16_KmPerHour;
class tcu_usb_fi_tcl_s16_MilesPerHour;
class tcu_usb_fi_tcl_s16_Knot;
class tcu_usb_fi_tcl_s16_CentimeterSecond;
class tcu_usb_fi_tcl_s16_Kelvin;
class tcu_usb_fi_tcl_s16_Fahrenheit;
class tcu_usb_fi_tcl_s32_Pascal;
class tcu_usb_fi_tcl_s32_Watt;
class tcu_usb_fi_tcl_FIVersion;
class tcu_usb_fi_tcl_s32_Longitude;
class tcu_usb_fi_tcl_s32_Latitude;
class tcu_usb_fi_tcl_PositionWGS84;
class tcu_usb_fi_tcl_RectangleWGS84;
class tcu_usb_fi_tcl_e16_ISOCountryCode;
class tcu_usb_fi_tcl_e16_ISOLanguageCode;
class tcu_usb_fi_tcl_LanguageID;
class tcu_usb_fi_tcl_u8_DirectionAbsolute;
class tcu_usb_fi_tcl_u8_DirectionRelative;
class tcu_usb_fi_tcl_s16_CentiDegree;
class tcu_usb_fi_tcl_s16_Degree;
class tcu_usb_fi_tcl_u16_DirectionAbsolute_CentiDegree;
class tcu_usb_fi_tcl_s16_DirectionRelative_CentiDegree;
class tcu_usb_fi_tcl_e8_FuelType;
class tcu_usb_fi_tcl_DistTimeFuel;
class tcu_usb_fi_tcl_e16_DataConnectionError;
class tcu_usb_fi_tcl_e8_DataConnectionStatus;
class tcu_usb_fi_tcl_e8_ServiceType;
class tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info;
class tcu_usb_fi_tcl_usb_tcu_POIID_List;
class tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info;
class tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info;
class tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List;
class tcu_usb_fi_tcl_e8_TCU_ProbePermitSetting;
class tcu_usb_fi_tcl_e8_tcu_NotiResult;
class tcu_usb_fi_tcl_e8_tcu_Authentication_Result;
class tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data;
class tcu_usb_fi_tcl_tcu_Block_Data_List;
class tcu_usb_fi_tcl_tcu_Japan_Location;
class tcu_usb_fi_tcl_tcu_navigation_setting_information;
class tcu_usb_fi_tcl_json_file_path;
class tcu_usb_fi_tcl_e8_tcu_LogLevel;
class tcu_usb_fi_tcl_e8_AutoDownloadInterval;
class tcu_usb_fi_tcl_e8_ConnectedSearchServiceType;
class tcu_usb_fi_tcl_e8_tcu_AudioActivity;
class tcu_usb_fi_tcl_e8_tcu_ExecType;
class tcu_usb_fi_tcl_tcu_VICS_Request_Data;
class tcu_usb_fi_tcl_usb_tcu_Channel_definition_information;
class tcu_usb_fi_tcl_usb_tcu_Channel_Info;
class tcu_usb_fi_tcl_usb_tcu_Channel_Info_List;
class tcu_usb_fi_tcl_usb_tcu_channel_master_data_header;
class tcu_usb_fi_tcl_usb_tcu_Folder_definition_information;
class tcu_usb_fi_tcl_usb_tcu_Location;
class tcu_usb_fi_tcl_usb_tcu_Data_Header_Part;
class tcu_usb_fi_tcl_usb_tcu_Data_Record;
class tcu_usb_fi_tcl_usb_tcu_channel_master_data;
class tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info;
class tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info;
class tcu_usb_fi_tcl_usb_tcu_GroupA_Info;
class tcu_usb_fi_tcl_usb_tcu_connected_search_result;
class tcu_usb_fi_tcl_tcu_charging_spot_data;
class tcu_usb_fi_tcl_tcu_response_charging_spot_data_result;
class tcu_usb_fi_tcl_tcu_charging_stations_info;
class tcu_usb_fi_tcl_tcu_charging_stations_data;
class tcu_usb_fi_tcl_tcu_response_charging_stations_list_result;
class tcu_usb_fi_tcl_tcu_vacancy_stations_info;
class tcu_usb_fi_tcl_tcu_vacancy_stations_data;
class tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result;
class tcu_usb_fi_tcl_tcu_vacancy_spot_data;
class tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result;
class tcu_usb_fi_tcl_usb_tcu_Server_Info;
class tcu_usb_fi_tcl_usb_tcu_Server_Info_List;
class tcu_usb_fi_tcl_e8_ModemType;
class tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info;
class tcu_usb_fi_tcl_e8_DatabaseServiceType;
class tcu_usb_fi_tcl_e8_DatabaseStatus;
class tcu_usb_fi_tcl_e8_CancelRequestType;
class tcu_usb_fi_tcl_e8_UserAuthenticationResultType;
class tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info;
class tcu_usb_fi_tcl_e8_tcu_Regions;
class tcu_usb_fi_tcl_BinContainer : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_BinContainer();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_BinContainer& operator=(const tcu_usb_fi_tcl_BinContainer& coRef);
   tcu_usb_fi_tcl_BinContainer(const tcu_usb_fi_tcl_BinContainer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > ContainerDataList;
   virtual ~tcu_usb_fi_tcl_BinContainer();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_BinContainer& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_Reserved : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_Reserved();

   virtual ~tcu_usb_fi_tcl_Reserved();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_Reserved& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_u8_Percent : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_u8_Percent(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~tcu_usb_fi_tcl_u8_Percent();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_u8_Percent& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s16_PerThousand : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s16_PerThousand(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~tcu_usb_fi_tcl_s16_PerThousand();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s16_PerThousand& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_u16_IndexInReferenceList : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_u16_IndexInReferenceList(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~tcu_usb_fi_tcl_u16_IndexInReferenceList();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_u16_IndexInReferenceList& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_u16_ErrorCode : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_u16_ErrorCode(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~tcu_usb_fi_tcl_u16_ErrorCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_u16_ErrorCode& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_u16_RPM : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_u16_RPM(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~tcu_usb_fi_tcl_u16_RPM();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_u16_RPM& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s32_Kilogram : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s32_Kilogram(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~tcu_usb_fi_tcl_s32_Kilogram();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s32_Kilogram& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s32_Pound : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s32_Pound(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~tcu_usb_fi_tcl_s32_Pound();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s32_Pound& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s16_Meter : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s16_Meter(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~tcu_usb_fi_tcl_s16_Meter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s16_Meter& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s32_Meter : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s32_Meter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~tcu_usb_fi_tcl_s32_Meter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s32_Meter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s32_Yards : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s32_Yards(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~tcu_usb_fi_tcl_s32_Yards();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s32_Yards& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s32_Foot : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s32_Foot(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~tcu_usb_fi_tcl_s32_Foot();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s32_Foot& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s32_Centimeter : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s32_Centimeter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~tcu_usb_fi_tcl_s32_Centimeter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s32_Centimeter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s32_Inch : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s32_Inch(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~tcu_usb_fi_tcl_s32_Inch();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s32_Inch& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s32_Millimeter : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s32_Millimeter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~tcu_usb_fi_tcl_s32_Millimeter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s32_Millimeter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s32_Microliter : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s32_Microliter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~tcu_usb_fi_tcl_s32_Microliter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s32_Microliter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s32_Second : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s32_Second(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~tcu_usb_fi_tcl_s32_Second();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s32_Second& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_u16_MilliSecond : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_u16_MilliSecond(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~tcu_usb_fi_tcl_u16_MilliSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_u16_MilliSecond& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s32_MilliSecond : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s32_MilliSecond(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~tcu_usb_fi_tcl_s32_MilliSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s32_MilliSecond& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_POSIXTime : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_POSIXTime();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_POSIXTime& operator=(const tcu_usb_fi_tcl_POSIXTime& coRef);
   tcu_usb_fi_tcl_POSIXTime(const tcu_usb_fi_tcl_POSIXTime& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 Time;
   virtual ~tcu_usb_fi_tcl_POSIXTime();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_POSIXTime& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_e8_DST_State : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_e8_DST_State();
   enum tenType {
      FI_EN_T_STANDARDTIME = 0UL,
      FI_EN_T_DAYLIGHTSAVINGTIME = 1UL,
      FI_EN_T_EVALUATIONNECESSARY = 2UL
   };
   tenType enType;

   tcu_usb_fi_tcl_e8_DST_State(tcu_usb_fi_tcl_e8_DST_State::tenType newValue)
      :enType(newValue)
   {}

   virtual ~tcu_usb_fi_tcl_e8_DST_State();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_e8_DST_State& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_TimeZoneElement : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_TimeZoneElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_TimeZoneElement& operator=(const tcu_usb_fi_tcl_TimeZoneElement& coRef);
   tcu_usb_fi_tcl_TimeZoneElement(const tcu_usb_fi_tcl_TimeZoneElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tclMultiLanguageString Abbreviation_StandardTime;
   tcu_usb_fi_tclMultiLanguageString Abbreviation_DST_in_effect;
   tcu_usb_fi_tcl_s32_Second TimeZoneDifference;
   tcu_usb_fi_tcl_e8_DST_State DST_State;
   tcu_usb_fi_tcl_s32_Second DSTDifference;
   std::vector<tU8, std::allocator<tU8> > DST_TimeDomain;
   virtual ~tcu_usb_fi_tcl_TimeZoneElement();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_TimeZoneElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s16_KmPerHour : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s16_KmPerHour(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~tcu_usb_fi_tcl_s16_KmPerHour();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s16_KmPerHour& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s16_MilesPerHour : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s16_MilesPerHour(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~tcu_usb_fi_tcl_s16_MilesPerHour();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s16_MilesPerHour& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s16_Knot : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s16_Knot(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~tcu_usb_fi_tcl_s16_Knot();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s16_Knot& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s16_CentimeterSecond : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s16_CentimeterSecond(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~tcu_usb_fi_tcl_s16_CentimeterSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s16_CentimeterSecond& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s16_Kelvin : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s16_Kelvin(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~tcu_usb_fi_tcl_s16_Kelvin();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s16_Kelvin& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s16_Fahrenheit : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s16_Fahrenheit(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~tcu_usb_fi_tcl_s16_Fahrenheit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s16_Fahrenheit& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s32_Pascal : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s32_Pascal(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~tcu_usb_fi_tcl_s32_Pascal();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s32_Pascal& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s32_Watt : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s32_Watt(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~tcu_usb_fi_tcl_s32_Watt();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s32_Watt& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_FIVersion : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_FIVersion();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_FIVersion& operator=(const tcu_usb_fi_tcl_FIVersion& coRef);
   tcu_usb_fi_tcl_FIVersion(const tcu_usb_fi_tcl_FIVersion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MajorVersion;
   tU8 MinorVersion;
   tU8 PatchVersion;
   virtual ~tcu_usb_fi_tcl_FIVersion();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_FIVersion& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s32_Longitude : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s32_Longitude(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~tcu_usb_fi_tcl_s32_Longitude();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s32_Longitude& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s32_Latitude : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s32_Latitude(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~tcu_usb_fi_tcl_s32_Latitude();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s32_Latitude& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_PositionWGS84 : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_PositionWGS84();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_PositionWGS84& operator=(const tcu_usb_fi_tcl_PositionWGS84& coRef);
   tcu_usb_fi_tcl_PositionWGS84(const tcu_usb_fi_tcl_PositionWGS84& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_s32_Longitude Longitude;
   tcu_usb_fi_tcl_s32_Latitude Latitude;
   virtual ~tcu_usb_fi_tcl_PositionWGS84();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_PositionWGS84& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_RectangleWGS84 : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_RectangleWGS84();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_RectangleWGS84& operator=(const tcu_usb_fi_tcl_RectangleWGS84& coRef);
   tcu_usb_fi_tcl_RectangleWGS84(const tcu_usb_fi_tcl_RectangleWGS84& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_s32_Longitude LongitudeMin;
   tcu_usb_fi_tcl_s32_Latitude LatitudeMin;
   tcu_usb_fi_tcl_s32_Longitude LongitudeMax;
   tcu_usb_fi_tcl_s32_Latitude LatitudeMax;
   virtual ~tcu_usb_fi_tcl_RectangleWGS84();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_RectangleWGS84& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_e16_ISOCountryCode : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_e16_ISOCountryCode();
   enum tenType {
      FI_EN_ISO_ALPHA_3_UNDEFINED = 0UL,
      FI_EN_ISO_ALPHA_3_AFG = 1223UL,
      FI_EN_ISO_ALPHA_3_ALB = 1410UL,
      FI_EN_ISO_ALPHA_3_DZA = 4929UL,
      FI_EN_ISO_ALPHA_3_ASM = 1645UL,
      FI_EN_ISO_ALPHA_3_AND = 1476UL,
      FI_EN_ISO_ALPHA_3_AGO = 1263UL,
      FI_EN_ISO_ALPHA_3_AIA = 1313UL,
      FI_EN_ISO_ALPHA_3_ATG = 1671UL,
      FI_EN_ISO_ALPHA_3_ARG = 1607UL,
      FI_EN_ISO_ALPHA_3_ARM = 1613UL,
      FI_EN_ISO_ALPHA_3_ABW = 1111UL,
      FI_EN_ISO_ALPHA_3_AUS = 1715UL,
      FI_EN_ISO_ALPHA_3_AUT = 1716UL,
      FI_EN_ISO_ALPHA_3_AZE = 1861UL,
      FI_EN_ISO_ALPHA_3_BHS = 2323UL,
      FI_EN_ISO_ALPHA_3_BHR = 2322UL,
      FI_EN_ISO_ALPHA_3_BGD = 2276UL,
      FI_EN_ISO_ALPHA_3_BRB = 2626UL,
      FI_EN_ISO_ALPHA_3_BLR = 2450UL,
      FI_EN_ISO_ALPHA_3_BEL = 2220UL,
      FI_EN_ISO_ALPHA_3_BLZ = 2458UL,
      FI_EN_ISO_ALPHA_3_BEN = 2222UL,
      FI_EN_ISO_ALPHA_3_BMU = 2485UL,
      FI_EN_ISO_ALPHA_3_BTN = 2702UL,
      FI_EN_ISO_ALPHA_3_BOL = 2540UL,
      FI_EN_ISO_ALPHA_3_BIH = 2344UL,
      FI_EN_ISO_ALPHA_3_BWA = 2785UL,
      FI_EN_ISO_ALPHA_3_BRA = 2625UL,
      FI_EN_ISO_ALPHA_3_BRN = 2638UL,
      FI_EN_ISO_ALPHA_3_BGR = 2290UL,
      FI_EN_ISO_ALPHA_3_BFA = 2241UL,
      FI_EN_ISO_ALPHA_3_BDI = 2185UL,
      FI_EN_ISO_ALPHA_3_KHM = 11533UL,
      FI_EN_ISO_ALPHA_3_CMR = 3506UL,
      FI_EN_ISO_ALPHA_3_CAN = 3118UL,
      FI_EN_ISO_ALPHA_3_CPV = 3606UL,
      FI_EN_ISO_ALPHA_3_CYM = 3885UL,
      FI_EN_ISO_ALPHA_3_CAF = 3110UL,
      FI_EN_ISO_ALPHA_3_TCD = 20580UL,
      FI_EN_ISO_ALPHA_3_CHL = 3340UL,
      FI_EN_ISO_ALPHA_3_CHN = 3342UL,
      FI_EN_ISO_ALPHA_3_COL = 3564UL,
      FI_EN_ISO_ALPHA_3_COM = 3565UL,
      FI_EN_ISO_ALPHA_3_COG = 3559UL,
      FI_EN_ISO_ALPHA_3_COD = 3556UL,
      FI_EN_ISO_ALPHA_3_COK = 3563UL,
      FI_EN_ISO_ALPHA_3_CRI = 3657UL,
      FI_EN_ISO_ALPHA_3_CIV = 3382UL,
      FI_EN_ISO_ALPHA_3_HRV = 8790UL,
      FI_EN_ISO_ALPHA_3_CUB = 3746UL,
      FI_EN_ISO_ALPHA_3_CYP = 3888UL,
      FI_EN_ISO_ALPHA_3_CZE = 3909UL,
      FI_EN_ISO_ALPHA_3_DNK = 4555UL,
      FI_EN_ISO_ALPHA_3_DJI = 4425UL,
      FI_EN_ISO_ALPHA_3_DMA = 4513UL,
      FI_EN_ISO_ALPHA_3_DOM = 4589UL,
      FI_EN_ISO_ALPHA_3_ECU = 5237UL,
      FI_EN_ISO_ALPHA_3_EGY = 5369UL,
      FI_EN_ISO_ALPHA_3_SLV = 19862UL,
      FI_EN_ISO_ALPHA_3_GNQ = 7633UL,
      FI_EN_ISO_ALPHA_3_ERI = 5705UL,
      FI_EN_ISO_ALPHA_3_EST = 5748UL,
      FI_EN_ISO_ALPHA_3_ETH = 5768UL,
      FI_EN_ISO_ALPHA_3_FLK = 6539UL,
      FI_EN_ISO_ALPHA_3_FRO = 6735UL,
      FI_EN_ISO_ALPHA_3_FJI = 6473UL,
      FI_EN_ISO_ALPHA_3_FIN = 6446UL,
      FI_EN_ISO_ALPHA_3_FRA = 6721UL,
      FI_EN_ISO_ALPHA_3_GUF = 7846UL,
      FI_EN_ISO_ALPHA_3_PYF = 17190UL,
      FI_EN_ISO_ALPHA_3_GAB = 7202UL,
      FI_EN_ISO_ALPHA_3_GMB = 7586UL,
      FI_EN_ISO_ALPHA_3_GEO = 7343UL,
      FI_EN_ISO_ALPHA_3_DEU = 4277UL,
      FI_EN_ISO_ALPHA_3_GHA = 7425UL,
      FI_EN_ISO_ALPHA_3_GIB = 7458UL,
      FI_EN_ISO_ALPHA_3_GRC = 7747UL,
      FI_EN_ISO_ALPHA_3_GRL = 7756UL,
      FI_EN_ISO_ALPHA_3_GRD = 7748UL,
      FI_EN_ISO_ALPHA_3_GLP = 7568UL,
      FI_EN_ISO_ALPHA_3_GUM = 7853UL,
      FI_EN_ISO_ALPHA_3_GTM = 7821UL,
      FI_EN_ISO_ALPHA_3_GIN = 7470UL,
      FI_EN_ISO_ALPHA_3_GNB = 7618UL,
      FI_EN_ISO_ALPHA_3_GUY = 7865UL,
      FI_EN_ISO_ALPHA_3_HTI = 8841UL,
      FI_EN_ISO_ALPHA_3_VAT = 22580UL,
      FI_EN_ISO_ALPHA_3_HND = 8644UL,
      FI_EN_ISO_ALPHA_3_HKG = 8551UL,
      FI_EN_ISO_ALPHA_3_HUN = 8878UL,
      FI_EN_ISO_ALPHA_3_ISL = 9836UL,
      FI_EN_ISO_ALPHA_3_IND = 9668UL,
      FI_EN_ISO_ALPHA_3_IDN = 9358UL,
      FI_EN_ISO_ALPHA_3_INT = 9684UL,
      FI_EN_ISO_ALPHA_3_IRN = 9806UL,
      FI_EN_ISO_ALPHA_3_IRQ = 9809UL,
      FI_EN_ISO_ALPHA_3_IRL = 9804UL,
      FI_EN_ISO_ALPHA_3_ISR = 9842UL,
      FI_EN_ISO_ALPHA_3_ITA = 9857UL,
      FI_EN_ISO_ALPHA_3_JAM = 10285UL,
      FI_EN_ISO_ALPHA_3_JPN = 10766UL,
      FI_EN_ISO_ALPHA_3_JOR = 10738UL,
      FI_EN_ISO_ALPHA_3_KAZ = 11322UL,
      FI_EN_ISO_ALPHA_3_KEN = 11438UL,
      FI_EN_ISO_ALPHA_3_KIR = 11570UL,
      FI_EN_ISO_ALPHA_3_PRK = 16971UL,
      FI_EN_ISO_ALPHA_3_KOR = 11762UL,
      FI_EN_ISO_ALPHA_3_KWT = 12020UL,
      FI_EN_ISO_ALPHA_3_KGZ = 11514UL,
      FI_EN_ISO_ALPHA_3_LAO = 12335UL,
      FI_EN_ISO_ALPHA_3_LVA = 12993UL,
      FI_EN_ISO_ALPHA_3_LBN = 12366UL,
      FI_EN_ISO_ALPHA_3_LSO = 12911UL,
      FI_EN_ISO_ALPHA_3_LBR = 12370UL,
      FI_EN_ISO_ALPHA_3_LBY = 12377UL,
      FI_EN_ISO_ALPHA_3_LIE = 12581UL,
      FI_EN_ISO_ALPHA_3_LTU = 12949UL,
      FI_EN_ISO_ALPHA_3_LUX = 12984UL,
      FI_EN_ISO_ALPHA_3_MAC = 13347UL,
      FI_EN_ISO_ALPHA_3_MKD = 13668UL,
      FI_EN_ISO_ALPHA_3_MDG = 13447UL,
      FI_EN_ISO_ALPHA_3_MWI = 14057UL,
      FI_EN_ISO_ALPHA_3_MYS = 14131UL,
      FI_EN_ISO_ALPHA_3_MDV = 13462UL,
      FI_EN_ISO_ALPHA_3_MLI = 13705UL,
      FI_EN_ISO_ALPHA_3_MLT = 13716UL,
      FI_EN_ISO_ALPHA_3_MHL = 13580UL,
      FI_EN_ISO_ALPHA_3_MTQ = 13969UL,
      FI_EN_ISO_ALPHA_3_MRT = 13908UL,
      FI_EN_ISO_ALPHA_3_MUS = 14003UL,
      FI_EN_ISO_ALPHA_3_MYT = 14132UL,
      FI_EN_ISO_ALPHA_3_MEX = 13496UL,
      FI_EN_ISO_ALPHA_3_FSM = 6765UL,
      FI_EN_ISO_ALPHA_3_MDA = 13441UL,
      FI_EN_ISO_ALPHA_3_MCO = 13423UL,
      FI_EN_ISO_ALPHA_3_MNG = 13767UL,
      FI_EN_ISO_ALPHA_3_MNE = 13765UL,
      FI_EN_ISO_ALPHA_3_MSR = 13938UL,
      FI_EN_ISO_ALPHA_3_MAR = 13362UL,
      FI_EN_ISO_ALPHA_3_MOZ = 13818UL,
      FI_EN_ISO_ALPHA_3_MMR = 13746UL,
      FI_EN_ISO_ALPHA_3_NAM = 14381UL,
      FI_EN_ISO_ALPHA_3_NRU = 14933UL,
      FI_EN_ISO_ALPHA_3_NPL = 14860UL,
      FI_EN_ISO_ALPHA_3_NLD = 14724UL,
      FI_EN_ISO_ALPHA_3_ANT = 1492UL,
      FI_EN_ISO_ALPHA_3_NCL = 14444UL,
      FI_EN_ISO_ALPHA_3_NZL = 15180UL,
      FI_EN_ISO_ALPHA_3_NIC = 14627UL,
      FI_EN_ISO_ALPHA_3_NER = 14514UL,
      FI_EN_ISO_ALPHA_3_NGA = 14561UL,
      FI_EN_ISO_ALPHA_3_NIU = 14645UL,
      FI_EN_ISO_ALPHA_3_NFK = 14539UL,
      FI_EN_ISO_ALPHA_3_MNP = 13776UL,
      FI_EN_ISO_ALPHA_3_NOR = 14834UL,
      FI_EN_ISO_ALPHA_3_PSE = 16997UL,
      FI_EN_ISO_ALPHA_3_OMN = 15790UL,
      FI_EN_ISO_ALPHA_3_PAK = 16427UL,
      FI_EN_ISO_ALPHA_3_PLW = 16791UL,
      FI_EN_ISO_ALPHA_3_PAN = 16430UL,
      FI_EN_ISO_ALPHA_3_PNG = 16839UL,
      FI_EN_ISO_ALPHA_3_PRY = 16985UL,
      FI_EN_ISO_ALPHA_3_PER = 16562UL,
      FI_EN_ISO_ALPHA_3_PHL = 16652UL,
      FI_EN_ISO_ALPHA_3_PCN = 16494UL,
      FI_EN_ISO_ALPHA_3_POL = 16876UL,
      FI_EN_ISO_ALPHA_3_PRT = 16980UL,
      FI_EN_ISO_ALPHA_3_PRI = 16969UL,
      FI_EN_ISO_ALPHA_3_QAT = 17460UL,
      FI_EN_ISO_ALPHA_3_REU = 18613UL,
      FI_EN_ISO_ALPHA_3_ROU = 18933UL,
      FI_EN_ISO_ALPHA_3_RUS = 19123UL,
      FI_EN_ISO_ALPHA_3_RWA = 19169UL,
      FI_EN_ISO_ALPHA_3_KNA = 11713UL,
      FI_EN_ISO_ALPHA_3_LCA = 12385UL,
      FI_EN_ISO_ALPHA_3_VCT = 22644UL,
      FI_EN_ISO_ALPHA_3_WSM = 24173UL,
      FI_EN_ISO_ALPHA_3_SMR = 19890UL,
      FI_EN_ISO_ALPHA_3_STP = 20112UL,
      FI_EN_ISO_ALPHA_3_SAU = 19509UL,
      FI_EN_ISO_ALPHA_3_SEN = 19630UL,
      FI_EN_ISO_ALPHA_3_SRB = 20034UL,
      FI_EN_ISO_ALPHA_3_SYC = 20259UL,
      FI_EN_ISO_ALPHA_3_SLE = 19845UL,
      FI_EN_ISO_ALPHA_3_SGP = 19696UL,
      FI_EN_ISO_ALPHA_3_SVK = 20171UL,
      FI_EN_ISO_ALPHA_3_SVN = 20174UL,
      FI_EN_ISO_ALPHA_3_SLB = 19842UL,
      FI_EN_ISO_ALPHA_3_SOM = 19949UL,
      FI_EN_ISO_ALPHA_3_ZAF = 26662UL,
      FI_EN_ISO_ALPHA_3_ESP = 5744UL,
      FI_EN_ISO_ALPHA_3_LKA = 12641UL,
      FI_EN_ISO_ALPHA_3_SHN = 19726UL,
      FI_EN_ISO_ALPHA_3_SPM = 19981UL,
      FI_EN_ISO_ALPHA_3_SDN = 19598UL,
      FI_EN_ISO_ALPHA_3_SUR = 20146UL,
      FI_EN_ISO_ALPHA_3_SJM = 19789UL,
      FI_EN_ISO_ALPHA_3_SWZ = 20218UL,
      FI_EN_ISO_ALPHA_3_SWE = 20197UL,
      FI_EN_ISO_ALPHA_3_CHE = 3333UL,
      FI_EN_ISO_ALPHA_3_SYR = 20274UL,
      FI_EN_ISO_ALPHA_3_TWN = 21230UL,
      FI_EN_ISO_ALPHA_3_TJK = 20811UL,
      FI_EN_ISO_ALPHA_3_TZA = 21313UL,
      FI_EN_ISO_ALPHA_3_THA = 20737UL,
      FI_EN_ISO_ALPHA_3_TLS = 20883UL,
      FI_EN_ISO_ALPHA_3_TGO = 20719UL,
      FI_EN_ISO_ALPHA_3_TKL = 20844UL,
      FI_EN_ISO_ALPHA_3_TON = 20974UL,
      FI_EN_ISO_ALPHA_3_TTO = 21135UL,
      FI_EN_ISO_ALPHA_3_TUN = 21166UL,
      FI_EN_ISO_ALPHA_3_TUR = 21170UL,
      FI_EN_ISO_ALPHA_3_TKM = 20845UL,
      FI_EN_ISO_ALPHA_3_TCA = 20577UL,
      FI_EN_ISO_ALPHA_3_TUV = 21174UL,
      FI_EN_ISO_ALPHA_3_UGA = 21729UL,
      FI_EN_ISO_ALPHA_3_UKR = 21874UL,
      FI_EN_ISO_ALPHA_3_ARE = 1605UL,
      FI_EN_ISO_ALPHA_3_GBR = 7250UL,
      FI_EN_ISO_ALPHA_3_USA = 22113UL,
      FI_EN_ISO_ALPHA_3_URY = 22105UL,
      FI_EN_ISO_ALPHA_3_UZB = 22338UL,
      FI_EN_ISO_ALPHA_3_VUT = 23220UL,
      FI_EN_ISO_ALPHA_3_VEN = 22702UL,
      FI_EN_ISO_ALPHA_3_VNM = 22989UL,
      FI_EN_ISO_ALPHA_3_VGB = 22754UL,
      FI_EN_ISO_ALPHA_3_VIR = 22834UL,
      FI_EN_ISO_ALPHA_3_WLF = 23942UL,
      FI_EN_ISO_ALPHA_3_ESH = 5736UL,
      FI_EN_ISO_ALPHA_3_YEM = 25773UL,
      FI_EN_ISO_ALPHA_3_YUG = 26279UL,
      FI_EN_ISO_ALPHA_3_ZMB = 27042UL,
      FI_EN_ISO_ALPHA_3_ZWE = 27365UL
   };
   tenType enType;

   tcu_usb_fi_tcl_e16_ISOCountryCode(tcu_usb_fi_tcl_e16_ISOCountryCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~tcu_usb_fi_tcl_e16_ISOCountryCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_e16_ISOCountryCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_e16_ISOLanguageCode : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_e16_ISOLanguageCode();
   enum tenType {
      FI_EN_ISO_639_1_UNDEFINED = 0UL,
      FI_EN_ISO_639_1_AA = 24929UL,
      FI_EN_ISO_639_1_AB = 24930UL,
      FI_EN_ISO_639_1_AE = 24933UL,
      FI_EN_ISO_639_1_AF = 24934UL,
      FI_EN_ISO_639_1_AK = 24939UL,
      FI_EN_ISO_639_1_AM = 24941UL,
      FI_EN_ISO_639_1_AN = 24942UL,
      FI_EN_ISO_639_1_AR = 24946UL,
      FI_EN_ISO_639_1_AS = 24947UL,
      FI_EN_ISO_639_1_AV = 24950UL,
      FI_EN_ISO_639_1_AY = 24953UL,
      FI_EN_ISO_639_1_AZ = 24954UL,
      FI_EN_ISO_639_1_BA = 25185UL,
      FI_EN_ISO_639_1_BE = 25189UL,
      FI_EN_ISO_639_1_BG = 25191UL,
      FI_EN_ISO_639_1_BH = 25192UL,
      FI_EN_ISO_639_1_BI = 25193UL,
      FI_EN_ISO_639_1_BL = 25196UL,
      FI_EN_ISO_639_1_BM = 25197UL,
      FI_EN_ISO_639_1_BN = 25198UL,
      FI_EN_ISO_639_1_BO = 25199UL,
      FI_EN_ISO_639_1_BR = 25202UL,
      FI_EN_ISO_639_1_BS = 25203UL,
      FI_EN_ISO_639_1_BT = 25204UL,
      FI_EN_ISO_639_1_CA = 25441UL,
      FI_EN_ISO_639_1_CE = 25445UL,
      FI_EN_ISO_639_1_CF = 25446UL,
      FI_EN_ISO_639_1_CH = 25448UL,
      FI_EN_ISO_639_1_CL = 25452UL,
      FI_EN_ISO_639_1_CN = 25454UL,
      FI_EN_ISO_639_1_CO = 25455UL,
      FI_EN_ISO_639_1_CR = 25458UL,
      FI_EN_ISO_639_1_CS = 25459UL,
      FI_EN_ISO_639_1_CT = 25460UL,
      FI_EN_ISO_639_1_CU = 25461UL,
      FI_EN_ISO_639_1_CV = 25462UL,
      FI_EN_ISO_639_1_CY = 25465UL,
      FI_EN_ISO_639_1_DA = 25697UL,
      FI_EN_ISO_639_1_DE = 25701UL,
      FI_EN_ISO_639_1_DV = 25718UL,
      FI_EN_ISO_639_1_DZ = 25722UL,
      FI_EN_ISO_639_1_EE = 25957UL,
      FI_EN_ISO_639_1_EG = 25959UL,
      FI_EN_ISO_639_1_EL = 25964UL,
      FI_EN_ISO_639_1_EN = 25966UL,
      FI_EN_ISO_639_1_EO = 25967UL,
      FI_EN_ISO_639_1_ES = 25971UL,
      FI_EN_ISO_639_1_ET = 25972UL,
      FI_EN_ISO_639_1_EU = 25973UL,
      FI_EN_ISO_639_1_FA = 26209UL,
      FI_EN_ISO_639_1_FF = 26214UL,
      FI_EN_ISO_639_1_FI = 26217UL,
      FI_EN_ISO_639_1_FJ = 26218UL,
      FI_EN_ISO_639_1_FO = 26223UL,
      FI_EN_ISO_639_1_FR = 26226UL,
      FI_EN_ISO_639_1_FY = 26233UL,
      FI_EN_ISO_639_1_GA = 26465UL,
      FI_EN_ISO_639_1_GD = 26468UL,
      FI_EN_ISO_639_1_GL = 26476UL,
      FI_EN_ISO_639_1_GN = 26478UL,
      FI_EN_ISO_639_1_GU = 26485UL,
      FI_EN_ISO_639_1_GV = 26486UL,
      FI_EN_ISO_639_1_HA = 26721UL,
      FI_EN_ISO_639_1_HE = 26725UL,
      FI_EN_ISO_639_1_HI = 26729UL,
      FI_EN_ISO_639_1_HO = 26735UL,
      FI_EN_ISO_639_1_HR = 26738UL,
      FI_EN_ISO_639_1_HU = 26741UL,
      FI_EN_ISO_639_1_HY = 26745UL,
      FI_EN_ISO_639_1_HZ = 26746UL,
      FI_EN_ISO_639_1_IA = 26977UL,
      FI_EN_ISO_639_1_ID = 26980UL,
      FI_EN_ISO_639_1_IE = 26981UL,
      FI_EN_ISO_639_1_IG = 26983UL,
      FI_EN_ISO_639_1_II = 26985UL,
      FI_EN_ISO_639_1_IK = 26987UL,
      FI_EN_ISO_639_1_IO = 26991UL,
      FI_EN_ISO_639_1_IS = 26995UL,
      FI_EN_ISO_639_1_IT = 26996UL,
      FI_EN_ISO_639_1_IU = 26997UL,
      FI_EN_ISO_639_1_JA = 27233UL,
      FI_EN_ISO_639_1_JV = 27254UL,
      FI_EN_ISO_639_1_KA = 27489UL,
      FI_EN_ISO_639_1_KG = 27495UL,
      FI_EN_ISO_639_1_KI = 27497UL,
      FI_EN_ISO_639_1_KJ = 27498UL,
      FI_EN_ISO_639_1_KK = 27499UL,
      FI_EN_ISO_639_1_KL = 27500UL,
      FI_EN_ISO_639_1_KM = 27501UL,
      FI_EN_ISO_639_1_KN = 27502UL,
      FI_EN_ISO_639_1_KO = 27503UL,
      FI_EN_ISO_639_1_KR = 27506UL,
      FI_EN_ISO_639_1_KS = 27507UL,
      FI_EN_ISO_639_1_KU = 27509UL,
      FI_EN_ISO_639_1_KV = 27510UL,
      FI_EN_ISO_639_1_KW = 27511UL,
      FI_EN_ISO_639_1_KY = 27513UL,
      FI_EN_ISO_639_1_LA = 27745UL,
      FI_EN_ISO_639_1_LB = 27746UL,
      FI_EN_ISO_639_1_LG = 27751UL,
      FI_EN_ISO_639_1_LI = 27753UL,
      FI_EN_ISO_639_1_LN = 27758UL,
      FI_EN_ISO_639_1_LO = 27759UL,
      FI_EN_ISO_639_1_LT = 27764UL,
      FI_EN_ISO_639_1_LU = 27765UL,
      FI_EN_ISO_639_1_LV = 27766UL,
      FI_EN_ISO_639_1_MC = 28003UL,
      FI_EN_ISO_639_1_MG = 28007UL,
      FI_EN_ISO_639_1_MH = 28008UL,
      FI_EN_ISO_639_1_MI = 28009UL,
      FI_EN_ISO_639_1_MK = 28011UL,
      FI_EN_ISO_639_1_ML = 28012UL,
      FI_EN_ISO_639_1_MN = 28014UL,
      FI_EN_ISO_639_1_MO = 28015UL,
      FI_EN_ISO_639_1_MR = 28018UL,
      FI_EN_ISO_639_1_MS = 28019UL,
      FI_EN_ISO_639_1_MT = 28020UL,
      FI_EN_ISO_639_1_MY = 28025UL,
      FI_EN_ISO_639_1_NA = 28257UL,
      FI_EN_ISO_639_1_NB = 28258UL,
      FI_EN_ISO_639_1_ND = 28260UL,
      FI_EN_ISO_639_1_NE = 28261UL,
      FI_EN_ISO_639_1_NG = 28263UL,
      FI_EN_ISO_639_1_NL = 28268UL,
      FI_EN_ISO_639_1_NN = 28270UL,
      FI_EN_ISO_639_1_NO = 28271UL,
      FI_EN_ISO_639_1_NR = 28274UL,
      FI_EN_ISO_639_1_NV = 28278UL,
      FI_EN_ISO_639_1_NY = 28281UL,
      FI_EN_ISO_639_1_OC = 28515UL,
      FI_EN_ISO_639_1_OJ = 28522UL,
      FI_EN_ISO_639_1_OM = 28525UL,
      FI_EN_ISO_639_1_OR = 28530UL,
      FI_EN_ISO_639_1_OS = 28531UL,
      FI_EN_ISO_639_1_PA = 28769UL,
      FI_EN_ISO_639_1_PI = 28777UL,
      FI_EN_ISO_639_1_PL = 28780UL,
      FI_EN_ISO_639_1_PS = 28787UL,
      FI_EN_ISO_639_1_PT = 28788UL,
      FI_EN_ISO_639_1_QU = 29045UL,
      FI_EN_ISO_639_1_RM = 29293UL,
      FI_EN_ISO_639_1_RN = 29294UL,
      FI_EN_ISO_639_1_RO = 29295UL,
      FI_EN_ISO_639_1_RT = 29300UL,
      FI_EN_ISO_639_1_RU = 29301UL,
      FI_EN_ISO_639_1_RW = 29303UL,
      FI_EN_ISO_639_1_SA = 29537UL,
      FI_EN_ISO_639_1_SB = 29538UL,
      FI_EN_ISO_639_1_SC = 29539UL,
      FI_EN_ISO_639_1_SD = 29540UL,
      FI_EN_ISO_639_1_SE = 29541UL,
      FI_EN_ISO_639_1_SG = 29543UL,
      FI_EN_ISO_639_1_SH = 29544UL,
      FI_EN_ISO_639_1_SI = 29545UL,
      FI_EN_ISO_639_1_SK = 29547UL,
      FI_EN_ISO_639_1_SL = 29548UL,
      FI_EN_ISO_639_1_SM = 29549UL,
      FI_EN_ISO_639_1_SN = 29550UL,
      FI_EN_ISO_639_1_SO = 29551UL,
      FI_EN_ISO_639_1_SQ = 29553UL,
      FI_EN_ISO_639_1_SR = 29554UL,
      FI_EN_ISO_639_1_SS = 29555UL,
      FI_EN_ISO_639_1_ST = 29556UL,
      FI_EN_ISO_639_1_SU = 29557UL,
      FI_EN_ISO_639_1_SV = 29558UL,
      FI_EN_ISO_639_1_SW = 29559UL,
      FI_EN_ISO_639_1_SX = 29560UL,
      FI_EN_ISO_639_1_TA = 29793UL,
      FI_EN_ISO_639_1_TE = 29797UL,
      FI_EN_ISO_639_1_TG = 29799UL,
      FI_EN_ISO_639_1_TH = 29800UL,
      FI_EN_ISO_639_1_TI = 29801UL,
      FI_EN_ISO_639_1_TK = 29803UL,
      FI_EN_ISO_639_1_TL = 29804UL,
      FI_EN_ISO_639_1_TN = 29806UL,
      FI_EN_ISO_639_1_TO = 29807UL,
      FI_EN_ISO_639_1_TR = 29810UL,
      FI_EN_ISO_639_1_TS = 29811UL,
      FI_EN_ISO_639_1_TT = 29812UL,
      FI_EN_ISO_639_1_TW = 29815UL,
      FI_EN_ISO_639_1_TY = 29817UL,
      FI_EN_ISO_639_1_UE = 30053UL,
      FI_EN_ISO_639_1_UG = 30055UL,
      FI_EN_ISO_639_1_UK = 30059UL,
      FI_EN_ISO_639_1_UL = 30060UL,
      FI_EN_ISO_639_1_UR = 30066UL,
      FI_EN_ISO_639_1_UZ = 30074UL,
      FI_EN_ISO_639_1_VA = 30305UL,
      FI_EN_ISO_639_1_VE = 30309UL,
      FI_EN_ISO_639_1_VI = 30313UL,
      FI_EN_ISO_639_1_VO = 30319UL,
      FI_EN_ISO_639_1_WA = 30561UL,
      FI_EN_ISO_639_1_WO = 30575UL,
      FI_EN_ISO_639_1_XH = 30824UL,
      FI_EN_ISO_639_1_YI = 31081UL,
      FI_EN_ISO_639_1_YO = 31087UL,
      FI_EN_ISO_639_1_ZA = 31329UL,
      FI_EN_ISO_639_1_ZH = 31336UL,
      FI_EN_ISO_639_1_ZL = 31340UL,
      FI_EN_ISO_639_1_ZU = 31349UL
   };
   tenType enType;

   tcu_usb_fi_tcl_e16_ISOLanguageCode(tcu_usb_fi_tcl_e16_ISOLanguageCode::tenType newValue)
      :enType(newValue)
   {}

   virtual ~tcu_usb_fi_tcl_e16_ISOLanguageCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_e16_ISOLanguageCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_LanguageID : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_LanguageID();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_LanguageID& operator=(const tcu_usb_fi_tcl_LanguageID& coRef);
   tcu_usb_fi_tcl_LanguageID(const tcu_usb_fi_tcl_LanguageID& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_e16_ISOLanguageCode ISO639_LanguageCode;
   tcu_usb_fi_tcl_e16_ISOCountryCode ISO3166_CountryCode;
   virtual ~tcu_usb_fi_tcl_LanguageID();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_LanguageID& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_u8_DirectionAbsolute : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_u8_DirectionAbsolute(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~tcu_usb_fi_tcl_u8_DirectionAbsolute();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_u8_DirectionAbsolute& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_u8_DirectionRelative : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_u8_DirectionRelative(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~tcu_usb_fi_tcl_u8_DirectionRelative();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_u8_DirectionRelative& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s16_CentiDegree : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s16_CentiDegree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~tcu_usb_fi_tcl_s16_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s16_CentiDegree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s16_Degree : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s16_Degree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~tcu_usb_fi_tcl_s16_Degree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s16_Degree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_u16_DirectionAbsolute_CentiDegree : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_u16_DirectionAbsolute_CentiDegree(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~tcu_usb_fi_tcl_u16_DirectionAbsolute_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_u16_DirectionAbsolute_CentiDegree& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_s16_DirectionRelative_CentiDegree : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_s16_DirectionRelative_CentiDegree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~tcu_usb_fi_tcl_s16_DirectionRelative_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_s16_DirectionRelative_CentiDegree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_e8_FuelType : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_e8_FuelType();
   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_PETROL = 1UL,
      FI_EN_DIESEL = 2UL,
      FI_EN_HYDROGEN = 3UL,
      FI_EN_COMPRESSEDNATURALGAS = 4UL,
      FI_EN_LIQUIFIEDPETROLEUMGAS = 5UL
   };
   tenType enType;

   tcu_usb_fi_tcl_e8_FuelType(tcu_usb_fi_tcl_e8_FuelType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~tcu_usb_fi_tcl_e8_FuelType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_e8_FuelType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_DistTimeFuel : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_DistTimeFuel();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_DistTimeFuel& operator=(const tcu_usb_fi_tcl_DistTimeFuel& coRef);
   tcu_usb_fi_tcl_DistTimeFuel(const tcu_usb_fi_tcl_DistTimeFuel& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_s32_Meter Distance;
   tcu_usb_fi_tcl_s32_Second Time;
   tcu_usb_fi_tcl_s32_Microliter Fuel;
   virtual ~tcu_usb_fi_tcl_DistTimeFuel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_DistTimeFuel& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_e16_DataConnectionError : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_e16_DataConnectionError();
   enum tenType {
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_ADDITIONAL_DOWNLOAD_FAILED = 15UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_APN_NOSPACE = 2UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_APN_SETTING_FAILED = 11UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_AUTHENTICATION_RESULT_NOTOK = 19UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_CANNOT_USE_SERVICE = 12UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_CRC32_CHECK_FAILED = 3UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_DCM_NOT_CONNECTED = 10UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTP_CONNECTION_REFUSED = 6UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_ACCEPTED = 202UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_ALREADY_REPORTED = 208UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_BAD_GATEWAY = 502UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_BAD_REQUEST = 400UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_CONFLICT = 409UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_CONTINUE = 100UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_CREATED = 201UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_EXPECTATION_FAILED = 417UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_FAILED_DEPENDENCY = 424UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_FORBIDDEN = 403UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_FOUND = 302UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_GATEWAY_TIMEOUT = 504UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_GONE = 410UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_HTTP_VERSION_NOT_SUPPORTED = 505UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_IM_USED = 226UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_INSUFFICIENT_STORAGE = 507UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_INTERNAL_SERVER_ERROR = 500UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_LENGTH_REQUIRED = 411UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_LOCKED = 423UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_LOOP_DETECTED = 508UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_METHOD_NOT_ALLOWED = 405UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_MOVED_PERMANENTLY = 301UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_MULTI_STATUS = 207UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_MULTIPLE_CHOICES = 300UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_NETWORK_AUTHENTICATION_REQUIRED = 511UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_NO_CONTENT = 204UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_NON_AUTHORITATIVE_INFORMATION = 203UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_NOT_ACCEPTABLE = 406UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_NOT_EXTENDED = 510UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_NOT_FOUND = 404UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_NOT_IMPLEMENTED = 501UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_NOT_MODIFIED = 304UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_OK = 200UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_PARTIAL_CONTENT = 206UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_PAYMENT_REQUIRED = 402UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_PERMANENT_REDIRECT = 308UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_PRECONDITION_FAILED = 412UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_PRECONDITION_REQUIRED = 428UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_PROCESSING = 102UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_PROXY_AUTHENTICATION_REQUIRED = 407UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_REQUEST_ENTITY_TOO_LARGE = 413UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_REQUEST_HEADER_FIELDS_TOO_LARGE = 431UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_REQUEST_TIMEOUT = 408UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_REQUEST_URI_TOO_LONG = 414UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_REQUESTED_RANGE_NOT_SATISFIABLE = 416UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_RESERVED = 306UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_RESET_CONTENT = 205UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_SEE_OTHER = 303UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_SERVICE_UNAVAILABLE = 503UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_SWITCHING_PROTOCOLS = 101UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_TEMPORARY_REDIRECT = 307UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_TOO_MANY_REQUESTS = 429UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_UNAUTHORIZED = 401UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_UNPROCESSABLE_ENTITY = 422UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_UNSUPPORTED_MEDIA_TYPE = 415UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_UPGRADE_REQUIRED = 426UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_USE_PROXY = 305UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_HTTPERROR_VARIANT_ALSO_NEGOTIATES = 506UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_IDLE_OR_NOERROR = 0UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_ILLEGAL_REQUEST = 13UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_INVALID_DATA = 14UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_NO_SERVICE = 9UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_PARSING_BINARYDATA_FAILED = 5UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_PARSING_JSONDATA_FAILED = 17UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_PPP_DIALING_FAILED = 8UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_PPP_DISCONNECTED_ABRUPTLY = 7UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_SOCKET_DISCONNECTED = 16UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_SOCKET_SENDING_FAILED = 18UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_UNKNOWN = 1UL,
      FI_EN_USB_TCU_DATA_CONNECTION_ERROR_UNPACK_FAILED = 4UL
   };
   tenType enType;

   tcu_usb_fi_tcl_e16_DataConnectionError(tcu_usb_fi_tcl_e16_DataConnectionError::tenType newValue)
      :enType(newValue)
   {}

   virtual ~tcu_usb_fi_tcl_e16_DataConnectionError();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_e16_DataConnectionError& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_e8_DataConnectionStatus : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_e8_DataConnectionStatus();
   enum tenType {
      FI_EN_USB_TCU_DATA_CONNECTION_STATUS_DISCONNECTED = 0UL,
      FI_EN_USB_TCU_DATA_CONNECTION_STATUS_CONNECTING = 1UL,
      FI_EN_USB_TCU_DATA_CONNECTION_STATUS_CONNECTED_IDLE = 2UL,
      FI_EN_USB_TCU_DATA_CONNECTION_STATUS_CONNECTED_DOWNLOADING = 3UL
   };
   tenType enType;

   tcu_usb_fi_tcl_e8_DataConnectionStatus(tcu_usb_fi_tcl_e8_DataConnectionStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~tcu_usb_fi_tcl_e8_DataConnectionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_e8_DataConnectionStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_e8_ServiceType : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_e8_ServiceType();
   enum tenType {
      FI_EN_USB_TCU_SERVICE_TYPE_NONE = 0UL,
      FI_EN_USB_TCU_SERVICE_TYPE_OPERATOR_DOWNLOAD = 1UL
   };
   tenType enType;

   tcu_usb_fi_tcl_e8_ServiceType(tcu_usb_fi_tcl_e8_ServiceType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~tcu_usb_fi_tcl_e8_ServiceType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_e8_ServiceType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info& operator=(const tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info& coRef);
   tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info(const tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16MaxNumberOfPOI;
   tU16 u16SearchRange;
   tU16 u16XCoordinate;
   tU16 u16YCoordinate;
   tU32 u32MeshID;
   virtual ~tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_usb_tcu_Charging_Stations_Request_Info& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_usb_tcu_POIID_List : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_usb_tcu_POIID_List();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_usb_tcu_POIID_List& operator=(const tcu_usb_fi_tcl_usb_tcu_POIID_List& coRef);
   tcu_usb_fi_tcl_usb_tcu_POIID_List(const tcu_usb_fi_tcl_usb_tcu_POIID_List& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU32, std::allocator<tU32> > POIIDList;
   virtual ~tcu_usb_fi_tcl_usb_tcu_POIID_List();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_usb_tcu_POIID_List& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info& operator=(const tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info& coRef);
   tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info(const tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CruisingDistance;
   tU16 u16Lat_second;
   tU16 u16Long_second;
   tU16 u16RemainingBatteryCapacity;
   tU8 u8CoordinateSystem;
   tU8 u8Lat_Degree;
   tU8 u8Lat_minute;
   tU8 u8Long_Degree;
   tU8 u8Long_minute;
   virtual ~tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_usb_tcu_Vacancy_Stations_Request_Info& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info& operator=(const tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info& coRef);
   tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info(const tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tclString strChannelName;
   tcu_usb_fi_tclString strChannelNameForTTS;
   tU16 u16ChannelID;
   tU8 u8FavoriteChannelListID;
   virtual ~tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List& operator=(const tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List& coRef);
   tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List(const tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info, std::allocator<tcu_usb_fi_tcl_usb_tcu_Favorite_channel_info> > FavoriteChannelInfoList;
   virtual ~tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_usb_tcu_Favorite_Feed_List& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_e8_TCU_ProbePermitSetting : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_e8_TCU_ProbePermitSetting();
   enum tenType {
      FI_EN_OFF = 0UL,
      FI_EN_ON = 1UL
   };
   tenType enType;

   tcu_usb_fi_tcl_e8_TCU_ProbePermitSetting(tcu_usb_fi_tcl_e8_TCU_ProbePermitSetting::tenType newValue)
      :enType(newValue)
   {}

   virtual ~tcu_usb_fi_tcl_e8_TCU_ProbePermitSetting();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_e8_TCU_ProbePermitSetting& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_e8_tcu_NotiResult : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_e8_tcu_NotiResult();
   enum tenType {
      FI_EN_USB_TCU_NOTI_RESULT_TYPE_FAVORITE_UPLOAD_NG = 12UL,
      FI_EN_USB_TCU_NOTI_RESULT_TYPE_FAVORITE_UPLOAD_OK = 11UL,
      FI_EN_USB_TCU_NOTI_RESULT_TYPE_RESERVED10 = 14UL,
      FI_EN_USB_TCU_NOTI_RESULT_TYPE_RESERVED1 = 0UL,
      FI_EN_USB_TCU_NOTI_RESULT_TYPE_RESERVED2 = 4UL,
      FI_EN_USB_TCU_NOTI_RESULT_TYPE_RESERVED3 = 5UL,
      FI_EN_USB_TCU_NOTI_RESULT_TYPE_RESERVED4 = 6UL,
      FI_EN_USB_TCU_NOTI_RESULT_TYPE_RESERVED5 = 7UL,
      FI_EN_USB_TCU_NOTI_RESULT_TYPE_RESERVED6 = 8UL,
      FI_EN_USB_TCU_NOTI_RESULT_TYPE_RESERVED7 = 9UL,
      FI_EN_USB_TCU_NOTI_RESULT_TYPE_RESERVED8 = 10UL,
      FI_EN_USB_TCU_NOTI_RESULT_TYPE_RESERVED9 = 13UL,
      FI_EN_USB_TCU_NOTI_RESULT_TYPE_SPOT_REGISTRATION_NG = 2UL,
      FI_EN_USB_TCU_NOTI_RESULT_TYPE_SPOT_REGISTRATION_OK = 1UL,
      FI_EN_USB_TCU_NOTI_RESULT_TYPE_SPOT_REGISTRATION_PARTLY_NG = 3UL
   };
   tenType enType;

   tcu_usb_fi_tcl_e8_tcu_NotiResult(tcu_usb_fi_tcl_e8_tcu_NotiResult::tenType newValue)
      :enType(newValue)
   {}

   virtual ~tcu_usb_fi_tcl_e8_tcu_NotiResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_e8_tcu_NotiResult& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_e8_tcu_Authentication_Result : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_e8_tcu_Authentication_Result();
   enum tenType {
      FI_EN_USB_TCU_AUTH_RESULT_TYPE_NG = 0UL,
      FI_EN_USB_TCU_AUTH_RESULT_TYPE_OK = 1UL
   };
   tenType enType;

   tcu_usb_fi_tcl_e8_tcu_Authentication_Result(tcu_usb_fi_tcl_e8_tcu_Authentication_Result::tenType newValue)
      :enType(newValue)
   {}

   virtual ~tcu_usb_fi_tcl_e8_tcu_Authentication_Result();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_e8_tcu_Authentication_Result& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data& operator=(const tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data& coRef);
   tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data(const tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > VICSResponseData;
   virtual ~tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_e8_tcu_VICS_Response_Data& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_tcu_Block_Data_List : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_tcu_Block_Data_List();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_tcu_Block_Data_List& operator=(const tcu_usb_fi_tcl_tcu_Block_Data_List& coRef);
   tcu_usb_fi_tcl_tcu_Block_Data_List(const tcu_usb_fi_tcl_tcu_Block_Data_List& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16NumberOfSecondLevelMesh;
   tU8 u8PredectedDate;
   tU16 u16PredectedDate;
   tU16 u16RequestInformationType;
   tU16 u16Reserved;
   tU8 u8InformationSourceID;
   std::vector<tU16, std::allocator<tU16> > SecondLevelMeshCoordinateList;
   virtual ~tcu_usb_fi_tcl_tcu_Block_Data_List();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_tcu_Block_Data_List& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_tcu_Japan_Location : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_tcu_Japan_Location();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_tcu_Japan_Location& operator=(const tcu_usb_fi_tcl_tcu_Japan_Location& coRef);
   tcu_usb_fi_tcl_tcu_Japan_Location(const tcu_usb_fi_tcl_tcu_Japan_Location& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16SecondLevelMesh_CoordinateId;
   tU16 u16SecondLevelMesh_XCoordinate;
   tU16 u16SecondLevelMesh_YCoordinate;
   virtual ~tcu_usb_fi_tcl_tcu_Japan_Location();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_tcu_Japan_Location& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_tcu_navigation_setting_information : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_tcu_navigation_setting_information();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_tcu_navigation_setting_information& operator=(const tcu_usb_fi_tcl_tcu_navigation_setting_information& coRef);
   tcu_usb_fi_tcl_tcu_navigation_setting_information(const tcu_usb_fi_tcl_tcu_navigation_setting_information& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_tcu_Japan_Location CurrentLocationInfo;
   tcu_usb_fi_tcl_tcu_Japan_Location DepartureInfo;
   tcu_usb_fi_tcl_tcu_Japan_Location DestinationInfo;
   tcu_usb_fi_tcl_tcu_Japan_Location ScrollPointInfo;
   tU16 u16SearchConditionInfo;
   tU16 u16VehicleDirectionInfo;
   tU8 u8InformationFlag;
   tU8 u8WaypointNumber;
   std::vector<tcu_usb_fi_tcl_tcu_Japan_Location, std::allocator<tcu_usb_fi_tcl_tcu_Japan_Location> > WaypointList;
   virtual ~tcu_usb_fi_tcl_tcu_navigation_setting_information();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_tcu_navigation_setting_information& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_json_file_path : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_json_file_path();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_json_file_path& operator=(const tcu_usb_fi_tcl_json_file_path& coRef);
   tcu_usb_fi_tcl_json_file_path(const tcu_usb_fi_tcl_json_file_path& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tclString strFilePath;
   virtual ~tcu_usb_fi_tcl_json_file_path();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_json_file_path& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_e8_tcu_LogLevel : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_e8_tcu_LogLevel();
   enum tenType {
      FI_EN_USB_TCU_LOG_LEVEL_DEBUG = 0UL,
      FI_EN_USB_TCU_LOG_LEVEL_FILE = 1UL
   };
   tenType enType;

   tcu_usb_fi_tcl_e8_tcu_LogLevel(tcu_usb_fi_tcl_e8_tcu_LogLevel::tenType newValue)
      :enType(newValue)
   {}

   virtual ~tcu_usb_fi_tcl_e8_tcu_LogLevel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_e8_tcu_LogLevel& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_e8_AutoDownloadInterval : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_e8_AutoDownloadInterval();
   enum tenType {
      FI_EN_USB_TCU_AUTO_DOWNLOAD_INTERVAL_EVERY_120_MIN = 4UL,
      FI_EN_USB_TCU_AUTO_DOWNLOAD_INTERVAL_EVERY_30_MIN = 2UL,
      FI_EN_USB_TCU_AUTO_DOWNLOAD_INTERVAL_EVERY_60_MIN = 3UL,
      FI_EN_USB_TCU_AUTO_DOWNLOAD_INTERVAL_NONE = 0UL,
      FI_EN_USB_TCU_AUTO_DOWNLOAD_INTERVAL_POWER_ON = 1UL
   };
   tenType enType;

   tcu_usb_fi_tcl_e8_AutoDownloadInterval(tcu_usb_fi_tcl_e8_AutoDownloadInterval::tenType newValue)
      :enType(newValue)
   {}

   virtual ~tcu_usb_fi_tcl_e8_AutoDownloadInterval();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_e8_AutoDownloadInterval& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_e8_ConnectedSearchServiceType : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_e8_ConnectedSearchServiceType();
   enum tenType {
      FI_EN_USB_TCU_CONNECTED_SEARCH_SERVICE_TYPE_ASSISTED_SEARCH_VIA_IVR = 2UL,
      FI_EN_USB_TCU_CONNECTED_SEARCH_SERVICE_TYPE_CONNECTED_SEARCH = 1UL,
      FI_EN_USB_TCU_CONNECTED_SEARCH_SERVICE_TYPE_NONE = 0UL
   };
   tenType enType;

   tcu_usb_fi_tcl_e8_ConnectedSearchServiceType(tcu_usb_fi_tcl_e8_ConnectedSearchServiceType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~tcu_usb_fi_tcl_e8_ConnectedSearchServiceType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_e8_ConnectedSearchServiceType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_e8_tcu_AudioActivity : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_e8_tcu_AudioActivity();
   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_PAUSE = 2UL,
      FI_EN_PLAY = 1UL,
      FI_EN_STOP = 3UL
   };
   tenType enType;

   tcu_usb_fi_tcl_e8_tcu_AudioActivity(tcu_usb_fi_tcl_e8_tcu_AudioActivity::tenType newValue)
      :enType(newValue)
   {}

   virtual ~tcu_usb_fi_tcl_e8_tcu_AudioActivity();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_e8_tcu_AudioActivity& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_e8_tcu_ExecType : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_e8_tcu_ExecType();
   enum tenType {
      FI_EN_AUTO_PLAY = 6UL,
      FI_EN_DISP_LIST = 4UL,
      FI_EN_RESERVED = 0UL,
      FI_EN_ROUTE_CALC = 2UL
   };
   tenType enType;

   tcu_usb_fi_tcl_e8_tcu_ExecType(tcu_usb_fi_tcl_e8_tcu_ExecType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~tcu_usb_fi_tcl_e8_tcu_ExecType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_e8_tcu_ExecType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_tcu_VICS_Request_Data : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_tcu_VICS_Request_Data();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_tcu_VICS_Request_Data& operator=(const tcu_usb_fi_tcl_tcu_VICS_Request_Data& coRef);
   tcu_usb_fi_tcl_tcu_VICS_Request_Data(const tcu_usb_fi_tcl_tcu_VICS_Request_Data& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_tcu_navigation_setting_information NavigationSettingInformation;
   std::vector<tcu_usb_fi_tcl_tcu_Block_Data_List, std::allocator<tcu_usb_fi_tcl_tcu_Block_Data_List> > BlockDataList;
   virtual ~tcu_usb_fi_tcl_tcu_VICS_Request_Data();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_tcu_VICS_Request_Data& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_usb_tcu_Channel_definition_information : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_usb_tcu_Channel_definition_information();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_usb_tcu_Channel_definition_information& operator=(const tcu_usb_fi_tcl_usb_tcu_Channel_definition_information& coRef);
   tcu_usb_fi_tcl_usb_tcu_Channel_definition_information(const tcu_usb_fi_tcl_usb_tcu_Channel_definition_information& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tclString strChannelName;
   tU16 u16ChannelIconID;
   tU16 u16ChannelID;
   tU16 u16FolderID;
   tU16 u16SizeOfChannelDefInfo;
   tU8 u8FixedData1;
   tU8 u8FixedData2;
   tU8 u8FixedData3;
   tU8 u8FixedData6;
   tU8 u8FixedData7;
   tU8 u8FixedData8;
   tU8 u8FixedData9;
   tU8 u8FlagOfChannelInfo;
   tU8 u8SizeOfChannelName;
   std::vector<tU8, std::allocator<tU8> > FixedData4;
   std::vector<tU8, std::allocator<tU8> > FixedData5;
   virtual ~tcu_usb_fi_tcl_usb_tcu_Channel_definition_information();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_usb_tcu_Channel_definition_information& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_usb_tcu_Channel_Info : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_usb_tcu_Channel_Info();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_usb_tcu_Channel_Info& operator=(const tcu_usb_fi_tcl_usb_tcu_Channel_Info& coRef);
   tcu_usb_fi_tcl_usb_tcu_Channel_Info(const tcu_usb_fi_tcl_usb_tcu_Channel_Info& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool u8ResumeDownload;
   tU16 u16ChannelID;
   tU8 u8ChannelContentID;
   virtual ~tcu_usb_fi_tcl_usb_tcu_Channel_Info();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_usb_tcu_Channel_Info& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_usb_tcu_Channel_Info_List : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_usb_tcu_Channel_Info_List();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_usb_tcu_Channel_Info_List& operator=(const tcu_usb_fi_tcl_usb_tcu_Channel_Info_List& coRef);
   tcu_usb_fi_tcl_usb_tcu_Channel_Info_List(const tcu_usb_fi_tcl_usb_tcu_Channel_Info_List& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tcu_usb_fi_tcl_usb_tcu_Channel_Info, std::allocator<tcu_usb_fi_tcl_usb_tcu_Channel_Info> > ChannelInfoList;
   virtual ~tcu_usb_fi_tcl_usb_tcu_Channel_Info_List();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_usb_tcu_Channel_Info_List& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_usb_tcu_channel_master_data_header : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_usb_tcu_channel_master_data_header();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_usb_tcu_channel_master_data_header& operator=(const tcu_usb_fi_tcl_usb_tcu_channel_master_data_header& coRef);
   tcu_usb_fi_tcl_usb_tcu_channel_master_data_header(const tcu_usb_fi_tcl_usb_tcu_channel_master_data_header& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16NumOfChannelDefInfo;
   tU8 u8NumOfFolderDefInfo;
   virtual ~tcu_usb_fi_tcl_usb_tcu_channel_master_data_header();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_usb_tcu_channel_master_data_header& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_usb_tcu_Folder_definition_information : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_usb_tcu_Folder_definition_information();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_usb_tcu_Folder_definition_information& operator=(const tcu_usb_fi_tcl_usb_tcu_Folder_definition_information& coRef);
   tcu_usb_fi_tcl_usb_tcu_Folder_definition_information(const tcu_usb_fi_tcl_usb_tcu_Folder_definition_information& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tclString strFolderName;
   tU16 u16FolderIconID;
   tU16 u16FolderID;
   tU16 u16SizeOfFolderDefInfo;
   tU8 u8FixedData1;
   tU8 u8FixedData2;
   tU8 u8SizeOfFolderName;
   virtual ~tcu_usb_fi_tcl_usb_tcu_Folder_definition_information();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_usb_tcu_Folder_definition_information& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_usb_tcu_Location : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_usb_tcu_Location();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_usb_tcu_Location& operator=(const tcu_usb_fi_tcl_usb_tcu_Location& coRef);
   tcu_usb_fi_tcl_usb_tcu_Location(const tcu_usb_fi_tcl_usb_tcu_Location& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16Latitude_second;
   tU16 u16Longitude_second;
   tU8 u8Direction;
   tU8 u8Latitude_degree;
   tU8 u8Latitude_minute;
   tU8 u8Longitude_Degree;
   tU8 u8Longitude_minute;
   tU8 u8Reserved;
   virtual ~tcu_usb_fi_tcl_usb_tcu_Location();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_usb_tcu_Location& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_usb_tcu_Data_Header_Part : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_usb_tcu_Data_Header_Part();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_usb_tcu_Data_Header_Part& operator=(const tcu_usb_fi_tcl_usb_tcu_Data_Header_Part& coRef);
   tcu_usb_fi_tcl_usb_tcu_Data_Header_Part(const tcu_usb_fi_tcl_usb_tcu_Data_Header_Part& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8NumOfPOI;
   virtual ~tcu_usb_fi_tcl_usb_tcu_Data_Header_Part();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_usb_tcu_Data_Header_Part& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_usb_tcu_Data_Record : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_usb_tcu_Data_Record();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_usb_tcu_Data_Record& operator=(const tcu_usb_fi_tcl_usb_tcu_Data_Record& coRef);
   tcu_usb_fi_tcl_usb_tcu_Data_Record(const tcu_usb_fi_tcl_usb_tcu_Data_Record& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_usb_tcu_Location Location;
   tcu_usb_fi_tclString strAddress;
   tcu_usb_fi_tclString strCategory;
   tcu_usb_fi_tclString strPhoneNumber;
   tcu_usb_fi_tclString strPhoneNumberForDisp;
   tcu_usb_fi_tclString strPOIName;
   tU8 u8SizeOfAddress;
   tU8 u8SizeOfCategory;
   tU8 u8SizeOfPhoneNumber;
   tU8 u8SizeOfPhoneNumberForDisp;
   tU8 u8SizeOfPOIName;
   virtual ~tcu_usb_fi_tcl_usb_tcu_Data_Record();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_usb_tcu_Data_Record& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_usb_tcu_channel_master_data : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_usb_tcu_channel_master_data();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_usb_tcu_channel_master_data& operator=(const tcu_usb_fi_tcl_usb_tcu_channel_master_data& coRef);
   tcu_usb_fi_tcl_usb_tcu_channel_master_data(const tcu_usb_fi_tcl_usb_tcu_channel_master_data& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_usb_tcu_channel_master_data_header ChannelMasterDataHeader;
   std::vector<tcu_usb_fi_tcl_usb_tcu_Channel_definition_information, std::allocator<tcu_usb_fi_tcl_usb_tcu_Channel_definition_information> > ChannelDefinitionInformation;
   std::vector<tcu_usb_fi_tcl_usb_tcu_Folder_definition_information, std::allocator<tcu_usb_fi_tcl_usb_tcu_Folder_definition_information> > FolderDefinitionInformation;
   virtual ~tcu_usb_fi_tcl_usb_tcu_channel_master_data();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_usb_tcu_channel_master_data& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info& operator=(const tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info& coRef);
   tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info(const tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tclString strNaviID;
   tcu_usb_fi_tclString strSimID;
   tcu_usb_fi_tclString strVinID;
   virtual ~tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info& operator=(const tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info& coRef);
   tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info(const tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tclString strDatum;
   tcu_usb_fi_tclString strDcmVersion;
   tcu_usb_fi_tclString strLanguage;
   tcu_usb_fi_tclString strLatitude;
   tcu_usb_fi_tclString strLongitude;
   tcu_usb_fi_tclString strMapVersion;
   tcu_usb_fi_tclString strNaviSWVersion;
   virtual ~tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_usb_tcu_GroupA_Info : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_usb_tcu_GroupA_Info();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_usb_tcu_GroupA_Info& operator=(const tcu_usb_fi_tcl_usb_tcu_GroupA_Info& coRef);
   tcu_usb_fi_tcl_usb_tcu_GroupA_Info(const tcu_usb_fi_tcl_usb_tcu_GroupA_Info& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_usb_tcu_GroupA_Authorization_Info GroupA_Authorization_Info;
   tcu_usb_fi_tcl_usb_tcu_GroupA_BasicServices_Info GroupA_BasicServices_Info;
   virtual ~tcu_usb_fi_tcl_usb_tcu_GroupA_Info();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_usb_tcu_GroupA_Info& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_usb_tcu_connected_search_result : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_usb_tcu_connected_search_result();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_usb_tcu_connected_search_result& operator=(const tcu_usb_fi_tcl_usb_tcu_connected_search_result& coRef);
   tcu_usb_fi_tcl_usb_tcu_connected_search_result(const tcu_usb_fi_tcl_usb_tcu_connected_search_result& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8NumOfPOI;
   std::vector<tcu_usb_fi_tcl_usb_tcu_Data_Record, std::allocator<tcu_usb_fi_tcl_usb_tcu_Data_Record> > DataRecord;
   virtual ~tcu_usb_fi_tcl_usb_tcu_connected_search_result();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_usb_tcu_connected_search_result& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_tcu_charging_spot_data : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_tcu_charging_spot_data();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_tcu_charging_spot_data& operator=(const tcu_usb_fi_tcl_tcu_charging_spot_data& coRef);
   tcu_usb_fi_tcl_tcu_charging_spot_data(const tcu_usb_fi_tcl_tcu_charging_spot_data& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_usb_tcu_Location Location;
   tcu_usb_fi_tclString strAreaCode1;
   tcu_usb_fi_tclString strAreaCode2;
   tcu_usb_fi_tclString strAreaCode3;
   tcu_usb_fi_tclString strAreaCode4;
   tcu_usb_fi_tclString strAreaCode5;
   tcu_usb_fi_tclString strAreaCode6;
   tcu_usb_fi_tclString strAreaCode7;
   tcu_usb_fi_tclString strAreaCode8;
   tcu_usb_fi_tclString strPOIName;
   tcu_usb_fi_tclString strStreetAndHouseNo;
   tcu_usb_fi_tclString strTelephonenumber;
   tU16 u16Categorycode;
   tU16 u16ClosedhourInformation;
   tU16 u16OpeninghourInformation;
   tU16 u16Parkingnumber;
   tU16 u16Paymenttypeinformation;
   tU16 u16Sizeofdetailinformation;
   tU16 u16Subcategorycode;
   tU32 u32POIID;
   tU32 u32UserrestrictionID;
   tU8 u8_24hoursadayinformation;
   tU8 u8Businessdayoftheweekinformation;
   tU8 u8Chargingfeeinformation;
   tU8 u8Chargingtype;
   tU8 u8Detailsinformation;
   tU8 u8Entranceinformation;
   tU8 u8Expresswaygeneraltype;
   tU8 u8Fixedvalue1;
   tU8 u8Fixedvalue2;
   tU8 u8Informationreliability;
   tU8 u8Installationfacilityinformation;
   tU8 u8Nearthefacilityinformation;
   tU8 u8Officehoursunknowninformation;
   tU8 u8Partnersfacilityinformation;
   tU8 u8SizeOfPOIName;
   tU8 u8SizeOfStreetAndHouseNo;
   tU8 u8SizeOfTelephonenumber;
   tU8 u8Thenumberofentranceinformation;
   tU8 u8Thenumberofinstallationfacilityinformation;
   tU8 u8Thenumberofpartnersfacilityinformation;
   tU8 u8Thetotalnumberofchargingtype;
   tU8 u8Userrestriction;
   virtual ~tcu_usb_fi_tcl_tcu_charging_spot_data();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_tcu_charging_spot_data& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_tcu_response_charging_spot_data_result : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_tcu_response_charging_spot_data_result();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_tcu_response_charging_spot_data_result& operator=(const tcu_usb_fi_tcl_tcu_response_charging_spot_data_result& coRef);
   tcu_usb_fi_tcl_tcu_response_charging_spot_data_result(const tcu_usb_fi_tcl_tcu_response_charging_spot_data_result& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_tcu_charging_spot_data ChargingSpotData;
   virtual ~tcu_usb_fi_tcl_tcu_response_charging_spot_data_result();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_tcu_response_charging_spot_data_result& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_tcu_charging_stations_info : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_tcu_charging_stations_info();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_tcu_charging_stations_info& operator=(const tcu_usb_fi_tcl_tcu_charging_stations_info& coRef);
   tcu_usb_fi_tcl_tcu_charging_stations_info(const tcu_usb_fi_tcl_tcu_charging_stations_info& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_usb_tcu_Location Location;
   tU32 u32POIID;
   tU32 u32POIIDVersion;
   virtual ~tcu_usb_fi_tcl_tcu_charging_stations_info();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_tcu_charging_stations_info& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_tcu_charging_stations_data : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_tcu_charging_stations_data();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_tcu_charging_stations_data& operator=(const tcu_usb_fi_tcl_tcu_charging_stations_data& coRef);
   tcu_usb_fi_tcl_tcu_charging_stations_data(const tcu_usb_fi_tcl_tcu_charging_stations_data& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32NumberOfPOIID;
   tU32 u32POIDataSetIdentificationID;
   tU8 u8POIDataSetIdentificationIDType;
   std::vector<tcu_usb_fi_tcl_tcu_charging_stations_info, std::allocator<tcu_usb_fi_tcl_tcu_charging_stations_info> > ChargingStationsInfoList;
   virtual ~tcu_usb_fi_tcl_tcu_charging_stations_data();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_tcu_charging_stations_data& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_tcu_response_charging_stations_list_result : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_tcu_response_charging_stations_list_result();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_tcu_response_charging_stations_list_result& operator=(const tcu_usb_fi_tcl_tcu_response_charging_stations_list_result& coRef);
   tcu_usb_fi_tcl_tcu_response_charging_stations_list_result(const tcu_usb_fi_tcl_tcu_response_charging_stations_list_result& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_tcu_charging_stations_data ChargingStationsData;
   virtual ~tcu_usb_fi_tcl_tcu_response_charging_stations_list_result();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_tcu_response_charging_stations_list_result& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_tcu_vacancy_stations_info : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_tcu_vacancy_stations_info();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_tcu_vacancy_stations_info& operator=(const tcu_usb_fi_tcl_tcu_vacancy_stations_info& coRef);
   tcu_usb_fi_tcl_tcu_vacancy_stations_info(const tcu_usb_fi_tcl_tcu_vacancy_stations_info& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_usb_tcu_Location Location;
   tU32 u32POIID;
   virtual ~tcu_usb_fi_tcl_tcu_vacancy_stations_info();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_tcu_vacancy_stations_info& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_tcu_vacancy_stations_data : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_tcu_vacancy_stations_data();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_tcu_vacancy_stations_data& operator=(const tcu_usb_fi_tcl_tcu_vacancy_stations_data& coRef);
   tcu_usb_fi_tcl_tcu_vacancy_stations_data(const tcu_usb_fi_tcl_tcu_vacancy_stations_data& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tcu_usb_fi_tcl_tcu_vacancy_stations_info, std::allocator<tcu_usb_fi_tcl_tcu_vacancy_stations_info> > VacancyStationsInfoList;
   virtual ~tcu_usb_fi_tcl_tcu_vacancy_stations_data();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_tcu_vacancy_stations_data& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result& operator=(const tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result& coRef);
   tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result(const tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_tcu_vacancy_stations_data VacancyStationsData;
   virtual ~tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_tcu_response_vacancy_stations_list_result& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_tcu_vacancy_spot_data : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_tcu_vacancy_spot_data();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_tcu_vacancy_spot_data& operator=(const tcu_usb_fi_tcl_tcu_vacancy_spot_data& coRef);
   tcu_usb_fi_tcl_tcu_vacancy_spot_data(const tcu_usb_fi_tcl_tcu_vacancy_spot_data& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_usb_tcu_Location Location;
   tcu_usb_fi_tclString strAreaCode1;
   tcu_usb_fi_tclString strAreaCode2;
   tcu_usb_fi_tclString strAreaCode3;
   tcu_usb_fi_tclString strAreaCode4;
   tcu_usb_fi_tclString strAreaCode5;
   tcu_usb_fi_tclString strAreaCode6;
   tcu_usb_fi_tclString strAreaCode7;
   tcu_usb_fi_tclString strAreaCode8;
   tcu_usb_fi_tclString strPOIName;
   tcu_usb_fi_tclString strStreetAndHouseNo;
   tcu_usb_fi_tclString strTelephonenumber;
   tU16 u16Categorycode;
   tU16 u16ClosedhourInformation;
   tU16 u16OpeninghourInformation;
   tU16 u16Parkingnumber;
   tU16 u16Paymenttypeinformation;
   tU16 u16Sizeofdetailinformation;
   tU16 u16Subcategorycode;
   tU32 u32POIID;
   tU32 u32UserrestrictionID;
   tU8 u8_24hoursadayinformation;
   tU8 u8Businessdayoftheweekinformation;
   tU8 u8Chargingfeeinformation;
   tU8 u8Chargingtype;
   tU8 u8Detailsinformation;
   tU8 u8Entranceinformation;
   tU8 u8Expresswaygeneraltype;
   tU8 u8Fixedvalue1;
   tU8 u8Fixedvalue2;
   tU8 u8Informationreliability;
   tU8 u8Installationfacilityinformation;
   tU8 u8Nearthefacilityinformation;
   tU8 u8Officehoursunknowninformation;
   tU8 u8Partnersfacilityinformation;
   tU8 u8SizeOfPOIName;
   tU8 u8SizeOfStreetAndHouseNo;
   tU8 u8SizeOfTelephonenumber;
   tU8 u8Thenumberofentranceinformation;
   tU8 u8Thenumberofinstallationfacilityinformation;
   tU8 u8Thenumberofpartnersfacilityinformation;
   tU8 u8Thetotalnumberofchargingtype;
   tU8 u8Userrestriction;
   virtual ~tcu_usb_fi_tcl_tcu_vacancy_spot_data();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_tcu_vacancy_spot_data& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result& operator=(const tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result& coRef);
   tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result(const tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_tcu_vacancy_spot_data VacancySpotData;
   virtual ~tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_tcu_response_vacancy_spot_data_result& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_usb_tcu_Server_Info : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_usb_tcu_Server_Info();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_usb_tcu_Server_Info& operator=(const tcu_usb_fi_tcl_usb_tcu_Server_Info& coRef);
   tcu_usb_fi_tcl_usb_tcu_Server_Info(const tcu_usb_fi_tcl_usb_tcu_Server_Info& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tclString strServerAddress;
   tcu_usb_fi_tclString strServerName;
   tU8 u8ServerId;
   virtual ~tcu_usb_fi_tcl_usb_tcu_Server_Info();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_usb_tcu_Server_Info& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_usb_tcu_Server_Info_List : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_usb_tcu_Server_Info_List();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_usb_tcu_Server_Info_List& operator=(const tcu_usb_fi_tcl_usb_tcu_Server_Info_List& coRef);
   tcu_usb_fi_tcl_usb_tcu_Server_Info_List(const tcu_usb_fi_tcl_usb_tcu_Server_Info_List& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tcu_usb_fi_tcl_usb_tcu_Server_Info, std::allocator<tcu_usb_fi_tcl_usb_tcu_Server_Info> > ServerInfoList;
   virtual ~tcu_usb_fi_tcl_usb_tcu_Server_Info_List();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_usb_tcu_Server_Info_List& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_e8_ModemType : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_e8_ModemType();
   enum tenType {
      FI_EN_2_9G = 3UL,
      FI_EN_2G = 1UL,
      FI_EN_3G = 2UL,
      FI_EN_UNKNOWN = 0UL
   };
   tenType enType;

   tcu_usb_fi_tcl_e8_ModemType(tcu_usb_fi_tcl_e8_ModemType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~tcu_usb_fi_tcl_e8_ModemType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_e8_ModemType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info& operator=(const tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info& coRef);
   tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info(const tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tcl_e8_ModemType eModemType;
   tBool bUSBConnectionStatus;
   virtual ~tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_usb_tcu_TCUDevice_Info& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_e8_DatabaseServiceType : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_e8_DatabaseServiceType();
   enum tenType {
      FI_EN_USB_TCU_DATABASE_SERVICE_TYPE_AUTO_CHANNEL_DOWNLOAD = 12UL,
      FI_EN_USB_TCU_DATABASE_SERVICE_TYPE_CHANNEL_DATA = 2UL,
      FI_EN_USB_TCU_DATABASE_SERVICE_TYPE_CHANNEL_MASTER_DATA = 1UL,
      FI_EN_USB_TCU_DATABASE_SERVICE_TYPE_DELETE_DB = 4UL,
      FI_EN_USB_TCU_DATABASE_SERVICE_TYPE_DELETE_INFO_HISTORY = 10UL,
      FI_EN_USB_TCU_DATABASE_SERVICE_TYPE_DELETE_MESSAGE_BOX = 7UL,
      FI_EN_USB_TCU_DATABASE_SERVICE_TYPE_FAVORITECHANNELLIST = 9UL,
      FI_EN_USB_TCU_DATABASE_SERVICE_TYPE_IN_VEHICLE_MESSAGE = 3UL,
      FI_EN_USB_TCU_DATABASE_SERVICE_TYPE_INITIALIZE_FEED_LIST = 8UL,
      FI_EN_USB_TCU_DATABASE_SERVICE_TYPE_MOBILE_INFO_SERVICE = 5UL,
      FI_EN_USB_TCU_DATABASE_SERVICE_TYPE_MY_SCHEDULE = 6UL,
      FI_EN_USB_TCU_DATABASE_SERVICE_TYPE_OPERATOR_CHANNEL_DOWNLOAD = 11UL,
      FI_EN_USB_TCU_DATABASE_SERVICE_TYPE_UNKNOWN = 0UL
   };
   tenType enType;

   tcu_usb_fi_tcl_e8_DatabaseServiceType(tcu_usb_fi_tcl_e8_DatabaseServiceType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~tcu_usb_fi_tcl_e8_DatabaseServiceType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_e8_DatabaseServiceType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_e8_DatabaseStatus : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_e8_DatabaseStatus();
   enum tenType {
      FI_EN_DATABASE_STATUS_DELETING_IFL = 7UL,
      FI_EN_DATABASE_STATUS_DELETING_MSB = 6UL,
      FI_EN_DATABASE_STATUS_DELETING = 5UL,
      FI_EN_DATABASE_STATUS_DISABLED = 4UL,
      FI_EN_DATABASE_STATUS_ERROR = 8UL,
      FI_EN_DATABASE_STATUS_READY = 3UL,
      FI_EN_DATABASE_STATUS_UNKNOWN = 0UL,
      FI_EN_DATABASE_STATUS_UPDATING = 2UL,
      FI_EN_DATABASE_STATUS_VERIFYING = 1UL
   };
   tenType enType;

   tcu_usb_fi_tcl_e8_DatabaseStatus(tcu_usb_fi_tcl_e8_DatabaseStatus::tenType newValue)
      :enType(newValue)
   {}

   virtual ~tcu_usb_fi_tcl_e8_DatabaseStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_e8_DatabaseStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_e8_CancelRequestType : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_e8_CancelRequestType();
   enum tenType {
      FI_EN_USB_TCU_CANCEL_REQUEST_TYPE_CONNECTED_SEARCH = 1UL,
      FI_EN_USB_TCU_CANCEL_REQUEST_TYPE_DESTINATION_SEND_TO_CAR = 4UL,
      FI_EN_USB_TCU_CANCEL_REQUEST_TYPE_GOOGLE_SEND_TO_CAR = 3UL,
      FI_EN_USB_TCU_CANCEL_REQUEST_TYPE_IN_VEHICLE_MESSAGE = 6UL,
      FI_EN_USB_TCU_CANCEL_REQUEST_TYPE_JOURNEY_PLANNER = 5UL,
      FI_EN_USB_TCU_CANCEL_REQUEST_TYPE_MOBILE_INFO_SERVICE = 8UL,
      FI_EN_USB_TCU_CANCEL_REQUEST_TYPE_MY_SCHEDULE = 9UL,
      FI_EN_USB_TCU_CANCEL_REQUEST_TYPE_NONE = 0UL,
      FI_EN_USB_TCU_CANCEL_REQUEST_TYPE_SYNC_ALL_FEEDS = 7UL,
      FI_EN_USB_TCU_CANCEL_REQUEST_TYPE_VOICE_MENU = 2UL
   };
   tenType enType;

   tcu_usb_fi_tcl_e8_CancelRequestType(tcu_usb_fi_tcl_e8_CancelRequestType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~tcu_usb_fi_tcl_e8_CancelRequestType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_e8_CancelRequestType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_e8_UserAuthenticationResultType : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_e8_UserAuthenticationResultType();
   enum tenType {
      FI_EN_USB_TCU_USER_AUTHENTICATION_RESULT_SUCCESS = 0UL,
      FI_EN_USB_TCU_USER_AUTHENTICATION_RESULT_INVALID_CREDENTIALS = 1UL,
      FI_EN_USB_TCU_USER_AUTHENTICATION_RESULT_TOKEN_EXPIRED = 2UL,
      FI_EN_USB_TCU_USER_AUTHENTICATION_RESULT_INVALID_TOKEN_KEY_OR_DATA = 3UL,
      FI_EN_USB_TCU_USER_AUTHENTICATION_RESULT_RESPONSE_PARSING_ERROR = 4UL,
      FI_EN_USB_TCU_USER_AUTHENTICATION_RESULT_CONNECTION_TIMEOUT = 5UL,
      FI_EN_USB_TCU_USER_AUTHENTICATION_RESULT_CONNECTION_REJECTED = 6UL,
      FI_EN_USB_TCU_USER_AUTHENTICATION_RESULT_NO_CONNECTION = 7UL,
      FI_EN_USB_TCU_USER_AUTHENTICATION_RESULT_CLIENT_AUTHENTICATION_FAILED = 8UL,
      FI_EN_USB_TCU_USER_AUTHENTICATION_RESULT_INVALID_REQUEST = 9UL,
      FI_EN_USB_TCU_USER_AUTHENTICATION_RESULT_UNEXPECTED_ERROR = 10UL,
      FI_EN_USB_TCU_USER_AUTHENTICATION_RESULT_NO_STORED_TOKEN = 11UL
   };
   tenType enType;

   tcu_usb_fi_tcl_e8_UserAuthenticationResultType(tcu_usb_fi_tcl_e8_UserAuthenticationResultType::tenType newValue)
      :enType(newValue)
   {}

   virtual ~tcu_usb_fi_tcl_e8_UserAuthenticationResultType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_e8_UserAuthenticationResultType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info& operator=(const tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info& coRef);
   tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info(const tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tcu_usb_fi_tclString KID;
   virtual ~tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const tcu_usb_fi_tcl_usb_tcu_UserAuthentication_DecodedToken_Info& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

class tcu_usb_fi_tcl_e8_tcu_Regions : public tcu_usb_fi_tclVisitableTypeBase
{
public:

   tcu_usb_fi_tcl_e8_tcu_Regions();
   enum tenType {
      FI_EN_REGION_AGT = 14UL,
      FI_EN_REGION_AZR_NZE = 12UL,
      FI_EN_REGION_BRA = 13UL,
      FI_EN_REGION_BRN = 20UL,
      FI_EN_REGION_CAN = 1UL,
      FI_EN_REGION_EGP = 11UL,
      FI_EN_REGION_GCC = 10UL,
      FI_EN_REGION_HKG_MACAU = 9UL,
      FI_EN_REGION_IND = 24UL,
      FI_EN_REGION_INN = 21UL,
      FI_EN_REGION_INVALID = 255UL,
      FI_EN_REGION_JPN = 25UL,
      FI_EN_REGION_KOR = 26UL,
      FI_EN_REGION_MEX = 2UL,
      FI_EN_REGION_MLY = 19UL,
      FI_EN_REGION_OTHER_EUR = 6UL,
      FI_EN_REGION_OTHER_GOM = 27UL,
      FI_EN_REGION_OTHER_LAC = 15UL,
      FI_EN_REGION_PHL = 23UL,
      FI_EN_REGION_PRC = 7UL,
      FI_EN_REGION_RUS = 5UL,
      FI_EN_REGION_SAF = 16UL,
      FI_EN_REGION_SGP = 18UL,
      FI_EN_REGION_THI = 17UL,
      FI_EN_REGION_TKY = 4UL,
      FI_EN_REGION_TWN = 8UL,
      FI_EN_REGION_UK = 3UL,
      FI_EN_REGION_US = 0UL,
      FI_EN_REGION_VNM = 22UL
   };
   tenType enType;

   tcu_usb_fi_tcl_e8_tcu_Regions(tcu_usb_fi_tcl_e8_tcu_Regions::tenType newValue)
      :enType(newValue)
   {}

   virtual ~tcu_usb_fi_tcl_e8_tcu_Regions();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const tcu_usb_fi_tcl_e8_tcu_Regions& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(tcu_usb_fi_tclVisitorBase& rfoVisitor);
};

#endif
