#ifndef SYNCDISPLAY_MAINFILANGUAGE_HEADER
#define SYNCDISPLAY_MAINFILANGUAGE_HEADER

class syncdisplay_mainfi_tclInContext;
class syncdisplay_mainfi_tclOutContext;
class syncdisplay_mainfi_tclVisitorBase;

class MY_DECL syncdisplay_mainfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  syncdisplay_mainfi_tclDescription(fi_tclInContext* poIn, syncdisplay_mainfi_tclVisitorBase* poVisit);
  syncdisplay_mainfi_tclDescription(fi_tclOutContext* poOut, syncdisplay_mainfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(syncdisplay_mainfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(syncdisplay_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ syncdisplay_mainfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  syncdisplay_mainfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<syncdisplay_mainfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<syncdisplay_mainfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline syncdisplay_mainfi_tclDescription::syncdisplay_mainfi_tclDescription(fi_tclInContext* poIn, syncdisplay_mainfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline syncdisplay_mainfi_tclDescription::syncdisplay_mainfi_tclDescription(fi_tclOutContext* poOut, syncdisplay_mainfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

