#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define SYNCDISPLAY_FI_S_IMPORT_INTERFACE_SYNCDISPLAY_MAINFI_STDVISITORS
#include "syncdisplay_fi_if.h"

tBool syncdisplay_mainfi_tclDescription::bInitMessage(syncdisplay_mainfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case syncdisplay_mainfi_tclToken::EN_LAST_TOKEN:
   case syncdisplay_mainfi_tclToken::EN_LIST:
   case syncdisplay_mainfi_tclToken::EN_END_OF_STRUCT:
   case syncdisplay_mainfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case syncdisplay_mainfi_tclToken::EN_MSG_SETFIRSTSCREENREADYMETHODSTART:
   {
      bResult = oPath.bGoDown(syncdisplay_mainfi_tclKnot(syncdisplay_mainfi_tclToken::EN_U8,syncdisplay_mainfi_tclSemanticDomain::EN_MSG_T_TU8_SCREENTYPE)) && bResult;
   } break;
   case syncdisplay_mainfi_tclToken::EN_MSG_SETANIMATIONRUNMETHODSTART:
   {
      bResult = oPath.bGoDown(syncdisplay_mainfi_tclKnot(syncdisplay_mainfi_tclToken::EN_U8,syncdisplay_mainfi_tclSemanticDomain::EN_MSG_T_TU8_PLAYRUN)) && bResult;
   } break;
   case syncdisplay_mainfi_tclToken::EN_MSG_SETANIMATIONSTOPMETHODSTART:
   {
      bResult = oPath.bGoDown(syncdisplay_mainfi_tclKnot(syncdisplay_mainfi_tclToken::EN_U8,syncdisplay_mainfi_tclSemanticDomain::EN_MSG_T_TU8_PLAYSTOP)) && bResult;
   } break;
   case syncdisplay_mainfi_tclToken::EN_MSG_EARLYVIDEOLAYERSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(syncdisplay_mainfi_tclKnot(syncdisplay_mainfi_tclToken::EN_E8_EARLYVIDEOLAYER_STATUS,syncdisplay_mainfi_tclSemanticDomain::EN_MSG_EEARLYVIDEOLAYERSTATUS)) && bResult;
   } break;
   case syncdisplay_mainfi_tclToken::EN_MSG_ANIMATIONSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(syncdisplay_mainfi_tclKnot(syncdisplay_mainfi_tclToken::EN_E8_ANIMATION_STATUS,syncdisplay_mainfi_tclSemanticDomain::EN_MSG_T_E8_ANIMATION_STATUS)) && bResult;
   } break;
   case syncdisplay_mainfi_tclToken::EN_MSG_SETFIRSTSCREENREADYMETHODRESULT:
   case syncdisplay_mainfi_tclToken::EN_MSG_SETANIMATIONRUNMETHODRESULT:
   case syncdisplay_mainfi_tclToken::EN_MSG_SETANIMATIONSTOPMETHODRESULT:
   case syncdisplay_mainfi_tclToken::EN_MSG_EARLYVIDEOLAYERSTATUSUPREG:
   case syncdisplay_mainfi_tclToken::EN_MSG_EARLYVIDEOLAYERSTATUSRELUPREG:
   case syncdisplay_mainfi_tclToken::EN_MSG_EARLYVIDEOLAYERSTATUSGET:
   case syncdisplay_mainfi_tclToken::EN_MSG_ANIMATIONSTATUSUPREG:
   case syncdisplay_mainfi_tclToken::EN_MSG_ANIMATIONSTATUSRELUPREG:
   case syncdisplay_mainfi_tclToken::EN_MSG_ANIMATIONSTATUSGET:
   case syncdisplay_mainfi_tclToken::EN_BINCONTAINER:
   case syncdisplay_mainfi_tclToken::EN_E8_EARLYVIDEOLAYER_STATUS:
   case syncdisplay_mainfi_tclToken::EN_E8_ANIMATION_STATUS:
   case syncdisplay_mainfi_tclToken::EN_U8:   
   case syncdisplay_mainfi_tclToken::EN_S8:   
   case syncdisplay_mainfi_tclToken::EN_U16:   
   case syncdisplay_mainfi_tclToken::EN_S16:   
   case syncdisplay_mainfi_tclToken::EN_U24:   
   case syncdisplay_mainfi_tclToken::EN_S24:   
   case syncdisplay_mainfi_tclToken::EN_U32:   
   case syncdisplay_mainfi_tclToken::EN_S32:   
   case syncdisplay_mainfi_tclToken::EN_U64:   
   case syncdisplay_mainfi_tclToken::EN_S64:   
   case syncdisplay_mainfi_tclToken::EN_F32:   
   case syncdisplay_mainfi_tclToken::EN_F64:   
   case syncdisplay_mainfi_tclToken::EN_BOOL:   
   case syncdisplay_mainfi_tclToken::EN_STRING:   
   case syncdisplay_mainfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(syncdisplay_mainfi_tclKnot(enMsgToken,syncdisplay_mainfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool syncdisplay_mainfi_tclDescription::bDoIt(syncdisplay_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool syncdisplay_mainfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      syncdisplay_mainfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      syncdisplay_mainfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      syncdisplay_mainfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == syncdisplay_mainfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(syncdisplay_mainfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(syncdisplay_mainfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(syncdisplay_mainfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case syncdisplay_mainfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == syncdisplay_mainfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case syncdisplay_mainfi_tclToken::EN_LIST: 
      {
         syncdisplay_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            syncdisplay_mainfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(syncdisplay_mainfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            syncdisplay_mainfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(syncdisplay_mainfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case syncdisplay_mainfi_tclToken::EN_U8: 
      {
         syncdisplay_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case syncdisplay_mainfi_tclToken::EN_U16: 
      {
         syncdisplay_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case syncdisplay_mainfi_tclToken::EN_U24: 
      {
         syncdisplay_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case syncdisplay_mainfi_tclToken::EN_U32: 
      {
         syncdisplay_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case syncdisplay_mainfi_tclToken::EN_U64: 
      {
         syncdisplay_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case syncdisplay_mainfi_tclToken::EN_S8: 
      {
         syncdisplay_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case syncdisplay_mainfi_tclToken::EN_S16: 
      {
         syncdisplay_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case syncdisplay_mainfi_tclToken::EN_S24: 
      {
         syncdisplay_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case syncdisplay_mainfi_tclToken::EN_S32: 
      {
         syncdisplay_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case syncdisplay_mainfi_tclToken::EN_S64: 
      {
         syncdisplay_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case syncdisplay_mainfi_tclToken::EN_F32: 
      {
         syncdisplay_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case syncdisplay_mainfi_tclToken::EN_F64: 
      {
         syncdisplay_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case syncdisplay_mainfi_tclToken::EN_BOOL: 
      {
         syncdisplay_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case syncdisplay_mainfi_tclToken::EN_STRING: 
      {
         syncdisplay_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case syncdisplay_mainfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         syncdisplay_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case syncdisplay_mainfi_tclToken::EN_MSG_SETFIRSTSCREENREADYMETHODSTART:
      case syncdisplay_mainfi_tclToken::EN_MSG_SETFIRSTSCREENREADYMETHODRESULT:
      case syncdisplay_mainfi_tclToken::EN_MSG_SETANIMATIONRUNMETHODSTART:
      case syncdisplay_mainfi_tclToken::EN_MSG_SETANIMATIONRUNMETHODRESULT:
      case syncdisplay_mainfi_tclToken::EN_MSG_SETANIMATIONSTOPMETHODSTART:
      case syncdisplay_mainfi_tclToken::EN_MSG_SETANIMATIONSTOPMETHODRESULT:
      case syncdisplay_mainfi_tclToken::EN_MSG_EARLYVIDEOLAYERSTATUSUPREG:
      case syncdisplay_mainfi_tclToken::EN_MSG_EARLYVIDEOLAYERSTATUSRELUPREG:
      case syncdisplay_mainfi_tclToken::EN_MSG_EARLYVIDEOLAYERSTATUSGET:
      case syncdisplay_mainfi_tclToken::EN_MSG_EARLYVIDEOLAYERSTATUSSTATUS:
      case syncdisplay_mainfi_tclToken::EN_MSG_ANIMATIONSTATUSUPREG:
      case syncdisplay_mainfi_tclToken::EN_MSG_ANIMATIONSTATUSRELUPREG:
      case syncdisplay_mainfi_tclToken::EN_MSG_ANIMATIONSTATUSGET:
      case syncdisplay_mainfi_tclToken::EN_MSG_ANIMATIONSTATUSSTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case syncdisplay_mainfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(syncdisplay_mainfi_tclKnot(syncdisplay_mainfi_tclToken::EN_END_OF_STRUCT,syncdisplay_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(syncdisplay_mainfi_tclKnot(syncdisplay_mainfi_tclToken::EN_U8,syncdisplay_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(syncdisplay_mainfi_tclKnot(syncdisplay_mainfi_tclToken::EN_LIST,syncdisplay_mainfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         syncdisplay_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case syncdisplay_mainfi_tclToken::EN_E8_EARLYVIDEOLAYER_STATUS:
      {
         syncdisplay_fi_tcl_e8_EarlyVideoLayer_Status o_e8_EarlyVideoLayer_Status;
         if (!bDoIt(o_e8_EarlyVideoLayer_Status))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case syncdisplay_mainfi_tclToken::EN_E8_ANIMATION_STATUS:
      {
         syncdisplay_fi_tcl_e8_Animation_Status o_e8_Animation_Status;
         if (!bDoIt(o_e8_Animation_Status))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case syncdisplay_mainfi_tclToken::EN_UNKNOWN:
      case syncdisplay_mainfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

