#ifndef SWITCHCTRL_FIVISITOR_HEADER
#define SWITCHCTRL_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class switchctrl_fi_tclOutput {
public:
   switchctrl_fi_tclOutput();
   virtual ~switchctrl_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class switchctrl_fi_tclFileOutput : public switchctrl_fi_tclOutput 
{
public:
   switchctrl_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   switchctrl_fi_tclFileOutput(); //lint !e1704
   switchctrl_fi_tclFileOutput& operator=(const switchctrl_fi_tclFileOutput& coRef);
   switchctrl_fi_tclFileOutput(const switchctrl_fi_tclFileOutput& coRef); //lint !e1704
};

class switchctrl_fi_tclMemOutput : public switchctrl_fi_tclOutput
{
public:
   switchctrl_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~switchctrl_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   switchctrl_fi_tclMemOutput(); //lint !e1704
   switchctrl_fi_tclMemOutput(const switchctrl_fi_tclMemOutput& coRef); //lint !e1704
   switchctrl_fi_tclMemOutput& operator=(const switchctrl_fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL switchctrl_fi_tclVisitorBase {
public:

   // --Konstruktor
   switchctrl_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~switchctrl_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(switchctrl_fi_tclU8& oU8);
   virtual tVoid vVisitS8(switchctrl_fi_tclS8& oS8);
   virtual tVoid vVisitU16(switchctrl_fi_tclU16& oU16);
   virtual tVoid vVisitS16(switchctrl_fi_tclS16& oS16);
   virtual tVoid vVisitU24(switchctrl_fi_tclU24& oU24);
   virtual tVoid vVisitS24(switchctrl_fi_tclS24& oS24);
   virtual tVoid vVisitU32(switchctrl_fi_tclU32& oU32);
   virtual tVoid vVisitS32(switchctrl_fi_tclS32& oS32);
   virtual tVoid vVisitU64(switchctrl_fi_tclU64& oU64);
   virtual tVoid vVisitS64(switchctrl_fi_tclS64& oS64);
   virtual tVoid vVisitF32(switchctrl_fi_tclF32& oF32);
   virtual tVoid vVisitF64(switchctrl_fi_tclF64& oF64);
   virtual tVoid vVisitBool(switchctrl_fi_tclBool& oBool);
   virtual tVoid vVisitString(switchctrl_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(switchctrl_fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(switchctrl_fi_tclList& oList);
   virtual tVoid vVisit_BinContainer(switchctrl_fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_Reserved(switchctrl_fi_tcl_Reserved& oReserved);

   virtual tVoid vVisit_u8_Percent(switchctrl_fi_tcl_u8_Percent& ou8_Percent);

   virtual tVoid vVisit_s16_PerThousand(switchctrl_fi_tcl_s16_PerThousand& os16_PerThousand);

   virtual tVoid vVisit_u16_IndexInReferenceList(switchctrl_fi_tcl_u16_IndexInReferenceList& ou16_IndexInReferenceList);

   virtual tVoid vVisit_u16_ErrorCode(switchctrl_fi_tcl_u16_ErrorCode& ou16_ErrorCode);

   virtual tVoid vVisit_u16_RPM(switchctrl_fi_tcl_u16_RPM& ou16_RPM);

   virtual tVoid vVisit_s32_Kilogram(switchctrl_fi_tcl_s32_Kilogram& os32_Kilogram);

   virtual tVoid vVisit_s32_Pound(switchctrl_fi_tcl_s32_Pound& os32_Pound);

   virtual tVoid vVisit_s16_Meter(switchctrl_fi_tcl_s16_Meter& os16_Meter);

   virtual tVoid vVisit_s32_Meter(switchctrl_fi_tcl_s32_Meter& os32_Meter);

   virtual tVoid vVisit_s32_Yards(switchctrl_fi_tcl_s32_Yards& os32_Yards);

   virtual tVoid vVisit_s32_Foot(switchctrl_fi_tcl_s32_Foot& os32_Foot);

   virtual tVoid vVisit_s32_Centimeter(switchctrl_fi_tcl_s32_Centimeter& os32_Centimeter);

   virtual tVoid vVisit_s32_Inch(switchctrl_fi_tcl_s32_Inch& os32_Inch);

   virtual tVoid vVisit_s32_Millimeter(switchctrl_fi_tcl_s32_Millimeter& os32_Millimeter);

   virtual tVoid vVisit_s32_Microliter(switchctrl_fi_tcl_s32_Microliter& os32_Microliter);

   virtual tVoid vVisit_s32_Second(switchctrl_fi_tcl_s32_Second& os32_Second);

   virtual tVoid vVisit_u16_MilliSecond(switchctrl_fi_tcl_u16_MilliSecond& ou16_MilliSecond);

   virtual tVoid vVisit_s32_MilliSecond(switchctrl_fi_tcl_s32_MilliSecond& os32_MilliSecond);

   virtual tVoid vVisit_POSIXTime(switchctrl_fi_tcl_POSIXTime& oPOSIXTime);

   virtual tVoid vVisit_e8_DST_State(switchctrl_fi_tcl_e8_DST_State& oe8_DST_State);

   virtual tVoid vVisit_TimeZoneElement(switchctrl_fi_tcl_TimeZoneElement& oTimeZoneElement);

   virtual tVoid vVisit_s16_KmPerHour(switchctrl_fi_tcl_s16_KmPerHour& os16_KmPerHour);

   virtual tVoid vVisit_s16_MilesPerHour(switchctrl_fi_tcl_s16_MilesPerHour& os16_MilesPerHour);

   virtual tVoid vVisit_s16_Knot(switchctrl_fi_tcl_s16_Knot& os16_Knot);

   virtual tVoid vVisit_s16_CentimeterSecond(switchctrl_fi_tcl_s16_CentimeterSecond& os16_CentimeterSecond);

   virtual tVoid vVisit_s16_Kelvin(switchctrl_fi_tcl_s16_Kelvin& os16_Kelvin);

   virtual tVoid vVisit_s16_Fahrenheit(switchctrl_fi_tcl_s16_Fahrenheit& os16_Fahrenheit);

   virtual tVoid vVisit_s32_Pascal(switchctrl_fi_tcl_s32_Pascal& os32_Pascal);

   virtual tVoid vVisit_s32_Watt(switchctrl_fi_tcl_s32_Watt& os32_Watt);

   virtual tVoid vVisit_FIVersion(switchctrl_fi_tcl_FIVersion& oFIVersion);

   virtual tVoid vVisit_s32_Longitude(switchctrl_fi_tcl_s32_Longitude& os32_Longitude);

   virtual tVoid vVisit_s32_Latitude(switchctrl_fi_tcl_s32_Latitude& os32_Latitude);

   virtual tVoid vVisit_PositionWGS84(switchctrl_fi_tcl_PositionWGS84& oPositionWGS84);

   virtual tVoid vVisit_RectangleWGS84(switchctrl_fi_tcl_RectangleWGS84& oRectangleWGS84);

   virtual tVoid vVisit_e16_ISOCountryCode(switchctrl_fi_tcl_e16_ISOCountryCode& oe16_ISOCountryCode);

   virtual tVoid vVisit_e16_ISOLanguageCode(switchctrl_fi_tcl_e16_ISOLanguageCode& oe16_ISOLanguageCode);

   virtual tVoid vVisit_LanguageID(switchctrl_fi_tcl_LanguageID& oLanguageID);

   virtual tVoid vVisit_u8_DirectionAbsolute(switchctrl_fi_tcl_u8_DirectionAbsolute& ou8_DirectionAbsolute);

   virtual tVoid vVisit_u8_DirectionRelative(switchctrl_fi_tcl_u8_DirectionRelative& ou8_DirectionRelative);

   virtual tVoid vVisit_s16_CentiDegree(switchctrl_fi_tcl_s16_CentiDegree& os16_CentiDegree);

   virtual tVoid vVisit_s16_Degree(switchctrl_fi_tcl_s16_Degree& os16_Degree);

   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(switchctrl_fi_tcl_u16_DirectionAbsolute_CentiDegree& ou16_DirectionAbsolute_CentiDegree);

   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(switchctrl_fi_tcl_s16_DirectionRelative_CentiDegree& os16_DirectionRelative_CentiDegree);

   virtual tVoid vVisit_e8_FuelType(switchctrl_fi_tcl_e8_FuelType& oe8_FuelType);

   virtual tVoid vVisit_DistTimeFuel(switchctrl_fi_tcl_DistTimeFuel& oDistTimeFuel);

   virtual tVoid vVisit_e8_MCanUnitType(switchctrl_fi_tcl_e8_MCanUnitType& oe8_MCanUnitType);

   virtual tVoid vVisit_SwCtrl_ConnectionStatus(switchctrl_fi_tcl_SwCtrl_ConnectionStatus& oSwCtrl_ConnectionStatus);

   virtual tVoid vVisit_SwitchCtrl_VersionInfo(switchctrl_fi_tcl_SwitchCtrl_VersionInfo& oSwitchCtrl_VersionInfo);

   virtual tVoid vVisit_SwitchCtrl_UnitVersion(switchctrl_fi_tcl_SwitchCtrl_UnitVersion& oSwitchCtrl_UnitVersion);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
