/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define SWITCHCTRL_FI_S_IMPORT_INTERFACE_SWITCHCTRL_MAINFI_TYPES
#define SWITCHCTRL_FI_S_IMPORT_INTERFACE_SWITCHCTRL_MAINFI_FUNCTIONIDS
#define SWITCHCTRL_FI_S_IMPORT_INTERFACE_SWITCHCTRL_MAINFI_SERVICEINFO
#include "switchctrl_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for switchctrl_main_fi message types

fi_tclMessageBase* switchctrl_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case switchctrl_mainfi_tclToken::EN_MSG_RESETHISTORYMETHODSTART:
         return OSAL_NEW switchctrl_mainfi_tclMsgResetHistoryMethodStart;

      case switchctrl_mainfi_tclToken::EN_MSG_RESETHISTORYMETHODRESULT:
         return OSAL_NEW switchctrl_mainfi_tclMsgResetHistoryMethodResult;

      case switchctrl_mainfi_tclToken::EN_MSG_VERSIONINFOMETHODSTART:
         return OSAL_NEW switchctrl_mainfi_tclMsgVersionInfoMethodStart;

      case switchctrl_mainfi_tclToken::EN_MSG_VERSIONINFOMETHODRESULT:
         return OSAL_NEW switchctrl_mainfi_tclMsgVersionInfoMethodResult;

      case switchctrl_mainfi_tclToken::EN_MSG_BEEPINFOMETHODSTART:
         return OSAL_NEW switchctrl_mainfi_tclMsgBeepInfoMethodStart;

      case switchctrl_mainfi_tclToken::EN_MSG_BEEPINFOMETHODRESULT:
         return OSAL_NEW switchctrl_mainfi_tclMsgBeepInfoMethodResult;

      case switchctrl_mainfi_tclToken::EN_MSG_REARSEAT_CONNECTIONUPREG:
         return OSAL_NEW switchctrl_mainfi_tclMsgRearSeat_ConnectionUpReg;

      case switchctrl_mainfi_tclToken::EN_MSG_REARSEAT_CONNECTIONRELUPREG:
         return OSAL_NEW switchctrl_mainfi_tclMsgRearSeat_ConnectionRelUpReg;

      case switchctrl_mainfi_tclToken::EN_MSG_REARSEAT_CONNECTIONGET:
         return OSAL_NEW switchctrl_mainfi_tclMsgRearSeat_ConnectionGet;

      case switchctrl_mainfi_tclToken::EN_MSG_REARSEAT_CONNECTIONSTATUS:
         return OSAL_NEW switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus;

      case switchctrl_mainfi_tclToken::EN_MSG_ITCOMMANDER_CONNECTIONUPREG:
         return OSAL_NEW switchctrl_mainfi_tclMsgITCommander_ConnectionUpReg;

      case switchctrl_mainfi_tclToken::EN_MSG_ITCOMMANDER_CONNECTIONRELUPREG:
         return OSAL_NEW switchctrl_mainfi_tclMsgITCommander_ConnectionRelUpReg;

      case switchctrl_mainfi_tclToken::EN_MSG_ITCOMMANDER_CONNECTIONGET:
         return OSAL_NEW switchctrl_mainfi_tclMsgITCommander_ConnectionGet;

      case switchctrl_mainfi_tclToken::EN_MSG_ITCOMMANDER_CONNECTIONSTATUS:
         return OSAL_NEW switchctrl_mainfi_tclMsgITCommander_ConnectionStatus;

      case switchctrl_mainfi_tclToken::EN_MSG_HARDWAREVERSIONUPREG:
         return OSAL_NEW switchctrl_mainfi_tclMsgHardwareVersionUpReg;

      case switchctrl_mainfi_tclToken::EN_MSG_HARDWAREVERSIONRELUPREG:
         return OSAL_NEW switchctrl_mainfi_tclMsgHardwareVersionRelUpReg;

      case switchctrl_mainfi_tclToken::EN_MSG_HARDWAREVERSIONGET:
         return OSAL_NEW switchctrl_mainfi_tclMsgHardwareVersionGet;

      case switchctrl_mainfi_tclToken::EN_MSG_HARDWAREVERSIONSTATUS:
         return OSAL_NEW switchctrl_mainfi_tclMsgHardwareVersionStatus;

      case switchctrl_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONUPREG:
         return OSAL_NEW switchctrl_mainfi_tclMsgSoftwareVersionUpReg;

      case switchctrl_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONRELUPREG:
         return OSAL_NEW switchctrl_mainfi_tclMsgSoftwareVersionRelUpReg;

      case switchctrl_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONGET:
         return OSAL_NEW switchctrl_mainfi_tclMsgSoftwareVersionGet;

      case switchctrl_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONSTATUS:
         return OSAL_NEW switchctrl_mainfi_tclMsgSoftwareVersionStatus;

      case switchctrl_mainfi_tclToken::EN_MSG_PRIMARYINTEGRATEDSWITCH_CONNECTIONUPREG:
         return OSAL_NEW switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionUpReg;

      case switchctrl_mainfi_tclToken::EN_MSG_PRIMARYINTEGRATEDSWITCH_CONNECTIONRELUPREG:
         return OSAL_NEW switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionRelUpReg;

      case switchctrl_mainfi_tclToken::EN_MSG_PRIMARYINTEGRATEDSWITCH_CONNECTIONGET:
         return OSAL_NEW switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionGet;

      case switchctrl_mainfi_tclToken::EN_MSG_PRIMARYINTEGRATEDSWITCH_CONNECTIONSTATUS:
         return OSAL_NEW switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all switchctrl_mainfifi messages

// common functions

tU16 switchctrl_mainfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return SWITCHCTRL_MAINFI_C_U16_SERVICE_ID;
}

tU16 switchctrl_mainfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 switchctrl_mainfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& switchctrl_mainfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& switchctrl_mainfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 switchctrl_mainfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& switchctrl_mainfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& switchctrl_mainfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

switchctrl_mainfi_tclMsgResetHistoryMethodStart::switchctrl_mainfi_tclMsgResetHistoryMethodStart()
 {}

tS32 switchctrl_mainfi_tclMsgResetHistoryMethodStart::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_RESETHISTORYMETHODSTART;
}


switchctrl_mainfi_tclMsgResetHistoryMethodStart::~switchctrl_mainfi_tclMsgResetHistoryMethodStart()
{}

//=============================================================================

switchctrl_mainfi_tclMsgResetHistoryMethodResult::switchctrl_mainfi_tclMsgResetHistoryMethodResult()
 {}

tS32 switchctrl_mainfi_tclMsgResetHistoryMethodResult::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_RESETHISTORYMETHODRESULT;
}


switchctrl_mainfi_tclMsgResetHistoryMethodResult::~switchctrl_mainfi_tclMsgResetHistoryMethodResult()
{}

//=============================================================================

switchctrl_mainfi_tclMsgVersionInfoMethodStart::switchctrl_mainfi_tclMsgVersionInfoMethodStart()
 {}

tS32 switchctrl_mainfi_tclMsgVersionInfoMethodStart::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_VERSIONINFOMETHODSTART;
}


switchctrl_mainfi_tclMsgVersionInfoMethodStart::~switchctrl_mainfi_tclMsgVersionInfoMethodStart()
{}

//=============================================================================

switchctrl_mainfi_tclMsgVersionInfoMethodResult::switchctrl_mainfi_tclMsgVersionInfoMethodResult()
 {}

tS32 switchctrl_mainfi_tclMsgVersionInfoMethodResult::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_VERSIONINFOMETHODRESULT;
}


switchctrl_mainfi_tclMsgVersionInfoMethodResult::~switchctrl_mainfi_tclMsgVersionInfoMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
switchctrl_mainfi_tclMsgBeepInfoMethodStart::switchctrl_mainfi_tclMsgBeepInfoMethodStart(const switchctrl_mainfi_tclMsgBeepInfoMethodStart& coRef)
   : switchctrl_mainfi_tclMsgBaseMessage(coRef)
{
   u8NoOfBeeps = coRef.u8NoOfBeeps;
   u8BeepTime = coRef.u8BeepTime;
   u8Period = coRef.u8Period;
}
switchctrl_mainfi_tclMsgBeepInfoMethodStart& switchctrl_mainfi_tclMsgBeepInfoMethodStart::operator=(const switchctrl_mainfi_tclMsgBeepInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8NoOfBeeps = coRef.u8NoOfBeeps;
   u8BeepTime = coRef.u8BeepTime;
   u8Period = coRef.u8Period;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

switchctrl_mainfi_tclMsgBeepInfoMethodStart::switchctrl_mainfi_tclMsgBeepInfoMethodStart()
:u8NoOfBeeps(0)
,u8BeepTime(0)
,u8Period(0)
 {}

tS32 switchctrl_mainfi_tclMsgBeepInfoMethodStart::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_BEEPINFOMETHODSTART;
}


switchctrl_mainfi_tclMsgBeepInfoMethodStart::~switchctrl_mainfi_tclMsgBeepInfoMethodStart()
{}

tU32 switchctrl_mainfi_tclMsgBeepInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& switchctrl_mainfi_tclMsgBeepInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8NoOfBeeps);
   (tVoid) (oIn >> u8BeepTime);
   (tVoid) (oIn >> u8Period);
   return oIn;
}

fi_tclOutContext& switchctrl_mainfi_tclMsgBeepInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8NoOfBeeps);
   (tVoid) (oOut << u8BeepTime);
   (tVoid) (oOut << u8Period);
   return oOut;
}

tBool switchctrl_mainfi_tclMsgBeepInfoMethodStart::operator==(const switchctrl_mainfi_tclMsgBeepInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8NoOfBeeps == roRef.u8NoOfBeeps);
   bResult = bResult && (u8BeepTime == roRef.u8BeepTime);
   bResult = bResult && (u8Period == roRef.u8Period);
   return bResult;
}

//=============================================================================

switchctrl_mainfi_tclMsgBeepInfoMethodResult::switchctrl_mainfi_tclMsgBeepInfoMethodResult()
 {}

tS32 switchctrl_mainfi_tclMsgBeepInfoMethodResult::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_BEEPINFOMETHODRESULT;
}


switchctrl_mainfi_tclMsgBeepInfoMethodResult::~switchctrl_mainfi_tclMsgBeepInfoMethodResult()
{}

//=============================================================================

switchctrl_mainfi_tclMsgRearSeat_ConnectionUpReg::switchctrl_mainfi_tclMsgRearSeat_ConnectionUpReg()
 {}

tS32 switchctrl_mainfi_tclMsgRearSeat_ConnectionUpReg::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_REARSEAT_CONNECTIONUPREG;
}


switchctrl_mainfi_tclMsgRearSeat_ConnectionUpReg::~switchctrl_mainfi_tclMsgRearSeat_ConnectionUpReg()
{}

//=============================================================================

switchctrl_mainfi_tclMsgRearSeat_ConnectionRelUpReg::switchctrl_mainfi_tclMsgRearSeat_ConnectionRelUpReg()
 {}

tS32 switchctrl_mainfi_tclMsgRearSeat_ConnectionRelUpReg::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_REARSEAT_CONNECTIONRELUPREG;
}


switchctrl_mainfi_tclMsgRearSeat_ConnectionRelUpReg::~switchctrl_mainfi_tclMsgRearSeat_ConnectionRelUpReg()
{}

//=============================================================================

switchctrl_mainfi_tclMsgRearSeat_ConnectionGet::switchctrl_mainfi_tclMsgRearSeat_ConnectionGet()
 {}

tS32 switchctrl_mainfi_tclMsgRearSeat_ConnectionGet::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_REARSEAT_CONNECTIONGET;
}


switchctrl_mainfi_tclMsgRearSeat_ConnectionGet::~switchctrl_mainfi_tclMsgRearSeat_ConnectionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus::switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus(const switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus& coRef)
   : switchctrl_mainfi_tclMsgBaseMessage(coRef)
{
   RSCConnectionStatus = coRef.RSCConnectionStatus;
}
switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus& switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus::operator=(const switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus& coRef)
{
   if (this == &coRef) return *this;
   RSCConnectionStatus = coRef.RSCConnectionStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus::switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus()
:RSCConnectionStatus()
 {}

tS32 switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_REARSEAT_CONNECTIONSTATUS;
}


switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus::~switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus()
{}

tU32 switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RSCConnectionStatus);
   return oIn;
}

fi_tclOutContext& switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RSCConnectionStatus);
   return oOut;
}

tBool switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus::operator==(const switchctrl_mainfi_tclMsgRearSeat_ConnectionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RSCConnectionStatus == roRef.RSCConnectionStatus);
   return bResult;
}

//=============================================================================

switchctrl_mainfi_tclMsgITCommander_ConnectionUpReg::switchctrl_mainfi_tclMsgITCommander_ConnectionUpReg()
 {}

tS32 switchctrl_mainfi_tclMsgITCommander_ConnectionUpReg::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_ITCOMMANDER_CONNECTIONUPREG;
}


switchctrl_mainfi_tclMsgITCommander_ConnectionUpReg::~switchctrl_mainfi_tclMsgITCommander_ConnectionUpReg()
{}

//=============================================================================

switchctrl_mainfi_tclMsgITCommander_ConnectionRelUpReg::switchctrl_mainfi_tclMsgITCommander_ConnectionRelUpReg()
 {}

tS32 switchctrl_mainfi_tclMsgITCommander_ConnectionRelUpReg::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_ITCOMMANDER_CONNECTIONRELUPREG;
}


switchctrl_mainfi_tclMsgITCommander_ConnectionRelUpReg::~switchctrl_mainfi_tclMsgITCommander_ConnectionRelUpReg()
{}

//=============================================================================

switchctrl_mainfi_tclMsgITCommander_ConnectionGet::switchctrl_mainfi_tclMsgITCommander_ConnectionGet()
 {}

tS32 switchctrl_mainfi_tclMsgITCommander_ConnectionGet::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_ITCOMMANDER_CONNECTIONGET;
}


switchctrl_mainfi_tclMsgITCommander_ConnectionGet::~switchctrl_mainfi_tclMsgITCommander_ConnectionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
switchctrl_mainfi_tclMsgITCommander_ConnectionStatus::switchctrl_mainfi_tclMsgITCommander_ConnectionStatus(const switchctrl_mainfi_tclMsgITCommander_ConnectionStatus& coRef)
   : switchctrl_mainfi_tclMsgBaseMessage(coRef)
{
   ITCommConnStatus = coRef.ITCommConnStatus;
}
switchctrl_mainfi_tclMsgITCommander_ConnectionStatus& switchctrl_mainfi_tclMsgITCommander_ConnectionStatus::operator=(const switchctrl_mainfi_tclMsgITCommander_ConnectionStatus& coRef)
{
   if (this == &coRef) return *this;
   ITCommConnStatus = coRef.ITCommConnStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

switchctrl_mainfi_tclMsgITCommander_ConnectionStatus::switchctrl_mainfi_tclMsgITCommander_ConnectionStatus()
:ITCommConnStatus()
 {}

tS32 switchctrl_mainfi_tclMsgITCommander_ConnectionStatus::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_ITCOMMANDER_CONNECTIONSTATUS;
}


switchctrl_mainfi_tclMsgITCommander_ConnectionStatus::~switchctrl_mainfi_tclMsgITCommander_ConnectionStatus()
{}

tU32 switchctrl_mainfi_tclMsgITCommander_ConnectionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& switchctrl_mainfi_tclMsgITCommander_ConnectionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ITCommConnStatus);
   return oIn;
}

fi_tclOutContext& switchctrl_mainfi_tclMsgITCommander_ConnectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ITCommConnStatus);
   return oOut;
}

tBool switchctrl_mainfi_tclMsgITCommander_ConnectionStatus::operator==(const switchctrl_mainfi_tclMsgITCommander_ConnectionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ITCommConnStatus == roRef.ITCommConnStatus);
   return bResult;
}

//=============================================================================

switchctrl_mainfi_tclMsgHardwareVersionUpReg::switchctrl_mainfi_tclMsgHardwareVersionUpReg()
 {}

tS32 switchctrl_mainfi_tclMsgHardwareVersionUpReg::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_HARDWAREVERSIONUPREG;
}


switchctrl_mainfi_tclMsgHardwareVersionUpReg::~switchctrl_mainfi_tclMsgHardwareVersionUpReg()
{}

//=============================================================================

switchctrl_mainfi_tclMsgHardwareVersionRelUpReg::switchctrl_mainfi_tclMsgHardwareVersionRelUpReg()
 {}

tS32 switchctrl_mainfi_tclMsgHardwareVersionRelUpReg::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_HARDWAREVERSIONRELUPREG;
}


switchctrl_mainfi_tclMsgHardwareVersionRelUpReg::~switchctrl_mainfi_tclMsgHardwareVersionRelUpReg()
{}

//=============================================================================

switchctrl_mainfi_tclMsgHardwareVersionGet::switchctrl_mainfi_tclMsgHardwareVersionGet()
 {}

tS32 switchctrl_mainfi_tclMsgHardwareVersionGet::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_HARDWAREVERSIONGET;
}


switchctrl_mainfi_tclMsgHardwareVersionGet::~switchctrl_mainfi_tclMsgHardwareVersionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
switchctrl_mainfi_tclMsgHardwareVersionStatus::switchctrl_mainfi_tclMsgHardwareVersionStatus(const switchctrl_mainfi_tclMsgHardwareVersionStatus& coRef)
   : switchctrl_mainfi_tclMsgBaseMessage(coRef)
{
   arHardwareVersionList = coRef.arHardwareVersionList;
}
switchctrl_mainfi_tclMsgHardwareVersionStatus& switchctrl_mainfi_tclMsgHardwareVersionStatus::operator=(const switchctrl_mainfi_tclMsgHardwareVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   arHardwareVersionList = coRef.arHardwareVersionList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid switchctrl_mainfi_tclMsgHardwareVersionStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < arHardwareVersionList.size(); ++u32Idx)
         arHardwareVersionList[u32Idx].vDestroy();
   arHardwareVersionList.clear();
   }
}

switchctrl_mainfi_tclMsgHardwareVersionStatus::switchctrl_mainfi_tclMsgHardwareVersionStatus()

 {}

tS32 switchctrl_mainfi_tclMsgHardwareVersionStatus::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_HARDWAREVERSIONSTATUS;
}


switchctrl_mainfi_tclMsgHardwareVersionStatus::~switchctrl_mainfi_tclMsgHardwareVersionStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 switchctrl_mainfi_tclMsgHardwareVersionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(arHardwareVersionList.size()*4);
}

fi_tclInContext& switchctrl_mainfi_tclMsgHardwareVersionStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arHardwareVersionList.size(); ++u32Idx)
      {
         arHardwareVersionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arHardwareVersionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arHardwareVersionList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& switchctrl_mainfi_tclMsgHardwareVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)arHardwareVersionList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arHardwareVersionList.size(); ++u32Idx)
         (tVoid) (oOut << arHardwareVersionList[u32Idx]);
   }
   return oOut;
}

tBool switchctrl_mainfi_tclMsgHardwareVersionStatus::operator==(const switchctrl_mainfi_tclMsgHardwareVersionStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (arHardwareVersionList.size() == roRef.arHardwareVersionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arHardwareVersionList.size()); ++u32Idx)
            bResult = bResult && (arHardwareVersionList[u32Idx] == roRef.arHardwareVersionList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

switchctrl_mainfi_tclMsgSoftwareVersionUpReg::switchctrl_mainfi_tclMsgSoftwareVersionUpReg()
 {}

tS32 switchctrl_mainfi_tclMsgSoftwareVersionUpReg::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONUPREG;
}


switchctrl_mainfi_tclMsgSoftwareVersionUpReg::~switchctrl_mainfi_tclMsgSoftwareVersionUpReg()
{}

//=============================================================================

switchctrl_mainfi_tclMsgSoftwareVersionRelUpReg::switchctrl_mainfi_tclMsgSoftwareVersionRelUpReg()
 {}

tS32 switchctrl_mainfi_tclMsgSoftwareVersionRelUpReg::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONRELUPREG;
}


switchctrl_mainfi_tclMsgSoftwareVersionRelUpReg::~switchctrl_mainfi_tclMsgSoftwareVersionRelUpReg()
{}

//=============================================================================

switchctrl_mainfi_tclMsgSoftwareVersionGet::switchctrl_mainfi_tclMsgSoftwareVersionGet()
 {}

tS32 switchctrl_mainfi_tclMsgSoftwareVersionGet::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONGET;
}


switchctrl_mainfi_tclMsgSoftwareVersionGet::~switchctrl_mainfi_tclMsgSoftwareVersionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
switchctrl_mainfi_tclMsgSoftwareVersionStatus::switchctrl_mainfi_tclMsgSoftwareVersionStatus(const switchctrl_mainfi_tclMsgSoftwareVersionStatus& coRef)
   : switchctrl_mainfi_tclMsgBaseMessage(coRef)
{
   arSoftwareVersionList = coRef.arSoftwareVersionList;
}
switchctrl_mainfi_tclMsgSoftwareVersionStatus& switchctrl_mainfi_tclMsgSoftwareVersionStatus::operator=(const switchctrl_mainfi_tclMsgSoftwareVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   arSoftwareVersionList = coRef.arSoftwareVersionList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid switchctrl_mainfi_tclMsgSoftwareVersionStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < arSoftwareVersionList.size(); ++u32Idx)
         arSoftwareVersionList[u32Idx].vDestroy();
   arSoftwareVersionList.clear();
   }
}

switchctrl_mainfi_tclMsgSoftwareVersionStatus::switchctrl_mainfi_tclMsgSoftwareVersionStatus()

 {}

tS32 switchctrl_mainfi_tclMsgSoftwareVersionStatus::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONSTATUS;
}


switchctrl_mainfi_tclMsgSoftwareVersionStatus::~switchctrl_mainfi_tclMsgSoftwareVersionStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 switchctrl_mainfi_tclMsgSoftwareVersionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(arSoftwareVersionList.size()*4);
}

fi_tclInContext& switchctrl_mainfi_tclMsgSoftwareVersionStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arSoftwareVersionList.size(); ++u32Idx)
      {
         arSoftwareVersionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arSoftwareVersionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arSoftwareVersionList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& switchctrl_mainfi_tclMsgSoftwareVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)arSoftwareVersionList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arSoftwareVersionList.size(); ++u32Idx)
         (tVoid) (oOut << arSoftwareVersionList[u32Idx]);
   }
   return oOut;
}

tBool switchctrl_mainfi_tclMsgSoftwareVersionStatus::operator==(const switchctrl_mainfi_tclMsgSoftwareVersionStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (arSoftwareVersionList.size() == roRef.arSoftwareVersionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arSoftwareVersionList.size()); ++u32Idx)
            bResult = bResult && (arSoftwareVersionList[u32Idx] == roRef.arSoftwareVersionList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionUpReg::switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionUpReg()
 {}

tS32 switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionUpReg::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_PRIMARYINTEGRATEDSWITCH_CONNECTIONUPREG;
}


switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionUpReg::~switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionUpReg()
{}

//=============================================================================

switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionRelUpReg::switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionRelUpReg()
 {}

tS32 switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionRelUpReg::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_PRIMARYINTEGRATEDSWITCH_CONNECTIONRELUPREG;
}


switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionRelUpReg::~switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionRelUpReg()
{}

//=============================================================================

switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionGet::switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionGet()
 {}

tS32 switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionGet::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_PRIMARYINTEGRATEDSWITCH_CONNECTIONGET;
}


switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionGet::~switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionStatus::switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionStatus(const switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionStatus& coRef)
   : switchctrl_mainfi_tclMsgBaseMessage(coRef)
{
   PrimarySwitchConnStatus = coRef.PrimarySwitchConnStatus;
}
switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionStatus& switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionStatus::operator=(const switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionStatus& coRef)
{
   if (this == &coRef) return *this;
   PrimarySwitchConnStatus = coRef.PrimarySwitchConnStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionStatus::switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionStatus()
:PrimarySwitchConnStatus()
 {}

tS32 switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionStatus::s32GetTypeId() const
{
   return (tS32) switchctrl_mainfi_tclToken::EN_MSG_PRIMARYINTEGRATEDSWITCH_CONNECTIONSTATUS;
}


switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionStatus::~switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionStatus()
{}

tU32 switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PrimarySwitchConnStatus);
   return oIn;
}

fi_tclOutContext& switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PrimarySwitchConnStatus);
   return oOut;
}

tBool switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionStatus::operator==(const switchctrl_mainfi_tclMsgPrimaryIntegratedSwitch_ConnectionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PrimarySwitchConnStatus == roRef.PrimarySwitchConnStatus);
   return bResult;
}

