#ifndef SWITCHCTRL_MAINFILANGUAGE_HEADER
#define SWITCHCTRL_MAINFILANGUAGE_HEADER

class switchctrl_mainfi_tclInContext;
class switchctrl_mainfi_tclOutContext;
class switchctrl_mainfi_tclVisitorBase;

class MY_DECL switchctrl_mainfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  switchctrl_mainfi_tclDescription(fi_tclInContext* poIn, switchctrl_mainfi_tclVisitorBase* poVisit);
  switchctrl_mainfi_tclDescription(fi_tclOutContext* poOut, switchctrl_mainfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(switchctrl_mainfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(switchctrl_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ switchctrl_mainfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  switchctrl_mainfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<switchctrl_mainfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<switchctrl_mainfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline switchctrl_mainfi_tclDescription::switchctrl_mainfi_tclDescription(fi_tclInContext* poIn, switchctrl_mainfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline switchctrl_mainfi_tclDescription::switchctrl_mainfi_tclDescription(fi_tclOutContext* poOut, switchctrl_mainfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

