#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define SWITCHCTRL_FI_S_IMPORT_INTERFACE_SWITCHCTRL_MAINFI_STDVISITORS
#include "switchctrl_fi_if.h"

tBool switchctrl_mainfi_tclDescription::bInitMessage(switchctrl_mainfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case switchctrl_mainfi_tclToken::EN_LAST_TOKEN:
   case switchctrl_mainfi_tclToken::EN_LIST:
   case switchctrl_mainfi_tclToken::EN_END_OF_STRUCT:
   case switchctrl_mainfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case switchctrl_mainfi_tclToken::EN_MSG_BEEPINFOMETHODSTART:
   {
      bResult = oPath.bGoDown(switchctrl_mainfi_tclKnot(switchctrl_mainfi_tclToken::EN_U8,switchctrl_mainfi_tclSemanticDomain::EN_MSG_U8PERIOD)) && bResult;
      bResult = oPath.bGoDown(switchctrl_mainfi_tclKnot(switchctrl_mainfi_tclToken::EN_U8,switchctrl_mainfi_tclSemanticDomain::EN_MSG_U8BEEPTIME)) && bResult;
      bResult = oPath.bGoDown(switchctrl_mainfi_tclKnot(switchctrl_mainfi_tclToken::EN_U8,switchctrl_mainfi_tclSemanticDomain::EN_MSG_U8NOOFBEEPS)) && bResult;
   } break;
   case switchctrl_mainfi_tclToken::EN_MSG_REARSEAT_CONNECTIONSTATUS:
   {
      bResult = oPath.bGoDown(switchctrl_mainfi_tclKnot(switchctrl_mainfi_tclToken::EN_SWCTRL_CONNECTIONSTATUS,switchctrl_mainfi_tclSemanticDomain::EN_MSG_RSCCONNECTIONSTATUS)) && bResult;
   } break;
   case switchctrl_mainfi_tclToken::EN_MSG_ITCOMMANDER_CONNECTIONSTATUS:
   {
      bResult = oPath.bGoDown(switchctrl_mainfi_tclKnot(switchctrl_mainfi_tclToken::EN_SWCTRL_CONNECTIONSTATUS,switchctrl_mainfi_tclSemanticDomain::EN_MSG_ITCOMMCONNSTATUS)) && bResult;
   } break;
   case switchctrl_mainfi_tclToken::EN_MSG_HARDWAREVERSIONSTATUS:
   {
      bResult = oPath.bGoDown(switchctrl_mainfi_tclKnot(switchctrl_mainfi_tclToken::EN_SWITCHCTRL_UNITVERSION,switchctrl_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(switchctrl_mainfi_tclKnot(switchctrl_mainfi_tclToken::EN_LIST,switchctrl_mainfi_tclSemanticDomain::EN_MSG_ARHARDWAREVERSIONLIST)) && bResult;
   } break;
   case switchctrl_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONSTATUS:
   {
      bResult = oPath.bGoDown(switchctrl_mainfi_tclKnot(switchctrl_mainfi_tclToken::EN_SWITCHCTRL_UNITVERSION,switchctrl_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(switchctrl_mainfi_tclKnot(switchctrl_mainfi_tclToken::EN_LIST,switchctrl_mainfi_tclSemanticDomain::EN_MSG_ARSOFTWAREVERSIONLIST)) && bResult;
   } break;
   case switchctrl_mainfi_tclToken::EN_MSG_PRIMARYINTEGRATEDSWITCH_CONNECTIONSTATUS:
   {
      bResult = oPath.bGoDown(switchctrl_mainfi_tclKnot(switchctrl_mainfi_tclToken::EN_SWCTRL_CONNECTIONSTATUS,switchctrl_mainfi_tclSemanticDomain::EN_MSG_PRIMARYSWITCHCONNSTATUS)) && bResult;
   } break;
   case switchctrl_mainfi_tclToken::EN_MSG_RESETHISTORYMETHODSTART:
   case switchctrl_mainfi_tclToken::EN_MSG_RESETHISTORYMETHODRESULT:
   case switchctrl_mainfi_tclToken::EN_MSG_VERSIONINFOMETHODSTART:
   case switchctrl_mainfi_tclToken::EN_MSG_VERSIONINFOMETHODRESULT:
   case switchctrl_mainfi_tclToken::EN_MSG_BEEPINFOMETHODRESULT:
   case switchctrl_mainfi_tclToken::EN_MSG_REARSEAT_CONNECTIONUPREG:
   case switchctrl_mainfi_tclToken::EN_MSG_REARSEAT_CONNECTIONRELUPREG:
   case switchctrl_mainfi_tclToken::EN_MSG_REARSEAT_CONNECTIONGET:
   case switchctrl_mainfi_tclToken::EN_MSG_ITCOMMANDER_CONNECTIONUPREG:
   case switchctrl_mainfi_tclToken::EN_MSG_ITCOMMANDER_CONNECTIONRELUPREG:
   case switchctrl_mainfi_tclToken::EN_MSG_ITCOMMANDER_CONNECTIONGET:
   case switchctrl_mainfi_tclToken::EN_MSG_HARDWAREVERSIONUPREG:
   case switchctrl_mainfi_tclToken::EN_MSG_HARDWAREVERSIONRELUPREG:
   case switchctrl_mainfi_tclToken::EN_MSG_HARDWAREVERSIONGET:
   case switchctrl_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONUPREG:
   case switchctrl_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONRELUPREG:
   case switchctrl_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONGET:
   case switchctrl_mainfi_tclToken::EN_MSG_PRIMARYINTEGRATEDSWITCH_CONNECTIONUPREG:
   case switchctrl_mainfi_tclToken::EN_MSG_PRIMARYINTEGRATEDSWITCH_CONNECTIONRELUPREG:
   case switchctrl_mainfi_tclToken::EN_MSG_PRIMARYINTEGRATEDSWITCH_CONNECTIONGET:
   case switchctrl_mainfi_tclToken::EN_BINCONTAINER:
   case switchctrl_mainfi_tclToken::EN_E8_MCANUNITTYPE:
   case switchctrl_mainfi_tclToken::EN_SWCTRL_CONNECTIONSTATUS:
   case switchctrl_mainfi_tclToken::EN_SWITCHCTRL_VERSIONINFO:
   case switchctrl_mainfi_tclToken::EN_SWITCHCTRL_UNITVERSION:
   case switchctrl_mainfi_tclToken::EN_U8:   
   case switchctrl_mainfi_tclToken::EN_S8:   
   case switchctrl_mainfi_tclToken::EN_U16:   
   case switchctrl_mainfi_tclToken::EN_S16:   
   case switchctrl_mainfi_tclToken::EN_U24:   
   case switchctrl_mainfi_tclToken::EN_S24:   
   case switchctrl_mainfi_tclToken::EN_U32:   
   case switchctrl_mainfi_tclToken::EN_S32:   
   case switchctrl_mainfi_tclToken::EN_U64:   
   case switchctrl_mainfi_tclToken::EN_S64:   
   case switchctrl_mainfi_tclToken::EN_F32:   
   case switchctrl_mainfi_tclToken::EN_F64:   
   case switchctrl_mainfi_tclToken::EN_BOOL:   
   case switchctrl_mainfi_tclToken::EN_STRING:   
   case switchctrl_mainfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(switchctrl_mainfi_tclKnot(enMsgToken,switchctrl_mainfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool switchctrl_mainfi_tclDescription::bDoIt(switchctrl_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool switchctrl_mainfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      switchctrl_mainfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      switchctrl_mainfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      switchctrl_mainfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == switchctrl_mainfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(switchctrl_mainfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(switchctrl_mainfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(switchctrl_mainfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case switchctrl_mainfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == switchctrl_mainfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case switchctrl_mainfi_tclToken::EN_LIST: 
      {
         switchctrl_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            switchctrl_mainfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(switchctrl_mainfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            switchctrl_mainfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(switchctrl_mainfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case switchctrl_mainfi_tclToken::EN_U8: 
      {
         switchctrl_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case switchctrl_mainfi_tclToken::EN_U16: 
      {
         switchctrl_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case switchctrl_mainfi_tclToken::EN_U24: 
      {
         switchctrl_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case switchctrl_mainfi_tclToken::EN_U32: 
      {
         switchctrl_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case switchctrl_mainfi_tclToken::EN_U64: 
      {
         switchctrl_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case switchctrl_mainfi_tclToken::EN_S8: 
      {
         switchctrl_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case switchctrl_mainfi_tclToken::EN_S16: 
      {
         switchctrl_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case switchctrl_mainfi_tclToken::EN_S24: 
      {
         switchctrl_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case switchctrl_mainfi_tclToken::EN_S32: 
      {
         switchctrl_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case switchctrl_mainfi_tclToken::EN_S64: 
      {
         switchctrl_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case switchctrl_mainfi_tclToken::EN_F32: 
      {
         switchctrl_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case switchctrl_mainfi_tclToken::EN_F64: 
      {
         switchctrl_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case switchctrl_mainfi_tclToken::EN_BOOL: 
      {
         switchctrl_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case switchctrl_mainfi_tclToken::EN_STRING: 
      {
         switchctrl_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case switchctrl_mainfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         switchctrl_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case switchctrl_mainfi_tclToken::EN_MSG_RESETHISTORYMETHODSTART:
      case switchctrl_mainfi_tclToken::EN_MSG_RESETHISTORYMETHODRESULT:
      case switchctrl_mainfi_tclToken::EN_MSG_VERSIONINFOMETHODSTART:
      case switchctrl_mainfi_tclToken::EN_MSG_VERSIONINFOMETHODRESULT:
      case switchctrl_mainfi_tclToken::EN_MSG_BEEPINFOMETHODSTART:
      case switchctrl_mainfi_tclToken::EN_MSG_BEEPINFOMETHODRESULT:
      case switchctrl_mainfi_tclToken::EN_MSG_REARSEAT_CONNECTIONUPREG:
      case switchctrl_mainfi_tclToken::EN_MSG_REARSEAT_CONNECTIONRELUPREG:
      case switchctrl_mainfi_tclToken::EN_MSG_REARSEAT_CONNECTIONGET:
      case switchctrl_mainfi_tclToken::EN_MSG_REARSEAT_CONNECTIONSTATUS:
      case switchctrl_mainfi_tclToken::EN_MSG_ITCOMMANDER_CONNECTIONUPREG:
      case switchctrl_mainfi_tclToken::EN_MSG_ITCOMMANDER_CONNECTIONRELUPREG:
      case switchctrl_mainfi_tclToken::EN_MSG_ITCOMMANDER_CONNECTIONGET:
      case switchctrl_mainfi_tclToken::EN_MSG_ITCOMMANDER_CONNECTIONSTATUS:
      case switchctrl_mainfi_tclToken::EN_MSG_HARDWAREVERSIONUPREG:
      case switchctrl_mainfi_tclToken::EN_MSG_HARDWAREVERSIONRELUPREG:
      case switchctrl_mainfi_tclToken::EN_MSG_HARDWAREVERSIONGET:
      case switchctrl_mainfi_tclToken::EN_MSG_HARDWAREVERSIONSTATUS:
      case switchctrl_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONUPREG:
      case switchctrl_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONRELUPREG:
      case switchctrl_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONGET:
      case switchctrl_mainfi_tclToken::EN_MSG_SOFTWAREVERSIONSTATUS:
      case switchctrl_mainfi_tclToken::EN_MSG_PRIMARYINTEGRATEDSWITCH_CONNECTIONUPREG:
      case switchctrl_mainfi_tclToken::EN_MSG_PRIMARYINTEGRATEDSWITCH_CONNECTIONRELUPREG:
      case switchctrl_mainfi_tclToken::EN_MSG_PRIMARYINTEGRATEDSWITCH_CONNECTIONGET:
      case switchctrl_mainfi_tclToken::EN_MSG_PRIMARYINTEGRATEDSWITCH_CONNECTIONSTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case switchctrl_mainfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(switchctrl_mainfi_tclKnot(switchctrl_mainfi_tclToken::EN_END_OF_STRUCT,switchctrl_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(switchctrl_mainfi_tclKnot(switchctrl_mainfi_tclToken::EN_U8,switchctrl_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(switchctrl_mainfi_tclKnot(switchctrl_mainfi_tclToken::EN_LIST,switchctrl_mainfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         switchctrl_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case switchctrl_mainfi_tclToken::EN_E8_MCANUNITTYPE:
      {
         switchctrl_fi_tcl_e8_MCanUnitType o_e8_MCanUnitType;
         if (!bDoIt(o_e8_MCanUnitType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case switchctrl_mainfi_tclToken::EN_SWCTRL_CONNECTIONSTATUS:
      {
      if (poVisitor->bDoExpand_SwCtrl_ConnectionStatus(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(switchctrl_mainfi_tclKnot(switchctrl_mainfi_tclToken::EN_END_OF_STRUCT,switchctrl_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(switchctrl_mainfi_tclKnot(switchctrl_mainfi_tclToken::EN_U8,switchctrl_mainfi_tclSemanticDomain::EN_U8MUTESTATE));
         (tVoid) oPath.bGoDown(switchctrl_mainfi_tclKnot(switchctrl_mainfi_tclToken::EN_U8,switchctrl_mainfi_tclSemanticDomain::EN_U8ABSENCESTATE));
         (tVoid) oPath.bGoDown(switchctrl_mainfi_tclKnot(switchctrl_mainfi_tclToken::EN_BOOL,switchctrl_mainfi_tclSemanticDomain::EN_BISCONNECTED));
         (tVoid) oPath.bGoDown(switchctrl_mainfi_tclKnot(switchctrl_mainfi_tclToken::EN_E8_MCANUNITTYPE,switchctrl_mainfi_tclSemanticDomain::EN_E8UNITTYPE));
      }
      else
      {
         switchctrl_fi_tcl_SwCtrl_ConnectionStatus o_SwCtrl_ConnectionStatus;
         if (!bDoIt(o_SwCtrl_ConnectionStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SwCtrl_ConnectionStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SwCtrl_ConnectionStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case switchctrl_mainfi_tclToken::EN_SWITCHCTRL_VERSIONINFO:
      {
      if (poVisitor->bDoExpand_SwitchCtrl_VersionInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(switchctrl_mainfi_tclKnot(switchctrl_mainfi_tclToken::EN_END_OF_STRUCT,switchctrl_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(switchctrl_mainfi_tclKnot(switchctrl_mainfi_tclToken::EN_U8,switchctrl_mainfi_tclSemanticDomain::EN_U8LOWER));
         (tVoid) oPath.bGoDown(switchctrl_mainfi_tclKnot(switchctrl_mainfi_tclToken::EN_U8,switchctrl_mainfi_tclSemanticDomain::EN_U8MID));
         (tVoid) oPath.bGoDown(switchctrl_mainfi_tclKnot(switchctrl_mainfi_tclToken::EN_U8,switchctrl_mainfi_tclSemanticDomain::EN_U8UPPER));
      }
      else
      {
         switchctrl_fi_tcl_SwitchCtrl_VersionInfo o_SwitchCtrl_VersionInfo;
         if (!bDoIt(o_SwitchCtrl_VersionInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SwitchCtrl_VersionInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SwitchCtrl_VersionInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case switchctrl_mainfi_tclToken::EN_SWITCHCTRL_UNITVERSION:
      {
      if (poVisitor->bDoExpand_SwitchCtrl_UnitVersion(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(switchctrl_mainfi_tclKnot(switchctrl_mainfi_tclToken::EN_END_OF_STRUCT,switchctrl_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(switchctrl_mainfi_tclKnot(switchctrl_mainfi_tclToken::EN_SWITCHCTRL_VERSIONINFO,switchctrl_mainfi_tclSemanticDomain::EN_RVERSION));
         (tVoid) oPath.bGoDown(switchctrl_mainfi_tclKnot(switchctrl_mainfi_tclToken::EN_E8_MCANUNITTYPE,switchctrl_mainfi_tclSemanticDomain::EN_E8UNITTYPE));
      }
      else
      {
         switchctrl_fi_tcl_SwitchCtrl_UnitVersion o_SwitchCtrl_UnitVersion;
         if (!bDoIt(o_SwitchCtrl_UnitVersion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SwitchCtrl_UnitVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SwitchCtrl_UnitVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case switchctrl_mainfi_tclToken::EN_UNKNOWN:
      case switchctrl_mainfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

