/************************************************************************
 
 *FILE:           alltypes.cpp
 
 *SW-COMPONENT:   FI Functional Interface
 
 *DESCRIPTION:    Interface fuer alle Typdefinitionen
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#if !defined(FI_S_NO_STRING_ACCESS_METHODS) || !defined(FI_S_UTFMODE_TRANSPARENT)
   #define UTFUTIL_S_IMPORT_INTERFACE_GENERIC
   #include "utf_if.h"
#endif

#define SPM_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "spm_fi_gen_if.h"
// -----------------------------------------------------------------------------

fi_tclOutContext& spm_fi_tclU8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u8Value);
  return oOut;
}

fi_tclInContext& spm_fi_tclU8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u8Value);
  return oIn;
}

tU32 spm_fi_tclU8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& spm_fi_tclS8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s8Value);
  return oOut;
}

fi_tclInContext& spm_fi_tclS8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s8Value);
  return oIn;
}

tU32 spm_fi_tclS8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& spm_fi_tclU16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u16Value);
  return oOut;
}

fi_tclInContext& spm_fi_tclU16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u16Value);
  return oIn;
}

tU32 spm_fi_tclU16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& spm_fi_tclS16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s16Value);
  return oOut;
}

fi_tclInContext& spm_fi_tclS16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s16Value);
  return oIn;
}

tU32 spm_fi_tclS16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& spm_fi_tclU24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u24Value);
  return oOut;
}

fi_tclInContext& spm_fi_tclU24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u24Value);
  return oIn;
}

tU32 spm_fi_tclU24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& spm_fi_tclS24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s24Value);
  return oOut;
}

fi_tclInContext& spm_fi_tclS24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s24Value);
  return oIn;
}

tU32 spm_fi_tclS24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& spm_fi_tclU32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u32Value);
  return oOut;
}

fi_tclInContext& spm_fi_tclU32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u32Value);
  return oIn;
}

tU32 spm_fi_tclU32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& spm_fi_tclU64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u64Value);
  return oOut;
}

fi_tclInContext& spm_fi_tclU64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u64Value);
  return oIn;
}

tU32 spm_fi_tclU64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& spm_fi_tclS32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s32Value);
  return oOut;
}

fi_tclInContext& spm_fi_tclS32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s32Value);
  return oIn;
}

tU32 spm_fi_tclS32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& spm_fi_tclS64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s64Value);
  return oOut;
}

fi_tclInContext& spm_fi_tclS64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s64Value);
  return oIn;
}

tU32 spm_fi_tclS64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& spm_fi_tclF32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f32Value);
  return oOut;
}

fi_tclInContext& spm_fi_tclF32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f32Value);
  return oIn;
}

tU32 spm_fi_tclF32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& spm_fi_tclF64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f64Value);
  return oOut;
}

fi_tclInContext& spm_fi_tclF64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f64Value);
  return oIn;
}

tU32 spm_fi_tclF64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& spm_fi_tclBool::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(bValue);
  return oOut;
}

fi_tclInContext& spm_fi_tclBool::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(bValue);
  return oIn;
}

tU32 spm_fi_tclBool::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& spm_fi_tclString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid spm_fi_tclString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tclString::~spm_fi_tclString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

spm_fi_tclString& spm_fi_tclString::operator=(const spm_fi_tclString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

spm_fi_tclString::spm_fi_tclString(const spm_fi_tclString& coRef):spm_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& spm_fi_tclString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool spm_fi_tclString::operator==(const spm_fi_tclString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 spm_fi_tclString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
spm_fi_tclString& spm_fi_tclString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclString::fi_tclString(const tString& coszString) // ADDED (changed from const tString to const tString&)
spm_fi_tclString::spm_fi_tclString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool spm_fi_tclString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

spm_fi_tclString::operator tString&() // ADDED
{
   return szValue;
}

spm_fi_tclString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool spm_fi_tclString::operator!=(intptr_t iNULL) const // ADDED
{
   return szValue != (char*)iNULL;
}

static tChar spm_FI_C_U8_NULLCHAR = '\0';

tChar* spm_fi_tclString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* spm_fi_tclString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* spm_fi_tclString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& spm_fi_tclString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return spm_FI_C_U8_NULLCHAR;
}

tChar& spm_fi_tclString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return spm_FI_C_U8_NULLCHAR;
}

tChar& spm_fi_tclString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return spm_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool spm_fi_tclString::bSet(const spm_fi_tclString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool spm_fi_tclString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
case FI_EN_ISO8859_1M :
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = util_u32ConvertISO8859_1Mod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            util_u32ConvertISO8859_1Mod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
   return bSuccess;
}

tString spm_fi_tclString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

// -----------------------------------------------------------------------------

fi_tclOutContext& spm_fi_tclList::oWrite(fi_tclOutContext& oOut) const 
{
   // --Schreibe die Listenlaenge in den Kontext
   (tVoid) oOut.oWrite(u32ListSize);
   return oOut;
}

fi_tclInContext& spm_fi_tclList::oRead(fi_tclInContext& oIn) 
{
  // --Lese die Listenlaenge aus dem Kontext
  (tVoid) oIn.oRead(u32ListSize);
  return oIn;
}

tBool spm_fi_tclList::operator==(const spm_fi_tclList& roRef) const
{
   return roRef.u32ListSize == u32ListSize;
}

tU32 spm_fi_tclList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& spm_fi_tclMultiLanguageString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid spm_fi_tclMultiLanguageString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tclMultiLanguageString::~spm_fi_tclMultiLanguageString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

spm_fi_tclMultiLanguageString& spm_fi_tclMultiLanguageString::operator=(const spm_fi_tclMultiLanguageString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

spm_fi_tclMultiLanguageString::spm_fi_tclMultiLanguageString(const spm_fi_tclMultiLanguageString& coRef):spm_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& spm_fi_tclMultiLanguageString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool spm_fi_tclMultiLanguageString::operator==(const spm_fi_tclMultiLanguageString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 spm_fi_tclMultiLanguageString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
spm_fi_tclMultiLanguageString& spm_fi_tclMultiLanguageString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclMultiLanguageString::fi_tclMultiLanguageString(const tString& coszString) // ADDED (changed from const tString to const tString&)
spm_fi_tclMultiLanguageString::spm_fi_tclMultiLanguageString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool spm_fi_tclMultiLanguageString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

spm_fi_tclMultiLanguageString::operator tString&() // ADDED
{
   return szValue;
}

spm_fi_tclMultiLanguageString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool spm_fi_tclMultiLanguageString::operator!=(intptr_t iNULL) const// ADDED
{
   return szValue != (char*)iNULL;
}

tChar* spm_fi_tclMultiLanguageString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* spm_fi_tclMultiLanguageString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* spm_fi_tclMultiLanguageString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& spm_fi_tclMultiLanguageString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return spm_FI_C_U8_NULLCHAR;
}

tChar& spm_fi_tclMultiLanguageString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return spm_FI_C_U8_NULLCHAR;
}

tChar& spm_fi_tclMultiLanguageString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return spm_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool spm_fi_tclMultiLanguageString::bSet(const spm_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclMultiLanguageString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool spm_fi_tclMultiLanguageString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }

   return bSuccess;
}

tString spm_fi_tclMultiLanguageString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_BinContainer::spm_fi_tcl_BinContainer(const spm_fi_tcl_BinContainer& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   ContainerDataList = coRef.ContainerDataList;
}
spm_fi_tcl_BinContainer& spm_fi_tcl_BinContainer::operator=(const spm_fi_tcl_BinContainer& coRef)
{
   if (this == &coRef) return *this;
   ContainerDataList = coRef.ContainerDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_fi_tcl_BinContainer::vDestroy()
{
   {
   ContainerDataList.clear();
   }
}

spm_fi_tcl_BinContainer::spm_fi_tcl_BinContainer()

 {}

tS32 spm_fi_tcl_BinContainer::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_BINCONTAINER;
}


spm_fi_tcl_BinContainer::~spm_fi_tcl_BinContainer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_fi_tcl_BinContainer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ContainerDataList.size()*1);
}

fi_tclInContext& spm_fi_tcl_BinContainer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ContainerDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ContainerDataList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_BinContainer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ContainerDataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ContainerDataList.size(); ++u32Idx)
         (tVoid) (oOut << ContainerDataList[u32Idx]);
   }
   return oOut;
}

tBool spm_fi_tcl_BinContainer::operator==(const spm_fi_tcl_BinContainer& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ContainerDataList.size() == roRef.ContainerDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ContainerDataList.size()); ++u32Idx)
            bResult = bResult && (ContainerDataList[u32Idx] == roRef.ContainerDataList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

spm_fi_tcl_Reserved::spm_fi_tcl_Reserved()
 {}

tS32 spm_fi_tcl_Reserved::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_RESERVED;
}


spm_fi_tcl_Reserved::~spm_fi_tcl_Reserved()
{}

tU32 spm_fi_tcl_Reserved::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

fi_tclInContext& spm_fi_tcl_Reserved::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_Reserved::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_u8_Percent::spm_fi_tcl_u8_Percent(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 spm_fi_tcl_u8_Percent::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_U8_PERCENT;
}


spm_fi_tcl_u8_Percent::~spm_fi_tcl_u8_Percent()
{}

tU32 spm_fi_tcl_u8_Percent::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_fi_tcl_u8_Percent::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& spm_fi_tcl_u8_Percent::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s16_PerThousand::spm_fi_tcl_s16_PerThousand(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 spm_fi_tcl_s16_PerThousand::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S16_PERTHOUSAND;
}


spm_fi_tcl_s16_PerThousand::~spm_fi_tcl_s16_PerThousand()
{}

tU32 spm_fi_tcl_s16_PerThousand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& spm_fi_tcl_s16_PerThousand::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& spm_fi_tcl_s16_PerThousand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_u16_IndexInReferenceList::spm_fi_tcl_u16_IndexInReferenceList(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 spm_fi_tcl_u16_IndexInReferenceList::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_U16_INDEXINREFERENCELIST;
}


spm_fi_tcl_u16_IndexInReferenceList::~spm_fi_tcl_u16_IndexInReferenceList()
{}

tU32 spm_fi_tcl_u16_IndexInReferenceList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& spm_fi_tcl_u16_IndexInReferenceList::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& spm_fi_tcl_u16_IndexInReferenceList::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_u16_ErrorCode::spm_fi_tcl_u16_ErrorCode(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 spm_fi_tcl_u16_ErrorCode::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_U16_ERRORCODE;
}


spm_fi_tcl_u16_ErrorCode::~spm_fi_tcl_u16_ErrorCode()
{}

tU32 spm_fi_tcl_u16_ErrorCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& spm_fi_tcl_u16_ErrorCode::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& spm_fi_tcl_u16_ErrorCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_u16_RPM::spm_fi_tcl_u16_RPM(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 spm_fi_tcl_u16_RPM::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_U16_RPM;
}


spm_fi_tcl_u16_RPM::~spm_fi_tcl_u16_RPM()
{}

tU32 spm_fi_tcl_u16_RPM::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& spm_fi_tcl_u16_RPM::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& spm_fi_tcl_u16_RPM::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s32_Kilogram::spm_fi_tcl_s32_Kilogram(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 spm_fi_tcl_s32_Kilogram::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S32_KILOGRAM;
}


spm_fi_tcl_s32_Kilogram::~spm_fi_tcl_s32_Kilogram()
{}

tU32 spm_fi_tcl_s32_Kilogram::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_s32_Kilogram::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& spm_fi_tcl_s32_Kilogram::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s32_Pound::spm_fi_tcl_s32_Pound(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 spm_fi_tcl_s32_Pound::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S32_POUND;
}


spm_fi_tcl_s32_Pound::~spm_fi_tcl_s32_Pound()
{}

tU32 spm_fi_tcl_s32_Pound::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_s32_Pound::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& spm_fi_tcl_s32_Pound::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s16_Meter::spm_fi_tcl_s16_Meter(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 spm_fi_tcl_s16_Meter::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S16_METER;
}


spm_fi_tcl_s16_Meter::~spm_fi_tcl_s16_Meter()
{}

tU32 spm_fi_tcl_s16_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& spm_fi_tcl_s16_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& spm_fi_tcl_s16_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s32_Meter::spm_fi_tcl_s32_Meter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 spm_fi_tcl_s32_Meter::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S32_METER;
}


spm_fi_tcl_s32_Meter::~spm_fi_tcl_s32_Meter()
{}

tU32 spm_fi_tcl_s32_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_s32_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& spm_fi_tcl_s32_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s32_Yards::spm_fi_tcl_s32_Yards(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 spm_fi_tcl_s32_Yards::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S32_YARDS;
}


spm_fi_tcl_s32_Yards::~spm_fi_tcl_s32_Yards()
{}

tU32 spm_fi_tcl_s32_Yards::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_s32_Yards::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& spm_fi_tcl_s32_Yards::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s32_Foot::spm_fi_tcl_s32_Foot(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 spm_fi_tcl_s32_Foot::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S32_FOOT;
}


spm_fi_tcl_s32_Foot::~spm_fi_tcl_s32_Foot()
{}

tU32 spm_fi_tcl_s32_Foot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_s32_Foot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& spm_fi_tcl_s32_Foot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s32_Centimeter::spm_fi_tcl_s32_Centimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 spm_fi_tcl_s32_Centimeter::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S32_CENTIMETER;
}


spm_fi_tcl_s32_Centimeter::~spm_fi_tcl_s32_Centimeter()
{}

tU32 spm_fi_tcl_s32_Centimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_s32_Centimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& spm_fi_tcl_s32_Centimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s32_Inch::spm_fi_tcl_s32_Inch(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 spm_fi_tcl_s32_Inch::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S32_INCH;
}


spm_fi_tcl_s32_Inch::~spm_fi_tcl_s32_Inch()
{}

tU32 spm_fi_tcl_s32_Inch::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_s32_Inch::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& spm_fi_tcl_s32_Inch::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s32_Millimeter::spm_fi_tcl_s32_Millimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 spm_fi_tcl_s32_Millimeter::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S32_MILLIMETER;
}


spm_fi_tcl_s32_Millimeter::~spm_fi_tcl_s32_Millimeter()
{}

tU32 spm_fi_tcl_s32_Millimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_s32_Millimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& spm_fi_tcl_s32_Millimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s32_Microliter::spm_fi_tcl_s32_Microliter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 spm_fi_tcl_s32_Microliter::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S32_MICROLITER;
}


spm_fi_tcl_s32_Microliter::~spm_fi_tcl_s32_Microliter()
{}

tU32 spm_fi_tcl_s32_Microliter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_s32_Microliter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& spm_fi_tcl_s32_Microliter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s32_Second::spm_fi_tcl_s32_Second(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 spm_fi_tcl_s32_Second::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S32_SECOND;
}


spm_fi_tcl_s32_Second::~spm_fi_tcl_s32_Second()
{}

tU32 spm_fi_tcl_s32_Second::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_s32_Second::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& spm_fi_tcl_s32_Second::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_u16_MilliSecond::spm_fi_tcl_u16_MilliSecond(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 spm_fi_tcl_u16_MilliSecond::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_U16_MILLISECOND;
}


spm_fi_tcl_u16_MilliSecond::~spm_fi_tcl_u16_MilliSecond()
{}

tU32 spm_fi_tcl_u16_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& spm_fi_tcl_u16_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& spm_fi_tcl_u16_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s32_MilliSecond::spm_fi_tcl_s32_MilliSecond(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 spm_fi_tcl_s32_MilliSecond::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S32_MILLISECOND;
}


spm_fi_tcl_s32_MilliSecond::~spm_fi_tcl_s32_MilliSecond()
{}

tU32 spm_fi_tcl_s32_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_s32_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& spm_fi_tcl_s32_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_POSIXTime::spm_fi_tcl_POSIXTime(const spm_fi_tcl_POSIXTime& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   Time = coRef.Time;
}
spm_fi_tcl_POSIXTime& spm_fi_tcl_POSIXTime::operator=(const spm_fi_tcl_POSIXTime& coRef)
{
   if (this == &coRef) return *this;
   Time = coRef.Time;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_POSIXTime::spm_fi_tcl_POSIXTime()
:Time(0)
 {}

tS32 spm_fi_tcl_POSIXTime::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_POSIXTIME;
}


spm_fi_tcl_POSIXTime::~spm_fi_tcl_POSIXTime()
{}

tU32 spm_fi_tcl_POSIXTime::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_POSIXTime::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Time);
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_POSIXTime::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Time);
   return oOut;
}

tBool spm_fi_tcl_POSIXTime::operator==(const spm_fi_tcl_POSIXTime& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Time == roRef.Time);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_e8_DST_State::spm_fi_tcl_e8_DST_State():enType(FI_EN_T_STANDARDTIME) {}

tS32 spm_fi_tcl_e8_DST_State::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_E8_DST_STATE;
}


spm_fi_tcl_e8_DST_State::~spm_fi_tcl_e8_DST_State()
{}

tU32 spm_fi_tcl_e8_DST_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_fi_tcl_e8_DST_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_e8_DST_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_TimeZoneElement::spm_fi_tcl_TimeZoneElement(const spm_fi_tcl_TimeZoneElement& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
}
spm_fi_tcl_TimeZoneElement& spm_fi_tcl_TimeZoneElement::operator=(const spm_fi_tcl_TimeZoneElement& coRef)
{
   if (this == &coRef) return *this;
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_fi_tcl_TimeZoneElement::vDestroy()
{
   Abbreviation_StandardTime.vDestroy();
   Abbreviation_DST_in_effect.vDestroy();
   {
   DST_TimeDomain.clear();
   }
}

spm_fi_tcl_TimeZoneElement::spm_fi_tcl_TimeZoneElement()
:Abbreviation_StandardTime(0)
,Abbreviation_DST_in_effect(0)
,TimeZoneDifference()
,DST_State()
,DSTDifference()

 {}

tS32 spm_fi_tcl_TimeZoneElement::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_TIMEZONEELEMENT;
}


spm_fi_tcl_TimeZoneElement::~spm_fi_tcl_TimeZoneElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_fi_tcl_TimeZoneElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 13+Abbreviation_StandardTime.u32GetSize(u16MajorVersion)+Abbreviation_DST_in_effect.u32GetSize(u16MajorVersion)+ static_cast<tU32>(DST_TimeDomain.size()*1);
}

fi_tclInContext& spm_fi_tcl_TimeZoneElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Abbreviation_StandardTime);
   (tVoid) (oIn >> Abbreviation_DST_in_effect);
   (tVoid) (oIn >> TimeZoneDifference);
   (tVoid) (oIn >> DST_State);
   (tVoid) (oIn >> DSTDifference);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      DST_TimeDomain.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DST_TimeDomain[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_TimeZoneElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Abbreviation_StandardTime);
   (tVoid) (oOut << Abbreviation_DST_in_effect);
   (tVoid) (oOut << TimeZoneDifference);
   (tVoid) (oOut << DST_State);
   (tVoid) (oOut << DSTDifference);
   (tVoid) (oOut << (tU32)DST_TimeDomain.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DST_TimeDomain.size(); ++u32Idx)
         (tVoid) (oOut << DST_TimeDomain[u32Idx]);
   }
   return oOut;
}

tBool spm_fi_tcl_TimeZoneElement::operator==(const spm_fi_tcl_TimeZoneElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Abbreviation_StandardTime == roRef.Abbreviation_StandardTime);
   bResult = bResult && (Abbreviation_DST_in_effect == roRef.Abbreviation_DST_in_effect);
   bResult = bResult && (TimeZoneDifference == roRef.TimeZoneDifference);
   bResult = bResult && (DST_State == roRef.DST_State);
   bResult = bResult && (DSTDifference == roRef.DSTDifference);
      bResult = bResult && (DST_TimeDomain.size() == roRef.DST_TimeDomain.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DST_TimeDomain.size()); ++u32Idx)
            bResult = bResult && (DST_TimeDomain[u32Idx] == roRef.DST_TimeDomain[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s16_KmPerHour::spm_fi_tcl_s16_KmPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 spm_fi_tcl_s16_KmPerHour::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S16_KMPERHOUR;
}


spm_fi_tcl_s16_KmPerHour::~spm_fi_tcl_s16_KmPerHour()
{}

tU32 spm_fi_tcl_s16_KmPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& spm_fi_tcl_s16_KmPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& spm_fi_tcl_s16_KmPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s16_MilesPerHour::spm_fi_tcl_s16_MilesPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 spm_fi_tcl_s16_MilesPerHour::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S16_MILESPERHOUR;
}


spm_fi_tcl_s16_MilesPerHour::~spm_fi_tcl_s16_MilesPerHour()
{}

tU32 spm_fi_tcl_s16_MilesPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& spm_fi_tcl_s16_MilesPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& spm_fi_tcl_s16_MilesPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s16_Knot::spm_fi_tcl_s16_Knot(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 spm_fi_tcl_s16_Knot::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S16_KNOT;
}


spm_fi_tcl_s16_Knot::~spm_fi_tcl_s16_Knot()
{}

tU32 spm_fi_tcl_s16_Knot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& spm_fi_tcl_s16_Knot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& spm_fi_tcl_s16_Knot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s16_CentimeterSecond::spm_fi_tcl_s16_CentimeterSecond(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 spm_fi_tcl_s16_CentimeterSecond::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S16_CENTIMETERSECOND;
}


spm_fi_tcl_s16_CentimeterSecond::~spm_fi_tcl_s16_CentimeterSecond()
{}

tU32 spm_fi_tcl_s16_CentimeterSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& spm_fi_tcl_s16_CentimeterSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& spm_fi_tcl_s16_CentimeterSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s16_Kelvin::spm_fi_tcl_s16_Kelvin(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 spm_fi_tcl_s16_Kelvin::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S16_KELVIN;
}


spm_fi_tcl_s16_Kelvin::~spm_fi_tcl_s16_Kelvin()
{}

tU32 spm_fi_tcl_s16_Kelvin::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& spm_fi_tcl_s16_Kelvin::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& spm_fi_tcl_s16_Kelvin::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s16_Fahrenheit::spm_fi_tcl_s16_Fahrenheit(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 spm_fi_tcl_s16_Fahrenheit::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S16_FAHRENHEIT;
}


spm_fi_tcl_s16_Fahrenheit::~spm_fi_tcl_s16_Fahrenheit()
{}

tU32 spm_fi_tcl_s16_Fahrenheit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& spm_fi_tcl_s16_Fahrenheit::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& spm_fi_tcl_s16_Fahrenheit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s32_Pascal::spm_fi_tcl_s32_Pascal(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 spm_fi_tcl_s32_Pascal::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S32_PASCAL;
}


spm_fi_tcl_s32_Pascal::~spm_fi_tcl_s32_Pascal()
{}

tU32 spm_fi_tcl_s32_Pascal::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_s32_Pascal::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& spm_fi_tcl_s32_Pascal::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s32_Watt::spm_fi_tcl_s32_Watt(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 spm_fi_tcl_s32_Watt::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S32_WATT;
}


spm_fi_tcl_s32_Watt::~spm_fi_tcl_s32_Watt()
{}

tU32 spm_fi_tcl_s32_Watt::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_s32_Watt::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& spm_fi_tcl_s32_Watt::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_FIVersion::spm_fi_tcl_FIVersion(const spm_fi_tcl_FIVersion& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
}
spm_fi_tcl_FIVersion& spm_fi_tcl_FIVersion::operator=(const spm_fi_tcl_FIVersion& coRef)
{
   if (this == &coRef) return *this;
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_FIVersion::spm_fi_tcl_FIVersion()
:MajorVersion(0)
,MinorVersion(0)
,PatchVersion(0)
 {}

tS32 spm_fi_tcl_FIVersion::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_FIVERSION;
}


spm_fi_tcl_FIVersion::~spm_fi_tcl_FIVersion()
{}

tU32 spm_fi_tcl_FIVersion::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& spm_fi_tcl_FIVersion::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MajorVersion);
   (tVoid) (oIn >> MinorVersion);
   (tVoid) (oIn >> PatchVersion);
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_FIVersion::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MajorVersion);
   (tVoid) (oOut << MinorVersion);
   (tVoid) (oOut << PatchVersion);
   return oOut;
}

tBool spm_fi_tcl_FIVersion::operator==(const spm_fi_tcl_FIVersion& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MajorVersion == roRef.MajorVersion);
   bResult = bResult && (MinorVersion == roRef.MinorVersion);
   bResult = bResult && (PatchVersion == roRef.PatchVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s32_Longitude::spm_fi_tcl_s32_Longitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 spm_fi_tcl_s32_Longitude::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S32_LONGITUDE;
}


spm_fi_tcl_s32_Longitude::~spm_fi_tcl_s32_Longitude()
{}

tU32 spm_fi_tcl_s32_Longitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_s32_Longitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& spm_fi_tcl_s32_Longitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s32_Latitude::spm_fi_tcl_s32_Latitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 spm_fi_tcl_s32_Latitude::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S32_LATITUDE;
}


spm_fi_tcl_s32_Latitude::~spm_fi_tcl_s32_Latitude()
{}

tU32 spm_fi_tcl_s32_Latitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_s32_Latitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& spm_fi_tcl_s32_Latitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_PositionWGS84::spm_fi_tcl_PositionWGS84(const spm_fi_tcl_PositionWGS84& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
}
spm_fi_tcl_PositionWGS84& spm_fi_tcl_PositionWGS84::operator=(const spm_fi_tcl_PositionWGS84& coRef)
{
   if (this == &coRef) return *this;
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_PositionWGS84::spm_fi_tcl_PositionWGS84()
:Longitude()
,Latitude()
 {}

tS32 spm_fi_tcl_PositionWGS84::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_POSITIONWGS84;
}


spm_fi_tcl_PositionWGS84::~spm_fi_tcl_PositionWGS84()
{}

tU32 spm_fi_tcl_PositionWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& spm_fi_tcl_PositionWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Longitude);
   (tVoid) (oIn >> Latitude);
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_PositionWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Longitude);
   (tVoid) (oOut << Latitude);
   return oOut;
}

tBool spm_fi_tcl_PositionWGS84::operator==(const spm_fi_tcl_PositionWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Longitude == roRef.Longitude);
   bResult = bResult && (Latitude == roRef.Latitude);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_RectangleWGS84::spm_fi_tcl_RectangleWGS84(const spm_fi_tcl_RectangleWGS84& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
}
spm_fi_tcl_RectangleWGS84& spm_fi_tcl_RectangleWGS84::operator=(const spm_fi_tcl_RectangleWGS84& coRef)
{
   if (this == &coRef) return *this;
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_RectangleWGS84::spm_fi_tcl_RectangleWGS84()
:LongitudeMin()
,LatitudeMin()
,LongitudeMax()
,LatitudeMax()
 {}

tS32 spm_fi_tcl_RectangleWGS84::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_RECTANGLEWGS84;
}


spm_fi_tcl_RectangleWGS84::~spm_fi_tcl_RectangleWGS84()
{}

tU32 spm_fi_tcl_RectangleWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& spm_fi_tcl_RectangleWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LongitudeMin);
   (tVoid) (oIn >> LatitudeMin);
   (tVoid) (oIn >> LongitudeMax);
   (tVoid) (oIn >> LatitudeMax);
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_RectangleWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LongitudeMin);
   (tVoid) (oOut << LatitudeMin);
   (tVoid) (oOut << LongitudeMax);
   (tVoid) (oOut << LatitudeMax);
   return oOut;
}

tBool spm_fi_tcl_RectangleWGS84::operator==(const spm_fi_tcl_RectangleWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LongitudeMin == roRef.LongitudeMin);
   bResult = bResult && (LatitudeMin == roRef.LatitudeMin);
   bResult = bResult && (LongitudeMax == roRef.LongitudeMax);
   bResult = bResult && (LatitudeMax == roRef.LatitudeMax);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_e16_ISOCountryCode::spm_fi_tcl_e16_ISOCountryCode():enType(FI_EN_ISO_ALPHA_3_UNDEFINED) {}

tS32 spm_fi_tcl_e16_ISOCountryCode::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_E16_ISOCOUNTRYCODE;
}


spm_fi_tcl_e16_ISOCountryCode::~spm_fi_tcl_e16_ISOCountryCode()
{}

tU32 spm_fi_tcl_e16_ISOCountryCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& spm_fi_tcl_e16_ISOCountryCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_e16_ISOCountryCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_e16_ISOLanguageCode::spm_fi_tcl_e16_ISOLanguageCode():enType(FI_EN_ISO_639_1_UNDEFINED) {}

tS32 spm_fi_tcl_e16_ISOLanguageCode::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_E16_ISOLANGUAGECODE;
}


spm_fi_tcl_e16_ISOLanguageCode::~spm_fi_tcl_e16_ISOLanguageCode()
{}

tU32 spm_fi_tcl_e16_ISOLanguageCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& spm_fi_tcl_e16_ISOLanguageCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_e16_ISOLanguageCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_LanguageID::spm_fi_tcl_LanguageID(const spm_fi_tcl_LanguageID& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
}
spm_fi_tcl_LanguageID& spm_fi_tcl_LanguageID::operator=(const spm_fi_tcl_LanguageID& coRef)
{
   if (this == &coRef) return *this;
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_LanguageID::spm_fi_tcl_LanguageID()
:ISO639_LanguageCode()
,ISO3166_CountryCode()
 {}

tS32 spm_fi_tcl_LanguageID::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_LANGUAGEID;
}


spm_fi_tcl_LanguageID::~spm_fi_tcl_LanguageID()
{}

tU32 spm_fi_tcl_LanguageID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_LanguageID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ISO639_LanguageCode);
   (tVoid) (oIn >> ISO3166_CountryCode);
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_LanguageID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ISO639_LanguageCode);
   (tVoid) (oOut << ISO3166_CountryCode);
   return oOut;
}

tBool spm_fi_tcl_LanguageID::operator==(const spm_fi_tcl_LanguageID& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ISO639_LanguageCode == roRef.ISO639_LanguageCode);
   bResult = bResult && (ISO3166_CountryCode == roRef.ISO3166_CountryCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_u8_DirectionAbsolute::spm_fi_tcl_u8_DirectionAbsolute(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 spm_fi_tcl_u8_DirectionAbsolute::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_U8_DIRECTIONABSOLUTE;
}


spm_fi_tcl_u8_DirectionAbsolute::~spm_fi_tcl_u8_DirectionAbsolute()
{}

tU32 spm_fi_tcl_u8_DirectionAbsolute::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_fi_tcl_u8_DirectionAbsolute::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& spm_fi_tcl_u8_DirectionAbsolute::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_u8_DirectionRelative::spm_fi_tcl_u8_DirectionRelative(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 spm_fi_tcl_u8_DirectionRelative::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_U8_DIRECTIONRELATIVE;
}


spm_fi_tcl_u8_DirectionRelative::~spm_fi_tcl_u8_DirectionRelative()
{}

tU32 spm_fi_tcl_u8_DirectionRelative::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_fi_tcl_u8_DirectionRelative::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& spm_fi_tcl_u8_DirectionRelative::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s16_CentiDegree::spm_fi_tcl_s16_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 spm_fi_tcl_s16_CentiDegree::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S16_CENTIDEGREE;
}


spm_fi_tcl_s16_CentiDegree::~spm_fi_tcl_s16_CentiDegree()
{}

tU32 spm_fi_tcl_s16_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& spm_fi_tcl_s16_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& spm_fi_tcl_s16_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s16_Degree::spm_fi_tcl_s16_Degree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 spm_fi_tcl_s16_Degree::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S16_DEGREE;
}


spm_fi_tcl_s16_Degree::~spm_fi_tcl_s16_Degree()
{}

tU32 spm_fi_tcl_s16_Degree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& spm_fi_tcl_s16_Degree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& spm_fi_tcl_s16_Degree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_u16_DirectionAbsolute_CentiDegree::spm_fi_tcl_u16_DirectionAbsolute_CentiDegree(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 spm_fi_tcl_u16_DirectionAbsolute_CentiDegree::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_U16_DIRECTIONABSOLUTE_CENTIDEGREE;
}


spm_fi_tcl_u16_DirectionAbsolute_CentiDegree::~spm_fi_tcl_u16_DirectionAbsolute_CentiDegree()
{}

tU32 spm_fi_tcl_u16_DirectionAbsolute_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& spm_fi_tcl_u16_DirectionAbsolute_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& spm_fi_tcl_u16_DirectionAbsolute_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_s16_DirectionRelative_CentiDegree::spm_fi_tcl_s16_DirectionRelative_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 spm_fi_tcl_s16_DirectionRelative_CentiDegree::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_S16_DIRECTIONRELATIVE_CENTIDEGREE;
}


spm_fi_tcl_s16_DirectionRelative_CentiDegree::~spm_fi_tcl_s16_DirectionRelative_CentiDegree()
{}

tU32 spm_fi_tcl_s16_DirectionRelative_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& spm_fi_tcl_s16_DirectionRelative_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& spm_fi_tcl_s16_DirectionRelative_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_e8_FuelType::spm_fi_tcl_e8_FuelType():enType(FI_EN_RESERVED) {}

tS32 spm_fi_tcl_e8_FuelType::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_E8_FUELTYPE;
}


spm_fi_tcl_e8_FuelType::~spm_fi_tcl_e8_FuelType()
{}

tU32 spm_fi_tcl_e8_FuelType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_fi_tcl_e8_FuelType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_e8_FuelType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_DistTimeFuel::spm_fi_tcl_DistTimeFuel(const spm_fi_tcl_DistTimeFuel& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
}
spm_fi_tcl_DistTimeFuel& spm_fi_tcl_DistTimeFuel::operator=(const spm_fi_tcl_DistTimeFuel& coRef)
{
   if (this == &coRef) return *this;
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_DistTimeFuel::spm_fi_tcl_DistTimeFuel()
:Distance()
,Time()
,Fuel()
 {}

tS32 spm_fi_tcl_DistTimeFuel::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_DISTTIMEFUEL;
}


spm_fi_tcl_DistTimeFuel::~spm_fi_tcl_DistTimeFuel()
{}

tU32 spm_fi_tcl_DistTimeFuel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& spm_fi_tcl_DistTimeFuel::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Distance);
   (tVoid) (oIn >> Time);
   (tVoid) (oIn >> Fuel);
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_DistTimeFuel::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Distance);
   (tVoid) (oOut << Time);
   (tVoid) (oOut << Fuel);
   return oOut;
}

tBool spm_fi_tcl_DistTimeFuel::operator==(const spm_fi_tcl_DistTimeFuel& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Distance == roRef.Distance);
   bResult = bResult && (Time == roRef.Time);
   bResult = bResult && (Fuel == roRef.Fuel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tclTimeDate::spm_fi_tclTimeDate(const spm_fi_tclTimeDate& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hour = coRef.u8Hour;
   u8Minute = coRef.u8Minute;
   u8Second = coRef.u8Second;
}
spm_fi_tclTimeDate& spm_fi_tclTimeDate::operator=(const spm_fi_tclTimeDate& coRef)
{
   if (this == &coRef) return *this;
   s16Year = coRef.s16Year;
   u8Month = coRef.u8Month;
   u8Day = coRef.u8Day;
   u8Hour = coRef.u8Hour;
   u8Minute = coRef.u8Minute;
   u8Second = coRef.u8Second;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tclTimeDate::spm_fi_tclTimeDate()
:s16Year(0)
,u8Month(0)
,u8Day(0)
,u8Hour(0)
,u8Minute(0)
,u8Second(0)
 {}

tS32 spm_fi_tclTimeDate::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_IMEDATE;
}


spm_fi_tclTimeDate::~spm_fi_tclTimeDate()
{}

tU32 spm_fi_tclTimeDate::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& spm_fi_tclTimeDate::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s16Year);
   (tVoid) (oIn >> u8Month);
   (tVoid) (oIn >> u8Day);
   (tVoid) (oIn >> u8Hour);
   (tVoid) (oIn >> u8Minute);
   (tVoid) (oIn >> u8Second);
   return oIn;
}

fi_tclOutContext& spm_fi_tclTimeDate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s16Year);
   (tVoid) (oOut << u8Month);
   (tVoid) (oOut << u8Day);
   (tVoid) (oOut << u8Hour);
   (tVoid) (oOut << u8Minute);
   (tVoid) (oOut << u8Second);
   return oOut;
}

tBool spm_fi_tclTimeDate::operator==(const spm_fi_tclTimeDate& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s16Year == roRef.s16Year);
   bResult = bResult && (u8Month == roRef.u8Month);
   bResult = bResult && (u8Day == roRef.u8Day);
   bResult = bResult && (u8Hour == roRef.u8Hour);
   bResult = bResult && (u8Minute == roRef.u8Minute);
   bResult = bResult && (u8Second == roRef.u8Second);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tclSwVersionInfo::spm_fi_tclSwVersionInfo(const spm_fi_tclSwVersionInfo& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   tSwBuildVersion = coRef.tSwBuildVersion;
   tSwCustomerVersion = coRef.tSwCustomerVersion;
}
spm_fi_tclSwVersionInfo& spm_fi_tclSwVersionInfo::operator=(const spm_fi_tclSwVersionInfo& coRef)
{
   if (this == &coRef) return *this;
   tSwBuildVersion = coRef.tSwBuildVersion;
   tSwCustomerVersion = coRef.tSwCustomerVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_fi_tclSwVersionInfo::vDestroy()
{
   tSwBuildVersion.vDestroy();
   tSwCustomerVersion.vDestroy();
}

spm_fi_tclSwVersionInfo::spm_fi_tclSwVersionInfo()
:tSwBuildVersion()
,tSwCustomerVersion()
 {}

tS32 spm_fi_tclSwVersionInfo::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_WVERSIONINFO;
}


spm_fi_tclSwVersionInfo::~spm_fi_tclSwVersionInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_fi_tclSwVersionInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+tSwBuildVersion.u32GetSize(u16MajorVersion)+tSwCustomerVersion.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_fi_tclSwVersionInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tSwBuildVersion);
   (tVoid) (oIn >> tSwCustomerVersion);
   return oIn;
}

fi_tclOutContext& spm_fi_tclSwVersionInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tSwBuildVersion);
   (tVoid) (oOut << tSwCustomerVersion);
   return oOut;
}

tBool spm_fi_tclSwVersionInfo::operator==(const spm_fi_tclSwVersionInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tSwBuildVersion == roRef.tSwBuildVersion);
   bResult = bResult && (tSwCustomerVersion == roRef.tSwCustomerVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_b32_SubState0::spm_fi_tcl_b32_SubState0():u32Value(0)
{}

tS32 spm_fi_tcl_b32_SubState0::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_B32_SUBSTATE0;
}


spm_fi_tcl_b32_SubState0::~spm_fi_tcl_b32_SubState0()
{}

tU32 spm_fi_tcl_b32_SubState0::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_b32_SubState0::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& spm_fi_tcl_b32_SubState0::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_b32_SubState1::spm_fi_tcl_b32_SubState1():u32Value(0)
{}

tS32 spm_fi_tcl_b32_SubState1::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_B32_SUBSTATE1;
}


spm_fi_tcl_b32_SubState1::~spm_fi_tcl_b32_SubState1()
{}

tU32 spm_fi_tcl_b32_SubState1::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_b32_SubState1::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& spm_fi_tcl_b32_SubState1::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_b32_SubState2::spm_fi_tcl_b32_SubState2():u32Value(0)
{}

tS32 spm_fi_tcl_b32_SubState2::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_B32_SUBSTATE2;
}


spm_fi_tcl_b32_SubState2::~spm_fi_tcl_b32_SubState2()
{}

tU32 spm_fi_tcl_b32_SubState2::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_b32_SubState2::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& spm_fi_tcl_b32_SubState2::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_b32_SubState3::spm_fi_tcl_b32_SubState3():u32Value(0)
{}

tS32 spm_fi_tcl_b32_SubState3::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_B32_SUBSTATE3;
}


spm_fi_tcl_b32_SubState3::~spm_fi_tcl_b32_SubState3()
{}

tU32 spm_fi_tcl_b32_SubState3::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_b32_SubState3::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& spm_fi_tcl_b32_SubState3::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_SubStateType::spm_fi_tcl_SPM_e32_SubStateType():enType(FI_EN_SPM_U32_SUBSTATE_SET_SD_CARD_ACCESS) {}

tS32 spm_fi_tcl_SPM_e32_SubStateType::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_SUBSTATETYPE;
}


spm_fi_tcl_SPM_e32_SubStateType::~spm_fi_tcl_SPM_e32_SubStateType()
{}

tU32 spm_fi_tcl_SPM_e32_SubStateType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_SubStateType::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_SubStateType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_OnOffReason::spm_fi_tcl_SPM_e32_OnOffReason():enType(FI_EN_SPM_SUBSTATE_TIPPER_ON) {}

tS32 spm_fi_tcl_SPM_e32_OnOffReason::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_ONOFFREASON;
}


spm_fi_tcl_SPM_e32_OnOffReason::~spm_fi_tcl_SPM_e32_OnOffReason()
{}

tU32 spm_fi_tcl_SPM_e32_OnOffReason::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_OnOffReason::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_OnOffReason::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_SYSTEM_STATES::spm_fi_tcl_SPM_e32_SYSTEM_STATES():enType(FI_EN_SPM_SYSTEM_BACKGROUND) {}

tS32 spm_fi_tcl_SPM_e32_SYSTEM_STATES::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_SYSTEM_STATES;
}


spm_fi_tcl_SPM_e32_SYSTEM_STATES::~spm_fi_tcl_SPM_e32_SYSTEM_STATES()
{}

tU32 spm_fi_tcl_SPM_e32_SYSTEM_STATES::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_SYSTEM_STATES::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_SYSTEM_STATES::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR::spm_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR():enType(FI_EN_SPM_U32_SYSPWR_NORMAL) {}

tS32 spm_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_SYSPWR_BEHAVIOUR;
}


spm_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR::~spm_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR()
{}

tU32 spm_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_HMI_STATE::spm_fi_tcl_SPM_e32_HMI_STATE():enType(FI_EN_SPM_U32_HMISTATE_SHOW_OFF) {}

tS32 spm_fi_tcl_SPM_e32_HMI_STATE::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_HMI_STATE;
}


spm_fi_tcl_SPM_e32_HMI_STATE::~spm_fi_tcl_SPM_e32_HMI_STATE()
{}

tU32 spm_fi_tcl_SPM_e32_HMI_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_HMI_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_HMI_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_DIM_STATE::spm_fi_tcl_SPM_e32_DIM_STATE():enType(FI_EN_SPM_U32_DIMSTATE) {}

tS32 spm_fi_tcl_SPM_e32_DIM_STATE::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_DIM_STATE;
}


spm_fi_tcl_SPM_e32_DIM_STATE::~spm_fi_tcl_SPM_e32_DIM_STATE()
{}

tU32 spm_fi_tcl_SPM_e32_DIM_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_DIM_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_DIM_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_b32_DIM_STATE::spm_fi_tcl_SPM_b32_DIM_STATE():u32Value(0)
{}

tS32 spm_fi_tcl_SPM_b32_DIM_STATE::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_B32_DIM_STATE;
}


spm_fi_tcl_SPM_b32_DIM_STATE::~spm_fi_tcl_SPM_b32_DIM_STATE()
{}

tU32 spm_fi_tcl_SPM_b32_DIM_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_b32_DIM_STATE::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& spm_fi_tcl_SPM_b32_DIM_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_BT_STATE::spm_fi_tcl_SPM_e32_BT_STATE():enType(FI_EN_BLUETOOTHSTATE_BT_OFF) {}

tS32 spm_fi_tcl_SPM_e32_BT_STATE::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_BT_STATE;
}


spm_fi_tcl_SPM_e32_BT_STATE::~spm_fi_tcl_SPM_e32_BT_STATE()
{}

tU32 spm_fi_tcl_SPM_e32_BT_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_BT_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_BT_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_WIFI_STATE::spm_fi_tcl_SPM_e32_WIFI_STATE():enType(FI_EN_WIFISTATE_OFF) {}

tS32 spm_fi_tcl_SPM_e32_WIFI_STATE::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_WIFI_STATE;
}


spm_fi_tcl_SPM_e32_WIFI_STATE::~spm_fi_tcl_SPM_e32_WIFI_STATE()
{}

tU32 spm_fi_tcl_SPM_e32_WIFI_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_WIFI_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_WIFI_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_AUDIO_STATE::spm_fi_tcl_SPM_e32_AUDIO_STATE():enType(FI_EN_SPM_U32_AUDIOSTATE_OFF) {}

tS32 spm_fi_tcl_SPM_e32_AUDIO_STATE::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_AUDIO_STATE;
}


spm_fi_tcl_SPM_e32_AUDIO_STATE::~spm_fi_tcl_SPM_e32_AUDIO_STATE()
{}

tU32 spm_fi_tcl_SPM_e32_AUDIO_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_AUDIO_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_AUDIO_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_SPI_STATE::spm_fi_tcl_SPM_e32_SPI_STATE():enType(FI_EN_SPM_U32_SPISTATE_OFF) {}

tS32 spm_fi_tcl_SPM_e32_SPI_STATE::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_SPI_STATE;
}


spm_fi_tcl_SPM_e32_SPI_STATE::~spm_fi_tcl_SPM_e32_SPI_STATE()
{}

tU32 spm_fi_tcl_SPM_e32_SPI_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_SPI_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_SPI_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_TUNER_STATE::spm_fi_tcl_SPM_e32_TUNER_STATE():enType(FI_EN_SPM_U32_TUNER_OFF) {}

tS32 spm_fi_tcl_SPM_e32_TUNER_STATE::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_TUNER_STATE;
}


spm_fi_tcl_SPM_e32_TUNER_STATE::~spm_fi_tcl_SPM_e32_TUNER_STATE()
{}

tU32 spm_fi_tcl_SPM_e32_TUNER_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_TUNER_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_TUNER_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_AUDIO_SOURCE::spm_fi_tcl_SPM_e32_AUDIO_SOURCE():enType(FI_EN_SPM_U32_AUDIOSRC_NONE) {}

tS32 spm_fi_tcl_SPM_e32_AUDIO_SOURCE::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_AUDIO_SOURCE;
}


spm_fi_tcl_SPM_e32_AUDIO_SOURCE::~spm_fi_tcl_SPM_e32_AUDIO_SOURCE()
{}

tU32 spm_fi_tcl_SPM_e32_AUDIO_SOURCE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_AUDIO_SOURCE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_AUDIO_SOURCE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_CD_INSERT_STATE::spm_fi_tcl_SPM_e32_CD_INSERT_STATE():enType(FI_EN_SPM_U32_CD_INSERT_INACTIVE) {}

tS32 spm_fi_tcl_SPM_e32_CD_INSERT_STATE::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_CD_INSERT_STATE;
}


spm_fi_tcl_SPM_e32_CD_INSERT_STATE::~spm_fi_tcl_SPM_e32_CD_INSERT_STATE()
{}

tU32 spm_fi_tcl_SPM_e32_CD_INSERT_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_CD_INSERT_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_CD_INSERT_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_SYS_STATE::spm_fi_tcl_SPM_e32_SYS_STATE():enType(FI_EN_SPM_U32_SYSSTATE_SLEEP) {}

tS32 spm_fi_tcl_SPM_e32_SYS_STATE::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_SYS_STATE;
}


spm_fi_tcl_SPM_e32_SYS_STATE::~spm_fi_tcl_SPM_e32_SYS_STATE()
{}

tU32 spm_fi_tcl_SPM_e32_SYS_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_SYS_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_SYS_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_MOST_EVENT::spm_fi_tcl_SPM_e32_MOST_EVENT():enType(FI_EN_SPM_U32_MOST_EVENT_NO_EVENT) {}

tS32 spm_fi_tcl_SPM_e32_MOST_EVENT::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_MOST_EVENT;
}


spm_fi_tcl_SPM_e32_MOST_EVENT::~spm_fi_tcl_SPM_e32_MOST_EVENT()
{}

tU32 spm_fi_tcl_SPM_e32_MOST_EVENT::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_MOST_EVENT::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_MOST_EVENT::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_MOST_CONFIG_STATE::spm_fi_tcl_SPM_e32_MOST_CONFIG_STATE():enType(FI_EN_SPM_U32_MOST_CONFIG_STATE_UNAVAILABLE) {}

tS32 spm_fi_tcl_SPM_e32_MOST_CONFIG_STATE::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_MOST_CONFIG_STATE;
}


spm_fi_tcl_SPM_e32_MOST_CONFIG_STATE::~spm_fi_tcl_SPM_e32_MOST_CONFIG_STATE()
{}

tU32 spm_fi_tcl_SPM_e32_MOST_CONFIG_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_MOST_CONFIG_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_MOST_CONFIG_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_TLA_STATE::spm_fi_tcl_SPM_e32_TLA_STATE():enType(FI_EN_SPM_U32_TLA_STATE_UNAVAILABLE) {}

tS32 spm_fi_tcl_SPM_e32_TLA_STATE::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_TLA_STATE;
}


spm_fi_tcl_SPM_e32_TLA_STATE::~spm_fi_tcl_SPM_e32_TLA_STATE()
{}

tU32 spm_fi_tcl_SPM_e32_TLA_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_TLA_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_TLA_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_PROCESSOR_STATE::spm_fi_tcl_SPM_e32_PROCESSOR_STATE():enType(FI_EN_SPM_U32_PROC_STATE_NORMAL) {}

tS32 spm_fi_tcl_SPM_e32_PROCESSOR_STATE::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_PROCESSOR_STATE;
}


spm_fi_tcl_SPM_e32_PROCESSOR_STATE::~spm_fi_tcl_SPM_e32_PROCESSOR_STATE()
{}

tU32 spm_fi_tcl_SPM_e32_PROCESSOR_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_PROCESSOR_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_PROCESSOR_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_STARTUP_STATE::spm_fi_tcl_SPM_e32_STARTUP_STATE():enType(FI_EN_SPM_U32_STARTUP_STATE_INIT) {}

tS32 spm_fi_tcl_SPM_e32_STARTUP_STATE::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_STARTUP_STATE;
}


spm_fi_tcl_SPM_e32_STARTUP_STATE::~spm_fi_tcl_SPM_e32_STARTUP_STATE()
{}

tU32 spm_fi_tcl_SPM_e32_STARTUP_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_STARTUP_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_STARTUP_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_SPM_HistoryTrigger::spm_fi_tcl_SPM_HistoryTrigger(const spm_fi_tcl_SPM_HistoryTrigger& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   u32Timestamp = coRef.u32Timestamp;
   eTriggerType = coRef.eTriggerType;
}
spm_fi_tcl_SPM_HistoryTrigger& spm_fi_tcl_SPM_HistoryTrigger::operator=(const spm_fi_tcl_SPM_HistoryTrigger& coRef)
{
   if (this == &coRef) return *this;
   u32Timestamp = coRef.u32Timestamp;
   eTriggerType = coRef.eTriggerType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_HistoryTrigger::spm_fi_tcl_SPM_HistoryTrigger()
:u32Timestamp(0)
,eTriggerType()
 {}

tS32 spm_fi_tcl_SPM_HistoryTrigger::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_HISTORYTRIGGER;
}


spm_fi_tcl_SPM_HistoryTrigger::~spm_fi_tcl_SPM_HistoryTrigger()
{}

tU32 spm_fi_tcl_SPM_HistoryTrigger::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& spm_fi_tcl_SPM_HistoryTrigger::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Timestamp);
   (tVoid) (oIn >> eTriggerType);
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_HistoryTrigger::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Timestamp);
   (tVoid) (oOut << eTriggerType);
   return oOut;
}

tBool spm_fi_tcl_SPM_HistoryTrigger::operator==(const spm_fi_tcl_SPM_HistoryTrigger& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Timestamp == roRef.u32Timestamp);
   bResult = bResult && (eTriggerType == roRef.eTriggerType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_RESTART_TYPE::spm_fi_tcl_SPM_e32_RESTART_TYPE():enType(FI_EN_SPM_U32_RESTART_ECU) {}

tS32 spm_fi_tcl_SPM_e32_RESTART_TYPE::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_RESTART_TYPE;
}


spm_fi_tcl_SPM_e32_RESTART_TYPE::~spm_fi_tcl_SPM_e32_RESTART_TYPE()
{}

tU32 spm_fi_tcl_SPM_e32_RESTART_TYPE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_RESTART_TYPE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_RESTART_TYPE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_CODE_REQUEST::spm_fi_tcl_SPM_e32_CODE_REQUEST():enType(FI_EN_SPM_U32_CODE_IDLE) {}

tS32 spm_fi_tcl_SPM_e32_CODE_REQUEST::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_CODE_REQUEST;
}


spm_fi_tcl_SPM_e32_CODE_REQUEST::~spm_fi_tcl_SPM_e32_CODE_REQUEST()
{}

tU32 spm_fi_tcl_SPM_e32_CODE_REQUEST::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_CODE_REQUEST::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_CODE_REQUEST::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_WAKEUP_REASON::spm_fi_tcl_SPM_e32_WAKEUP_REASON():enType(FI_EN_SPM_U32_WAKEUP_INVALID) {}

tS32 spm_fi_tcl_SPM_e32_WAKEUP_REASON::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_WAKEUP_REASON;
}


spm_fi_tcl_SPM_e32_WAKEUP_REASON::~spm_fi_tcl_SPM_e32_WAKEUP_REASON()
{}

tU32 spm_fi_tcl_SPM_e32_WAKEUP_REASON::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_WAKEUP_REASON::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_WAKEUP_REASON::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_MEDIA_EJECT_STATE::spm_fi_tcl_SPM_e32_MEDIA_EJECT_STATE():enType(FI_EN_SPM_U32_EJECT_RELEASED) {}

tS32 spm_fi_tcl_SPM_e32_MEDIA_EJECT_STATE::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_MEDIA_EJECT_STATE;
}


spm_fi_tcl_SPM_e32_MEDIA_EJECT_STATE::~spm_fi_tcl_SPM_e32_MEDIA_EJECT_STATE()
{}

tU32 spm_fi_tcl_SPM_e32_MEDIA_EJECT_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_MEDIA_EJECT_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_MEDIA_EJECT_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_KEY_STATE::spm_fi_tcl_SPM_e32_KEY_STATE():enType(FI_EN_SPM_U32_RELEASED) {}

tS32 spm_fi_tcl_SPM_e32_KEY_STATE::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_KEY_STATE;
}


spm_fi_tcl_SPM_e32_KEY_STATE::~spm_fi_tcl_SPM_e32_KEY_STATE()
{}

tU32 spm_fi_tcl_SPM_e32_KEY_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_KEY_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_KEY_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_SECURITY_STATE::spm_fi_tcl_SPM_e32_SECURITY_STATE():enType(FI_EN_SPM_U32_SECURITY_STATE_NO_VIN) {}

tS32 spm_fi_tcl_SPM_e32_SECURITY_STATE::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_SECURITY_STATE;
}


spm_fi_tcl_SPM_e32_SECURITY_STATE::~spm_fi_tcl_SPM_e32_SECURITY_STATE()
{}

tU32 spm_fi_tcl_SPM_e32_SECURITY_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_SECURITY_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_SECURITY_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_STARTUP_REASON::spm_fi_tcl_SPM_e32_STARTUP_REASON():enType(FI_EN_SPM_U32_STARTUP_ON_EJECT) {}

tS32 spm_fi_tcl_SPM_e32_STARTUP_REASON::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_STARTUP_REASON;
}


spm_fi_tcl_SPM_e32_STARTUP_REASON::~spm_fi_tcl_SPM_e32_STARTUP_REASON()
{}

tU32 spm_fi_tcl_SPM_e32_STARTUP_REASON::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_STARTUP_REASON::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_STARTUP_REASON::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_PHONE_MUTE_STATE::spm_fi_tcl_SPM_e32_PHONE_MUTE_STATE():enType(FI_EN_SPM_U32_PHONEMUTE_INACTIVE) {}

tS32 spm_fi_tcl_SPM_e32_PHONE_MUTE_STATE::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_PHONE_MUTE_STATE;
}


spm_fi_tcl_SPM_e32_PHONE_MUTE_STATE::~spm_fi_tcl_SPM_e32_PHONE_MUTE_STATE()
{}

tU32 spm_fi_tcl_SPM_e32_PHONE_MUTE_STATE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_PHONE_MUTE_STATE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_PHONE_MUTE_STATE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_e8_ResetReason::spm_fi_tcl_e8_ResetReason():enType(FI_EN_SPM_EHMI_COPRO_NO_REASON) {}

tS32 spm_fi_tcl_e8_ResetReason::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_E8_RESETREASON;
}


spm_fi_tcl_e8_ResetReason::~spm_fi_tcl_e8_ResetReason()
{}

tU32 spm_fi_tcl_e8_ResetReason::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_fi_tcl_e8_ResetReason::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_e8_ResetReason::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_e8_LcmResetReason::spm_fi_tcl_e8_LcmResetReason():enType(FI_EN_SPM_EHMI_APP_ERROR) {}

tS32 spm_fi_tcl_e8_LcmResetReason::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_E8_LCMRESETREASON;
}


spm_fi_tcl_e8_LcmResetReason::~spm_fi_tcl_e8_LcmResetReason()
{}

tU32 spm_fi_tcl_e8_LcmResetReason::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_fi_tcl_e8_LcmResetReason::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_e8_LcmResetReason::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_CVM_EVENT::spm_fi_tcl_SPM_e32_CVM_EVENT():enType(FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_START) {}

tS32 spm_fi_tcl_SPM_e32_CVM_EVENT::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_CVM_EVENT;
}


spm_fi_tcl_SPM_e32_CVM_EVENT::~spm_fi_tcl_SPM_e32_CVM_EVENT()
{}

tU32 spm_fi_tcl_SPM_e32_CVM_EVENT::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_CVM_EVENT::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_CVM_EVENT::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_SYSPWRMODE::spm_fi_tcl_SPM_e32_SYSPWRMODE():enType(FI_EN_SPM_U32_SYSPWRMODE_UNDEFINED) {}

tS32 spm_fi_tcl_SPM_e32_SYSPWRMODE::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_SYSPWRMODE;
}


spm_fi_tcl_SPM_e32_SYSPWRMODE::~spm_fi_tcl_SPM_e32_SYSPWRMODE()
{}

tU32 spm_fi_tcl_SPM_e32_SYSPWRMODE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_SYSPWRMODE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_SYSPWRMODE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e8_WAKEUP_LIST_REASON::spm_fi_tcl_SPM_e8_WAKEUP_LIST_REASON():enType(FI_EN_SPM_U8_WAKEUP_INVALID) {}

tS32 spm_fi_tcl_SPM_e8_WAKEUP_LIST_REASON::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E8_WAKEUP_LIST_REASON;
}


spm_fi_tcl_SPM_e8_WAKEUP_LIST_REASON::~spm_fi_tcl_SPM_e8_WAKEUP_LIST_REASON()
{}

tU32 spm_fi_tcl_SPM_e8_WAKEUP_LIST_REASON::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_fi_tcl_SPM_e8_WAKEUP_LIST_REASON::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e8_WAKEUP_LIST_REASON::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_SPM_TransPortMode::spm_fi_tcl_SPM_TransPortMode(const spm_fi_tcl_SPM_TransPortMode& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   YEAR = coRef.YEAR;
   MONTH = coRef.MONTH;
   DAY = coRef.DAY;
   HOUR = coRef.HOUR;
   MINUTE = coRef.MINUTE;
}
spm_fi_tcl_SPM_TransPortMode& spm_fi_tcl_SPM_TransPortMode::operator=(const spm_fi_tcl_SPM_TransPortMode& coRef)
{
   if (this == &coRef) return *this;
   YEAR = coRef.YEAR;
   MONTH = coRef.MONTH;
   DAY = coRef.DAY;
   HOUR = coRef.HOUR;
   MINUTE = coRef.MINUTE;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_TransPortMode::spm_fi_tcl_SPM_TransPortMode()
:YEAR(0)
,MONTH(0)
,DAY(0)
,HOUR(0)
,MINUTE(0)
 {}

tS32 spm_fi_tcl_SPM_TransPortMode::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_TRANSPORTMODE;
}


spm_fi_tcl_SPM_TransPortMode::~spm_fi_tcl_SPM_TransPortMode()
{}

tU32 spm_fi_tcl_SPM_TransPortMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 20;
}

fi_tclInContext& spm_fi_tcl_SPM_TransPortMode::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> YEAR);
   (tVoid) (oIn >> MONTH);
   (tVoid) (oIn >> DAY);
   (tVoid) (oIn >> HOUR);
   (tVoid) (oIn >> MINUTE);
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_TransPortMode::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << YEAR);
   (tVoid) (oOut << MONTH);
   (tVoid) (oOut << DAY);
   (tVoid) (oOut << HOUR);
   (tVoid) (oOut << MINUTE);
   return oOut;
}

tBool spm_fi_tcl_SPM_TransPortMode::operator==(const spm_fi_tcl_SPM_TransPortMode& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (YEAR == roRef.YEAR);
   bResult = bResult && (MONTH == roRef.MONTH);
   bResult = bResult && (DAY == roRef.DAY);
   bResult = bResult && (HOUR == roRef.HOUR);
   bResult = bResult && (MINUTE == roRef.MINUTE);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_SPM_TransPortModeList::spm_fi_tcl_SPM_TransPortModeList(const spm_fi_tcl_SPM_TransPortModeList& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   TransPortModeList = coRef.TransPortModeList;
}
spm_fi_tcl_SPM_TransPortModeList& spm_fi_tcl_SPM_TransPortModeList::operator=(const spm_fi_tcl_SPM_TransPortModeList& coRef)
{
   if (this == &coRef) return *this;
   TransPortModeList = coRef.TransPortModeList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_fi_tcl_SPM_TransPortModeList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TransPortModeList.size(); ++u32Idx)
         TransPortModeList[u32Idx].vDestroy();
   TransPortModeList.clear();
   }
}

spm_fi_tcl_SPM_TransPortModeList::spm_fi_tcl_SPM_TransPortModeList()

 {}

tS32 spm_fi_tcl_SPM_TransPortModeList::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_TRANSPORTMODELIST;
}


spm_fi_tcl_SPM_TransPortModeList::~spm_fi_tcl_SPM_TransPortModeList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_fi_tcl_SPM_TransPortModeList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(TransPortModeList.size()*20);
}

fi_tclInContext& spm_fi_tcl_SPM_TransPortModeList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TransPortModeList.size(); ++u32Idx)
      {
         TransPortModeList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TransPortModeList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TransPortModeList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_TransPortModeList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TransPortModeList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TransPortModeList.size(); ++u32Idx)
         (tVoid) (oOut << TransPortModeList[u32Idx]);
   }
   return oOut;
}

tBool spm_fi_tcl_SPM_TransPortModeList::operator==(const spm_fi_tcl_SPM_TransPortModeList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TransPortModeList.size() == roRef.TransPortModeList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TransPortModeList.size()); ++u32Idx)
            bResult = bResult && (TransPortModeList[u32Idx] == roRef.TransPortModeList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_e8_StateModes::spm_fi_tcl_e8_StateModes():enType(FI_EN_SPM_E8_SYSMODEDOWNLOAD) {}

tS32 spm_fi_tcl_e8_StateModes::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_E8_STATEMODES;
}


spm_fi_tcl_e8_StateModes::~spm_fi_tcl_e8_StateModes()
{}

tU32 spm_fi_tcl_e8_StateModes::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_fi_tcl_e8_StateModes::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_e8_StateModes::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_e8_StateEntryType::spm_fi_tcl_e8_StateEntryType():enType(FI_EN_SPM_E8_HISTORYENTRYWAKEUP) {}

tS32 spm_fi_tcl_e8_StateEntryType::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_E8_STATEENTRYTYPE;
}


spm_fi_tcl_e8_StateEntryType::~spm_fi_tcl_e8_StateEntryType()
{}

tU32 spm_fi_tcl_e8_StateEntryType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_fi_tcl_e8_StateEntryType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_e8_StateEntryType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_SubStateEntry::spm_fi_tcl_SubStateEntry(const spm_fi_tcl_SubStateEntry& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   tSubStateMask0 = coRef.tSubStateMask0;
   tSubStateData0 = coRef.tSubStateData0;
   tSubStateMask1 = coRef.tSubStateMask1;
   tSubStateData1 = coRef.tSubStateData1;
   tSubStateMask2 = coRef.tSubStateMask2;
   tSubStateData2 = coRef.tSubStateData2;
   tSubStateMask3 = coRef.tSubStateMask3;
   tSubStateData3 = coRef.tSubStateData3;
}
spm_fi_tcl_SubStateEntry& spm_fi_tcl_SubStateEntry::operator=(const spm_fi_tcl_SubStateEntry& coRef)
{
   if (this == &coRef) return *this;
   tSubStateMask0 = coRef.tSubStateMask0;
   tSubStateData0 = coRef.tSubStateData0;
   tSubStateMask1 = coRef.tSubStateMask1;
   tSubStateData1 = coRef.tSubStateData1;
   tSubStateMask2 = coRef.tSubStateMask2;
   tSubStateData2 = coRef.tSubStateData2;
   tSubStateMask3 = coRef.tSubStateMask3;
   tSubStateData3 = coRef.tSubStateData3;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SubStateEntry::spm_fi_tcl_SubStateEntry()
:tSubStateMask0()
,tSubStateData0()
,tSubStateMask1()
,tSubStateData1()
,tSubStateMask2()
,tSubStateData2()
,tSubStateMask3()
,tSubStateData3()
 {}

tS32 spm_fi_tcl_SubStateEntry::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SUBSTATEENTRY;
}


spm_fi_tcl_SubStateEntry::~spm_fi_tcl_SubStateEntry()
{}

tU32 spm_fi_tcl_SubStateEntry::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 32;
}

fi_tclInContext& spm_fi_tcl_SubStateEntry::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tSubStateMask0);
   (tVoid) (oIn >> tSubStateData0);
   (tVoid) (oIn >> tSubStateMask1);
   (tVoid) (oIn >> tSubStateData1);
   (tVoid) (oIn >> tSubStateMask2);
   (tVoid) (oIn >> tSubStateData2);
   (tVoid) (oIn >> tSubStateMask3);
   (tVoid) (oIn >> tSubStateData3);
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SubStateEntry::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tSubStateMask0);
   (tVoid) (oOut << tSubStateData0);
   (tVoid) (oOut << tSubStateMask1);
   (tVoid) (oOut << tSubStateData1);
   (tVoid) (oOut << tSubStateMask2);
   (tVoid) (oOut << tSubStateData2);
   (tVoid) (oOut << tSubStateMask3);
   (tVoid) (oOut << tSubStateData3);
   return oOut;
}

tBool spm_fi_tcl_SubStateEntry::operator==(const spm_fi_tcl_SubStateEntry& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tSubStateMask0 == roRef.tSubStateMask0);
   bResult = bResult && (tSubStateData0 == roRef.tSubStateData0);
   bResult = bResult && (tSubStateMask1 == roRef.tSubStateMask1);
   bResult = bResult && (tSubStateData1 == roRef.tSubStateData1);
   bResult = bResult && (tSubStateMask2 == roRef.tSubStateMask2);
   bResult = bResult && (tSubStateData2 == roRef.tSubStateData2);
   bResult = bResult && (tSubStateMask3 == roRef.tSubStateMask3);
   bResult = bResult && (tSubStateData3 == roRef.tSubStateData3);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_e8_DownloadLockStates::spm_fi_tcl_e8_DownloadLockStates():enType(FI_EN_SPM_E8_DOWNLOADLOCK) {}

tS32 spm_fi_tcl_e8_DownloadLockStates::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_E8_DOWNLOADLOCKSTATES;
}


spm_fi_tcl_e8_DownloadLockStates::~spm_fi_tcl_e8_DownloadLockStates()
{}

tU32 spm_fi_tcl_e8_DownloadLockStates::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_fi_tcl_e8_DownloadLockStates::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_e8_DownloadLockStates::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_e8_ProcessState::spm_fi_tcl_e8_ProcessState():enType(FI_EN_SPM_E8_PROCESSTOSTART) {}

tS32 spm_fi_tcl_e8_ProcessState::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_E8_PROCESSSTATE;
}


spm_fi_tcl_e8_ProcessState::~spm_fi_tcl_e8_ProcessState()
{}

tU32 spm_fi_tcl_e8_ProcessState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_fi_tcl_e8_ProcessState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_e8_ProcessState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_ProcessElement::spm_fi_tcl_ProcessElement(const spm_fi_tcl_ProcessElement& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   tProcessName = coRef.tProcessName;
   tConfiguredProcessName = coRef.tConfiguredProcessName;
   eProcState = coRef.eProcState;
   u32StartTimeSinceStart = coRef.u32StartTimeSinceStart;
   tSwitchOnDate = coRef.tSwitchOnDate;
}
spm_fi_tcl_ProcessElement& spm_fi_tcl_ProcessElement::operator=(const spm_fi_tcl_ProcessElement& coRef)
{
   if (this == &coRef) return *this;
   tProcessName = coRef.tProcessName;
   tConfiguredProcessName = coRef.tConfiguredProcessName;
   eProcState = coRef.eProcState;
   u32StartTimeSinceStart = coRef.u32StartTimeSinceStart;
   tSwitchOnDate = coRef.tSwitchOnDate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_fi_tcl_ProcessElement::vDestroy()
{
   tProcessName.vDestroy();
   tConfiguredProcessName.vDestroy();
   tSwitchOnDate.vDestroy(); 
}

spm_fi_tcl_ProcessElement::spm_fi_tcl_ProcessElement()
:tProcessName()
,tConfiguredProcessName()
,eProcState()
,u32StartTimeSinceStart(0)
,tSwitchOnDate()
 {}

tS32 spm_fi_tcl_ProcessElement::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_PROCESSELEMENT;
}


spm_fi_tcl_ProcessElement::~spm_fi_tcl_ProcessElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_fi_tcl_ProcessElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 12+tProcessName.u32GetSize(u16MajorVersion)+tConfiguredProcessName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_fi_tcl_ProcessElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tProcessName);
   (tVoid) (oIn >> tConfiguredProcessName);
   (tVoid) (oIn >> eProcState);
   (tVoid) (oIn >> u32StartTimeSinceStart);
   (tVoid) (oIn >> tSwitchOnDate);
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_ProcessElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tProcessName);
   (tVoid) (oOut << tConfiguredProcessName);
   (tVoid) (oOut << eProcState);
   (tVoid) (oOut << u32StartTimeSinceStart);
   (tVoid) (oOut << tSwitchOnDate);
   return oOut;
}

tBool spm_fi_tcl_ProcessElement::operator==(const spm_fi_tcl_ProcessElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tProcessName == roRef.tProcessName);
   bResult = bResult && (tConfiguredProcessName == roRef.tConfiguredProcessName);
   bResult = bResult && (eProcState == roRef.eProcState);
   bResult = bResult && (u32StartTimeSinceStart == roRef.u32StartTimeSinceStart);
   bResult = bResult && (tSwitchOnDate == roRef.tSwitchOnDate);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_SPM_ProcessInfo::spm_fi_tcl_SPM_ProcessInfo(const spm_fi_tcl_SPM_ProcessInfo& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   tProcesses = coRef.tProcesses;
}
spm_fi_tcl_SPM_ProcessInfo& spm_fi_tcl_SPM_ProcessInfo::operator=(const spm_fi_tcl_SPM_ProcessInfo& coRef)
{
   if (this == &coRef) return *this;
   tProcesses = coRef.tProcesses;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_fi_tcl_SPM_ProcessInfo::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tProcesses.size(); ++u32Idx)
         tProcesses[u32Idx].vDestroy();
   tProcesses.clear();
   }
}

spm_fi_tcl_SPM_ProcessInfo::spm_fi_tcl_SPM_ProcessInfo()

 {}

tS32 spm_fi_tcl_SPM_ProcessInfo::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_PROCESSINFO;
}


spm_fi_tcl_SPM_ProcessInfo::~spm_fi_tcl_SPM_ProcessInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_fi_tcl_SPM_ProcessInfo::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < tProcesses.size(); ++u32ListIdx)
      u32DynamicSize += tProcesses[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& spm_fi_tcl_SPM_ProcessInfo::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tProcesses.size(); ++u32Idx)
      {
         tProcesses[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tProcesses.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tProcesses[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_ProcessInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tProcesses.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tProcesses.size(); ++u32Idx)
         (tVoid) (oOut << tProcesses[u32Idx]);
   }
   return oOut;
}

tBool spm_fi_tcl_SPM_ProcessInfo::operator==(const spm_fi_tcl_SPM_ProcessInfo& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tProcesses.size() == roRef.tProcesses.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tProcesses.size()); ++u32Idx)
            bResult = bResult && (tProcesses[u32Idx] == roRef.tProcesses[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_SPM_Vin::spm_fi_tcl_SPM_Vin(const spm_fi_tcl_SPM_Vin& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   Vin = coRef.Vin;
}
spm_fi_tcl_SPM_Vin& spm_fi_tcl_SPM_Vin::operator=(const spm_fi_tcl_SPM_Vin& coRef)
{
   if (this == &coRef) return *this;
   Vin = coRef.Vin;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_fi_tcl_SPM_Vin::vDestroy()
{
   {
   Vin.clear();
   }
}

spm_fi_tcl_SPM_Vin::spm_fi_tcl_SPM_Vin()

 {}

tS32 spm_fi_tcl_SPM_Vin::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_VIN;
}


spm_fi_tcl_SPM_Vin::~spm_fi_tcl_SPM_Vin()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_fi_tcl_SPM_Vin::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(Vin.size()*1);
}

fi_tclInContext& spm_fi_tcl_SPM_Vin::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      Vin.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Vin[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_Vin::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Vin.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Vin.size(); ++u32Idx)
         (tVoid) (oOut << Vin[u32Idx]);
   }
   return oOut;
}

tBool spm_fi_tcl_SPM_Vin::operator==(const spm_fi_tcl_SPM_Vin& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Vin.size() == roRef.Vin.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Vin.size()); ++u32Idx)
            bResult = bResult && (Vin[u32Idx] == roRef.Vin[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_SPM_VinHistory::spm_fi_tcl_SPM_VinHistory(const spm_fi_tcl_SPM_VinHistory& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   VinHistory = coRef.VinHistory;
}
spm_fi_tcl_SPM_VinHistory& spm_fi_tcl_SPM_VinHistory::operator=(const spm_fi_tcl_SPM_VinHistory& coRef)
{
   if (this == &coRef) return *this;
   VinHistory = coRef.VinHistory;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_fi_tcl_SPM_VinHistory::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < VinHistory.size(); ++u32Idx)
         VinHistory[u32Idx].vDestroy();
   VinHistory.clear();
   }
}

spm_fi_tcl_SPM_VinHistory::spm_fi_tcl_SPM_VinHistory()

 {}

tS32 spm_fi_tcl_SPM_VinHistory::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_VINHISTORY;
}


spm_fi_tcl_SPM_VinHistory::~spm_fi_tcl_SPM_VinHistory()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_fi_tcl_SPM_VinHistory::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < VinHistory.size(); ++u32ListIdx)
      u32DynamicSize += VinHistory[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& spm_fi_tcl_SPM_VinHistory::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < VinHistory.size(); ++u32Idx)
      {
         VinHistory[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      VinHistory.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> VinHistory[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_VinHistory::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)VinHistory.size());
   {
      for (tU32 u32Idx = 0; u32Idx < VinHistory.size(); ++u32Idx)
         (tVoid) (oOut << VinHistory[u32Idx]);
   }
   return oOut;
}

tBool spm_fi_tcl_SPM_VinHistory::operator==(const spm_fi_tcl_SPM_VinHistory& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (VinHistory.size() == roRef.VinHistory.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < VinHistory.size()); ++u32Idx)
            bResult = bResult && (VinHistory[u32Idx] == roRef.VinHistory[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_ResetElement::spm_fi_tcl_ResetElement(const spm_fi_tcl_ResetElement& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   tResetDate = coRef.tResetDate;
   tSwVersionInfo = coRef.tSwVersionInfo;
   eReset = coRef.eReset;
}
spm_fi_tcl_ResetElement& spm_fi_tcl_ResetElement::operator=(const spm_fi_tcl_ResetElement& coRef)
{
   if (this == &coRef) return *this;
   tResetDate = coRef.tResetDate;
   tSwVersionInfo = coRef.tSwVersionInfo;
   eReset = coRef.eReset;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_fi_tcl_ResetElement::vDestroy()
{
   tResetDate.vDestroy(); 
   tSwVersionInfo.vDestroy(); 
}

spm_fi_tcl_ResetElement::spm_fi_tcl_ResetElement()
:tResetDate()
,tSwVersionInfo()
,eReset()
 {}

tS32 spm_fi_tcl_ResetElement::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_RESETELEMENT;
}


spm_fi_tcl_ResetElement::~spm_fi_tcl_ResetElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_fi_tcl_ResetElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+tSwVersionInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_fi_tcl_ResetElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tResetDate);
   (tVoid) (oIn >> tSwVersionInfo);
   (tVoid) (oIn >> eReset);
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_ResetElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tResetDate);
   (tVoid) (oOut << tSwVersionInfo);
   (tVoid) (oOut << eReset);
   return oOut;
}

tBool spm_fi_tcl_ResetElement::operator==(const spm_fi_tcl_ResetElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tResetDate == roRef.tResetDate);
   bResult = bResult && (tSwVersionInfo == roRef.tSwVersionInfo);
   bResult = bResult && (eReset == roRef.eReset);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_WakeupElement::spm_fi_tcl_WakeupElement(const spm_fi_tcl_WakeupElement& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   tWakeupDate = coRef.tWakeupDate;
   eWakeupReason = coRef.eWakeupReason;
}
spm_fi_tcl_WakeupElement& spm_fi_tcl_WakeupElement::operator=(const spm_fi_tcl_WakeupElement& coRef)
{
   if (this == &coRef) return *this;
   tWakeupDate = coRef.tWakeupDate;
   eWakeupReason = coRef.eWakeupReason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_WakeupElement::spm_fi_tcl_WakeupElement()
:tWakeupDate()
,eWakeupReason()
 {}

tS32 spm_fi_tcl_WakeupElement::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_WAKEUPELEMENT;
}


spm_fi_tcl_WakeupElement::~spm_fi_tcl_WakeupElement()
{}

tU32 spm_fi_tcl_WakeupElement::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& spm_fi_tcl_WakeupElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tWakeupDate);
   (tVoid) (oIn >> eWakeupReason);
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_WakeupElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tWakeupDate);
   (tVoid) (oOut << eWakeupReason);
   return oOut;
}

tBool spm_fi_tcl_WakeupElement::operator==(const spm_fi_tcl_WakeupElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tWakeupDate == roRef.tWakeupDate);
   bResult = bResult && (eWakeupReason == roRef.eWakeupReason);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_StateChangeElement::spm_fi_tcl_StateChangeElement(const spm_fi_tcl_StateChangeElement& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   tWakeupDate = coRef.tWakeupDate;
   tSysState = coRef.tSysState;
   tElemType = coRef.tElemType;
   tWakeup = coRef.tWakeup;
   tReset = coRef.tReset;
   tSubStates = coRef.tSubStates;
}
spm_fi_tcl_StateChangeElement& spm_fi_tcl_StateChangeElement::operator=(const spm_fi_tcl_StateChangeElement& coRef)
{
   if (this == &coRef) return *this;
   tWakeupDate = coRef.tWakeupDate;
   tSysState = coRef.tSysState;
   tElemType = coRef.tElemType;
   tWakeup = coRef.tWakeup;
   tReset = coRef.tReset;
   tSubStates = coRef.tSubStates;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_StateChangeElement::spm_fi_tcl_StateChangeElement()
:tWakeupDate()
,tSysState()
,tElemType()
,tWakeup()
,tReset()
,tSubStates()
 {}

tS32 spm_fi_tcl_StateChangeElement::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_STATECHANGEELEMENT;
}


spm_fi_tcl_StateChangeElement::~spm_fi_tcl_StateChangeElement()
{}

tU32 spm_fi_tcl_StateChangeElement::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 49;
}

fi_tclInContext& spm_fi_tcl_StateChangeElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tWakeupDate);
   (tVoid) (oIn >> tSysState);
   (tVoid) (oIn >> tElemType);
   (tVoid) (oIn >> tWakeup);
   (tVoid) (oIn >> tReset);
   (tVoid) (oIn >> tSubStates);
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_StateChangeElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tWakeupDate);
   (tVoid) (oOut << tSysState);
   (tVoid) (oOut << tElemType);
   (tVoid) (oOut << tWakeup);
   (tVoid) (oOut << tReset);
   (tVoid) (oOut << tSubStates);
   return oOut;
}

tBool spm_fi_tcl_StateChangeElement::operator==(const spm_fi_tcl_StateChangeElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tWakeupDate == roRef.tWakeupDate);
   bResult = bResult && (tSysState == roRef.tSysState);
   bResult = bResult && (tElemType == roRef.tElemType);
   bResult = bResult && (tWakeup == roRef.tWakeup);
   bResult = bResult && (tReset == roRef.tReset);
   bResult = bResult && (tSubStates == roRef.tSubStates);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_SwitchOnElement::spm_fi_tcl_SwitchOnElement(const spm_fi_tcl_SwitchOnElement& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   tSwitchOnDate = coRef.tSwitchOnDate;
   eSwitchOnReason = coRef.eSwitchOnReason;
}
spm_fi_tcl_SwitchOnElement& spm_fi_tcl_SwitchOnElement::operator=(const spm_fi_tcl_SwitchOnElement& coRef)
{
   if (this == &coRef) return *this;
   tSwitchOnDate = coRef.tSwitchOnDate;
   eSwitchOnReason = coRef.eSwitchOnReason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SwitchOnElement::spm_fi_tcl_SwitchOnElement()
:tSwitchOnDate()
,eSwitchOnReason()
 {}

tS32 spm_fi_tcl_SwitchOnElement::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SWITCHONELEMENT;
}


spm_fi_tcl_SwitchOnElement::~spm_fi_tcl_SwitchOnElement()
{}

tU32 spm_fi_tcl_SwitchOnElement::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& spm_fi_tcl_SwitchOnElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tSwitchOnDate);
   (tVoid) (oIn >> eSwitchOnReason);
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SwitchOnElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tSwitchOnDate);
   (tVoid) (oOut << eSwitchOnReason);
   return oOut;
}

tBool spm_fi_tcl_SwitchOnElement::operator==(const spm_fi_tcl_SwitchOnElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tSwitchOnDate == roRef.tSwitchOnDate);
   bResult = bResult && (eSwitchOnReason == roRef.eSwitchOnReason);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_START_PROC_TYPE::spm_fi_tcl_SPM_e32_START_PROC_TYPE():enType(FI_EN_SPM_U32_START_PROC_TYPE_OSAL_SPAWN) {}

tS32 spm_fi_tcl_SPM_e32_START_PROC_TYPE::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_START_PROC_TYPE;
}


spm_fi_tcl_SPM_e32_START_PROC_TYPE::~spm_fi_tcl_SPM_e32_START_PROC_TYPE()
{}

tU32 spm_fi_tcl_SPM_e32_START_PROC_TYPE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_START_PROC_TYPE::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_START_PROC_TYPE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_MRESULT::spm_fi_tcl_SPM_e32_MRESULT():enType(FI_EN_SPM_U32_MRESULT_NOK) {}

tS32 spm_fi_tcl_SPM_e32_MRESULT::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_MRESULT;
}


spm_fi_tcl_SPM_e32_MRESULT::~spm_fi_tcl_SPM_e32_MRESULT()
{}

tU32 spm_fi_tcl_SPM_e32_MRESULT::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_MRESULT::oRead(fi_tclInContext& oIn)
{
   tS32 s32Value;
   (tVoid) (oIn >> s32Value);
   enType = (tenType)s32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_MRESULT::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tS32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_RUNLEVEL::spm_fi_tcl_SPM_e32_RUNLEVEL():enType(FI_EN_SPM_U32_RUNLEVEL_LCM_STARTED) {}

tS32 spm_fi_tcl_SPM_e32_RUNLEVEL::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_RUNLEVEL;
}


spm_fi_tcl_SPM_e32_RUNLEVEL::~spm_fi_tcl_SPM_e32_RUNLEVEL()
{}

tU32 spm_fi_tcl_SPM_e32_RUNLEVEL::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_RUNLEVEL::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_RUNLEVEL::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_b32_SYSPWRSAVEMODE::spm_fi_tcl_SPM_b32_SYSPWRSAVEMODE():u32Value(0)
{}

tS32 spm_fi_tcl_SPM_b32_SYSPWRSAVEMODE::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_B32_SYSPWRSAVEMODE;
}


spm_fi_tcl_SPM_b32_SYSPWRSAVEMODE::~spm_fi_tcl_SPM_b32_SYSPWRSAVEMODE()
{}

tU32 spm_fi_tcl_SPM_b32_SYSPWRSAVEMODE::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_b32_SYSPWRSAVEMODE::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& spm_fi_tcl_SPM_b32_SYSPWRSAVEMODE::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_SPM_PartnumberItem::spm_fi_tcl_SPM_PartnumberItem(const spm_fi_tcl_SPM_PartnumberItem& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   Part = coRef.Part;
   Number = coRef.Number;
}
spm_fi_tcl_SPM_PartnumberItem& spm_fi_tcl_SPM_PartnumberItem::operator=(const spm_fi_tcl_SPM_PartnumberItem& coRef)
{
   if (this == &coRef) return *this;
   Part = coRef.Part;
   Number = coRef.Number;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_fi_tcl_SPM_PartnumberItem::vDestroy()
{
   Part.vDestroy();
}

spm_fi_tcl_SPM_PartnumberItem::spm_fi_tcl_SPM_PartnumberItem()
:Part()
,Number(0)
 {}

tS32 spm_fi_tcl_SPM_PartnumberItem::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_PARTNUMBERITEM;
}


spm_fi_tcl_SPM_PartnumberItem::~spm_fi_tcl_SPM_PartnumberItem()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_fi_tcl_SPM_PartnumberItem::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+Part.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_fi_tcl_SPM_PartnumberItem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Part);
   (tVoid) (oIn >> Number);
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_PartnumberItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Part);
   (tVoid) (oOut << Number);
   return oOut;
}

tBool spm_fi_tcl_SPM_PartnumberItem::operator==(const spm_fi_tcl_SPM_PartnumberItem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Part == roRef.Part);
   bResult = bResult && (Number == roRef.Number);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_SPM_PartnumberList::spm_fi_tcl_SPM_PartnumberList(const spm_fi_tcl_SPM_PartnumberList& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   Items = coRef.Items;
}
spm_fi_tcl_SPM_PartnumberList& spm_fi_tcl_SPM_PartnumberList::operator=(const spm_fi_tcl_SPM_PartnumberList& coRef)
{
   if (this == &coRef) return *this;
   Items = coRef.Items;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_fi_tcl_SPM_PartnumberList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Items.size(); ++u32Idx)
         Items[u32Idx].vDestroy();
   Items.clear();
   }
}

spm_fi_tcl_SPM_PartnumberList::spm_fi_tcl_SPM_PartnumberList()

 {}

tS32 spm_fi_tcl_SPM_PartnumberList::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_PARTNUMBERLIST;
}


spm_fi_tcl_SPM_PartnumberList::~spm_fi_tcl_SPM_PartnumberList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_fi_tcl_SPM_PartnumberList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Items.size(); ++u32ListIdx)
      u32DynamicSize += Items[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& spm_fi_tcl_SPM_PartnumberList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Items.size(); ++u32Idx)
      {
         Items[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Items.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Items[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_PartnumberList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Items.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Items.size(); ++u32Idx)
         (tVoid) (oOut << Items[u32Idx]);
   }
   return oOut;
}

tBool spm_fi_tcl_SPM_PartnumberList::operator==(const spm_fi_tcl_SPM_PartnumberList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Items.size() == roRef.Items.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Items.size()); ++u32Idx)
            bResult = bResult && (Items[u32Idx] == roRef.Items[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_SPM_AlphacodeItem::spm_fi_tcl_SPM_AlphacodeItem(const spm_fi_tcl_SPM_AlphacodeItem& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   Part = coRef.Part;
   Alphacode1 = coRef.Alphacode1;
   Alphacode2 = coRef.Alphacode2;
}
spm_fi_tcl_SPM_AlphacodeItem& spm_fi_tcl_SPM_AlphacodeItem::operator=(const spm_fi_tcl_SPM_AlphacodeItem& coRef)
{
   if (this == &coRef) return *this;
   Part = coRef.Part;
   Alphacode1 = coRef.Alphacode1;
   Alphacode2 = coRef.Alphacode2;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_fi_tcl_SPM_AlphacodeItem::vDestroy()
{
   Part.vDestroy();
}

spm_fi_tcl_SPM_AlphacodeItem::spm_fi_tcl_SPM_AlphacodeItem()
:Part()
,Alphacode1(0)
,Alphacode2(0)
 {}

tS32 spm_fi_tcl_SPM_AlphacodeItem::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_ALPHACODEITEM;
}


spm_fi_tcl_SPM_AlphacodeItem::~spm_fi_tcl_SPM_AlphacodeItem()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_fi_tcl_SPM_AlphacodeItem::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+Part.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_fi_tcl_SPM_AlphacodeItem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Part);
   (tVoid) (oIn >> Alphacode1);
   (tVoid) (oIn >> Alphacode2);
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_AlphacodeItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Part);
   (tVoid) (oOut << Alphacode1);
   (tVoid) (oOut << Alphacode2);
   return oOut;
}

tBool spm_fi_tcl_SPM_AlphacodeItem::operator==(const spm_fi_tcl_SPM_AlphacodeItem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Part == roRef.Part);
   bResult = bResult && (Alphacode1 == roRef.Alphacode1);
   bResult = bResult && (Alphacode2 == roRef.Alphacode2);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_SPM_AlphacodeList::spm_fi_tcl_SPM_AlphacodeList(const spm_fi_tcl_SPM_AlphacodeList& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   Items = coRef.Items;
}
spm_fi_tcl_SPM_AlphacodeList& spm_fi_tcl_SPM_AlphacodeList::operator=(const spm_fi_tcl_SPM_AlphacodeList& coRef)
{
   if (this == &coRef) return *this;
   Items = coRef.Items;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_fi_tcl_SPM_AlphacodeList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Items.size(); ++u32Idx)
         Items[u32Idx].vDestroy();
   Items.clear();
   }
}

spm_fi_tcl_SPM_AlphacodeList::spm_fi_tcl_SPM_AlphacodeList()

 {}

tS32 spm_fi_tcl_SPM_AlphacodeList::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_ALPHACODELIST;
}


spm_fi_tcl_SPM_AlphacodeList::~spm_fi_tcl_SPM_AlphacodeList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_fi_tcl_SPM_AlphacodeList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Items.size(); ++u32ListIdx)
      u32DynamicSize += Items[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& spm_fi_tcl_SPM_AlphacodeList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Items.size(); ++u32Idx)
      {
         Items[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Items.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Items[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_AlphacodeList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Items.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Items.size(); ++u32Idx)
         (tVoid) (oOut << Items[u32Idx]);
   }
   return oOut;
}

tBool spm_fi_tcl_SPM_AlphacodeList::operator==(const spm_fi_tcl_SPM_AlphacodeList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Items.size() == roRef.Items.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Items.size()); ++u32Idx)
            bResult = bResult && (Items[u32Idx] == roRef.Items[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_REDUCTION_LEVEL::spm_fi_tcl_SPM_e32_REDUCTION_LEVEL():enType(FI_EN_SPM_U32_REDUCTION_LEVEL_INACTIVE) {}

tS32 spm_fi_tcl_SPM_e32_REDUCTION_LEVEL::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_REDUCTION_LEVEL;
}


spm_fi_tcl_SPM_e32_REDUCTION_LEVEL::~spm_fi_tcl_SPM_e32_REDUCTION_LEVEL()
{}

tU32 spm_fi_tcl_SPM_e32_REDUCTION_LEVEL::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_REDUCTION_LEVEL::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_REDUCTION_LEVEL::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_e32_CLEAR_LIST::spm_fi_tcl_SPM_e32_CLEAR_LIST():enType(FI_EN_SPM_U32_CLEAR_LIST_ALL) {}

tS32 spm_fi_tcl_SPM_e32_CLEAR_LIST::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_E32_CLEAR_LIST;
}


spm_fi_tcl_SPM_e32_CLEAR_LIST::~spm_fi_tcl_SPM_e32_CLEAR_LIST()
{}

tU32 spm_fi_tcl_SPM_e32_CLEAR_LIST::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_fi_tcl_SPM_e32_CLEAR_LIST::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_e32_CLEAR_LIST::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_SPM_AppIdList::spm_fi_tcl_SPM_AppIdList(const spm_fi_tcl_SPM_AppIdList& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   tAppIdList = coRef.tAppIdList;
}
spm_fi_tcl_SPM_AppIdList& spm_fi_tcl_SPM_AppIdList::operator=(const spm_fi_tcl_SPM_AppIdList& coRef)
{
   if (this == &coRef) return *this;
   tAppIdList = coRef.tAppIdList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_fi_tcl_SPM_AppIdList::vDestroy()
{
   {
   tAppIdList.clear();
   }
}

spm_fi_tcl_SPM_AppIdList::spm_fi_tcl_SPM_AppIdList()

 {}

tS32 spm_fi_tcl_SPM_AppIdList::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_APPIDLIST;
}


spm_fi_tcl_SPM_AppIdList::~spm_fi_tcl_SPM_AppIdList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_fi_tcl_SPM_AppIdList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(tAppIdList.size()*2);
}

fi_tclInContext& spm_fi_tcl_SPM_AppIdList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      tAppIdList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tAppIdList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_AppIdList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tAppIdList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tAppIdList.size(); ++u32Idx)
         (tVoid) (oOut << tAppIdList[u32Idx]);
   }
   return oOut;
}

tBool spm_fi_tcl_SPM_AppIdList::operator==(const spm_fi_tcl_SPM_AppIdList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tAppIdList.size() == roRef.tAppIdList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tAppIdList.size()); ++u32Idx)
            bResult = bResult && (tAppIdList[u32Idx] == roRef.tAppIdList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_SPM_RestrictedDlLock::spm_fi_tcl_SPM_RestrictedDlLock(const spm_fi_tcl_SPM_RestrictedDlLock& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   strRestrictedLockArea = coRef.strRestrictedLockArea;
   u16AppIdLockOwner = coRef.u16AppIdLockOwner;
   u16AppIdLockRequester = coRef.u16AppIdLockRequester;
}
spm_fi_tcl_SPM_RestrictedDlLock& spm_fi_tcl_SPM_RestrictedDlLock::operator=(const spm_fi_tcl_SPM_RestrictedDlLock& coRef)
{
   if (this == &coRef) return *this;
   strRestrictedLockArea = coRef.strRestrictedLockArea;
   u16AppIdLockOwner = coRef.u16AppIdLockOwner;
   u16AppIdLockRequester = coRef.u16AppIdLockRequester;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_fi_tcl_SPM_RestrictedDlLock::vDestroy()
{
   strRestrictedLockArea.vDestroy();
}

spm_fi_tcl_SPM_RestrictedDlLock::spm_fi_tcl_SPM_RestrictedDlLock()
:strRestrictedLockArea()
,u16AppIdLockOwner(0)
,u16AppIdLockRequester(0)
 {}

tS32 spm_fi_tcl_SPM_RestrictedDlLock::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_RESTRICTEDDLLOCK;
}


spm_fi_tcl_SPM_RestrictedDlLock::~spm_fi_tcl_SPM_RestrictedDlLock()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_fi_tcl_SPM_RestrictedDlLock::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+strRestrictedLockArea.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_fi_tcl_SPM_RestrictedDlLock::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strRestrictedLockArea);
   (tVoid) (oIn >> u16AppIdLockOwner);
   (tVoid) (oIn >> u16AppIdLockRequester);
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_RestrictedDlLock::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strRestrictedLockArea);
   (tVoid) (oOut << u16AppIdLockOwner);
   (tVoid) (oOut << u16AppIdLockRequester);
   return oOut;
}

tBool spm_fi_tcl_SPM_RestrictedDlLock::operator==(const spm_fi_tcl_SPM_RestrictedDlLock& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strRestrictedLockArea == roRef.strRestrictedLockArea);
   bResult = bResult && (u16AppIdLockOwner == roRef.u16AppIdLockOwner);
   bResult = bResult && (u16AppIdLockRequester == roRef.u16AppIdLockRequester);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_e8_UpdateLockCommand::spm_fi_tcl_e8_UpdateLockCommand():enType(FI_EN_SPM_E8_USE) {}

tS32 spm_fi_tcl_e8_UpdateLockCommand::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_E8_UPDATELOCKCOMMAND;
}


spm_fi_tcl_e8_UpdateLockCommand::~spm_fi_tcl_e8_UpdateLockCommand()
{}

tU32 spm_fi_tcl_e8_UpdateLockCommand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_fi_tcl_e8_UpdateLockCommand::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_e8_UpdateLockCommand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_e8_UpdateLockState::spm_fi_tcl_e8_UpdateLockState():enType(FI_EN_SPM_E8_USED) {}

tS32 spm_fi_tcl_e8_UpdateLockState::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_E8_UPDATELOCKSTATE;
}


spm_fi_tcl_e8_UpdateLockState::~spm_fi_tcl_e8_UpdateLockState()
{}

tU32 spm_fi_tcl_e8_UpdateLockState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_fi_tcl_e8_UpdateLockState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_e8_UpdateLockState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_SPM_UpdateLockState::spm_fi_tcl_SPM_UpdateLockState(const spm_fi_tcl_SPM_UpdateLockState& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   strLockName = coRef.strLockName;
   eLockState = coRef.eLockState;
   u16LockOwner = coRef.u16LockOwner;
   lu16LockUsers = coRef.lu16LockUsers;
}
spm_fi_tcl_SPM_UpdateLockState& spm_fi_tcl_SPM_UpdateLockState::operator=(const spm_fi_tcl_SPM_UpdateLockState& coRef)
{
   if (this == &coRef) return *this;
   strLockName = coRef.strLockName;
   eLockState = coRef.eLockState;
   u16LockOwner = coRef.u16LockOwner;
   lu16LockUsers = coRef.lu16LockUsers;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_fi_tcl_SPM_UpdateLockState::vDestroy()
{
   strLockName.vDestroy();
   {
   lu16LockUsers.clear();
   }
}

spm_fi_tcl_SPM_UpdateLockState::spm_fi_tcl_SPM_UpdateLockState()
:strLockName()
,eLockState()
,u16LockOwner(0)

 {}

tS32 spm_fi_tcl_SPM_UpdateLockState::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_UPDATELOCKSTATE;
}


spm_fi_tcl_SPM_UpdateLockState::~spm_fi_tcl_SPM_UpdateLockState()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_fi_tcl_SPM_UpdateLockState::u32GetSize(tU16 u16MajorVersion) const
{
   return 7+strLockName.u32GetSize(u16MajorVersion)+ static_cast<tU32>(lu16LockUsers.size()*2);
}

fi_tclInContext& spm_fi_tcl_SPM_UpdateLockState::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strLockName);
   (tVoid) (oIn >> eLockState);
   (tVoid) (oIn >> u16LockOwner);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      lu16LockUsers.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> lu16LockUsers[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_UpdateLockState::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strLockName);
   (tVoid) (oOut << eLockState);
   (tVoid) (oOut << u16LockOwner);
   (tVoid) (oOut << (tU32)lu16LockUsers.size());
   {
      for (tU32 u32Idx = 0; u32Idx < lu16LockUsers.size(); ++u32Idx)
         (tVoid) (oOut << lu16LockUsers[u32Idx]);
   }
   return oOut;
}

tBool spm_fi_tcl_SPM_UpdateLockState::operator==(const spm_fi_tcl_SPM_UpdateLockState& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strLockName == roRef.strLockName);
   bResult = bResult && (eLockState == roRef.eLockState);
   bResult = bResult && (u16LockOwner == roRef.u16LockOwner);
      bResult = bResult && (lu16LockUsers.size() == roRef.lu16LockUsers.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < lu16LockUsers.size()); ++u32Idx)
            bResult = bResult && (lu16LockUsers[u32Idx] == roRef.lu16LockUsers[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_SPM_VoltageEventCounter::spm_fi_tcl_SPM_VoltageEventCounter(const spm_fi_tcl_SPM_VoltageEventCounter& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   LowVoltageCount = coRef.LowVoltageCount;
   CrLowVoltageCount = coRef.CrLowVoltageCount;
   HighVoltageCount = coRef.HighVoltageCount;
   CrHighVoltageCount = coRef.CrHighVoltageCount;
}
spm_fi_tcl_SPM_VoltageEventCounter& spm_fi_tcl_SPM_VoltageEventCounter::operator=(const spm_fi_tcl_SPM_VoltageEventCounter& coRef)
{
   if (this == &coRef) return *this;
   LowVoltageCount = coRef.LowVoltageCount;
   CrLowVoltageCount = coRef.CrLowVoltageCount;
   HighVoltageCount = coRef.HighVoltageCount;
   CrHighVoltageCount = coRef.CrHighVoltageCount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_VoltageEventCounter::spm_fi_tcl_SPM_VoltageEventCounter()
:LowVoltageCount(0)
,CrLowVoltageCount(0)
,HighVoltageCount(0)
,CrHighVoltageCount(0)
 {}

tS32 spm_fi_tcl_SPM_VoltageEventCounter::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_VOLTAGEEVENTCOUNTER;
}


spm_fi_tcl_SPM_VoltageEventCounter::~spm_fi_tcl_SPM_VoltageEventCounter()
{}

tU32 spm_fi_tcl_SPM_VoltageEventCounter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& spm_fi_tcl_SPM_VoltageEventCounter::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LowVoltageCount);
   (tVoid) (oIn >> CrLowVoltageCount);
   (tVoid) (oIn >> HighVoltageCount);
   (tVoid) (oIn >> CrHighVoltageCount);
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_VoltageEventCounter::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LowVoltageCount);
   (tVoid) (oOut << CrLowVoltageCount);
   (tVoid) (oOut << HighVoltageCount);
   (tVoid) (oOut << CrHighVoltageCount);
   return oOut;
}

tBool spm_fi_tcl_SPM_VoltageEventCounter::operator==(const spm_fi_tcl_SPM_VoltageEventCounter& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LowVoltageCount == roRef.LowVoltageCount);
   bResult = bResult && (CrLowVoltageCount == roRef.CrLowVoltageCount);
   bResult = bResult && (HighVoltageCount == roRef.HighVoltageCount);
   bResult = bResult && (CrHighVoltageCount == roRef.CrHighVoltageCount);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_SPM_VoltageRange::spm_fi_tcl_SPM_VoltageRange(const spm_fi_tcl_SPM_VoltageRange& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   VoltageValue = coRef.VoltageValue;
   OperationTime = coRef.OperationTime;
}
spm_fi_tcl_SPM_VoltageRange& spm_fi_tcl_SPM_VoltageRange::operator=(const spm_fi_tcl_SPM_VoltageRange& coRef)
{
   if (this == &coRef) return *this;
   VoltageValue = coRef.VoltageValue;
   OperationTime = coRef.OperationTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_VoltageRange::spm_fi_tcl_SPM_VoltageRange()
:VoltageValue(0)
,OperationTime(0)
 {}

tS32 spm_fi_tcl_SPM_VoltageRange::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_VOLTAGERANGE;
}


spm_fi_tcl_SPM_VoltageRange::~spm_fi_tcl_SPM_VoltageRange()
{}

tU32 spm_fi_tcl_SPM_VoltageRange::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& spm_fi_tcl_SPM_VoltageRange::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VoltageValue);
   (tVoid) (oIn >> OperationTime);
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_VoltageRange::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VoltageValue);
   (tVoid) (oOut << OperationTime);
   return oOut;
}

tBool spm_fi_tcl_SPM_VoltageRange::operator==(const spm_fi_tcl_SPM_VoltageRange& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VoltageValue == roRef.VoltageValue);
   bResult = bResult && (OperationTime == roRef.OperationTime);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_SPM_SystemStatisticsData::spm_fi_tcl_SPM_SystemStatisticsData(const spm_fi_tcl_SPM_SystemStatisticsData& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   MaxValue = coRef.MaxValue;
   AvgValue = coRef.AvgValue;
   MinValue = coRef.MinValue;
   StatisticDataDisabled = coRef.StatisticDataDisabled;
}
spm_fi_tcl_SPM_SystemStatisticsData& spm_fi_tcl_SPM_SystemStatisticsData::operator=(const spm_fi_tcl_SPM_SystemStatisticsData& coRef)
{
   if (this == &coRef) return *this;
   MaxValue = coRef.MaxValue;
   AvgValue = coRef.AvgValue;
   MinValue = coRef.MinValue;
   StatisticDataDisabled = coRef.StatisticDataDisabled;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_SystemStatisticsData::spm_fi_tcl_SPM_SystemStatisticsData()
:MaxValue(0)
,AvgValue(0)
,MinValue(0)
,StatisticDataDisabled(0)
 {}

tS32 spm_fi_tcl_SPM_SystemStatisticsData::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_SYSTEMSTATISTICSDATA;
}


spm_fi_tcl_SPM_SystemStatisticsData::~spm_fi_tcl_SPM_SystemStatisticsData()
{}

tU32 spm_fi_tcl_SPM_SystemStatisticsData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& spm_fi_tcl_SPM_SystemStatisticsData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MaxValue);
   (tVoid) (oIn >> AvgValue);
   (tVoid) (oIn >> MinValue);
   (tVoid) (oIn >> StatisticDataDisabled);
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_SystemStatisticsData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MaxValue);
   (tVoid) (oOut << AvgValue);
   (tVoid) (oOut << MinValue);
   (tVoid) (oOut << StatisticDataDisabled);
   return oOut;
}

tBool spm_fi_tcl_SPM_SystemStatisticsData::operator==(const spm_fi_tcl_SPM_SystemStatisticsData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MaxValue == roRef.MaxValue);
   bResult = bResult && (AvgValue == roRef.AvgValue);
   bResult = bResult && (MinValue == roRef.MinValue);
   bResult = bResult && (StatisticDataDisabled == roRef.StatisticDataDisabled);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_SPM_ResetInfoStatisticData::spm_fi_tcl_SPM_ResetInfoStatisticData(const spm_fi_tcl_SPM_ResetInfoStatisticData& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   tLastResetDate = coRef.tLastResetDate;
   tLastResetReason = coRef.tLastResetReason;
   u32ApApplicationError = coRef.u32ApApplicationError;
   u32ApSoftware = coRef.u32ApSoftware;
   u32ApEcuReset = coRef.u32ApEcuReset;
   u32ApDownload = coRef.u32ApDownload;
   u32ApDownloadError = coRef.u32ApDownloadError;
   u32ApOvertemperature = coRef.u32ApOvertemperature;
   u32ApUser = coRef.u32ApUser;
   u32ApLcmIntern = coRef.u32ApLcmIntern;
   u32ApWarmstartCount = coRef.u32ApWarmstartCount;
   u32ApPowerOnCount = coRef.u32ApPowerOnCount;
   u32ApPowerLossCount = coRef.u32ApPowerLossCount;
   u32ApPowerOffCount = coRef.u32ApPowerOffCount;
   u32ApSccCount = coRef.u32ApSccCount;
   u32ApUnknownCount = coRef.u32ApUnknownCount;
   u32SccHwWdtCount = coRef.u32SccHwWdtCount;
   u32SccPowerOnCount = coRef.u32SccPowerOnCount;
   u32SccColdstartCount = coRef.u32SccColdstartCount;
   u32SccAppmodeChangeCount = coRef.u32SccAppmodeChangeCount;
   u32SccDuringLpwCount = coRef.u32SccDuringLpwCount;
   u32SccDuringPllOszCount = coRef.u32SccDuringPllOszCount;
   u32SccDuringSWCount = coRef.u32SccDuringSWCount;
   u32SccWarmstartCount = coRef.u32SccWarmstartCount;
}
spm_fi_tcl_SPM_ResetInfoStatisticData& spm_fi_tcl_SPM_ResetInfoStatisticData::operator=(const spm_fi_tcl_SPM_ResetInfoStatisticData& coRef)
{
   if (this == &coRef) return *this;
   tLastResetDate = coRef.tLastResetDate;
   tLastResetReason = coRef.tLastResetReason;
   u32ApApplicationError = coRef.u32ApApplicationError;
   u32ApSoftware = coRef.u32ApSoftware;
   u32ApEcuReset = coRef.u32ApEcuReset;
   u32ApDownload = coRef.u32ApDownload;
   u32ApDownloadError = coRef.u32ApDownloadError;
   u32ApOvertemperature = coRef.u32ApOvertemperature;
   u32ApUser = coRef.u32ApUser;
   u32ApLcmIntern = coRef.u32ApLcmIntern;
   u32ApWarmstartCount = coRef.u32ApWarmstartCount;
   u32ApPowerOnCount = coRef.u32ApPowerOnCount;
   u32ApPowerLossCount = coRef.u32ApPowerLossCount;
   u32ApPowerOffCount = coRef.u32ApPowerOffCount;
   u32ApSccCount = coRef.u32ApSccCount;
   u32ApUnknownCount = coRef.u32ApUnknownCount;
   u32SccHwWdtCount = coRef.u32SccHwWdtCount;
   u32SccPowerOnCount = coRef.u32SccPowerOnCount;
   u32SccColdstartCount = coRef.u32SccColdstartCount;
   u32SccAppmodeChangeCount = coRef.u32SccAppmodeChangeCount;
   u32SccDuringLpwCount = coRef.u32SccDuringLpwCount;
   u32SccDuringPllOszCount = coRef.u32SccDuringPllOszCount;
   u32SccDuringSWCount = coRef.u32SccDuringSWCount;
   u32SccWarmstartCount = coRef.u32SccWarmstartCount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_SPM_ResetInfoStatisticData::spm_fi_tcl_SPM_ResetInfoStatisticData()
:tLastResetDate()
,tLastResetReason()
,u32ApApplicationError(0)
,u32ApSoftware(0)
,u32ApEcuReset(0)
,u32ApDownload(0)
,u32ApDownloadError(0)
,u32ApOvertemperature(0)
,u32ApUser(0)
,u32ApLcmIntern(0)
,u32ApWarmstartCount(0)
,u32ApPowerOnCount(0)
,u32ApPowerLossCount(0)
,u32ApPowerOffCount(0)
,u32ApSccCount(0)
,u32ApUnknownCount(0)
,u32SccHwWdtCount(0)
,u32SccPowerOnCount(0)
,u32SccColdstartCount(0)
,u32SccAppmodeChangeCount(0)
,u32SccDuringLpwCount(0)
,u32SccDuringPllOszCount(0)
,u32SccDuringSWCount(0)
,u32SccWarmstartCount(0)
 {}

tS32 spm_fi_tcl_SPM_ResetInfoStatisticData::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_RESETINFOSTATISTICDATA;
}


spm_fi_tcl_SPM_ResetInfoStatisticData::~spm_fi_tcl_SPM_ResetInfoStatisticData()
{}

tU32 spm_fi_tcl_SPM_ResetInfoStatisticData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 96;
}

fi_tclInContext& spm_fi_tcl_SPM_ResetInfoStatisticData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tLastResetDate);
   (tVoid) (oIn >> tLastResetReason);
   (tVoid) (oIn >> u32ApApplicationError);
   (tVoid) (oIn >> u32ApSoftware);
   (tVoid) (oIn >> u32ApEcuReset);
   (tVoid) (oIn >> u32ApDownload);
   (tVoid) (oIn >> u32ApDownloadError);
   (tVoid) (oIn >> u32ApOvertemperature);
   (tVoid) (oIn >> u32ApUser);
   (tVoid) (oIn >> u32ApLcmIntern);
   (tVoid) (oIn >> u32ApWarmstartCount);
   (tVoid) (oIn >> u32ApPowerOnCount);
   (tVoid) (oIn >> u32ApPowerLossCount);
   (tVoid) (oIn >> u32ApPowerOffCount);
   (tVoid) (oIn >> u32ApSccCount);
   (tVoid) (oIn >> u32ApUnknownCount);
   (tVoid) (oIn >> u32SccHwWdtCount);
   (tVoid) (oIn >> u32SccPowerOnCount);
   (tVoid) (oIn >> u32SccColdstartCount);
   (tVoid) (oIn >> u32SccAppmodeChangeCount);
   (tVoid) (oIn >> u32SccDuringLpwCount);
   (tVoid) (oIn >> u32SccDuringPllOszCount);
   (tVoid) (oIn >> u32SccDuringSWCount);
   (tVoid) (oIn >> u32SccWarmstartCount);
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_ResetInfoStatisticData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tLastResetDate);
   (tVoid) (oOut << tLastResetReason);
   (tVoid) (oOut << u32ApApplicationError);
   (tVoid) (oOut << u32ApSoftware);
   (tVoid) (oOut << u32ApEcuReset);
   (tVoid) (oOut << u32ApDownload);
   (tVoid) (oOut << u32ApDownloadError);
   (tVoid) (oOut << u32ApOvertemperature);
   (tVoid) (oOut << u32ApUser);
   (tVoid) (oOut << u32ApLcmIntern);
   (tVoid) (oOut << u32ApWarmstartCount);
   (tVoid) (oOut << u32ApPowerOnCount);
   (tVoid) (oOut << u32ApPowerLossCount);
   (tVoid) (oOut << u32ApPowerOffCount);
   (tVoid) (oOut << u32ApSccCount);
   (tVoid) (oOut << u32ApUnknownCount);
   (tVoid) (oOut << u32SccHwWdtCount);
   (tVoid) (oOut << u32SccPowerOnCount);
   (tVoid) (oOut << u32SccColdstartCount);
   (tVoid) (oOut << u32SccAppmodeChangeCount);
   (tVoid) (oOut << u32SccDuringLpwCount);
   (tVoid) (oOut << u32SccDuringPllOszCount);
   (tVoid) (oOut << u32SccDuringSWCount);
   (tVoid) (oOut << u32SccWarmstartCount);
   return oOut;
}

tBool spm_fi_tcl_SPM_ResetInfoStatisticData::operator==(const spm_fi_tcl_SPM_ResetInfoStatisticData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tLastResetDate == roRef.tLastResetDate);
   bResult = bResult && (tLastResetReason == roRef.tLastResetReason);
   bResult = bResult && (u32ApApplicationError == roRef.u32ApApplicationError);
   bResult = bResult && (u32ApSoftware == roRef.u32ApSoftware);
   bResult = bResult && (u32ApEcuReset == roRef.u32ApEcuReset);
   bResult = bResult && (u32ApDownload == roRef.u32ApDownload);
   bResult = bResult && (u32ApDownloadError == roRef.u32ApDownloadError);
   bResult = bResult && (u32ApOvertemperature == roRef.u32ApOvertemperature);
   bResult = bResult && (u32ApUser == roRef.u32ApUser);
   bResult = bResult && (u32ApLcmIntern == roRef.u32ApLcmIntern);
   bResult = bResult && (u32ApWarmstartCount == roRef.u32ApWarmstartCount);
   bResult = bResult && (u32ApPowerOnCount == roRef.u32ApPowerOnCount);
   bResult = bResult && (u32ApPowerLossCount == roRef.u32ApPowerLossCount);
   bResult = bResult && (u32ApPowerOffCount == roRef.u32ApPowerOffCount);
   bResult = bResult && (u32ApSccCount == roRef.u32ApSccCount);
   bResult = bResult && (u32ApUnknownCount == roRef.u32ApUnknownCount);
   bResult = bResult && (u32SccHwWdtCount == roRef.u32SccHwWdtCount);
   bResult = bResult && (u32SccPowerOnCount == roRef.u32SccPowerOnCount);
   bResult = bResult && (u32SccColdstartCount == roRef.u32SccColdstartCount);
   bResult = bResult && (u32SccAppmodeChangeCount == roRef.u32SccAppmodeChangeCount);
   bResult = bResult && (u32SccDuringLpwCount == roRef.u32SccDuringLpwCount);
   bResult = bResult && (u32SccDuringPllOszCount == roRef.u32SccDuringPllOszCount);
   bResult = bResult && (u32SccDuringSWCount == roRef.u32SccDuringSWCount);
   bResult = bResult && (u32SccWarmstartCount == roRef.u32SccWarmstartCount);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_fi_tcl_SPM_SWVersionStatisticData::spm_fi_tcl_SPM_SWVersionStatisticData(const spm_fi_tcl_SPM_SWVersionStatisticData& coRef)
   : spm_fi_tclVisitableTypeBase(coRef)
{
   strBuildVersion = coRef.strBuildVersion;
   strBuildVersionCustomer = coRef.strBuildVersionCustomer;
   strCustomerVersion = coRef.strCustomerVersion;
   tResetInfo = coRef.tResetInfo;
   tResetHistoryList = coRef.tResetHistoryList;
   tWakeupHistoryList = coRef.tWakeupHistoryList;
   tSwitchOnList = coRef.tSwitchOnList;
   tStateHistoryList = coRef.tStateHistoryList;
   tErrStateHistory01List = coRef.tErrStateHistory01List;
   tErrStateHistory02List = coRef.tErrStateHistory02List;
   tErrStateHistory03List = coRef.tErrStateHistory03List;
   tErrStateHistory04List = coRef.tErrStateHistory04List;
   tErrStateHistory05List = coRef.tErrStateHistory05List;
   u32SystemOperationTime = coRef.u32SystemOperationTime;
   tCpuUsage = coRef.tCpuUsage;
   tRamUsage = coRef.tRamUsage;
   tStartupTime = coRef.tStartupTime;
}
spm_fi_tcl_SPM_SWVersionStatisticData& spm_fi_tcl_SPM_SWVersionStatisticData::operator=(const spm_fi_tcl_SPM_SWVersionStatisticData& coRef)
{
   if (this == &coRef) return *this;
   strBuildVersion = coRef.strBuildVersion;
   strBuildVersionCustomer = coRef.strBuildVersionCustomer;
   strCustomerVersion = coRef.strCustomerVersion;
   tResetInfo = coRef.tResetInfo;
   tResetHistoryList = coRef.tResetHistoryList;
   tWakeupHistoryList = coRef.tWakeupHistoryList;
   tSwitchOnList = coRef.tSwitchOnList;
   tStateHistoryList = coRef.tStateHistoryList;
   tErrStateHistory01List = coRef.tErrStateHistory01List;
   tErrStateHistory02List = coRef.tErrStateHistory02List;
   tErrStateHistory03List = coRef.tErrStateHistory03List;
   tErrStateHistory04List = coRef.tErrStateHistory04List;
   tErrStateHistory05List = coRef.tErrStateHistory05List;
   u32SystemOperationTime = coRef.u32SystemOperationTime;
   tCpuUsage = coRef.tCpuUsage;
   tRamUsage = coRef.tRamUsage;
   tStartupTime = coRef.tStartupTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_fi_tcl_SPM_SWVersionStatisticData::vDestroy()
{
   strBuildVersion.vDestroy();
   strBuildVersionCustomer.vDestroy();
   strCustomerVersion.vDestroy();
   tResetInfo.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < tResetHistoryList.size(); ++u32Idx)
         tResetHistoryList[u32Idx].vDestroy();
   tResetHistoryList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < tWakeupHistoryList.size(); ++u32Idx)
         tWakeupHistoryList[u32Idx].vDestroy();
   tWakeupHistoryList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < tSwitchOnList.size(); ++u32Idx)
         tSwitchOnList[u32Idx].vDestroy();
   tSwitchOnList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < tStateHistoryList.size(); ++u32Idx)
         tStateHistoryList[u32Idx].vDestroy();
   tStateHistoryList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < tErrStateHistory01List.size(); ++u32Idx)
         tErrStateHistory01List[u32Idx].vDestroy();
   tErrStateHistory01List.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < tErrStateHistory02List.size(); ++u32Idx)
         tErrStateHistory02List[u32Idx].vDestroy();
   tErrStateHistory02List.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < tErrStateHistory03List.size(); ++u32Idx)
         tErrStateHistory03List[u32Idx].vDestroy();
   tErrStateHistory03List.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < tErrStateHistory04List.size(); ++u32Idx)
         tErrStateHistory04List[u32Idx].vDestroy();
   tErrStateHistory04List.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < tErrStateHistory05List.size(); ++u32Idx)
         tErrStateHistory05List[u32Idx].vDestroy();
   tErrStateHistory05List.clear();
   }
   tCpuUsage.vDestroy(); 
   tRamUsage.vDestroy(); 
   tStartupTime.vDestroy(); 
}

spm_fi_tcl_SPM_SWVersionStatisticData::spm_fi_tcl_SPM_SWVersionStatisticData()
:strBuildVersion()
,strBuildVersionCustomer()
,strCustomerVersion()
,tResetInfo()









,u32SystemOperationTime(0)
,tCpuUsage()
,tRamUsage()
,tStartupTime()
 {}

tS32 spm_fi_tcl_SPM_SWVersionStatisticData::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_SPM_SWVERSIONSTATISTICDATA;
}


spm_fi_tcl_SPM_SWVersionStatisticData::~spm_fi_tcl_SPM_SWVersionStatisticData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_fi_tcl_SPM_SWVersionStatisticData::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < tResetHistoryList.size(); ++u32ListIdx)
      u32DynamicSize += tResetHistoryList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+175+strBuildVersion.u32GetSize(u16MajorVersion)+strBuildVersionCustomer.u32GetSize(u16MajorVersion)+strCustomerVersion.u32GetSize(u16MajorVersion)+ static_cast<tU32>(tWakeupHistoryList.size()*11)+ static_cast<tU32>(tSwitchOnList.size()*11)+ static_cast<tU32>(tStateHistoryList.size()*49)+ static_cast<tU32>(tErrStateHistory01List.size()*49)+ static_cast<tU32>(tErrStateHistory02List.size()*49)+ static_cast<tU32>(tErrStateHistory03List.size()*49)+ static_cast<tU32>(tErrStateHistory04List.size()*49)+ static_cast<tU32>(tErrStateHistory05List.size()*49);
}

fi_tclInContext& spm_fi_tcl_SPM_SWVersionStatisticData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strBuildVersion);
   (tVoid) (oIn >> strBuildVersionCustomer);
   (tVoid) (oIn >> strCustomerVersion);
   (tVoid) (oIn >> tResetInfo);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tResetHistoryList.size(); ++u32Idx)
      {
         tResetHistoryList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tResetHistoryList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tResetHistoryList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tWakeupHistoryList.size(); ++u32Idx)
      {
         tWakeupHistoryList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tWakeupHistoryList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tWakeupHistoryList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tSwitchOnList.size(); ++u32Idx)
      {
         tSwitchOnList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tSwitchOnList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tSwitchOnList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tStateHistoryList.size(); ++u32Idx)
      {
         tStateHistoryList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tStateHistoryList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tStateHistoryList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tErrStateHistory01List.size(); ++u32Idx)
      {
         tErrStateHistory01List[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tErrStateHistory01List.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tErrStateHistory01List[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tErrStateHistory02List.size(); ++u32Idx)
      {
         tErrStateHistory02List[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tErrStateHistory02List.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tErrStateHistory02List[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tErrStateHistory03List.size(); ++u32Idx)
      {
         tErrStateHistory03List[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tErrStateHistory03List.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tErrStateHistory03List[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tErrStateHistory04List.size(); ++u32Idx)
      {
         tErrStateHistory04List[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tErrStateHistory04List.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tErrStateHistory04List[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tErrStateHistory05List.size(); ++u32Idx)
      {
         tErrStateHistory05List[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tErrStateHistory05List.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tErrStateHistory05List[u32Idx]);
      }
   }
   (tVoid) (oIn >> u32SystemOperationTime);
   (tVoid) (oIn >> tCpuUsage);
   (tVoid) (oIn >> tRamUsage);
   (tVoid) (oIn >> tStartupTime);
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_SPM_SWVersionStatisticData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strBuildVersion);
   (tVoid) (oOut << strBuildVersionCustomer);
   (tVoid) (oOut << strCustomerVersion);
   (tVoid) (oOut << tResetInfo);
   (tVoid) (oOut << (tU32)tResetHistoryList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tResetHistoryList.size(); ++u32Idx)
         (tVoid) (oOut << tResetHistoryList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)tWakeupHistoryList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tWakeupHistoryList.size(); ++u32Idx)
         (tVoid) (oOut << tWakeupHistoryList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)tSwitchOnList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tSwitchOnList.size(); ++u32Idx)
         (tVoid) (oOut << tSwitchOnList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)tStateHistoryList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tStateHistoryList.size(); ++u32Idx)
         (tVoid) (oOut << tStateHistoryList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)tErrStateHistory01List.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tErrStateHistory01List.size(); ++u32Idx)
         (tVoid) (oOut << tErrStateHistory01List[u32Idx]);
   }
   (tVoid) (oOut << (tU32)tErrStateHistory02List.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tErrStateHistory02List.size(); ++u32Idx)
         (tVoid) (oOut << tErrStateHistory02List[u32Idx]);
   }
   (tVoid) (oOut << (tU32)tErrStateHistory03List.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tErrStateHistory03List.size(); ++u32Idx)
         (tVoid) (oOut << tErrStateHistory03List[u32Idx]);
   }
   (tVoid) (oOut << (tU32)tErrStateHistory04List.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tErrStateHistory04List.size(); ++u32Idx)
         (tVoid) (oOut << tErrStateHistory04List[u32Idx]);
   }
   (tVoid) (oOut << (tU32)tErrStateHistory05List.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tErrStateHistory05List.size(); ++u32Idx)
         (tVoid) (oOut << tErrStateHistory05List[u32Idx]);
   }
   (tVoid) (oOut << u32SystemOperationTime);
   (tVoid) (oOut << tCpuUsage);
   (tVoid) (oOut << tRamUsage);
   (tVoid) (oOut << tStartupTime);
   return oOut;
}

tBool spm_fi_tcl_SPM_SWVersionStatisticData::operator==(const spm_fi_tcl_SPM_SWVersionStatisticData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strBuildVersion == roRef.strBuildVersion);
   bResult = bResult && (strBuildVersionCustomer == roRef.strBuildVersionCustomer);
   bResult = bResult && (strCustomerVersion == roRef.strCustomerVersion);
   bResult = bResult && (tResetInfo == roRef.tResetInfo);
      bResult = bResult && (tResetHistoryList.size() == roRef.tResetHistoryList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tResetHistoryList.size()); ++u32Idx)
            bResult = bResult && (tResetHistoryList[u32Idx] == roRef.tResetHistoryList[u32Idx]);
      }
      bResult = bResult && (tWakeupHistoryList.size() == roRef.tWakeupHistoryList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tWakeupHistoryList.size()); ++u32Idx)
            bResult = bResult && (tWakeupHistoryList[u32Idx] == roRef.tWakeupHistoryList[u32Idx]);
      }
      bResult = bResult && (tSwitchOnList.size() == roRef.tSwitchOnList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tSwitchOnList.size()); ++u32Idx)
            bResult = bResult && (tSwitchOnList[u32Idx] == roRef.tSwitchOnList[u32Idx]);
      }
      bResult = bResult && (tStateHistoryList.size() == roRef.tStateHistoryList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tStateHistoryList.size()); ++u32Idx)
            bResult = bResult && (tStateHistoryList[u32Idx] == roRef.tStateHistoryList[u32Idx]);
      }
      bResult = bResult && (tErrStateHistory01List.size() == roRef.tErrStateHistory01List.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tErrStateHistory01List.size()); ++u32Idx)
            bResult = bResult && (tErrStateHistory01List[u32Idx] == roRef.tErrStateHistory01List[u32Idx]);
      }
      bResult = bResult && (tErrStateHistory02List.size() == roRef.tErrStateHistory02List.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tErrStateHistory02List.size()); ++u32Idx)
            bResult = bResult && (tErrStateHistory02List[u32Idx] == roRef.tErrStateHistory02List[u32Idx]);
      }
      bResult = bResult && (tErrStateHistory03List.size() == roRef.tErrStateHistory03List.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tErrStateHistory03List.size()); ++u32Idx)
            bResult = bResult && (tErrStateHistory03List[u32Idx] == roRef.tErrStateHistory03List[u32Idx]);
      }
      bResult = bResult && (tErrStateHistory04List.size() == roRef.tErrStateHistory04List.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tErrStateHistory04List.size()); ++u32Idx)
            bResult = bResult && (tErrStateHistory04List[u32Idx] == roRef.tErrStateHistory04List[u32Idx]);
      }
      bResult = bResult && (tErrStateHistory05List.size() == roRef.tErrStateHistory05List.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tErrStateHistory05List.size()); ++u32Idx)
            bResult = bResult && (tErrStateHistory05List[u32Idx] == roRef.tErrStateHistory05List[u32Idx]);
      }
   bResult = bResult && (u32SystemOperationTime == roRef.u32SystemOperationTime);
   bResult = bResult && (tCpuUsage == roRef.tCpuUsage);
   bResult = bResult && (tRamUsage == roRef.tRamUsage);
   bResult = bResult && (tStartupTime == roRef.tStartupTime);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_e8_DefSetMode::spm_fi_tcl_e8_DefSetMode():enType(FI_EN_DEFSET_SRC_NOT_DEF) {}

tS32 spm_fi_tcl_e8_DefSetMode::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_E8_DEFSETMODE;
}


spm_fi_tcl_e8_DefSetMode::~spm_fi_tcl_e8_DefSetMode()
{}

tU32 spm_fi_tcl_e8_DefSetMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_fi_tcl_e8_DefSetMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_e8_DefSetMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_e8_DefSetServiceStatus::spm_fi_tcl_e8_DefSetServiceStatus():enType(FI_EN_DEFSET_STATE_UNDEFINED) {}

tS32 spm_fi_tcl_e8_DefSetServiceStatus::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_E8_DEFSETSERVICESTATUS;
}


spm_fi_tcl_e8_DefSetServiceStatus::~spm_fi_tcl_e8_DefSetServiceStatus()
{}

tU32 spm_fi_tcl_e8_DefSetServiceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_fi_tcl_e8_DefSetServiceStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_e8_DefSetServiceStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_e8_DiaglogDefsetType::spm_fi_tcl_e8_DiaglogDefsetType():enType(FI_EN_CLEAR_ERRMEM) {}

tS32 spm_fi_tcl_e8_DiaglogDefsetType::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_E8_DIAGLOGDEFSETTYPE;
}


spm_fi_tcl_e8_DiaglogDefsetType::~spm_fi_tcl_e8_DiaglogDefsetType()
{}

tU32 spm_fi_tcl_e8_DiaglogDefsetType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_fi_tcl_e8_DiaglogDefsetType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_e8_DiaglogDefsetType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_fi_tcl_e8_DefSetGroup::spm_fi_tcl_e8_DefSetGroup():enType(FI_EN_DEFSET_GROUP_SPM) {}

tS32 spm_fi_tcl_e8_DefSetGroup::s32GetTypeId() const
{
   return (tS32) spm_typesfi_tclToken::EN_E8_DEFSETGROUP;
}


spm_fi_tcl_e8_DefSetGroup::~spm_fi_tcl_e8_DefSetGroup()
{}

tU32 spm_fi_tcl_e8_DefSetGroup::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_fi_tcl_e8_DefSetGroup::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& spm_fi_tcl_e8_DefSetGroup::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

