/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef SPM_COREFITYPES_HEADER
#define SPM_COREFITYPES_HEADER


class spm_corefi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for SPM_CORE_FI message types

fi_tclMessageBase* spm_corefi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class spm_corefi_tclMsgBaseMessage : public spm_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   spm_corefi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class spm_corefi_tclMsgSystemModeMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSystemModeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSystemModeMethodStart& operator=(const spm_corefi_tclMsgSystemModeMethodStart& coRef);
   spm_corefi_tclMsgSystemModeMethodStart(const spm_corefi_tclMsgSystemModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_e8_StateModes eSystemMode;
   virtual ~spm_corefi_tclMsgSystemModeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSystemModeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSystemModeMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSystemModeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSystemModeMethodResult& operator=(const spm_corefi_tclMsgSystemModeMethodResult& coRef);
   spm_corefi_tclMsgSystemModeMethodResult(const spm_corefi_tclMsgSystemModeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32ReturnVal;
   virtual ~spm_corefi_tclMsgSystemModeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSystemModeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDownloadLockStateMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDownloadLockStateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgDownloadLockStateMethodStart& operator=(const spm_corefi_tclMsgDownloadLockStateMethodStart& coRef);
   spm_corefi_tclMsgDownloadLockStateMethodStart(const spm_corefi_tclMsgDownloadLockStateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tclString strRestrictedDlState;
   spm_fi_tcl_e8_DownloadLockStates eRestrictedDlMode;
   virtual ~spm_corefi_tclMsgDownloadLockStateMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgDownloadLockStateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDownloadLockStateMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDownloadLockStateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgDownloadLockStateMethodResult& operator=(const spm_corefi_tclMsgDownloadLockStateMethodResult& coRef);
   spm_corefi_tclMsgDownloadLockStateMethodResult(const spm_corefi_tclMsgDownloadLockStateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32ReturnVal;
   virtual ~spm_corefi_tclMsgDownloadLockStateMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgDownloadLockStateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgUpdateLockMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgUpdateLockMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgUpdateLockMethodStart& operator=(const spm_corefi_tclMsgUpdateLockMethodStart& coRef);
   spm_corefi_tclMsgUpdateLockMethodStart(const spm_corefi_tclMsgUpdateLockMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tclString strLockName;
   spm_fi_tcl_e8_UpdateLockCommand eLockRequest;
   virtual ~spm_corefi_tclMsgUpdateLockMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgUpdateLockMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgUpdateLockMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgUpdateLockMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgUpdateLockMethodResult& operator=(const spm_corefi_tclMsgUpdateLockMethodResult& coRef);
   spm_corefi_tclMsgUpdateLockMethodResult(const spm_corefi_tclMsgUpdateLockMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32ReturnVal;
   virtual ~spm_corefi_tclMsgUpdateLockMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgUpdateLockMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgOnOffTriggerMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgOnOffTriggerMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgOnOffTriggerMethodStart& operator=(const spm_corefi_tclMsgOnOffTriggerMethodStart& coRef);
   spm_corefi_tclMsgOnOffTriggerMethodStart(const spm_corefi_tclMsgOnOffTriggerMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_SubStateType eSwitchOnTrigger;
   tBool bState;
   virtual ~spm_corefi_tclMsgOnOffTriggerMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgOnOffTriggerMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgOnOffTriggerMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgOnOffTriggerMethodResult();

   virtual ~spm_corefi_tclMsgOnOffTriggerMethodResult();

   inline tBool operator==(const spm_corefi_tclMsgOnOffTriggerMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgStartProcessMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgStartProcessMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgStartProcessMethodStart& operator=(const spm_corefi_tclMsgStartProcessMethodStart& coRef);
   spm_corefi_tclMsgStartProcessMethodStart(const spm_corefi_tclMsgStartProcessMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tclString strLocation;
   tU32 u32Prio;
   tU32 u32Affinity;
   tU32 u32AffinityEnd;
   tU32 u32NiceLevel;
   tU32 u32NiceLevelEnd;
   spm_fi_tcl_SPM_e32_START_PROC_TYPE u32Type;
   tU32 u32Info;
   virtual ~spm_corefi_tclMsgStartProcessMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgStartProcessMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgStartProcessMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgStartProcessMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgStartProcessMethodResult& operator=(const spm_corefi_tclMsgStartProcessMethodResult& coRef);
   spm_corefi_tclMsgStartProcessMethodResult(const spm_corefi_tclMsgStartProcessMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32ReturnVal;
   spm_fi_tclString strLocation;
   tU32 u32ProcId;
   tU32 u32SpawnDuration;
   virtual ~spm_corefi_tclMsgStartProcessMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgStartProcessMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgStopProcessMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgStopProcessMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgStopProcessMethodStart& operator=(const spm_corefi_tclMsgStopProcessMethodStart& coRef);
   spm_corefi_tclMsgStopProcessMethodStart(const spm_corefi_tclMsgStopProcessMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tclString strLocation;
   tU32 u32ProcId;
   virtual ~spm_corefi_tclMsgStopProcessMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgStopProcessMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgStopProcessMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgStopProcessMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgStopProcessMethodResult& operator=(const spm_corefi_tclMsgStopProcessMethodResult& coRef);
   spm_corefi_tclMsgStopProcessMethodResult(const spm_corefi_tclMsgStopProcessMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32ReturnVal;
   virtual ~spm_corefi_tclMsgStopProcessMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgStopProcessMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgRestartProcessMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgRestartProcessMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgRestartProcessMethodStart& operator=(const spm_corefi_tclMsgRestartProcessMethodStart& coRef);
   spm_corefi_tclMsgRestartProcessMethodStart(const spm_corefi_tclMsgRestartProcessMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tclString strLocation;
   tU32 u32ProcId;
   virtual ~spm_corefi_tclMsgRestartProcessMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgRestartProcessMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgRestartProcessMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgRestartProcessMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgRestartProcessMethodResult& operator=(const spm_corefi_tclMsgRestartProcessMethodResult& coRef);
   spm_corefi_tclMsgRestartProcessMethodResult(const spm_corefi_tclMsgRestartProcessMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32ReturnVal;
   virtual ~spm_corefi_tclMsgRestartProcessMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgRestartProcessMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgStartUpSyncPointReachedMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgStartUpSyncPointReachedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgStartUpSyncPointReachedMethodStart& operator=(const spm_corefi_tclMsgStartUpSyncPointReachedMethodStart& coRef);
   spm_corefi_tclMsgStartUpSyncPointReachedMethodStart(const spm_corefi_tclMsgStartUpSyncPointReachedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tclString strNewSyncPoint;
   virtual ~spm_corefi_tclMsgStartUpSyncPointReachedMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgStartUpSyncPointReachedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgStartUpSyncPointReachedMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgStartUpSyncPointReachedMethodResult();

   virtual ~spm_corefi_tclMsgStartUpSyncPointReachedMethodResult();

   inline tBool operator==(const spm_corefi_tclMsgStartUpSyncPointReachedMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgClearListMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgClearListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgClearListMethodStart& operator=(const spm_corefi_tclMsgClearListMethodStart& coRef);
   spm_corefi_tclMsgClearListMethodStart(const spm_corefi_tclMsgClearListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_CLEAR_LIST eList2Clear;
   virtual ~spm_corefi_tclMsgClearListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgClearListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgClearListMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgClearListMethodResult();

   virtual ~spm_corefi_tclMsgClearListMethodResult();

   inline tBool operator==(const spm_corefi_tclMsgClearListMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart& operator=(const spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart& coRef);
   spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart(const spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Index;
   virtual ~spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult& operator=(const spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult& coRef);
   spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult(const spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_SWVersionStatisticData tSWVersionStatistic;
   virtual ~spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgRestartSystemMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgRestartSystemMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgRestartSystemMethodStart& operator=(const spm_corefi_tclMsgRestartSystemMethodStart& coRef);
   spm_corefi_tclMsgRestartSystemMethodStart(const spm_corefi_tclMsgRestartSystemMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_RESTART_TYPE eRestartType;
   virtual ~spm_corefi_tclMsgRestartSystemMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgRestartSystemMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgRestartSystemMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgRestartSystemMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgRestartSystemMethodResult& operator=(const spm_corefi_tclMsgRestartSystemMethodResult& coRef);
   spm_corefi_tclMsgRestartSystemMethodResult(const spm_corefi_tclMsgRestartSystemMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_MRESULT e32ReturnVal;
   virtual ~spm_corefi_tclMsgRestartSystemMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgRestartSystemMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgAudioSourceChangeMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgAudioSourceChangeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgAudioSourceChangeMethodStart& operator=(const spm_corefi_tclMsgAudioSourceChangeMethodStart& coRef);
   spm_corefi_tclMsgAudioSourceChangeMethodStart(const spm_corefi_tclMsgAudioSourceChangeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_AUDIO_SOURCE eAudioSrc;
   virtual ~spm_corefi_tclMsgAudioSourceChangeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgAudioSourceChangeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgAudioSourceChangeMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgAudioSourceChangeMethodResult();

   virtual ~spm_corefi_tclMsgAudioSourceChangeMethodResult();

   inline tBool operator==(const spm_corefi_tclMsgAudioSourceChangeMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgChangeBluetoothStateMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgChangeBluetoothStateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgChangeBluetoothStateMethodStart& operator=(const spm_corefi_tclMsgChangeBluetoothStateMethodStart& coRef);
   spm_corefi_tclMsgChangeBluetoothStateMethodStart(const spm_corefi_tclMsgChangeBluetoothStateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_BT_STATE BtState;
   virtual ~spm_corefi_tclMsgChangeBluetoothStateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgChangeBluetoothStateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgChangeBluetoothStateMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgChangeBluetoothStateMethodResult();

   virtual ~spm_corefi_tclMsgChangeBluetoothStateMethodResult();

   inline tBool operator==(const spm_corefi_tclMsgChangeBluetoothStateMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgChangeAudioStateMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgChangeAudioStateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgChangeAudioStateMethodStart& operator=(const spm_corefi_tclMsgChangeAudioStateMethodStart& coRef);
   spm_corefi_tclMsgChangeAudioStateMethodStart(const spm_corefi_tclMsgChangeAudioStateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_AUDIO_STATE AudioState;
   virtual ~spm_corefi_tclMsgChangeAudioStateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgChangeAudioStateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgChangeAudioStateMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgChangeAudioStateMethodResult();

   virtual ~spm_corefi_tclMsgChangeAudioStateMethodResult();

   inline tBool operator==(const spm_corefi_tclMsgChangeAudioStateMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgChangeSpiStateMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgChangeSpiStateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgChangeSpiStateMethodStart& operator=(const spm_corefi_tclMsgChangeSpiStateMethodStart& coRef);
   spm_corefi_tclMsgChangeSpiStateMethodStart(const spm_corefi_tclMsgChangeSpiStateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_SPI_STATE SpiState;
   virtual ~spm_corefi_tclMsgChangeSpiStateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgChangeSpiStateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgChangeSpiStateMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgChangeSpiStateMethodResult();

   virtual ~spm_corefi_tclMsgChangeSpiStateMethodResult();

   inline tBool operator==(const spm_corefi_tclMsgChangeSpiStateMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgChangeTunerStateMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgChangeTunerStateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgChangeTunerStateMethodStart& operator=(const spm_corefi_tclMsgChangeTunerStateMethodStart& coRef);
   spm_corefi_tclMsgChangeTunerStateMethodStart(const spm_corefi_tclMsgChangeTunerStateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_TUNER_STATE TunerState;
   virtual ~spm_corefi_tclMsgChangeTunerStateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgChangeTunerStateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgChangeTunerStateMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgChangeTunerStateMethodResult();

   virtual ~spm_corefi_tclMsgChangeTunerStateMethodResult();

   inline tBool operator==(const spm_corefi_tclMsgChangeTunerStateMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgChangeWifiStateMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgChangeWifiStateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgChangeWifiStateMethodStart& operator=(const spm_corefi_tclMsgChangeWifiStateMethodStart& coRef);
   spm_corefi_tclMsgChangeWifiStateMethodStart(const spm_corefi_tclMsgChangeWifiStateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_WIFI_STATE WiFiState;
   virtual ~spm_corefi_tclMsgChangeWifiStateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgChangeWifiStateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgChangeWifiStateMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgChangeWifiStateMethodResult();

   virtual ~spm_corefi_tclMsgChangeWifiStateMethodResult();

   inline tBool operator==(const spm_corefi_tclMsgChangeWifiStateMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart& operator=(const spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart& coRef);
   spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart(const spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_AppIdList tAppIdList;
   virtual ~spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodResult();

   virtual ~spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodResult();

   inline tBool operator==(const spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSetFactorySettingsNewMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSetFactorySettingsNewMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSetFactorySettingsNewMethodStart& operator=(const spm_corefi_tclMsgSetFactorySettingsNewMethodStart& coRef);
   spm_corefi_tclMsgSetFactorySettingsNewMethodStart(const spm_corefi_tclMsgSetFactorySettingsNewMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_e8_DiaglogDefsetType DefSetStateGroup;
   spm_fi_tcl_e8_DefSetMode DefSetStateMode;
   virtual ~spm_corefi_tclMsgSetFactorySettingsNewMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSetFactorySettingsNewMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSetFactorySettingsNewMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSetFactorySettingsNewMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSetFactorySettingsNewMethodResult& operator=(const spm_corefi_tclMsgSetFactorySettingsNewMethodResult& coRef);
   spm_corefi_tclMsgSetFactorySettingsNewMethodResult(const spm_corefi_tclMsgSetFactorySettingsNewMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_e8_DiaglogDefsetType DefSetStateGroup;
   spm_fi_tcl_e8_DefSetMode DefSetStateMode;
   tBool DefSetStateSuccessful;
   tU16 DefSetStateFirstDifferentParameterId;
   virtual ~spm_corefi_tclMsgSetFactorySettingsNewMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSetFactorySettingsNewMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgClearVINMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgClearVINMethodStart();

   virtual ~spm_corefi_tclMsgClearVINMethodStart();

   inline tBool operator==(const spm_corefi_tclMsgClearVINMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgClearVINMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgClearVINMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgClearVINMethodResult& operator=(const spm_corefi_tclMsgClearVINMethodResult& coRef);
   spm_corefi_tclMsgClearVINMethodResult(const spm_corefi_tclMsgClearVINMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Result;
   virtual ~spm_corefi_tclMsgClearVINMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgClearVINMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgPrepareDownloadMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgPrepareDownloadMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgPrepareDownloadMethodStart& operator=(const spm_corefi_tclMsgPrepareDownloadMethodStart& coRef);
   spm_corefi_tclMsgPrepareDownloadMethodStart(const spm_corefi_tclMsgPrepareDownloadMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Configuration;
   tBool SuspendBusShutdown;
   tU32 Timeout;
   virtual ~spm_corefi_tclMsgPrepareDownloadMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgPrepareDownloadMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgPrepareDownloadMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgPrepareDownloadMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgPrepareDownloadMethodResult& operator=(const spm_corefi_tclMsgPrepareDownloadMethodResult& coRef);
   spm_corefi_tclMsgPrepareDownloadMethodResult(const spm_corefi_tclMsgPrepareDownloadMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Result;
   virtual ~spm_corefi_tclMsgPrepareDownloadMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgPrepareDownloadMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgEndDownloadMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgEndDownloadMethodStart();

   virtual ~spm_corefi_tclMsgEndDownloadMethodStart();

   inline tBool operator==(const spm_corefi_tclMsgEndDownloadMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgEndDownloadMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgEndDownloadMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgEndDownloadMethodResult& operator=(const spm_corefi_tclMsgEndDownloadMethodResult& coRef);
   spm_corefi_tclMsgEndDownloadMethodResult(const spm_corefi_tclMsgEndDownloadMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Result;
   virtual ~spm_corefi_tclMsgEndDownloadMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgEndDownloadMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSetOnConfigurationMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSetOnConfigurationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSetOnConfigurationMethodStart& operator=(const spm_corefi_tclMsgSetOnConfigurationMethodStart& coRef);
   spm_corefi_tclMsgSetOnConfigurationMethodStart(const spm_corefi_tclMsgSetOnConfigurationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Configuration;
   virtual ~spm_corefi_tclMsgSetOnConfigurationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSetOnConfigurationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSetOnConfigurationMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSetOnConfigurationMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSetOnConfigurationMethodResult& operator=(const spm_corefi_tclMsgSetOnConfigurationMethodResult& coRef);
   spm_corefi_tclMsgSetOnConfigurationMethodResult(const spm_corefi_tclMsgSetOnConfigurationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Result;
   virtual ~spm_corefi_tclMsgSetOnConfigurationMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSetOnConfigurationMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSetProcessConfigurationMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSetProcessConfigurationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSetProcessConfigurationMethodStart& operator=(const spm_corefi_tclMsgSetProcessConfigurationMethodStart& coRef);
   spm_corefi_tclMsgSetProcessConfigurationMethodStart(const spm_corefi_tclMsgSetProcessConfigurationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Configuration;
   virtual ~spm_corefi_tclMsgSetProcessConfigurationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSetProcessConfigurationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSetProcessConfigurationMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSetProcessConfigurationMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSetProcessConfigurationMethodResult& operator=(const spm_corefi_tclMsgSetProcessConfigurationMethodResult& coRef);
   spm_corefi_tclMsgSetProcessConfigurationMethodResult(const spm_corefi_tclMsgSetProcessConfigurationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Result;
   virtual ~spm_corefi_tclMsgSetProcessConfigurationMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSetProcessConfigurationMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgEntertainDeMuteMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgEntertainDeMuteMethodStart();

   virtual ~spm_corefi_tclMsgEntertainDeMuteMethodStart();

   inline tBool operator==(const spm_corefi_tclMsgEntertainDeMuteMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgEntertainDeMuteMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgEntertainDeMuteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgEntertainDeMuteMethodResult& operator=(const spm_corefi_tclMsgEntertainDeMuteMethodResult& coRef);
   spm_corefi_tclMsgEntertainDeMuteMethodResult(const spm_corefi_tclMsgEntertainDeMuteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32ReturnVal;
   virtual ~spm_corefi_tclMsgEntertainDeMuteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgEntertainDeMuteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgEntertainMuteRequestMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgEntertainMuteRequestMethodStart();

   virtual ~spm_corefi_tclMsgEntertainMuteRequestMethodStart();

   inline tBool operator==(const spm_corefi_tclMsgEntertainMuteRequestMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgEntertainMuteRequestMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgEntertainMuteRequestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgEntertainMuteRequestMethodResult& operator=(const spm_corefi_tclMsgEntertainMuteRequestMethodResult& coRef);
   spm_corefi_tclMsgEntertainMuteRequestMethodResult(const spm_corefi_tclMsgEntertainMuteRequestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32ReturnVal;
   virtual ~spm_corefi_tclMsgEntertainMuteRequestMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgEntertainMuteRequestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgWelcomeAudioActivationMethodStart : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgWelcomeAudioActivationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgWelcomeAudioActivationMethodStart& operator=(const spm_corefi_tclMsgWelcomeAudioActivationMethodStart& coRef);
   spm_corefi_tclMsgWelcomeAudioActivationMethodStart(const spm_corefi_tclMsgWelcomeAudioActivationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bActivateState;
   virtual ~spm_corefi_tclMsgWelcomeAudioActivationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgWelcomeAudioActivationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgWelcomeAudioActivationMethodResult : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgWelcomeAudioActivationMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgWelcomeAudioActivationMethodResult& operator=(const spm_corefi_tclMsgWelcomeAudioActivationMethodResult& coRef);
   spm_corefi_tclMsgWelcomeAudioActivationMethodResult(const spm_corefi_tclMsgWelcomeAudioActivationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32ReturnVal;
   virtual ~spm_corefi_tclMsgWelcomeAudioActivationMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgWelcomeAudioActivationMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSystemStateUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSystemStateUpReg();

   virtual ~spm_corefi_tclMsgSystemStateUpReg();

   inline tBool operator==(const spm_corefi_tclMsgSystemStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSystemStateRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSystemStateRelUpReg();

   virtual ~spm_corefi_tclMsgSystemStateRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgSystemStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSystemStateGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSystemStateGet();

   virtual ~spm_corefi_tclMsgSystemStateGet();

   inline tBool operator==(const spm_corefi_tclMsgSystemStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSystemStateStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSystemStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSystemStateStatus& operator=(const spm_corefi_tclMsgSystemStateStatus& coRef);
   spm_corefi_tclMsgSystemStateStatus(const spm_corefi_tclMsgSystemStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_SYSTEM_STATES SystemState;
   virtual ~spm_corefi_tclMsgSystemStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSystemStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDownloadLockStatesStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDownloadLockStatesStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgDownloadLockStatesStatus& operator=(const spm_corefi_tclMsgDownloadLockStatesStatus& coRef);
   spm_corefi_tclMsgDownloadLockStatesStatus(const spm_corefi_tclMsgDownloadLockStatesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<spm_fi_tcl_SPM_RestrictedDlLock, std::allocator<spm_fi_tcl_SPM_RestrictedDlLock> > listRestrictedLock;
   virtual ~spm_corefi_tclMsgDownloadLockStatesStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgDownloadLockStatesStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDownloadLockStatesUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDownloadLockStatesUpReg();

   virtual ~spm_corefi_tclMsgDownloadLockStatesUpReg();

   inline tBool operator==(const spm_corefi_tclMsgDownloadLockStatesUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDownloadLockStatesRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDownloadLockStatesRelUpReg();

   virtual ~spm_corefi_tclMsgDownloadLockStatesRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgDownloadLockStatesRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDownloadLockStatesGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDownloadLockStatesGet();

   virtual ~spm_corefi_tclMsgDownloadLockStatesGet();

   inline tBool operator==(const spm_corefi_tclMsgDownloadLockStatesGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgUpdateLockStatesStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgUpdateLockStatesStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgUpdateLockStatesStatus& operator=(const spm_corefi_tclMsgUpdateLockStatesStatus& coRef);
   spm_corefi_tclMsgUpdateLockStatesStatus(const spm_corefi_tclMsgUpdateLockStatesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<spm_fi_tcl_SPM_UpdateLockState, std::allocator<spm_fi_tcl_SPM_UpdateLockState> > lLocks;
   virtual ~spm_corefi_tclMsgUpdateLockStatesStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgUpdateLockStatesStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgUpdateLockStatesUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgUpdateLockStatesUpReg();

   virtual ~spm_corefi_tclMsgUpdateLockStatesUpReg();

   inline tBool operator==(const spm_corefi_tclMsgUpdateLockStatesUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgUpdateLockStatesRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgUpdateLockStatesRelUpReg();

   virtual ~spm_corefi_tclMsgUpdateLockStatesRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgUpdateLockStatesRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgUpdateLockStatesGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgUpdateLockStatesGet();

   virtual ~spm_corefi_tclMsgUpdateLockStatesGet();

   inline tBool operator==(const spm_corefi_tclMsgUpdateLockStatesGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgActiveOnOffTriggerStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgActiveOnOffTriggerStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgActiveOnOffTriggerStatus& operator=(const spm_corefi_tclMsgActiveOnOffTriggerStatus& coRef);
   spm_corefi_tclMsgActiveOnOffTriggerStatus(const spm_corefi_tclMsgActiveOnOffTriggerStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<spm_fi_tcl_SPM_e32_SubStateType, std::allocator<spm_fi_tcl_SPM_e32_SubStateType> > tOnOffTriggerList;
   virtual ~spm_corefi_tclMsgActiveOnOffTriggerStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgActiveOnOffTriggerStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgActiveOnOffTriggerUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgActiveOnOffTriggerUpReg();

   virtual ~spm_corefi_tclMsgActiveOnOffTriggerUpReg();

   inline tBool operator==(const spm_corefi_tclMsgActiveOnOffTriggerUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgActiveOnOffTriggerRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgActiveOnOffTriggerRelUpReg();

   virtual ~spm_corefi_tclMsgActiveOnOffTriggerRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgActiveOnOffTriggerRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgActiveOnOffTriggerGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgActiveOnOffTriggerGet();

   virtual ~spm_corefi_tclMsgActiveOnOffTriggerGet();

   inline tBool operator==(const spm_corefi_tclMsgActiveOnOffTriggerGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSubStatesSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSubStatesSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSubStatesSet& operator=(const spm_corefi_tclMsgSubStatesSet& coRef);
   spm_corefi_tclMsgSubStatesSet(const spm_corefi_tclMsgSubStatesSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_SubStateType SubStateType;
   tBool SubStateData;
   virtual ~spm_corefi_tclMsgSubStatesSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSubStatesSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSubStatesStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSubStatesStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSubStatesStatus& operator=(const spm_corefi_tclMsgSubStatesStatus& coRef);
   spm_corefi_tclMsgSubStatesStatus(const spm_corefi_tclMsgSubStatesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 SubState;
   tU32 HwSubState;
   tU32 InternSubState;
   virtual ~spm_corefi_tclMsgSubStatesStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSubStatesStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSubStatesUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSubStatesUpReg();

   virtual ~spm_corefi_tclMsgSubStatesUpReg();

   inline tBool operator==(const spm_corefi_tclMsgSubStatesUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSubStatesRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSubStatesRelUpReg();

   virtual ~spm_corefi_tclMsgSubStatesRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgSubStatesRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSubStatesGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSubStatesGet();

   virtual ~spm_corefi_tclMsgSubStatesGet();

   inline tBool operator==(const spm_corefi_tclMsgSubStatesGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgHistoryTriggerStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgHistoryTriggerStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgHistoryTriggerStatus& operator=(const spm_corefi_tclMsgHistoryTriggerStatus& coRef);
   spm_corefi_tclMsgHistoryTriggerStatus(const spm_corefi_tclMsgHistoryTriggerStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<spm_fi_tcl_SPM_HistoryTrigger, std::allocator<spm_fi_tcl_SPM_HistoryTrigger> > tTriggeredStates;
   virtual ~spm_corefi_tclMsgHistoryTriggerStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgHistoryTriggerStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgHistoryTriggerUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgHistoryTriggerUpReg();

   virtual ~spm_corefi_tclMsgHistoryTriggerUpReg();

   inline tBool operator==(const spm_corefi_tclMsgHistoryTriggerUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgHistoryTriggerRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgHistoryTriggerRelUpReg();

   virtual ~spm_corefi_tclMsgHistoryTriggerRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgHistoryTriggerRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgHistoryTriggerGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgHistoryTriggerGet();

   virtual ~spm_corefi_tclMsgHistoryTriggerGet();

   inline tBool operator==(const spm_corefi_tclMsgHistoryTriggerGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgInsertStateStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgInsertStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgInsertStateStatus& operator=(const spm_corefi_tclMsgInsertStateStatus& coRef);
   spm_corefi_tclMsgInsertStateStatus(const spm_corefi_tclMsgInsertStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_CD_INSERT_STATE InsertState;
   virtual ~spm_corefi_tclMsgInsertStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgInsertStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgInsertStateUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgInsertStateUpReg();

   virtual ~spm_corefi_tclMsgInsertStateUpReg();

   inline tBool operator==(const spm_corefi_tclMsgInsertStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgInsertStateRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgInsertStateRelUpReg();

   virtual ~spm_corefi_tclMsgInsertStateRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgInsertStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgInsertStateGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgInsertStateGet();

   virtual ~spm_corefi_tclMsgInsertStateGet();

   inline tBool operator==(const spm_corefi_tclMsgInsertStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgMediaEjectStateStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgMediaEjectStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgMediaEjectStateStatus& operator=(const spm_corefi_tclMsgMediaEjectStateStatus& coRef);
   spm_corefi_tclMsgMediaEjectStateStatus(const spm_corefi_tclMsgMediaEjectStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_MEDIA_EJECT_STATE MediaEjectState;
   virtual ~spm_corefi_tclMsgMediaEjectStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgMediaEjectStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgMediaEjectStateUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgMediaEjectStateUpReg();

   virtual ~spm_corefi_tclMsgMediaEjectStateUpReg();

   inline tBool operator==(const spm_corefi_tclMsgMediaEjectStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgMediaEjectStateRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgMediaEjectStateRelUpReg();

   virtual ~spm_corefi_tclMsgMediaEjectStateRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgMediaEjectStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgMediaEjectStateGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgMediaEjectStateGet();

   virtual ~spm_corefi_tclMsgMediaEjectStateGet();

   inline tBool operator==(const spm_corefi_tclMsgMediaEjectStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgPhoneMuteStateStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgPhoneMuteStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgPhoneMuteStateStatus& operator=(const spm_corefi_tclMsgPhoneMuteStateStatus& coRef);
   spm_corefi_tclMsgPhoneMuteStateStatus(const spm_corefi_tclMsgPhoneMuteStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_PHONE_MUTE_STATE PhoneMuteState;
   virtual ~spm_corefi_tclMsgPhoneMuteStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgPhoneMuteStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgPhoneMuteStateUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgPhoneMuteStateUpReg();

   virtual ~spm_corefi_tclMsgPhoneMuteStateUpReg();

   inline tBool operator==(const spm_corefi_tclMsgPhoneMuteStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgPhoneMuteStateRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgPhoneMuteStateRelUpReg();

   virtual ~spm_corefi_tclMsgPhoneMuteStateRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgPhoneMuteStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgPhoneMuteStateGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgPhoneMuteStateGet();

   virtual ~spm_corefi_tclMsgPhoneMuteStateGet();

   inline tBool operator==(const spm_corefi_tclMsgPhoneMuteStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgOnTipperStateStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgOnTipperStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgOnTipperStateStatus& operator=(const spm_corefi_tclMsgOnTipperStateStatus& coRef);
   spm_corefi_tclMsgOnTipperStateStatus(const spm_corefi_tclMsgOnTipperStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_KEY_STATE OnTipperState;
   virtual ~spm_corefi_tclMsgOnTipperStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgOnTipperStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgOnTipperStateUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgOnTipperStateUpReg();

   virtual ~spm_corefi_tclMsgOnTipperStateUpReg();

   inline tBool operator==(const spm_corefi_tclMsgOnTipperStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgOnTipperStateRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgOnTipperStateRelUpReg();

   virtual ~spm_corefi_tclMsgOnTipperStateRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgOnTipperStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgOnTipperStateGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgOnTipperStateGet();

   virtual ~spm_corefi_tclMsgOnTipperStateGet();

   inline tBool operator==(const spm_corefi_tclMsgOnTipperStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgIgnitionCyclesStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgIgnitionCyclesStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgIgnitionCyclesStatus& operator=(const spm_corefi_tclMsgIgnitionCyclesStatus& coRef);
   spm_corefi_tclMsgIgnitionCyclesStatus(const spm_corefi_tclMsgIgnitionCyclesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 IgnitionCycle;
   virtual ~spm_corefi_tclMsgIgnitionCyclesStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgIgnitionCyclesStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgIgnitionCyclesUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgIgnitionCyclesUpReg();

   virtual ~spm_corefi_tclMsgIgnitionCyclesUpReg();

   inline tBool operator==(const spm_corefi_tclMsgIgnitionCyclesUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgIgnitionCyclesRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgIgnitionCyclesRelUpReg();

   virtual ~spm_corefi_tclMsgIgnitionCyclesRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgIgnitionCyclesRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgIgnitionCyclesGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgIgnitionCyclesGet();

   virtual ~spm_corefi_tclMsgIgnitionCyclesGet();

   inline tBool operator==(const spm_corefi_tclMsgIgnitionCyclesGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSysPwrModeStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSysPwrModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSysPwrModeStatus& operator=(const spm_corefi_tclMsgSysPwrModeStatus& coRef);
   spm_corefi_tclMsgSysPwrModeStatus(const spm_corefi_tclMsgSysPwrModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_SYSPWRMODE SysPwrMode;
   virtual ~spm_corefi_tclMsgSysPwrModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSysPwrModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSysPwrModeUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSysPwrModeUpReg();

   virtual ~spm_corefi_tclMsgSysPwrModeUpReg();

   inline tBool operator==(const spm_corefi_tclMsgSysPwrModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSysPwrModeRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSysPwrModeRelUpReg();

   virtual ~spm_corefi_tclMsgSysPwrModeRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgSysPwrModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSysPwrModeGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSysPwrModeGet();

   virtual ~spm_corefi_tclMsgSysPwrModeGet();

   inline tBool operator==(const spm_corefi_tclMsgSysPwrModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSysPwrSaveModeStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSysPwrSaveModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSysPwrSaveModeStatus& operator=(const spm_corefi_tclMsgSysPwrSaveModeStatus& coRef);
   spm_corefi_tclMsgSysPwrSaveModeStatus(const spm_corefi_tclMsgSysPwrSaveModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_b32_SYSPWRSAVEMODE SysPwrSaveMode;
   virtual ~spm_corefi_tclMsgSysPwrSaveModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSysPwrSaveModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSysPwrSaveModeGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSysPwrSaveModeGet();

   virtual ~spm_corefi_tclMsgSysPwrSaveModeGet();

   inline tBool operator==(const spm_corefi_tclMsgSysPwrSaveModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgMapDownloadLockStateStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgMapDownloadLockStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgMapDownloadLockStateStatus& operator=(const spm_corefi_tclMsgMapDownloadLockStateStatus& coRef);
   spm_corefi_tclMsgMapDownloadLockStateStatus(const spm_corefi_tclMsgMapDownloadLockStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16AppIdLockOwner;
   virtual ~spm_corefi_tclMsgMapDownloadLockStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgMapDownloadLockStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgMapDownloadLockStateUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgMapDownloadLockStateUpReg();

   virtual ~spm_corefi_tclMsgMapDownloadLockStateUpReg();

   inline tBool operator==(const spm_corefi_tclMsgMapDownloadLockStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgMapDownloadLockStateRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgMapDownloadLockStateRelUpReg();

   virtual ~spm_corefi_tclMsgMapDownloadLockStateRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgMapDownloadLockStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgMapDownloadLockStateGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgMapDownloadLockStateGet();

   virtual ~spm_corefi_tclMsgMapDownloadLockStateGet();

   inline tBool operator==(const spm_corefi_tclMsgMapDownloadLockStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgStandbyTimeSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgStandbyTimeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgStandbyTimeSet& operator=(const spm_corefi_tclMsgStandbyTimeSet& coRef);
   spm_corefi_tclMsgStandbyTimeSet(const spm_corefi_tclMsgStandbyTimeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 StandbyTime;
   virtual ~spm_corefi_tclMsgStandbyTimeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgStandbyTimeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgStandbyTimeStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgStandbyTimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgStandbyTimeStatus& operator=(const spm_corefi_tclMsgStandbyTimeStatus& coRef);
   spm_corefi_tclMsgStandbyTimeStatus(const spm_corefi_tclMsgStandbyTimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 StandbyTime;
   virtual ~spm_corefi_tclMsgStandbyTimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgStandbyTimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgStandbyTimeGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgStandbyTimeGet();

   virtual ~spm_corefi_tclMsgStandbyTimeGet();

   inline tBool operator==(const spm_corefi_tclMsgStandbyTimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgPersitentStandbyTimeSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgPersitentStandbyTimeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgPersitentStandbyTimeSet& operator=(const spm_corefi_tclMsgPersitentStandbyTimeSet& coRef);
   spm_corefi_tclMsgPersitentStandbyTimeSet(const spm_corefi_tclMsgPersitentStandbyTimeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 PersitentStandbyTime;
   virtual ~spm_corefi_tclMsgPersitentStandbyTimeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgPersitentStandbyTimeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgPersitentStandbyTimeStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgPersitentStandbyTimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgPersitentStandbyTimeStatus& operator=(const spm_corefi_tclMsgPersitentStandbyTimeStatus& coRef);
   spm_corefi_tclMsgPersitentStandbyTimeStatus(const spm_corefi_tclMsgPersitentStandbyTimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 PersitentStandbyTime;
   virtual ~spm_corefi_tclMsgPersitentStandbyTimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgPersitentStandbyTimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgPersitentStandbyTimeGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgPersitentStandbyTimeGet();

   virtual ~spm_corefi_tclMsgPersitentStandbyTimeGet();

   inline tBool operator==(const spm_corefi_tclMsgPersitentStandbyTimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgIgnitionOffTimeSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgIgnitionOffTimeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgIgnitionOffTimeSet& operator=(const spm_corefi_tclMsgIgnitionOffTimeSet& coRef);
   spm_corefi_tclMsgIgnitionOffTimeSet(const spm_corefi_tclMsgIgnitionOffTimeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 IgnitionOffTime;
   virtual ~spm_corefi_tclMsgIgnitionOffTimeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgIgnitionOffTimeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgIgnitionOffTimeStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgIgnitionOffTimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgIgnitionOffTimeStatus& operator=(const spm_corefi_tclMsgIgnitionOffTimeStatus& coRef);
   spm_corefi_tclMsgIgnitionOffTimeStatus(const spm_corefi_tclMsgIgnitionOffTimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 IgnitionOffTime;
   virtual ~spm_corefi_tclMsgIgnitionOffTimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgIgnitionOffTimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgIgnitionOffTimeGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgIgnitionOffTimeGet();

   virtual ~spm_corefi_tclMsgIgnitionOffTimeGet();

   inline tBool operator==(const spm_corefi_tclMsgIgnitionOffTimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDoorOpenTimeSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDoorOpenTimeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgDoorOpenTimeSet& operator=(const spm_corefi_tclMsgDoorOpenTimeSet& coRef);
   spm_corefi_tclMsgDoorOpenTimeSet(const spm_corefi_tclMsgDoorOpenTimeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DoorOpenTime;
   virtual ~spm_corefi_tclMsgDoorOpenTimeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgDoorOpenTimeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDoorOpenTimeStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDoorOpenTimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgDoorOpenTimeStatus& operator=(const spm_corefi_tclMsgDoorOpenTimeStatus& coRef);
   spm_corefi_tclMsgDoorOpenTimeStatus(const spm_corefi_tclMsgDoorOpenTimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DoorOpenTime;
   virtual ~spm_corefi_tclMsgDoorOpenTimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgDoorOpenTimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDoorOpenTimeGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDoorOpenTimeGet();

   virtual ~spm_corefi_tclMsgDoorOpenTimeGet();

   inline tBool operator==(const spm_corefi_tclMsgDoorOpenTimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgClockDisplayTimeSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgClockDisplayTimeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgClockDisplayTimeSet& operator=(const spm_corefi_tclMsgClockDisplayTimeSet& coRef);
   spm_corefi_tclMsgClockDisplayTimeSet(const spm_corefi_tclMsgClockDisplayTimeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ClockDisplayTime;
   virtual ~spm_corefi_tclMsgClockDisplayTimeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgClockDisplayTimeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgClockDisplayTimeStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgClockDisplayTimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgClockDisplayTimeStatus& operator=(const spm_corefi_tclMsgClockDisplayTimeStatus& coRef);
   spm_corefi_tclMsgClockDisplayTimeStatus(const spm_corefi_tclMsgClockDisplayTimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ClockDisplayTime;
   virtual ~spm_corefi_tclMsgClockDisplayTimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgClockDisplayTimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgClockDisplayTimeGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgClockDisplayTimeGet();

   virtual ~spm_corefi_tclMsgClockDisplayTimeGet();

   inline tBool operator==(const spm_corefi_tclMsgClockDisplayTimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSystemStateTimeGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSystemStateTimeGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSystemStateTimeGet& operator=(const spm_corefi_tclMsgSystemStateTimeGet& coRef);
   spm_corefi_tclMsgSystemStateTimeGet(const spm_corefi_tclMsgSystemStateTimeGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_SYSTEM_STATES tSystemState;
   virtual ~spm_corefi_tclMsgSystemStateTimeGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSystemStateTimeGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSystemStateTimeSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSystemStateTimeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSystemStateTimeSet& operator=(const spm_corefi_tclMsgSystemStateTimeSet& coRef);
   spm_corefi_tclMsgSystemStateTimeSet(const spm_corefi_tclMsgSystemStateTimeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_SYSTEM_STATES tSystemState;
   tU32 tStateTimerValue;
   virtual ~spm_corefi_tclMsgSystemStateTimeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSystemStateTimeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSystemStateTimeStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSystemStateTimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSystemStateTimeStatus& operator=(const spm_corefi_tclMsgSystemStateTimeStatus& coRef);
   spm_corefi_tclMsgSystemStateTimeStatus(const spm_corefi_tclMsgSystemStateTimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_SYSTEM_STATES tSystemState;
   tU32 tStateTimerValue;
   virtual ~spm_corefi_tclMsgSystemStateTimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSystemStateTimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgProcessListStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgProcessListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgProcessListStatus& operator=(const spm_corefi_tclMsgProcessListStatus& coRef);
   spm_corefi_tclMsgProcessListStatus(const spm_corefi_tclMsgProcessListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_ProcessInfo tProcesses;
   virtual ~spm_corefi_tclMsgProcessListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgProcessListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgProcessListUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgProcessListUpReg();

   virtual ~spm_corefi_tclMsgProcessListUpReg();

   inline tBool operator==(const spm_corefi_tclMsgProcessListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgProcessListRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgProcessListRelUpReg();

   virtual ~spm_corefi_tclMsgProcessListRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgProcessListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgProcessListGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgProcessListGet();

   virtual ~spm_corefi_tclMsgProcessListGet();

   inline tBool operator==(const spm_corefi_tclMsgProcessListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgWakeupReasonStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgWakeupReasonStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgWakeupReasonStatus& operator=(const spm_corefi_tclMsgWakeupReasonStatus& coRef);
   spm_corefi_tclMsgWakeupReasonStatus(const spm_corefi_tclMsgWakeupReasonStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_WAKEUP_REASON WakeupReason;
   virtual ~spm_corefi_tclMsgWakeupReasonStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgWakeupReasonStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgWakeupReasonGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgWakeupReasonGet();

   virtual ~spm_corefi_tclMsgWakeupReasonGet();

   inline tBool operator==(const spm_corefi_tclMsgWakeupReasonGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgStartupReasonStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgStartupReasonStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgStartupReasonStatus& operator=(const spm_corefi_tclMsgStartupReasonStatus& coRef);
   spm_corefi_tclMsgStartupReasonStatus(const spm_corefi_tclMsgStartupReasonStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_STARTUP_REASON StartupReason;
   virtual ~spm_corefi_tclMsgStartupReasonStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgStartupReasonStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgStartupReasonGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgStartupReasonGet();

   virtual ~spm_corefi_tclMsgStartupReasonGet();

   inline tBool operator==(const spm_corefi_tclMsgStartupReasonGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgConnectToBatteryStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgConnectToBatteryStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgConnectToBatteryStatus& operator=(const spm_corefi_tclMsgConnectToBatteryStatus& coRef);
   spm_corefi_tclMsgConnectToBatteryStatus(const spm_corefi_tclMsgConnectToBatteryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool ConnectToBatteryState;
   tU16 ConnectToBatteryCount;
   virtual ~spm_corefi_tclMsgConnectToBatteryStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgConnectToBatteryStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgConnectToBatteryGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgConnectToBatteryGet();

   virtual ~spm_corefi_tclMsgConnectToBatteryGet();

   inline tBool operator==(const spm_corefi_tclMsgConnectToBatteryGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgCodeRequestStateSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgCodeRequestStateSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgCodeRequestStateSet& operator=(const spm_corefi_tclMsgCodeRequestStateSet& coRef);
   spm_corefi_tclMsgCodeRequestStateSet(const spm_corefi_tclMsgCodeRequestStateSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_CODE_REQUEST CodeRequestState;
   virtual ~spm_corefi_tclMsgCodeRequestStateSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgCodeRequestStateSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgCodeRequestStateStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgCodeRequestStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgCodeRequestStateStatus& operator=(const spm_corefi_tclMsgCodeRequestStateStatus& coRef);
   spm_corefi_tclMsgCodeRequestStateStatus(const spm_corefi_tclMsgCodeRequestStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_CODE_REQUEST CodeRequestState;
   virtual ~spm_corefi_tclMsgCodeRequestStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgCodeRequestStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgCodeRequestStateUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgCodeRequestStateUpReg();

   virtual ~spm_corefi_tclMsgCodeRequestStateUpReg();

   inline tBool operator==(const spm_corefi_tclMsgCodeRequestStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgCodeRequestStateRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgCodeRequestStateRelUpReg();

   virtual ~spm_corefi_tclMsgCodeRequestStateRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgCodeRequestStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgCodeRequestStateGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgCodeRequestStateGet();

   virtual ~spm_corefi_tclMsgCodeRequestStateGet();

   inline tBool operator==(const spm_corefi_tclMsgCodeRequestStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgActiveStartUpSyncPointsStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgActiveStartUpSyncPointsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgActiveStartUpSyncPointsStatus& operator=(const spm_corefi_tclMsgActiveStartUpSyncPointsStatus& coRef);
   spm_corefi_tclMsgActiveStartUpSyncPointsStatus(const spm_corefi_tclMsgActiveStartUpSyncPointsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<spm_fi_tclString, std::allocator<spm_fi_tclString> > tStartupSyncPointList;
   virtual ~spm_corefi_tclMsgActiveStartUpSyncPointsStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgActiveStartUpSyncPointsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgActiveStartUpSyncPointsUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgActiveStartUpSyncPointsUpReg();

   virtual ~spm_corefi_tclMsgActiveStartUpSyncPointsUpReg();

   inline tBool operator==(const spm_corefi_tclMsgActiveStartUpSyncPointsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgActiveStartUpSyncPointsRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgActiveStartUpSyncPointsRelUpReg();

   virtual ~spm_corefi_tclMsgActiveStartUpSyncPointsRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgActiveStartUpSyncPointsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgActiveStartUpSyncPointsGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgActiveStartUpSyncPointsGet();

   virtual ~spm_corefi_tclMsgActiveStartUpSyncPointsGet();

   inline tBool operator==(const spm_corefi_tclMsgActiveStartUpSyncPointsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgCvmEventStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgCvmEventStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgCvmEventStatus& operator=(const spm_corefi_tclMsgCvmEventStatus& coRef);
   spm_corefi_tclMsgCvmEventStatus(const spm_corefi_tclMsgCvmEventStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_CVM_EVENT CvmEvent;
   virtual ~spm_corefi_tclMsgCvmEventStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgCvmEventStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgCvmEventUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgCvmEventUpReg();

   virtual ~spm_corefi_tclMsgCvmEventUpReg();

   inline tBool operator==(const spm_corefi_tclMsgCvmEventUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgCvmEventRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgCvmEventRelUpReg();

   virtual ~spm_corefi_tclMsgCvmEventRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgCvmEventRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgCvmEventGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgCvmEventGet();

   virtual ~spm_corefi_tclMsgCvmEventGet();

   inline tBool operator==(const spm_corefi_tclMsgCvmEventGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgUBatSenseGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgUBatSenseGet();

   virtual ~spm_corefi_tclMsgUBatSenseGet();

   inline tBool operator==(const spm_corefi_tclMsgUBatSenseGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgUBatSenseStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgUBatSenseStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgUBatSenseStatus& operator=(const spm_corefi_tclMsgUBatSenseStatus& coRef);
   spm_corefi_tclMsgUBatSenseStatus(const spm_corefi_tclMsgUBatSenseStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 UBatSense;
   virtual ~spm_corefi_tclMsgUBatSenseStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgUBatSenseStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgCoproStateSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgCoproStateSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgCoproStateSet& operator=(const spm_corefi_tclMsgCoproStateSet& coRef);
   spm_corefi_tclMsgCoproStateSet(const spm_corefi_tclMsgCoproStateSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_PROCESSOR_STATE CoproState;
   virtual ~spm_corefi_tclMsgCoproStateSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgCoproStateSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgCoproStateStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgCoproStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgCoproStateStatus& operator=(const spm_corefi_tclMsgCoproStateStatus& coRef);
   spm_corefi_tclMsgCoproStateStatus(const spm_corefi_tclMsgCoproStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_PROCESSOR_STATE CoproState;
   virtual ~spm_corefi_tclMsgCoproStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgCoproStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgCoproStateUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgCoproStateUpReg();

   virtual ~spm_corefi_tclMsgCoproStateUpReg();

   inline tBool operator==(const spm_corefi_tclMsgCoproStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgCoproStateRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgCoproStateRelUpReg();

   virtual ~spm_corefi_tclMsgCoproStateRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgCoproStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgCoproStateGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgCoproStateGet();

   virtual ~spm_corefi_tclMsgCoproStateGet();

   inline tBool operator==(const spm_corefi_tclMsgCoproStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDevicePowerOnTimeSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDevicePowerOnTimeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgDevicePowerOnTimeSet& operator=(const spm_corefi_tclMsgDevicePowerOnTimeSet& coRef);
   spm_corefi_tclMsgDevicePowerOnTimeSet(const spm_corefi_tclMsgDevicePowerOnTimeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DevicePowerOnTime;
   virtual ~spm_corefi_tclMsgDevicePowerOnTimeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgDevicePowerOnTimeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDevicePowerOnTimeStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDevicePowerOnTimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgDevicePowerOnTimeStatus& operator=(const spm_corefi_tclMsgDevicePowerOnTimeStatus& coRef);
   spm_corefi_tclMsgDevicePowerOnTimeStatus(const spm_corefi_tclMsgDevicePowerOnTimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DevicePowerOnTime;
   virtual ~spm_corefi_tclMsgDevicePowerOnTimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgDevicePowerOnTimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDevicePowerOnTimeGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDevicePowerOnTimeGet();

   virtual ~spm_corefi_tclMsgDevicePowerOnTimeGet();

   inline tBool operator==(const spm_corefi_tclMsgDevicePowerOnTimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgLastSystemRuntimeStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgLastSystemRuntimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgLastSystemRuntimeStatus& operator=(const spm_corefi_tclMsgLastSystemRuntimeStatus& coRef);
   spm_corefi_tclMsgLastSystemRuntimeStatus(const spm_corefi_tclMsgLastSystemRuntimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32RunTime;
   virtual ~spm_corefi_tclMsgLastSystemRuntimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgLastSystemRuntimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgLastSystemRuntimeGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgLastSystemRuntimeGet();

   virtual ~spm_corefi_tclMsgLastSystemRuntimeGet();

   inline tBool operator==(const spm_corefi_tclMsgLastSystemRuntimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgCurrentSystemRuntimeStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgCurrentSystemRuntimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgCurrentSystemRuntimeStatus& operator=(const spm_corefi_tclMsgCurrentSystemRuntimeStatus& coRef);
   spm_corefi_tclMsgCurrentSystemRuntimeStatus(const spm_corefi_tclMsgCurrentSystemRuntimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32RunTime;
   virtual ~spm_corefi_tclMsgCurrentSystemRuntimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgCurrentSystemRuntimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgCurrentSystemRuntimeGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgCurrentSystemRuntimeGet();

   virtual ~spm_corefi_tclMsgCurrentSystemRuntimeGet();

   inline tBool operator==(const spm_corefi_tclMsgCurrentSystemRuntimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgResetListSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgResetListSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgResetListSet& operator=(const spm_corefi_tclMsgResetListSet& coRef);
   spm_corefi_tclMsgResetListSet(const spm_corefi_tclMsgResetListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ResetResetList;
   virtual ~spm_corefi_tclMsgResetListSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgResetListSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgResetListStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgResetListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgResetListStatus& operator=(const spm_corefi_tclMsgResetListStatus& coRef);
   spm_corefi_tclMsgResetListStatus(const spm_corefi_tclMsgResetListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_e8_LcmResetReason LastResetReason;
   tU8 DateHour;
   tU8 DateMinute;
   tU8 DateDay;
   tU8 DateMonth;
   tU16 DateYear;
   tU8 CoproResetByHmi;
   tU8 CoproResetByUndervoltage;
   tU8 HmiResetByCoproStartup;
   tU8 HmiResetByCoproRun;
   tU8 HmiResetByCoproShutdown;
   tU8 HmiResetByHmiWdg;
   tU8 HmiResetByHmiApp;
   tU8 HmiResetByHmiException;
   tU8 HmiResetByHmiExtern;
   tU8 HmiResetByHmiDownload;
   tU8 HmiResetByHmiDiag;
   tU8 FgsResetByHmi;
   virtual ~spm_corefi_tclMsgResetListStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgResetListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgResetListGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgResetListGet();

   virtual ~spm_corefi_tclMsgResetListGet();

   inline tBool operator==(const spm_corefi_tclMsgResetListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgResetCounterSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgResetCounterSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgResetCounterSet& operator=(const spm_corefi_tclMsgResetCounterSet& coRef);
   spm_corefi_tclMsgResetCounterSet(const spm_corefi_tclMsgResetCounterSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ResetCounter;
   virtual ~spm_corefi_tclMsgResetCounterSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgResetCounterSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgResetCounterStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgResetCounterStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgResetCounterStatus& operator=(const spm_corefi_tclMsgResetCounterStatus& coRef);
   spm_corefi_tclMsgResetCounterStatus(const spm_corefi_tclMsgResetCounterStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tclTimeDate tLastResetDate;
   spm_fi_tcl_e8_LcmResetReason tLastResetReason;
   tU32 u32ApApplicationError;
   tU32 u32ApSoftware;
   tU32 u32ApEcuReset;
   tU32 u32ApDownload;
   tU32 u32ApDownloadError;
   tU32 u32ApOvertemperature;
   tU32 u32ApUser;
   tU32 u32ApLcmIntern;
   tU32 u32ApWarmstartCount;
   tU32 u32ApPowerOnCount;
   tU32 u32ApPowerLossCount;
   tU32 u32ApPowerOffCount;
   tU32 u32ApSccCount;
   tU32 u32ApUnknownCount;
   tU32 u32SccHwWdtCount;
   tU32 u32SccPowerOnCount;
   tU32 u32SccColdstartCount;
   tU32 u32SccAppmodeChangeCount;
   tU32 u32SccDuringLpwCount;
   tU32 u32SccDuringPllOszCount;
   tU32 u32SccDuringSWCount;
   tU32 u32SccWarmstartCount;
   virtual ~spm_corefi_tclMsgResetCounterStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgResetCounterStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgResetCounterUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgResetCounterUpReg();

   virtual ~spm_corefi_tclMsgResetCounterUpReg();

   inline tBool operator==(const spm_corefi_tclMsgResetCounterUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgResetCounterRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgResetCounterRelUpReg();

   virtual ~spm_corefi_tclMsgResetCounterRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgResetCounterRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgResetCounterGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgResetCounterGet();

   virtual ~spm_corefi_tclMsgResetCounterGet();

   inline tBool operator==(const spm_corefi_tclMsgResetCounterGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgTransportModeListSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgTransportModeListSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgTransportModeListSet& operator=(const spm_corefi_tclMsgTransportModeListSet& coRef);
   spm_corefi_tclMsgTransportModeListSet(const spm_corefi_tclMsgTransportModeListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 TransPortList;
   virtual ~spm_corefi_tclMsgTransportModeListSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgTransportModeListSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgTransportModeListStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgTransportModeListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgTransportModeListStatus& operator=(const spm_corefi_tclMsgTransportModeListStatus& coRef);
   spm_corefi_tclMsgTransportModeListStatus(const spm_corefi_tclMsgTransportModeListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_TransPortModeList TransportModeList;
   virtual ~spm_corefi_tclMsgTransportModeListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgTransportModeListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgTransportModeListGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgTransportModeListGet();

   virtual ~spm_corefi_tclMsgTransportModeListGet();

   inline tBool operator==(const spm_corefi_tclMsgTransportModeListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgResetHistorySet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgResetHistorySet();

   virtual ~spm_corefi_tclMsgResetHistorySet();

   inline tBool operator==(const spm_corefi_tclMsgResetHistorySet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgResetHistoryStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgResetHistoryStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgResetHistoryStatus& operator=(const spm_corefi_tclMsgResetHistoryStatus& coRef);
   spm_corefi_tclMsgResetHistoryStatus(const spm_corefi_tclMsgResetHistoryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<spm_fi_tcl_ResetElement, std::allocator<spm_fi_tcl_ResetElement> > tResetList;
   virtual ~spm_corefi_tclMsgResetHistoryStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgResetHistoryStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgResetHistoryGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgResetHistoryGet();

   virtual ~spm_corefi_tclMsgResetHistoryGet();

   inline tBool operator==(const spm_corefi_tclMsgResetHistoryGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgWakeupHistorySet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgWakeupHistorySet();

   virtual ~spm_corefi_tclMsgWakeupHistorySet();

   inline tBool operator==(const spm_corefi_tclMsgWakeupHistorySet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgWakeupHistoryStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgWakeupHistoryStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgWakeupHistoryStatus& operator=(const spm_corefi_tclMsgWakeupHistoryStatus& coRef);
   spm_corefi_tclMsgWakeupHistoryStatus(const spm_corefi_tclMsgWakeupHistoryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<spm_fi_tcl_WakeupElement, std::allocator<spm_fi_tcl_WakeupElement> > tWakeupList;
   virtual ~spm_corefi_tclMsgWakeupHistoryStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgWakeupHistoryStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgWakeupHistoryGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgWakeupHistoryGet();

   virtual ~spm_corefi_tclMsgWakeupHistoryGet();

   inline tBool operator==(const spm_corefi_tclMsgWakeupHistoryGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgStateHistorySet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgStateHistorySet();

   virtual ~spm_corefi_tclMsgStateHistorySet();

   inline tBool operator==(const spm_corefi_tclMsgStateHistorySet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgStateHistoryStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgStateHistoryStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgStateHistoryStatus& operator=(const spm_corefi_tclMsgStateHistoryStatus& coRef);
   spm_corefi_tclMsgStateHistoryStatus(const spm_corefi_tclMsgStateHistoryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<spm_fi_tcl_StateChangeElement, std::allocator<spm_fi_tcl_StateChangeElement> > tStateList;
   virtual ~spm_corefi_tclMsgStateHistoryStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgStateHistoryStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgStateHistoryGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgStateHistoryGet();

   virtual ~spm_corefi_tclMsgStateHistoryGet();

   inline tBool operator==(const spm_corefi_tclMsgStateHistoryGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgErrStateHistory01Set : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgErrStateHistory01Set();

   virtual ~spm_corefi_tclMsgErrStateHistory01Set();

   inline tBool operator==(const spm_corefi_tclMsgErrStateHistory01Set& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgErrStateHistory01Status : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgErrStateHistory01Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgErrStateHistory01Status& operator=(const spm_corefi_tclMsgErrStateHistory01Status& coRef);
   spm_corefi_tclMsgErrStateHistory01Status(const spm_corefi_tclMsgErrStateHistory01Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<spm_fi_tcl_StateChangeElement, std::allocator<spm_fi_tcl_StateChangeElement> > tStateList;
   virtual ~spm_corefi_tclMsgErrStateHistory01Status();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgErrStateHistory01Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgErrStateHistory01Get : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgErrStateHistory01Get();

   virtual ~spm_corefi_tclMsgErrStateHistory01Get();

   inline tBool operator==(const spm_corefi_tclMsgErrStateHistory01Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgErrStateHistory02Set : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgErrStateHistory02Set();

   virtual ~spm_corefi_tclMsgErrStateHistory02Set();

   inline tBool operator==(const spm_corefi_tclMsgErrStateHistory02Set& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgErrStateHistory02Status : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgErrStateHistory02Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgErrStateHistory02Status& operator=(const spm_corefi_tclMsgErrStateHistory02Status& coRef);
   spm_corefi_tclMsgErrStateHistory02Status(const spm_corefi_tclMsgErrStateHistory02Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<spm_fi_tcl_StateChangeElement, std::allocator<spm_fi_tcl_StateChangeElement> > tStateList;
   virtual ~spm_corefi_tclMsgErrStateHistory02Status();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgErrStateHistory02Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgErrStateHistory02Get : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgErrStateHistory02Get();

   virtual ~spm_corefi_tclMsgErrStateHistory02Get();

   inline tBool operator==(const spm_corefi_tclMsgErrStateHistory02Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgErrStateHistory03Set : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgErrStateHistory03Set();

   virtual ~spm_corefi_tclMsgErrStateHistory03Set();

   inline tBool operator==(const spm_corefi_tclMsgErrStateHistory03Set& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgErrStateHistory03Status : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgErrStateHistory03Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgErrStateHistory03Status& operator=(const spm_corefi_tclMsgErrStateHistory03Status& coRef);
   spm_corefi_tclMsgErrStateHistory03Status(const spm_corefi_tclMsgErrStateHistory03Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<spm_fi_tcl_StateChangeElement, std::allocator<spm_fi_tcl_StateChangeElement> > tStateList;
   virtual ~spm_corefi_tclMsgErrStateHistory03Status();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgErrStateHistory03Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgErrStateHistory03Get : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgErrStateHistory03Get();

   virtual ~spm_corefi_tclMsgErrStateHistory03Get();

   inline tBool operator==(const spm_corefi_tclMsgErrStateHistory03Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgErrStateHistory04Set : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgErrStateHistory04Set();

   virtual ~spm_corefi_tclMsgErrStateHistory04Set();

   inline tBool operator==(const spm_corefi_tclMsgErrStateHistory04Set& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgErrStateHistory04Status : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgErrStateHistory04Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgErrStateHistory04Status& operator=(const spm_corefi_tclMsgErrStateHistory04Status& coRef);
   spm_corefi_tclMsgErrStateHistory04Status(const spm_corefi_tclMsgErrStateHistory04Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<spm_fi_tcl_StateChangeElement, std::allocator<spm_fi_tcl_StateChangeElement> > tStateList;
   virtual ~spm_corefi_tclMsgErrStateHistory04Status();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgErrStateHistory04Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgErrStateHistory04Get : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgErrStateHistory04Get();

   virtual ~spm_corefi_tclMsgErrStateHistory04Get();

   inline tBool operator==(const spm_corefi_tclMsgErrStateHistory04Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgErrStateHistory05Set : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgErrStateHistory05Set();

   virtual ~spm_corefi_tclMsgErrStateHistory05Set();

   inline tBool operator==(const spm_corefi_tclMsgErrStateHistory05Set& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgErrStateHistory05Status : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgErrStateHistory05Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgErrStateHistory05Status& operator=(const spm_corefi_tclMsgErrStateHistory05Status& coRef);
   spm_corefi_tclMsgErrStateHistory05Status(const spm_corefi_tclMsgErrStateHistory05Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<spm_fi_tcl_StateChangeElement, std::allocator<spm_fi_tcl_StateChangeElement> > tStateList;
   virtual ~spm_corefi_tclMsgErrStateHistory05Status();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgErrStateHistory05Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgErrStateHistory05Get : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgErrStateHistory05Get();

   virtual ~spm_corefi_tclMsgErrStateHistory05Get();

   inline tBool operator==(const spm_corefi_tclMsgErrStateHistory05Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSwitchOnHistorySet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSwitchOnHistorySet();

   virtual ~spm_corefi_tclMsgSwitchOnHistorySet();

   inline tBool operator==(const spm_corefi_tclMsgSwitchOnHistorySet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSwitchOnHistoryStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSwitchOnHistoryStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSwitchOnHistoryStatus& operator=(const spm_corefi_tclMsgSwitchOnHistoryStatus& coRef);
   spm_corefi_tclMsgSwitchOnHistoryStatus(const spm_corefi_tclMsgSwitchOnHistoryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<spm_fi_tcl_SwitchOnElement, std::allocator<spm_fi_tcl_SwitchOnElement> > tSwitchOnList;
   virtual ~spm_corefi_tclMsgSwitchOnHistoryStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSwitchOnHistoryStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSwitchOnHistoryGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSwitchOnHistoryGet();

   virtual ~spm_corefi_tclMsgSwitchOnHistoryGet();

   inline tBool operator==(const spm_corefi_tclMsgSwitchOnHistoryGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDeviceOnCounterStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDeviceOnCounterStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgDeviceOnCounterStatus& operator=(const spm_corefi_tclMsgDeviceOnCounterStatus& coRef);
   spm_corefi_tclMsgDeviceOnCounterStatus(const spm_corefi_tclMsgDeviceOnCounterStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32DeviceWakeupCount;
   tU32 u32DeviceUserOnCount;
   virtual ~spm_corefi_tclMsgDeviceOnCounterStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgDeviceOnCounterStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDeviceOnCounterGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDeviceOnCounterGet();

   virtual ~spm_corefi_tclMsgDeviceOnCounterGet();

   inline tBool operator==(const spm_corefi_tclMsgDeviceOnCounterGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgVoltageEventCounterStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgVoltageEventCounterStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgVoltageEventCounterStatus& operator=(const spm_corefi_tclMsgVoltageEventCounterStatus& coRef);
   spm_corefi_tclMsgVoltageEventCounterStatus(const spm_corefi_tclMsgVoltageEventCounterStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_VoltageEventCounter tVoltageEventCounter;
   virtual ~spm_corefi_tclMsgVoltageEventCounterStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgVoltageEventCounterStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgVoltageEventCounterGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgVoltageEventCounterGet();

   virtual ~spm_corefi_tclMsgVoltageEventCounterGet();

   inline tBool operator==(const spm_corefi_tclMsgVoltageEventCounterGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgVoltageRangeHistogramStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgVoltageRangeHistogramStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgVoltageRangeHistogramStatus& operator=(const spm_corefi_tclMsgVoltageRangeHistogramStatus& coRef);
   spm_corefi_tclMsgVoltageRangeHistogramStatus(const spm_corefi_tclMsgVoltageRangeHistogramStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<spm_fi_tcl_SPM_VoltageRange, std::allocator<spm_fi_tcl_SPM_VoltageRange> > listVoltageRangeHistogram;
   virtual ~spm_corefi_tclMsgVoltageRangeHistogramStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgVoltageRangeHistogramStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgVoltageRangeHistogramGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgVoltageRangeHistogramGet();

   virtual ~spm_corefi_tclMsgVoltageRangeHistogramGet();

   inline tBool operator==(const spm_corefi_tclMsgVoltageRangeHistogramGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgCpuUsageStatisticStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgCpuUsageStatisticStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgCpuUsageStatisticStatus& operator=(const spm_corefi_tclMsgCpuUsageStatisticStatus& coRef);
   spm_corefi_tclMsgCpuUsageStatisticStatus(const spm_corefi_tclMsgCpuUsageStatisticStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_SystemStatisticsData tCpuUsageStatisticsData;
   virtual ~spm_corefi_tclMsgCpuUsageStatisticStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgCpuUsageStatisticStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgCpuUsageStatisticGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgCpuUsageStatisticGet();

   virtual ~spm_corefi_tclMsgCpuUsageStatisticGet();

   inline tBool operator==(const spm_corefi_tclMsgCpuUsageStatisticGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgRamUsageStatisticStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgRamUsageStatisticStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgRamUsageStatisticStatus& operator=(const spm_corefi_tclMsgRamUsageStatisticStatus& coRef);
   spm_corefi_tclMsgRamUsageStatisticStatus(const spm_corefi_tclMsgRamUsageStatisticStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_SystemStatisticsData tRamUsageStatisticsData;
   virtual ~spm_corefi_tclMsgRamUsageStatisticStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgRamUsageStatisticStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgRamUsageStatisticGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgRamUsageStatisticGet();

   virtual ~spm_corefi_tclMsgRamUsageStatisticGet();

   inline tBool operator==(const spm_corefi_tclMsgRamUsageStatisticGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgStartupTimeStatisticStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgStartupTimeStatisticStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgStartupTimeStatisticStatus& operator=(const spm_corefi_tclMsgStartupTimeStatisticStatus& coRef);
   spm_corefi_tclMsgStartupTimeStatisticStatus(const spm_corefi_tclMsgStartupTimeStatisticStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_SystemStatisticsData tStartupTimeStatisticsData;
   virtual ~spm_corefi_tclMsgStartupTimeStatisticStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgStartupTimeStatisticStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgStartupTimeStatisticGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgStartupTimeStatisticGet();

   virtual ~spm_corefi_tclMsgStartupTimeStatisticGet();

   inline tBool operator==(const spm_corefi_tclMsgStartupTimeStatisticGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSWVersionStatisticStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSWVersionStatisticStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSWVersionStatisticStatus& operator=(const spm_corefi_tclMsgSWVersionStatisticStatus& coRef);
   spm_corefi_tclMsgSWVersionStatisticStatus(const spm_corefi_tclMsgSWVersionStatisticStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<spm_fi_tcl_SPM_SWVersionStatisticData, std::allocator<spm_fi_tcl_SPM_SWVersionStatisticData> > listSWVersionStatistic;
   virtual ~spm_corefi_tclMsgSWVersionStatisticStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSWVersionStatisticStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSWVersionStatisticGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSWVersionStatisticGet();

   virtual ~spm_corefi_tclMsgSWVersionStatisticGet();

   inline tBool operator==(const spm_corefi_tclMsgSWVersionStatisticGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgRunlevelStateUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgRunlevelStateUpReg();

   virtual ~spm_corefi_tclMsgRunlevelStateUpReg();

   inline tBool operator==(const spm_corefi_tclMsgRunlevelStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgRunlevelStateRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgRunlevelStateRelUpReg();

   virtual ~spm_corefi_tclMsgRunlevelStateRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgRunlevelStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgRunlevelStateGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgRunlevelStateGet();

   virtual ~spm_corefi_tclMsgRunlevelStateGet();

   inline tBool operator==(const spm_corefi_tclMsgRunlevelStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgRunlevelStateStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgRunlevelStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgRunlevelStateStatus& operator=(const spm_corefi_tclMsgRunlevelStateStatus& coRef);
   spm_corefi_tclMsgRunlevelStateStatus(const spm_corefi_tclMsgRunlevelStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_RUNLEVEL eRunlevel;
   virtual ~spm_corefi_tclMsgRunlevelStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgRunlevelStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgRestartSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgRestartSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgRestartSet& operator=(const spm_corefi_tclMsgRestartSet& coRef);
   spm_corefi_tclMsgRestartSet(const spm_corefi_tclMsgRestartSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_RESTART_TYPE Restart;
   virtual ~spm_corefi_tclMsgRestartSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgRestartSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgRestartStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgRestartStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgRestartStatus& operator=(const spm_corefi_tclMsgRestartStatus& coRef);
   spm_corefi_tclMsgRestartStatus(const spm_corefi_tclMsgRestartStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_RESTART_TYPE Restart;
   virtual ~spm_corefi_tclMsgRestartStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgRestartStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgRestartUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgRestartUpReg();

   virtual ~spm_corefi_tclMsgRestartUpReg();

   inline tBool operator==(const spm_corefi_tclMsgRestartUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgRestartRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgRestartRelUpReg();

   virtual ~spm_corefi_tclMsgRestartRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgRestartRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgRestartGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgRestartGet();

   virtual ~spm_corefi_tclMsgRestartGet();

   inline tBool operator==(const spm_corefi_tclMsgRestartGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgLifesignStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgLifesignStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgLifesignStatus& operator=(const spm_corefi_tclMsgLifesignStatus& coRef);
   spm_corefi_tclMsgLifesignStatus(const spm_corefi_tclMsgLifesignStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Lifesign;
   virtual ~spm_corefi_tclMsgLifesignStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgLifesignStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgLifesignUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgLifesignUpReg();

   virtual ~spm_corefi_tclMsgLifesignUpReg();

   inline tBool operator==(const spm_corefi_tclMsgLifesignUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgLifesignRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgLifesignRelUpReg();

   virtual ~spm_corefi_tclMsgLifesignRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgLifesignRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgLifesignGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgLifesignGet();

   virtual ~spm_corefi_tclMsgLifesignGet();

   inline tBool operator==(const spm_corefi_tclMsgLifesignGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgHmiStateStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgHmiStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgHmiStateStatus& operator=(const spm_corefi_tclMsgHmiStateStatus& coRef);
   spm_corefi_tclMsgHmiStateStatus(const spm_corefi_tclMsgHmiStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_HMI_STATE HmiState;
   virtual ~spm_corefi_tclMsgHmiStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgHmiStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgHmiStateUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgHmiStateUpReg();

   virtual ~spm_corefi_tclMsgHmiStateUpReg();

   inline tBool operator==(const spm_corefi_tclMsgHmiStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgHmiStateRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgHmiStateRelUpReg();

   virtual ~spm_corefi_tclMsgHmiStateRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgHmiStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgHmiStateGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgHmiStateGet();

   virtual ~spm_corefi_tclMsgHmiStateGet();

   inline tBool operator==(const spm_corefi_tclMsgHmiStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSystemPowerBehaviourStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSystemPowerBehaviourStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSystemPowerBehaviourStatus& operator=(const spm_corefi_tclMsgSystemPowerBehaviourStatus& coRef);
   spm_corefi_tclMsgSystemPowerBehaviourStatus(const spm_corefi_tclMsgSystemPowerBehaviourStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR eSystemPowerBehaviour;
   virtual ~spm_corefi_tclMsgSystemPowerBehaviourStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSystemPowerBehaviourStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSystemPowerBehaviourUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSystemPowerBehaviourUpReg();

   virtual ~spm_corefi_tclMsgSystemPowerBehaviourUpReg();

   inline tBool operator==(const spm_corefi_tclMsgSystemPowerBehaviourUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSystemPowerBehaviourRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSystemPowerBehaviourRelUpReg();

   virtual ~spm_corefi_tclMsgSystemPowerBehaviourRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgSystemPowerBehaviourRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSystemPowerBehaviourGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSystemPowerBehaviourGet();

   virtual ~spm_corefi_tclMsgSystemPowerBehaviourGet();

   inline tBool operator==(const spm_corefi_tclMsgSystemPowerBehaviourGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDimStateStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDimStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgDimStateStatus& operator=(const spm_corefi_tclMsgDimStateStatus& coRef);
   spm_corefi_tclMsgDimStateStatus(const spm_corefi_tclMsgDimStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_DIM_STATE DimState;
   virtual ~spm_corefi_tclMsgDimStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgDimStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDimStateUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDimStateUpReg();

   virtual ~spm_corefi_tclMsgDimStateUpReg();

   inline tBool operator==(const spm_corefi_tclMsgDimStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDimStateRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDimStateRelUpReg();

   virtual ~spm_corefi_tclMsgDimStateRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgDimStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDimStateGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDimStateGet();

   virtual ~spm_corefi_tclMsgDimStateGet();

   inline tBool operator==(const spm_corefi_tclMsgDimStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDimmingStateStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDimmingStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgDimmingStateStatus& operator=(const spm_corefi_tclMsgDimmingStateStatus& coRef);
   spm_corefi_tclMsgDimmingStateStatus(const spm_corefi_tclMsgDimmingStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_b32_DIM_STATE DimState;
   virtual ~spm_corefi_tclMsgDimmingStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgDimmingStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDimmingStateUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDimmingStateUpReg();

   virtual ~spm_corefi_tclMsgDimmingStateUpReg();

   inline tBool operator==(const spm_corefi_tclMsgDimmingStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDimmingStateRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDimmingStateRelUpReg();

   virtual ~spm_corefi_tclMsgDimmingStateRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgDimmingStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDimmingStateGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDimmingStateGet();

   virtual ~spm_corefi_tclMsgDimmingStateGet();

   inline tBool operator==(const spm_corefi_tclMsgDimmingStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgBluetoothStateStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgBluetoothStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgBluetoothStateStatus& operator=(const spm_corefi_tclMsgBluetoothStateStatus& coRef);
   spm_corefi_tclMsgBluetoothStateStatus(const spm_corefi_tclMsgBluetoothStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_BT_STATE BtState;
   virtual ~spm_corefi_tclMsgBluetoothStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgBluetoothStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgBluetoothStateUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgBluetoothStateUpReg();

   virtual ~spm_corefi_tclMsgBluetoothStateUpReg();

   inline tBool operator==(const spm_corefi_tclMsgBluetoothStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgBluetoothStateRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgBluetoothStateRelUpReg();

   virtual ~spm_corefi_tclMsgBluetoothStateRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgBluetoothStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgBluetoothStateGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgBluetoothStateGet();

   virtual ~spm_corefi_tclMsgBluetoothStateGet();

   inline tBool operator==(const spm_corefi_tclMsgBluetoothStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgAudioStateStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgAudioStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgAudioStateStatus& operator=(const spm_corefi_tclMsgAudioStateStatus& coRef);
   spm_corefi_tclMsgAudioStateStatus(const spm_corefi_tclMsgAudioStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_AUDIO_STATE AudioState;
   virtual ~spm_corefi_tclMsgAudioStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgAudioStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgAudioStateUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgAudioStateUpReg();

   virtual ~spm_corefi_tclMsgAudioStateUpReg();

   inline tBool operator==(const spm_corefi_tclMsgAudioStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgAudioStateRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgAudioStateRelUpReg();

   virtual ~spm_corefi_tclMsgAudioStateRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgAudioStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgAudioStateGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgAudioStateGet();

   virtual ~spm_corefi_tclMsgAudioStateGet();

   inline tBool operator==(const spm_corefi_tclMsgAudioStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSpiStateStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSpiStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSpiStateStatus& operator=(const spm_corefi_tclMsgSpiStateStatus& coRef);
   spm_corefi_tclMsgSpiStateStatus(const spm_corefi_tclMsgSpiStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_SPI_STATE SpiState;
   virtual ~spm_corefi_tclMsgSpiStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSpiStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSpiStateUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSpiStateUpReg();

   virtual ~spm_corefi_tclMsgSpiStateUpReg();

   inline tBool operator==(const spm_corefi_tclMsgSpiStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSpiStateRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSpiStateRelUpReg();

   virtual ~spm_corefi_tclMsgSpiStateRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgSpiStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSpiStateGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSpiStateGet();

   virtual ~spm_corefi_tclMsgSpiStateGet();

   inline tBool operator==(const spm_corefi_tclMsgSpiStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgTunerStateStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgTunerStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgTunerStateStatus& operator=(const spm_corefi_tclMsgTunerStateStatus& coRef);
   spm_corefi_tclMsgTunerStateStatus(const spm_corefi_tclMsgTunerStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_TUNER_STATE TunerState;
   virtual ~spm_corefi_tclMsgTunerStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgTunerStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgTunerStateUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgTunerStateUpReg();

   virtual ~spm_corefi_tclMsgTunerStateUpReg();

   inline tBool operator==(const spm_corefi_tclMsgTunerStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgTunerStateRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgTunerStateRelUpReg();

   virtual ~spm_corefi_tclMsgTunerStateRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgTunerStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgTunerStateGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgTunerStateGet();

   virtual ~spm_corefi_tclMsgTunerStateGet();

   inline tBool operator==(const spm_corefi_tclMsgTunerStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgWifiStateStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgWifiStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgWifiStateStatus& operator=(const spm_corefi_tclMsgWifiStateStatus& coRef);
   spm_corefi_tclMsgWifiStateStatus(const spm_corefi_tclMsgWifiStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_WIFI_STATE WiFiState;
   virtual ~spm_corefi_tclMsgWifiStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgWifiStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgWifiStateUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgWifiStateUpReg();

   virtual ~spm_corefi_tclMsgWifiStateUpReg();

   inline tBool operator==(const spm_corefi_tclMsgWifiStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgWifiStateRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgWifiStateRelUpReg();

   virtual ~spm_corefi_tclMsgWifiStateRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgWifiStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgWifiStateGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgWifiStateGet();

   virtual ~spm_corefi_tclMsgWifiStateGet();

   inline tBool operator==(const spm_corefi_tclMsgWifiStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgOnOffReasonSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgOnOffReasonSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgOnOffReasonSet& operator=(const spm_corefi_tclMsgOnOffReasonSet& coRef);
   spm_corefi_tclMsgOnOffReasonSet(const spm_corefi_tclMsgOnOffReasonSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_OnOffReason OnOffReason;
   virtual ~spm_corefi_tclMsgOnOffReasonSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgOnOffReasonSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgOnOffReasonGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgOnOffReasonGet();

   virtual ~spm_corefi_tclMsgOnOffReasonGet();

   inline tBool operator==(const spm_corefi_tclMsgOnOffReasonGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgOnOffReasonStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgOnOffReasonStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgOnOffReasonStatus& operator=(const spm_corefi_tclMsgOnOffReasonStatus& coRef);
   spm_corefi_tclMsgOnOffReasonStatus(const spm_corefi_tclMsgOnOffReasonStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_OnOffReason OnOffReason;
   virtual ~spm_corefi_tclMsgOnOffReasonStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgOnOffReasonStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgOnOffReasonUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgOnOffReasonUpReg();

   virtual ~spm_corefi_tclMsgOnOffReasonUpReg();

   inline tBool operator==(const spm_corefi_tclMsgOnOffReasonUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgOnOffReasonRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgOnOffReasonRelUpReg();

   virtual ~spm_corefi_tclMsgOnOffReasonRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgOnOffReasonRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgWakeupListSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgWakeupListSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgWakeupListSet& operator=(const spm_corefi_tclMsgWakeupListSet& coRef);
   spm_corefi_tclMsgWakeupListSet(const spm_corefi_tclMsgWakeupListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 WakeupList;
   virtual ~spm_corefi_tclMsgWakeupListSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgWakeupListSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgWakeupListGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgWakeupListGet();

   virtual ~spm_corefi_tclMsgWakeupListGet();

   inline tBool operator==(const spm_corefi_tclMsgWakeupListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgWakeupListStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgWakeupListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgWakeupListStatus& operator=(const spm_corefi_tclMsgWakeupListStatus& coRef);
   spm_corefi_tclMsgWakeupListStatus(const spm_corefi_tclMsgWakeupListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e8_WAKEUP_LIST_REASON WakeUpReason1;
   spm_fi_tcl_SPM_e8_WAKEUP_LIST_REASON WakeUpReason2;
   spm_fi_tcl_SPM_e8_WAKEUP_LIST_REASON WakeUpReason3;
   spm_fi_tcl_SPM_e8_WAKEUP_LIST_REASON WakeUpReason4;
   spm_fi_tcl_SPM_e8_WAKEUP_LIST_REASON WakeUpReason5;
   spm_fi_tcl_SPM_e8_WAKEUP_LIST_REASON WakeUpReason6;
   spm_fi_tcl_SPM_e8_WAKEUP_LIST_REASON WakeUpReason7;
   spm_fi_tcl_SPM_e8_WAKEUP_LIST_REASON WakeUpReason8;
   spm_fi_tcl_SPM_e8_WAKEUP_LIST_REASON WakeUpReason9;
   spm_fi_tcl_SPM_e8_WAKEUP_LIST_REASON WakeUpReason10;
   virtual ~spm_corefi_tclMsgWakeupListStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgWakeupListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgStartupFinishedUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgStartupFinishedUpReg();

   virtual ~spm_corefi_tclMsgStartupFinishedUpReg();

   inline tBool operator==(const spm_corefi_tclMsgStartupFinishedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgStartupFinishedRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgStartupFinishedRelUpReg();

   virtual ~spm_corefi_tclMsgStartupFinishedRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgStartupFinishedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgStartupFinishedGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgStartupFinishedGet();

   virtual ~spm_corefi_tclMsgStartupFinishedGet();

   inline tBool operator==(const spm_corefi_tclMsgStartupFinishedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgStartupFinishedStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgStartupFinishedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgStartupFinishedStatus& operator=(const spm_corefi_tclMsgStartupFinishedStatus& coRef);
   spm_corefi_tclMsgStartupFinishedStatus(const spm_corefi_tclMsgStartupFinishedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool StartupFinishedState;
   virtual ~spm_corefi_tclMsgStartupFinishedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgStartupFinishedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSysStateUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSysStateUpReg();

   virtual ~spm_corefi_tclMsgSysStateUpReg();

   inline tBool operator==(const spm_corefi_tclMsgSysStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSysStateRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSysStateRelUpReg();

   virtual ~spm_corefi_tclMsgSysStateRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgSysStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSysStateGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSysStateGet();

   virtual ~spm_corefi_tclMsgSysStateGet();

   inline tBool operator==(const spm_corefi_tclMsgSysStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSysStateStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSysStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSysStateStatus& operator=(const spm_corefi_tclMsgSysStateStatus& coRef);
   spm_corefi_tclMsgSysStateStatus(const spm_corefi_tclMsgSysStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_SYS_STATE SysState;
   virtual ~spm_corefi_tclMsgSysStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSysStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgMostStateUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgMostStateUpReg();

   virtual ~spm_corefi_tclMsgMostStateUpReg();

   inline tBool operator==(const spm_corefi_tclMsgMostStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgMostStateRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgMostStateRelUpReg();

   virtual ~spm_corefi_tclMsgMostStateRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgMostStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgMostStateGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgMostStateGet();

   virtual ~spm_corefi_tclMsgMostStateGet();

   inline tBool operator==(const spm_corefi_tclMsgMostStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgMostStateStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgMostStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgMostStateStatus& operator=(const spm_corefi_tclMsgMostStateStatus& coRef);
   spm_corefi_tclMsgMostStateStatus(const spm_corefi_tclMsgMostStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_MOST_EVENT MostEvent;
   spm_fi_tcl_SPM_e32_MOST_CONFIG_STATE MostConfigurationState;
   tU32 FirstReceiveTime;
   spm_fi_tcl_SPM_e32_TLA_STATE TLAState;
   tBool OvertemperatureMostOff;
   virtual ~spm_corefi_tclMsgMostStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgMostStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgMostVersionGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgMostVersionGet();

   virtual ~spm_corefi_tclMsgMostVersionGet();

   inline tBool operator==(const spm_corefi_tclMsgMostVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgMostVersionStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgMostVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgMostVersionStatus& operator=(const spm_corefi_tclMsgMostVersionStatus& coRef);
   spm_corefi_tclMsgMostVersionStatus(const spm_corefi_tclMsgMostVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tclString MostVersion;
   virtual ~spm_corefi_tclMsgMostVersionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgMostVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgRVCStateSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgRVCStateSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgRVCStateSet& operator=(const spm_corefi_tclMsgRVCStateSet& coRef);
   spm_corefi_tclMsgRVCStateSet(const spm_corefi_tclMsgRVCStateSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool State;
   virtual ~spm_corefi_tclMsgRVCStateSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgRVCStateSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgRVCStateGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgRVCStateGet();

   virtual ~spm_corefi_tclMsgRVCStateGet();

   inline tBool operator==(const spm_corefi_tclMsgRVCStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgRVCStateStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgRVCStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgRVCStateStatus& operator=(const spm_corefi_tclMsgRVCStateStatus& coRef);
   spm_corefi_tclMsgRVCStateStatus(const spm_corefi_tclMsgRVCStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool State;
   virtual ~spm_corefi_tclMsgRVCStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgRVCStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgTriggerMostRemoteResetGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgTriggerMostRemoteResetGet();

   virtual ~spm_corefi_tclMsgTriggerMostRemoteResetGet();

   inline tBool operator==(const spm_corefi_tclMsgTriggerMostRemoteResetGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgTriggerMostRemoteResetSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgTriggerMostRemoteResetSet();

   virtual ~spm_corefi_tclMsgTriggerMostRemoteResetSet();

   inline tBool operator==(const spm_corefi_tclMsgTriggerMostRemoteResetSet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgTriggerMostRemoteResetUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgTriggerMostRemoteResetUpReg();

   virtual ~spm_corefi_tclMsgTriggerMostRemoteResetUpReg();

   inline tBool operator==(const spm_corefi_tclMsgTriggerMostRemoteResetUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgTriggerMostRemoteResetRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgTriggerMostRemoteResetRelUpReg();

   virtual ~spm_corefi_tclMsgTriggerMostRemoteResetRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgTriggerMostRemoteResetRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgTriggerMostRemoteResetStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgTriggerMostRemoteResetStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgTriggerMostRemoteResetStatus& operator=(const spm_corefi_tclMsgTriggerMostRemoteResetStatus& coRef);
   spm_corefi_tclMsgTriggerMostRemoteResetStatus(const spm_corefi_tclMsgTriggerMostRemoteResetStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Trigger;
   virtual ~spm_corefi_tclMsgTriggerMostRemoteResetStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgTriggerMostRemoteResetStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgPartnumberGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgPartnumberGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgPartnumberGet& operator=(const spm_corefi_tclMsgPartnumberGet& coRef);
   spm_corefi_tclMsgPartnumberGet(const spm_corefi_tclMsgPartnumberGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tclString Part;
   virtual ~spm_corefi_tclMsgPartnumberGet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgPartnumberGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgPartnumberSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgPartnumberSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgPartnumberSet& operator=(const spm_corefi_tclMsgPartnumberSet& coRef);
   spm_corefi_tclMsgPartnumberSet(const spm_corefi_tclMsgPartnumberSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tclString Part;
   tU32 Number;
   virtual ~spm_corefi_tclMsgPartnumberSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgPartnumberSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgPartnumberStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgPartnumberStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgPartnumberStatus& operator=(const spm_corefi_tclMsgPartnumberStatus& coRef);
   spm_corefi_tclMsgPartnumberStatus(const spm_corefi_tclMsgPartnumberStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Partnumber;
   virtual ~spm_corefi_tclMsgPartnumberStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgPartnumberStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgPartnumbersGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgPartnumbersGet();

   virtual ~spm_corefi_tclMsgPartnumbersGet();

   inline tBool operator==(const spm_corefi_tclMsgPartnumbersGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgPartnumbersStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgPartnumbersStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgPartnumbersStatus& operator=(const spm_corefi_tclMsgPartnumbersStatus& coRef);
   spm_corefi_tclMsgPartnumbersStatus(const spm_corefi_tclMsgPartnumbersStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_PartnumberList Parts;
   virtual ~spm_corefi_tclMsgPartnumbersStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgPartnumbersStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgAlphacodeGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgAlphacodeGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgAlphacodeGet& operator=(const spm_corefi_tclMsgAlphacodeGet& coRef);
   spm_corefi_tclMsgAlphacodeGet(const spm_corefi_tclMsgAlphacodeGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tclString Part;
   virtual ~spm_corefi_tclMsgAlphacodeGet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgAlphacodeGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgAlphacodeSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgAlphacodeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgAlphacodeSet& operator=(const spm_corefi_tclMsgAlphacodeSet& coRef);
   spm_corefi_tclMsgAlphacodeSet(const spm_corefi_tclMsgAlphacodeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tclString Part;
   tU8 Alphacode1;
   tU8 Alphacode2;
   virtual ~spm_corefi_tclMsgAlphacodeSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgAlphacodeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgAlphacodeStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgAlphacodeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgAlphacodeStatus& operator=(const spm_corefi_tclMsgAlphacodeStatus& coRef);
   spm_corefi_tclMsgAlphacodeStatus(const spm_corefi_tclMsgAlphacodeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Alphacode1;
   tU8 Alphacode2;
   virtual ~spm_corefi_tclMsgAlphacodeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgAlphacodeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgAlphacodesGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgAlphacodesGet();

   virtual ~spm_corefi_tclMsgAlphacodesGet();

   inline tBool operator==(const spm_corefi_tclMsgAlphacodesGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgAlphacodesStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgAlphacodesStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgAlphacodesStatus& operator=(const spm_corefi_tclMsgAlphacodesStatus& coRef);
   spm_corefi_tclMsgAlphacodesStatus(const spm_corefi_tclMsgAlphacodesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_AlphacodeList Parts;
   virtual ~spm_corefi_tclMsgAlphacodesStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgAlphacodesStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgManufacturersEnableCounterGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgManufacturersEnableCounterGet();

   virtual ~spm_corefi_tclMsgManufacturersEnableCounterGet();

   inline tBool operator==(const spm_corefi_tclMsgManufacturersEnableCounterGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgManufacturersEnableCounterSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgManufacturersEnableCounterSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgManufacturersEnableCounterSet& operator=(const spm_corefi_tclMsgManufacturersEnableCounterSet& coRef);
   spm_corefi_tclMsgManufacturersEnableCounterSet(const spm_corefi_tclMsgManufacturersEnableCounterSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MEC;
   virtual ~spm_corefi_tclMsgManufacturersEnableCounterSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgManufacturersEnableCounterSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgManufacturersEnableCounterStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgManufacturersEnableCounterStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgManufacturersEnableCounterStatus& operator=(const spm_corefi_tclMsgManufacturersEnableCounterStatus& coRef);
   spm_corefi_tclMsgManufacturersEnableCounterStatus(const spm_corefi_tclMsgManufacturersEnableCounterStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MEC;
   virtual ~spm_corefi_tclMsgManufacturersEnableCounterStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgManufacturersEnableCounterStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgNoCalibrationStateGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgNoCalibrationStateGet();

   virtual ~spm_corefi_tclMsgNoCalibrationStateGet();

   inline tBool operator==(const spm_corefi_tclMsgNoCalibrationStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgNoCalibrationStateSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgNoCalibrationStateSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgNoCalibrationStateSet& operator=(const spm_corefi_tclMsgNoCalibrationStateSet& coRef);
   spm_corefi_tclMsgNoCalibrationStateSet(const spm_corefi_tclMsgNoCalibrationStateSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool State;
   virtual ~spm_corefi_tclMsgNoCalibrationStateSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgNoCalibrationStateSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgNoCalibrationStateStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgNoCalibrationStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgNoCalibrationStateStatus& operator=(const spm_corefi_tclMsgNoCalibrationStateStatus& coRef);
   spm_corefi_tclMsgNoCalibrationStateStatus(const spm_corefi_tclMsgNoCalibrationStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool State;
   virtual ~spm_corefi_tclMsgNoCalibrationStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgNoCalibrationStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSecurityCommErrorGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSecurityCommErrorGet();

   virtual ~spm_corefi_tclMsgSecurityCommErrorGet();

   inline tBool operator==(const spm_corefi_tclMsgSecurityCommErrorGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSecurityCommErrorStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSecurityCommErrorStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSecurityCommErrorStatus& operator=(const spm_corefi_tclMsgSecurityCommErrorStatus& coRef);
   spm_corefi_tclMsgSecurityCommErrorStatus(const spm_corefi_tclMsgSecurityCommErrorStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 CommErrorCount;
   virtual ~spm_corefi_tclMsgSecurityCommErrorStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSecurityCommErrorStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSecurityMoreThan10VinGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSecurityMoreThan10VinGet();

   virtual ~spm_corefi_tclMsgSecurityMoreThan10VinGet();

   inline tBool operator==(const spm_corefi_tclMsgSecurityMoreThan10VinGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSecurityMoreThan10VinStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSecurityMoreThan10VinStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSecurityMoreThan10VinStatus& operator=(const spm_corefi_tclMsgSecurityMoreThan10VinStatus& coRef);
   spm_corefi_tclMsgSecurityMoreThan10VinStatus(const spm_corefi_tclMsgSecurityMoreThan10VinStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 MoreThan10VinCount;
   virtual ~spm_corefi_tclMsgSecurityMoreThan10VinStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSecurityMoreThan10VinStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSecurityInvalidVinGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSecurityInvalidVinGet();

   virtual ~spm_corefi_tclMsgSecurityInvalidVinGet();

   inline tBool operator==(const spm_corefi_tclMsgSecurityInvalidVinGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSecurityInvalidVinStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSecurityInvalidVinStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSecurityInvalidVinStatus& operator=(const spm_corefi_tclMsgSecurityInvalidVinStatus& coRef);
   spm_corefi_tclMsgSecurityInvalidVinStatus(const spm_corefi_tclMsgSecurityInvalidVinStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 InvalidVinCount;
   virtual ~spm_corefi_tclMsgSecurityInvalidVinStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSecurityInvalidVinStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSecurityCurrentVinGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSecurityCurrentVinGet();

   virtual ~spm_corefi_tclMsgSecurityCurrentVinGet();

   inline tBool operator==(const spm_corefi_tclMsgSecurityCurrentVinGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSecurityCurrentVinStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSecurityCurrentVinStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSecurityCurrentVinStatus& operator=(const spm_corefi_tclMsgSecurityCurrentVinStatus& coRef);
   spm_corefi_tclMsgSecurityCurrentVinStatus(const spm_corefi_tclMsgSecurityCurrentVinStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_Vin CurrentVin;
   virtual ~spm_corefi_tclMsgSecurityCurrentVinStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSecurityCurrentVinStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSecurityVinHistoryGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSecurityVinHistoryGet();

   virtual ~spm_corefi_tclMsgSecurityVinHistoryGet();

   inline tBool operator==(const spm_corefi_tclMsgSecurityVinHistoryGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSecurityVinHistoryStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSecurityVinHistoryStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSecurityVinHistoryStatus& operator=(const spm_corefi_tclMsgSecurityVinHistoryStatus& coRef);
   spm_corefi_tclMsgSecurityVinHistoryStatus(const spm_corefi_tclMsgSecurityVinHistoryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_VinHistory VinHistory;
   virtual ~spm_corefi_tclMsgSecurityVinHistoryStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSecurityVinHistoryStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgVINGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgVINGet();

   virtual ~spm_corefi_tclMsgVINGet();

   inline tBool operator==(const spm_corefi_tclMsgVINGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgVINStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgVINStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgVINStatus& operator=(const spm_corefi_tclMsgVINStatus& coRef);
   spm_corefi_tclMsgVINStatus(const spm_corefi_tclMsgVINStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tclString VehicleIdentificationNumber;
   virtual ~spm_corefi_tclMsgVINStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgVINStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSecurityStateUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSecurityStateUpReg();

   virtual ~spm_corefi_tclMsgSecurityStateUpReg();

   inline tBool operator==(const spm_corefi_tclMsgSecurityStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSecurityStateRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSecurityStateRelUpReg();

   virtual ~spm_corefi_tclMsgSecurityStateRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgSecurityStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSecurityStateGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSecurityStateGet();

   virtual ~spm_corefi_tclMsgSecurityStateGet();

   inline tBool operator==(const spm_corefi_tclMsgSecurityStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgSecurityStateStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgSecurityStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgSecurityStateStatus& operator=(const spm_corefi_tclMsgSecurityStateStatus& coRef);
   spm_corefi_tclMsgSecurityStateStatus(const spm_corefi_tclMsgSecurityStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_SECURITY_STATE State;
   virtual ~spm_corefi_tclMsgSecurityStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgSecurityStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgVehicleIDUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgVehicleIDUpReg();

   virtual ~spm_corefi_tclMsgVehicleIDUpReg();

   inline tBool operator==(const spm_corefi_tclMsgVehicleIDUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgVehicleIDRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgVehicleIDRelUpReg();

   virtual ~spm_corefi_tclMsgVehicleIDRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgVehicleIDRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgVehicleIDGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgVehicleIDGet();

   virtual ~spm_corefi_tclMsgVehicleIDGet();

   inline tBool operator==(const spm_corefi_tclMsgVehicleIDGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgVehicleIDStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgVehicleIDStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgVehicleIDStatus& operator=(const spm_corefi_tclMsgVehicleIDStatus& coRef);
   spm_corefi_tclMsgVehicleIDStatus(const spm_corefi_tclMsgVehicleIDStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32VehicleID;
   virtual ~spm_corefi_tclMsgVehicleIDStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgVehicleIDStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDisplayVariantGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDisplayVariantGet();

   virtual ~spm_corefi_tclMsgDisplayVariantGet();

   inline tBool operator==(const spm_corefi_tclMsgDisplayVariantGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDisplayVariantSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDisplayVariantSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgDisplayVariantSet& operator=(const spm_corefi_tclMsgDisplayVariantSet& coRef);
   spm_corefi_tclMsgDisplayVariantSet(const spm_corefi_tclMsgDisplayVariantSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DisplayVariantNumber;
   virtual ~spm_corefi_tclMsgDisplayVariantSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgDisplayVariantSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDisplayVariantStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDisplayVariantStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgDisplayVariantStatus& operator=(const spm_corefi_tclMsgDisplayVariantStatus& coRef);
   spm_corefi_tclMsgDisplayVariantStatus(const spm_corefi_tclMsgDisplayVariantStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DisplayVariantNumber;
   virtual ~spm_corefi_tclMsgDisplayVariantStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgDisplayVariantStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgReductionLevelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgReductionLevelUpReg();

   virtual ~spm_corefi_tclMsgReductionLevelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgReductionLevelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgReductionLevelRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgReductionLevelRelUpReg();

   virtual ~spm_corefi_tclMsgReductionLevelRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgReductionLevelRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgReductionLevelGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgReductionLevelGet();

   virtual ~spm_corefi_tclMsgReductionLevelGet();

   inline tBool operator==(const spm_corefi_tclMsgReductionLevelGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgReductionLevelStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgReductionLevelStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgReductionLevelStatus& operator=(const spm_corefi_tclMsgReductionLevelStatus& coRef);
   spm_corefi_tclMsgReductionLevelStatus(const spm_corefi_tclMsgReductionLevelStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_REDUCTION_LEVEL ReductionLevelState;
   virtual ~spm_corefi_tclMsgReductionLevelStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgReductionLevelStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgStartupStateUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgStartupStateUpReg();

   virtual ~spm_corefi_tclMsgStartupStateUpReg();

   inline tBool operator==(const spm_corefi_tclMsgStartupStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgStartupStateRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgStartupStateRelUpReg();

   virtual ~spm_corefi_tclMsgStartupStateRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgStartupStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgStartupStateGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgStartupStateGet();

   virtual ~spm_corefi_tclMsgStartupStateGet();

   inline tBool operator==(const spm_corefi_tclMsgStartupStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgStartupStateStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgStartupStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgStartupStateStatus& operator=(const spm_corefi_tclMsgStartupStateStatus& coRef);
   spm_corefi_tclMsgStartupStateStatus(const spm_corefi_tclMsgStartupStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   spm_fi_tcl_SPM_e32_STARTUP_STATE StartupState;
   virtual ~spm_corefi_tclMsgStartupStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgStartupStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgEntertainMuteUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgEntertainMuteUpReg();

   virtual ~spm_corefi_tclMsgEntertainMuteUpReg();

   inline tBool operator==(const spm_corefi_tclMsgEntertainMuteUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgEntertainMuteRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgEntertainMuteRelUpReg();

   virtual ~spm_corefi_tclMsgEntertainMuteRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgEntertainMuteRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgEntertainMuteGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgEntertainMuteGet();

   virtual ~spm_corefi_tclMsgEntertainMuteGet();

   inline tBool operator==(const spm_corefi_tclMsgEntertainMuteGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgEntertainMuteStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgEntertainMuteStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgEntertainMuteStatus& operator=(const spm_corefi_tclMsgEntertainMuteStatus& coRef);
   spm_corefi_tclMsgEntertainMuteStatus(const spm_corefi_tclMsgEntertainMuteStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bMuteState;
   virtual ~spm_corefi_tclMsgEntertainMuteStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgEntertainMuteStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgWelcomeAudioStateGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgWelcomeAudioStateGet();

   virtual ~spm_corefi_tclMsgWelcomeAudioStateGet();

   inline tBool operator==(const spm_corefi_tclMsgWelcomeAudioStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgWelcomeAudioStateStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgWelcomeAudioStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgWelcomeAudioStateStatus& operator=(const spm_corefi_tclMsgWelcomeAudioStateStatus& coRef);
   spm_corefi_tclMsgWelcomeAudioStateStatus(const spm_corefi_tclMsgWelcomeAudioStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bEnabled;
   virtual ~spm_corefi_tclMsgWelcomeAudioStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgWelcomeAudioStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgUnballastTimeFromEngineStoppedGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgUnballastTimeFromEngineStoppedGet();

   virtual ~spm_corefi_tclMsgUnballastTimeFromEngineStoppedGet();

   inline tBool operator==(const spm_corefi_tclMsgUnballastTimeFromEngineStoppedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus& operator=(const spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus& coRef);
   spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus(const spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32TimeFromEngineStopped;
   virtual ~spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgUnballastTimeBeforeUnballastGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgUnballastTimeBeforeUnballastGet();

   virtual ~spm_corefi_tclMsgUnballastTimeBeforeUnballastGet();

   inline tBool operator==(const spm_corefi_tclMsgUnballastTimeBeforeUnballastGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus& operator=(const spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus& coRef);
   spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus(const spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32UnballastTime;
   virtual ~spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgUnballastTimeBeforeUnballastSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgUnballastTimeBeforeUnballastSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgUnballastTimeBeforeUnballastSet& operator=(const spm_corefi_tclMsgUnballastTimeBeforeUnballastSet& coRef);
   spm_corefi_tclMsgUnballastTimeBeforeUnballastSet(const spm_corefi_tclMsgUnballastTimeBeforeUnballastSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32UnballastTime;
   virtual ~spm_corefi_tclMsgUnballastTimeBeforeUnballastSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgUnballastTimeBeforeUnballastSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgUnballastWarningTimeGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgUnballastWarningTimeGet();

   virtual ~spm_corefi_tclMsgUnballastWarningTimeGet();

   inline tBool operator==(const spm_corefi_tclMsgUnballastWarningTimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgUnballastWarningTimeStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgUnballastWarningTimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgUnballastWarningTimeStatus& operator=(const spm_corefi_tclMsgUnballastWarningTimeStatus& coRef);
   spm_corefi_tclMsgUnballastWarningTimeStatus(const spm_corefi_tclMsgUnballastWarningTimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32UnballastWarningTime;
   virtual ~spm_corefi_tclMsgUnballastWarningTimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgUnballastWarningTimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgUnballastWarningTimeSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgUnballastWarningTimeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgUnballastWarningTimeSet& operator=(const spm_corefi_tclMsgUnballastWarningTimeSet& coRef);
   spm_corefi_tclMsgUnballastWarningTimeSet(const spm_corefi_tclMsgUnballastWarningTimeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32UnballastWarningTime;
   virtual ~spm_corefi_tclMsgUnballastWarningTimeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgUnballastWarningTimeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDegradedCountGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDegradedCountGet();

   virtual ~spm_corefi_tclMsgDegradedCountGet();

   inline tBool operator==(const spm_corefi_tclMsgDegradedCountGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDegradedCountStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDegradedCountStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgDegradedCountStatus& operator=(const spm_corefi_tclMsgDegradedCountStatus& coRef);
   spm_corefi_tclMsgDegradedCountStatus(const spm_corefi_tclMsgDegradedCountStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32DegradedCount;
   virtual ~spm_corefi_tclMsgDegradedCountStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgDegradedCountStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDegradedTimeGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDegradedTimeGet();

   virtual ~spm_corefi_tclMsgDegradedTimeGet();

   inline tBool operator==(const spm_corefi_tclMsgDegradedTimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgDegradedTimeStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgDegradedTimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgDegradedTimeStatus& operator=(const spm_corefi_tclMsgDegradedTimeStatus& coRef);
   spm_corefi_tclMsgDegradedTimeStatus(const spm_corefi_tclMsgDegradedTimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32DegradedTime;
   virtual ~spm_corefi_tclMsgDegradedTimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgDegradedTimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgPhoneHandoverWarnTimeUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgPhoneHandoverWarnTimeUpReg();

   virtual ~spm_corefi_tclMsgPhoneHandoverWarnTimeUpReg();

   inline tBool operator==(const spm_corefi_tclMsgPhoneHandoverWarnTimeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgPhoneHandoverWarnTimeRelUpReg : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgPhoneHandoverWarnTimeRelUpReg();

   virtual ~spm_corefi_tclMsgPhoneHandoverWarnTimeRelUpReg();

   inline tBool operator==(const spm_corefi_tclMsgPhoneHandoverWarnTimeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgPhoneHandoverWarnTimeGet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgPhoneHandoverWarnTimeGet();

   virtual ~spm_corefi_tclMsgPhoneHandoverWarnTimeGet();

   inline tBool operator==(const spm_corefi_tclMsgPhoneHandoverWarnTimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgPhoneHandoverWarnTimeSet : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgPhoneHandoverWarnTimeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgPhoneHandoverWarnTimeSet& operator=(const spm_corefi_tclMsgPhoneHandoverWarnTimeSet& coRef);
   spm_corefi_tclMsgPhoneHandoverWarnTimeSet(const spm_corefi_tclMsgPhoneHandoverWarnTimeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Time;
   virtual ~spm_corefi_tclMsgPhoneHandoverWarnTimeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgPhoneHandoverWarnTimeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class spm_corefi_tclMsgPhoneHandoverWarnTimeStatus : public spm_corefi_tclMsgBaseMessage
{
public:

   spm_corefi_tclMsgPhoneHandoverWarnTimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   spm_corefi_tclMsgPhoneHandoverWarnTimeStatus& operator=(const spm_corefi_tclMsgPhoneHandoverWarnTimeStatus& coRef);
   spm_corefi_tclMsgPhoneHandoverWarnTimeStatus(const spm_corefi_tclMsgPhoneHandoverWarnTimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Time;
   virtual ~spm_corefi_tclMsgPhoneHandoverWarnTimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const spm_corefi_tclMsgPhoneHandoverWarnTimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
