/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_TYPES
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_SERVICEINFO
#include "spm_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for SPM_CORE_FI message types

fi_tclMessageBase* spm_corefi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case spm_corefi_tclToken::EN_MSG_SYSTEMMODEMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgSystemModeMethodStart;

      case spm_corefi_tclToken::EN_MSG_SYSTEMMODEMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgSystemModeMethodResult;

      case spm_corefi_tclToken::EN_MSG_DOWNLOADLOCKSTATEMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgDownloadLockStateMethodStart;

      case spm_corefi_tclToken::EN_MSG_DOWNLOADLOCKSTATEMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgDownloadLockStateMethodResult;

      case spm_corefi_tclToken::EN_MSG_UPDATELOCKMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgUpdateLockMethodStart;

      case spm_corefi_tclToken::EN_MSG_UPDATELOCKMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgUpdateLockMethodResult;

      case spm_corefi_tclToken::EN_MSG_ONOFFTRIGGERMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgOnOffTriggerMethodStart;

      case spm_corefi_tclToken::EN_MSG_ONOFFTRIGGERMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgOnOffTriggerMethodResult;

      case spm_corefi_tclToken::EN_MSG_STARTPROCESSMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgStartProcessMethodStart;

      case spm_corefi_tclToken::EN_MSG_STARTPROCESSMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgStartProcessMethodResult;

      case spm_corefi_tclToken::EN_MSG_STOPPROCESSMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgStopProcessMethodStart;

      case spm_corefi_tclToken::EN_MSG_STOPPROCESSMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgStopProcessMethodResult;

      case spm_corefi_tclToken::EN_MSG_RESTARTPROCESSMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgRestartProcessMethodStart;

      case spm_corefi_tclToken::EN_MSG_RESTARTPROCESSMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgRestartProcessMethodResult;

      case spm_corefi_tclToken::EN_MSG_STARTUPSYNCPOINTREACHEDMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgStartUpSyncPointReachedMethodStart;

      case spm_corefi_tclToken::EN_MSG_STARTUPSYNCPOINTREACHEDMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgStartUpSyncPointReachedMethodResult;

      case spm_corefi_tclToken::EN_MSG_CLEARLISTMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgClearListMethodStart;

      case spm_corefi_tclToken::EN_MSG_CLEARLISTMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgClearListMethodResult;

      case spm_corefi_tclToken::EN_MSG_SPECIFICSWVERSIONSTATISTICMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart;

      case spm_corefi_tclToken::EN_MSG_SPECIFICSWVERSIONSTATISTICMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult;

      case spm_corefi_tclToken::EN_MSG_RESTARTSYSTEMMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgRestartSystemMethodStart;

      case spm_corefi_tclToken::EN_MSG_RESTARTSYSTEMMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgRestartSystemMethodResult;

      case spm_corefi_tclToken::EN_MSG_AUDIOSOURCECHANGEMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgAudioSourceChangeMethodStart;

      case spm_corefi_tclToken::EN_MSG_AUDIOSOURCECHANGEMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgAudioSourceChangeMethodResult;

      case spm_corefi_tclToken::EN_MSG_CHANGEBLUETOOTHSTATEMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgChangeBluetoothStateMethodStart;

      case spm_corefi_tclToken::EN_MSG_CHANGEBLUETOOTHSTATEMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgChangeBluetoothStateMethodResult;

      case spm_corefi_tclToken::EN_MSG_CHANGEAUDIOSTATEMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgChangeAudioStateMethodStart;

      case spm_corefi_tclToken::EN_MSG_CHANGEAUDIOSTATEMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgChangeAudioStateMethodResult;

      case spm_corefi_tclToken::EN_MSG_CHANGESPISTATEMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgChangeSpiStateMethodStart;

      case spm_corefi_tclToken::EN_MSG_CHANGESPISTATEMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgChangeSpiStateMethodResult;

      case spm_corefi_tclToken::EN_MSG_CHANGETUNERSTATEMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgChangeTunerStateMethodStart;

      case spm_corefi_tclToken::EN_MSG_CHANGETUNERSTATEMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgChangeTunerStateMethodResult;

      case spm_corefi_tclToken::EN_MSG_CHANGEWIFISTATEMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgChangeWifiStateMethodStart;

      case spm_corefi_tclToken::EN_MSG_CHANGEWIFISTATEMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgChangeWifiStateMethodResult;

      case spm_corefi_tclToken::EN_MSG_SHUTDOWNANDTERMINATECCAAPPSMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart;

      case spm_corefi_tclToken::EN_MSG_SHUTDOWNANDTERMINATECCAAPPSMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodResult;

      case spm_corefi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgSetFactorySettingsNewMethodStart;

      case spm_corefi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgSetFactorySettingsNewMethodResult;

      case spm_corefi_tclToken::EN_MSG_CLEARVINMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgClearVINMethodStart;

      case spm_corefi_tclToken::EN_MSG_CLEARVINMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgClearVINMethodResult;

      case spm_corefi_tclToken::EN_MSG_PREPAREDOWNLOADMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgPrepareDownloadMethodStart;

      case spm_corefi_tclToken::EN_MSG_PREPAREDOWNLOADMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgPrepareDownloadMethodResult;

      case spm_corefi_tclToken::EN_MSG_ENDDOWNLOADMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgEndDownloadMethodStart;

      case spm_corefi_tclToken::EN_MSG_ENDDOWNLOADMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgEndDownloadMethodResult;

      case spm_corefi_tclToken::EN_MSG_SETONCONFIGURATIONMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgSetOnConfigurationMethodStart;

      case spm_corefi_tclToken::EN_MSG_SETONCONFIGURATIONMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgSetOnConfigurationMethodResult;

      case spm_corefi_tclToken::EN_MSG_SETPROCESSCONFIGURATIONMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgSetProcessConfigurationMethodStart;

      case spm_corefi_tclToken::EN_MSG_SETPROCESSCONFIGURATIONMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgSetProcessConfigurationMethodResult;

      case spm_corefi_tclToken::EN_MSG_ENTERTAINDEMUTEMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgEntertainDeMuteMethodStart;

      case spm_corefi_tclToken::EN_MSG_ENTERTAINDEMUTEMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgEntertainDeMuteMethodResult;

      case spm_corefi_tclToken::EN_MSG_ENTERTAINMUTEREQUESTMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgEntertainMuteRequestMethodStart;

      case spm_corefi_tclToken::EN_MSG_ENTERTAINMUTEREQUESTMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgEntertainMuteRequestMethodResult;

      case spm_corefi_tclToken::EN_MSG_WELCOMEAUDIOACTIVATIONMETHODSTART:
         return OSAL_NEW spm_corefi_tclMsgWelcomeAudioActivationMethodStart;

      case spm_corefi_tclToken::EN_MSG_WELCOMEAUDIOACTIVATIONMETHODRESULT:
         return OSAL_NEW spm_corefi_tclMsgWelcomeAudioActivationMethodResult;

      case spm_corefi_tclToken::EN_MSG_SYSTEMSTATEUPREG:
         return OSAL_NEW spm_corefi_tclMsgSystemStateUpReg;

      case spm_corefi_tclToken::EN_MSG_SYSTEMSTATERELUPREG:
         return OSAL_NEW spm_corefi_tclMsgSystemStateRelUpReg;

      case spm_corefi_tclToken::EN_MSG_SYSTEMSTATEGET:
         return OSAL_NEW spm_corefi_tclMsgSystemStateGet;

      case spm_corefi_tclToken::EN_MSG_SYSTEMSTATESTATUS:
         return OSAL_NEW spm_corefi_tclMsgSystemStateStatus;

      case spm_corefi_tclToken::EN_MSG_DOWNLOADLOCKSTATESSTATUS:
         return OSAL_NEW spm_corefi_tclMsgDownloadLockStatesStatus;

      case spm_corefi_tclToken::EN_MSG_DOWNLOADLOCKSTATESUPREG:
         return OSAL_NEW spm_corefi_tclMsgDownloadLockStatesUpReg;

      case spm_corefi_tclToken::EN_MSG_DOWNLOADLOCKSTATESRELUPREG:
         return OSAL_NEW spm_corefi_tclMsgDownloadLockStatesRelUpReg;

      case spm_corefi_tclToken::EN_MSG_DOWNLOADLOCKSTATESGET:
         return OSAL_NEW spm_corefi_tclMsgDownloadLockStatesGet;

      case spm_corefi_tclToken::EN_MSG_UPDATELOCKSTATESSTATUS:
         return OSAL_NEW spm_corefi_tclMsgUpdateLockStatesStatus;

      case spm_corefi_tclToken::EN_MSG_UPDATELOCKSTATESUPREG:
         return OSAL_NEW spm_corefi_tclMsgUpdateLockStatesUpReg;

      case spm_corefi_tclToken::EN_MSG_UPDATELOCKSTATESRELUPREG:
         return OSAL_NEW spm_corefi_tclMsgUpdateLockStatesRelUpReg;

      case spm_corefi_tclToken::EN_MSG_UPDATELOCKSTATESGET:
         return OSAL_NEW spm_corefi_tclMsgUpdateLockStatesGet;

      case spm_corefi_tclToken::EN_MSG_ACTIVEONOFFTRIGGERSTATUS:
         return OSAL_NEW spm_corefi_tclMsgActiveOnOffTriggerStatus;

      case spm_corefi_tclToken::EN_MSG_ACTIVEONOFFTRIGGERUPREG:
         return OSAL_NEW spm_corefi_tclMsgActiveOnOffTriggerUpReg;

      case spm_corefi_tclToken::EN_MSG_ACTIVEONOFFTRIGGERRELUPREG:
         return OSAL_NEW spm_corefi_tclMsgActiveOnOffTriggerRelUpReg;

      case spm_corefi_tclToken::EN_MSG_ACTIVEONOFFTRIGGERGET:
         return OSAL_NEW spm_corefi_tclMsgActiveOnOffTriggerGet;

      case spm_corefi_tclToken::EN_MSG_SUBSTATESSET:
         return OSAL_NEW spm_corefi_tclMsgSubStatesSet;

      case spm_corefi_tclToken::EN_MSG_SUBSTATESSTATUS:
         return OSAL_NEW spm_corefi_tclMsgSubStatesStatus;

      case spm_corefi_tclToken::EN_MSG_SUBSTATESUPREG:
         return OSAL_NEW spm_corefi_tclMsgSubStatesUpReg;

      case spm_corefi_tclToken::EN_MSG_SUBSTATESRELUPREG:
         return OSAL_NEW spm_corefi_tclMsgSubStatesRelUpReg;

      case spm_corefi_tclToken::EN_MSG_SUBSTATESGET:
         return OSAL_NEW spm_corefi_tclMsgSubStatesGet;

      case spm_corefi_tclToken::EN_MSG_HISTORYTRIGGERSTATUS:
         return OSAL_NEW spm_corefi_tclMsgHistoryTriggerStatus;

      case spm_corefi_tclToken::EN_MSG_HISTORYTRIGGERUPREG:
         return OSAL_NEW spm_corefi_tclMsgHistoryTriggerUpReg;

      case spm_corefi_tclToken::EN_MSG_HISTORYTRIGGERRELUPREG:
         return OSAL_NEW spm_corefi_tclMsgHistoryTriggerRelUpReg;

      case spm_corefi_tclToken::EN_MSG_HISTORYTRIGGERGET:
         return OSAL_NEW spm_corefi_tclMsgHistoryTriggerGet;

      case spm_corefi_tclToken::EN_MSG_INSERTSTATESTATUS:
         return OSAL_NEW spm_corefi_tclMsgInsertStateStatus;

      case spm_corefi_tclToken::EN_MSG_INSERTSTATEUPREG:
         return OSAL_NEW spm_corefi_tclMsgInsertStateUpReg;

      case spm_corefi_tclToken::EN_MSG_INSERTSTATERELUPREG:
         return OSAL_NEW spm_corefi_tclMsgInsertStateRelUpReg;

      case spm_corefi_tclToken::EN_MSG_INSERTSTATEGET:
         return OSAL_NEW spm_corefi_tclMsgInsertStateGet;

      case spm_corefi_tclToken::EN_MSG_MEDIAEJECTSTATESTATUS:
         return OSAL_NEW spm_corefi_tclMsgMediaEjectStateStatus;

      case spm_corefi_tclToken::EN_MSG_MEDIAEJECTSTATEUPREG:
         return OSAL_NEW spm_corefi_tclMsgMediaEjectStateUpReg;

      case spm_corefi_tclToken::EN_MSG_MEDIAEJECTSTATERELUPREG:
         return OSAL_NEW spm_corefi_tclMsgMediaEjectStateRelUpReg;

      case spm_corefi_tclToken::EN_MSG_MEDIAEJECTSTATEGET:
         return OSAL_NEW spm_corefi_tclMsgMediaEjectStateGet;

      case spm_corefi_tclToken::EN_MSG_PHONEMUTESTATESTATUS:
         return OSAL_NEW spm_corefi_tclMsgPhoneMuteStateStatus;

      case spm_corefi_tclToken::EN_MSG_PHONEMUTESTATEUPREG:
         return OSAL_NEW spm_corefi_tclMsgPhoneMuteStateUpReg;

      case spm_corefi_tclToken::EN_MSG_PHONEMUTESTATERELUPREG:
         return OSAL_NEW spm_corefi_tclMsgPhoneMuteStateRelUpReg;

      case spm_corefi_tclToken::EN_MSG_PHONEMUTESTATEGET:
         return OSAL_NEW spm_corefi_tclMsgPhoneMuteStateGet;

      case spm_corefi_tclToken::EN_MSG_ONTIPPERSTATESTATUS:
         return OSAL_NEW spm_corefi_tclMsgOnTipperStateStatus;

      case spm_corefi_tclToken::EN_MSG_ONTIPPERSTATEUPREG:
         return OSAL_NEW spm_corefi_tclMsgOnTipperStateUpReg;

      case spm_corefi_tclToken::EN_MSG_ONTIPPERSTATERELUPREG:
         return OSAL_NEW spm_corefi_tclMsgOnTipperStateRelUpReg;

      case spm_corefi_tclToken::EN_MSG_ONTIPPERSTATEGET:
         return OSAL_NEW spm_corefi_tclMsgOnTipperStateGet;

      case spm_corefi_tclToken::EN_MSG_IGNITIONCYCLESSTATUS:
         return OSAL_NEW spm_corefi_tclMsgIgnitionCyclesStatus;

      case spm_corefi_tclToken::EN_MSG_IGNITIONCYCLESUPREG:
         return OSAL_NEW spm_corefi_tclMsgIgnitionCyclesUpReg;

      case spm_corefi_tclToken::EN_MSG_IGNITIONCYCLESRELUPREG:
         return OSAL_NEW spm_corefi_tclMsgIgnitionCyclesRelUpReg;

      case spm_corefi_tclToken::EN_MSG_IGNITIONCYCLESGET:
         return OSAL_NEW spm_corefi_tclMsgIgnitionCyclesGet;

      case spm_corefi_tclToken::EN_MSG_SYSPWRMODESTATUS:
         return OSAL_NEW spm_corefi_tclMsgSysPwrModeStatus;

      case spm_corefi_tclToken::EN_MSG_SYSPWRMODEUPREG:
         return OSAL_NEW spm_corefi_tclMsgSysPwrModeUpReg;

      case spm_corefi_tclToken::EN_MSG_SYSPWRMODERELUPREG:
         return OSAL_NEW spm_corefi_tclMsgSysPwrModeRelUpReg;

      case spm_corefi_tclToken::EN_MSG_SYSPWRMODEGET:
         return OSAL_NEW spm_corefi_tclMsgSysPwrModeGet;

      case spm_corefi_tclToken::EN_MSG_SYSPWRSAVEMODESTATUS:
         return OSAL_NEW spm_corefi_tclMsgSysPwrSaveModeStatus;

      case spm_corefi_tclToken::EN_MSG_SYSPWRSAVEMODEGET:
         return OSAL_NEW spm_corefi_tclMsgSysPwrSaveModeGet;

      case spm_corefi_tclToken::EN_MSG_MAPDOWNLOADLOCKSTATESTATUS:
         return OSAL_NEW spm_corefi_tclMsgMapDownloadLockStateStatus;

      case spm_corefi_tclToken::EN_MSG_MAPDOWNLOADLOCKSTATEUPREG:
         return OSAL_NEW spm_corefi_tclMsgMapDownloadLockStateUpReg;

      case spm_corefi_tclToken::EN_MSG_MAPDOWNLOADLOCKSTATERELUPREG:
         return OSAL_NEW spm_corefi_tclMsgMapDownloadLockStateRelUpReg;

      case spm_corefi_tclToken::EN_MSG_MAPDOWNLOADLOCKSTATEGET:
         return OSAL_NEW spm_corefi_tclMsgMapDownloadLockStateGet;

      case spm_corefi_tclToken::EN_MSG_STANDBYTIMESET:
         return OSAL_NEW spm_corefi_tclMsgStandbyTimeSet;

      case spm_corefi_tclToken::EN_MSG_STANDBYTIMESTATUS:
         return OSAL_NEW spm_corefi_tclMsgStandbyTimeStatus;

      case spm_corefi_tclToken::EN_MSG_STANDBYTIMEGET:
         return OSAL_NEW spm_corefi_tclMsgStandbyTimeGet;

      case spm_corefi_tclToken::EN_MSG_PERSITENTSTANDBYTIMESET:
         return OSAL_NEW spm_corefi_tclMsgPersitentStandbyTimeSet;

      case spm_corefi_tclToken::EN_MSG_PERSITENTSTANDBYTIMESTATUS:
         return OSAL_NEW spm_corefi_tclMsgPersitentStandbyTimeStatus;

      case spm_corefi_tclToken::EN_MSG_PERSITENTSTANDBYTIMEGET:
         return OSAL_NEW spm_corefi_tclMsgPersitentStandbyTimeGet;

      case spm_corefi_tclToken::EN_MSG_IGNITIONOFFTIMESET:
         return OSAL_NEW spm_corefi_tclMsgIgnitionOffTimeSet;

      case spm_corefi_tclToken::EN_MSG_IGNITIONOFFTIMESTATUS:
         return OSAL_NEW spm_corefi_tclMsgIgnitionOffTimeStatus;

      case spm_corefi_tclToken::EN_MSG_IGNITIONOFFTIMEGET:
         return OSAL_NEW spm_corefi_tclMsgIgnitionOffTimeGet;

      case spm_corefi_tclToken::EN_MSG_DOOROPENTIMESET:
         return OSAL_NEW spm_corefi_tclMsgDoorOpenTimeSet;

      case spm_corefi_tclToken::EN_MSG_DOOROPENTIMESTATUS:
         return OSAL_NEW spm_corefi_tclMsgDoorOpenTimeStatus;

      case spm_corefi_tclToken::EN_MSG_DOOROPENTIMEGET:
         return OSAL_NEW spm_corefi_tclMsgDoorOpenTimeGet;

      case spm_corefi_tclToken::EN_MSG_CLOCKDISPLAYTIMESET:
         return OSAL_NEW spm_corefi_tclMsgClockDisplayTimeSet;

      case spm_corefi_tclToken::EN_MSG_CLOCKDISPLAYTIMESTATUS:
         return OSAL_NEW spm_corefi_tclMsgClockDisplayTimeStatus;

      case spm_corefi_tclToken::EN_MSG_CLOCKDISPLAYTIMEGET:
         return OSAL_NEW spm_corefi_tclMsgClockDisplayTimeGet;

      case spm_corefi_tclToken::EN_MSG_SYSTEMSTATETIMEGET:
         return OSAL_NEW spm_corefi_tclMsgSystemStateTimeGet;

      case spm_corefi_tclToken::EN_MSG_SYSTEMSTATETIMESET:
         return OSAL_NEW spm_corefi_tclMsgSystemStateTimeSet;

      case spm_corefi_tclToken::EN_MSG_SYSTEMSTATETIMESTATUS:
         return OSAL_NEW spm_corefi_tclMsgSystemStateTimeStatus;

      case spm_corefi_tclToken::EN_MSG_PROCESSLISTSTATUS:
         return OSAL_NEW spm_corefi_tclMsgProcessListStatus;

      case spm_corefi_tclToken::EN_MSG_PROCESSLISTUPREG:
         return OSAL_NEW spm_corefi_tclMsgProcessListUpReg;

      case spm_corefi_tclToken::EN_MSG_PROCESSLISTRELUPREG:
         return OSAL_NEW spm_corefi_tclMsgProcessListRelUpReg;

      case spm_corefi_tclToken::EN_MSG_PROCESSLISTGET:
         return OSAL_NEW spm_corefi_tclMsgProcessListGet;

      case spm_corefi_tclToken::EN_MSG_WAKEUPREASONSTATUS:
         return OSAL_NEW spm_corefi_tclMsgWakeupReasonStatus;

      case spm_corefi_tclToken::EN_MSG_WAKEUPREASONGET:
         return OSAL_NEW spm_corefi_tclMsgWakeupReasonGet;

      case spm_corefi_tclToken::EN_MSG_STARTUPREASONSTATUS:
         return OSAL_NEW spm_corefi_tclMsgStartupReasonStatus;

      case spm_corefi_tclToken::EN_MSG_STARTUPREASONGET:
         return OSAL_NEW spm_corefi_tclMsgStartupReasonGet;

      case spm_corefi_tclToken::EN_MSG_CONNECTTOBATTERYSTATUS:
         return OSAL_NEW spm_corefi_tclMsgConnectToBatteryStatus;

      case spm_corefi_tclToken::EN_MSG_CONNECTTOBATTERYGET:
         return OSAL_NEW spm_corefi_tclMsgConnectToBatteryGet;

      case spm_corefi_tclToken::EN_MSG_CODEREQUESTSTATESET:
         return OSAL_NEW spm_corefi_tclMsgCodeRequestStateSet;

      case spm_corefi_tclToken::EN_MSG_CODEREQUESTSTATESTATUS:
         return OSAL_NEW spm_corefi_tclMsgCodeRequestStateStatus;

      case spm_corefi_tclToken::EN_MSG_CODEREQUESTSTATEUPREG:
         return OSAL_NEW spm_corefi_tclMsgCodeRequestStateUpReg;

      case spm_corefi_tclToken::EN_MSG_CODEREQUESTSTATERELUPREG:
         return OSAL_NEW spm_corefi_tclMsgCodeRequestStateRelUpReg;

      case spm_corefi_tclToken::EN_MSG_CODEREQUESTSTATEGET:
         return OSAL_NEW spm_corefi_tclMsgCodeRequestStateGet;

      case spm_corefi_tclToken::EN_MSG_ACTIVESTARTUPSYNCPOINTSSTATUS:
         return OSAL_NEW spm_corefi_tclMsgActiveStartUpSyncPointsStatus;

      case spm_corefi_tclToken::EN_MSG_ACTIVESTARTUPSYNCPOINTSUPREG:
         return OSAL_NEW spm_corefi_tclMsgActiveStartUpSyncPointsUpReg;

      case spm_corefi_tclToken::EN_MSG_ACTIVESTARTUPSYNCPOINTSRELUPREG:
         return OSAL_NEW spm_corefi_tclMsgActiveStartUpSyncPointsRelUpReg;

      case spm_corefi_tclToken::EN_MSG_ACTIVESTARTUPSYNCPOINTSGET:
         return OSAL_NEW spm_corefi_tclMsgActiveStartUpSyncPointsGet;

      case spm_corefi_tclToken::EN_MSG_CVMEVENTSTATUS:
         return OSAL_NEW spm_corefi_tclMsgCvmEventStatus;

      case spm_corefi_tclToken::EN_MSG_CVMEVENTUPREG:
         return OSAL_NEW spm_corefi_tclMsgCvmEventUpReg;

      case spm_corefi_tclToken::EN_MSG_CVMEVENTRELUPREG:
         return OSAL_NEW spm_corefi_tclMsgCvmEventRelUpReg;

      case spm_corefi_tclToken::EN_MSG_CVMEVENTGET:
         return OSAL_NEW spm_corefi_tclMsgCvmEventGet;

      case spm_corefi_tclToken::EN_MSG_UBATSENSEGET:
         return OSAL_NEW spm_corefi_tclMsgUBatSenseGet;

      case spm_corefi_tclToken::EN_MSG_UBATSENSESTATUS:
         return OSAL_NEW spm_corefi_tclMsgUBatSenseStatus;

      case spm_corefi_tclToken::EN_MSG_COPROSTATESET:
         return OSAL_NEW spm_corefi_tclMsgCoproStateSet;

      case spm_corefi_tclToken::EN_MSG_COPROSTATESTATUS:
         return OSAL_NEW spm_corefi_tclMsgCoproStateStatus;

      case spm_corefi_tclToken::EN_MSG_COPROSTATEUPREG:
         return OSAL_NEW spm_corefi_tclMsgCoproStateUpReg;

      case spm_corefi_tclToken::EN_MSG_COPROSTATERELUPREG:
         return OSAL_NEW spm_corefi_tclMsgCoproStateRelUpReg;

      case spm_corefi_tclToken::EN_MSG_COPROSTATEGET:
         return OSAL_NEW spm_corefi_tclMsgCoproStateGet;

      case spm_corefi_tclToken::EN_MSG_DEVICEPOWERONTIMESET:
         return OSAL_NEW spm_corefi_tclMsgDevicePowerOnTimeSet;

      case spm_corefi_tclToken::EN_MSG_DEVICEPOWERONTIMESTATUS:
         return OSAL_NEW spm_corefi_tclMsgDevicePowerOnTimeStatus;

      case spm_corefi_tclToken::EN_MSG_DEVICEPOWERONTIMEGET:
         return OSAL_NEW spm_corefi_tclMsgDevicePowerOnTimeGet;

      case spm_corefi_tclToken::EN_MSG_LASTSYSTEMRUNTIMESTATUS:
         return OSAL_NEW spm_corefi_tclMsgLastSystemRuntimeStatus;

      case spm_corefi_tclToken::EN_MSG_LASTSYSTEMRUNTIMEGET:
         return OSAL_NEW spm_corefi_tclMsgLastSystemRuntimeGet;

      case spm_corefi_tclToken::EN_MSG_CURRENTSYSTEMRUNTIMESTATUS:
         return OSAL_NEW spm_corefi_tclMsgCurrentSystemRuntimeStatus;

      case spm_corefi_tclToken::EN_MSG_CURRENTSYSTEMRUNTIMEGET:
         return OSAL_NEW spm_corefi_tclMsgCurrentSystemRuntimeGet;

      case spm_corefi_tclToken::EN_MSG_RESETLISTSET:
         return OSAL_NEW spm_corefi_tclMsgResetListSet;

      case spm_corefi_tclToken::EN_MSG_RESETLISTSTATUS:
         return OSAL_NEW spm_corefi_tclMsgResetListStatus;

      case spm_corefi_tclToken::EN_MSG_RESETLISTGET:
         return OSAL_NEW spm_corefi_tclMsgResetListGet;

      case spm_corefi_tclToken::EN_MSG_RESETCOUNTERSET:
         return OSAL_NEW spm_corefi_tclMsgResetCounterSet;

      case spm_corefi_tclToken::EN_MSG_RESETCOUNTERSTATUS:
         return OSAL_NEW spm_corefi_tclMsgResetCounterStatus;

      case spm_corefi_tclToken::EN_MSG_RESETCOUNTERUPREG:
         return OSAL_NEW spm_corefi_tclMsgResetCounterUpReg;

      case spm_corefi_tclToken::EN_MSG_RESETCOUNTERRELUPREG:
         return OSAL_NEW spm_corefi_tclMsgResetCounterRelUpReg;

      case spm_corefi_tclToken::EN_MSG_RESETCOUNTERGET:
         return OSAL_NEW spm_corefi_tclMsgResetCounterGet;

      case spm_corefi_tclToken::EN_MSG_TRANSPORTMODELISTSET:
         return OSAL_NEW spm_corefi_tclMsgTransportModeListSet;

      case spm_corefi_tclToken::EN_MSG_TRANSPORTMODELISTSTATUS:
         return OSAL_NEW spm_corefi_tclMsgTransportModeListStatus;

      case spm_corefi_tclToken::EN_MSG_TRANSPORTMODELISTGET:
         return OSAL_NEW spm_corefi_tclMsgTransportModeListGet;

      case spm_corefi_tclToken::EN_MSG_RESETHISTORYSET:
         return OSAL_NEW spm_corefi_tclMsgResetHistorySet;

      case spm_corefi_tclToken::EN_MSG_RESETHISTORYSTATUS:
         return OSAL_NEW spm_corefi_tclMsgResetHistoryStatus;

      case spm_corefi_tclToken::EN_MSG_RESETHISTORYGET:
         return OSAL_NEW spm_corefi_tclMsgResetHistoryGet;

      case spm_corefi_tclToken::EN_MSG_WAKEUPHISTORYSET:
         return OSAL_NEW spm_corefi_tclMsgWakeupHistorySet;

      case spm_corefi_tclToken::EN_MSG_WAKEUPHISTORYSTATUS:
         return OSAL_NEW spm_corefi_tclMsgWakeupHistoryStatus;

      case spm_corefi_tclToken::EN_MSG_WAKEUPHISTORYGET:
         return OSAL_NEW spm_corefi_tclMsgWakeupHistoryGet;

      case spm_corefi_tclToken::EN_MSG_STATEHISTORYSET:
         return OSAL_NEW spm_corefi_tclMsgStateHistorySet;

      case spm_corefi_tclToken::EN_MSG_STATEHISTORYSTATUS:
         return OSAL_NEW spm_corefi_tclMsgStateHistoryStatus;

      case spm_corefi_tclToken::EN_MSG_STATEHISTORYGET:
         return OSAL_NEW spm_corefi_tclMsgStateHistoryGet;

      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY01SET:
         return OSAL_NEW spm_corefi_tclMsgErrStateHistory01Set;

      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY01STATUS:
         return OSAL_NEW spm_corefi_tclMsgErrStateHistory01Status;

      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY01GET:
         return OSAL_NEW spm_corefi_tclMsgErrStateHistory01Get;

      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY02SET:
         return OSAL_NEW spm_corefi_tclMsgErrStateHistory02Set;

      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY02STATUS:
         return OSAL_NEW spm_corefi_tclMsgErrStateHistory02Status;

      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY02GET:
         return OSAL_NEW spm_corefi_tclMsgErrStateHistory02Get;

      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY03SET:
         return OSAL_NEW spm_corefi_tclMsgErrStateHistory03Set;

      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY03STATUS:
         return OSAL_NEW spm_corefi_tclMsgErrStateHistory03Status;

      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY03GET:
         return OSAL_NEW spm_corefi_tclMsgErrStateHistory03Get;

      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY04SET:
         return OSAL_NEW spm_corefi_tclMsgErrStateHistory04Set;

      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY04STATUS:
         return OSAL_NEW spm_corefi_tclMsgErrStateHistory04Status;

      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY04GET:
         return OSAL_NEW spm_corefi_tclMsgErrStateHistory04Get;

      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY05SET:
         return OSAL_NEW spm_corefi_tclMsgErrStateHistory05Set;

      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY05STATUS:
         return OSAL_NEW spm_corefi_tclMsgErrStateHistory05Status;

      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY05GET:
         return OSAL_NEW spm_corefi_tclMsgErrStateHistory05Get;

      case spm_corefi_tclToken::EN_MSG_SWITCHONHISTORYSET:
         return OSAL_NEW spm_corefi_tclMsgSwitchOnHistorySet;

      case spm_corefi_tclToken::EN_MSG_SWITCHONHISTORYSTATUS:
         return OSAL_NEW spm_corefi_tclMsgSwitchOnHistoryStatus;

      case spm_corefi_tclToken::EN_MSG_SWITCHONHISTORYGET:
         return OSAL_NEW spm_corefi_tclMsgSwitchOnHistoryGet;

      case spm_corefi_tclToken::EN_MSG_DEVICEONCOUNTERSTATUS:
         return OSAL_NEW spm_corefi_tclMsgDeviceOnCounterStatus;

      case spm_corefi_tclToken::EN_MSG_DEVICEONCOUNTERGET:
         return OSAL_NEW spm_corefi_tclMsgDeviceOnCounterGet;

      case spm_corefi_tclToken::EN_MSG_VOLTAGEEVENTCOUNTERSTATUS:
         return OSAL_NEW spm_corefi_tclMsgVoltageEventCounterStatus;

      case spm_corefi_tclToken::EN_MSG_VOLTAGEEVENTCOUNTERGET:
         return OSAL_NEW spm_corefi_tclMsgVoltageEventCounterGet;

      case spm_corefi_tclToken::EN_MSG_VOLTAGERANGEHISTOGRAMSTATUS:
         return OSAL_NEW spm_corefi_tclMsgVoltageRangeHistogramStatus;

      case spm_corefi_tclToken::EN_MSG_VOLTAGERANGEHISTOGRAMGET:
         return OSAL_NEW spm_corefi_tclMsgVoltageRangeHistogramGet;

      case spm_corefi_tclToken::EN_MSG_CPUUSAGESTATISTICSTATUS:
         return OSAL_NEW spm_corefi_tclMsgCpuUsageStatisticStatus;

      case spm_corefi_tclToken::EN_MSG_CPUUSAGESTATISTICGET:
         return OSAL_NEW spm_corefi_tclMsgCpuUsageStatisticGet;

      case spm_corefi_tclToken::EN_MSG_RAMUSAGESTATISTICSTATUS:
         return OSAL_NEW spm_corefi_tclMsgRamUsageStatisticStatus;

      case spm_corefi_tclToken::EN_MSG_RAMUSAGESTATISTICGET:
         return OSAL_NEW spm_corefi_tclMsgRamUsageStatisticGet;

      case spm_corefi_tclToken::EN_MSG_STARTUPTIMESTATISTICSTATUS:
         return OSAL_NEW spm_corefi_tclMsgStartupTimeStatisticStatus;

      case spm_corefi_tclToken::EN_MSG_STARTUPTIMESTATISTICGET:
         return OSAL_NEW spm_corefi_tclMsgStartupTimeStatisticGet;

      case spm_corefi_tclToken::EN_MSG_SWVERSIONSTATISTICSTATUS:
         return OSAL_NEW spm_corefi_tclMsgSWVersionStatisticStatus;

      case spm_corefi_tclToken::EN_MSG_SWVERSIONSTATISTICGET:
         return OSAL_NEW spm_corefi_tclMsgSWVersionStatisticGet;

      case spm_corefi_tclToken::EN_MSG_RUNLEVELSTATEUPREG:
         return OSAL_NEW spm_corefi_tclMsgRunlevelStateUpReg;

      case spm_corefi_tclToken::EN_MSG_RUNLEVELSTATERELUPREG:
         return OSAL_NEW spm_corefi_tclMsgRunlevelStateRelUpReg;

      case spm_corefi_tclToken::EN_MSG_RUNLEVELSTATEGET:
         return OSAL_NEW spm_corefi_tclMsgRunlevelStateGet;

      case spm_corefi_tclToken::EN_MSG_RUNLEVELSTATESTATUS:
         return OSAL_NEW spm_corefi_tclMsgRunlevelStateStatus;

      case spm_corefi_tclToken::EN_MSG_RESTARTSET:
         return OSAL_NEW spm_corefi_tclMsgRestartSet;

      case spm_corefi_tclToken::EN_MSG_RESTARTSTATUS:
         return OSAL_NEW spm_corefi_tclMsgRestartStatus;

      case spm_corefi_tclToken::EN_MSG_RESTARTUPREG:
         return OSAL_NEW spm_corefi_tclMsgRestartUpReg;

      case spm_corefi_tclToken::EN_MSG_RESTARTRELUPREG:
         return OSAL_NEW spm_corefi_tclMsgRestartRelUpReg;

      case spm_corefi_tclToken::EN_MSG_RESTARTGET:
         return OSAL_NEW spm_corefi_tclMsgRestartGet;

      case spm_corefi_tclToken::EN_MSG_LIFESIGNSTATUS:
         return OSAL_NEW spm_corefi_tclMsgLifesignStatus;

      case spm_corefi_tclToken::EN_MSG_LIFESIGNUPREG:
         return OSAL_NEW spm_corefi_tclMsgLifesignUpReg;

      case spm_corefi_tclToken::EN_MSG_LIFESIGNRELUPREG:
         return OSAL_NEW spm_corefi_tclMsgLifesignRelUpReg;

      case spm_corefi_tclToken::EN_MSG_LIFESIGNGET:
         return OSAL_NEW spm_corefi_tclMsgLifesignGet;

      case spm_corefi_tclToken::EN_MSG_HMISTATESTATUS:
         return OSAL_NEW spm_corefi_tclMsgHmiStateStatus;

      case spm_corefi_tclToken::EN_MSG_HMISTATEUPREG:
         return OSAL_NEW spm_corefi_tclMsgHmiStateUpReg;

      case spm_corefi_tclToken::EN_MSG_HMISTATERELUPREG:
         return OSAL_NEW spm_corefi_tclMsgHmiStateRelUpReg;

      case spm_corefi_tclToken::EN_MSG_HMISTATEGET:
         return OSAL_NEW spm_corefi_tclMsgHmiStateGet;

      case spm_corefi_tclToken::EN_MSG_SYSTEMPOWERBEHAVIOURSTATUS:
         return OSAL_NEW spm_corefi_tclMsgSystemPowerBehaviourStatus;

      case spm_corefi_tclToken::EN_MSG_SYSTEMPOWERBEHAVIOURUPREG:
         return OSAL_NEW spm_corefi_tclMsgSystemPowerBehaviourUpReg;

      case spm_corefi_tclToken::EN_MSG_SYSTEMPOWERBEHAVIOURRELUPREG:
         return OSAL_NEW spm_corefi_tclMsgSystemPowerBehaviourRelUpReg;

      case spm_corefi_tclToken::EN_MSG_SYSTEMPOWERBEHAVIOURGET:
         return OSAL_NEW spm_corefi_tclMsgSystemPowerBehaviourGet;

      case spm_corefi_tclToken::EN_MSG_DIMSTATESTATUS:
         return OSAL_NEW spm_corefi_tclMsgDimStateStatus;

      case spm_corefi_tclToken::EN_MSG_DIMSTATEUPREG:
         return OSAL_NEW spm_corefi_tclMsgDimStateUpReg;

      case spm_corefi_tclToken::EN_MSG_DIMSTATERELUPREG:
         return OSAL_NEW spm_corefi_tclMsgDimStateRelUpReg;

      case spm_corefi_tclToken::EN_MSG_DIMSTATEGET:
         return OSAL_NEW spm_corefi_tclMsgDimStateGet;

      case spm_corefi_tclToken::EN_MSG_DIMMINGSTATESTATUS:
         return OSAL_NEW spm_corefi_tclMsgDimmingStateStatus;

      case spm_corefi_tclToken::EN_MSG_DIMMINGSTATEUPREG:
         return OSAL_NEW spm_corefi_tclMsgDimmingStateUpReg;

      case spm_corefi_tclToken::EN_MSG_DIMMINGSTATERELUPREG:
         return OSAL_NEW spm_corefi_tclMsgDimmingStateRelUpReg;

      case spm_corefi_tclToken::EN_MSG_DIMMINGSTATEGET:
         return OSAL_NEW spm_corefi_tclMsgDimmingStateGet;

      case spm_corefi_tclToken::EN_MSG_BLUETOOTHSTATESTATUS:
         return OSAL_NEW spm_corefi_tclMsgBluetoothStateStatus;

      case spm_corefi_tclToken::EN_MSG_BLUETOOTHSTATEUPREG:
         return OSAL_NEW spm_corefi_tclMsgBluetoothStateUpReg;

      case spm_corefi_tclToken::EN_MSG_BLUETOOTHSTATERELUPREG:
         return OSAL_NEW spm_corefi_tclMsgBluetoothStateRelUpReg;

      case spm_corefi_tclToken::EN_MSG_BLUETOOTHSTATEGET:
         return OSAL_NEW spm_corefi_tclMsgBluetoothStateGet;

      case spm_corefi_tclToken::EN_MSG_AUDIOSTATESTATUS:
         return OSAL_NEW spm_corefi_tclMsgAudioStateStatus;

      case spm_corefi_tclToken::EN_MSG_AUDIOSTATEUPREG:
         return OSAL_NEW spm_corefi_tclMsgAudioStateUpReg;

      case spm_corefi_tclToken::EN_MSG_AUDIOSTATERELUPREG:
         return OSAL_NEW spm_corefi_tclMsgAudioStateRelUpReg;

      case spm_corefi_tclToken::EN_MSG_AUDIOSTATEGET:
         return OSAL_NEW spm_corefi_tclMsgAudioStateGet;

      case spm_corefi_tclToken::EN_MSG_SPISTATESTATUS:
         return OSAL_NEW spm_corefi_tclMsgSpiStateStatus;

      case spm_corefi_tclToken::EN_MSG_SPISTATEUPREG:
         return OSAL_NEW spm_corefi_tclMsgSpiStateUpReg;

      case spm_corefi_tclToken::EN_MSG_SPISTATERELUPREG:
         return OSAL_NEW spm_corefi_tclMsgSpiStateRelUpReg;

      case spm_corefi_tclToken::EN_MSG_SPISTATEGET:
         return OSAL_NEW spm_corefi_tclMsgSpiStateGet;

      case spm_corefi_tclToken::EN_MSG_TUNERSTATESTATUS:
         return OSAL_NEW spm_corefi_tclMsgTunerStateStatus;

      case spm_corefi_tclToken::EN_MSG_TUNERSTATEUPREG:
         return OSAL_NEW spm_corefi_tclMsgTunerStateUpReg;

      case spm_corefi_tclToken::EN_MSG_TUNERSTATERELUPREG:
         return OSAL_NEW spm_corefi_tclMsgTunerStateRelUpReg;

      case spm_corefi_tclToken::EN_MSG_TUNERSTATEGET:
         return OSAL_NEW spm_corefi_tclMsgTunerStateGet;

      case spm_corefi_tclToken::EN_MSG_WIFISTATESTATUS:
         return OSAL_NEW spm_corefi_tclMsgWifiStateStatus;

      case spm_corefi_tclToken::EN_MSG_WIFISTATEUPREG:
         return OSAL_NEW spm_corefi_tclMsgWifiStateUpReg;

      case spm_corefi_tclToken::EN_MSG_WIFISTATERELUPREG:
         return OSAL_NEW spm_corefi_tclMsgWifiStateRelUpReg;

      case spm_corefi_tclToken::EN_MSG_WIFISTATEGET:
         return OSAL_NEW spm_corefi_tclMsgWifiStateGet;

      case spm_corefi_tclToken::EN_MSG_ONOFFREASONSET:
         return OSAL_NEW spm_corefi_tclMsgOnOffReasonSet;

      case spm_corefi_tclToken::EN_MSG_ONOFFREASONGET:
         return OSAL_NEW spm_corefi_tclMsgOnOffReasonGet;

      case spm_corefi_tclToken::EN_MSG_ONOFFREASONSTATUS:
         return OSAL_NEW spm_corefi_tclMsgOnOffReasonStatus;

      case spm_corefi_tclToken::EN_MSG_ONOFFREASONUPREG:
         return OSAL_NEW spm_corefi_tclMsgOnOffReasonUpReg;

      case spm_corefi_tclToken::EN_MSG_ONOFFREASONRELUPREG:
         return OSAL_NEW spm_corefi_tclMsgOnOffReasonRelUpReg;

      case spm_corefi_tclToken::EN_MSG_WAKEUPLISTSET:
         return OSAL_NEW spm_corefi_tclMsgWakeupListSet;

      case spm_corefi_tclToken::EN_MSG_WAKEUPLISTGET:
         return OSAL_NEW spm_corefi_tclMsgWakeupListGet;

      case spm_corefi_tclToken::EN_MSG_WAKEUPLISTSTATUS:
         return OSAL_NEW spm_corefi_tclMsgWakeupListStatus;

      case spm_corefi_tclToken::EN_MSG_STARTUPFINISHEDUPREG:
         return OSAL_NEW spm_corefi_tclMsgStartupFinishedUpReg;

      case spm_corefi_tclToken::EN_MSG_STARTUPFINISHEDRELUPREG:
         return OSAL_NEW spm_corefi_tclMsgStartupFinishedRelUpReg;

      case spm_corefi_tclToken::EN_MSG_STARTUPFINISHEDGET:
         return OSAL_NEW spm_corefi_tclMsgStartupFinishedGet;

      case spm_corefi_tclToken::EN_MSG_STARTUPFINISHEDSTATUS:
         return OSAL_NEW spm_corefi_tclMsgStartupFinishedStatus;

      case spm_corefi_tclToken::EN_MSG_SYSSTATEUPREG:
         return OSAL_NEW spm_corefi_tclMsgSysStateUpReg;

      case spm_corefi_tclToken::EN_MSG_SYSSTATERELUPREG:
         return OSAL_NEW spm_corefi_tclMsgSysStateRelUpReg;

      case spm_corefi_tclToken::EN_MSG_SYSSTATEGET:
         return OSAL_NEW spm_corefi_tclMsgSysStateGet;

      case spm_corefi_tclToken::EN_MSG_SYSSTATESTATUS:
         return OSAL_NEW spm_corefi_tclMsgSysStateStatus;

      case spm_corefi_tclToken::EN_MSG_MOSTSTATEUPREG:
         return OSAL_NEW spm_corefi_tclMsgMostStateUpReg;

      case spm_corefi_tclToken::EN_MSG_MOSTSTATERELUPREG:
         return OSAL_NEW spm_corefi_tclMsgMostStateRelUpReg;

      case spm_corefi_tclToken::EN_MSG_MOSTSTATEGET:
         return OSAL_NEW spm_corefi_tclMsgMostStateGet;

      case spm_corefi_tclToken::EN_MSG_MOSTSTATESTATUS:
         return OSAL_NEW spm_corefi_tclMsgMostStateStatus;

      case spm_corefi_tclToken::EN_MSG_MOSTVERSIONGET:
         return OSAL_NEW spm_corefi_tclMsgMostVersionGet;

      case spm_corefi_tclToken::EN_MSG_MOSTVERSIONSTATUS:
         return OSAL_NEW spm_corefi_tclMsgMostVersionStatus;

      case spm_corefi_tclToken::EN_MSG_RVCSTATESET:
         return OSAL_NEW spm_corefi_tclMsgRVCStateSet;

      case spm_corefi_tclToken::EN_MSG_RVCSTATEGET:
         return OSAL_NEW spm_corefi_tclMsgRVCStateGet;

      case spm_corefi_tclToken::EN_MSG_RVCSTATESTATUS:
         return OSAL_NEW spm_corefi_tclMsgRVCStateStatus;

      case spm_corefi_tclToken::EN_MSG_TRIGGERMOSTREMOTERESETGET:
         return OSAL_NEW spm_corefi_tclMsgTriggerMostRemoteResetGet;

      case spm_corefi_tclToken::EN_MSG_TRIGGERMOSTREMOTERESETSET:
         return OSAL_NEW spm_corefi_tclMsgTriggerMostRemoteResetSet;

      case spm_corefi_tclToken::EN_MSG_TRIGGERMOSTREMOTERESETUPREG:
         return OSAL_NEW spm_corefi_tclMsgTriggerMostRemoteResetUpReg;

      case spm_corefi_tclToken::EN_MSG_TRIGGERMOSTREMOTERESETRELUPREG:
         return OSAL_NEW spm_corefi_tclMsgTriggerMostRemoteResetRelUpReg;

      case spm_corefi_tclToken::EN_MSG_TRIGGERMOSTREMOTERESETSTATUS:
         return OSAL_NEW spm_corefi_tclMsgTriggerMostRemoteResetStatus;

      case spm_corefi_tclToken::EN_MSG_PARTNUMBERGET:
         return OSAL_NEW spm_corefi_tclMsgPartnumberGet;

      case spm_corefi_tclToken::EN_MSG_PARTNUMBERSET:
         return OSAL_NEW spm_corefi_tclMsgPartnumberSet;

      case spm_corefi_tclToken::EN_MSG_PARTNUMBERSTATUS:
         return OSAL_NEW spm_corefi_tclMsgPartnumberStatus;

      case spm_corefi_tclToken::EN_MSG_PARTNUMBERSGET:
         return OSAL_NEW spm_corefi_tclMsgPartnumbersGet;

      case spm_corefi_tclToken::EN_MSG_PARTNUMBERSSTATUS:
         return OSAL_NEW spm_corefi_tclMsgPartnumbersStatus;

      case spm_corefi_tclToken::EN_MSG_ALPHACODEGET:
         return OSAL_NEW spm_corefi_tclMsgAlphacodeGet;

      case spm_corefi_tclToken::EN_MSG_ALPHACODESET:
         return OSAL_NEW spm_corefi_tclMsgAlphacodeSet;

      case spm_corefi_tclToken::EN_MSG_ALPHACODESTATUS:
         return OSAL_NEW spm_corefi_tclMsgAlphacodeStatus;

      case spm_corefi_tclToken::EN_MSG_ALPHACODESGET:
         return OSAL_NEW spm_corefi_tclMsgAlphacodesGet;

      case spm_corefi_tclToken::EN_MSG_ALPHACODESSTATUS:
         return OSAL_NEW spm_corefi_tclMsgAlphacodesStatus;

      case spm_corefi_tclToken::EN_MSG_MANUFACTURERSENABLECOUNTERGET:
         return OSAL_NEW spm_corefi_tclMsgManufacturersEnableCounterGet;

      case spm_corefi_tclToken::EN_MSG_MANUFACTURERSENABLECOUNTERSET:
         return OSAL_NEW spm_corefi_tclMsgManufacturersEnableCounterSet;

      case spm_corefi_tclToken::EN_MSG_MANUFACTURERSENABLECOUNTERSTATUS:
         return OSAL_NEW spm_corefi_tclMsgManufacturersEnableCounterStatus;

      case spm_corefi_tclToken::EN_MSG_NOCALIBRATIONSTATEGET:
         return OSAL_NEW spm_corefi_tclMsgNoCalibrationStateGet;

      case spm_corefi_tclToken::EN_MSG_NOCALIBRATIONSTATESET:
         return OSAL_NEW spm_corefi_tclMsgNoCalibrationStateSet;

      case spm_corefi_tclToken::EN_MSG_NOCALIBRATIONSTATESTATUS:
         return OSAL_NEW spm_corefi_tclMsgNoCalibrationStateStatus;

      case spm_corefi_tclToken::EN_MSG_SECURITYCOMMERRORGET:
         return OSAL_NEW spm_corefi_tclMsgSecurityCommErrorGet;

      case spm_corefi_tclToken::EN_MSG_SECURITYCOMMERRORSTATUS:
         return OSAL_NEW spm_corefi_tclMsgSecurityCommErrorStatus;

      case spm_corefi_tclToken::EN_MSG_SECURITYMORETHAN10VINGET:
         return OSAL_NEW spm_corefi_tclMsgSecurityMoreThan10VinGet;

      case spm_corefi_tclToken::EN_MSG_SECURITYMORETHAN10VINSTATUS:
         return OSAL_NEW spm_corefi_tclMsgSecurityMoreThan10VinStatus;

      case spm_corefi_tclToken::EN_MSG_SECURITYINVALIDVINGET:
         return OSAL_NEW spm_corefi_tclMsgSecurityInvalidVinGet;

      case spm_corefi_tclToken::EN_MSG_SECURITYINVALIDVINSTATUS:
         return OSAL_NEW spm_corefi_tclMsgSecurityInvalidVinStatus;

      case spm_corefi_tclToken::EN_MSG_SECURITYCURRENTVINGET:
         return OSAL_NEW spm_corefi_tclMsgSecurityCurrentVinGet;

      case spm_corefi_tclToken::EN_MSG_SECURITYCURRENTVINSTATUS:
         return OSAL_NEW spm_corefi_tclMsgSecurityCurrentVinStatus;

      case spm_corefi_tclToken::EN_MSG_SECURITYVINHISTORYGET:
         return OSAL_NEW spm_corefi_tclMsgSecurityVinHistoryGet;

      case spm_corefi_tclToken::EN_MSG_SECURITYVINHISTORYSTATUS:
         return OSAL_NEW spm_corefi_tclMsgSecurityVinHistoryStatus;

      case spm_corefi_tclToken::EN_MSG_VINGET:
         return OSAL_NEW spm_corefi_tclMsgVINGet;

      case spm_corefi_tclToken::EN_MSG_VINSTATUS:
         return OSAL_NEW spm_corefi_tclMsgVINStatus;

      case spm_corefi_tclToken::EN_MSG_SECURITYSTATEUPREG:
         return OSAL_NEW spm_corefi_tclMsgSecurityStateUpReg;

      case spm_corefi_tclToken::EN_MSG_SECURITYSTATERELUPREG:
         return OSAL_NEW spm_corefi_tclMsgSecurityStateRelUpReg;

      case spm_corefi_tclToken::EN_MSG_SECURITYSTATEGET:
         return OSAL_NEW spm_corefi_tclMsgSecurityStateGet;

      case spm_corefi_tclToken::EN_MSG_SECURITYSTATESTATUS:
         return OSAL_NEW spm_corefi_tclMsgSecurityStateStatus;

      case spm_corefi_tclToken::EN_MSG_VEHICLEIDUPREG:
         return OSAL_NEW spm_corefi_tclMsgVehicleIDUpReg;

      case spm_corefi_tclToken::EN_MSG_VEHICLEIDRELUPREG:
         return OSAL_NEW spm_corefi_tclMsgVehicleIDRelUpReg;

      case spm_corefi_tclToken::EN_MSG_VEHICLEIDGET:
         return OSAL_NEW spm_corefi_tclMsgVehicleIDGet;

      case spm_corefi_tclToken::EN_MSG_VEHICLEIDSTATUS:
         return OSAL_NEW spm_corefi_tclMsgVehicleIDStatus;

      case spm_corefi_tclToken::EN_MSG_DISPLAYVARIANTGET:
         return OSAL_NEW spm_corefi_tclMsgDisplayVariantGet;

      case spm_corefi_tclToken::EN_MSG_DISPLAYVARIANTSET:
         return OSAL_NEW spm_corefi_tclMsgDisplayVariantSet;

      case spm_corefi_tclToken::EN_MSG_DISPLAYVARIANTSTATUS:
         return OSAL_NEW spm_corefi_tclMsgDisplayVariantStatus;

      case spm_corefi_tclToken::EN_MSG_REDUCTIONLEVELUPREG:
         return OSAL_NEW spm_corefi_tclMsgReductionLevelUpReg;

      case spm_corefi_tclToken::EN_MSG_REDUCTIONLEVELRELUPREG:
         return OSAL_NEW spm_corefi_tclMsgReductionLevelRelUpReg;

      case spm_corefi_tclToken::EN_MSG_REDUCTIONLEVELGET:
         return OSAL_NEW spm_corefi_tclMsgReductionLevelGet;

      case spm_corefi_tclToken::EN_MSG_REDUCTIONLEVELSTATUS:
         return OSAL_NEW spm_corefi_tclMsgReductionLevelStatus;

      case spm_corefi_tclToken::EN_MSG_STARTUPSTATEUPREG:
         return OSAL_NEW spm_corefi_tclMsgStartupStateUpReg;

      case spm_corefi_tclToken::EN_MSG_STARTUPSTATERELUPREG:
         return OSAL_NEW spm_corefi_tclMsgStartupStateRelUpReg;

      case spm_corefi_tclToken::EN_MSG_STARTUPSTATEGET:
         return OSAL_NEW spm_corefi_tclMsgStartupStateGet;

      case spm_corefi_tclToken::EN_MSG_STARTUPSTATESTATUS:
         return OSAL_NEW spm_corefi_tclMsgStartupStateStatus;

      case spm_corefi_tclToken::EN_MSG_ENTERTAINMUTEUPREG:
         return OSAL_NEW spm_corefi_tclMsgEntertainMuteUpReg;

      case spm_corefi_tclToken::EN_MSG_ENTERTAINMUTERELUPREG:
         return OSAL_NEW spm_corefi_tclMsgEntertainMuteRelUpReg;

      case spm_corefi_tclToken::EN_MSG_ENTERTAINMUTEGET:
         return OSAL_NEW spm_corefi_tclMsgEntertainMuteGet;

      case spm_corefi_tclToken::EN_MSG_ENTERTAINMUTESTATUS:
         return OSAL_NEW spm_corefi_tclMsgEntertainMuteStatus;

      case spm_corefi_tclToken::EN_MSG_WELCOMEAUDIOSTATEGET:
         return OSAL_NEW spm_corefi_tclMsgWelcomeAudioStateGet;

      case spm_corefi_tclToken::EN_MSG_WELCOMEAUDIOSTATESTATUS:
         return OSAL_NEW spm_corefi_tclMsgWelcomeAudioStateStatus;

      case spm_corefi_tclToken::EN_MSG_UNBALLASTTIMEFROMENGINESTOPPEDGET:
         return OSAL_NEW spm_corefi_tclMsgUnballastTimeFromEngineStoppedGet;

      case spm_corefi_tclToken::EN_MSG_UNBALLASTTIMEFROMENGINESTOPPEDSTATUS:
         return OSAL_NEW spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus;

      case spm_corefi_tclToken::EN_MSG_UNBALLASTTIMEBEFOREUNBALLASTGET:
         return OSAL_NEW spm_corefi_tclMsgUnballastTimeBeforeUnballastGet;

      case spm_corefi_tclToken::EN_MSG_UNBALLASTTIMEBEFOREUNBALLASTSTATUS:
         return OSAL_NEW spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus;

      case spm_corefi_tclToken::EN_MSG_UNBALLASTTIMEBEFOREUNBALLASTSET:
         return OSAL_NEW spm_corefi_tclMsgUnballastTimeBeforeUnballastSet;

      case spm_corefi_tclToken::EN_MSG_UNBALLASTWARNINGTIMEGET:
         return OSAL_NEW spm_corefi_tclMsgUnballastWarningTimeGet;

      case spm_corefi_tclToken::EN_MSG_UNBALLASTWARNINGTIMESTATUS:
         return OSAL_NEW spm_corefi_tclMsgUnballastWarningTimeStatus;

      case spm_corefi_tclToken::EN_MSG_UNBALLASTWARNINGTIMESET:
         return OSAL_NEW spm_corefi_tclMsgUnballastWarningTimeSet;

      case spm_corefi_tclToken::EN_MSG_DEGRADEDCOUNTGET:
         return OSAL_NEW spm_corefi_tclMsgDegradedCountGet;

      case spm_corefi_tclToken::EN_MSG_DEGRADEDCOUNTSTATUS:
         return OSAL_NEW spm_corefi_tclMsgDegradedCountStatus;

      case spm_corefi_tclToken::EN_MSG_DEGRADEDTIMEGET:
         return OSAL_NEW spm_corefi_tclMsgDegradedTimeGet;

      case spm_corefi_tclToken::EN_MSG_DEGRADEDTIMESTATUS:
         return OSAL_NEW spm_corefi_tclMsgDegradedTimeStatus;

      case spm_corefi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMEUPREG:
         return OSAL_NEW spm_corefi_tclMsgPhoneHandoverWarnTimeUpReg;

      case spm_corefi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMERELUPREG:
         return OSAL_NEW spm_corefi_tclMsgPhoneHandoverWarnTimeRelUpReg;

      case spm_corefi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMEGET:
         return OSAL_NEW spm_corefi_tclMsgPhoneHandoverWarnTimeGet;

      case spm_corefi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMESET:
         return OSAL_NEW spm_corefi_tclMsgPhoneHandoverWarnTimeSet;

      case spm_corefi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMESTATUS:
         return OSAL_NEW spm_corefi_tclMsgPhoneHandoverWarnTimeStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all spm_corefifi messages

// common functions

tU16 spm_corefi_tclMsgBaseMessage::u16GetServiceID() const
{
   return SPM_COREFI_C_U16_SERVICE_ID;
}

tU16 spm_corefi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 spm_corefi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& spm_corefi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& spm_corefi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 spm_corefi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& spm_corefi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& spm_corefi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSystemModeMethodStart::spm_corefi_tclMsgSystemModeMethodStart(const spm_corefi_tclMsgSystemModeMethodStart& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   eSystemMode = coRef.eSystemMode;
}
spm_corefi_tclMsgSystemModeMethodStart& spm_corefi_tclMsgSystemModeMethodStart::operator=(const spm_corefi_tclMsgSystemModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   eSystemMode = coRef.eSystemMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgSystemModeMethodStart::spm_corefi_tclMsgSystemModeMethodStart()
:eSystemMode()
 {}

tS32 spm_corefi_tclMsgSystemModeMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SYSTEMMODEMETHODSTART;
}


spm_corefi_tclMsgSystemModeMethodStart::~spm_corefi_tclMsgSystemModeMethodStart()
{}

tU32 spm_corefi_tclMsgSystemModeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_corefi_tclMsgSystemModeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eSystemMode);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSystemModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eSystemMode);
   return oOut;
}

tBool spm_corefi_tclMsgSystemModeMethodStart::operator==(const spm_corefi_tclMsgSystemModeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eSystemMode == roRef.eSystemMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSystemModeMethodResult::spm_corefi_tclMsgSystemModeMethodResult(const spm_corefi_tclMsgSystemModeMethodResult& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   s32ReturnVal = coRef.s32ReturnVal;
}
spm_corefi_tclMsgSystemModeMethodResult& spm_corefi_tclMsgSystemModeMethodResult::operator=(const spm_corefi_tclMsgSystemModeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   s32ReturnVal = coRef.s32ReturnVal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgSystemModeMethodResult::spm_corefi_tclMsgSystemModeMethodResult()
:s32ReturnVal(0)
 {}

tS32 spm_corefi_tclMsgSystemModeMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SYSTEMMODEMETHODRESULT;
}


spm_corefi_tclMsgSystemModeMethodResult::~spm_corefi_tclMsgSystemModeMethodResult()
{}

tU32 spm_corefi_tclMsgSystemModeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgSystemModeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32ReturnVal);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSystemModeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32ReturnVal);
   return oOut;
}

tBool spm_corefi_tclMsgSystemModeMethodResult::operator==(const spm_corefi_tclMsgSystemModeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32ReturnVal == roRef.s32ReturnVal);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgDownloadLockStateMethodStart::spm_corefi_tclMsgDownloadLockStateMethodStart(const spm_corefi_tclMsgDownloadLockStateMethodStart& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   strRestrictedDlState = coRef.strRestrictedDlState;
   eRestrictedDlMode = coRef.eRestrictedDlMode;
}
spm_corefi_tclMsgDownloadLockStateMethodStart& spm_corefi_tclMsgDownloadLockStateMethodStart::operator=(const spm_corefi_tclMsgDownloadLockStateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   strRestrictedDlState = coRef.strRestrictedDlState;
   eRestrictedDlMode = coRef.eRestrictedDlMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgDownloadLockStateMethodStart::vDestroy()
{
   strRestrictedDlState.vDestroy();
}

spm_corefi_tclMsgDownloadLockStateMethodStart::spm_corefi_tclMsgDownloadLockStateMethodStart()
:strRestrictedDlState()
,eRestrictedDlMode()
 {}

tS32 spm_corefi_tclMsgDownloadLockStateMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DOWNLOADLOCKSTATEMETHODSTART;
}


spm_corefi_tclMsgDownloadLockStateMethodStart::~spm_corefi_tclMsgDownloadLockStateMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgDownloadLockStateMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+strRestrictedDlState.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_corefi_tclMsgDownloadLockStateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strRestrictedDlState);
   (tVoid) (oIn >> eRestrictedDlMode);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgDownloadLockStateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strRestrictedDlState);
   (tVoid) (oOut << eRestrictedDlMode);
   return oOut;
}

tBool spm_corefi_tclMsgDownloadLockStateMethodStart::operator==(const spm_corefi_tclMsgDownloadLockStateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strRestrictedDlState == roRef.strRestrictedDlState);
   bResult = bResult && (eRestrictedDlMode == roRef.eRestrictedDlMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgDownloadLockStateMethodResult::spm_corefi_tclMsgDownloadLockStateMethodResult(const spm_corefi_tclMsgDownloadLockStateMethodResult& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   s32ReturnVal = coRef.s32ReturnVal;
}
spm_corefi_tclMsgDownloadLockStateMethodResult& spm_corefi_tclMsgDownloadLockStateMethodResult::operator=(const spm_corefi_tclMsgDownloadLockStateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   s32ReturnVal = coRef.s32ReturnVal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgDownloadLockStateMethodResult::spm_corefi_tclMsgDownloadLockStateMethodResult()
:s32ReturnVal(0)
 {}

tS32 spm_corefi_tclMsgDownloadLockStateMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DOWNLOADLOCKSTATEMETHODRESULT;
}


spm_corefi_tclMsgDownloadLockStateMethodResult::~spm_corefi_tclMsgDownloadLockStateMethodResult()
{}

tU32 spm_corefi_tclMsgDownloadLockStateMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgDownloadLockStateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32ReturnVal);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgDownloadLockStateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32ReturnVal);
   return oOut;
}

tBool spm_corefi_tclMsgDownloadLockStateMethodResult::operator==(const spm_corefi_tclMsgDownloadLockStateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32ReturnVal == roRef.s32ReturnVal);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgUpdateLockMethodStart::spm_corefi_tclMsgUpdateLockMethodStart(const spm_corefi_tclMsgUpdateLockMethodStart& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   strLockName = coRef.strLockName;
   eLockRequest = coRef.eLockRequest;
}
spm_corefi_tclMsgUpdateLockMethodStart& spm_corefi_tclMsgUpdateLockMethodStart::operator=(const spm_corefi_tclMsgUpdateLockMethodStart& coRef)
{
   if (this == &coRef) return *this;
   strLockName = coRef.strLockName;
   eLockRequest = coRef.eLockRequest;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgUpdateLockMethodStart::vDestroy()
{
   strLockName.vDestroy();
}

spm_corefi_tclMsgUpdateLockMethodStart::spm_corefi_tclMsgUpdateLockMethodStart()
:strLockName()
,eLockRequest()
 {}

tS32 spm_corefi_tclMsgUpdateLockMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_UPDATELOCKMETHODSTART;
}


spm_corefi_tclMsgUpdateLockMethodStart::~spm_corefi_tclMsgUpdateLockMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgUpdateLockMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+strLockName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_corefi_tclMsgUpdateLockMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strLockName);
   (tVoid) (oIn >> eLockRequest);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgUpdateLockMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strLockName);
   (tVoid) (oOut << eLockRequest);
   return oOut;
}

tBool spm_corefi_tclMsgUpdateLockMethodStart::operator==(const spm_corefi_tclMsgUpdateLockMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strLockName == roRef.strLockName);
   bResult = bResult && (eLockRequest == roRef.eLockRequest);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgUpdateLockMethodResult::spm_corefi_tclMsgUpdateLockMethodResult(const spm_corefi_tclMsgUpdateLockMethodResult& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   s32ReturnVal = coRef.s32ReturnVal;
}
spm_corefi_tclMsgUpdateLockMethodResult& spm_corefi_tclMsgUpdateLockMethodResult::operator=(const spm_corefi_tclMsgUpdateLockMethodResult& coRef)
{
   if (this == &coRef) return *this;
   s32ReturnVal = coRef.s32ReturnVal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgUpdateLockMethodResult::spm_corefi_tclMsgUpdateLockMethodResult()
:s32ReturnVal(0)
 {}

tS32 spm_corefi_tclMsgUpdateLockMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_UPDATELOCKMETHODRESULT;
}


spm_corefi_tclMsgUpdateLockMethodResult::~spm_corefi_tclMsgUpdateLockMethodResult()
{}

tU32 spm_corefi_tclMsgUpdateLockMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgUpdateLockMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32ReturnVal);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgUpdateLockMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32ReturnVal);
   return oOut;
}

tBool spm_corefi_tclMsgUpdateLockMethodResult::operator==(const spm_corefi_tclMsgUpdateLockMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32ReturnVal == roRef.s32ReturnVal);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgOnOffTriggerMethodStart::spm_corefi_tclMsgOnOffTriggerMethodStart(const spm_corefi_tclMsgOnOffTriggerMethodStart& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   eSwitchOnTrigger = coRef.eSwitchOnTrigger;
   bState = coRef.bState;
}
spm_corefi_tclMsgOnOffTriggerMethodStart& spm_corefi_tclMsgOnOffTriggerMethodStart::operator=(const spm_corefi_tclMsgOnOffTriggerMethodStart& coRef)
{
   if (this == &coRef) return *this;
   eSwitchOnTrigger = coRef.eSwitchOnTrigger;
   bState = coRef.bState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgOnOffTriggerMethodStart::spm_corefi_tclMsgOnOffTriggerMethodStart()
:eSwitchOnTrigger()
,bState(0)
 {}

tS32 spm_corefi_tclMsgOnOffTriggerMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ONOFFTRIGGERMETHODSTART;
}


spm_corefi_tclMsgOnOffTriggerMethodStart::~spm_corefi_tclMsgOnOffTriggerMethodStart()
{}

tU32 spm_corefi_tclMsgOnOffTriggerMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& spm_corefi_tclMsgOnOffTriggerMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eSwitchOnTrigger);
   (tVoid) (oIn >> bState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgOnOffTriggerMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eSwitchOnTrigger);
   (tVoid) (oOut << bState);
   return oOut;
}

tBool spm_corefi_tclMsgOnOffTriggerMethodStart::operator==(const spm_corefi_tclMsgOnOffTriggerMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eSwitchOnTrigger == roRef.eSwitchOnTrigger);
   bResult = bResult && (bState == roRef.bState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgOnOffTriggerMethodResult::spm_corefi_tclMsgOnOffTriggerMethodResult()
 {}

tS32 spm_corefi_tclMsgOnOffTriggerMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ONOFFTRIGGERMETHODRESULT;
}


spm_corefi_tclMsgOnOffTriggerMethodResult::~spm_corefi_tclMsgOnOffTriggerMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgStartProcessMethodStart::spm_corefi_tclMsgStartProcessMethodStart(const spm_corefi_tclMsgStartProcessMethodStart& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   strLocation = coRef.strLocation;
   u32Prio = coRef.u32Prio;
   u32Affinity = coRef.u32Affinity;
   u32AffinityEnd = coRef.u32AffinityEnd;
   u32NiceLevel = coRef.u32NiceLevel;
   u32NiceLevelEnd = coRef.u32NiceLevelEnd;
   u32Type = coRef.u32Type;
   u32Info = coRef.u32Info;
}
spm_corefi_tclMsgStartProcessMethodStart& spm_corefi_tclMsgStartProcessMethodStart::operator=(const spm_corefi_tclMsgStartProcessMethodStart& coRef)
{
   if (this == &coRef) return *this;
   strLocation = coRef.strLocation;
   u32Prio = coRef.u32Prio;
   u32Affinity = coRef.u32Affinity;
   u32AffinityEnd = coRef.u32AffinityEnd;
   u32NiceLevel = coRef.u32NiceLevel;
   u32NiceLevelEnd = coRef.u32NiceLevelEnd;
   u32Type = coRef.u32Type;
   u32Info = coRef.u32Info;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgStartProcessMethodStart::vDestroy()
{
   strLocation.vDestroy();
}

spm_corefi_tclMsgStartProcessMethodStart::spm_corefi_tclMsgStartProcessMethodStart()
:strLocation()
,u32Prio(0)
,u32Affinity(0)
,u32AffinityEnd(0)
,u32NiceLevel(0)
,u32NiceLevelEnd(0)
,u32Type()
,u32Info(0)
 {}

tS32 spm_corefi_tclMsgStartProcessMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_STARTPROCESSMETHODSTART;
}


spm_corefi_tclMsgStartProcessMethodStart::~spm_corefi_tclMsgStartProcessMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgStartProcessMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 28+strLocation.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_corefi_tclMsgStartProcessMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strLocation);
   (tVoid) (oIn >> u32Prio);
   (tVoid) (oIn >> u32Affinity);
   (tVoid) (oIn >> u32AffinityEnd);
   (tVoid) (oIn >> u32NiceLevel);
   (tVoid) (oIn >> u32NiceLevelEnd);
   (tVoid) (oIn >> u32Type);
   (tVoid) (oIn >> u32Info);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgStartProcessMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strLocation);
   (tVoid) (oOut << u32Prio);
   (tVoid) (oOut << u32Affinity);
   (tVoid) (oOut << u32AffinityEnd);
   (tVoid) (oOut << u32NiceLevel);
   (tVoid) (oOut << u32NiceLevelEnd);
   (tVoid) (oOut << u32Type);
   (tVoid) (oOut << u32Info);
   return oOut;
}

tBool spm_corefi_tclMsgStartProcessMethodStart::operator==(const spm_corefi_tclMsgStartProcessMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strLocation == roRef.strLocation);
   bResult = bResult && (u32Prio == roRef.u32Prio);
   bResult = bResult && (u32Affinity == roRef.u32Affinity);
   bResult = bResult && (u32AffinityEnd == roRef.u32AffinityEnd);
   bResult = bResult && (u32NiceLevel == roRef.u32NiceLevel);
   bResult = bResult && (u32NiceLevelEnd == roRef.u32NiceLevelEnd);
   bResult = bResult && (u32Type == roRef.u32Type);
   bResult = bResult && (u32Info == roRef.u32Info);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgStartProcessMethodResult::spm_corefi_tclMsgStartProcessMethodResult(const spm_corefi_tclMsgStartProcessMethodResult& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   s32ReturnVal = coRef.s32ReturnVal;
   strLocation = coRef.strLocation;
   u32ProcId = coRef.u32ProcId;
   u32SpawnDuration = coRef.u32SpawnDuration;
}
spm_corefi_tclMsgStartProcessMethodResult& spm_corefi_tclMsgStartProcessMethodResult::operator=(const spm_corefi_tclMsgStartProcessMethodResult& coRef)
{
   if (this == &coRef) return *this;
   s32ReturnVal = coRef.s32ReturnVal;
   strLocation = coRef.strLocation;
   u32ProcId = coRef.u32ProcId;
   u32SpawnDuration = coRef.u32SpawnDuration;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgStartProcessMethodResult::vDestroy()
{
   strLocation.vDestroy();
}

spm_corefi_tclMsgStartProcessMethodResult::spm_corefi_tclMsgStartProcessMethodResult()
:s32ReturnVal(0)
,strLocation()
,u32ProcId(0)
,u32SpawnDuration(0)
 {}

tS32 spm_corefi_tclMsgStartProcessMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_STARTPROCESSMETHODRESULT;
}


spm_corefi_tclMsgStartProcessMethodResult::~spm_corefi_tclMsgStartProcessMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgStartProcessMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 12+strLocation.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_corefi_tclMsgStartProcessMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32ReturnVal);
   (tVoid) (oIn >> strLocation);
   (tVoid) (oIn >> u32ProcId);
   (tVoid) (oIn >> u32SpawnDuration);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgStartProcessMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32ReturnVal);
   (tVoid) (oOut << strLocation);
   (tVoid) (oOut << u32ProcId);
   (tVoid) (oOut << u32SpawnDuration);
   return oOut;
}

tBool spm_corefi_tclMsgStartProcessMethodResult::operator==(const spm_corefi_tclMsgStartProcessMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32ReturnVal == roRef.s32ReturnVal);
   bResult = bResult && (strLocation == roRef.strLocation);
   bResult = bResult && (u32ProcId == roRef.u32ProcId);
   bResult = bResult && (u32SpawnDuration == roRef.u32SpawnDuration);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgStopProcessMethodStart::spm_corefi_tclMsgStopProcessMethodStart(const spm_corefi_tclMsgStopProcessMethodStart& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   strLocation = coRef.strLocation;
   u32ProcId = coRef.u32ProcId;
}
spm_corefi_tclMsgStopProcessMethodStart& spm_corefi_tclMsgStopProcessMethodStart::operator=(const spm_corefi_tclMsgStopProcessMethodStart& coRef)
{
   if (this == &coRef) return *this;
   strLocation = coRef.strLocation;
   u32ProcId = coRef.u32ProcId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgStopProcessMethodStart::vDestroy()
{
   strLocation.vDestroy();
}

spm_corefi_tclMsgStopProcessMethodStart::spm_corefi_tclMsgStopProcessMethodStart()
:strLocation()
,u32ProcId(0)
 {}

tS32 spm_corefi_tclMsgStopProcessMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_STOPPROCESSMETHODSTART;
}


spm_corefi_tclMsgStopProcessMethodStart::~spm_corefi_tclMsgStopProcessMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgStopProcessMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+strLocation.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_corefi_tclMsgStopProcessMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strLocation);
   (tVoid) (oIn >> u32ProcId);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgStopProcessMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strLocation);
   (tVoid) (oOut << u32ProcId);
   return oOut;
}

tBool spm_corefi_tclMsgStopProcessMethodStart::operator==(const spm_corefi_tclMsgStopProcessMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strLocation == roRef.strLocation);
   bResult = bResult && (u32ProcId == roRef.u32ProcId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgStopProcessMethodResult::spm_corefi_tclMsgStopProcessMethodResult(const spm_corefi_tclMsgStopProcessMethodResult& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   s32ReturnVal = coRef.s32ReturnVal;
}
spm_corefi_tclMsgStopProcessMethodResult& spm_corefi_tclMsgStopProcessMethodResult::operator=(const spm_corefi_tclMsgStopProcessMethodResult& coRef)
{
   if (this == &coRef) return *this;
   s32ReturnVal = coRef.s32ReturnVal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgStopProcessMethodResult::spm_corefi_tclMsgStopProcessMethodResult()
:s32ReturnVal(0)
 {}

tS32 spm_corefi_tclMsgStopProcessMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_STOPPROCESSMETHODRESULT;
}


spm_corefi_tclMsgStopProcessMethodResult::~spm_corefi_tclMsgStopProcessMethodResult()
{}

tU32 spm_corefi_tclMsgStopProcessMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgStopProcessMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32ReturnVal);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgStopProcessMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32ReturnVal);
   return oOut;
}

tBool spm_corefi_tclMsgStopProcessMethodResult::operator==(const spm_corefi_tclMsgStopProcessMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32ReturnVal == roRef.s32ReturnVal);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgRestartProcessMethodStart::spm_corefi_tclMsgRestartProcessMethodStart(const spm_corefi_tclMsgRestartProcessMethodStart& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   strLocation = coRef.strLocation;
   u32ProcId = coRef.u32ProcId;
}
spm_corefi_tclMsgRestartProcessMethodStart& spm_corefi_tclMsgRestartProcessMethodStart::operator=(const spm_corefi_tclMsgRestartProcessMethodStart& coRef)
{
   if (this == &coRef) return *this;
   strLocation = coRef.strLocation;
   u32ProcId = coRef.u32ProcId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgRestartProcessMethodStart::vDestroy()
{
   strLocation.vDestroy();
}

spm_corefi_tclMsgRestartProcessMethodStart::spm_corefi_tclMsgRestartProcessMethodStart()
:strLocation()
,u32ProcId(0)
 {}

tS32 spm_corefi_tclMsgRestartProcessMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RESTARTPROCESSMETHODSTART;
}


spm_corefi_tclMsgRestartProcessMethodStart::~spm_corefi_tclMsgRestartProcessMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgRestartProcessMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+strLocation.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_corefi_tclMsgRestartProcessMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strLocation);
   (tVoid) (oIn >> u32ProcId);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgRestartProcessMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strLocation);
   (tVoid) (oOut << u32ProcId);
   return oOut;
}

tBool spm_corefi_tclMsgRestartProcessMethodStart::operator==(const spm_corefi_tclMsgRestartProcessMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strLocation == roRef.strLocation);
   bResult = bResult && (u32ProcId == roRef.u32ProcId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgRestartProcessMethodResult::spm_corefi_tclMsgRestartProcessMethodResult(const spm_corefi_tclMsgRestartProcessMethodResult& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   s32ReturnVal = coRef.s32ReturnVal;
}
spm_corefi_tclMsgRestartProcessMethodResult& spm_corefi_tclMsgRestartProcessMethodResult::operator=(const spm_corefi_tclMsgRestartProcessMethodResult& coRef)
{
   if (this == &coRef) return *this;
   s32ReturnVal = coRef.s32ReturnVal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgRestartProcessMethodResult::spm_corefi_tclMsgRestartProcessMethodResult()
:s32ReturnVal(0)
 {}

tS32 spm_corefi_tclMsgRestartProcessMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RESTARTPROCESSMETHODRESULT;
}


spm_corefi_tclMsgRestartProcessMethodResult::~spm_corefi_tclMsgRestartProcessMethodResult()
{}

tU32 spm_corefi_tclMsgRestartProcessMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgRestartProcessMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32ReturnVal);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgRestartProcessMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32ReturnVal);
   return oOut;
}

tBool spm_corefi_tclMsgRestartProcessMethodResult::operator==(const spm_corefi_tclMsgRestartProcessMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32ReturnVal == roRef.s32ReturnVal);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgStartUpSyncPointReachedMethodStart::spm_corefi_tclMsgStartUpSyncPointReachedMethodStart(const spm_corefi_tclMsgStartUpSyncPointReachedMethodStart& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   strNewSyncPoint = coRef.strNewSyncPoint;
}
spm_corefi_tclMsgStartUpSyncPointReachedMethodStart& spm_corefi_tclMsgStartUpSyncPointReachedMethodStart::operator=(const spm_corefi_tclMsgStartUpSyncPointReachedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   strNewSyncPoint = coRef.strNewSyncPoint;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgStartUpSyncPointReachedMethodStart::vDestroy()
{
   strNewSyncPoint.vDestroy();
}

spm_corefi_tclMsgStartUpSyncPointReachedMethodStart::spm_corefi_tclMsgStartUpSyncPointReachedMethodStart()
:strNewSyncPoint()
 {}

tS32 spm_corefi_tclMsgStartUpSyncPointReachedMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_STARTUPSYNCPOINTREACHEDMETHODSTART;
}


spm_corefi_tclMsgStartUpSyncPointReachedMethodStart::~spm_corefi_tclMsgStartUpSyncPointReachedMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgStartUpSyncPointReachedMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+strNewSyncPoint.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_corefi_tclMsgStartUpSyncPointReachedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> strNewSyncPoint);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgStartUpSyncPointReachedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << strNewSyncPoint);
   return oOut;
}

tBool spm_corefi_tclMsgStartUpSyncPointReachedMethodStart::operator==(const spm_corefi_tclMsgStartUpSyncPointReachedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (strNewSyncPoint == roRef.strNewSyncPoint);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgStartUpSyncPointReachedMethodResult::spm_corefi_tclMsgStartUpSyncPointReachedMethodResult()
 {}

tS32 spm_corefi_tclMsgStartUpSyncPointReachedMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_STARTUPSYNCPOINTREACHEDMETHODRESULT;
}


spm_corefi_tclMsgStartUpSyncPointReachedMethodResult::~spm_corefi_tclMsgStartUpSyncPointReachedMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgClearListMethodStart::spm_corefi_tclMsgClearListMethodStart(const spm_corefi_tclMsgClearListMethodStart& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   eList2Clear = coRef.eList2Clear;
}
spm_corefi_tclMsgClearListMethodStart& spm_corefi_tclMsgClearListMethodStart::operator=(const spm_corefi_tclMsgClearListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   eList2Clear = coRef.eList2Clear;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgClearListMethodStart::spm_corefi_tclMsgClearListMethodStart()
:eList2Clear()
 {}

tS32 spm_corefi_tclMsgClearListMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CLEARLISTMETHODSTART;
}


spm_corefi_tclMsgClearListMethodStart::~spm_corefi_tclMsgClearListMethodStart()
{}

tU32 spm_corefi_tclMsgClearListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgClearListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eList2Clear);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgClearListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eList2Clear);
   return oOut;
}

tBool spm_corefi_tclMsgClearListMethodStart::operator==(const spm_corefi_tclMsgClearListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eList2Clear == roRef.eList2Clear);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgClearListMethodResult::spm_corefi_tclMsgClearListMethodResult()
 {}

tS32 spm_corefi_tclMsgClearListMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CLEARLISTMETHODRESULT;
}


spm_corefi_tclMsgClearListMethodResult::~spm_corefi_tclMsgClearListMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart::spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart(const spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   u32Index = coRef.u32Index;
}
spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart& spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart::operator=(const spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32Index = coRef.u32Index;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart::spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart()
:u32Index(0)
 {}

tS32 spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SPECIFICSWVERSIONSTATISTICMETHODSTART;
}


spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart::~spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart()
{}

tU32 spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Index);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Index);
   return oOut;
}

tBool spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart::operator==(const spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Index == roRef.u32Index);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult::spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult(const spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   tSWVersionStatistic = coRef.tSWVersionStatistic;
}
spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult& spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult::operator=(const spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult& coRef)
{
   if (this == &coRef) return *this;
   tSWVersionStatistic = coRef.tSWVersionStatistic;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult::vDestroy()
{
   tSWVersionStatistic.vDestroy(); 
}

spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult::spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult()
:tSWVersionStatistic()
 {}

tS32 spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SPECIFICSWVERSIONSTATISTICMETHODRESULT;
}


spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult::~spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+tSWVersionStatistic.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tSWVersionStatistic);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tSWVersionStatistic);
   return oOut;
}

tBool spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult::operator==(const spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tSWVersionStatistic == roRef.tSWVersionStatistic);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgRestartSystemMethodStart::spm_corefi_tclMsgRestartSystemMethodStart(const spm_corefi_tclMsgRestartSystemMethodStart& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   eRestartType = coRef.eRestartType;
}
spm_corefi_tclMsgRestartSystemMethodStart& spm_corefi_tclMsgRestartSystemMethodStart::operator=(const spm_corefi_tclMsgRestartSystemMethodStart& coRef)
{
   if (this == &coRef) return *this;
   eRestartType = coRef.eRestartType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgRestartSystemMethodStart::spm_corefi_tclMsgRestartSystemMethodStart()
:eRestartType()
 {}

tS32 spm_corefi_tclMsgRestartSystemMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RESTARTSYSTEMMETHODSTART;
}


spm_corefi_tclMsgRestartSystemMethodStart::~spm_corefi_tclMsgRestartSystemMethodStart()
{}

tU32 spm_corefi_tclMsgRestartSystemMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgRestartSystemMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eRestartType);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgRestartSystemMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eRestartType);
   return oOut;
}

tBool spm_corefi_tclMsgRestartSystemMethodStart::operator==(const spm_corefi_tclMsgRestartSystemMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eRestartType == roRef.eRestartType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgRestartSystemMethodResult::spm_corefi_tclMsgRestartSystemMethodResult(const spm_corefi_tclMsgRestartSystemMethodResult& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   e32ReturnVal = coRef.e32ReturnVal;
}
spm_corefi_tclMsgRestartSystemMethodResult& spm_corefi_tclMsgRestartSystemMethodResult::operator=(const spm_corefi_tclMsgRestartSystemMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e32ReturnVal = coRef.e32ReturnVal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgRestartSystemMethodResult::spm_corefi_tclMsgRestartSystemMethodResult()
:e32ReturnVal()
 {}

tS32 spm_corefi_tclMsgRestartSystemMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RESTARTSYSTEMMETHODRESULT;
}


spm_corefi_tclMsgRestartSystemMethodResult::~spm_corefi_tclMsgRestartSystemMethodResult()
{}

tU32 spm_corefi_tclMsgRestartSystemMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgRestartSystemMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e32ReturnVal);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgRestartSystemMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e32ReturnVal);
   return oOut;
}

tBool spm_corefi_tclMsgRestartSystemMethodResult::operator==(const spm_corefi_tclMsgRestartSystemMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e32ReturnVal == roRef.e32ReturnVal);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgAudioSourceChangeMethodStart::spm_corefi_tclMsgAudioSourceChangeMethodStart(const spm_corefi_tclMsgAudioSourceChangeMethodStart& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   eAudioSrc = coRef.eAudioSrc;
}
spm_corefi_tclMsgAudioSourceChangeMethodStart& spm_corefi_tclMsgAudioSourceChangeMethodStart::operator=(const spm_corefi_tclMsgAudioSourceChangeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   eAudioSrc = coRef.eAudioSrc;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgAudioSourceChangeMethodStart::spm_corefi_tclMsgAudioSourceChangeMethodStart()
:eAudioSrc()
 {}

tS32 spm_corefi_tclMsgAudioSourceChangeMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_AUDIOSOURCECHANGEMETHODSTART;
}


spm_corefi_tclMsgAudioSourceChangeMethodStart::~spm_corefi_tclMsgAudioSourceChangeMethodStart()
{}

tU32 spm_corefi_tclMsgAudioSourceChangeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgAudioSourceChangeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eAudioSrc);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgAudioSourceChangeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eAudioSrc);
   return oOut;
}

tBool spm_corefi_tclMsgAudioSourceChangeMethodStart::operator==(const spm_corefi_tclMsgAudioSourceChangeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eAudioSrc == roRef.eAudioSrc);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgAudioSourceChangeMethodResult::spm_corefi_tclMsgAudioSourceChangeMethodResult()
 {}

tS32 spm_corefi_tclMsgAudioSourceChangeMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_AUDIOSOURCECHANGEMETHODRESULT;
}


spm_corefi_tclMsgAudioSourceChangeMethodResult::~spm_corefi_tclMsgAudioSourceChangeMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgChangeBluetoothStateMethodStart::spm_corefi_tclMsgChangeBluetoothStateMethodStart(const spm_corefi_tclMsgChangeBluetoothStateMethodStart& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   BtState = coRef.BtState;
}
spm_corefi_tclMsgChangeBluetoothStateMethodStart& spm_corefi_tclMsgChangeBluetoothStateMethodStart::operator=(const spm_corefi_tclMsgChangeBluetoothStateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   BtState = coRef.BtState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgChangeBluetoothStateMethodStart::spm_corefi_tclMsgChangeBluetoothStateMethodStart()
:BtState()
 {}

tS32 spm_corefi_tclMsgChangeBluetoothStateMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CHANGEBLUETOOTHSTATEMETHODSTART;
}


spm_corefi_tclMsgChangeBluetoothStateMethodStart::~spm_corefi_tclMsgChangeBluetoothStateMethodStart()
{}

tU32 spm_corefi_tclMsgChangeBluetoothStateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgChangeBluetoothStateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BtState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgChangeBluetoothStateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BtState);
   return oOut;
}

tBool spm_corefi_tclMsgChangeBluetoothStateMethodStart::operator==(const spm_corefi_tclMsgChangeBluetoothStateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BtState == roRef.BtState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgChangeBluetoothStateMethodResult::spm_corefi_tclMsgChangeBluetoothStateMethodResult()
 {}

tS32 spm_corefi_tclMsgChangeBluetoothStateMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CHANGEBLUETOOTHSTATEMETHODRESULT;
}


spm_corefi_tclMsgChangeBluetoothStateMethodResult::~spm_corefi_tclMsgChangeBluetoothStateMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgChangeAudioStateMethodStart::spm_corefi_tclMsgChangeAudioStateMethodStart(const spm_corefi_tclMsgChangeAudioStateMethodStart& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   AudioState = coRef.AudioState;
}
spm_corefi_tclMsgChangeAudioStateMethodStart& spm_corefi_tclMsgChangeAudioStateMethodStart::operator=(const spm_corefi_tclMsgChangeAudioStateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   AudioState = coRef.AudioState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgChangeAudioStateMethodStart::spm_corefi_tclMsgChangeAudioStateMethodStart()
:AudioState()
 {}

tS32 spm_corefi_tclMsgChangeAudioStateMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CHANGEAUDIOSTATEMETHODSTART;
}


spm_corefi_tclMsgChangeAudioStateMethodStart::~spm_corefi_tclMsgChangeAudioStateMethodStart()
{}

tU32 spm_corefi_tclMsgChangeAudioStateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgChangeAudioStateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AudioState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgChangeAudioStateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AudioState);
   return oOut;
}

tBool spm_corefi_tclMsgChangeAudioStateMethodStart::operator==(const spm_corefi_tclMsgChangeAudioStateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AudioState == roRef.AudioState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgChangeAudioStateMethodResult::spm_corefi_tclMsgChangeAudioStateMethodResult()
 {}

tS32 spm_corefi_tclMsgChangeAudioStateMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CHANGEAUDIOSTATEMETHODRESULT;
}


spm_corefi_tclMsgChangeAudioStateMethodResult::~spm_corefi_tclMsgChangeAudioStateMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgChangeSpiStateMethodStart::spm_corefi_tclMsgChangeSpiStateMethodStart(const spm_corefi_tclMsgChangeSpiStateMethodStart& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   SpiState = coRef.SpiState;
}
spm_corefi_tclMsgChangeSpiStateMethodStart& spm_corefi_tclMsgChangeSpiStateMethodStart::operator=(const spm_corefi_tclMsgChangeSpiStateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SpiState = coRef.SpiState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgChangeSpiStateMethodStart::spm_corefi_tclMsgChangeSpiStateMethodStart()
:SpiState()
 {}

tS32 spm_corefi_tclMsgChangeSpiStateMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CHANGESPISTATEMETHODSTART;
}


spm_corefi_tclMsgChangeSpiStateMethodStart::~spm_corefi_tclMsgChangeSpiStateMethodStart()
{}

tU32 spm_corefi_tclMsgChangeSpiStateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgChangeSpiStateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SpiState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgChangeSpiStateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SpiState);
   return oOut;
}

tBool spm_corefi_tclMsgChangeSpiStateMethodStart::operator==(const spm_corefi_tclMsgChangeSpiStateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SpiState == roRef.SpiState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgChangeSpiStateMethodResult::spm_corefi_tclMsgChangeSpiStateMethodResult()
 {}

tS32 spm_corefi_tclMsgChangeSpiStateMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CHANGESPISTATEMETHODRESULT;
}


spm_corefi_tclMsgChangeSpiStateMethodResult::~spm_corefi_tclMsgChangeSpiStateMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgChangeTunerStateMethodStart::spm_corefi_tclMsgChangeTunerStateMethodStart(const spm_corefi_tclMsgChangeTunerStateMethodStart& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   TunerState = coRef.TunerState;
}
spm_corefi_tclMsgChangeTunerStateMethodStart& spm_corefi_tclMsgChangeTunerStateMethodStart::operator=(const spm_corefi_tclMsgChangeTunerStateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TunerState = coRef.TunerState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgChangeTunerStateMethodStart::spm_corefi_tclMsgChangeTunerStateMethodStart()
:TunerState()
 {}

tS32 spm_corefi_tclMsgChangeTunerStateMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CHANGETUNERSTATEMETHODSTART;
}


spm_corefi_tclMsgChangeTunerStateMethodStart::~spm_corefi_tclMsgChangeTunerStateMethodStart()
{}

tU32 spm_corefi_tclMsgChangeTunerStateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgChangeTunerStateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgChangeTunerStateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerState);
   return oOut;
}

tBool spm_corefi_tclMsgChangeTunerStateMethodStart::operator==(const spm_corefi_tclMsgChangeTunerStateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerState == roRef.TunerState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgChangeTunerStateMethodResult::spm_corefi_tclMsgChangeTunerStateMethodResult()
 {}

tS32 spm_corefi_tclMsgChangeTunerStateMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CHANGETUNERSTATEMETHODRESULT;
}


spm_corefi_tclMsgChangeTunerStateMethodResult::~spm_corefi_tclMsgChangeTunerStateMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgChangeWifiStateMethodStart::spm_corefi_tclMsgChangeWifiStateMethodStart(const spm_corefi_tclMsgChangeWifiStateMethodStart& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   WiFiState = coRef.WiFiState;
}
spm_corefi_tclMsgChangeWifiStateMethodStart& spm_corefi_tclMsgChangeWifiStateMethodStart::operator=(const spm_corefi_tclMsgChangeWifiStateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   WiFiState = coRef.WiFiState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgChangeWifiStateMethodStart::spm_corefi_tclMsgChangeWifiStateMethodStart()
:WiFiState()
 {}

tS32 spm_corefi_tclMsgChangeWifiStateMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CHANGEWIFISTATEMETHODSTART;
}


spm_corefi_tclMsgChangeWifiStateMethodStart::~spm_corefi_tclMsgChangeWifiStateMethodStart()
{}

tU32 spm_corefi_tclMsgChangeWifiStateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgChangeWifiStateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> WiFiState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgChangeWifiStateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << WiFiState);
   return oOut;
}

tBool spm_corefi_tclMsgChangeWifiStateMethodStart::operator==(const spm_corefi_tclMsgChangeWifiStateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (WiFiState == roRef.WiFiState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgChangeWifiStateMethodResult::spm_corefi_tclMsgChangeWifiStateMethodResult()
 {}

tS32 spm_corefi_tclMsgChangeWifiStateMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CHANGEWIFISTATEMETHODRESULT;
}


spm_corefi_tclMsgChangeWifiStateMethodResult::~spm_corefi_tclMsgChangeWifiStateMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart::spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart(const spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   tAppIdList = coRef.tAppIdList;
}
spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart& spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart::operator=(const spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   tAppIdList = coRef.tAppIdList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart::vDestroy()
{
   tAppIdList.vDestroy(); 
}

spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart::spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart()
:tAppIdList()
 {}

tS32 spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SHUTDOWNANDTERMINATECCAAPPSMETHODSTART;
}


spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart::~spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+tAppIdList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tAppIdList);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tAppIdList);
   return oOut;
}

tBool spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart::operator==(const spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tAppIdList == roRef.tAppIdList);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodResult::spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodResult()
 {}

tS32 spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SHUTDOWNANDTERMINATECCAAPPSMETHODRESULT;
}


spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodResult::~spm_corefi_tclMsgShutdownAndTerminateCcaAppsMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSetFactorySettingsNewMethodStart::spm_corefi_tclMsgSetFactorySettingsNewMethodStart(const spm_corefi_tclMsgSetFactorySettingsNewMethodStart& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
}
spm_corefi_tclMsgSetFactorySettingsNewMethodStart& spm_corefi_tclMsgSetFactorySettingsNewMethodStart::operator=(const spm_corefi_tclMsgSetFactorySettingsNewMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgSetFactorySettingsNewMethodStart::spm_corefi_tclMsgSetFactorySettingsNewMethodStart()
:DefSetStateGroup()
,DefSetStateMode()
 {}

tS32 spm_corefi_tclMsgSetFactorySettingsNewMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODSTART;
}


spm_corefi_tclMsgSetFactorySettingsNewMethodStart::~spm_corefi_tclMsgSetFactorySettingsNewMethodStart()
{}

tU32 spm_corefi_tclMsgSetFactorySettingsNewMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& spm_corefi_tclMsgSetFactorySettingsNewMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetStateMode);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSetFactorySettingsNewMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetStateMode);
   return oOut;
}

tBool spm_corefi_tclMsgSetFactorySettingsNewMethodStart::operator==(const spm_corefi_tclMsgSetFactorySettingsNewMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetStateMode == roRef.DefSetStateMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSetFactorySettingsNewMethodResult::spm_corefi_tclMsgSetFactorySettingsNewMethodResult(const spm_corefi_tclMsgSetFactorySettingsNewMethodResult& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   DefSetStateSuccessful = coRef.DefSetStateSuccessful;
   DefSetStateFirstDifferentParameterId = coRef.DefSetStateFirstDifferentParameterId;
}
spm_corefi_tclMsgSetFactorySettingsNewMethodResult& spm_corefi_tclMsgSetFactorySettingsNewMethodResult::operator=(const spm_corefi_tclMsgSetFactorySettingsNewMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   DefSetStateSuccessful = coRef.DefSetStateSuccessful;
   DefSetStateFirstDifferentParameterId = coRef.DefSetStateFirstDifferentParameterId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgSetFactorySettingsNewMethodResult::spm_corefi_tclMsgSetFactorySettingsNewMethodResult()
:DefSetStateGroup()
,DefSetStateMode()
,DefSetStateSuccessful(0)
,DefSetStateFirstDifferentParameterId(0)
 {}

tS32 spm_corefi_tclMsgSetFactorySettingsNewMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODRESULT;
}


spm_corefi_tclMsgSetFactorySettingsNewMethodResult::~spm_corefi_tclMsgSetFactorySettingsNewMethodResult()
{}

tU32 spm_corefi_tclMsgSetFactorySettingsNewMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& spm_corefi_tclMsgSetFactorySettingsNewMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetStateMode);
   (tVoid) (oIn >> DefSetStateSuccessful);
   (tVoid) (oIn >> DefSetStateFirstDifferentParameterId);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSetFactorySettingsNewMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetStateMode);
   (tVoid) (oOut << DefSetStateSuccessful);
   (tVoid) (oOut << DefSetStateFirstDifferentParameterId);
   return oOut;
}

tBool spm_corefi_tclMsgSetFactorySettingsNewMethodResult::operator==(const spm_corefi_tclMsgSetFactorySettingsNewMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetStateMode == roRef.DefSetStateMode);
   bResult = bResult && (DefSetStateSuccessful == roRef.DefSetStateSuccessful);
   bResult = bResult && (DefSetStateFirstDifferentParameterId == roRef.DefSetStateFirstDifferentParameterId);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgClearVINMethodStart::spm_corefi_tclMsgClearVINMethodStart()
 {}

tS32 spm_corefi_tclMsgClearVINMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CLEARVINMETHODSTART;
}


spm_corefi_tclMsgClearVINMethodStart::~spm_corefi_tclMsgClearVINMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgClearVINMethodResult::spm_corefi_tclMsgClearVINMethodResult(const spm_corefi_tclMsgClearVINMethodResult& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
spm_corefi_tclMsgClearVINMethodResult& spm_corefi_tclMsgClearVINMethodResult::operator=(const spm_corefi_tclMsgClearVINMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgClearVINMethodResult::spm_corefi_tclMsgClearVINMethodResult()
:Result(0)
 {}

tS32 spm_corefi_tclMsgClearVINMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CLEARVINMETHODRESULT;
}


spm_corefi_tclMsgClearVINMethodResult::~spm_corefi_tclMsgClearVINMethodResult()
{}

tU32 spm_corefi_tclMsgClearVINMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgClearVINMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgClearVINMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool spm_corefi_tclMsgClearVINMethodResult::operator==(const spm_corefi_tclMsgClearVINMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgPrepareDownloadMethodStart::spm_corefi_tclMsgPrepareDownloadMethodStart(const spm_corefi_tclMsgPrepareDownloadMethodStart& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   Configuration = coRef.Configuration;
   SuspendBusShutdown = coRef.SuspendBusShutdown;
   Timeout = coRef.Timeout;
}
spm_corefi_tclMsgPrepareDownloadMethodStart& spm_corefi_tclMsgPrepareDownloadMethodStart::operator=(const spm_corefi_tclMsgPrepareDownloadMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Configuration = coRef.Configuration;
   SuspendBusShutdown = coRef.SuspendBusShutdown;
   Timeout = coRef.Timeout;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgPrepareDownloadMethodStart::spm_corefi_tclMsgPrepareDownloadMethodStart()
:Configuration(0)
,SuspendBusShutdown(0)
,Timeout(0)
 {}

tS32 spm_corefi_tclMsgPrepareDownloadMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_PREPAREDOWNLOADMETHODSTART;
}


spm_corefi_tclMsgPrepareDownloadMethodStart::~spm_corefi_tclMsgPrepareDownloadMethodStart()
{}

tU32 spm_corefi_tclMsgPrepareDownloadMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& spm_corefi_tclMsgPrepareDownloadMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Configuration);
   (tVoid) (oIn >> SuspendBusShutdown);
   (tVoid) (oIn >> Timeout);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgPrepareDownloadMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Configuration);
   (tVoid) (oOut << SuspendBusShutdown);
   (tVoid) (oOut << Timeout);
   return oOut;
}

tBool spm_corefi_tclMsgPrepareDownloadMethodStart::operator==(const spm_corefi_tclMsgPrepareDownloadMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Configuration == roRef.Configuration);
   bResult = bResult && (SuspendBusShutdown == roRef.SuspendBusShutdown);
   bResult = bResult && (Timeout == roRef.Timeout);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgPrepareDownloadMethodResult::spm_corefi_tclMsgPrepareDownloadMethodResult(const spm_corefi_tclMsgPrepareDownloadMethodResult& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
spm_corefi_tclMsgPrepareDownloadMethodResult& spm_corefi_tclMsgPrepareDownloadMethodResult::operator=(const spm_corefi_tclMsgPrepareDownloadMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgPrepareDownloadMethodResult::spm_corefi_tclMsgPrepareDownloadMethodResult()
:Result(0)
 {}

tS32 spm_corefi_tclMsgPrepareDownloadMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_PREPAREDOWNLOADMETHODRESULT;
}


spm_corefi_tclMsgPrepareDownloadMethodResult::~spm_corefi_tclMsgPrepareDownloadMethodResult()
{}

tU32 spm_corefi_tclMsgPrepareDownloadMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgPrepareDownloadMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgPrepareDownloadMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool spm_corefi_tclMsgPrepareDownloadMethodResult::operator==(const spm_corefi_tclMsgPrepareDownloadMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgEndDownloadMethodStart::spm_corefi_tclMsgEndDownloadMethodStart()
 {}

tS32 spm_corefi_tclMsgEndDownloadMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ENDDOWNLOADMETHODSTART;
}


spm_corefi_tclMsgEndDownloadMethodStart::~spm_corefi_tclMsgEndDownloadMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgEndDownloadMethodResult::spm_corefi_tclMsgEndDownloadMethodResult(const spm_corefi_tclMsgEndDownloadMethodResult& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
spm_corefi_tclMsgEndDownloadMethodResult& spm_corefi_tclMsgEndDownloadMethodResult::operator=(const spm_corefi_tclMsgEndDownloadMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgEndDownloadMethodResult::spm_corefi_tclMsgEndDownloadMethodResult()
:Result(0)
 {}

tS32 spm_corefi_tclMsgEndDownloadMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ENDDOWNLOADMETHODRESULT;
}


spm_corefi_tclMsgEndDownloadMethodResult::~spm_corefi_tclMsgEndDownloadMethodResult()
{}

tU32 spm_corefi_tclMsgEndDownloadMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgEndDownloadMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgEndDownloadMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool spm_corefi_tclMsgEndDownloadMethodResult::operator==(const spm_corefi_tclMsgEndDownloadMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSetOnConfigurationMethodStart::spm_corefi_tclMsgSetOnConfigurationMethodStart(const spm_corefi_tclMsgSetOnConfigurationMethodStart& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   Configuration = coRef.Configuration;
}
spm_corefi_tclMsgSetOnConfigurationMethodStart& spm_corefi_tclMsgSetOnConfigurationMethodStart::operator=(const spm_corefi_tclMsgSetOnConfigurationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Configuration = coRef.Configuration;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgSetOnConfigurationMethodStart::spm_corefi_tclMsgSetOnConfigurationMethodStart()
:Configuration(0)
 {}

tS32 spm_corefi_tclMsgSetOnConfigurationMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SETONCONFIGURATIONMETHODSTART;
}


spm_corefi_tclMsgSetOnConfigurationMethodStart::~spm_corefi_tclMsgSetOnConfigurationMethodStart()
{}

tU32 spm_corefi_tclMsgSetOnConfigurationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgSetOnConfigurationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Configuration);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSetOnConfigurationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Configuration);
   return oOut;
}

tBool spm_corefi_tclMsgSetOnConfigurationMethodStart::operator==(const spm_corefi_tclMsgSetOnConfigurationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Configuration == roRef.Configuration);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSetOnConfigurationMethodResult::spm_corefi_tclMsgSetOnConfigurationMethodResult(const spm_corefi_tclMsgSetOnConfigurationMethodResult& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
spm_corefi_tclMsgSetOnConfigurationMethodResult& spm_corefi_tclMsgSetOnConfigurationMethodResult::operator=(const spm_corefi_tclMsgSetOnConfigurationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgSetOnConfigurationMethodResult::spm_corefi_tclMsgSetOnConfigurationMethodResult()
:Result(0)
 {}

tS32 spm_corefi_tclMsgSetOnConfigurationMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SETONCONFIGURATIONMETHODRESULT;
}


spm_corefi_tclMsgSetOnConfigurationMethodResult::~spm_corefi_tclMsgSetOnConfigurationMethodResult()
{}

tU32 spm_corefi_tclMsgSetOnConfigurationMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgSetOnConfigurationMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSetOnConfigurationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool spm_corefi_tclMsgSetOnConfigurationMethodResult::operator==(const spm_corefi_tclMsgSetOnConfigurationMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSetProcessConfigurationMethodStart::spm_corefi_tclMsgSetProcessConfigurationMethodStart(const spm_corefi_tclMsgSetProcessConfigurationMethodStart& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   Configuration = coRef.Configuration;
}
spm_corefi_tclMsgSetProcessConfigurationMethodStart& spm_corefi_tclMsgSetProcessConfigurationMethodStart::operator=(const spm_corefi_tclMsgSetProcessConfigurationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Configuration = coRef.Configuration;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgSetProcessConfigurationMethodStart::spm_corefi_tclMsgSetProcessConfigurationMethodStart()
:Configuration(0)
 {}

tS32 spm_corefi_tclMsgSetProcessConfigurationMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SETPROCESSCONFIGURATIONMETHODSTART;
}


spm_corefi_tclMsgSetProcessConfigurationMethodStart::~spm_corefi_tclMsgSetProcessConfigurationMethodStart()
{}

tU32 spm_corefi_tclMsgSetProcessConfigurationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgSetProcessConfigurationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Configuration);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSetProcessConfigurationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Configuration);
   return oOut;
}

tBool spm_corefi_tclMsgSetProcessConfigurationMethodStart::operator==(const spm_corefi_tclMsgSetProcessConfigurationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Configuration == roRef.Configuration);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSetProcessConfigurationMethodResult::spm_corefi_tclMsgSetProcessConfigurationMethodResult(const spm_corefi_tclMsgSetProcessConfigurationMethodResult& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
spm_corefi_tclMsgSetProcessConfigurationMethodResult& spm_corefi_tclMsgSetProcessConfigurationMethodResult::operator=(const spm_corefi_tclMsgSetProcessConfigurationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgSetProcessConfigurationMethodResult::spm_corefi_tclMsgSetProcessConfigurationMethodResult()
:Result(0)
 {}

tS32 spm_corefi_tclMsgSetProcessConfigurationMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SETPROCESSCONFIGURATIONMETHODRESULT;
}


spm_corefi_tclMsgSetProcessConfigurationMethodResult::~spm_corefi_tclMsgSetProcessConfigurationMethodResult()
{}

tU32 spm_corefi_tclMsgSetProcessConfigurationMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgSetProcessConfigurationMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSetProcessConfigurationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool spm_corefi_tclMsgSetProcessConfigurationMethodResult::operator==(const spm_corefi_tclMsgSetProcessConfigurationMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgEntertainDeMuteMethodStart::spm_corefi_tclMsgEntertainDeMuteMethodStart()
 {}

tS32 spm_corefi_tclMsgEntertainDeMuteMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ENTERTAINDEMUTEMETHODSTART;
}


spm_corefi_tclMsgEntertainDeMuteMethodStart::~spm_corefi_tclMsgEntertainDeMuteMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgEntertainDeMuteMethodResult::spm_corefi_tclMsgEntertainDeMuteMethodResult(const spm_corefi_tclMsgEntertainDeMuteMethodResult& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   s32ReturnVal = coRef.s32ReturnVal;
}
spm_corefi_tclMsgEntertainDeMuteMethodResult& spm_corefi_tclMsgEntertainDeMuteMethodResult::operator=(const spm_corefi_tclMsgEntertainDeMuteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   s32ReturnVal = coRef.s32ReturnVal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgEntertainDeMuteMethodResult::spm_corefi_tclMsgEntertainDeMuteMethodResult()
:s32ReturnVal(0)
 {}

tS32 spm_corefi_tclMsgEntertainDeMuteMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ENTERTAINDEMUTEMETHODRESULT;
}


spm_corefi_tclMsgEntertainDeMuteMethodResult::~spm_corefi_tclMsgEntertainDeMuteMethodResult()
{}

tU32 spm_corefi_tclMsgEntertainDeMuteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgEntertainDeMuteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32ReturnVal);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgEntertainDeMuteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32ReturnVal);
   return oOut;
}

tBool spm_corefi_tclMsgEntertainDeMuteMethodResult::operator==(const spm_corefi_tclMsgEntertainDeMuteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32ReturnVal == roRef.s32ReturnVal);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgEntertainMuteRequestMethodStart::spm_corefi_tclMsgEntertainMuteRequestMethodStart()
 {}

tS32 spm_corefi_tclMsgEntertainMuteRequestMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ENTERTAINMUTEREQUESTMETHODSTART;
}


spm_corefi_tclMsgEntertainMuteRequestMethodStart::~spm_corefi_tclMsgEntertainMuteRequestMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgEntertainMuteRequestMethodResult::spm_corefi_tclMsgEntertainMuteRequestMethodResult(const spm_corefi_tclMsgEntertainMuteRequestMethodResult& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   s32ReturnVal = coRef.s32ReturnVal;
}
spm_corefi_tclMsgEntertainMuteRequestMethodResult& spm_corefi_tclMsgEntertainMuteRequestMethodResult::operator=(const spm_corefi_tclMsgEntertainMuteRequestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   s32ReturnVal = coRef.s32ReturnVal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgEntertainMuteRequestMethodResult::spm_corefi_tclMsgEntertainMuteRequestMethodResult()
:s32ReturnVal(0)
 {}

tS32 spm_corefi_tclMsgEntertainMuteRequestMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ENTERTAINMUTEREQUESTMETHODRESULT;
}


spm_corefi_tclMsgEntertainMuteRequestMethodResult::~spm_corefi_tclMsgEntertainMuteRequestMethodResult()
{}

tU32 spm_corefi_tclMsgEntertainMuteRequestMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgEntertainMuteRequestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32ReturnVal);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgEntertainMuteRequestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32ReturnVal);
   return oOut;
}

tBool spm_corefi_tclMsgEntertainMuteRequestMethodResult::operator==(const spm_corefi_tclMsgEntertainMuteRequestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32ReturnVal == roRef.s32ReturnVal);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgWelcomeAudioActivationMethodStart::spm_corefi_tclMsgWelcomeAudioActivationMethodStart(const spm_corefi_tclMsgWelcomeAudioActivationMethodStart& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   bActivateState = coRef.bActivateState;
}
spm_corefi_tclMsgWelcomeAudioActivationMethodStart& spm_corefi_tclMsgWelcomeAudioActivationMethodStart::operator=(const spm_corefi_tclMsgWelcomeAudioActivationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bActivateState = coRef.bActivateState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgWelcomeAudioActivationMethodStart::spm_corefi_tclMsgWelcomeAudioActivationMethodStart()
:bActivateState(0)
 {}

tS32 spm_corefi_tclMsgWelcomeAudioActivationMethodStart::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_WELCOMEAUDIOACTIVATIONMETHODSTART;
}


spm_corefi_tclMsgWelcomeAudioActivationMethodStart::~spm_corefi_tclMsgWelcomeAudioActivationMethodStart()
{}

tU32 spm_corefi_tclMsgWelcomeAudioActivationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_corefi_tclMsgWelcomeAudioActivationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bActivateState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgWelcomeAudioActivationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bActivateState);
   return oOut;
}

tBool spm_corefi_tclMsgWelcomeAudioActivationMethodStart::operator==(const spm_corefi_tclMsgWelcomeAudioActivationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bActivateState == roRef.bActivateState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgWelcomeAudioActivationMethodResult::spm_corefi_tclMsgWelcomeAudioActivationMethodResult(const spm_corefi_tclMsgWelcomeAudioActivationMethodResult& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   s32ReturnVal = coRef.s32ReturnVal;
}
spm_corefi_tclMsgWelcomeAudioActivationMethodResult& spm_corefi_tclMsgWelcomeAudioActivationMethodResult::operator=(const spm_corefi_tclMsgWelcomeAudioActivationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   s32ReturnVal = coRef.s32ReturnVal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgWelcomeAudioActivationMethodResult::spm_corefi_tclMsgWelcomeAudioActivationMethodResult()
:s32ReturnVal(0)
 {}

tS32 spm_corefi_tclMsgWelcomeAudioActivationMethodResult::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_WELCOMEAUDIOACTIVATIONMETHODRESULT;
}


spm_corefi_tclMsgWelcomeAudioActivationMethodResult::~spm_corefi_tclMsgWelcomeAudioActivationMethodResult()
{}

tU32 spm_corefi_tclMsgWelcomeAudioActivationMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgWelcomeAudioActivationMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> s32ReturnVal);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgWelcomeAudioActivationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << s32ReturnVal);
   return oOut;
}

tBool spm_corefi_tclMsgWelcomeAudioActivationMethodResult::operator==(const spm_corefi_tclMsgWelcomeAudioActivationMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (s32ReturnVal == roRef.s32ReturnVal);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgSystemStateUpReg::spm_corefi_tclMsgSystemStateUpReg()
 {}

tS32 spm_corefi_tclMsgSystemStateUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SYSTEMSTATEUPREG;
}


spm_corefi_tclMsgSystemStateUpReg::~spm_corefi_tclMsgSystemStateUpReg()
{}

//=============================================================================

spm_corefi_tclMsgSystemStateRelUpReg::spm_corefi_tclMsgSystemStateRelUpReg()
 {}

tS32 spm_corefi_tclMsgSystemStateRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SYSTEMSTATERELUPREG;
}


spm_corefi_tclMsgSystemStateRelUpReg::~spm_corefi_tclMsgSystemStateRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgSystemStateGet::spm_corefi_tclMsgSystemStateGet()
 {}

tS32 spm_corefi_tclMsgSystemStateGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SYSTEMSTATEGET;
}


spm_corefi_tclMsgSystemStateGet::~spm_corefi_tclMsgSystemStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSystemStateStatus::spm_corefi_tclMsgSystemStateStatus(const spm_corefi_tclMsgSystemStateStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   SystemState = coRef.SystemState;
}
spm_corefi_tclMsgSystemStateStatus& spm_corefi_tclMsgSystemStateStatus::operator=(const spm_corefi_tclMsgSystemStateStatus& coRef)
{
   if (this == &coRef) return *this;
   SystemState = coRef.SystemState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgSystemStateStatus::spm_corefi_tclMsgSystemStateStatus()
:SystemState()
 {}

tS32 spm_corefi_tclMsgSystemStateStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SYSTEMSTATESTATUS;
}


spm_corefi_tclMsgSystemStateStatus::~spm_corefi_tclMsgSystemStateStatus()
{}

tU32 spm_corefi_tclMsgSystemStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgSystemStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SystemState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSystemStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SystemState);
   return oOut;
}

tBool spm_corefi_tclMsgSystemStateStatus::operator==(const spm_corefi_tclMsgSystemStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SystemState == roRef.SystemState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgDownloadLockStatesStatus::spm_corefi_tclMsgDownloadLockStatesStatus(const spm_corefi_tclMsgDownloadLockStatesStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   listRestrictedLock = coRef.listRestrictedLock;
}
spm_corefi_tclMsgDownloadLockStatesStatus& spm_corefi_tclMsgDownloadLockStatesStatus::operator=(const spm_corefi_tclMsgDownloadLockStatesStatus& coRef)
{
   if (this == &coRef) return *this;
   listRestrictedLock = coRef.listRestrictedLock;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgDownloadLockStatesStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < listRestrictedLock.size(); ++u32Idx)
         listRestrictedLock[u32Idx].vDestroy();
   listRestrictedLock.clear();
   }
}

spm_corefi_tclMsgDownloadLockStatesStatus::spm_corefi_tclMsgDownloadLockStatesStatus()

 {}

tS32 spm_corefi_tclMsgDownloadLockStatesStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DOWNLOADLOCKSTATESSTATUS;
}


spm_corefi_tclMsgDownloadLockStatesStatus::~spm_corefi_tclMsgDownloadLockStatesStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgDownloadLockStatesStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < listRestrictedLock.size(); ++u32ListIdx)
      u32DynamicSize += listRestrictedLock[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& spm_corefi_tclMsgDownloadLockStatesStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < listRestrictedLock.size(); ++u32Idx)
      {
         listRestrictedLock[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      listRestrictedLock.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> listRestrictedLock[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgDownloadLockStatesStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)listRestrictedLock.size());
   {
      for (tU32 u32Idx = 0; u32Idx < listRestrictedLock.size(); ++u32Idx)
         (tVoid) (oOut << listRestrictedLock[u32Idx]);
   }
   return oOut;
}

tBool spm_corefi_tclMsgDownloadLockStatesStatus::operator==(const spm_corefi_tclMsgDownloadLockStatesStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (listRestrictedLock.size() == roRef.listRestrictedLock.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < listRestrictedLock.size()); ++u32Idx)
            bResult = bResult && (listRestrictedLock[u32Idx] == roRef.listRestrictedLock[u32Idx]);
      }
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgDownloadLockStatesUpReg::spm_corefi_tclMsgDownloadLockStatesUpReg()
 {}

tS32 spm_corefi_tclMsgDownloadLockStatesUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DOWNLOADLOCKSTATESUPREG;
}


spm_corefi_tclMsgDownloadLockStatesUpReg::~spm_corefi_tclMsgDownloadLockStatesUpReg()
{}

//=============================================================================

spm_corefi_tclMsgDownloadLockStatesRelUpReg::spm_corefi_tclMsgDownloadLockStatesRelUpReg()
 {}

tS32 spm_corefi_tclMsgDownloadLockStatesRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DOWNLOADLOCKSTATESRELUPREG;
}


spm_corefi_tclMsgDownloadLockStatesRelUpReg::~spm_corefi_tclMsgDownloadLockStatesRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgDownloadLockStatesGet::spm_corefi_tclMsgDownloadLockStatesGet()
 {}

tS32 spm_corefi_tclMsgDownloadLockStatesGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DOWNLOADLOCKSTATESGET;
}


spm_corefi_tclMsgDownloadLockStatesGet::~spm_corefi_tclMsgDownloadLockStatesGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgUpdateLockStatesStatus::spm_corefi_tclMsgUpdateLockStatesStatus(const spm_corefi_tclMsgUpdateLockStatesStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   lLocks = coRef.lLocks;
}
spm_corefi_tclMsgUpdateLockStatesStatus& spm_corefi_tclMsgUpdateLockStatesStatus::operator=(const spm_corefi_tclMsgUpdateLockStatesStatus& coRef)
{
   if (this == &coRef) return *this;
   lLocks = coRef.lLocks;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgUpdateLockStatesStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < lLocks.size(); ++u32Idx)
         lLocks[u32Idx].vDestroy();
   lLocks.clear();
   }
}

spm_corefi_tclMsgUpdateLockStatesStatus::spm_corefi_tclMsgUpdateLockStatesStatus()

 {}

tS32 spm_corefi_tclMsgUpdateLockStatesStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_UPDATELOCKSTATESSTATUS;
}


spm_corefi_tclMsgUpdateLockStatesStatus::~spm_corefi_tclMsgUpdateLockStatesStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgUpdateLockStatesStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < lLocks.size(); ++u32ListIdx)
      u32DynamicSize += lLocks[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& spm_corefi_tclMsgUpdateLockStatesStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < lLocks.size(); ++u32Idx)
      {
         lLocks[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      lLocks.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> lLocks[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgUpdateLockStatesStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)lLocks.size());
   {
      for (tU32 u32Idx = 0; u32Idx < lLocks.size(); ++u32Idx)
         (tVoid) (oOut << lLocks[u32Idx]);
   }
   return oOut;
}

tBool spm_corefi_tclMsgUpdateLockStatesStatus::operator==(const spm_corefi_tclMsgUpdateLockStatesStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (lLocks.size() == roRef.lLocks.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < lLocks.size()); ++u32Idx)
            bResult = bResult && (lLocks[u32Idx] == roRef.lLocks[u32Idx]);
      }
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgUpdateLockStatesUpReg::spm_corefi_tclMsgUpdateLockStatesUpReg()
 {}

tS32 spm_corefi_tclMsgUpdateLockStatesUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_UPDATELOCKSTATESUPREG;
}


spm_corefi_tclMsgUpdateLockStatesUpReg::~spm_corefi_tclMsgUpdateLockStatesUpReg()
{}

//=============================================================================

spm_corefi_tclMsgUpdateLockStatesRelUpReg::spm_corefi_tclMsgUpdateLockStatesRelUpReg()
 {}

tS32 spm_corefi_tclMsgUpdateLockStatesRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_UPDATELOCKSTATESRELUPREG;
}


spm_corefi_tclMsgUpdateLockStatesRelUpReg::~spm_corefi_tclMsgUpdateLockStatesRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgUpdateLockStatesGet::spm_corefi_tclMsgUpdateLockStatesGet()
 {}

tS32 spm_corefi_tclMsgUpdateLockStatesGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_UPDATELOCKSTATESGET;
}


spm_corefi_tclMsgUpdateLockStatesGet::~spm_corefi_tclMsgUpdateLockStatesGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgActiveOnOffTriggerStatus::spm_corefi_tclMsgActiveOnOffTriggerStatus(const spm_corefi_tclMsgActiveOnOffTriggerStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   tOnOffTriggerList = coRef.tOnOffTriggerList;
}
spm_corefi_tclMsgActiveOnOffTriggerStatus& spm_corefi_tclMsgActiveOnOffTriggerStatus::operator=(const spm_corefi_tclMsgActiveOnOffTriggerStatus& coRef)
{
   if (this == &coRef) return *this;
   tOnOffTriggerList = coRef.tOnOffTriggerList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgActiveOnOffTriggerStatus::vDestroy()
{
   {
   tOnOffTriggerList.clear();
   }
}

spm_corefi_tclMsgActiveOnOffTriggerStatus::spm_corefi_tclMsgActiveOnOffTriggerStatus()

 {}

tS32 spm_corefi_tclMsgActiveOnOffTriggerStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ACTIVEONOFFTRIGGERSTATUS;
}


spm_corefi_tclMsgActiveOnOffTriggerStatus::~spm_corefi_tclMsgActiveOnOffTriggerStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgActiveOnOffTriggerStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(tOnOffTriggerList.size()*4);
}

fi_tclInContext& spm_corefi_tclMsgActiveOnOffTriggerStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      tOnOffTriggerList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tOnOffTriggerList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgActiveOnOffTriggerStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tOnOffTriggerList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tOnOffTriggerList.size(); ++u32Idx)
         (tVoid) (oOut << tOnOffTriggerList[u32Idx]);
   }
   return oOut;
}

tBool spm_corefi_tclMsgActiveOnOffTriggerStatus::operator==(const spm_corefi_tclMsgActiveOnOffTriggerStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tOnOffTriggerList.size() == roRef.tOnOffTriggerList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tOnOffTriggerList.size()); ++u32Idx)
            bResult = bResult && (tOnOffTriggerList[u32Idx] == roRef.tOnOffTriggerList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgActiveOnOffTriggerUpReg::spm_corefi_tclMsgActiveOnOffTriggerUpReg()
 {}

tS32 spm_corefi_tclMsgActiveOnOffTriggerUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ACTIVEONOFFTRIGGERUPREG;
}


spm_corefi_tclMsgActiveOnOffTriggerUpReg::~spm_corefi_tclMsgActiveOnOffTriggerUpReg()
{}

//=============================================================================

spm_corefi_tclMsgActiveOnOffTriggerRelUpReg::spm_corefi_tclMsgActiveOnOffTriggerRelUpReg()
 {}

tS32 spm_corefi_tclMsgActiveOnOffTriggerRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ACTIVEONOFFTRIGGERRELUPREG;
}


spm_corefi_tclMsgActiveOnOffTriggerRelUpReg::~spm_corefi_tclMsgActiveOnOffTriggerRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgActiveOnOffTriggerGet::spm_corefi_tclMsgActiveOnOffTriggerGet()
 {}

tS32 spm_corefi_tclMsgActiveOnOffTriggerGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ACTIVEONOFFTRIGGERGET;
}


spm_corefi_tclMsgActiveOnOffTriggerGet::~spm_corefi_tclMsgActiveOnOffTriggerGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSubStatesSet::spm_corefi_tclMsgSubStatesSet(const spm_corefi_tclMsgSubStatesSet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   SubStateType = coRef.SubStateType;
   SubStateData = coRef.SubStateData;
}
spm_corefi_tclMsgSubStatesSet& spm_corefi_tclMsgSubStatesSet::operator=(const spm_corefi_tclMsgSubStatesSet& coRef)
{
   if (this == &coRef) return *this;
   SubStateType = coRef.SubStateType;
   SubStateData = coRef.SubStateData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgSubStatesSet::spm_corefi_tclMsgSubStatesSet()
:SubStateType()
,SubStateData(0)
 {}

tS32 spm_corefi_tclMsgSubStatesSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SUBSTATESSET;
}


spm_corefi_tclMsgSubStatesSet::~spm_corefi_tclMsgSubStatesSet()
{}

tU32 spm_corefi_tclMsgSubStatesSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& spm_corefi_tclMsgSubStatesSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SubStateType);
   (tVoid) (oIn >> SubStateData);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSubStatesSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SubStateType);
   (tVoid) (oOut << SubStateData);
   return oOut;
}

tBool spm_corefi_tclMsgSubStatesSet::operator==(const spm_corefi_tclMsgSubStatesSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SubStateType == roRef.SubStateType);
   bResult = bResult && (SubStateData == roRef.SubStateData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSubStatesStatus::spm_corefi_tclMsgSubStatesStatus(const spm_corefi_tclMsgSubStatesStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   SubState = coRef.SubState;
   HwSubState = coRef.HwSubState;
   InternSubState = coRef.InternSubState;
}
spm_corefi_tclMsgSubStatesStatus& spm_corefi_tclMsgSubStatesStatus::operator=(const spm_corefi_tclMsgSubStatesStatus& coRef)
{
   if (this == &coRef) return *this;
   SubState = coRef.SubState;
   HwSubState = coRef.HwSubState;
   InternSubState = coRef.InternSubState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgSubStatesStatus::spm_corefi_tclMsgSubStatesStatus()
:SubState(0)
,HwSubState(0)
,InternSubState(0)
 {}

tS32 spm_corefi_tclMsgSubStatesStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SUBSTATESSTATUS;
}


spm_corefi_tclMsgSubStatesStatus::~spm_corefi_tclMsgSubStatesStatus()
{}

tU32 spm_corefi_tclMsgSubStatesStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& spm_corefi_tclMsgSubStatesStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SubState);
   (tVoid) (oIn >> HwSubState);
   (tVoid) (oIn >> InternSubState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSubStatesStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SubState);
   (tVoid) (oOut << HwSubState);
   (tVoid) (oOut << InternSubState);
   return oOut;
}

tBool spm_corefi_tclMsgSubStatesStatus::operator==(const spm_corefi_tclMsgSubStatesStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SubState == roRef.SubState);
   bResult = bResult && (HwSubState == roRef.HwSubState);
   bResult = bResult && (InternSubState == roRef.InternSubState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgSubStatesUpReg::spm_corefi_tclMsgSubStatesUpReg()
 {}

tS32 spm_corefi_tclMsgSubStatesUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SUBSTATESUPREG;
}


spm_corefi_tclMsgSubStatesUpReg::~spm_corefi_tclMsgSubStatesUpReg()
{}

//=============================================================================

spm_corefi_tclMsgSubStatesRelUpReg::spm_corefi_tclMsgSubStatesRelUpReg()
 {}

tS32 spm_corefi_tclMsgSubStatesRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SUBSTATESRELUPREG;
}


spm_corefi_tclMsgSubStatesRelUpReg::~spm_corefi_tclMsgSubStatesRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgSubStatesGet::spm_corefi_tclMsgSubStatesGet()
 {}

tS32 spm_corefi_tclMsgSubStatesGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SUBSTATESGET;
}


spm_corefi_tclMsgSubStatesGet::~spm_corefi_tclMsgSubStatesGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgHistoryTriggerStatus::spm_corefi_tclMsgHistoryTriggerStatus(const spm_corefi_tclMsgHistoryTriggerStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   tTriggeredStates = coRef.tTriggeredStates;
}
spm_corefi_tclMsgHistoryTriggerStatus& spm_corefi_tclMsgHistoryTriggerStatus::operator=(const spm_corefi_tclMsgHistoryTriggerStatus& coRef)
{
   if (this == &coRef) return *this;
   tTriggeredStates = coRef.tTriggeredStates;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgHistoryTriggerStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tTriggeredStates.size(); ++u32Idx)
         tTriggeredStates[u32Idx].vDestroy();
   tTriggeredStates.clear();
   }
}

spm_corefi_tclMsgHistoryTriggerStatus::spm_corefi_tclMsgHistoryTriggerStatus()

 {}

tS32 spm_corefi_tclMsgHistoryTriggerStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_HISTORYTRIGGERSTATUS;
}


spm_corefi_tclMsgHistoryTriggerStatus::~spm_corefi_tclMsgHistoryTriggerStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgHistoryTriggerStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(tTriggeredStates.size()*8);
}

fi_tclInContext& spm_corefi_tclMsgHistoryTriggerStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tTriggeredStates.size(); ++u32Idx)
      {
         tTriggeredStates[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tTriggeredStates.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tTriggeredStates[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgHistoryTriggerStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tTriggeredStates.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tTriggeredStates.size(); ++u32Idx)
         (tVoid) (oOut << tTriggeredStates[u32Idx]);
   }
   return oOut;
}

tBool spm_corefi_tclMsgHistoryTriggerStatus::operator==(const spm_corefi_tclMsgHistoryTriggerStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tTriggeredStates.size() == roRef.tTriggeredStates.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tTriggeredStates.size()); ++u32Idx)
            bResult = bResult && (tTriggeredStates[u32Idx] == roRef.tTriggeredStates[u32Idx]);
      }
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgHistoryTriggerUpReg::spm_corefi_tclMsgHistoryTriggerUpReg()
 {}

tS32 spm_corefi_tclMsgHistoryTriggerUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_HISTORYTRIGGERUPREG;
}


spm_corefi_tclMsgHistoryTriggerUpReg::~spm_corefi_tclMsgHistoryTriggerUpReg()
{}

//=============================================================================

spm_corefi_tclMsgHistoryTriggerRelUpReg::spm_corefi_tclMsgHistoryTriggerRelUpReg()
 {}

tS32 spm_corefi_tclMsgHistoryTriggerRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_HISTORYTRIGGERRELUPREG;
}


spm_corefi_tclMsgHistoryTriggerRelUpReg::~spm_corefi_tclMsgHistoryTriggerRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgHistoryTriggerGet::spm_corefi_tclMsgHistoryTriggerGet()
 {}

tS32 spm_corefi_tclMsgHistoryTriggerGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_HISTORYTRIGGERGET;
}


spm_corefi_tclMsgHistoryTriggerGet::~spm_corefi_tclMsgHistoryTriggerGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgInsertStateStatus::spm_corefi_tclMsgInsertStateStatus(const spm_corefi_tclMsgInsertStateStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   InsertState = coRef.InsertState;
}
spm_corefi_tclMsgInsertStateStatus& spm_corefi_tclMsgInsertStateStatus::operator=(const spm_corefi_tclMsgInsertStateStatus& coRef)
{
   if (this == &coRef) return *this;
   InsertState = coRef.InsertState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgInsertStateStatus::spm_corefi_tclMsgInsertStateStatus()
:InsertState()
 {}

tS32 spm_corefi_tclMsgInsertStateStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_INSERTSTATESTATUS;
}


spm_corefi_tclMsgInsertStateStatus::~spm_corefi_tclMsgInsertStateStatus()
{}

tU32 spm_corefi_tclMsgInsertStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgInsertStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> InsertState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgInsertStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << InsertState);
   return oOut;
}

tBool spm_corefi_tclMsgInsertStateStatus::operator==(const spm_corefi_tclMsgInsertStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (InsertState == roRef.InsertState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgInsertStateUpReg::spm_corefi_tclMsgInsertStateUpReg()
 {}

tS32 spm_corefi_tclMsgInsertStateUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_INSERTSTATEUPREG;
}


spm_corefi_tclMsgInsertStateUpReg::~spm_corefi_tclMsgInsertStateUpReg()
{}

//=============================================================================

spm_corefi_tclMsgInsertStateRelUpReg::spm_corefi_tclMsgInsertStateRelUpReg()
 {}

tS32 spm_corefi_tclMsgInsertStateRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_INSERTSTATERELUPREG;
}


spm_corefi_tclMsgInsertStateRelUpReg::~spm_corefi_tclMsgInsertStateRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgInsertStateGet::spm_corefi_tclMsgInsertStateGet()
 {}

tS32 spm_corefi_tclMsgInsertStateGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_INSERTSTATEGET;
}


spm_corefi_tclMsgInsertStateGet::~spm_corefi_tclMsgInsertStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgMediaEjectStateStatus::spm_corefi_tclMsgMediaEjectStateStatus(const spm_corefi_tclMsgMediaEjectStateStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   MediaEjectState = coRef.MediaEjectState;
}
spm_corefi_tclMsgMediaEjectStateStatus& spm_corefi_tclMsgMediaEjectStateStatus::operator=(const spm_corefi_tclMsgMediaEjectStateStatus& coRef)
{
   if (this == &coRef) return *this;
   MediaEjectState = coRef.MediaEjectState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgMediaEjectStateStatus::spm_corefi_tclMsgMediaEjectStateStatus()
:MediaEjectState()
 {}

tS32 spm_corefi_tclMsgMediaEjectStateStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_MEDIAEJECTSTATESTATUS;
}


spm_corefi_tclMsgMediaEjectStateStatus::~spm_corefi_tclMsgMediaEjectStateStatus()
{}

tU32 spm_corefi_tclMsgMediaEjectStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgMediaEjectStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MediaEjectState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgMediaEjectStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MediaEjectState);
   return oOut;
}

tBool spm_corefi_tclMsgMediaEjectStateStatus::operator==(const spm_corefi_tclMsgMediaEjectStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MediaEjectState == roRef.MediaEjectState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgMediaEjectStateUpReg::spm_corefi_tclMsgMediaEjectStateUpReg()
 {}

tS32 spm_corefi_tclMsgMediaEjectStateUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_MEDIAEJECTSTATEUPREG;
}


spm_corefi_tclMsgMediaEjectStateUpReg::~spm_corefi_tclMsgMediaEjectStateUpReg()
{}

//=============================================================================

spm_corefi_tclMsgMediaEjectStateRelUpReg::spm_corefi_tclMsgMediaEjectStateRelUpReg()
 {}

tS32 spm_corefi_tclMsgMediaEjectStateRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_MEDIAEJECTSTATERELUPREG;
}


spm_corefi_tclMsgMediaEjectStateRelUpReg::~spm_corefi_tclMsgMediaEjectStateRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgMediaEjectStateGet::spm_corefi_tclMsgMediaEjectStateGet()
 {}

tS32 spm_corefi_tclMsgMediaEjectStateGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_MEDIAEJECTSTATEGET;
}


spm_corefi_tclMsgMediaEjectStateGet::~spm_corefi_tclMsgMediaEjectStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgPhoneMuteStateStatus::spm_corefi_tclMsgPhoneMuteStateStatus(const spm_corefi_tclMsgPhoneMuteStateStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   PhoneMuteState = coRef.PhoneMuteState;
}
spm_corefi_tclMsgPhoneMuteStateStatus& spm_corefi_tclMsgPhoneMuteStateStatus::operator=(const spm_corefi_tclMsgPhoneMuteStateStatus& coRef)
{
   if (this == &coRef) return *this;
   PhoneMuteState = coRef.PhoneMuteState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgPhoneMuteStateStatus::spm_corefi_tclMsgPhoneMuteStateStatus()
:PhoneMuteState()
 {}

tS32 spm_corefi_tclMsgPhoneMuteStateStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_PHONEMUTESTATESTATUS;
}


spm_corefi_tclMsgPhoneMuteStateStatus::~spm_corefi_tclMsgPhoneMuteStateStatus()
{}

tU32 spm_corefi_tclMsgPhoneMuteStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgPhoneMuteStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PhoneMuteState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgPhoneMuteStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PhoneMuteState);
   return oOut;
}

tBool spm_corefi_tclMsgPhoneMuteStateStatus::operator==(const spm_corefi_tclMsgPhoneMuteStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PhoneMuteState == roRef.PhoneMuteState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgPhoneMuteStateUpReg::spm_corefi_tclMsgPhoneMuteStateUpReg()
 {}

tS32 spm_corefi_tclMsgPhoneMuteStateUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_PHONEMUTESTATEUPREG;
}


spm_corefi_tclMsgPhoneMuteStateUpReg::~spm_corefi_tclMsgPhoneMuteStateUpReg()
{}

//=============================================================================

spm_corefi_tclMsgPhoneMuteStateRelUpReg::spm_corefi_tclMsgPhoneMuteStateRelUpReg()
 {}

tS32 spm_corefi_tclMsgPhoneMuteStateRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_PHONEMUTESTATERELUPREG;
}


spm_corefi_tclMsgPhoneMuteStateRelUpReg::~spm_corefi_tclMsgPhoneMuteStateRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgPhoneMuteStateGet::spm_corefi_tclMsgPhoneMuteStateGet()
 {}

tS32 spm_corefi_tclMsgPhoneMuteStateGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_PHONEMUTESTATEGET;
}


spm_corefi_tclMsgPhoneMuteStateGet::~spm_corefi_tclMsgPhoneMuteStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgOnTipperStateStatus::spm_corefi_tclMsgOnTipperStateStatus(const spm_corefi_tclMsgOnTipperStateStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   OnTipperState = coRef.OnTipperState;
}
spm_corefi_tclMsgOnTipperStateStatus& spm_corefi_tclMsgOnTipperStateStatus::operator=(const spm_corefi_tclMsgOnTipperStateStatus& coRef)
{
   if (this == &coRef) return *this;
   OnTipperState = coRef.OnTipperState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgOnTipperStateStatus::spm_corefi_tclMsgOnTipperStateStatus()
:OnTipperState()
 {}

tS32 spm_corefi_tclMsgOnTipperStateStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ONTIPPERSTATESTATUS;
}


spm_corefi_tclMsgOnTipperStateStatus::~spm_corefi_tclMsgOnTipperStateStatus()
{}

tU32 spm_corefi_tclMsgOnTipperStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgOnTipperStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> OnTipperState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgOnTipperStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << OnTipperState);
   return oOut;
}

tBool spm_corefi_tclMsgOnTipperStateStatus::operator==(const spm_corefi_tclMsgOnTipperStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (OnTipperState == roRef.OnTipperState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgOnTipperStateUpReg::spm_corefi_tclMsgOnTipperStateUpReg()
 {}

tS32 spm_corefi_tclMsgOnTipperStateUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ONTIPPERSTATEUPREG;
}


spm_corefi_tclMsgOnTipperStateUpReg::~spm_corefi_tclMsgOnTipperStateUpReg()
{}

//=============================================================================

spm_corefi_tclMsgOnTipperStateRelUpReg::spm_corefi_tclMsgOnTipperStateRelUpReg()
 {}

tS32 spm_corefi_tclMsgOnTipperStateRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ONTIPPERSTATERELUPREG;
}


spm_corefi_tclMsgOnTipperStateRelUpReg::~spm_corefi_tclMsgOnTipperStateRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgOnTipperStateGet::spm_corefi_tclMsgOnTipperStateGet()
 {}

tS32 spm_corefi_tclMsgOnTipperStateGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ONTIPPERSTATEGET;
}


spm_corefi_tclMsgOnTipperStateGet::~spm_corefi_tclMsgOnTipperStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgIgnitionCyclesStatus::spm_corefi_tclMsgIgnitionCyclesStatus(const spm_corefi_tclMsgIgnitionCyclesStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   IgnitionCycle = coRef.IgnitionCycle;
}
spm_corefi_tclMsgIgnitionCyclesStatus& spm_corefi_tclMsgIgnitionCyclesStatus::operator=(const spm_corefi_tclMsgIgnitionCyclesStatus& coRef)
{
   if (this == &coRef) return *this;
   IgnitionCycle = coRef.IgnitionCycle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgIgnitionCyclesStatus::spm_corefi_tclMsgIgnitionCyclesStatus()
:IgnitionCycle(0)
 {}

tS32 spm_corefi_tclMsgIgnitionCyclesStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_IGNITIONCYCLESSTATUS;
}


spm_corefi_tclMsgIgnitionCyclesStatus::~spm_corefi_tclMsgIgnitionCyclesStatus()
{}

tU32 spm_corefi_tclMsgIgnitionCyclesStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgIgnitionCyclesStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> IgnitionCycle);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgIgnitionCyclesStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << IgnitionCycle);
   return oOut;
}

tBool spm_corefi_tclMsgIgnitionCyclesStatus::operator==(const spm_corefi_tclMsgIgnitionCyclesStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (IgnitionCycle == roRef.IgnitionCycle);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgIgnitionCyclesUpReg::spm_corefi_tclMsgIgnitionCyclesUpReg()
 {}

tS32 spm_corefi_tclMsgIgnitionCyclesUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_IGNITIONCYCLESUPREG;
}


spm_corefi_tclMsgIgnitionCyclesUpReg::~spm_corefi_tclMsgIgnitionCyclesUpReg()
{}

//=============================================================================

spm_corefi_tclMsgIgnitionCyclesRelUpReg::spm_corefi_tclMsgIgnitionCyclesRelUpReg()
 {}

tS32 spm_corefi_tclMsgIgnitionCyclesRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_IGNITIONCYCLESRELUPREG;
}


spm_corefi_tclMsgIgnitionCyclesRelUpReg::~spm_corefi_tclMsgIgnitionCyclesRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgIgnitionCyclesGet::spm_corefi_tclMsgIgnitionCyclesGet()
 {}

tS32 spm_corefi_tclMsgIgnitionCyclesGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_IGNITIONCYCLESGET;
}


spm_corefi_tclMsgIgnitionCyclesGet::~spm_corefi_tclMsgIgnitionCyclesGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSysPwrModeStatus::spm_corefi_tclMsgSysPwrModeStatus(const spm_corefi_tclMsgSysPwrModeStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   SysPwrMode = coRef.SysPwrMode;
}
spm_corefi_tclMsgSysPwrModeStatus& spm_corefi_tclMsgSysPwrModeStatus::operator=(const spm_corefi_tclMsgSysPwrModeStatus& coRef)
{
   if (this == &coRef) return *this;
   SysPwrMode = coRef.SysPwrMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgSysPwrModeStatus::spm_corefi_tclMsgSysPwrModeStatus()
:SysPwrMode()
 {}

tS32 spm_corefi_tclMsgSysPwrModeStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SYSPWRMODESTATUS;
}


spm_corefi_tclMsgSysPwrModeStatus::~spm_corefi_tclMsgSysPwrModeStatus()
{}

tU32 spm_corefi_tclMsgSysPwrModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgSysPwrModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SysPwrMode);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSysPwrModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SysPwrMode);
   return oOut;
}

tBool spm_corefi_tclMsgSysPwrModeStatus::operator==(const spm_corefi_tclMsgSysPwrModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SysPwrMode == roRef.SysPwrMode);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgSysPwrModeUpReg::spm_corefi_tclMsgSysPwrModeUpReg()
 {}

tS32 spm_corefi_tclMsgSysPwrModeUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SYSPWRMODEUPREG;
}


spm_corefi_tclMsgSysPwrModeUpReg::~spm_corefi_tclMsgSysPwrModeUpReg()
{}

//=============================================================================

spm_corefi_tclMsgSysPwrModeRelUpReg::spm_corefi_tclMsgSysPwrModeRelUpReg()
 {}

tS32 spm_corefi_tclMsgSysPwrModeRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SYSPWRMODERELUPREG;
}


spm_corefi_tclMsgSysPwrModeRelUpReg::~spm_corefi_tclMsgSysPwrModeRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgSysPwrModeGet::spm_corefi_tclMsgSysPwrModeGet()
 {}

tS32 spm_corefi_tclMsgSysPwrModeGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SYSPWRMODEGET;
}


spm_corefi_tclMsgSysPwrModeGet::~spm_corefi_tclMsgSysPwrModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSysPwrSaveModeStatus::spm_corefi_tclMsgSysPwrSaveModeStatus(const spm_corefi_tclMsgSysPwrSaveModeStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   SysPwrSaveMode = coRef.SysPwrSaveMode;
}
spm_corefi_tclMsgSysPwrSaveModeStatus& spm_corefi_tclMsgSysPwrSaveModeStatus::operator=(const spm_corefi_tclMsgSysPwrSaveModeStatus& coRef)
{
   if (this == &coRef) return *this;
   SysPwrSaveMode = coRef.SysPwrSaveMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgSysPwrSaveModeStatus::spm_corefi_tclMsgSysPwrSaveModeStatus()
:SysPwrSaveMode()
 {}

tS32 spm_corefi_tclMsgSysPwrSaveModeStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SYSPWRSAVEMODESTATUS;
}


spm_corefi_tclMsgSysPwrSaveModeStatus::~spm_corefi_tclMsgSysPwrSaveModeStatus()
{}

tU32 spm_corefi_tclMsgSysPwrSaveModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgSysPwrSaveModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SysPwrSaveMode);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSysPwrSaveModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SysPwrSaveMode);
   return oOut;
}

tBool spm_corefi_tclMsgSysPwrSaveModeStatus::operator==(const spm_corefi_tclMsgSysPwrSaveModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SysPwrSaveMode == roRef.SysPwrSaveMode);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgSysPwrSaveModeGet::spm_corefi_tclMsgSysPwrSaveModeGet()
 {}

tS32 spm_corefi_tclMsgSysPwrSaveModeGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SYSPWRSAVEMODEGET;
}


spm_corefi_tclMsgSysPwrSaveModeGet::~spm_corefi_tclMsgSysPwrSaveModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgMapDownloadLockStateStatus::spm_corefi_tclMsgMapDownloadLockStateStatus(const spm_corefi_tclMsgMapDownloadLockStateStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   u16AppIdLockOwner = coRef.u16AppIdLockOwner;
}
spm_corefi_tclMsgMapDownloadLockStateStatus& spm_corefi_tclMsgMapDownloadLockStateStatus::operator=(const spm_corefi_tclMsgMapDownloadLockStateStatus& coRef)
{
   if (this == &coRef) return *this;
   u16AppIdLockOwner = coRef.u16AppIdLockOwner;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgMapDownloadLockStateStatus::spm_corefi_tclMsgMapDownloadLockStateStatus()
:u16AppIdLockOwner(0)
 {}

tS32 spm_corefi_tclMsgMapDownloadLockStateStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_MAPDOWNLOADLOCKSTATESTATUS;
}


spm_corefi_tclMsgMapDownloadLockStateStatus::~spm_corefi_tclMsgMapDownloadLockStateStatus()
{}

tU32 spm_corefi_tclMsgMapDownloadLockStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& spm_corefi_tclMsgMapDownloadLockStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16AppIdLockOwner);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgMapDownloadLockStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16AppIdLockOwner);
   return oOut;
}

tBool spm_corefi_tclMsgMapDownloadLockStateStatus::operator==(const spm_corefi_tclMsgMapDownloadLockStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16AppIdLockOwner == roRef.u16AppIdLockOwner);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgMapDownloadLockStateUpReg::spm_corefi_tclMsgMapDownloadLockStateUpReg()
 {}

tS32 spm_corefi_tclMsgMapDownloadLockStateUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_MAPDOWNLOADLOCKSTATEUPREG;
}


spm_corefi_tclMsgMapDownloadLockStateUpReg::~spm_corefi_tclMsgMapDownloadLockStateUpReg()
{}

//=============================================================================

spm_corefi_tclMsgMapDownloadLockStateRelUpReg::spm_corefi_tclMsgMapDownloadLockStateRelUpReg()
 {}

tS32 spm_corefi_tclMsgMapDownloadLockStateRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_MAPDOWNLOADLOCKSTATERELUPREG;
}


spm_corefi_tclMsgMapDownloadLockStateRelUpReg::~spm_corefi_tclMsgMapDownloadLockStateRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgMapDownloadLockStateGet::spm_corefi_tclMsgMapDownloadLockStateGet()
 {}

tS32 spm_corefi_tclMsgMapDownloadLockStateGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_MAPDOWNLOADLOCKSTATEGET;
}


spm_corefi_tclMsgMapDownloadLockStateGet::~spm_corefi_tclMsgMapDownloadLockStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgStandbyTimeSet::spm_corefi_tclMsgStandbyTimeSet(const spm_corefi_tclMsgStandbyTimeSet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   StandbyTime = coRef.StandbyTime;
}
spm_corefi_tclMsgStandbyTimeSet& spm_corefi_tclMsgStandbyTimeSet::operator=(const spm_corefi_tclMsgStandbyTimeSet& coRef)
{
   if (this == &coRef) return *this;
   StandbyTime = coRef.StandbyTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgStandbyTimeSet::spm_corefi_tclMsgStandbyTimeSet()
:StandbyTime(0)
 {}

tS32 spm_corefi_tclMsgStandbyTimeSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_STANDBYTIMESET;
}


spm_corefi_tclMsgStandbyTimeSet::~spm_corefi_tclMsgStandbyTimeSet()
{}

tU32 spm_corefi_tclMsgStandbyTimeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgStandbyTimeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StandbyTime);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgStandbyTimeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StandbyTime);
   return oOut;
}

tBool spm_corefi_tclMsgStandbyTimeSet::operator==(const spm_corefi_tclMsgStandbyTimeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StandbyTime == roRef.StandbyTime);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgStandbyTimeStatus::spm_corefi_tclMsgStandbyTimeStatus(const spm_corefi_tclMsgStandbyTimeStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   StandbyTime = coRef.StandbyTime;
}
spm_corefi_tclMsgStandbyTimeStatus& spm_corefi_tclMsgStandbyTimeStatus::operator=(const spm_corefi_tclMsgStandbyTimeStatus& coRef)
{
   if (this == &coRef) return *this;
   StandbyTime = coRef.StandbyTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgStandbyTimeStatus::spm_corefi_tclMsgStandbyTimeStatus()
:StandbyTime(0)
 {}

tS32 spm_corefi_tclMsgStandbyTimeStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_STANDBYTIMESTATUS;
}


spm_corefi_tclMsgStandbyTimeStatus::~spm_corefi_tclMsgStandbyTimeStatus()
{}

tU32 spm_corefi_tclMsgStandbyTimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgStandbyTimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StandbyTime);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgStandbyTimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StandbyTime);
   return oOut;
}

tBool spm_corefi_tclMsgStandbyTimeStatus::operator==(const spm_corefi_tclMsgStandbyTimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StandbyTime == roRef.StandbyTime);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgStandbyTimeGet::spm_corefi_tclMsgStandbyTimeGet()
 {}

tS32 spm_corefi_tclMsgStandbyTimeGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_STANDBYTIMEGET;
}


spm_corefi_tclMsgStandbyTimeGet::~spm_corefi_tclMsgStandbyTimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgPersitentStandbyTimeSet::spm_corefi_tclMsgPersitentStandbyTimeSet(const spm_corefi_tclMsgPersitentStandbyTimeSet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   PersitentStandbyTime = coRef.PersitentStandbyTime;
}
spm_corefi_tclMsgPersitentStandbyTimeSet& spm_corefi_tclMsgPersitentStandbyTimeSet::operator=(const spm_corefi_tclMsgPersitentStandbyTimeSet& coRef)
{
   if (this == &coRef) return *this;
   PersitentStandbyTime = coRef.PersitentStandbyTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgPersitentStandbyTimeSet::spm_corefi_tclMsgPersitentStandbyTimeSet()
:PersitentStandbyTime(0)
 {}

tS32 spm_corefi_tclMsgPersitentStandbyTimeSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_PERSITENTSTANDBYTIMESET;
}


spm_corefi_tclMsgPersitentStandbyTimeSet::~spm_corefi_tclMsgPersitentStandbyTimeSet()
{}

tU32 spm_corefi_tclMsgPersitentStandbyTimeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgPersitentStandbyTimeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PersitentStandbyTime);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgPersitentStandbyTimeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PersitentStandbyTime);
   return oOut;
}

tBool spm_corefi_tclMsgPersitentStandbyTimeSet::operator==(const spm_corefi_tclMsgPersitentStandbyTimeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PersitentStandbyTime == roRef.PersitentStandbyTime);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgPersitentStandbyTimeStatus::spm_corefi_tclMsgPersitentStandbyTimeStatus(const spm_corefi_tclMsgPersitentStandbyTimeStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   PersitentStandbyTime = coRef.PersitentStandbyTime;
}
spm_corefi_tclMsgPersitentStandbyTimeStatus& spm_corefi_tclMsgPersitentStandbyTimeStatus::operator=(const spm_corefi_tclMsgPersitentStandbyTimeStatus& coRef)
{
   if (this == &coRef) return *this;
   PersitentStandbyTime = coRef.PersitentStandbyTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgPersitentStandbyTimeStatus::spm_corefi_tclMsgPersitentStandbyTimeStatus()
:PersitentStandbyTime(0)
 {}

tS32 spm_corefi_tclMsgPersitentStandbyTimeStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_PERSITENTSTANDBYTIMESTATUS;
}


spm_corefi_tclMsgPersitentStandbyTimeStatus::~spm_corefi_tclMsgPersitentStandbyTimeStatus()
{}

tU32 spm_corefi_tclMsgPersitentStandbyTimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgPersitentStandbyTimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PersitentStandbyTime);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgPersitentStandbyTimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PersitentStandbyTime);
   return oOut;
}

tBool spm_corefi_tclMsgPersitentStandbyTimeStatus::operator==(const spm_corefi_tclMsgPersitentStandbyTimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PersitentStandbyTime == roRef.PersitentStandbyTime);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgPersitentStandbyTimeGet::spm_corefi_tclMsgPersitentStandbyTimeGet()
 {}

tS32 spm_corefi_tclMsgPersitentStandbyTimeGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_PERSITENTSTANDBYTIMEGET;
}


spm_corefi_tclMsgPersitentStandbyTimeGet::~spm_corefi_tclMsgPersitentStandbyTimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgIgnitionOffTimeSet::spm_corefi_tclMsgIgnitionOffTimeSet(const spm_corefi_tclMsgIgnitionOffTimeSet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   IgnitionOffTime = coRef.IgnitionOffTime;
}
spm_corefi_tclMsgIgnitionOffTimeSet& spm_corefi_tclMsgIgnitionOffTimeSet::operator=(const spm_corefi_tclMsgIgnitionOffTimeSet& coRef)
{
   if (this == &coRef) return *this;
   IgnitionOffTime = coRef.IgnitionOffTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgIgnitionOffTimeSet::spm_corefi_tclMsgIgnitionOffTimeSet()
:IgnitionOffTime(0)
 {}

tS32 spm_corefi_tclMsgIgnitionOffTimeSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_IGNITIONOFFTIMESET;
}


spm_corefi_tclMsgIgnitionOffTimeSet::~spm_corefi_tclMsgIgnitionOffTimeSet()
{}

tU32 spm_corefi_tclMsgIgnitionOffTimeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgIgnitionOffTimeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> IgnitionOffTime);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgIgnitionOffTimeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << IgnitionOffTime);
   return oOut;
}

tBool spm_corefi_tclMsgIgnitionOffTimeSet::operator==(const spm_corefi_tclMsgIgnitionOffTimeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (IgnitionOffTime == roRef.IgnitionOffTime);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgIgnitionOffTimeStatus::spm_corefi_tclMsgIgnitionOffTimeStatus(const spm_corefi_tclMsgIgnitionOffTimeStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   IgnitionOffTime = coRef.IgnitionOffTime;
}
spm_corefi_tclMsgIgnitionOffTimeStatus& spm_corefi_tclMsgIgnitionOffTimeStatus::operator=(const spm_corefi_tclMsgIgnitionOffTimeStatus& coRef)
{
   if (this == &coRef) return *this;
   IgnitionOffTime = coRef.IgnitionOffTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgIgnitionOffTimeStatus::spm_corefi_tclMsgIgnitionOffTimeStatus()
:IgnitionOffTime(0)
 {}

tS32 spm_corefi_tclMsgIgnitionOffTimeStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_IGNITIONOFFTIMESTATUS;
}


spm_corefi_tclMsgIgnitionOffTimeStatus::~spm_corefi_tclMsgIgnitionOffTimeStatus()
{}

tU32 spm_corefi_tclMsgIgnitionOffTimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgIgnitionOffTimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> IgnitionOffTime);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgIgnitionOffTimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << IgnitionOffTime);
   return oOut;
}

tBool spm_corefi_tclMsgIgnitionOffTimeStatus::operator==(const spm_corefi_tclMsgIgnitionOffTimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (IgnitionOffTime == roRef.IgnitionOffTime);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgIgnitionOffTimeGet::spm_corefi_tclMsgIgnitionOffTimeGet()
 {}

tS32 spm_corefi_tclMsgIgnitionOffTimeGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_IGNITIONOFFTIMEGET;
}


spm_corefi_tclMsgIgnitionOffTimeGet::~spm_corefi_tclMsgIgnitionOffTimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgDoorOpenTimeSet::spm_corefi_tclMsgDoorOpenTimeSet(const spm_corefi_tclMsgDoorOpenTimeSet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   DoorOpenTime = coRef.DoorOpenTime;
}
spm_corefi_tclMsgDoorOpenTimeSet& spm_corefi_tclMsgDoorOpenTimeSet::operator=(const spm_corefi_tclMsgDoorOpenTimeSet& coRef)
{
   if (this == &coRef) return *this;
   DoorOpenTime = coRef.DoorOpenTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgDoorOpenTimeSet::spm_corefi_tclMsgDoorOpenTimeSet()
:DoorOpenTime(0)
 {}

tS32 spm_corefi_tclMsgDoorOpenTimeSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DOOROPENTIMESET;
}


spm_corefi_tclMsgDoorOpenTimeSet::~spm_corefi_tclMsgDoorOpenTimeSet()
{}

tU32 spm_corefi_tclMsgDoorOpenTimeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgDoorOpenTimeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DoorOpenTime);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgDoorOpenTimeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DoorOpenTime);
   return oOut;
}

tBool spm_corefi_tclMsgDoorOpenTimeSet::operator==(const spm_corefi_tclMsgDoorOpenTimeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DoorOpenTime == roRef.DoorOpenTime);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgDoorOpenTimeStatus::spm_corefi_tclMsgDoorOpenTimeStatus(const spm_corefi_tclMsgDoorOpenTimeStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   DoorOpenTime = coRef.DoorOpenTime;
}
spm_corefi_tclMsgDoorOpenTimeStatus& spm_corefi_tclMsgDoorOpenTimeStatus::operator=(const spm_corefi_tclMsgDoorOpenTimeStatus& coRef)
{
   if (this == &coRef) return *this;
   DoorOpenTime = coRef.DoorOpenTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgDoorOpenTimeStatus::spm_corefi_tclMsgDoorOpenTimeStatus()
:DoorOpenTime(0)
 {}

tS32 spm_corefi_tclMsgDoorOpenTimeStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DOOROPENTIMESTATUS;
}


spm_corefi_tclMsgDoorOpenTimeStatus::~spm_corefi_tclMsgDoorOpenTimeStatus()
{}

tU32 spm_corefi_tclMsgDoorOpenTimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgDoorOpenTimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DoorOpenTime);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgDoorOpenTimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DoorOpenTime);
   return oOut;
}

tBool spm_corefi_tclMsgDoorOpenTimeStatus::operator==(const spm_corefi_tclMsgDoorOpenTimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DoorOpenTime == roRef.DoorOpenTime);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgDoorOpenTimeGet::spm_corefi_tclMsgDoorOpenTimeGet()
 {}

tS32 spm_corefi_tclMsgDoorOpenTimeGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DOOROPENTIMEGET;
}


spm_corefi_tclMsgDoorOpenTimeGet::~spm_corefi_tclMsgDoorOpenTimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgClockDisplayTimeSet::spm_corefi_tclMsgClockDisplayTimeSet(const spm_corefi_tclMsgClockDisplayTimeSet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   ClockDisplayTime = coRef.ClockDisplayTime;
}
spm_corefi_tclMsgClockDisplayTimeSet& spm_corefi_tclMsgClockDisplayTimeSet::operator=(const spm_corefi_tclMsgClockDisplayTimeSet& coRef)
{
   if (this == &coRef) return *this;
   ClockDisplayTime = coRef.ClockDisplayTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgClockDisplayTimeSet::spm_corefi_tclMsgClockDisplayTimeSet()
:ClockDisplayTime(0)
 {}

tS32 spm_corefi_tclMsgClockDisplayTimeSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CLOCKDISPLAYTIMESET;
}


spm_corefi_tclMsgClockDisplayTimeSet::~spm_corefi_tclMsgClockDisplayTimeSet()
{}

tU32 spm_corefi_tclMsgClockDisplayTimeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgClockDisplayTimeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ClockDisplayTime);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgClockDisplayTimeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ClockDisplayTime);
   return oOut;
}

tBool spm_corefi_tclMsgClockDisplayTimeSet::operator==(const spm_corefi_tclMsgClockDisplayTimeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ClockDisplayTime == roRef.ClockDisplayTime);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgClockDisplayTimeStatus::spm_corefi_tclMsgClockDisplayTimeStatus(const spm_corefi_tclMsgClockDisplayTimeStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   ClockDisplayTime = coRef.ClockDisplayTime;
}
spm_corefi_tclMsgClockDisplayTimeStatus& spm_corefi_tclMsgClockDisplayTimeStatus::operator=(const spm_corefi_tclMsgClockDisplayTimeStatus& coRef)
{
   if (this == &coRef) return *this;
   ClockDisplayTime = coRef.ClockDisplayTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgClockDisplayTimeStatus::spm_corefi_tclMsgClockDisplayTimeStatus()
:ClockDisplayTime(0)
 {}

tS32 spm_corefi_tclMsgClockDisplayTimeStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CLOCKDISPLAYTIMESTATUS;
}


spm_corefi_tclMsgClockDisplayTimeStatus::~spm_corefi_tclMsgClockDisplayTimeStatus()
{}

tU32 spm_corefi_tclMsgClockDisplayTimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgClockDisplayTimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ClockDisplayTime);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgClockDisplayTimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ClockDisplayTime);
   return oOut;
}

tBool spm_corefi_tclMsgClockDisplayTimeStatus::operator==(const spm_corefi_tclMsgClockDisplayTimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ClockDisplayTime == roRef.ClockDisplayTime);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgClockDisplayTimeGet::spm_corefi_tclMsgClockDisplayTimeGet()
 {}

tS32 spm_corefi_tclMsgClockDisplayTimeGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CLOCKDISPLAYTIMEGET;
}


spm_corefi_tclMsgClockDisplayTimeGet::~spm_corefi_tclMsgClockDisplayTimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSystemStateTimeGet::spm_corefi_tclMsgSystemStateTimeGet(const spm_corefi_tclMsgSystemStateTimeGet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   tSystemState = coRef.tSystemState;
}
spm_corefi_tclMsgSystemStateTimeGet& spm_corefi_tclMsgSystemStateTimeGet::operator=(const spm_corefi_tclMsgSystemStateTimeGet& coRef)
{
   if (this == &coRef) return *this;
   tSystemState = coRef.tSystemState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgSystemStateTimeGet::spm_corefi_tclMsgSystemStateTimeGet()
:tSystemState()
 {}

tS32 spm_corefi_tclMsgSystemStateTimeGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SYSTEMSTATETIMEGET;
}


spm_corefi_tclMsgSystemStateTimeGet::~spm_corefi_tclMsgSystemStateTimeGet()
{}

tU32 spm_corefi_tclMsgSystemStateTimeGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgSystemStateTimeGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tSystemState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSystemStateTimeGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tSystemState);
   return oOut;
}

tBool spm_corefi_tclMsgSystemStateTimeGet::operator==(const spm_corefi_tclMsgSystemStateTimeGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tSystemState == roRef.tSystemState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSystemStateTimeSet::spm_corefi_tclMsgSystemStateTimeSet(const spm_corefi_tclMsgSystemStateTimeSet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   tSystemState = coRef.tSystemState;
   tStateTimerValue = coRef.tStateTimerValue;
}
spm_corefi_tclMsgSystemStateTimeSet& spm_corefi_tclMsgSystemStateTimeSet::operator=(const spm_corefi_tclMsgSystemStateTimeSet& coRef)
{
   if (this == &coRef) return *this;
   tSystemState = coRef.tSystemState;
   tStateTimerValue = coRef.tStateTimerValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgSystemStateTimeSet::spm_corefi_tclMsgSystemStateTimeSet()
:tSystemState()
,tStateTimerValue(0)
 {}

tS32 spm_corefi_tclMsgSystemStateTimeSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SYSTEMSTATETIMESET;
}


spm_corefi_tclMsgSystemStateTimeSet::~spm_corefi_tclMsgSystemStateTimeSet()
{}

tU32 spm_corefi_tclMsgSystemStateTimeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& spm_corefi_tclMsgSystemStateTimeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tSystemState);
   (tVoid) (oIn >> tStateTimerValue);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSystemStateTimeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tSystemState);
   (tVoid) (oOut << tStateTimerValue);
   return oOut;
}

tBool spm_corefi_tclMsgSystemStateTimeSet::operator==(const spm_corefi_tclMsgSystemStateTimeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tSystemState == roRef.tSystemState);
   bResult = bResult && (tStateTimerValue == roRef.tStateTimerValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSystemStateTimeStatus::spm_corefi_tclMsgSystemStateTimeStatus(const spm_corefi_tclMsgSystemStateTimeStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   tSystemState = coRef.tSystemState;
   tStateTimerValue = coRef.tStateTimerValue;
}
spm_corefi_tclMsgSystemStateTimeStatus& spm_corefi_tclMsgSystemStateTimeStatus::operator=(const spm_corefi_tclMsgSystemStateTimeStatus& coRef)
{
   if (this == &coRef) return *this;
   tSystemState = coRef.tSystemState;
   tStateTimerValue = coRef.tStateTimerValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgSystemStateTimeStatus::spm_corefi_tclMsgSystemStateTimeStatus()
:tSystemState()
,tStateTimerValue(0)
 {}

tS32 spm_corefi_tclMsgSystemStateTimeStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SYSTEMSTATETIMESTATUS;
}


spm_corefi_tclMsgSystemStateTimeStatus::~spm_corefi_tclMsgSystemStateTimeStatus()
{}

tU32 spm_corefi_tclMsgSystemStateTimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& spm_corefi_tclMsgSystemStateTimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tSystemState);
   (tVoid) (oIn >> tStateTimerValue);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSystemStateTimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tSystemState);
   (tVoid) (oOut << tStateTimerValue);
   return oOut;
}

tBool spm_corefi_tclMsgSystemStateTimeStatus::operator==(const spm_corefi_tclMsgSystemStateTimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tSystemState == roRef.tSystemState);
   bResult = bResult && (tStateTimerValue == roRef.tStateTimerValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgProcessListStatus::spm_corefi_tclMsgProcessListStatus(const spm_corefi_tclMsgProcessListStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   tProcesses = coRef.tProcesses;
}
spm_corefi_tclMsgProcessListStatus& spm_corefi_tclMsgProcessListStatus::operator=(const spm_corefi_tclMsgProcessListStatus& coRef)
{
   if (this == &coRef) return *this;
   tProcesses = coRef.tProcesses;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgProcessListStatus::vDestroy()
{
   tProcesses.vDestroy(); 
}

spm_corefi_tclMsgProcessListStatus::spm_corefi_tclMsgProcessListStatus()
:tProcesses()
 {}

tS32 spm_corefi_tclMsgProcessListStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_PROCESSLISTSTATUS;
}


spm_corefi_tclMsgProcessListStatus::~spm_corefi_tclMsgProcessListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgProcessListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+tProcesses.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_corefi_tclMsgProcessListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tProcesses);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgProcessListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tProcesses);
   return oOut;
}

tBool spm_corefi_tclMsgProcessListStatus::operator==(const spm_corefi_tclMsgProcessListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tProcesses == roRef.tProcesses);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgProcessListUpReg::spm_corefi_tclMsgProcessListUpReg()
 {}

tS32 spm_corefi_tclMsgProcessListUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_PROCESSLISTUPREG;
}


spm_corefi_tclMsgProcessListUpReg::~spm_corefi_tclMsgProcessListUpReg()
{}

//=============================================================================

spm_corefi_tclMsgProcessListRelUpReg::spm_corefi_tclMsgProcessListRelUpReg()
 {}

tS32 spm_corefi_tclMsgProcessListRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_PROCESSLISTRELUPREG;
}


spm_corefi_tclMsgProcessListRelUpReg::~spm_corefi_tclMsgProcessListRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgProcessListGet::spm_corefi_tclMsgProcessListGet()
 {}

tS32 spm_corefi_tclMsgProcessListGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_PROCESSLISTGET;
}


spm_corefi_tclMsgProcessListGet::~spm_corefi_tclMsgProcessListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgWakeupReasonStatus::spm_corefi_tclMsgWakeupReasonStatus(const spm_corefi_tclMsgWakeupReasonStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   WakeupReason = coRef.WakeupReason;
}
spm_corefi_tclMsgWakeupReasonStatus& spm_corefi_tclMsgWakeupReasonStatus::operator=(const spm_corefi_tclMsgWakeupReasonStatus& coRef)
{
   if (this == &coRef) return *this;
   WakeupReason = coRef.WakeupReason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgWakeupReasonStatus::spm_corefi_tclMsgWakeupReasonStatus()
:WakeupReason()
 {}

tS32 spm_corefi_tclMsgWakeupReasonStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_WAKEUPREASONSTATUS;
}


spm_corefi_tclMsgWakeupReasonStatus::~spm_corefi_tclMsgWakeupReasonStatus()
{}

tU32 spm_corefi_tclMsgWakeupReasonStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgWakeupReasonStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> WakeupReason);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgWakeupReasonStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << WakeupReason);
   return oOut;
}

tBool spm_corefi_tclMsgWakeupReasonStatus::operator==(const spm_corefi_tclMsgWakeupReasonStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (WakeupReason == roRef.WakeupReason);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgWakeupReasonGet::spm_corefi_tclMsgWakeupReasonGet()
 {}

tS32 spm_corefi_tclMsgWakeupReasonGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_WAKEUPREASONGET;
}


spm_corefi_tclMsgWakeupReasonGet::~spm_corefi_tclMsgWakeupReasonGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgStartupReasonStatus::spm_corefi_tclMsgStartupReasonStatus(const spm_corefi_tclMsgStartupReasonStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   StartupReason = coRef.StartupReason;
}
spm_corefi_tclMsgStartupReasonStatus& spm_corefi_tclMsgStartupReasonStatus::operator=(const spm_corefi_tclMsgStartupReasonStatus& coRef)
{
   if (this == &coRef) return *this;
   StartupReason = coRef.StartupReason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgStartupReasonStatus::spm_corefi_tclMsgStartupReasonStatus()
:StartupReason()
 {}

tS32 spm_corefi_tclMsgStartupReasonStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_STARTUPREASONSTATUS;
}


spm_corefi_tclMsgStartupReasonStatus::~spm_corefi_tclMsgStartupReasonStatus()
{}

tU32 spm_corefi_tclMsgStartupReasonStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgStartupReasonStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StartupReason);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgStartupReasonStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StartupReason);
   return oOut;
}

tBool spm_corefi_tclMsgStartupReasonStatus::operator==(const spm_corefi_tclMsgStartupReasonStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StartupReason == roRef.StartupReason);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgStartupReasonGet::spm_corefi_tclMsgStartupReasonGet()
 {}

tS32 spm_corefi_tclMsgStartupReasonGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_STARTUPREASONGET;
}


spm_corefi_tclMsgStartupReasonGet::~spm_corefi_tclMsgStartupReasonGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgConnectToBatteryStatus::spm_corefi_tclMsgConnectToBatteryStatus(const spm_corefi_tclMsgConnectToBatteryStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   ConnectToBatteryState = coRef.ConnectToBatteryState;
   ConnectToBatteryCount = coRef.ConnectToBatteryCount;
}
spm_corefi_tclMsgConnectToBatteryStatus& spm_corefi_tclMsgConnectToBatteryStatus::operator=(const spm_corefi_tclMsgConnectToBatteryStatus& coRef)
{
   if (this == &coRef) return *this;
   ConnectToBatteryState = coRef.ConnectToBatteryState;
   ConnectToBatteryCount = coRef.ConnectToBatteryCount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgConnectToBatteryStatus::spm_corefi_tclMsgConnectToBatteryStatus()
:ConnectToBatteryState(0)
,ConnectToBatteryCount(0)
 {}

tS32 spm_corefi_tclMsgConnectToBatteryStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CONNECTTOBATTERYSTATUS;
}


spm_corefi_tclMsgConnectToBatteryStatus::~spm_corefi_tclMsgConnectToBatteryStatus()
{}

tU32 spm_corefi_tclMsgConnectToBatteryStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& spm_corefi_tclMsgConnectToBatteryStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ConnectToBatteryState);
   (tVoid) (oIn >> ConnectToBatteryCount);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgConnectToBatteryStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ConnectToBatteryState);
   (tVoid) (oOut << ConnectToBatteryCount);
   return oOut;
}

tBool spm_corefi_tclMsgConnectToBatteryStatus::operator==(const spm_corefi_tclMsgConnectToBatteryStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ConnectToBatteryState == roRef.ConnectToBatteryState);
   bResult = bResult && (ConnectToBatteryCount == roRef.ConnectToBatteryCount);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgConnectToBatteryGet::spm_corefi_tclMsgConnectToBatteryGet()
 {}

tS32 spm_corefi_tclMsgConnectToBatteryGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CONNECTTOBATTERYGET;
}


spm_corefi_tclMsgConnectToBatteryGet::~spm_corefi_tclMsgConnectToBatteryGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgCodeRequestStateSet::spm_corefi_tclMsgCodeRequestStateSet(const spm_corefi_tclMsgCodeRequestStateSet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   CodeRequestState = coRef.CodeRequestState;
}
spm_corefi_tclMsgCodeRequestStateSet& spm_corefi_tclMsgCodeRequestStateSet::operator=(const spm_corefi_tclMsgCodeRequestStateSet& coRef)
{
   if (this == &coRef) return *this;
   CodeRequestState = coRef.CodeRequestState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgCodeRequestStateSet::spm_corefi_tclMsgCodeRequestStateSet()
:CodeRequestState()
 {}

tS32 spm_corefi_tclMsgCodeRequestStateSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CODEREQUESTSTATESET;
}


spm_corefi_tclMsgCodeRequestStateSet::~spm_corefi_tclMsgCodeRequestStateSet()
{}

tU32 spm_corefi_tclMsgCodeRequestStateSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgCodeRequestStateSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CodeRequestState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgCodeRequestStateSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CodeRequestState);
   return oOut;
}

tBool spm_corefi_tclMsgCodeRequestStateSet::operator==(const spm_corefi_tclMsgCodeRequestStateSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CodeRequestState == roRef.CodeRequestState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgCodeRequestStateStatus::spm_corefi_tclMsgCodeRequestStateStatus(const spm_corefi_tclMsgCodeRequestStateStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   CodeRequestState = coRef.CodeRequestState;
}
spm_corefi_tclMsgCodeRequestStateStatus& spm_corefi_tclMsgCodeRequestStateStatus::operator=(const spm_corefi_tclMsgCodeRequestStateStatus& coRef)
{
   if (this == &coRef) return *this;
   CodeRequestState = coRef.CodeRequestState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgCodeRequestStateStatus::spm_corefi_tclMsgCodeRequestStateStatus()
:CodeRequestState()
 {}

tS32 spm_corefi_tclMsgCodeRequestStateStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CODEREQUESTSTATESTATUS;
}


spm_corefi_tclMsgCodeRequestStateStatus::~spm_corefi_tclMsgCodeRequestStateStatus()
{}

tU32 spm_corefi_tclMsgCodeRequestStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgCodeRequestStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CodeRequestState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgCodeRequestStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CodeRequestState);
   return oOut;
}

tBool spm_corefi_tclMsgCodeRequestStateStatus::operator==(const spm_corefi_tclMsgCodeRequestStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CodeRequestState == roRef.CodeRequestState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgCodeRequestStateUpReg::spm_corefi_tclMsgCodeRequestStateUpReg()
 {}

tS32 spm_corefi_tclMsgCodeRequestStateUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CODEREQUESTSTATEUPREG;
}


spm_corefi_tclMsgCodeRequestStateUpReg::~spm_corefi_tclMsgCodeRequestStateUpReg()
{}

//=============================================================================

spm_corefi_tclMsgCodeRequestStateRelUpReg::spm_corefi_tclMsgCodeRequestStateRelUpReg()
 {}

tS32 spm_corefi_tclMsgCodeRequestStateRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CODEREQUESTSTATERELUPREG;
}


spm_corefi_tclMsgCodeRequestStateRelUpReg::~spm_corefi_tclMsgCodeRequestStateRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgCodeRequestStateGet::spm_corefi_tclMsgCodeRequestStateGet()
 {}

tS32 spm_corefi_tclMsgCodeRequestStateGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CODEREQUESTSTATEGET;
}


spm_corefi_tclMsgCodeRequestStateGet::~spm_corefi_tclMsgCodeRequestStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgActiveStartUpSyncPointsStatus::spm_corefi_tclMsgActiveStartUpSyncPointsStatus(const spm_corefi_tclMsgActiveStartUpSyncPointsStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   tStartupSyncPointList = coRef.tStartupSyncPointList;
}
spm_corefi_tclMsgActiveStartUpSyncPointsStatus& spm_corefi_tclMsgActiveStartUpSyncPointsStatus::operator=(const spm_corefi_tclMsgActiveStartUpSyncPointsStatus& coRef)
{
   if (this == &coRef) return *this;
   tStartupSyncPointList = coRef.tStartupSyncPointList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgActiveStartUpSyncPointsStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tStartupSyncPointList.size(); ++u32Idx)
         tStartupSyncPointList[u32Idx].vDestroy();
   tStartupSyncPointList.clear();
   }
}

spm_corefi_tclMsgActiveStartUpSyncPointsStatus::spm_corefi_tclMsgActiveStartUpSyncPointsStatus()

 {}

tS32 spm_corefi_tclMsgActiveStartUpSyncPointsStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ACTIVESTARTUPSYNCPOINTSSTATUS;
}


spm_corefi_tclMsgActiveStartUpSyncPointsStatus::~spm_corefi_tclMsgActiveStartUpSyncPointsStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgActiveStartUpSyncPointsStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < tStartupSyncPointList.size(); ++u32ListIdx)
      u32DynamicSize += tStartupSyncPointList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& spm_corefi_tclMsgActiveStartUpSyncPointsStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tStartupSyncPointList.size(); ++u32Idx)
      {
         tStartupSyncPointList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tStartupSyncPointList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tStartupSyncPointList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgActiveStartUpSyncPointsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tStartupSyncPointList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tStartupSyncPointList.size(); ++u32Idx)
         (tVoid) (oOut << tStartupSyncPointList[u32Idx]);
   }
   return oOut;
}

tBool spm_corefi_tclMsgActiveStartUpSyncPointsStatus::operator==(const spm_corefi_tclMsgActiveStartUpSyncPointsStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tStartupSyncPointList.size() == roRef.tStartupSyncPointList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tStartupSyncPointList.size()); ++u32Idx)
            bResult = bResult && (tStartupSyncPointList[u32Idx] == roRef.tStartupSyncPointList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgActiveStartUpSyncPointsUpReg::spm_corefi_tclMsgActiveStartUpSyncPointsUpReg()
 {}

tS32 spm_corefi_tclMsgActiveStartUpSyncPointsUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ACTIVESTARTUPSYNCPOINTSUPREG;
}


spm_corefi_tclMsgActiveStartUpSyncPointsUpReg::~spm_corefi_tclMsgActiveStartUpSyncPointsUpReg()
{}

//=============================================================================

spm_corefi_tclMsgActiveStartUpSyncPointsRelUpReg::spm_corefi_tclMsgActiveStartUpSyncPointsRelUpReg()
 {}

tS32 spm_corefi_tclMsgActiveStartUpSyncPointsRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ACTIVESTARTUPSYNCPOINTSRELUPREG;
}


spm_corefi_tclMsgActiveStartUpSyncPointsRelUpReg::~spm_corefi_tclMsgActiveStartUpSyncPointsRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgActiveStartUpSyncPointsGet::spm_corefi_tclMsgActiveStartUpSyncPointsGet()
 {}

tS32 spm_corefi_tclMsgActiveStartUpSyncPointsGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ACTIVESTARTUPSYNCPOINTSGET;
}


spm_corefi_tclMsgActiveStartUpSyncPointsGet::~spm_corefi_tclMsgActiveStartUpSyncPointsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgCvmEventStatus::spm_corefi_tclMsgCvmEventStatus(const spm_corefi_tclMsgCvmEventStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   CvmEvent = coRef.CvmEvent;
}
spm_corefi_tclMsgCvmEventStatus& spm_corefi_tclMsgCvmEventStatus::operator=(const spm_corefi_tclMsgCvmEventStatus& coRef)
{
   if (this == &coRef) return *this;
   CvmEvent = coRef.CvmEvent;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgCvmEventStatus::spm_corefi_tclMsgCvmEventStatus()
:CvmEvent()
 {}

tS32 spm_corefi_tclMsgCvmEventStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CVMEVENTSTATUS;
}


spm_corefi_tclMsgCvmEventStatus::~spm_corefi_tclMsgCvmEventStatus()
{}

tU32 spm_corefi_tclMsgCvmEventStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgCvmEventStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CvmEvent);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgCvmEventStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CvmEvent);
   return oOut;
}

tBool spm_corefi_tclMsgCvmEventStatus::operator==(const spm_corefi_tclMsgCvmEventStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CvmEvent == roRef.CvmEvent);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgCvmEventUpReg::spm_corefi_tclMsgCvmEventUpReg()
 {}

tS32 spm_corefi_tclMsgCvmEventUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CVMEVENTUPREG;
}


spm_corefi_tclMsgCvmEventUpReg::~spm_corefi_tclMsgCvmEventUpReg()
{}

//=============================================================================

spm_corefi_tclMsgCvmEventRelUpReg::spm_corefi_tclMsgCvmEventRelUpReg()
 {}

tS32 spm_corefi_tclMsgCvmEventRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CVMEVENTRELUPREG;
}


spm_corefi_tclMsgCvmEventRelUpReg::~spm_corefi_tclMsgCvmEventRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgCvmEventGet::spm_corefi_tclMsgCvmEventGet()
 {}

tS32 spm_corefi_tclMsgCvmEventGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CVMEVENTGET;
}


spm_corefi_tclMsgCvmEventGet::~spm_corefi_tclMsgCvmEventGet()
{}

//=============================================================================

spm_corefi_tclMsgUBatSenseGet::spm_corefi_tclMsgUBatSenseGet()
 {}

tS32 spm_corefi_tclMsgUBatSenseGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_UBATSENSEGET;
}


spm_corefi_tclMsgUBatSenseGet::~spm_corefi_tclMsgUBatSenseGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgUBatSenseStatus::spm_corefi_tclMsgUBatSenseStatus(const spm_corefi_tclMsgUBatSenseStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   UBatSense = coRef.UBatSense;
}
spm_corefi_tclMsgUBatSenseStatus& spm_corefi_tclMsgUBatSenseStatus::operator=(const spm_corefi_tclMsgUBatSenseStatus& coRef)
{
   if (this == &coRef) return *this;
   UBatSense = coRef.UBatSense;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgUBatSenseStatus::spm_corefi_tclMsgUBatSenseStatus()
:UBatSense(0)
 {}

tS32 spm_corefi_tclMsgUBatSenseStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_UBATSENSESTATUS;
}


spm_corefi_tclMsgUBatSenseStatus::~spm_corefi_tclMsgUBatSenseStatus()
{}

tU32 spm_corefi_tclMsgUBatSenseStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& spm_corefi_tclMsgUBatSenseStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UBatSense);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgUBatSenseStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UBatSense);
   return oOut;
}

tBool spm_corefi_tclMsgUBatSenseStatus::operator==(const spm_corefi_tclMsgUBatSenseStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UBatSense == roRef.UBatSense);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgCoproStateSet::spm_corefi_tclMsgCoproStateSet(const spm_corefi_tclMsgCoproStateSet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   CoproState = coRef.CoproState;
}
spm_corefi_tclMsgCoproStateSet& spm_corefi_tclMsgCoproStateSet::operator=(const spm_corefi_tclMsgCoproStateSet& coRef)
{
   if (this == &coRef) return *this;
   CoproState = coRef.CoproState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgCoproStateSet::spm_corefi_tclMsgCoproStateSet()
:CoproState()
 {}

tS32 spm_corefi_tclMsgCoproStateSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_COPROSTATESET;
}


spm_corefi_tclMsgCoproStateSet::~spm_corefi_tclMsgCoproStateSet()
{}

tU32 spm_corefi_tclMsgCoproStateSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgCoproStateSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CoproState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgCoproStateSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CoproState);
   return oOut;
}

tBool spm_corefi_tclMsgCoproStateSet::operator==(const spm_corefi_tclMsgCoproStateSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CoproState == roRef.CoproState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgCoproStateStatus::spm_corefi_tclMsgCoproStateStatus(const spm_corefi_tclMsgCoproStateStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   CoproState = coRef.CoproState;
}
spm_corefi_tclMsgCoproStateStatus& spm_corefi_tclMsgCoproStateStatus::operator=(const spm_corefi_tclMsgCoproStateStatus& coRef)
{
   if (this == &coRef) return *this;
   CoproState = coRef.CoproState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgCoproStateStatus::spm_corefi_tclMsgCoproStateStatus()
:CoproState()
 {}

tS32 spm_corefi_tclMsgCoproStateStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_COPROSTATESTATUS;
}


spm_corefi_tclMsgCoproStateStatus::~spm_corefi_tclMsgCoproStateStatus()
{}

tU32 spm_corefi_tclMsgCoproStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgCoproStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CoproState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgCoproStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CoproState);
   return oOut;
}

tBool spm_corefi_tclMsgCoproStateStatus::operator==(const spm_corefi_tclMsgCoproStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CoproState == roRef.CoproState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgCoproStateUpReg::spm_corefi_tclMsgCoproStateUpReg()
 {}

tS32 spm_corefi_tclMsgCoproStateUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_COPROSTATEUPREG;
}


spm_corefi_tclMsgCoproStateUpReg::~spm_corefi_tclMsgCoproStateUpReg()
{}

//=============================================================================

spm_corefi_tclMsgCoproStateRelUpReg::spm_corefi_tclMsgCoproStateRelUpReg()
 {}

tS32 spm_corefi_tclMsgCoproStateRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_COPROSTATERELUPREG;
}


spm_corefi_tclMsgCoproStateRelUpReg::~spm_corefi_tclMsgCoproStateRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgCoproStateGet::spm_corefi_tclMsgCoproStateGet()
 {}

tS32 spm_corefi_tclMsgCoproStateGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_COPROSTATEGET;
}


spm_corefi_tclMsgCoproStateGet::~spm_corefi_tclMsgCoproStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgDevicePowerOnTimeSet::spm_corefi_tclMsgDevicePowerOnTimeSet(const spm_corefi_tclMsgDevicePowerOnTimeSet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   DevicePowerOnTime = coRef.DevicePowerOnTime;
}
spm_corefi_tclMsgDevicePowerOnTimeSet& spm_corefi_tclMsgDevicePowerOnTimeSet::operator=(const spm_corefi_tclMsgDevicePowerOnTimeSet& coRef)
{
   if (this == &coRef) return *this;
   DevicePowerOnTime = coRef.DevicePowerOnTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgDevicePowerOnTimeSet::spm_corefi_tclMsgDevicePowerOnTimeSet()
:DevicePowerOnTime(0)
 {}

tS32 spm_corefi_tclMsgDevicePowerOnTimeSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DEVICEPOWERONTIMESET;
}


spm_corefi_tclMsgDevicePowerOnTimeSet::~spm_corefi_tclMsgDevicePowerOnTimeSet()
{}

tU32 spm_corefi_tclMsgDevicePowerOnTimeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgDevicePowerOnTimeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DevicePowerOnTime);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgDevicePowerOnTimeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DevicePowerOnTime);
   return oOut;
}

tBool spm_corefi_tclMsgDevicePowerOnTimeSet::operator==(const spm_corefi_tclMsgDevicePowerOnTimeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DevicePowerOnTime == roRef.DevicePowerOnTime);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgDevicePowerOnTimeStatus::spm_corefi_tclMsgDevicePowerOnTimeStatus(const spm_corefi_tclMsgDevicePowerOnTimeStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   DevicePowerOnTime = coRef.DevicePowerOnTime;
}
spm_corefi_tclMsgDevicePowerOnTimeStatus& spm_corefi_tclMsgDevicePowerOnTimeStatus::operator=(const spm_corefi_tclMsgDevicePowerOnTimeStatus& coRef)
{
   if (this == &coRef) return *this;
   DevicePowerOnTime = coRef.DevicePowerOnTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgDevicePowerOnTimeStatus::spm_corefi_tclMsgDevicePowerOnTimeStatus()
:DevicePowerOnTime(0)
 {}

tS32 spm_corefi_tclMsgDevicePowerOnTimeStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DEVICEPOWERONTIMESTATUS;
}


spm_corefi_tclMsgDevicePowerOnTimeStatus::~spm_corefi_tclMsgDevicePowerOnTimeStatus()
{}

tU32 spm_corefi_tclMsgDevicePowerOnTimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgDevicePowerOnTimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DevicePowerOnTime);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgDevicePowerOnTimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DevicePowerOnTime);
   return oOut;
}

tBool spm_corefi_tclMsgDevicePowerOnTimeStatus::operator==(const spm_corefi_tclMsgDevicePowerOnTimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DevicePowerOnTime == roRef.DevicePowerOnTime);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgDevicePowerOnTimeGet::spm_corefi_tclMsgDevicePowerOnTimeGet()
 {}

tS32 spm_corefi_tclMsgDevicePowerOnTimeGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DEVICEPOWERONTIMEGET;
}


spm_corefi_tclMsgDevicePowerOnTimeGet::~spm_corefi_tclMsgDevicePowerOnTimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgLastSystemRuntimeStatus::spm_corefi_tclMsgLastSystemRuntimeStatus(const spm_corefi_tclMsgLastSystemRuntimeStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   u32RunTime = coRef.u32RunTime;
}
spm_corefi_tclMsgLastSystemRuntimeStatus& spm_corefi_tclMsgLastSystemRuntimeStatus::operator=(const spm_corefi_tclMsgLastSystemRuntimeStatus& coRef)
{
   if (this == &coRef) return *this;
   u32RunTime = coRef.u32RunTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgLastSystemRuntimeStatus::spm_corefi_tclMsgLastSystemRuntimeStatus()
:u32RunTime(0)
 {}

tS32 spm_corefi_tclMsgLastSystemRuntimeStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_LASTSYSTEMRUNTIMESTATUS;
}


spm_corefi_tclMsgLastSystemRuntimeStatus::~spm_corefi_tclMsgLastSystemRuntimeStatus()
{}

tU32 spm_corefi_tclMsgLastSystemRuntimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgLastSystemRuntimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32RunTime);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgLastSystemRuntimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32RunTime);
   return oOut;
}

tBool spm_corefi_tclMsgLastSystemRuntimeStatus::operator==(const spm_corefi_tclMsgLastSystemRuntimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32RunTime == roRef.u32RunTime);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgLastSystemRuntimeGet::spm_corefi_tclMsgLastSystemRuntimeGet()
 {}

tS32 spm_corefi_tclMsgLastSystemRuntimeGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_LASTSYSTEMRUNTIMEGET;
}


spm_corefi_tclMsgLastSystemRuntimeGet::~spm_corefi_tclMsgLastSystemRuntimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgCurrentSystemRuntimeStatus::spm_corefi_tclMsgCurrentSystemRuntimeStatus(const spm_corefi_tclMsgCurrentSystemRuntimeStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   u32RunTime = coRef.u32RunTime;
}
spm_corefi_tclMsgCurrentSystemRuntimeStatus& spm_corefi_tclMsgCurrentSystemRuntimeStatus::operator=(const spm_corefi_tclMsgCurrentSystemRuntimeStatus& coRef)
{
   if (this == &coRef) return *this;
   u32RunTime = coRef.u32RunTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgCurrentSystemRuntimeStatus::spm_corefi_tclMsgCurrentSystemRuntimeStatus()
:u32RunTime(0)
 {}

tS32 spm_corefi_tclMsgCurrentSystemRuntimeStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CURRENTSYSTEMRUNTIMESTATUS;
}


spm_corefi_tclMsgCurrentSystemRuntimeStatus::~spm_corefi_tclMsgCurrentSystemRuntimeStatus()
{}

tU32 spm_corefi_tclMsgCurrentSystemRuntimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgCurrentSystemRuntimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32RunTime);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgCurrentSystemRuntimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32RunTime);
   return oOut;
}

tBool spm_corefi_tclMsgCurrentSystemRuntimeStatus::operator==(const spm_corefi_tclMsgCurrentSystemRuntimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32RunTime == roRef.u32RunTime);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgCurrentSystemRuntimeGet::spm_corefi_tclMsgCurrentSystemRuntimeGet()
 {}

tS32 spm_corefi_tclMsgCurrentSystemRuntimeGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CURRENTSYSTEMRUNTIMEGET;
}


spm_corefi_tclMsgCurrentSystemRuntimeGet::~spm_corefi_tclMsgCurrentSystemRuntimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgResetListSet::spm_corefi_tclMsgResetListSet(const spm_corefi_tclMsgResetListSet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   ResetResetList = coRef.ResetResetList;
}
spm_corefi_tclMsgResetListSet& spm_corefi_tclMsgResetListSet::operator=(const spm_corefi_tclMsgResetListSet& coRef)
{
   if (this == &coRef) return *this;
   ResetResetList = coRef.ResetResetList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgResetListSet::spm_corefi_tclMsgResetListSet()
:ResetResetList(0)
 {}

tS32 spm_corefi_tclMsgResetListSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RESETLISTSET;
}


spm_corefi_tclMsgResetListSet::~spm_corefi_tclMsgResetListSet()
{}

tU32 spm_corefi_tclMsgResetListSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgResetListSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResetResetList);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgResetListSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResetResetList);
   return oOut;
}

tBool spm_corefi_tclMsgResetListSet::operator==(const spm_corefi_tclMsgResetListSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResetResetList == roRef.ResetResetList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgResetListStatus::spm_corefi_tclMsgResetListStatus(const spm_corefi_tclMsgResetListStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   LastResetReason = coRef.LastResetReason;
   DateHour = coRef.DateHour;
   DateMinute = coRef.DateMinute;
   DateDay = coRef.DateDay;
   DateMonth = coRef.DateMonth;
   DateYear = coRef.DateYear;
   CoproResetByHmi = coRef.CoproResetByHmi;
   CoproResetByUndervoltage = coRef.CoproResetByUndervoltage;
   HmiResetByCoproStartup = coRef.HmiResetByCoproStartup;
   HmiResetByCoproRun = coRef.HmiResetByCoproRun;
   HmiResetByCoproShutdown = coRef.HmiResetByCoproShutdown;
   HmiResetByHmiWdg = coRef.HmiResetByHmiWdg;
   HmiResetByHmiApp = coRef.HmiResetByHmiApp;
   HmiResetByHmiException = coRef.HmiResetByHmiException;
   HmiResetByHmiExtern = coRef.HmiResetByHmiExtern;
   HmiResetByHmiDownload = coRef.HmiResetByHmiDownload;
   HmiResetByHmiDiag = coRef.HmiResetByHmiDiag;
   FgsResetByHmi = coRef.FgsResetByHmi;
}
spm_corefi_tclMsgResetListStatus& spm_corefi_tclMsgResetListStatus::operator=(const spm_corefi_tclMsgResetListStatus& coRef)
{
   if (this == &coRef) return *this;
   LastResetReason = coRef.LastResetReason;
   DateHour = coRef.DateHour;
   DateMinute = coRef.DateMinute;
   DateDay = coRef.DateDay;
   DateMonth = coRef.DateMonth;
   DateYear = coRef.DateYear;
   CoproResetByHmi = coRef.CoproResetByHmi;
   CoproResetByUndervoltage = coRef.CoproResetByUndervoltage;
   HmiResetByCoproStartup = coRef.HmiResetByCoproStartup;
   HmiResetByCoproRun = coRef.HmiResetByCoproRun;
   HmiResetByCoproShutdown = coRef.HmiResetByCoproShutdown;
   HmiResetByHmiWdg = coRef.HmiResetByHmiWdg;
   HmiResetByHmiApp = coRef.HmiResetByHmiApp;
   HmiResetByHmiException = coRef.HmiResetByHmiException;
   HmiResetByHmiExtern = coRef.HmiResetByHmiExtern;
   HmiResetByHmiDownload = coRef.HmiResetByHmiDownload;
   HmiResetByHmiDiag = coRef.HmiResetByHmiDiag;
   FgsResetByHmi = coRef.FgsResetByHmi;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgResetListStatus::spm_corefi_tclMsgResetListStatus()
:LastResetReason()
,DateHour(0)
,DateMinute(0)
,DateDay(0)
,DateMonth(0)
,DateYear(0)
,CoproResetByHmi(0)
,CoproResetByUndervoltage(0)
,HmiResetByCoproStartup(0)
,HmiResetByCoproRun(0)
,HmiResetByCoproShutdown(0)
,HmiResetByHmiWdg(0)
,HmiResetByHmiApp(0)
,HmiResetByHmiException(0)
,HmiResetByHmiExtern(0)
,HmiResetByHmiDownload(0)
,HmiResetByHmiDiag(0)
,FgsResetByHmi(0)
 {}

tS32 spm_corefi_tclMsgResetListStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RESETLISTSTATUS;
}


spm_corefi_tclMsgResetListStatus::~spm_corefi_tclMsgResetListStatus()
{}

tU32 spm_corefi_tclMsgResetListStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 19;
}

fi_tclInContext& spm_corefi_tclMsgResetListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LastResetReason);
   (tVoid) (oIn >> DateHour);
   (tVoid) (oIn >> DateMinute);
   (tVoid) (oIn >> DateDay);
   (tVoid) (oIn >> DateMonth);
   (tVoid) (oIn >> DateYear);
   (tVoid) (oIn >> CoproResetByHmi);
   (tVoid) (oIn >> CoproResetByUndervoltage);
   (tVoid) (oIn >> HmiResetByCoproStartup);
   (tVoid) (oIn >> HmiResetByCoproRun);
   (tVoid) (oIn >> HmiResetByCoproShutdown);
   (tVoid) (oIn >> HmiResetByHmiWdg);
   (tVoid) (oIn >> HmiResetByHmiApp);
   (tVoid) (oIn >> HmiResetByHmiException);
   (tVoid) (oIn >> HmiResetByHmiExtern);
   (tVoid) (oIn >> HmiResetByHmiDownload);
   (tVoid) (oIn >> HmiResetByHmiDiag);
   (tVoid) (oIn >> FgsResetByHmi);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgResetListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LastResetReason);
   (tVoid) (oOut << DateHour);
   (tVoid) (oOut << DateMinute);
   (tVoid) (oOut << DateDay);
   (tVoid) (oOut << DateMonth);
   (tVoid) (oOut << DateYear);
   (tVoid) (oOut << CoproResetByHmi);
   (tVoid) (oOut << CoproResetByUndervoltage);
   (tVoid) (oOut << HmiResetByCoproStartup);
   (tVoid) (oOut << HmiResetByCoproRun);
   (tVoid) (oOut << HmiResetByCoproShutdown);
   (tVoid) (oOut << HmiResetByHmiWdg);
   (tVoid) (oOut << HmiResetByHmiApp);
   (tVoid) (oOut << HmiResetByHmiException);
   (tVoid) (oOut << HmiResetByHmiExtern);
   (tVoid) (oOut << HmiResetByHmiDownload);
   (tVoid) (oOut << HmiResetByHmiDiag);
   (tVoid) (oOut << FgsResetByHmi);
   return oOut;
}

tBool spm_corefi_tclMsgResetListStatus::operator==(const spm_corefi_tclMsgResetListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LastResetReason == roRef.LastResetReason);
   bResult = bResult && (DateHour == roRef.DateHour);
   bResult = bResult && (DateMinute == roRef.DateMinute);
   bResult = bResult && (DateDay == roRef.DateDay);
   bResult = bResult && (DateMonth == roRef.DateMonth);
   bResult = bResult && (DateYear == roRef.DateYear);
   bResult = bResult && (CoproResetByHmi == roRef.CoproResetByHmi);
   bResult = bResult && (CoproResetByUndervoltage == roRef.CoproResetByUndervoltage);
   bResult = bResult && (HmiResetByCoproStartup == roRef.HmiResetByCoproStartup);
   bResult = bResult && (HmiResetByCoproRun == roRef.HmiResetByCoproRun);
   bResult = bResult && (HmiResetByCoproShutdown == roRef.HmiResetByCoproShutdown);
   bResult = bResult && (HmiResetByHmiWdg == roRef.HmiResetByHmiWdg);
   bResult = bResult && (HmiResetByHmiApp == roRef.HmiResetByHmiApp);
   bResult = bResult && (HmiResetByHmiException == roRef.HmiResetByHmiException);
   bResult = bResult && (HmiResetByHmiExtern == roRef.HmiResetByHmiExtern);
   bResult = bResult && (HmiResetByHmiDownload == roRef.HmiResetByHmiDownload);
   bResult = bResult && (HmiResetByHmiDiag == roRef.HmiResetByHmiDiag);
   bResult = bResult && (FgsResetByHmi == roRef.FgsResetByHmi);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgResetListGet::spm_corefi_tclMsgResetListGet()
 {}

tS32 spm_corefi_tclMsgResetListGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RESETLISTGET;
}


spm_corefi_tclMsgResetListGet::~spm_corefi_tclMsgResetListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgResetCounterSet::spm_corefi_tclMsgResetCounterSet(const spm_corefi_tclMsgResetCounterSet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   ResetCounter = coRef.ResetCounter;
}
spm_corefi_tclMsgResetCounterSet& spm_corefi_tclMsgResetCounterSet::operator=(const spm_corefi_tclMsgResetCounterSet& coRef)
{
   if (this == &coRef) return *this;
   ResetCounter = coRef.ResetCounter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgResetCounterSet::spm_corefi_tclMsgResetCounterSet()
:ResetCounter(0)
 {}

tS32 spm_corefi_tclMsgResetCounterSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RESETCOUNTERSET;
}


spm_corefi_tclMsgResetCounterSet::~spm_corefi_tclMsgResetCounterSet()
{}

tU32 spm_corefi_tclMsgResetCounterSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgResetCounterSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResetCounter);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgResetCounterSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResetCounter);
   return oOut;
}

tBool spm_corefi_tclMsgResetCounterSet::operator==(const spm_corefi_tclMsgResetCounterSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResetCounter == roRef.ResetCounter);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgResetCounterStatus::spm_corefi_tclMsgResetCounterStatus(const spm_corefi_tclMsgResetCounterStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   tLastResetDate = coRef.tLastResetDate;
   tLastResetReason = coRef.tLastResetReason;
   u32ApApplicationError = coRef.u32ApApplicationError;
   u32ApSoftware = coRef.u32ApSoftware;
   u32ApEcuReset = coRef.u32ApEcuReset;
   u32ApDownload = coRef.u32ApDownload;
   u32ApDownloadError = coRef.u32ApDownloadError;
   u32ApOvertemperature = coRef.u32ApOvertemperature;
   u32ApUser = coRef.u32ApUser;
   u32ApLcmIntern = coRef.u32ApLcmIntern;
   u32ApWarmstartCount = coRef.u32ApWarmstartCount;
   u32ApPowerOnCount = coRef.u32ApPowerOnCount;
   u32ApPowerLossCount = coRef.u32ApPowerLossCount;
   u32ApPowerOffCount = coRef.u32ApPowerOffCount;
   u32ApSccCount = coRef.u32ApSccCount;
   u32ApUnknownCount = coRef.u32ApUnknownCount;
   u32SccHwWdtCount = coRef.u32SccHwWdtCount;
   u32SccPowerOnCount = coRef.u32SccPowerOnCount;
   u32SccColdstartCount = coRef.u32SccColdstartCount;
   u32SccAppmodeChangeCount = coRef.u32SccAppmodeChangeCount;
   u32SccDuringLpwCount = coRef.u32SccDuringLpwCount;
   u32SccDuringPllOszCount = coRef.u32SccDuringPllOszCount;
   u32SccDuringSWCount = coRef.u32SccDuringSWCount;
   u32SccWarmstartCount = coRef.u32SccWarmstartCount;
}
spm_corefi_tclMsgResetCounterStatus& spm_corefi_tclMsgResetCounterStatus::operator=(const spm_corefi_tclMsgResetCounterStatus& coRef)
{
   if (this == &coRef) return *this;
   tLastResetDate = coRef.tLastResetDate;
   tLastResetReason = coRef.tLastResetReason;
   u32ApApplicationError = coRef.u32ApApplicationError;
   u32ApSoftware = coRef.u32ApSoftware;
   u32ApEcuReset = coRef.u32ApEcuReset;
   u32ApDownload = coRef.u32ApDownload;
   u32ApDownloadError = coRef.u32ApDownloadError;
   u32ApOvertemperature = coRef.u32ApOvertemperature;
   u32ApUser = coRef.u32ApUser;
   u32ApLcmIntern = coRef.u32ApLcmIntern;
   u32ApWarmstartCount = coRef.u32ApWarmstartCount;
   u32ApPowerOnCount = coRef.u32ApPowerOnCount;
   u32ApPowerLossCount = coRef.u32ApPowerLossCount;
   u32ApPowerOffCount = coRef.u32ApPowerOffCount;
   u32ApSccCount = coRef.u32ApSccCount;
   u32ApUnknownCount = coRef.u32ApUnknownCount;
   u32SccHwWdtCount = coRef.u32SccHwWdtCount;
   u32SccPowerOnCount = coRef.u32SccPowerOnCount;
   u32SccColdstartCount = coRef.u32SccColdstartCount;
   u32SccAppmodeChangeCount = coRef.u32SccAppmodeChangeCount;
   u32SccDuringLpwCount = coRef.u32SccDuringLpwCount;
   u32SccDuringPllOszCount = coRef.u32SccDuringPllOszCount;
   u32SccDuringSWCount = coRef.u32SccDuringSWCount;
   u32SccWarmstartCount = coRef.u32SccWarmstartCount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgResetCounterStatus::spm_corefi_tclMsgResetCounterStatus()
:tLastResetDate()
,tLastResetReason()
,u32ApApplicationError(0)
,u32ApSoftware(0)
,u32ApEcuReset(0)
,u32ApDownload(0)
,u32ApDownloadError(0)
,u32ApOvertemperature(0)
,u32ApUser(0)
,u32ApLcmIntern(0)
,u32ApWarmstartCount(0)
,u32ApPowerOnCount(0)
,u32ApPowerLossCount(0)
,u32ApPowerOffCount(0)
,u32ApSccCount(0)
,u32ApUnknownCount(0)
,u32SccHwWdtCount(0)
,u32SccPowerOnCount(0)
,u32SccColdstartCount(0)
,u32SccAppmodeChangeCount(0)
,u32SccDuringLpwCount(0)
,u32SccDuringPllOszCount(0)
,u32SccDuringSWCount(0)
,u32SccWarmstartCount(0)
 {}

tS32 spm_corefi_tclMsgResetCounterStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RESETCOUNTERSTATUS;
}


spm_corefi_tclMsgResetCounterStatus::~spm_corefi_tclMsgResetCounterStatus()
{}

tU32 spm_corefi_tclMsgResetCounterStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 96;
}

fi_tclInContext& spm_corefi_tclMsgResetCounterStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tLastResetDate);
   (tVoid) (oIn >> tLastResetReason);
   (tVoid) (oIn >> u32ApApplicationError);
   (tVoid) (oIn >> u32ApSoftware);
   (tVoid) (oIn >> u32ApEcuReset);
   (tVoid) (oIn >> u32ApDownload);
   (tVoid) (oIn >> u32ApDownloadError);
   (tVoid) (oIn >> u32ApOvertemperature);
   (tVoid) (oIn >> u32ApUser);
   (tVoid) (oIn >> u32ApLcmIntern);
   (tVoid) (oIn >> u32ApWarmstartCount);
   (tVoid) (oIn >> u32ApPowerOnCount);
   (tVoid) (oIn >> u32ApPowerLossCount);
   (tVoid) (oIn >> u32ApPowerOffCount);
   (tVoid) (oIn >> u32ApSccCount);
   (tVoid) (oIn >> u32ApUnknownCount);
   (tVoid) (oIn >> u32SccHwWdtCount);
   (tVoid) (oIn >> u32SccPowerOnCount);
   (tVoid) (oIn >> u32SccColdstartCount);
   (tVoid) (oIn >> u32SccAppmodeChangeCount);
   (tVoid) (oIn >> u32SccDuringLpwCount);
   (tVoid) (oIn >> u32SccDuringPllOszCount);
   (tVoid) (oIn >> u32SccDuringSWCount);
   (tVoid) (oIn >> u32SccWarmstartCount);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgResetCounterStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tLastResetDate);
   (tVoid) (oOut << tLastResetReason);
   (tVoid) (oOut << u32ApApplicationError);
   (tVoid) (oOut << u32ApSoftware);
   (tVoid) (oOut << u32ApEcuReset);
   (tVoid) (oOut << u32ApDownload);
   (tVoid) (oOut << u32ApDownloadError);
   (tVoid) (oOut << u32ApOvertemperature);
   (tVoid) (oOut << u32ApUser);
   (tVoid) (oOut << u32ApLcmIntern);
   (tVoid) (oOut << u32ApWarmstartCount);
   (tVoid) (oOut << u32ApPowerOnCount);
   (tVoid) (oOut << u32ApPowerLossCount);
   (tVoid) (oOut << u32ApPowerOffCount);
   (tVoid) (oOut << u32ApSccCount);
   (tVoid) (oOut << u32ApUnknownCount);
   (tVoid) (oOut << u32SccHwWdtCount);
   (tVoid) (oOut << u32SccPowerOnCount);
   (tVoid) (oOut << u32SccColdstartCount);
   (tVoid) (oOut << u32SccAppmodeChangeCount);
   (tVoid) (oOut << u32SccDuringLpwCount);
   (tVoid) (oOut << u32SccDuringPllOszCount);
   (tVoid) (oOut << u32SccDuringSWCount);
   (tVoid) (oOut << u32SccWarmstartCount);
   return oOut;
}

tBool spm_corefi_tclMsgResetCounterStatus::operator==(const spm_corefi_tclMsgResetCounterStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tLastResetDate == roRef.tLastResetDate);
   bResult = bResult && (tLastResetReason == roRef.tLastResetReason);
   bResult = bResult && (u32ApApplicationError == roRef.u32ApApplicationError);
   bResult = bResult && (u32ApSoftware == roRef.u32ApSoftware);
   bResult = bResult && (u32ApEcuReset == roRef.u32ApEcuReset);
   bResult = bResult && (u32ApDownload == roRef.u32ApDownload);
   bResult = bResult && (u32ApDownloadError == roRef.u32ApDownloadError);
   bResult = bResult && (u32ApOvertemperature == roRef.u32ApOvertemperature);
   bResult = bResult && (u32ApUser == roRef.u32ApUser);
   bResult = bResult && (u32ApLcmIntern == roRef.u32ApLcmIntern);
   bResult = bResult && (u32ApWarmstartCount == roRef.u32ApWarmstartCount);
   bResult = bResult && (u32ApPowerOnCount == roRef.u32ApPowerOnCount);
   bResult = bResult && (u32ApPowerLossCount == roRef.u32ApPowerLossCount);
   bResult = bResult && (u32ApPowerOffCount == roRef.u32ApPowerOffCount);
   bResult = bResult && (u32ApSccCount == roRef.u32ApSccCount);
   bResult = bResult && (u32ApUnknownCount == roRef.u32ApUnknownCount);
   bResult = bResult && (u32SccHwWdtCount == roRef.u32SccHwWdtCount);
   bResult = bResult && (u32SccPowerOnCount == roRef.u32SccPowerOnCount);
   bResult = bResult && (u32SccColdstartCount == roRef.u32SccColdstartCount);
   bResult = bResult && (u32SccAppmodeChangeCount == roRef.u32SccAppmodeChangeCount);
   bResult = bResult && (u32SccDuringLpwCount == roRef.u32SccDuringLpwCount);
   bResult = bResult && (u32SccDuringPllOszCount == roRef.u32SccDuringPllOszCount);
   bResult = bResult && (u32SccDuringSWCount == roRef.u32SccDuringSWCount);
   bResult = bResult && (u32SccWarmstartCount == roRef.u32SccWarmstartCount);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgResetCounterUpReg::spm_corefi_tclMsgResetCounterUpReg()
 {}

tS32 spm_corefi_tclMsgResetCounterUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RESETCOUNTERUPREG;
}


spm_corefi_tclMsgResetCounterUpReg::~spm_corefi_tclMsgResetCounterUpReg()
{}

//=============================================================================

spm_corefi_tclMsgResetCounterRelUpReg::spm_corefi_tclMsgResetCounterRelUpReg()
 {}

tS32 spm_corefi_tclMsgResetCounterRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RESETCOUNTERRELUPREG;
}


spm_corefi_tclMsgResetCounterRelUpReg::~spm_corefi_tclMsgResetCounterRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgResetCounterGet::spm_corefi_tclMsgResetCounterGet()
 {}

tS32 spm_corefi_tclMsgResetCounterGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RESETCOUNTERGET;
}


spm_corefi_tclMsgResetCounterGet::~spm_corefi_tclMsgResetCounterGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgTransportModeListSet::spm_corefi_tclMsgTransportModeListSet(const spm_corefi_tclMsgTransportModeListSet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   TransPortList = coRef.TransPortList;
}
spm_corefi_tclMsgTransportModeListSet& spm_corefi_tclMsgTransportModeListSet::operator=(const spm_corefi_tclMsgTransportModeListSet& coRef)
{
   if (this == &coRef) return *this;
   TransPortList = coRef.TransPortList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgTransportModeListSet::spm_corefi_tclMsgTransportModeListSet()
:TransPortList(0)
 {}

tS32 spm_corefi_tclMsgTransportModeListSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_TRANSPORTMODELISTSET;
}


spm_corefi_tclMsgTransportModeListSet::~spm_corefi_tclMsgTransportModeListSet()
{}

tU32 spm_corefi_tclMsgTransportModeListSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgTransportModeListSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TransPortList);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgTransportModeListSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TransPortList);
   return oOut;
}

tBool spm_corefi_tclMsgTransportModeListSet::operator==(const spm_corefi_tclMsgTransportModeListSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TransPortList == roRef.TransPortList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgTransportModeListStatus::spm_corefi_tclMsgTransportModeListStatus(const spm_corefi_tclMsgTransportModeListStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   TransportModeList = coRef.TransportModeList;
}
spm_corefi_tclMsgTransportModeListStatus& spm_corefi_tclMsgTransportModeListStatus::operator=(const spm_corefi_tclMsgTransportModeListStatus& coRef)
{
   if (this == &coRef) return *this;
   TransportModeList = coRef.TransportModeList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgTransportModeListStatus::vDestroy()
{
   TransportModeList.vDestroy(); 
}

spm_corefi_tclMsgTransportModeListStatus::spm_corefi_tclMsgTransportModeListStatus()
:TransportModeList()
 {}

tS32 spm_corefi_tclMsgTransportModeListStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_TRANSPORTMODELISTSTATUS;
}


spm_corefi_tclMsgTransportModeListStatus::~spm_corefi_tclMsgTransportModeListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgTransportModeListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TransportModeList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_corefi_tclMsgTransportModeListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TransportModeList);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgTransportModeListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TransportModeList);
   return oOut;
}

tBool spm_corefi_tclMsgTransportModeListStatus::operator==(const spm_corefi_tclMsgTransportModeListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TransportModeList == roRef.TransportModeList);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgTransportModeListGet::spm_corefi_tclMsgTransportModeListGet()
 {}

tS32 spm_corefi_tclMsgTransportModeListGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_TRANSPORTMODELISTGET;
}


spm_corefi_tclMsgTransportModeListGet::~spm_corefi_tclMsgTransportModeListGet()
{}

//=============================================================================

spm_corefi_tclMsgResetHistorySet::spm_corefi_tclMsgResetHistorySet()
 {}

tS32 spm_corefi_tclMsgResetHistorySet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RESETHISTORYSET;
}


spm_corefi_tclMsgResetHistorySet::~spm_corefi_tclMsgResetHistorySet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgResetHistoryStatus::spm_corefi_tclMsgResetHistoryStatus(const spm_corefi_tclMsgResetHistoryStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   tResetList = coRef.tResetList;
}
spm_corefi_tclMsgResetHistoryStatus& spm_corefi_tclMsgResetHistoryStatus::operator=(const spm_corefi_tclMsgResetHistoryStatus& coRef)
{
   if (this == &coRef) return *this;
   tResetList = coRef.tResetList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgResetHistoryStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tResetList.size(); ++u32Idx)
         tResetList[u32Idx].vDestroy();
   tResetList.clear();
   }
}

spm_corefi_tclMsgResetHistoryStatus::spm_corefi_tclMsgResetHistoryStatus()

 {}

tS32 spm_corefi_tclMsgResetHistoryStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RESETHISTORYSTATUS;
}


spm_corefi_tclMsgResetHistoryStatus::~spm_corefi_tclMsgResetHistoryStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgResetHistoryStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < tResetList.size(); ++u32ListIdx)
      u32DynamicSize += tResetList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& spm_corefi_tclMsgResetHistoryStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tResetList.size(); ++u32Idx)
      {
         tResetList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tResetList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tResetList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgResetHistoryStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tResetList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tResetList.size(); ++u32Idx)
         (tVoid) (oOut << tResetList[u32Idx]);
   }
   return oOut;
}

tBool spm_corefi_tclMsgResetHistoryStatus::operator==(const spm_corefi_tclMsgResetHistoryStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tResetList.size() == roRef.tResetList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tResetList.size()); ++u32Idx)
            bResult = bResult && (tResetList[u32Idx] == roRef.tResetList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgResetHistoryGet::spm_corefi_tclMsgResetHistoryGet()
 {}

tS32 spm_corefi_tclMsgResetHistoryGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RESETHISTORYGET;
}


spm_corefi_tclMsgResetHistoryGet::~spm_corefi_tclMsgResetHistoryGet()
{}

//=============================================================================

spm_corefi_tclMsgWakeupHistorySet::spm_corefi_tclMsgWakeupHistorySet()
 {}

tS32 spm_corefi_tclMsgWakeupHistorySet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_WAKEUPHISTORYSET;
}


spm_corefi_tclMsgWakeupHistorySet::~spm_corefi_tclMsgWakeupHistorySet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgWakeupHistoryStatus::spm_corefi_tclMsgWakeupHistoryStatus(const spm_corefi_tclMsgWakeupHistoryStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   tWakeupList = coRef.tWakeupList;
}
spm_corefi_tclMsgWakeupHistoryStatus& spm_corefi_tclMsgWakeupHistoryStatus::operator=(const spm_corefi_tclMsgWakeupHistoryStatus& coRef)
{
   if (this == &coRef) return *this;
   tWakeupList = coRef.tWakeupList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgWakeupHistoryStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tWakeupList.size(); ++u32Idx)
         tWakeupList[u32Idx].vDestroy();
   tWakeupList.clear();
   }
}

spm_corefi_tclMsgWakeupHistoryStatus::spm_corefi_tclMsgWakeupHistoryStatus()

 {}

tS32 spm_corefi_tclMsgWakeupHistoryStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_WAKEUPHISTORYSTATUS;
}


spm_corefi_tclMsgWakeupHistoryStatus::~spm_corefi_tclMsgWakeupHistoryStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgWakeupHistoryStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(tWakeupList.size()*11);
}

fi_tclInContext& spm_corefi_tclMsgWakeupHistoryStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tWakeupList.size(); ++u32Idx)
      {
         tWakeupList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tWakeupList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tWakeupList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgWakeupHistoryStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tWakeupList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tWakeupList.size(); ++u32Idx)
         (tVoid) (oOut << tWakeupList[u32Idx]);
   }
   return oOut;
}

tBool spm_corefi_tclMsgWakeupHistoryStatus::operator==(const spm_corefi_tclMsgWakeupHistoryStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tWakeupList.size() == roRef.tWakeupList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tWakeupList.size()); ++u32Idx)
            bResult = bResult && (tWakeupList[u32Idx] == roRef.tWakeupList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgWakeupHistoryGet::spm_corefi_tclMsgWakeupHistoryGet()
 {}

tS32 spm_corefi_tclMsgWakeupHistoryGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_WAKEUPHISTORYGET;
}


spm_corefi_tclMsgWakeupHistoryGet::~spm_corefi_tclMsgWakeupHistoryGet()
{}

//=============================================================================

spm_corefi_tclMsgStateHistorySet::spm_corefi_tclMsgStateHistorySet()
 {}

tS32 spm_corefi_tclMsgStateHistorySet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_STATEHISTORYSET;
}


spm_corefi_tclMsgStateHistorySet::~spm_corefi_tclMsgStateHistorySet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgStateHistoryStatus::spm_corefi_tclMsgStateHistoryStatus(const spm_corefi_tclMsgStateHistoryStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   tStateList = coRef.tStateList;
}
spm_corefi_tclMsgStateHistoryStatus& spm_corefi_tclMsgStateHistoryStatus::operator=(const spm_corefi_tclMsgStateHistoryStatus& coRef)
{
   if (this == &coRef) return *this;
   tStateList = coRef.tStateList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgStateHistoryStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
         tStateList[u32Idx].vDestroy();
   tStateList.clear();
   }
}

spm_corefi_tclMsgStateHistoryStatus::spm_corefi_tclMsgStateHistoryStatus()

 {}

tS32 spm_corefi_tclMsgStateHistoryStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_STATEHISTORYSTATUS;
}


spm_corefi_tclMsgStateHistoryStatus::~spm_corefi_tclMsgStateHistoryStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgStateHistoryStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(tStateList.size()*49);
}

fi_tclInContext& spm_corefi_tclMsgStateHistoryStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
      {
         tStateList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tStateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tStateList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgStateHistoryStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tStateList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
         (tVoid) (oOut << tStateList[u32Idx]);
   }
   return oOut;
}

tBool spm_corefi_tclMsgStateHistoryStatus::operator==(const spm_corefi_tclMsgStateHistoryStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tStateList.size() == roRef.tStateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tStateList.size()); ++u32Idx)
            bResult = bResult && (tStateList[u32Idx] == roRef.tStateList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgStateHistoryGet::spm_corefi_tclMsgStateHistoryGet()
 {}

tS32 spm_corefi_tclMsgStateHistoryGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_STATEHISTORYGET;
}


spm_corefi_tclMsgStateHistoryGet::~spm_corefi_tclMsgStateHistoryGet()
{}

//=============================================================================

spm_corefi_tclMsgErrStateHistory01Set::spm_corefi_tclMsgErrStateHistory01Set()
 {}

tS32 spm_corefi_tclMsgErrStateHistory01Set::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY01SET;
}


spm_corefi_tclMsgErrStateHistory01Set::~spm_corefi_tclMsgErrStateHistory01Set()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgErrStateHistory01Status::spm_corefi_tclMsgErrStateHistory01Status(const spm_corefi_tclMsgErrStateHistory01Status& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   tStateList = coRef.tStateList;
}
spm_corefi_tclMsgErrStateHistory01Status& spm_corefi_tclMsgErrStateHistory01Status::operator=(const spm_corefi_tclMsgErrStateHistory01Status& coRef)
{
   if (this == &coRef) return *this;
   tStateList = coRef.tStateList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgErrStateHistory01Status::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
         tStateList[u32Idx].vDestroy();
   tStateList.clear();
   }
}

spm_corefi_tclMsgErrStateHistory01Status::spm_corefi_tclMsgErrStateHistory01Status()

 {}

tS32 spm_corefi_tclMsgErrStateHistory01Status::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY01STATUS;
}


spm_corefi_tclMsgErrStateHistory01Status::~spm_corefi_tclMsgErrStateHistory01Status()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgErrStateHistory01Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(tStateList.size()*49);
}

fi_tclInContext& spm_corefi_tclMsgErrStateHistory01Status::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
      {
         tStateList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tStateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tStateList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgErrStateHistory01Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tStateList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
         (tVoid) (oOut << tStateList[u32Idx]);
   }
   return oOut;
}

tBool spm_corefi_tclMsgErrStateHistory01Status::operator==(const spm_corefi_tclMsgErrStateHistory01Status& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tStateList.size() == roRef.tStateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tStateList.size()); ++u32Idx)
            bResult = bResult && (tStateList[u32Idx] == roRef.tStateList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgErrStateHistory01Get::spm_corefi_tclMsgErrStateHistory01Get()
 {}

tS32 spm_corefi_tclMsgErrStateHistory01Get::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY01GET;
}


spm_corefi_tclMsgErrStateHistory01Get::~spm_corefi_tclMsgErrStateHistory01Get()
{}

//=============================================================================

spm_corefi_tclMsgErrStateHistory02Set::spm_corefi_tclMsgErrStateHistory02Set()
 {}

tS32 spm_corefi_tclMsgErrStateHistory02Set::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY02SET;
}


spm_corefi_tclMsgErrStateHistory02Set::~spm_corefi_tclMsgErrStateHistory02Set()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgErrStateHistory02Status::spm_corefi_tclMsgErrStateHistory02Status(const spm_corefi_tclMsgErrStateHistory02Status& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   tStateList = coRef.tStateList;
}
spm_corefi_tclMsgErrStateHistory02Status& spm_corefi_tclMsgErrStateHistory02Status::operator=(const spm_corefi_tclMsgErrStateHistory02Status& coRef)
{
   if (this == &coRef) return *this;
   tStateList = coRef.tStateList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgErrStateHistory02Status::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
         tStateList[u32Idx].vDestroy();
   tStateList.clear();
   }
}

spm_corefi_tclMsgErrStateHistory02Status::spm_corefi_tclMsgErrStateHistory02Status()

 {}

tS32 spm_corefi_tclMsgErrStateHistory02Status::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY02STATUS;
}


spm_corefi_tclMsgErrStateHistory02Status::~spm_corefi_tclMsgErrStateHistory02Status()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgErrStateHistory02Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(tStateList.size()*49);
}

fi_tclInContext& spm_corefi_tclMsgErrStateHistory02Status::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
      {
         tStateList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tStateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tStateList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgErrStateHistory02Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tStateList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
         (tVoid) (oOut << tStateList[u32Idx]);
   }
   return oOut;
}

tBool spm_corefi_tclMsgErrStateHistory02Status::operator==(const spm_corefi_tclMsgErrStateHistory02Status& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tStateList.size() == roRef.tStateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tStateList.size()); ++u32Idx)
            bResult = bResult && (tStateList[u32Idx] == roRef.tStateList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgErrStateHistory02Get::spm_corefi_tclMsgErrStateHistory02Get()
 {}

tS32 spm_corefi_tclMsgErrStateHistory02Get::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY02GET;
}


spm_corefi_tclMsgErrStateHistory02Get::~spm_corefi_tclMsgErrStateHistory02Get()
{}

//=============================================================================

spm_corefi_tclMsgErrStateHistory03Set::spm_corefi_tclMsgErrStateHistory03Set()
 {}

tS32 spm_corefi_tclMsgErrStateHistory03Set::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY03SET;
}


spm_corefi_tclMsgErrStateHistory03Set::~spm_corefi_tclMsgErrStateHistory03Set()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgErrStateHistory03Status::spm_corefi_tclMsgErrStateHistory03Status(const spm_corefi_tclMsgErrStateHistory03Status& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   tStateList = coRef.tStateList;
}
spm_corefi_tclMsgErrStateHistory03Status& spm_corefi_tclMsgErrStateHistory03Status::operator=(const spm_corefi_tclMsgErrStateHistory03Status& coRef)
{
   if (this == &coRef) return *this;
   tStateList = coRef.tStateList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgErrStateHistory03Status::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
         tStateList[u32Idx].vDestroy();
   tStateList.clear();
   }
}

spm_corefi_tclMsgErrStateHistory03Status::spm_corefi_tclMsgErrStateHistory03Status()

 {}

tS32 spm_corefi_tclMsgErrStateHistory03Status::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY03STATUS;
}


spm_corefi_tclMsgErrStateHistory03Status::~spm_corefi_tclMsgErrStateHistory03Status()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgErrStateHistory03Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(tStateList.size()*49);
}

fi_tclInContext& spm_corefi_tclMsgErrStateHistory03Status::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
      {
         tStateList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tStateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tStateList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgErrStateHistory03Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tStateList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
         (tVoid) (oOut << tStateList[u32Idx]);
   }
   return oOut;
}

tBool spm_corefi_tclMsgErrStateHistory03Status::operator==(const spm_corefi_tclMsgErrStateHistory03Status& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tStateList.size() == roRef.tStateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tStateList.size()); ++u32Idx)
            bResult = bResult && (tStateList[u32Idx] == roRef.tStateList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgErrStateHistory03Get::spm_corefi_tclMsgErrStateHistory03Get()
 {}

tS32 spm_corefi_tclMsgErrStateHistory03Get::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY03GET;
}


spm_corefi_tclMsgErrStateHistory03Get::~spm_corefi_tclMsgErrStateHistory03Get()
{}

//=============================================================================

spm_corefi_tclMsgErrStateHistory04Set::spm_corefi_tclMsgErrStateHistory04Set()
 {}

tS32 spm_corefi_tclMsgErrStateHistory04Set::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY04SET;
}


spm_corefi_tclMsgErrStateHistory04Set::~spm_corefi_tclMsgErrStateHistory04Set()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgErrStateHistory04Status::spm_corefi_tclMsgErrStateHistory04Status(const spm_corefi_tclMsgErrStateHistory04Status& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   tStateList = coRef.tStateList;
}
spm_corefi_tclMsgErrStateHistory04Status& spm_corefi_tclMsgErrStateHistory04Status::operator=(const spm_corefi_tclMsgErrStateHistory04Status& coRef)
{
   if (this == &coRef) return *this;
   tStateList = coRef.tStateList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgErrStateHistory04Status::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
         tStateList[u32Idx].vDestroy();
   tStateList.clear();
   }
}

spm_corefi_tclMsgErrStateHistory04Status::spm_corefi_tclMsgErrStateHistory04Status()

 {}

tS32 spm_corefi_tclMsgErrStateHistory04Status::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY04STATUS;
}


spm_corefi_tclMsgErrStateHistory04Status::~spm_corefi_tclMsgErrStateHistory04Status()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgErrStateHistory04Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(tStateList.size()*49);
}

fi_tclInContext& spm_corefi_tclMsgErrStateHistory04Status::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
      {
         tStateList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tStateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tStateList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgErrStateHistory04Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tStateList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
         (tVoid) (oOut << tStateList[u32Idx]);
   }
   return oOut;
}

tBool spm_corefi_tclMsgErrStateHistory04Status::operator==(const spm_corefi_tclMsgErrStateHistory04Status& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tStateList.size() == roRef.tStateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tStateList.size()); ++u32Idx)
            bResult = bResult && (tStateList[u32Idx] == roRef.tStateList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgErrStateHistory04Get::spm_corefi_tclMsgErrStateHistory04Get()
 {}

tS32 spm_corefi_tclMsgErrStateHistory04Get::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY04GET;
}


spm_corefi_tclMsgErrStateHistory04Get::~spm_corefi_tclMsgErrStateHistory04Get()
{}

//=============================================================================

spm_corefi_tclMsgErrStateHistory05Set::spm_corefi_tclMsgErrStateHistory05Set()
 {}

tS32 spm_corefi_tclMsgErrStateHistory05Set::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY05SET;
}


spm_corefi_tclMsgErrStateHistory05Set::~spm_corefi_tclMsgErrStateHistory05Set()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgErrStateHistory05Status::spm_corefi_tclMsgErrStateHistory05Status(const spm_corefi_tclMsgErrStateHistory05Status& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   tStateList = coRef.tStateList;
}
spm_corefi_tclMsgErrStateHistory05Status& spm_corefi_tclMsgErrStateHistory05Status::operator=(const spm_corefi_tclMsgErrStateHistory05Status& coRef)
{
   if (this == &coRef) return *this;
   tStateList = coRef.tStateList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgErrStateHistory05Status::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
         tStateList[u32Idx].vDestroy();
   tStateList.clear();
   }
}

spm_corefi_tclMsgErrStateHistory05Status::spm_corefi_tclMsgErrStateHistory05Status()

 {}

tS32 spm_corefi_tclMsgErrStateHistory05Status::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY05STATUS;
}


spm_corefi_tclMsgErrStateHistory05Status::~spm_corefi_tclMsgErrStateHistory05Status()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgErrStateHistory05Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(tStateList.size()*49);
}

fi_tclInContext& spm_corefi_tclMsgErrStateHistory05Status::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
      {
         tStateList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tStateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tStateList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgErrStateHistory05Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tStateList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tStateList.size(); ++u32Idx)
         (tVoid) (oOut << tStateList[u32Idx]);
   }
   return oOut;
}

tBool spm_corefi_tclMsgErrStateHistory05Status::operator==(const spm_corefi_tclMsgErrStateHistory05Status& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tStateList.size() == roRef.tStateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tStateList.size()); ++u32Idx)
            bResult = bResult && (tStateList[u32Idx] == roRef.tStateList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgErrStateHistory05Get::spm_corefi_tclMsgErrStateHistory05Get()
 {}

tS32 spm_corefi_tclMsgErrStateHistory05Get::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY05GET;
}


spm_corefi_tclMsgErrStateHistory05Get::~spm_corefi_tclMsgErrStateHistory05Get()
{}

//=============================================================================

spm_corefi_tclMsgSwitchOnHistorySet::spm_corefi_tclMsgSwitchOnHistorySet()
 {}

tS32 spm_corefi_tclMsgSwitchOnHistorySet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SWITCHONHISTORYSET;
}


spm_corefi_tclMsgSwitchOnHistorySet::~spm_corefi_tclMsgSwitchOnHistorySet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSwitchOnHistoryStatus::spm_corefi_tclMsgSwitchOnHistoryStatus(const spm_corefi_tclMsgSwitchOnHistoryStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   tSwitchOnList = coRef.tSwitchOnList;
}
spm_corefi_tclMsgSwitchOnHistoryStatus& spm_corefi_tclMsgSwitchOnHistoryStatus::operator=(const spm_corefi_tclMsgSwitchOnHistoryStatus& coRef)
{
   if (this == &coRef) return *this;
   tSwitchOnList = coRef.tSwitchOnList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgSwitchOnHistoryStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tSwitchOnList.size(); ++u32Idx)
         tSwitchOnList[u32Idx].vDestroy();
   tSwitchOnList.clear();
   }
}

spm_corefi_tclMsgSwitchOnHistoryStatus::spm_corefi_tclMsgSwitchOnHistoryStatus()

 {}

tS32 spm_corefi_tclMsgSwitchOnHistoryStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SWITCHONHISTORYSTATUS;
}


spm_corefi_tclMsgSwitchOnHistoryStatus::~spm_corefi_tclMsgSwitchOnHistoryStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgSwitchOnHistoryStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(tSwitchOnList.size()*11);
}

fi_tclInContext& spm_corefi_tclMsgSwitchOnHistoryStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tSwitchOnList.size(); ++u32Idx)
      {
         tSwitchOnList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tSwitchOnList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tSwitchOnList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSwitchOnHistoryStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tSwitchOnList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tSwitchOnList.size(); ++u32Idx)
         (tVoid) (oOut << tSwitchOnList[u32Idx]);
   }
   return oOut;
}

tBool spm_corefi_tclMsgSwitchOnHistoryStatus::operator==(const spm_corefi_tclMsgSwitchOnHistoryStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tSwitchOnList.size() == roRef.tSwitchOnList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tSwitchOnList.size()); ++u32Idx)
            bResult = bResult && (tSwitchOnList[u32Idx] == roRef.tSwitchOnList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgSwitchOnHistoryGet::spm_corefi_tclMsgSwitchOnHistoryGet()
 {}

tS32 spm_corefi_tclMsgSwitchOnHistoryGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SWITCHONHISTORYGET;
}


spm_corefi_tclMsgSwitchOnHistoryGet::~spm_corefi_tclMsgSwitchOnHistoryGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgDeviceOnCounterStatus::spm_corefi_tclMsgDeviceOnCounterStatus(const spm_corefi_tclMsgDeviceOnCounterStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   u32DeviceWakeupCount = coRef.u32DeviceWakeupCount;
   u32DeviceUserOnCount = coRef.u32DeviceUserOnCount;
}
spm_corefi_tclMsgDeviceOnCounterStatus& spm_corefi_tclMsgDeviceOnCounterStatus::operator=(const spm_corefi_tclMsgDeviceOnCounterStatus& coRef)
{
   if (this == &coRef) return *this;
   u32DeviceWakeupCount = coRef.u32DeviceWakeupCount;
   u32DeviceUserOnCount = coRef.u32DeviceUserOnCount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgDeviceOnCounterStatus::spm_corefi_tclMsgDeviceOnCounterStatus()
:u32DeviceWakeupCount(0)
,u32DeviceUserOnCount(0)
 {}

tS32 spm_corefi_tclMsgDeviceOnCounterStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DEVICEONCOUNTERSTATUS;
}


spm_corefi_tclMsgDeviceOnCounterStatus::~spm_corefi_tclMsgDeviceOnCounterStatus()
{}

tU32 spm_corefi_tclMsgDeviceOnCounterStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& spm_corefi_tclMsgDeviceOnCounterStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32DeviceWakeupCount);
   (tVoid) (oIn >> u32DeviceUserOnCount);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgDeviceOnCounterStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32DeviceWakeupCount);
   (tVoid) (oOut << u32DeviceUserOnCount);
   return oOut;
}

tBool spm_corefi_tclMsgDeviceOnCounterStatus::operator==(const spm_corefi_tclMsgDeviceOnCounterStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32DeviceWakeupCount == roRef.u32DeviceWakeupCount);
   bResult = bResult && (u32DeviceUserOnCount == roRef.u32DeviceUserOnCount);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgDeviceOnCounterGet::spm_corefi_tclMsgDeviceOnCounterGet()
 {}

tS32 spm_corefi_tclMsgDeviceOnCounterGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DEVICEONCOUNTERGET;
}


spm_corefi_tclMsgDeviceOnCounterGet::~spm_corefi_tclMsgDeviceOnCounterGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgVoltageEventCounterStatus::spm_corefi_tclMsgVoltageEventCounterStatus(const spm_corefi_tclMsgVoltageEventCounterStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   tVoltageEventCounter = coRef.tVoltageEventCounter;
}
spm_corefi_tclMsgVoltageEventCounterStatus& spm_corefi_tclMsgVoltageEventCounterStatus::operator=(const spm_corefi_tclMsgVoltageEventCounterStatus& coRef)
{
   if (this == &coRef) return *this;
   tVoltageEventCounter = coRef.tVoltageEventCounter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgVoltageEventCounterStatus::spm_corefi_tclMsgVoltageEventCounterStatus()
:tVoltageEventCounter()
 {}

tS32 spm_corefi_tclMsgVoltageEventCounterStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_VOLTAGEEVENTCOUNTERSTATUS;
}


spm_corefi_tclMsgVoltageEventCounterStatus::~spm_corefi_tclMsgVoltageEventCounterStatus()
{}

tU32 spm_corefi_tclMsgVoltageEventCounterStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& spm_corefi_tclMsgVoltageEventCounterStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tVoltageEventCounter);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgVoltageEventCounterStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tVoltageEventCounter);
   return oOut;
}

tBool spm_corefi_tclMsgVoltageEventCounterStatus::operator==(const spm_corefi_tclMsgVoltageEventCounterStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tVoltageEventCounter == roRef.tVoltageEventCounter);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgVoltageEventCounterGet::spm_corefi_tclMsgVoltageEventCounterGet()
 {}

tS32 spm_corefi_tclMsgVoltageEventCounterGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_VOLTAGEEVENTCOUNTERGET;
}


spm_corefi_tclMsgVoltageEventCounterGet::~spm_corefi_tclMsgVoltageEventCounterGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgVoltageRangeHistogramStatus::spm_corefi_tclMsgVoltageRangeHistogramStatus(const spm_corefi_tclMsgVoltageRangeHistogramStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   listVoltageRangeHistogram = coRef.listVoltageRangeHistogram;
}
spm_corefi_tclMsgVoltageRangeHistogramStatus& spm_corefi_tclMsgVoltageRangeHistogramStatus::operator=(const spm_corefi_tclMsgVoltageRangeHistogramStatus& coRef)
{
   if (this == &coRef) return *this;
   listVoltageRangeHistogram = coRef.listVoltageRangeHistogram;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgVoltageRangeHistogramStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < listVoltageRangeHistogram.size(); ++u32Idx)
         listVoltageRangeHistogram[u32Idx].vDestroy();
   listVoltageRangeHistogram.clear();
   }
}

spm_corefi_tclMsgVoltageRangeHistogramStatus::spm_corefi_tclMsgVoltageRangeHistogramStatus()

 {}

tS32 spm_corefi_tclMsgVoltageRangeHistogramStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_VOLTAGERANGEHISTOGRAMSTATUS;
}


spm_corefi_tclMsgVoltageRangeHistogramStatus::~spm_corefi_tclMsgVoltageRangeHistogramStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgVoltageRangeHistogramStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(listVoltageRangeHistogram.size()*6);
}

fi_tclInContext& spm_corefi_tclMsgVoltageRangeHistogramStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < listVoltageRangeHistogram.size(); ++u32Idx)
      {
         listVoltageRangeHistogram[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      listVoltageRangeHistogram.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> listVoltageRangeHistogram[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgVoltageRangeHistogramStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)listVoltageRangeHistogram.size());
   {
      for (tU32 u32Idx = 0; u32Idx < listVoltageRangeHistogram.size(); ++u32Idx)
         (tVoid) (oOut << listVoltageRangeHistogram[u32Idx]);
   }
   return oOut;
}

tBool spm_corefi_tclMsgVoltageRangeHistogramStatus::operator==(const spm_corefi_tclMsgVoltageRangeHistogramStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (listVoltageRangeHistogram.size() == roRef.listVoltageRangeHistogram.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < listVoltageRangeHistogram.size()); ++u32Idx)
            bResult = bResult && (listVoltageRangeHistogram[u32Idx] == roRef.listVoltageRangeHistogram[u32Idx]);
      }
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgVoltageRangeHistogramGet::spm_corefi_tclMsgVoltageRangeHistogramGet()
 {}

tS32 spm_corefi_tclMsgVoltageRangeHistogramGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_VOLTAGERANGEHISTOGRAMGET;
}


spm_corefi_tclMsgVoltageRangeHistogramGet::~spm_corefi_tclMsgVoltageRangeHistogramGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgCpuUsageStatisticStatus::spm_corefi_tclMsgCpuUsageStatisticStatus(const spm_corefi_tclMsgCpuUsageStatisticStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   tCpuUsageStatisticsData = coRef.tCpuUsageStatisticsData;
}
spm_corefi_tclMsgCpuUsageStatisticStatus& spm_corefi_tclMsgCpuUsageStatisticStatus::operator=(const spm_corefi_tclMsgCpuUsageStatisticStatus& coRef)
{
   if (this == &coRef) return *this;
   tCpuUsageStatisticsData = coRef.tCpuUsageStatisticsData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgCpuUsageStatisticStatus::spm_corefi_tclMsgCpuUsageStatisticStatus()
:tCpuUsageStatisticsData()
 {}

tS32 spm_corefi_tclMsgCpuUsageStatisticStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CPUUSAGESTATISTICSTATUS;
}


spm_corefi_tclMsgCpuUsageStatisticStatus::~spm_corefi_tclMsgCpuUsageStatisticStatus()
{}

tU32 spm_corefi_tclMsgCpuUsageStatisticStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& spm_corefi_tclMsgCpuUsageStatisticStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tCpuUsageStatisticsData);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgCpuUsageStatisticStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tCpuUsageStatisticsData);
   return oOut;
}

tBool spm_corefi_tclMsgCpuUsageStatisticStatus::operator==(const spm_corefi_tclMsgCpuUsageStatisticStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tCpuUsageStatisticsData == roRef.tCpuUsageStatisticsData);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgCpuUsageStatisticGet::spm_corefi_tclMsgCpuUsageStatisticGet()
 {}

tS32 spm_corefi_tclMsgCpuUsageStatisticGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_CPUUSAGESTATISTICGET;
}


spm_corefi_tclMsgCpuUsageStatisticGet::~spm_corefi_tclMsgCpuUsageStatisticGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgRamUsageStatisticStatus::spm_corefi_tclMsgRamUsageStatisticStatus(const spm_corefi_tclMsgRamUsageStatisticStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   tRamUsageStatisticsData = coRef.tRamUsageStatisticsData;
}
spm_corefi_tclMsgRamUsageStatisticStatus& spm_corefi_tclMsgRamUsageStatisticStatus::operator=(const spm_corefi_tclMsgRamUsageStatisticStatus& coRef)
{
   if (this == &coRef) return *this;
   tRamUsageStatisticsData = coRef.tRamUsageStatisticsData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgRamUsageStatisticStatus::spm_corefi_tclMsgRamUsageStatisticStatus()
:tRamUsageStatisticsData()
 {}

tS32 spm_corefi_tclMsgRamUsageStatisticStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RAMUSAGESTATISTICSTATUS;
}


spm_corefi_tclMsgRamUsageStatisticStatus::~spm_corefi_tclMsgRamUsageStatisticStatus()
{}

tU32 spm_corefi_tclMsgRamUsageStatisticStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& spm_corefi_tclMsgRamUsageStatisticStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tRamUsageStatisticsData);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgRamUsageStatisticStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tRamUsageStatisticsData);
   return oOut;
}

tBool spm_corefi_tclMsgRamUsageStatisticStatus::operator==(const spm_corefi_tclMsgRamUsageStatisticStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tRamUsageStatisticsData == roRef.tRamUsageStatisticsData);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgRamUsageStatisticGet::spm_corefi_tclMsgRamUsageStatisticGet()
 {}

tS32 spm_corefi_tclMsgRamUsageStatisticGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RAMUSAGESTATISTICGET;
}


spm_corefi_tclMsgRamUsageStatisticGet::~spm_corefi_tclMsgRamUsageStatisticGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgStartupTimeStatisticStatus::spm_corefi_tclMsgStartupTimeStatisticStatus(const spm_corefi_tclMsgStartupTimeStatisticStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   tStartupTimeStatisticsData = coRef.tStartupTimeStatisticsData;
}
spm_corefi_tclMsgStartupTimeStatisticStatus& spm_corefi_tclMsgStartupTimeStatisticStatus::operator=(const spm_corefi_tclMsgStartupTimeStatisticStatus& coRef)
{
   if (this == &coRef) return *this;
   tStartupTimeStatisticsData = coRef.tStartupTimeStatisticsData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgStartupTimeStatisticStatus::spm_corefi_tclMsgStartupTimeStatisticStatus()
:tStartupTimeStatisticsData()
 {}

tS32 spm_corefi_tclMsgStartupTimeStatisticStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_STARTUPTIMESTATISTICSTATUS;
}


spm_corefi_tclMsgStartupTimeStatisticStatus::~spm_corefi_tclMsgStartupTimeStatisticStatus()
{}

tU32 spm_corefi_tclMsgStartupTimeStatisticStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& spm_corefi_tclMsgStartupTimeStatisticStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tStartupTimeStatisticsData);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgStartupTimeStatisticStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tStartupTimeStatisticsData);
   return oOut;
}

tBool spm_corefi_tclMsgStartupTimeStatisticStatus::operator==(const spm_corefi_tclMsgStartupTimeStatisticStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tStartupTimeStatisticsData == roRef.tStartupTimeStatisticsData);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgStartupTimeStatisticGet::spm_corefi_tclMsgStartupTimeStatisticGet()
 {}

tS32 spm_corefi_tclMsgStartupTimeStatisticGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_STARTUPTIMESTATISTICGET;
}


spm_corefi_tclMsgStartupTimeStatisticGet::~spm_corefi_tclMsgStartupTimeStatisticGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSWVersionStatisticStatus::spm_corefi_tclMsgSWVersionStatisticStatus(const spm_corefi_tclMsgSWVersionStatisticStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   listSWVersionStatistic = coRef.listSWVersionStatistic;
}
spm_corefi_tclMsgSWVersionStatisticStatus& spm_corefi_tclMsgSWVersionStatisticStatus::operator=(const spm_corefi_tclMsgSWVersionStatisticStatus& coRef)
{
   if (this == &coRef) return *this;
   listSWVersionStatistic = coRef.listSWVersionStatistic;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgSWVersionStatisticStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < listSWVersionStatistic.size(); ++u32Idx)
         listSWVersionStatistic[u32Idx].vDestroy();
   listSWVersionStatistic.clear();
   }
}

spm_corefi_tclMsgSWVersionStatisticStatus::spm_corefi_tclMsgSWVersionStatisticStatus()

 {}

tS32 spm_corefi_tclMsgSWVersionStatisticStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SWVERSIONSTATISTICSTATUS;
}


spm_corefi_tclMsgSWVersionStatisticStatus::~spm_corefi_tclMsgSWVersionStatisticStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgSWVersionStatisticStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < listSWVersionStatistic.size(); ++u32ListIdx)
      u32DynamicSize += listSWVersionStatistic[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& spm_corefi_tclMsgSWVersionStatisticStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < listSWVersionStatistic.size(); ++u32Idx)
      {
         listSWVersionStatistic[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      listSWVersionStatistic.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> listSWVersionStatistic[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSWVersionStatisticStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)listSWVersionStatistic.size());
   {
      for (tU32 u32Idx = 0; u32Idx < listSWVersionStatistic.size(); ++u32Idx)
         (tVoid) (oOut << listSWVersionStatistic[u32Idx]);
   }
   return oOut;
}

tBool spm_corefi_tclMsgSWVersionStatisticStatus::operator==(const spm_corefi_tclMsgSWVersionStatisticStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (listSWVersionStatistic.size() == roRef.listSWVersionStatistic.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < listSWVersionStatistic.size()); ++u32Idx)
            bResult = bResult && (listSWVersionStatistic[u32Idx] == roRef.listSWVersionStatistic[u32Idx]);
      }
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgSWVersionStatisticGet::spm_corefi_tclMsgSWVersionStatisticGet()
 {}

tS32 spm_corefi_tclMsgSWVersionStatisticGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SWVERSIONSTATISTICGET;
}


spm_corefi_tclMsgSWVersionStatisticGet::~spm_corefi_tclMsgSWVersionStatisticGet()
{}

//=============================================================================

spm_corefi_tclMsgRunlevelStateUpReg::spm_corefi_tclMsgRunlevelStateUpReg()
 {}

tS32 spm_corefi_tclMsgRunlevelStateUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RUNLEVELSTATEUPREG;
}


spm_corefi_tclMsgRunlevelStateUpReg::~spm_corefi_tclMsgRunlevelStateUpReg()
{}

//=============================================================================

spm_corefi_tclMsgRunlevelStateRelUpReg::spm_corefi_tclMsgRunlevelStateRelUpReg()
 {}

tS32 spm_corefi_tclMsgRunlevelStateRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RUNLEVELSTATERELUPREG;
}


spm_corefi_tclMsgRunlevelStateRelUpReg::~spm_corefi_tclMsgRunlevelStateRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgRunlevelStateGet::spm_corefi_tclMsgRunlevelStateGet()
 {}

tS32 spm_corefi_tclMsgRunlevelStateGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RUNLEVELSTATEGET;
}


spm_corefi_tclMsgRunlevelStateGet::~spm_corefi_tclMsgRunlevelStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgRunlevelStateStatus::spm_corefi_tclMsgRunlevelStateStatus(const spm_corefi_tclMsgRunlevelStateStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   eRunlevel = coRef.eRunlevel;
}
spm_corefi_tclMsgRunlevelStateStatus& spm_corefi_tclMsgRunlevelStateStatus::operator=(const spm_corefi_tclMsgRunlevelStateStatus& coRef)
{
   if (this == &coRef) return *this;
   eRunlevel = coRef.eRunlevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgRunlevelStateStatus::spm_corefi_tclMsgRunlevelStateStatus()
:eRunlevel()
 {}

tS32 spm_corefi_tclMsgRunlevelStateStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RUNLEVELSTATESTATUS;
}


spm_corefi_tclMsgRunlevelStateStatus::~spm_corefi_tclMsgRunlevelStateStatus()
{}

tU32 spm_corefi_tclMsgRunlevelStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgRunlevelStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eRunlevel);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgRunlevelStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eRunlevel);
   return oOut;
}

tBool spm_corefi_tclMsgRunlevelStateStatus::operator==(const spm_corefi_tclMsgRunlevelStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eRunlevel == roRef.eRunlevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgRestartSet::spm_corefi_tclMsgRestartSet(const spm_corefi_tclMsgRestartSet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   Restart = coRef.Restart;
}
spm_corefi_tclMsgRestartSet& spm_corefi_tclMsgRestartSet::operator=(const spm_corefi_tclMsgRestartSet& coRef)
{
   if (this == &coRef) return *this;
   Restart = coRef.Restart;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgRestartSet::spm_corefi_tclMsgRestartSet()
:Restart()
 {}

tS32 spm_corefi_tclMsgRestartSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RESTARTSET;
}


spm_corefi_tclMsgRestartSet::~spm_corefi_tclMsgRestartSet()
{}

tU32 spm_corefi_tclMsgRestartSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgRestartSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Restart);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgRestartSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Restart);
   return oOut;
}

tBool spm_corefi_tclMsgRestartSet::operator==(const spm_corefi_tclMsgRestartSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Restart == roRef.Restart);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgRestartStatus::spm_corefi_tclMsgRestartStatus(const spm_corefi_tclMsgRestartStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   Restart = coRef.Restart;
}
spm_corefi_tclMsgRestartStatus& spm_corefi_tclMsgRestartStatus::operator=(const spm_corefi_tclMsgRestartStatus& coRef)
{
   if (this == &coRef) return *this;
   Restart = coRef.Restart;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgRestartStatus::spm_corefi_tclMsgRestartStatus()
:Restart()
 {}

tS32 spm_corefi_tclMsgRestartStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RESTARTSTATUS;
}


spm_corefi_tclMsgRestartStatus::~spm_corefi_tclMsgRestartStatus()
{}

tU32 spm_corefi_tclMsgRestartStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgRestartStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Restart);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgRestartStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Restart);
   return oOut;
}

tBool spm_corefi_tclMsgRestartStatus::operator==(const spm_corefi_tclMsgRestartStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Restart == roRef.Restart);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgRestartUpReg::spm_corefi_tclMsgRestartUpReg()
 {}

tS32 spm_corefi_tclMsgRestartUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RESTARTUPREG;
}


spm_corefi_tclMsgRestartUpReg::~spm_corefi_tclMsgRestartUpReg()
{}

//=============================================================================

spm_corefi_tclMsgRestartRelUpReg::spm_corefi_tclMsgRestartRelUpReg()
 {}

tS32 spm_corefi_tclMsgRestartRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RESTARTRELUPREG;
}


spm_corefi_tclMsgRestartRelUpReg::~spm_corefi_tclMsgRestartRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgRestartGet::spm_corefi_tclMsgRestartGet()
 {}

tS32 spm_corefi_tclMsgRestartGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RESTARTGET;
}


spm_corefi_tclMsgRestartGet::~spm_corefi_tclMsgRestartGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgLifesignStatus::spm_corefi_tclMsgLifesignStatus(const spm_corefi_tclMsgLifesignStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   Lifesign = coRef.Lifesign;
}
spm_corefi_tclMsgLifesignStatus& spm_corefi_tclMsgLifesignStatus::operator=(const spm_corefi_tclMsgLifesignStatus& coRef)
{
   if (this == &coRef) return *this;
   Lifesign = coRef.Lifesign;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgLifesignStatus::spm_corefi_tclMsgLifesignStatus()
:Lifesign(0)
 {}

tS32 spm_corefi_tclMsgLifesignStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_LIFESIGNSTATUS;
}


spm_corefi_tclMsgLifesignStatus::~spm_corefi_tclMsgLifesignStatus()
{}

tU32 spm_corefi_tclMsgLifesignStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgLifesignStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Lifesign);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgLifesignStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Lifesign);
   return oOut;
}

tBool spm_corefi_tclMsgLifesignStatus::operator==(const spm_corefi_tclMsgLifesignStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Lifesign == roRef.Lifesign);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgLifesignUpReg::spm_corefi_tclMsgLifesignUpReg()
 {}

tS32 spm_corefi_tclMsgLifesignUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_LIFESIGNUPREG;
}


spm_corefi_tclMsgLifesignUpReg::~spm_corefi_tclMsgLifesignUpReg()
{}

//=============================================================================

spm_corefi_tclMsgLifesignRelUpReg::spm_corefi_tclMsgLifesignRelUpReg()
 {}

tS32 spm_corefi_tclMsgLifesignRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_LIFESIGNRELUPREG;
}


spm_corefi_tclMsgLifesignRelUpReg::~spm_corefi_tclMsgLifesignRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgLifesignGet::spm_corefi_tclMsgLifesignGet()
 {}

tS32 spm_corefi_tclMsgLifesignGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_LIFESIGNGET;
}


spm_corefi_tclMsgLifesignGet::~spm_corefi_tclMsgLifesignGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgHmiStateStatus::spm_corefi_tclMsgHmiStateStatus(const spm_corefi_tclMsgHmiStateStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   HmiState = coRef.HmiState;
}
spm_corefi_tclMsgHmiStateStatus& spm_corefi_tclMsgHmiStateStatus::operator=(const spm_corefi_tclMsgHmiStateStatus& coRef)
{
   if (this == &coRef) return *this;
   HmiState = coRef.HmiState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgHmiStateStatus::spm_corefi_tclMsgHmiStateStatus()
:HmiState()
 {}

tS32 spm_corefi_tclMsgHmiStateStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_HMISTATESTATUS;
}


spm_corefi_tclMsgHmiStateStatus::~spm_corefi_tclMsgHmiStateStatus()
{}

tU32 spm_corefi_tclMsgHmiStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgHmiStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> HmiState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgHmiStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << HmiState);
   return oOut;
}

tBool spm_corefi_tclMsgHmiStateStatus::operator==(const spm_corefi_tclMsgHmiStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (HmiState == roRef.HmiState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgHmiStateUpReg::spm_corefi_tclMsgHmiStateUpReg()
 {}

tS32 spm_corefi_tclMsgHmiStateUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_HMISTATEUPREG;
}


spm_corefi_tclMsgHmiStateUpReg::~spm_corefi_tclMsgHmiStateUpReg()
{}

//=============================================================================

spm_corefi_tclMsgHmiStateRelUpReg::spm_corefi_tclMsgHmiStateRelUpReg()
 {}

tS32 spm_corefi_tclMsgHmiStateRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_HMISTATERELUPREG;
}


spm_corefi_tclMsgHmiStateRelUpReg::~spm_corefi_tclMsgHmiStateRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgHmiStateGet::spm_corefi_tclMsgHmiStateGet()
 {}

tS32 spm_corefi_tclMsgHmiStateGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_HMISTATEGET;
}


spm_corefi_tclMsgHmiStateGet::~spm_corefi_tclMsgHmiStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSystemPowerBehaviourStatus::spm_corefi_tclMsgSystemPowerBehaviourStatus(const spm_corefi_tclMsgSystemPowerBehaviourStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   eSystemPowerBehaviour = coRef.eSystemPowerBehaviour;
}
spm_corefi_tclMsgSystemPowerBehaviourStatus& spm_corefi_tclMsgSystemPowerBehaviourStatus::operator=(const spm_corefi_tclMsgSystemPowerBehaviourStatus& coRef)
{
   if (this == &coRef) return *this;
   eSystemPowerBehaviour = coRef.eSystemPowerBehaviour;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgSystemPowerBehaviourStatus::spm_corefi_tclMsgSystemPowerBehaviourStatus()
:eSystemPowerBehaviour()
 {}

tS32 spm_corefi_tclMsgSystemPowerBehaviourStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SYSTEMPOWERBEHAVIOURSTATUS;
}


spm_corefi_tclMsgSystemPowerBehaviourStatus::~spm_corefi_tclMsgSystemPowerBehaviourStatus()
{}

tU32 spm_corefi_tclMsgSystemPowerBehaviourStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgSystemPowerBehaviourStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eSystemPowerBehaviour);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSystemPowerBehaviourStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eSystemPowerBehaviour);
   return oOut;
}

tBool spm_corefi_tclMsgSystemPowerBehaviourStatus::operator==(const spm_corefi_tclMsgSystemPowerBehaviourStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eSystemPowerBehaviour == roRef.eSystemPowerBehaviour);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgSystemPowerBehaviourUpReg::spm_corefi_tclMsgSystemPowerBehaviourUpReg()
 {}

tS32 spm_corefi_tclMsgSystemPowerBehaviourUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SYSTEMPOWERBEHAVIOURUPREG;
}


spm_corefi_tclMsgSystemPowerBehaviourUpReg::~spm_corefi_tclMsgSystemPowerBehaviourUpReg()
{}

//=============================================================================

spm_corefi_tclMsgSystemPowerBehaviourRelUpReg::spm_corefi_tclMsgSystemPowerBehaviourRelUpReg()
 {}

tS32 spm_corefi_tclMsgSystemPowerBehaviourRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SYSTEMPOWERBEHAVIOURRELUPREG;
}


spm_corefi_tclMsgSystemPowerBehaviourRelUpReg::~spm_corefi_tclMsgSystemPowerBehaviourRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgSystemPowerBehaviourGet::spm_corefi_tclMsgSystemPowerBehaviourGet()
 {}

tS32 spm_corefi_tclMsgSystemPowerBehaviourGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SYSTEMPOWERBEHAVIOURGET;
}


spm_corefi_tclMsgSystemPowerBehaviourGet::~spm_corefi_tclMsgSystemPowerBehaviourGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgDimStateStatus::spm_corefi_tclMsgDimStateStatus(const spm_corefi_tclMsgDimStateStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   DimState = coRef.DimState;
}
spm_corefi_tclMsgDimStateStatus& spm_corefi_tclMsgDimStateStatus::operator=(const spm_corefi_tclMsgDimStateStatus& coRef)
{
   if (this == &coRef) return *this;
   DimState = coRef.DimState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgDimStateStatus::spm_corefi_tclMsgDimStateStatus()
:DimState()
 {}

tS32 spm_corefi_tclMsgDimStateStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DIMSTATESTATUS;
}


spm_corefi_tclMsgDimStateStatus::~spm_corefi_tclMsgDimStateStatus()
{}

tU32 spm_corefi_tclMsgDimStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgDimStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DimState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgDimStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DimState);
   return oOut;
}

tBool spm_corefi_tclMsgDimStateStatus::operator==(const spm_corefi_tclMsgDimStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DimState == roRef.DimState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgDimStateUpReg::spm_corefi_tclMsgDimStateUpReg()
 {}

tS32 spm_corefi_tclMsgDimStateUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DIMSTATEUPREG;
}


spm_corefi_tclMsgDimStateUpReg::~spm_corefi_tclMsgDimStateUpReg()
{}

//=============================================================================

spm_corefi_tclMsgDimStateRelUpReg::spm_corefi_tclMsgDimStateRelUpReg()
 {}

tS32 spm_corefi_tclMsgDimStateRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DIMSTATERELUPREG;
}


spm_corefi_tclMsgDimStateRelUpReg::~spm_corefi_tclMsgDimStateRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgDimStateGet::spm_corefi_tclMsgDimStateGet()
 {}

tS32 spm_corefi_tclMsgDimStateGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DIMSTATEGET;
}


spm_corefi_tclMsgDimStateGet::~spm_corefi_tclMsgDimStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgDimmingStateStatus::spm_corefi_tclMsgDimmingStateStatus(const spm_corefi_tclMsgDimmingStateStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   DimState = coRef.DimState;
}
spm_corefi_tclMsgDimmingStateStatus& spm_corefi_tclMsgDimmingStateStatus::operator=(const spm_corefi_tclMsgDimmingStateStatus& coRef)
{
   if (this == &coRef) return *this;
   DimState = coRef.DimState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgDimmingStateStatus::spm_corefi_tclMsgDimmingStateStatus()
:DimState()
 {}

tS32 spm_corefi_tclMsgDimmingStateStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DIMMINGSTATESTATUS;
}


spm_corefi_tclMsgDimmingStateStatus::~spm_corefi_tclMsgDimmingStateStatus()
{}

tU32 spm_corefi_tclMsgDimmingStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgDimmingStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DimState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgDimmingStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DimState);
   return oOut;
}

tBool spm_corefi_tclMsgDimmingStateStatus::operator==(const spm_corefi_tclMsgDimmingStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DimState == roRef.DimState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgDimmingStateUpReg::spm_corefi_tclMsgDimmingStateUpReg()
 {}

tS32 spm_corefi_tclMsgDimmingStateUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DIMMINGSTATEUPREG;
}


spm_corefi_tclMsgDimmingStateUpReg::~spm_corefi_tclMsgDimmingStateUpReg()
{}

//=============================================================================

spm_corefi_tclMsgDimmingStateRelUpReg::spm_corefi_tclMsgDimmingStateRelUpReg()
 {}

tS32 spm_corefi_tclMsgDimmingStateRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DIMMINGSTATERELUPREG;
}


spm_corefi_tclMsgDimmingStateRelUpReg::~spm_corefi_tclMsgDimmingStateRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgDimmingStateGet::spm_corefi_tclMsgDimmingStateGet()
 {}

tS32 spm_corefi_tclMsgDimmingStateGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DIMMINGSTATEGET;
}


spm_corefi_tclMsgDimmingStateGet::~spm_corefi_tclMsgDimmingStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgBluetoothStateStatus::spm_corefi_tclMsgBluetoothStateStatus(const spm_corefi_tclMsgBluetoothStateStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   BtState = coRef.BtState;
}
spm_corefi_tclMsgBluetoothStateStatus& spm_corefi_tclMsgBluetoothStateStatus::operator=(const spm_corefi_tclMsgBluetoothStateStatus& coRef)
{
   if (this == &coRef) return *this;
   BtState = coRef.BtState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgBluetoothStateStatus::spm_corefi_tclMsgBluetoothStateStatus()
:BtState()
 {}

tS32 spm_corefi_tclMsgBluetoothStateStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_BLUETOOTHSTATESTATUS;
}


spm_corefi_tclMsgBluetoothStateStatus::~spm_corefi_tclMsgBluetoothStateStatus()
{}

tU32 spm_corefi_tclMsgBluetoothStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgBluetoothStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BtState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgBluetoothStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BtState);
   return oOut;
}

tBool spm_corefi_tclMsgBluetoothStateStatus::operator==(const spm_corefi_tclMsgBluetoothStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BtState == roRef.BtState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgBluetoothStateUpReg::spm_corefi_tclMsgBluetoothStateUpReg()
 {}

tS32 spm_corefi_tclMsgBluetoothStateUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_BLUETOOTHSTATEUPREG;
}


spm_corefi_tclMsgBluetoothStateUpReg::~spm_corefi_tclMsgBluetoothStateUpReg()
{}

//=============================================================================

spm_corefi_tclMsgBluetoothStateRelUpReg::spm_corefi_tclMsgBluetoothStateRelUpReg()
 {}

tS32 spm_corefi_tclMsgBluetoothStateRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_BLUETOOTHSTATERELUPREG;
}


spm_corefi_tclMsgBluetoothStateRelUpReg::~spm_corefi_tclMsgBluetoothStateRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgBluetoothStateGet::spm_corefi_tclMsgBluetoothStateGet()
 {}

tS32 spm_corefi_tclMsgBluetoothStateGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_BLUETOOTHSTATEGET;
}


spm_corefi_tclMsgBluetoothStateGet::~spm_corefi_tclMsgBluetoothStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgAudioStateStatus::spm_corefi_tclMsgAudioStateStatus(const spm_corefi_tclMsgAudioStateStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   AudioState = coRef.AudioState;
}
spm_corefi_tclMsgAudioStateStatus& spm_corefi_tclMsgAudioStateStatus::operator=(const spm_corefi_tclMsgAudioStateStatus& coRef)
{
   if (this == &coRef) return *this;
   AudioState = coRef.AudioState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgAudioStateStatus::spm_corefi_tclMsgAudioStateStatus()
:AudioState()
 {}

tS32 spm_corefi_tclMsgAudioStateStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_AUDIOSTATESTATUS;
}


spm_corefi_tclMsgAudioStateStatus::~spm_corefi_tclMsgAudioStateStatus()
{}

tU32 spm_corefi_tclMsgAudioStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgAudioStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AudioState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgAudioStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AudioState);
   return oOut;
}

tBool spm_corefi_tclMsgAudioStateStatus::operator==(const spm_corefi_tclMsgAudioStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AudioState == roRef.AudioState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgAudioStateUpReg::spm_corefi_tclMsgAudioStateUpReg()
 {}

tS32 spm_corefi_tclMsgAudioStateUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_AUDIOSTATEUPREG;
}


spm_corefi_tclMsgAudioStateUpReg::~spm_corefi_tclMsgAudioStateUpReg()
{}

//=============================================================================

spm_corefi_tclMsgAudioStateRelUpReg::spm_corefi_tclMsgAudioStateRelUpReg()
 {}

tS32 spm_corefi_tclMsgAudioStateRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_AUDIOSTATERELUPREG;
}


spm_corefi_tclMsgAudioStateRelUpReg::~spm_corefi_tclMsgAudioStateRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgAudioStateGet::spm_corefi_tclMsgAudioStateGet()
 {}

tS32 spm_corefi_tclMsgAudioStateGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_AUDIOSTATEGET;
}


spm_corefi_tclMsgAudioStateGet::~spm_corefi_tclMsgAudioStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSpiStateStatus::spm_corefi_tclMsgSpiStateStatus(const spm_corefi_tclMsgSpiStateStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   SpiState = coRef.SpiState;
}
spm_corefi_tclMsgSpiStateStatus& spm_corefi_tclMsgSpiStateStatus::operator=(const spm_corefi_tclMsgSpiStateStatus& coRef)
{
   if (this == &coRef) return *this;
   SpiState = coRef.SpiState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgSpiStateStatus::spm_corefi_tclMsgSpiStateStatus()
:SpiState()
 {}

tS32 spm_corefi_tclMsgSpiStateStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SPISTATESTATUS;
}


spm_corefi_tclMsgSpiStateStatus::~spm_corefi_tclMsgSpiStateStatus()
{}

tU32 spm_corefi_tclMsgSpiStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgSpiStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SpiState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSpiStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SpiState);
   return oOut;
}

tBool spm_corefi_tclMsgSpiStateStatus::operator==(const spm_corefi_tclMsgSpiStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SpiState == roRef.SpiState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgSpiStateUpReg::spm_corefi_tclMsgSpiStateUpReg()
 {}

tS32 spm_corefi_tclMsgSpiStateUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SPISTATEUPREG;
}


spm_corefi_tclMsgSpiStateUpReg::~spm_corefi_tclMsgSpiStateUpReg()
{}

//=============================================================================

spm_corefi_tclMsgSpiStateRelUpReg::spm_corefi_tclMsgSpiStateRelUpReg()
 {}

tS32 spm_corefi_tclMsgSpiStateRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SPISTATERELUPREG;
}


spm_corefi_tclMsgSpiStateRelUpReg::~spm_corefi_tclMsgSpiStateRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgSpiStateGet::spm_corefi_tclMsgSpiStateGet()
 {}

tS32 spm_corefi_tclMsgSpiStateGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SPISTATEGET;
}


spm_corefi_tclMsgSpiStateGet::~spm_corefi_tclMsgSpiStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgTunerStateStatus::spm_corefi_tclMsgTunerStateStatus(const spm_corefi_tclMsgTunerStateStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   TunerState = coRef.TunerState;
}
spm_corefi_tclMsgTunerStateStatus& spm_corefi_tclMsgTunerStateStatus::operator=(const spm_corefi_tclMsgTunerStateStatus& coRef)
{
   if (this == &coRef) return *this;
   TunerState = coRef.TunerState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgTunerStateStatus::spm_corefi_tclMsgTunerStateStatus()
:TunerState()
 {}

tS32 spm_corefi_tclMsgTunerStateStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_TUNERSTATESTATUS;
}


spm_corefi_tclMsgTunerStateStatus::~spm_corefi_tclMsgTunerStateStatus()
{}

tU32 spm_corefi_tclMsgTunerStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgTunerStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgTunerStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerState);
   return oOut;
}

tBool spm_corefi_tclMsgTunerStateStatus::operator==(const spm_corefi_tclMsgTunerStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerState == roRef.TunerState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgTunerStateUpReg::spm_corefi_tclMsgTunerStateUpReg()
 {}

tS32 spm_corefi_tclMsgTunerStateUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_TUNERSTATEUPREG;
}


spm_corefi_tclMsgTunerStateUpReg::~spm_corefi_tclMsgTunerStateUpReg()
{}

//=============================================================================

spm_corefi_tclMsgTunerStateRelUpReg::spm_corefi_tclMsgTunerStateRelUpReg()
 {}

tS32 spm_corefi_tclMsgTunerStateRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_TUNERSTATERELUPREG;
}


spm_corefi_tclMsgTunerStateRelUpReg::~spm_corefi_tclMsgTunerStateRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgTunerStateGet::spm_corefi_tclMsgTunerStateGet()
 {}

tS32 spm_corefi_tclMsgTunerStateGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_TUNERSTATEGET;
}


spm_corefi_tclMsgTunerStateGet::~spm_corefi_tclMsgTunerStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgWifiStateStatus::spm_corefi_tclMsgWifiStateStatus(const spm_corefi_tclMsgWifiStateStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   WiFiState = coRef.WiFiState;
}
spm_corefi_tclMsgWifiStateStatus& spm_corefi_tclMsgWifiStateStatus::operator=(const spm_corefi_tclMsgWifiStateStatus& coRef)
{
   if (this == &coRef) return *this;
   WiFiState = coRef.WiFiState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgWifiStateStatus::spm_corefi_tclMsgWifiStateStatus()
:WiFiState()
 {}

tS32 spm_corefi_tclMsgWifiStateStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_WIFISTATESTATUS;
}


spm_corefi_tclMsgWifiStateStatus::~spm_corefi_tclMsgWifiStateStatus()
{}

tU32 spm_corefi_tclMsgWifiStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgWifiStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> WiFiState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgWifiStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << WiFiState);
   return oOut;
}

tBool spm_corefi_tclMsgWifiStateStatus::operator==(const spm_corefi_tclMsgWifiStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (WiFiState == roRef.WiFiState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgWifiStateUpReg::spm_corefi_tclMsgWifiStateUpReg()
 {}

tS32 spm_corefi_tclMsgWifiStateUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_WIFISTATEUPREG;
}


spm_corefi_tclMsgWifiStateUpReg::~spm_corefi_tclMsgWifiStateUpReg()
{}

//=============================================================================

spm_corefi_tclMsgWifiStateRelUpReg::spm_corefi_tclMsgWifiStateRelUpReg()
 {}

tS32 spm_corefi_tclMsgWifiStateRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_WIFISTATERELUPREG;
}


spm_corefi_tclMsgWifiStateRelUpReg::~spm_corefi_tclMsgWifiStateRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgWifiStateGet::spm_corefi_tclMsgWifiStateGet()
 {}

tS32 spm_corefi_tclMsgWifiStateGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_WIFISTATEGET;
}


spm_corefi_tclMsgWifiStateGet::~spm_corefi_tclMsgWifiStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgOnOffReasonSet::spm_corefi_tclMsgOnOffReasonSet(const spm_corefi_tclMsgOnOffReasonSet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   OnOffReason = coRef.OnOffReason;
}
spm_corefi_tclMsgOnOffReasonSet& spm_corefi_tclMsgOnOffReasonSet::operator=(const spm_corefi_tclMsgOnOffReasonSet& coRef)
{
   if (this == &coRef) return *this;
   OnOffReason = coRef.OnOffReason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgOnOffReasonSet::spm_corefi_tclMsgOnOffReasonSet()
:OnOffReason()
 {}

tS32 spm_corefi_tclMsgOnOffReasonSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ONOFFREASONSET;
}


spm_corefi_tclMsgOnOffReasonSet::~spm_corefi_tclMsgOnOffReasonSet()
{}

tU32 spm_corefi_tclMsgOnOffReasonSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgOnOffReasonSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> OnOffReason);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgOnOffReasonSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << OnOffReason);
   return oOut;
}

tBool spm_corefi_tclMsgOnOffReasonSet::operator==(const spm_corefi_tclMsgOnOffReasonSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (OnOffReason == roRef.OnOffReason);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgOnOffReasonGet::spm_corefi_tclMsgOnOffReasonGet()
 {}

tS32 spm_corefi_tclMsgOnOffReasonGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ONOFFREASONGET;
}


spm_corefi_tclMsgOnOffReasonGet::~spm_corefi_tclMsgOnOffReasonGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgOnOffReasonStatus::spm_corefi_tclMsgOnOffReasonStatus(const spm_corefi_tclMsgOnOffReasonStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   OnOffReason = coRef.OnOffReason;
}
spm_corefi_tclMsgOnOffReasonStatus& spm_corefi_tclMsgOnOffReasonStatus::operator=(const spm_corefi_tclMsgOnOffReasonStatus& coRef)
{
   if (this == &coRef) return *this;
   OnOffReason = coRef.OnOffReason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgOnOffReasonStatus::spm_corefi_tclMsgOnOffReasonStatus()
:OnOffReason()
 {}

tS32 spm_corefi_tclMsgOnOffReasonStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ONOFFREASONSTATUS;
}


spm_corefi_tclMsgOnOffReasonStatus::~spm_corefi_tclMsgOnOffReasonStatus()
{}

tU32 spm_corefi_tclMsgOnOffReasonStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgOnOffReasonStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> OnOffReason);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgOnOffReasonStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << OnOffReason);
   return oOut;
}

tBool spm_corefi_tclMsgOnOffReasonStatus::operator==(const spm_corefi_tclMsgOnOffReasonStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (OnOffReason == roRef.OnOffReason);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgOnOffReasonUpReg::spm_corefi_tclMsgOnOffReasonUpReg()
 {}

tS32 spm_corefi_tclMsgOnOffReasonUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ONOFFREASONUPREG;
}


spm_corefi_tclMsgOnOffReasonUpReg::~spm_corefi_tclMsgOnOffReasonUpReg()
{}

//=============================================================================

spm_corefi_tclMsgOnOffReasonRelUpReg::spm_corefi_tclMsgOnOffReasonRelUpReg()
 {}

tS32 spm_corefi_tclMsgOnOffReasonRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ONOFFREASONRELUPREG;
}


spm_corefi_tclMsgOnOffReasonRelUpReg::~spm_corefi_tclMsgOnOffReasonRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgWakeupListSet::spm_corefi_tclMsgWakeupListSet(const spm_corefi_tclMsgWakeupListSet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   WakeupList = coRef.WakeupList;
}
spm_corefi_tclMsgWakeupListSet& spm_corefi_tclMsgWakeupListSet::operator=(const spm_corefi_tclMsgWakeupListSet& coRef)
{
   if (this == &coRef) return *this;
   WakeupList = coRef.WakeupList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgWakeupListSet::spm_corefi_tclMsgWakeupListSet()
:WakeupList(0)
 {}

tS32 spm_corefi_tclMsgWakeupListSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_WAKEUPLISTSET;
}


spm_corefi_tclMsgWakeupListSet::~spm_corefi_tclMsgWakeupListSet()
{}

tU32 spm_corefi_tclMsgWakeupListSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgWakeupListSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> WakeupList);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgWakeupListSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << WakeupList);
   return oOut;
}

tBool spm_corefi_tclMsgWakeupListSet::operator==(const spm_corefi_tclMsgWakeupListSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (WakeupList == roRef.WakeupList);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgWakeupListGet::spm_corefi_tclMsgWakeupListGet()
 {}

tS32 spm_corefi_tclMsgWakeupListGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_WAKEUPLISTGET;
}


spm_corefi_tclMsgWakeupListGet::~spm_corefi_tclMsgWakeupListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgWakeupListStatus::spm_corefi_tclMsgWakeupListStatus(const spm_corefi_tclMsgWakeupListStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   WakeUpReason1 = coRef.WakeUpReason1;
   WakeUpReason2 = coRef.WakeUpReason2;
   WakeUpReason3 = coRef.WakeUpReason3;
   WakeUpReason4 = coRef.WakeUpReason4;
   WakeUpReason5 = coRef.WakeUpReason5;
   WakeUpReason6 = coRef.WakeUpReason6;
   WakeUpReason7 = coRef.WakeUpReason7;
   WakeUpReason8 = coRef.WakeUpReason8;
   WakeUpReason9 = coRef.WakeUpReason9;
   WakeUpReason10 = coRef.WakeUpReason10;
}
spm_corefi_tclMsgWakeupListStatus& spm_corefi_tclMsgWakeupListStatus::operator=(const spm_corefi_tclMsgWakeupListStatus& coRef)
{
   if (this == &coRef) return *this;
   WakeUpReason1 = coRef.WakeUpReason1;
   WakeUpReason2 = coRef.WakeUpReason2;
   WakeUpReason3 = coRef.WakeUpReason3;
   WakeUpReason4 = coRef.WakeUpReason4;
   WakeUpReason5 = coRef.WakeUpReason5;
   WakeUpReason6 = coRef.WakeUpReason6;
   WakeUpReason7 = coRef.WakeUpReason7;
   WakeUpReason8 = coRef.WakeUpReason8;
   WakeUpReason9 = coRef.WakeUpReason9;
   WakeUpReason10 = coRef.WakeUpReason10;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgWakeupListStatus::spm_corefi_tclMsgWakeupListStatus()
:WakeUpReason1()
,WakeUpReason2()
,WakeUpReason3()
,WakeUpReason4()
,WakeUpReason5()
,WakeUpReason6()
,WakeUpReason7()
,WakeUpReason8()
,WakeUpReason9()
,WakeUpReason10()
 {}

tS32 spm_corefi_tclMsgWakeupListStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_WAKEUPLISTSTATUS;
}


spm_corefi_tclMsgWakeupListStatus::~spm_corefi_tclMsgWakeupListStatus()
{}

tU32 spm_corefi_tclMsgWakeupListStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& spm_corefi_tclMsgWakeupListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> WakeUpReason1);
   (tVoid) (oIn >> WakeUpReason2);
   (tVoid) (oIn >> WakeUpReason3);
   (tVoid) (oIn >> WakeUpReason4);
   (tVoid) (oIn >> WakeUpReason5);
   (tVoid) (oIn >> WakeUpReason6);
   (tVoid) (oIn >> WakeUpReason7);
   (tVoid) (oIn >> WakeUpReason8);
   (tVoid) (oIn >> WakeUpReason9);
   (tVoid) (oIn >> WakeUpReason10);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgWakeupListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << WakeUpReason1);
   (tVoid) (oOut << WakeUpReason2);
   (tVoid) (oOut << WakeUpReason3);
   (tVoid) (oOut << WakeUpReason4);
   (tVoid) (oOut << WakeUpReason5);
   (tVoid) (oOut << WakeUpReason6);
   (tVoid) (oOut << WakeUpReason7);
   (tVoid) (oOut << WakeUpReason8);
   (tVoid) (oOut << WakeUpReason9);
   (tVoid) (oOut << WakeUpReason10);
   return oOut;
}

tBool spm_corefi_tclMsgWakeupListStatus::operator==(const spm_corefi_tclMsgWakeupListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (WakeUpReason1 == roRef.WakeUpReason1);
   bResult = bResult && (WakeUpReason2 == roRef.WakeUpReason2);
   bResult = bResult && (WakeUpReason3 == roRef.WakeUpReason3);
   bResult = bResult && (WakeUpReason4 == roRef.WakeUpReason4);
   bResult = bResult && (WakeUpReason5 == roRef.WakeUpReason5);
   bResult = bResult && (WakeUpReason6 == roRef.WakeUpReason6);
   bResult = bResult && (WakeUpReason7 == roRef.WakeUpReason7);
   bResult = bResult && (WakeUpReason8 == roRef.WakeUpReason8);
   bResult = bResult && (WakeUpReason9 == roRef.WakeUpReason9);
   bResult = bResult && (WakeUpReason10 == roRef.WakeUpReason10);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgStartupFinishedUpReg::spm_corefi_tclMsgStartupFinishedUpReg()
 {}

tS32 spm_corefi_tclMsgStartupFinishedUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_STARTUPFINISHEDUPREG;
}


spm_corefi_tclMsgStartupFinishedUpReg::~spm_corefi_tclMsgStartupFinishedUpReg()
{}

//=============================================================================

spm_corefi_tclMsgStartupFinishedRelUpReg::spm_corefi_tclMsgStartupFinishedRelUpReg()
 {}

tS32 spm_corefi_tclMsgStartupFinishedRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_STARTUPFINISHEDRELUPREG;
}


spm_corefi_tclMsgStartupFinishedRelUpReg::~spm_corefi_tclMsgStartupFinishedRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgStartupFinishedGet::spm_corefi_tclMsgStartupFinishedGet()
 {}

tS32 spm_corefi_tclMsgStartupFinishedGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_STARTUPFINISHEDGET;
}


spm_corefi_tclMsgStartupFinishedGet::~spm_corefi_tclMsgStartupFinishedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgStartupFinishedStatus::spm_corefi_tclMsgStartupFinishedStatus(const spm_corefi_tclMsgStartupFinishedStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   StartupFinishedState = coRef.StartupFinishedState;
}
spm_corefi_tclMsgStartupFinishedStatus& spm_corefi_tclMsgStartupFinishedStatus::operator=(const spm_corefi_tclMsgStartupFinishedStatus& coRef)
{
   if (this == &coRef) return *this;
   StartupFinishedState = coRef.StartupFinishedState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgStartupFinishedStatus::spm_corefi_tclMsgStartupFinishedStatus()
:StartupFinishedState(0)
 {}

tS32 spm_corefi_tclMsgStartupFinishedStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_STARTUPFINISHEDSTATUS;
}


spm_corefi_tclMsgStartupFinishedStatus::~spm_corefi_tclMsgStartupFinishedStatus()
{}

tU32 spm_corefi_tclMsgStartupFinishedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_corefi_tclMsgStartupFinishedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StartupFinishedState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgStartupFinishedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StartupFinishedState);
   return oOut;
}

tBool spm_corefi_tclMsgStartupFinishedStatus::operator==(const spm_corefi_tclMsgStartupFinishedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StartupFinishedState == roRef.StartupFinishedState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgSysStateUpReg::spm_corefi_tclMsgSysStateUpReg()
 {}

tS32 spm_corefi_tclMsgSysStateUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SYSSTATEUPREG;
}


spm_corefi_tclMsgSysStateUpReg::~spm_corefi_tclMsgSysStateUpReg()
{}

//=============================================================================

spm_corefi_tclMsgSysStateRelUpReg::spm_corefi_tclMsgSysStateRelUpReg()
 {}

tS32 spm_corefi_tclMsgSysStateRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SYSSTATERELUPREG;
}


spm_corefi_tclMsgSysStateRelUpReg::~spm_corefi_tclMsgSysStateRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgSysStateGet::spm_corefi_tclMsgSysStateGet()
 {}

tS32 spm_corefi_tclMsgSysStateGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SYSSTATEGET;
}


spm_corefi_tclMsgSysStateGet::~spm_corefi_tclMsgSysStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSysStateStatus::spm_corefi_tclMsgSysStateStatus(const spm_corefi_tclMsgSysStateStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   SysState = coRef.SysState;
}
spm_corefi_tclMsgSysStateStatus& spm_corefi_tclMsgSysStateStatus::operator=(const spm_corefi_tclMsgSysStateStatus& coRef)
{
   if (this == &coRef) return *this;
   SysState = coRef.SysState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgSysStateStatus::spm_corefi_tclMsgSysStateStatus()
:SysState()
 {}

tS32 spm_corefi_tclMsgSysStateStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SYSSTATESTATUS;
}


spm_corefi_tclMsgSysStateStatus::~spm_corefi_tclMsgSysStateStatus()
{}

tU32 spm_corefi_tclMsgSysStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgSysStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SysState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSysStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SysState);
   return oOut;
}

tBool spm_corefi_tclMsgSysStateStatus::operator==(const spm_corefi_tclMsgSysStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SysState == roRef.SysState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgMostStateUpReg::spm_corefi_tclMsgMostStateUpReg()
 {}

tS32 spm_corefi_tclMsgMostStateUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_MOSTSTATEUPREG;
}


spm_corefi_tclMsgMostStateUpReg::~spm_corefi_tclMsgMostStateUpReg()
{}

//=============================================================================

spm_corefi_tclMsgMostStateRelUpReg::spm_corefi_tclMsgMostStateRelUpReg()
 {}

tS32 spm_corefi_tclMsgMostStateRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_MOSTSTATERELUPREG;
}


spm_corefi_tclMsgMostStateRelUpReg::~spm_corefi_tclMsgMostStateRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgMostStateGet::spm_corefi_tclMsgMostStateGet()
 {}

tS32 spm_corefi_tclMsgMostStateGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_MOSTSTATEGET;
}


spm_corefi_tclMsgMostStateGet::~spm_corefi_tclMsgMostStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgMostStateStatus::spm_corefi_tclMsgMostStateStatus(const spm_corefi_tclMsgMostStateStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   MostEvent = coRef.MostEvent;
   MostConfigurationState = coRef.MostConfigurationState;
   FirstReceiveTime = coRef.FirstReceiveTime;
   TLAState = coRef.TLAState;
   OvertemperatureMostOff = coRef.OvertemperatureMostOff;
}
spm_corefi_tclMsgMostStateStatus& spm_corefi_tclMsgMostStateStatus::operator=(const spm_corefi_tclMsgMostStateStatus& coRef)
{
   if (this == &coRef) return *this;
   MostEvent = coRef.MostEvent;
   MostConfigurationState = coRef.MostConfigurationState;
   FirstReceiveTime = coRef.FirstReceiveTime;
   TLAState = coRef.TLAState;
   OvertemperatureMostOff = coRef.OvertemperatureMostOff;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgMostStateStatus::spm_corefi_tclMsgMostStateStatus()
:MostEvent()
,MostConfigurationState()
,FirstReceiveTime(0)
,TLAState()
,OvertemperatureMostOff(0)
 {}

tS32 spm_corefi_tclMsgMostStateStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_MOSTSTATESTATUS;
}


spm_corefi_tclMsgMostStateStatus::~spm_corefi_tclMsgMostStateStatus()
{}

tU32 spm_corefi_tclMsgMostStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 17;
}

fi_tclInContext& spm_corefi_tclMsgMostStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MostEvent);
   (tVoid) (oIn >> MostConfigurationState);
   (tVoid) (oIn >> FirstReceiveTime);
   (tVoid) (oIn >> TLAState);
   (tVoid) (oIn >> OvertemperatureMostOff);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgMostStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MostEvent);
   (tVoid) (oOut << MostConfigurationState);
   (tVoid) (oOut << FirstReceiveTime);
   (tVoid) (oOut << TLAState);
   (tVoid) (oOut << OvertemperatureMostOff);
   return oOut;
}

tBool spm_corefi_tclMsgMostStateStatus::operator==(const spm_corefi_tclMsgMostStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MostEvent == roRef.MostEvent);
   bResult = bResult && (MostConfigurationState == roRef.MostConfigurationState);
   bResult = bResult && (FirstReceiveTime == roRef.FirstReceiveTime);
   bResult = bResult && (TLAState == roRef.TLAState);
   bResult = bResult && (OvertemperatureMostOff == roRef.OvertemperatureMostOff);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgMostVersionGet::spm_corefi_tclMsgMostVersionGet()
 {}

tS32 spm_corefi_tclMsgMostVersionGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_MOSTVERSIONGET;
}


spm_corefi_tclMsgMostVersionGet::~spm_corefi_tclMsgMostVersionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgMostVersionStatus::spm_corefi_tclMsgMostVersionStatus(const spm_corefi_tclMsgMostVersionStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   MostVersion = coRef.MostVersion;
}
spm_corefi_tclMsgMostVersionStatus& spm_corefi_tclMsgMostVersionStatus::operator=(const spm_corefi_tclMsgMostVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   MostVersion = coRef.MostVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgMostVersionStatus::vDestroy()
{
   MostVersion.vDestroy();
}

spm_corefi_tclMsgMostVersionStatus::spm_corefi_tclMsgMostVersionStatus()
:MostVersion()
 {}

tS32 spm_corefi_tclMsgMostVersionStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_MOSTVERSIONSTATUS;
}


spm_corefi_tclMsgMostVersionStatus::~spm_corefi_tclMsgMostVersionStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgMostVersionStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+MostVersion.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_corefi_tclMsgMostVersionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MostVersion);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgMostVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MostVersion);
   return oOut;
}

tBool spm_corefi_tclMsgMostVersionStatus::operator==(const spm_corefi_tclMsgMostVersionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MostVersion == roRef.MostVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgRVCStateSet::spm_corefi_tclMsgRVCStateSet(const spm_corefi_tclMsgRVCStateSet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   State = coRef.State;
}
spm_corefi_tclMsgRVCStateSet& spm_corefi_tclMsgRVCStateSet::operator=(const spm_corefi_tclMsgRVCStateSet& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgRVCStateSet::spm_corefi_tclMsgRVCStateSet()
:State(0)
 {}

tS32 spm_corefi_tclMsgRVCStateSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RVCSTATESET;
}


spm_corefi_tclMsgRVCStateSet::~spm_corefi_tclMsgRVCStateSet()
{}

tU32 spm_corefi_tclMsgRVCStateSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_corefi_tclMsgRVCStateSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgRVCStateSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   return oOut;
}

tBool spm_corefi_tclMsgRVCStateSet::operator==(const spm_corefi_tclMsgRVCStateSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgRVCStateGet::spm_corefi_tclMsgRVCStateGet()
 {}

tS32 spm_corefi_tclMsgRVCStateGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RVCSTATEGET;
}


spm_corefi_tclMsgRVCStateGet::~spm_corefi_tclMsgRVCStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgRVCStateStatus::spm_corefi_tclMsgRVCStateStatus(const spm_corefi_tclMsgRVCStateStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   State = coRef.State;
}
spm_corefi_tclMsgRVCStateStatus& spm_corefi_tclMsgRVCStateStatus::operator=(const spm_corefi_tclMsgRVCStateStatus& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgRVCStateStatus::spm_corefi_tclMsgRVCStateStatus()
:State(0)
 {}

tS32 spm_corefi_tclMsgRVCStateStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_RVCSTATESTATUS;
}


spm_corefi_tclMsgRVCStateStatus::~spm_corefi_tclMsgRVCStateStatus()
{}

tU32 spm_corefi_tclMsgRVCStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_corefi_tclMsgRVCStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgRVCStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   return oOut;
}

tBool spm_corefi_tclMsgRVCStateStatus::operator==(const spm_corefi_tclMsgRVCStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgTriggerMostRemoteResetGet::spm_corefi_tclMsgTriggerMostRemoteResetGet()
 {}

tS32 spm_corefi_tclMsgTriggerMostRemoteResetGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_TRIGGERMOSTREMOTERESETGET;
}


spm_corefi_tclMsgTriggerMostRemoteResetGet::~spm_corefi_tclMsgTriggerMostRemoteResetGet()
{}

//=============================================================================

spm_corefi_tclMsgTriggerMostRemoteResetSet::spm_corefi_tclMsgTriggerMostRemoteResetSet()
 {}

tS32 spm_corefi_tclMsgTriggerMostRemoteResetSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_TRIGGERMOSTREMOTERESETSET;
}


spm_corefi_tclMsgTriggerMostRemoteResetSet::~spm_corefi_tclMsgTriggerMostRemoteResetSet()
{}

//=============================================================================

spm_corefi_tclMsgTriggerMostRemoteResetUpReg::spm_corefi_tclMsgTriggerMostRemoteResetUpReg()
 {}

tS32 spm_corefi_tclMsgTriggerMostRemoteResetUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_TRIGGERMOSTREMOTERESETUPREG;
}


spm_corefi_tclMsgTriggerMostRemoteResetUpReg::~spm_corefi_tclMsgTriggerMostRemoteResetUpReg()
{}

//=============================================================================

spm_corefi_tclMsgTriggerMostRemoteResetRelUpReg::spm_corefi_tclMsgTriggerMostRemoteResetRelUpReg()
 {}

tS32 spm_corefi_tclMsgTriggerMostRemoteResetRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_TRIGGERMOSTREMOTERESETRELUPREG;
}


spm_corefi_tclMsgTriggerMostRemoteResetRelUpReg::~spm_corefi_tclMsgTriggerMostRemoteResetRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgTriggerMostRemoteResetStatus::spm_corefi_tclMsgTriggerMostRemoteResetStatus(const spm_corefi_tclMsgTriggerMostRemoteResetStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   Trigger = coRef.Trigger;
}
spm_corefi_tclMsgTriggerMostRemoteResetStatus& spm_corefi_tclMsgTriggerMostRemoteResetStatus::operator=(const spm_corefi_tclMsgTriggerMostRemoteResetStatus& coRef)
{
   if (this == &coRef) return *this;
   Trigger = coRef.Trigger;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgTriggerMostRemoteResetStatus::spm_corefi_tclMsgTriggerMostRemoteResetStatus()
:Trigger(0)
 {}

tS32 spm_corefi_tclMsgTriggerMostRemoteResetStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_TRIGGERMOSTREMOTERESETSTATUS;
}


spm_corefi_tclMsgTriggerMostRemoteResetStatus::~spm_corefi_tclMsgTriggerMostRemoteResetStatus()
{}

tU32 spm_corefi_tclMsgTriggerMostRemoteResetStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgTriggerMostRemoteResetStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Trigger);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgTriggerMostRemoteResetStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Trigger);
   return oOut;
}

tBool spm_corefi_tclMsgTriggerMostRemoteResetStatus::operator==(const spm_corefi_tclMsgTriggerMostRemoteResetStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Trigger == roRef.Trigger);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgPartnumberGet::spm_corefi_tclMsgPartnumberGet(const spm_corefi_tclMsgPartnumberGet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   Part = coRef.Part;
}
spm_corefi_tclMsgPartnumberGet& spm_corefi_tclMsgPartnumberGet::operator=(const spm_corefi_tclMsgPartnumberGet& coRef)
{
   if (this == &coRef) return *this;
   Part = coRef.Part;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgPartnumberGet::vDestroy()
{
   Part.vDestroy();
}

spm_corefi_tclMsgPartnumberGet::spm_corefi_tclMsgPartnumberGet()
:Part()
 {}

tS32 spm_corefi_tclMsgPartnumberGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_PARTNUMBERGET;
}


spm_corefi_tclMsgPartnumberGet::~spm_corefi_tclMsgPartnumberGet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgPartnumberGet::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Part.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_corefi_tclMsgPartnumberGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Part);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgPartnumberGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Part);
   return oOut;
}

tBool spm_corefi_tclMsgPartnumberGet::operator==(const spm_corefi_tclMsgPartnumberGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Part == roRef.Part);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgPartnumberSet::spm_corefi_tclMsgPartnumberSet(const spm_corefi_tclMsgPartnumberSet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   Part = coRef.Part;
   Number = coRef.Number;
}
spm_corefi_tclMsgPartnumberSet& spm_corefi_tclMsgPartnumberSet::operator=(const spm_corefi_tclMsgPartnumberSet& coRef)
{
   if (this == &coRef) return *this;
   Part = coRef.Part;
   Number = coRef.Number;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgPartnumberSet::vDestroy()
{
   Part.vDestroy();
}

spm_corefi_tclMsgPartnumberSet::spm_corefi_tclMsgPartnumberSet()
:Part()
,Number(0)
 {}

tS32 spm_corefi_tclMsgPartnumberSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_PARTNUMBERSET;
}


spm_corefi_tclMsgPartnumberSet::~spm_corefi_tclMsgPartnumberSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgPartnumberSet::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+Part.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_corefi_tclMsgPartnumberSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Part);
   (tVoid) (oIn >> Number);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgPartnumberSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Part);
   (tVoid) (oOut << Number);
   return oOut;
}

tBool spm_corefi_tclMsgPartnumberSet::operator==(const spm_corefi_tclMsgPartnumberSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Part == roRef.Part);
   bResult = bResult && (Number == roRef.Number);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgPartnumberStatus::spm_corefi_tclMsgPartnumberStatus(const spm_corefi_tclMsgPartnumberStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   Partnumber = coRef.Partnumber;
}
spm_corefi_tclMsgPartnumberStatus& spm_corefi_tclMsgPartnumberStatus::operator=(const spm_corefi_tclMsgPartnumberStatus& coRef)
{
   if (this == &coRef) return *this;
   Partnumber = coRef.Partnumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgPartnumberStatus::spm_corefi_tclMsgPartnumberStatus()
:Partnumber(0)
 {}

tS32 spm_corefi_tclMsgPartnumberStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_PARTNUMBERSTATUS;
}


spm_corefi_tclMsgPartnumberStatus::~spm_corefi_tclMsgPartnumberStatus()
{}

tU32 spm_corefi_tclMsgPartnumberStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgPartnumberStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Partnumber);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgPartnumberStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Partnumber);
   return oOut;
}

tBool spm_corefi_tclMsgPartnumberStatus::operator==(const spm_corefi_tclMsgPartnumberStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Partnumber == roRef.Partnumber);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgPartnumbersGet::spm_corefi_tclMsgPartnumbersGet()
 {}

tS32 spm_corefi_tclMsgPartnumbersGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_PARTNUMBERSGET;
}


spm_corefi_tclMsgPartnumbersGet::~spm_corefi_tclMsgPartnumbersGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgPartnumbersStatus::spm_corefi_tclMsgPartnumbersStatus(const spm_corefi_tclMsgPartnumbersStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   Parts = coRef.Parts;
}
spm_corefi_tclMsgPartnumbersStatus& spm_corefi_tclMsgPartnumbersStatus::operator=(const spm_corefi_tclMsgPartnumbersStatus& coRef)
{
   if (this == &coRef) return *this;
   Parts = coRef.Parts;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgPartnumbersStatus::vDestroy()
{
   Parts.vDestroy(); 
}

spm_corefi_tclMsgPartnumbersStatus::spm_corefi_tclMsgPartnumbersStatus()
:Parts()
 {}

tS32 spm_corefi_tclMsgPartnumbersStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_PARTNUMBERSSTATUS;
}


spm_corefi_tclMsgPartnumbersStatus::~spm_corefi_tclMsgPartnumbersStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgPartnumbersStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Parts.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_corefi_tclMsgPartnumbersStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Parts);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgPartnumbersStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Parts);
   return oOut;
}

tBool spm_corefi_tclMsgPartnumbersStatus::operator==(const spm_corefi_tclMsgPartnumbersStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Parts == roRef.Parts);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgAlphacodeGet::spm_corefi_tclMsgAlphacodeGet(const spm_corefi_tclMsgAlphacodeGet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   Part = coRef.Part;
}
spm_corefi_tclMsgAlphacodeGet& spm_corefi_tclMsgAlphacodeGet::operator=(const spm_corefi_tclMsgAlphacodeGet& coRef)
{
   if (this == &coRef) return *this;
   Part = coRef.Part;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgAlphacodeGet::vDestroy()
{
   Part.vDestroy();
}

spm_corefi_tclMsgAlphacodeGet::spm_corefi_tclMsgAlphacodeGet()
:Part()
 {}

tS32 spm_corefi_tclMsgAlphacodeGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ALPHACODEGET;
}


spm_corefi_tclMsgAlphacodeGet::~spm_corefi_tclMsgAlphacodeGet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgAlphacodeGet::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Part.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_corefi_tclMsgAlphacodeGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Part);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgAlphacodeGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Part);
   return oOut;
}

tBool spm_corefi_tclMsgAlphacodeGet::operator==(const spm_corefi_tclMsgAlphacodeGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Part == roRef.Part);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgAlphacodeSet::spm_corefi_tclMsgAlphacodeSet(const spm_corefi_tclMsgAlphacodeSet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   Part = coRef.Part;
   Alphacode1 = coRef.Alphacode1;
   Alphacode2 = coRef.Alphacode2;
}
spm_corefi_tclMsgAlphacodeSet& spm_corefi_tclMsgAlphacodeSet::operator=(const spm_corefi_tclMsgAlphacodeSet& coRef)
{
   if (this == &coRef) return *this;
   Part = coRef.Part;
   Alphacode1 = coRef.Alphacode1;
   Alphacode2 = coRef.Alphacode2;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgAlphacodeSet::vDestroy()
{
   Part.vDestroy();
}

spm_corefi_tclMsgAlphacodeSet::spm_corefi_tclMsgAlphacodeSet()
:Part()
,Alphacode1(0)
,Alphacode2(0)
 {}

tS32 spm_corefi_tclMsgAlphacodeSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ALPHACODESET;
}


spm_corefi_tclMsgAlphacodeSet::~spm_corefi_tclMsgAlphacodeSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgAlphacodeSet::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+Part.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_corefi_tclMsgAlphacodeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Part);
   (tVoid) (oIn >> Alphacode1);
   (tVoid) (oIn >> Alphacode2);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgAlphacodeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Part);
   (tVoid) (oOut << Alphacode1);
   (tVoid) (oOut << Alphacode2);
   return oOut;
}

tBool spm_corefi_tclMsgAlphacodeSet::operator==(const spm_corefi_tclMsgAlphacodeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Part == roRef.Part);
   bResult = bResult && (Alphacode1 == roRef.Alphacode1);
   bResult = bResult && (Alphacode2 == roRef.Alphacode2);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgAlphacodeStatus::spm_corefi_tclMsgAlphacodeStatus(const spm_corefi_tclMsgAlphacodeStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   Alphacode1 = coRef.Alphacode1;
   Alphacode2 = coRef.Alphacode2;
}
spm_corefi_tclMsgAlphacodeStatus& spm_corefi_tclMsgAlphacodeStatus::operator=(const spm_corefi_tclMsgAlphacodeStatus& coRef)
{
   if (this == &coRef) return *this;
   Alphacode1 = coRef.Alphacode1;
   Alphacode2 = coRef.Alphacode2;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgAlphacodeStatus::spm_corefi_tclMsgAlphacodeStatus()
:Alphacode1(0)
,Alphacode2(0)
 {}

tS32 spm_corefi_tclMsgAlphacodeStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ALPHACODESTATUS;
}


spm_corefi_tclMsgAlphacodeStatus::~spm_corefi_tclMsgAlphacodeStatus()
{}

tU32 spm_corefi_tclMsgAlphacodeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& spm_corefi_tclMsgAlphacodeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Alphacode1);
   (tVoid) (oIn >> Alphacode2);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgAlphacodeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Alphacode1);
   (tVoid) (oOut << Alphacode2);
   return oOut;
}

tBool spm_corefi_tclMsgAlphacodeStatus::operator==(const spm_corefi_tclMsgAlphacodeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Alphacode1 == roRef.Alphacode1);
   bResult = bResult && (Alphacode2 == roRef.Alphacode2);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgAlphacodesGet::spm_corefi_tclMsgAlphacodesGet()
 {}

tS32 spm_corefi_tclMsgAlphacodesGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ALPHACODESGET;
}


spm_corefi_tclMsgAlphacodesGet::~spm_corefi_tclMsgAlphacodesGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgAlphacodesStatus::spm_corefi_tclMsgAlphacodesStatus(const spm_corefi_tclMsgAlphacodesStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   Parts = coRef.Parts;
}
spm_corefi_tclMsgAlphacodesStatus& spm_corefi_tclMsgAlphacodesStatus::operator=(const spm_corefi_tclMsgAlphacodesStatus& coRef)
{
   if (this == &coRef) return *this;
   Parts = coRef.Parts;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgAlphacodesStatus::vDestroy()
{
   Parts.vDestroy(); 
}

spm_corefi_tclMsgAlphacodesStatus::spm_corefi_tclMsgAlphacodesStatus()
:Parts()
 {}

tS32 spm_corefi_tclMsgAlphacodesStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ALPHACODESSTATUS;
}


spm_corefi_tclMsgAlphacodesStatus::~spm_corefi_tclMsgAlphacodesStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgAlphacodesStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Parts.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_corefi_tclMsgAlphacodesStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Parts);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgAlphacodesStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Parts);
   return oOut;
}

tBool spm_corefi_tclMsgAlphacodesStatus::operator==(const spm_corefi_tclMsgAlphacodesStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Parts == roRef.Parts);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgManufacturersEnableCounterGet::spm_corefi_tclMsgManufacturersEnableCounterGet()
 {}

tS32 spm_corefi_tclMsgManufacturersEnableCounterGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_MANUFACTURERSENABLECOUNTERGET;
}


spm_corefi_tclMsgManufacturersEnableCounterGet::~spm_corefi_tclMsgManufacturersEnableCounterGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgManufacturersEnableCounterSet::spm_corefi_tclMsgManufacturersEnableCounterSet(const spm_corefi_tclMsgManufacturersEnableCounterSet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   MEC = coRef.MEC;
}
spm_corefi_tclMsgManufacturersEnableCounterSet& spm_corefi_tclMsgManufacturersEnableCounterSet::operator=(const spm_corefi_tclMsgManufacturersEnableCounterSet& coRef)
{
   if (this == &coRef) return *this;
   MEC = coRef.MEC;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgManufacturersEnableCounterSet::spm_corefi_tclMsgManufacturersEnableCounterSet()
:MEC(0)
 {}

tS32 spm_corefi_tclMsgManufacturersEnableCounterSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_MANUFACTURERSENABLECOUNTERSET;
}


spm_corefi_tclMsgManufacturersEnableCounterSet::~spm_corefi_tclMsgManufacturersEnableCounterSet()
{}

tU32 spm_corefi_tclMsgManufacturersEnableCounterSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_corefi_tclMsgManufacturersEnableCounterSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MEC);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgManufacturersEnableCounterSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MEC);
   return oOut;
}

tBool spm_corefi_tclMsgManufacturersEnableCounterSet::operator==(const spm_corefi_tclMsgManufacturersEnableCounterSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MEC == roRef.MEC);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgManufacturersEnableCounterStatus::spm_corefi_tclMsgManufacturersEnableCounterStatus(const spm_corefi_tclMsgManufacturersEnableCounterStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   MEC = coRef.MEC;
}
spm_corefi_tclMsgManufacturersEnableCounterStatus& spm_corefi_tclMsgManufacturersEnableCounterStatus::operator=(const spm_corefi_tclMsgManufacturersEnableCounterStatus& coRef)
{
   if (this == &coRef) return *this;
   MEC = coRef.MEC;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgManufacturersEnableCounterStatus::spm_corefi_tclMsgManufacturersEnableCounterStatus()
:MEC(0)
 {}

tS32 spm_corefi_tclMsgManufacturersEnableCounterStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_MANUFACTURERSENABLECOUNTERSTATUS;
}


spm_corefi_tclMsgManufacturersEnableCounterStatus::~spm_corefi_tclMsgManufacturersEnableCounterStatus()
{}

tU32 spm_corefi_tclMsgManufacturersEnableCounterStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_corefi_tclMsgManufacturersEnableCounterStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MEC);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgManufacturersEnableCounterStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MEC);
   return oOut;
}

tBool spm_corefi_tclMsgManufacturersEnableCounterStatus::operator==(const spm_corefi_tclMsgManufacturersEnableCounterStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MEC == roRef.MEC);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgNoCalibrationStateGet::spm_corefi_tclMsgNoCalibrationStateGet()
 {}

tS32 spm_corefi_tclMsgNoCalibrationStateGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_NOCALIBRATIONSTATEGET;
}


spm_corefi_tclMsgNoCalibrationStateGet::~spm_corefi_tclMsgNoCalibrationStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgNoCalibrationStateSet::spm_corefi_tclMsgNoCalibrationStateSet(const spm_corefi_tclMsgNoCalibrationStateSet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   State = coRef.State;
}
spm_corefi_tclMsgNoCalibrationStateSet& spm_corefi_tclMsgNoCalibrationStateSet::operator=(const spm_corefi_tclMsgNoCalibrationStateSet& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgNoCalibrationStateSet::spm_corefi_tclMsgNoCalibrationStateSet()
:State(0)
 {}

tS32 spm_corefi_tclMsgNoCalibrationStateSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_NOCALIBRATIONSTATESET;
}


spm_corefi_tclMsgNoCalibrationStateSet::~spm_corefi_tclMsgNoCalibrationStateSet()
{}

tU32 spm_corefi_tclMsgNoCalibrationStateSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_corefi_tclMsgNoCalibrationStateSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgNoCalibrationStateSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   return oOut;
}

tBool spm_corefi_tclMsgNoCalibrationStateSet::operator==(const spm_corefi_tclMsgNoCalibrationStateSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgNoCalibrationStateStatus::spm_corefi_tclMsgNoCalibrationStateStatus(const spm_corefi_tclMsgNoCalibrationStateStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   State = coRef.State;
}
spm_corefi_tclMsgNoCalibrationStateStatus& spm_corefi_tclMsgNoCalibrationStateStatus::operator=(const spm_corefi_tclMsgNoCalibrationStateStatus& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgNoCalibrationStateStatus::spm_corefi_tclMsgNoCalibrationStateStatus()
:State(0)
 {}

tS32 spm_corefi_tclMsgNoCalibrationStateStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_NOCALIBRATIONSTATESTATUS;
}


spm_corefi_tclMsgNoCalibrationStateStatus::~spm_corefi_tclMsgNoCalibrationStateStatus()
{}

tU32 spm_corefi_tclMsgNoCalibrationStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_corefi_tclMsgNoCalibrationStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgNoCalibrationStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   return oOut;
}

tBool spm_corefi_tclMsgNoCalibrationStateStatus::operator==(const spm_corefi_tclMsgNoCalibrationStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgSecurityCommErrorGet::spm_corefi_tclMsgSecurityCommErrorGet()
 {}

tS32 spm_corefi_tclMsgSecurityCommErrorGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SECURITYCOMMERRORGET;
}


spm_corefi_tclMsgSecurityCommErrorGet::~spm_corefi_tclMsgSecurityCommErrorGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSecurityCommErrorStatus::spm_corefi_tclMsgSecurityCommErrorStatus(const spm_corefi_tclMsgSecurityCommErrorStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   CommErrorCount = coRef.CommErrorCount;
}
spm_corefi_tclMsgSecurityCommErrorStatus& spm_corefi_tclMsgSecurityCommErrorStatus::operator=(const spm_corefi_tclMsgSecurityCommErrorStatus& coRef)
{
   if (this == &coRef) return *this;
   CommErrorCount = coRef.CommErrorCount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgSecurityCommErrorStatus::spm_corefi_tclMsgSecurityCommErrorStatus()
:CommErrorCount(0)
 {}

tS32 spm_corefi_tclMsgSecurityCommErrorStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SECURITYCOMMERRORSTATUS;
}


spm_corefi_tclMsgSecurityCommErrorStatus::~spm_corefi_tclMsgSecurityCommErrorStatus()
{}

tU32 spm_corefi_tclMsgSecurityCommErrorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& spm_corefi_tclMsgSecurityCommErrorStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CommErrorCount);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSecurityCommErrorStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CommErrorCount);
   return oOut;
}

tBool spm_corefi_tclMsgSecurityCommErrorStatus::operator==(const spm_corefi_tclMsgSecurityCommErrorStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CommErrorCount == roRef.CommErrorCount);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgSecurityMoreThan10VinGet::spm_corefi_tclMsgSecurityMoreThan10VinGet()
 {}

tS32 spm_corefi_tclMsgSecurityMoreThan10VinGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SECURITYMORETHAN10VINGET;
}


spm_corefi_tclMsgSecurityMoreThan10VinGet::~spm_corefi_tclMsgSecurityMoreThan10VinGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSecurityMoreThan10VinStatus::spm_corefi_tclMsgSecurityMoreThan10VinStatus(const spm_corefi_tclMsgSecurityMoreThan10VinStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   MoreThan10VinCount = coRef.MoreThan10VinCount;
}
spm_corefi_tclMsgSecurityMoreThan10VinStatus& spm_corefi_tclMsgSecurityMoreThan10VinStatus::operator=(const spm_corefi_tclMsgSecurityMoreThan10VinStatus& coRef)
{
   if (this == &coRef) return *this;
   MoreThan10VinCount = coRef.MoreThan10VinCount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgSecurityMoreThan10VinStatus::spm_corefi_tclMsgSecurityMoreThan10VinStatus()
:MoreThan10VinCount(0)
 {}

tS32 spm_corefi_tclMsgSecurityMoreThan10VinStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SECURITYMORETHAN10VINSTATUS;
}


spm_corefi_tclMsgSecurityMoreThan10VinStatus::~spm_corefi_tclMsgSecurityMoreThan10VinStatus()
{}

tU32 spm_corefi_tclMsgSecurityMoreThan10VinStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& spm_corefi_tclMsgSecurityMoreThan10VinStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MoreThan10VinCount);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSecurityMoreThan10VinStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MoreThan10VinCount);
   return oOut;
}

tBool spm_corefi_tclMsgSecurityMoreThan10VinStatus::operator==(const spm_corefi_tclMsgSecurityMoreThan10VinStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MoreThan10VinCount == roRef.MoreThan10VinCount);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgSecurityInvalidVinGet::spm_corefi_tclMsgSecurityInvalidVinGet()
 {}

tS32 spm_corefi_tclMsgSecurityInvalidVinGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SECURITYINVALIDVINGET;
}


spm_corefi_tclMsgSecurityInvalidVinGet::~spm_corefi_tclMsgSecurityInvalidVinGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSecurityInvalidVinStatus::spm_corefi_tclMsgSecurityInvalidVinStatus(const spm_corefi_tclMsgSecurityInvalidVinStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   InvalidVinCount = coRef.InvalidVinCount;
}
spm_corefi_tclMsgSecurityInvalidVinStatus& spm_corefi_tclMsgSecurityInvalidVinStatus::operator=(const spm_corefi_tclMsgSecurityInvalidVinStatus& coRef)
{
   if (this == &coRef) return *this;
   InvalidVinCount = coRef.InvalidVinCount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgSecurityInvalidVinStatus::spm_corefi_tclMsgSecurityInvalidVinStatus()
:InvalidVinCount(0)
 {}

tS32 spm_corefi_tclMsgSecurityInvalidVinStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SECURITYINVALIDVINSTATUS;
}


spm_corefi_tclMsgSecurityInvalidVinStatus::~spm_corefi_tclMsgSecurityInvalidVinStatus()
{}

tU32 spm_corefi_tclMsgSecurityInvalidVinStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& spm_corefi_tclMsgSecurityInvalidVinStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> InvalidVinCount);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSecurityInvalidVinStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << InvalidVinCount);
   return oOut;
}

tBool spm_corefi_tclMsgSecurityInvalidVinStatus::operator==(const spm_corefi_tclMsgSecurityInvalidVinStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (InvalidVinCount == roRef.InvalidVinCount);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgSecurityCurrentVinGet::spm_corefi_tclMsgSecurityCurrentVinGet()
 {}

tS32 spm_corefi_tclMsgSecurityCurrentVinGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SECURITYCURRENTVINGET;
}


spm_corefi_tclMsgSecurityCurrentVinGet::~spm_corefi_tclMsgSecurityCurrentVinGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSecurityCurrentVinStatus::spm_corefi_tclMsgSecurityCurrentVinStatus(const spm_corefi_tclMsgSecurityCurrentVinStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   CurrentVin = coRef.CurrentVin;
}
spm_corefi_tclMsgSecurityCurrentVinStatus& spm_corefi_tclMsgSecurityCurrentVinStatus::operator=(const spm_corefi_tclMsgSecurityCurrentVinStatus& coRef)
{
   if (this == &coRef) return *this;
   CurrentVin = coRef.CurrentVin;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgSecurityCurrentVinStatus::vDestroy()
{
   CurrentVin.vDestroy(); 
}

spm_corefi_tclMsgSecurityCurrentVinStatus::spm_corefi_tclMsgSecurityCurrentVinStatus()
:CurrentVin()
 {}

tS32 spm_corefi_tclMsgSecurityCurrentVinStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SECURITYCURRENTVINSTATUS;
}


spm_corefi_tclMsgSecurityCurrentVinStatus::~spm_corefi_tclMsgSecurityCurrentVinStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgSecurityCurrentVinStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+CurrentVin.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_corefi_tclMsgSecurityCurrentVinStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CurrentVin);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSecurityCurrentVinStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CurrentVin);
   return oOut;
}

tBool spm_corefi_tclMsgSecurityCurrentVinStatus::operator==(const spm_corefi_tclMsgSecurityCurrentVinStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CurrentVin == roRef.CurrentVin);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgSecurityVinHistoryGet::spm_corefi_tclMsgSecurityVinHistoryGet()
 {}

tS32 spm_corefi_tclMsgSecurityVinHistoryGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SECURITYVINHISTORYGET;
}


spm_corefi_tclMsgSecurityVinHistoryGet::~spm_corefi_tclMsgSecurityVinHistoryGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSecurityVinHistoryStatus::spm_corefi_tclMsgSecurityVinHistoryStatus(const spm_corefi_tclMsgSecurityVinHistoryStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   VinHistory = coRef.VinHistory;
}
spm_corefi_tclMsgSecurityVinHistoryStatus& spm_corefi_tclMsgSecurityVinHistoryStatus::operator=(const spm_corefi_tclMsgSecurityVinHistoryStatus& coRef)
{
   if (this == &coRef) return *this;
   VinHistory = coRef.VinHistory;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgSecurityVinHistoryStatus::vDestroy()
{
   VinHistory.vDestroy(); 
}

spm_corefi_tclMsgSecurityVinHistoryStatus::spm_corefi_tclMsgSecurityVinHistoryStatus()
:VinHistory()
 {}

tS32 spm_corefi_tclMsgSecurityVinHistoryStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SECURITYVINHISTORYSTATUS;
}


spm_corefi_tclMsgSecurityVinHistoryStatus::~spm_corefi_tclMsgSecurityVinHistoryStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgSecurityVinHistoryStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+VinHistory.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_corefi_tclMsgSecurityVinHistoryStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VinHistory);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSecurityVinHistoryStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VinHistory);
   return oOut;
}

tBool spm_corefi_tclMsgSecurityVinHistoryStatus::operator==(const spm_corefi_tclMsgSecurityVinHistoryStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VinHistory == roRef.VinHistory);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgVINGet::spm_corefi_tclMsgVINGet()
 {}

tS32 spm_corefi_tclMsgVINGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_VINGET;
}


spm_corefi_tclMsgVINGet::~spm_corefi_tclMsgVINGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgVINStatus::spm_corefi_tclMsgVINStatus(const spm_corefi_tclMsgVINStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   VehicleIdentificationNumber = coRef.VehicleIdentificationNumber;
}
spm_corefi_tclMsgVINStatus& spm_corefi_tclMsgVINStatus::operator=(const spm_corefi_tclMsgVINStatus& coRef)
{
   if (this == &coRef) return *this;
   VehicleIdentificationNumber = coRef.VehicleIdentificationNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid spm_corefi_tclMsgVINStatus::vDestroy()
{
   VehicleIdentificationNumber.vDestroy();
}

spm_corefi_tclMsgVINStatus::spm_corefi_tclMsgVINStatus()
:VehicleIdentificationNumber()
 {}

tS32 spm_corefi_tclMsgVINStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_VINSTATUS;
}


spm_corefi_tclMsgVINStatus::~spm_corefi_tclMsgVINStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 spm_corefi_tclMsgVINStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+VehicleIdentificationNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& spm_corefi_tclMsgVINStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VehicleIdentificationNumber);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgVINStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VehicleIdentificationNumber);
   return oOut;
}

tBool spm_corefi_tclMsgVINStatus::operator==(const spm_corefi_tclMsgVINStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VehicleIdentificationNumber == roRef.VehicleIdentificationNumber);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgSecurityStateUpReg::spm_corefi_tclMsgSecurityStateUpReg()
 {}

tS32 spm_corefi_tclMsgSecurityStateUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SECURITYSTATEUPREG;
}


spm_corefi_tclMsgSecurityStateUpReg::~spm_corefi_tclMsgSecurityStateUpReg()
{}

//=============================================================================

spm_corefi_tclMsgSecurityStateRelUpReg::spm_corefi_tclMsgSecurityStateRelUpReg()
 {}

tS32 spm_corefi_tclMsgSecurityStateRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SECURITYSTATERELUPREG;
}


spm_corefi_tclMsgSecurityStateRelUpReg::~spm_corefi_tclMsgSecurityStateRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgSecurityStateGet::spm_corefi_tclMsgSecurityStateGet()
 {}

tS32 spm_corefi_tclMsgSecurityStateGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SECURITYSTATEGET;
}


spm_corefi_tclMsgSecurityStateGet::~spm_corefi_tclMsgSecurityStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgSecurityStateStatus::spm_corefi_tclMsgSecurityStateStatus(const spm_corefi_tclMsgSecurityStateStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   State = coRef.State;
}
spm_corefi_tclMsgSecurityStateStatus& spm_corefi_tclMsgSecurityStateStatus::operator=(const spm_corefi_tclMsgSecurityStateStatus& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgSecurityStateStatus::spm_corefi_tclMsgSecurityStateStatus()
:State()
 {}

tS32 spm_corefi_tclMsgSecurityStateStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_SECURITYSTATESTATUS;
}


spm_corefi_tclMsgSecurityStateStatus::~spm_corefi_tclMsgSecurityStateStatus()
{}

tU32 spm_corefi_tclMsgSecurityStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgSecurityStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgSecurityStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   return oOut;
}

tBool spm_corefi_tclMsgSecurityStateStatus::operator==(const spm_corefi_tclMsgSecurityStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgVehicleIDUpReg::spm_corefi_tclMsgVehicleIDUpReg()
 {}

tS32 spm_corefi_tclMsgVehicleIDUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_VEHICLEIDUPREG;
}


spm_corefi_tclMsgVehicleIDUpReg::~spm_corefi_tclMsgVehicleIDUpReg()
{}

//=============================================================================

spm_corefi_tclMsgVehicleIDRelUpReg::spm_corefi_tclMsgVehicleIDRelUpReg()
 {}

tS32 spm_corefi_tclMsgVehicleIDRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_VEHICLEIDRELUPREG;
}


spm_corefi_tclMsgVehicleIDRelUpReg::~spm_corefi_tclMsgVehicleIDRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgVehicleIDGet::spm_corefi_tclMsgVehicleIDGet()
 {}

tS32 spm_corefi_tclMsgVehicleIDGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_VEHICLEIDGET;
}


spm_corefi_tclMsgVehicleIDGet::~spm_corefi_tclMsgVehicleIDGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgVehicleIDStatus::spm_corefi_tclMsgVehicleIDStatus(const spm_corefi_tclMsgVehicleIDStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   u32VehicleID = coRef.u32VehicleID;
}
spm_corefi_tclMsgVehicleIDStatus& spm_corefi_tclMsgVehicleIDStatus::operator=(const spm_corefi_tclMsgVehicleIDStatus& coRef)
{
   if (this == &coRef) return *this;
   u32VehicleID = coRef.u32VehicleID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgVehicleIDStatus::spm_corefi_tclMsgVehicleIDStatus()
:u32VehicleID(0)
 {}

tS32 spm_corefi_tclMsgVehicleIDStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_VEHICLEIDSTATUS;
}


spm_corefi_tclMsgVehicleIDStatus::~spm_corefi_tclMsgVehicleIDStatus()
{}

tU32 spm_corefi_tclMsgVehicleIDStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgVehicleIDStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32VehicleID);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgVehicleIDStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32VehicleID);
   return oOut;
}

tBool spm_corefi_tclMsgVehicleIDStatus::operator==(const spm_corefi_tclMsgVehicleIDStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32VehicleID == roRef.u32VehicleID);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgDisplayVariantGet::spm_corefi_tclMsgDisplayVariantGet()
 {}

tS32 spm_corefi_tclMsgDisplayVariantGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DISPLAYVARIANTGET;
}


spm_corefi_tclMsgDisplayVariantGet::~spm_corefi_tclMsgDisplayVariantGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgDisplayVariantSet::spm_corefi_tclMsgDisplayVariantSet(const spm_corefi_tclMsgDisplayVariantSet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   DisplayVariantNumber = coRef.DisplayVariantNumber;
}
spm_corefi_tclMsgDisplayVariantSet& spm_corefi_tclMsgDisplayVariantSet::operator=(const spm_corefi_tclMsgDisplayVariantSet& coRef)
{
   if (this == &coRef) return *this;
   DisplayVariantNumber = coRef.DisplayVariantNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgDisplayVariantSet::spm_corefi_tclMsgDisplayVariantSet()
:DisplayVariantNumber(0)
 {}

tS32 spm_corefi_tclMsgDisplayVariantSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DISPLAYVARIANTSET;
}


spm_corefi_tclMsgDisplayVariantSet::~spm_corefi_tclMsgDisplayVariantSet()
{}

tU32 spm_corefi_tclMsgDisplayVariantSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgDisplayVariantSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DisplayVariantNumber);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgDisplayVariantSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DisplayVariantNumber);
   return oOut;
}

tBool spm_corefi_tclMsgDisplayVariantSet::operator==(const spm_corefi_tclMsgDisplayVariantSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DisplayVariantNumber == roRef.DisplayVariantNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgDisplayVariantStatus::spm_corefi_tclMsgDisplayVariantStatus(const spm_corefi_tclMsgDisplayVariantStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   DisplayVariantNumber = coRef.DisplayVariantNumber;
}
spm_corefi_tclMsgDisplayVariantStatus& spm_corefi_tclMsgDisplayVariantStatus::operator=(const spm_corefi_tclMsgDisplayVariantStatus& coRef)
{
   if (this == &coRef) return *this;
   DisplayVariantNumber = coRef.DisplayVariantNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgDisplayVariantStatus::spm_corefi_tclMsgDisplayVariantStatus()
:DisplayVariantNumber(0)
 {}

tS32 spm_corefi_tclMsgDisplayVariantStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DISPLAYVARIANTSTATUS;
}


spm_corefi_tclMsgDisplayVariantStatus::~spm_corefi_tclMsgDisplayVariantStatus()
{}

tU32 spm_corefi_tclMsgDisplayVariantStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgDisplayVariantStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DisplayVariantNumber);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgDisplayVariantStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DisplayVariantNumber);
   return oOut;
}

tBool spm_corefi_tclMsgDisplayVariantStatus::operator==(const spm_corefi_tclMsgDisplayVariantStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DisplayVariantNumber == roRef.DisplayVariantNumber);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgReductionLevelUpReg::spm_corefi_tclMsgReductionLevelUpReg()
 {}

tS32 spm_corefi_tclMsgReductionLevelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_REDUCTIONLEVELUPREG;
}


spm_corefi_tclMsgReductionLevelUpReg::~spm_corefi_tclMsgReductionLevelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgReductionLevelRelUpReg::spm_corefi_tclMsgReductionLevelRelUpReg()
 {}

tS32 spm_corefi_tclMsgReductionLevelRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_REDUCTIONLEVELRELUPREG;
}


spm_corefi_tclMsgReductionLevelRelUpReg::~spm_corefi_tclMsgReductionLevelRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgReductionLevelGet::spm_corefi_tclMsgReductionLevelGet()
 {}

tS32 spm_corefi_tclMsgReductionLevelGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_REDUCTIONLEVELGET;
}


spm_corefi_tclMsgReductionLevelGet::~spm_corefi_tclMsgReductionLevelGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgReductionLevelStatus::spm_corefi_tclMsgReductionLevelStatus(const spm_corefi_tclMsgReductionLevelStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   ReductionLevelState = coRef.ReductionLevelState;
}
spm_corefi_tclMsgReductionLevelStatus& spm_corefi_tclMsgReductionLevelStatus::operator=(const spm_corefi_tclMsgReductionLevelStatus& coRef)
{
   if (this == &coRef) return *this;
   ReductionLevelState = coRef.ReductionLevelState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgReductionLevelStatus::spm_corefi_tclMsgReductionLevelStatus()
:ReductionLevelState()
 {}

tS32 spm_corefi_tclMsgReductionLevelStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_REDUCTIONLEVELSTATUS;
}


spm_corefi_tclMsgReductionLevelStatus::~spm_corefi_tclMsgReductionLevelStatus()
{}

tU32 spm_corefi_tclMsgReductionLevelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgReductionLevelStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ReductionLevelState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgReductionLevelStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ReductionLevelState);
   return oOut;
}

tBool spm_corefi_tclMsgReductionLevelStatus::operator==(const spm_corefi_tclMsgReductionLevelStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ReductionLevelState == roRef.ReductionLevelState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgStartupStateUpReg::spm_corefi_tclMsgStartupStateUpReg()
 {}

tS32 spm_corefi_tclMsgStartupStateUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_STARTUPSTATEUPREG;
}


spm_corefi_tclMsgStartupStateUpReg::~spm_corefi_tclMsgStartupStateUpReg()
{}

//=============================================================================

spm_corefi_tclMsgStartupStateRelUpReg::spm_corefi_tclMsgStartupStateRelUpReg()
 {}

tS32 spm_corefi_tclMsgStartupStateRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_STARTUPSTATERELUPREG;
}


spm_corefi_tclMsgStartupStateRelUpReg::~spm_corefi_tclMsgStartupStateRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgStartupStateGet::spm_corefi_tclMsgStartupStateGet()
 {}

tS32 spm_corefi_tclMsgStartupStateGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_STARTUPSTATEGET;
}


spm_corefi_tclMsgStartupStateGet::~spm_corefi_tclMsgStartupStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgStartupStateStatus::spm_corefi_tclMsgStartupStateStatus(const spm_corefi_tclMsgStartupStateStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   StartupState = coRef.StartupState;
}
spm_corefi_tclMsgStartupStateStatus& spm_corefi_tclMsgStartupStateStatus::operator=(const spm_corefi_tclMsgStartupStateStatus& coRef)
{
   if (this == &coRef) return *this;
   StartupState = coRef.StartupState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgStartupStateStatus::spm_corefi_tclMsgStartupStateStatus()
:StartupState()
 {}

tS32 spm_corefi_tclMsgStartupStateStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_STARTUPSTATESTATUS;
}


spm_corefi_tclMsgStartupStateStatus::~spm_corefi_tclMsgStartupStateStatus()
{}

tU32 spm_corefi_tclMsgStartupStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgStartupStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StartupState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgStartupStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StartupState);
   return oOut;
}

tBool spm_corefi_tclMsgStartupStateStatus::operator==(const spm_corefi_tclMsgStartupStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StartupState == roRef.StartupState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgEntertainMuteUpReg::spm_corefi_tclMsgEntertainMuteUpReg()
 {}

tS32 spm_corefi_tclMsgEntertainMuteUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ENTERTAINMUTEUPREG;
}


spm_corefi_tclMsgEntertainMuteUpReg::~spm_corefi_tclMsgEntertainMuteUpReg()
{}

//=============================================================================

spm_corefi_tclMsgEntertainMuteRelUpReg::spm_corefi_tclMsgEntertainMuteRelUpReg()
 {}

tS32 spm_corefi_tclMsgEntertainMuteRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ENTERTAINMUTERELUPREG;
}


spm_corefi_tclMsgEntertainMuteRelUpReg::~spm_corefi_tclMsgEntertainMuteRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgEntertainMuteGet::spm_corefi_tclMsgEntertainMuteGet()
 {}

tS32 spm_corefi_tclMsgEntertainMuteGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ENTERTAINMUTEGET;
}


spm_corefi_tclMsgEntertainMuteGet::~spm_corefi_tclMsgEntertainMuteGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgEntertainMuteStatus::spm_corefi_tclMsgEntertainMuteStatus(const spm_corefi_tclMsgEntertainMuteStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   bMuteState = coRef.bMuteState;
}
spm_corefi_tclMsgEntertainMuteStatus& spm_corefi_tclMsgEntertainMuteStatus::operator=(const spm_corefi_tclMsgEntertainMuteStatus& coRef)
{
   if (this == &coRef) return *this;
   bMuteState = coRef.bMuteState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgEntertainMuteStatus::spm_corefi_tclMsgEntertainMuteStatus()
:bMuteState(0)
 {}

tS32 spm_corefi_tclMsgEntertainMuteStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_ENTERTAINMUTESTATUS;
}


spm_corefi_tclMsgEntertainMuteStatus::~spm_corefi_tclMsgEntertainMuteStatus()
{}

tU32 spm_corefi_tclMsgEntertainMuteStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_corefi_tclMsgEntertainMuteStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bMuteState);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgEntertainMuteStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bMuteState);
   return oOut;
}

tBool spm_corefi_tclMsgEntertainMuteStatus::operator==(const spm_corefi_tclMsgEntertainMuteStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bMuteState == roRef.bMuteState);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgWelcomeAudioStateGet::spm_corefi_tclMsgWelcomeAudioStateGet()
 {}

tS32 spm_corefi_tclMsgWelcomeAudioStateGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_WELCOMEAUDIOSTATEGET;
}


spm_corefi_tclMsgWelcomeAudioStateGet::~spm_corefi_tclMsgWelcomeAudioStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgWelcomeAudioStateStatus::spm_corefi_tclMsgWelcomeAudioStateStatus(const spm_corefi_tclMsgWelcomeAudioStateStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   bEnabled = coRef.bEnabled;
}
spm_corefi_tclMsgWelcomeAudioStateStatus& spm_corefi_tclMsgWelcomeAudioStateStatus::operator=(const spm_corefi_tclMsgWelcomeAudioStateStatus& coRef)
{
   if (this == &coRef) return *this;
   bEnabled = coRef.bEnabled;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgWelcomeAudioStateStatus::spm_corefi_tclMsgWelcomeAudioStateStatus()
:bEnabled(0)
 {}

tS32 spm_corefi_tclMsgWelcomeAudioStateStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_WELCOMEAUDIOSTATESTATUS;
}


spm_corefi_tclMsgWelcomeAudioStateStatus::~spm_corefi_tclMsgWelcomeAudioStateStatus()
{}

tU32 spm_corefi_tclMsgWelcomeAudioStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& spm_corefi_tclMsgWelcomeAudioStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bEnabled);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgWelcomeAudioStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bEnabled);
   return oOut;
}

tBool spm_corefi_tclMsgWelcomeAudioStateStatus::operator==(const spm_corefi_tclMsgWelcomeAudioStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bEnabled == roRef.bEnabled);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgUnballastTimeFromEngineStoppedGet::spm_corefi_tclMsgUnballastTimeFromEngineStoppedGet()
 {}

tS32 spm_corefi_tclMsgUnballastTimeFromEngineStoppedGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_UNBALLASTTIMEFROMENGINESTOPPEDGET;
}


spm_corefi_tclMsgUnballastTimeFromEngineStoppedGet::~spm_corefi_tclMsgUnballastTimeFromEngineStoppedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus::spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus(const spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   u32TimeFromEngineStopped = coRef.u32TimeFromEngineStopped;
}
spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus& spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus::operator=(const spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus& coRef)
{
   if (this == &coRef) return *this;
   u32TimeFromEngineStopped = coRef.u32TimeFromEngineStopped;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus::spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus()
:u32TimeFromEngineStopped(0)
 {}

tS32 spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_UNBALLASTTIMEFROMENGINESTOPPEDSTATUS;
}


spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus::~spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus()
{}

tU32 spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32TimeFromEngineStopped);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32TimeFromEngineStopped);
   return oOut;
}

tBool spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus::operator==(const spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32TimeFromEngineStopped == roRef.u32TimeFromEngineStopped);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgUnballastTimeBeforeUnballastGet::spm_corefi_tclMsgUnballastTimeBeforeUnballastGet()
 {}

tS32 spm_corefi_tclMsgUnballastTimeBeforeUnballastGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_UNBALLASTTIMEBEFOREUNBALLASTGET;
}


spm_corefi_tclMsgUnballastTimeBeforeUnballastGet::~spm_corefi_tclMsgUnballastTimeBeforeUnballastGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus::spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus(const spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   u32UnballastTime = coRef.u32UnballastTime;
}
spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus& spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus::operator=(const spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus& coRef)
{
   if (this == &coRef) return *this;
   u32UnballastTime = coRef.u32UnballastTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus::spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus()
:u32UnballastTime(0)
 {}

tS32 spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_UNBALLASTTIMEBEFOREUNBALLASTSTATUS;
}


spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus::~spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus()
{}

tU32 spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32UnballastTime);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32UnballastTime);
   return oOut;
}

tBool spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus::operator==(const spm_corefi_tclMsgUnballastTimeBeforeUnballastStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32UnballastTime == roRef.u32UnballastTime);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgUnballastTimeBeforeUnballastSet::spm_corefi_tclMsgUnballastTimeBeforeUnballastSet(const spm_corefi_tclMsgUnballastTimeBeforeUnballastSet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   u32UnballastTime = coRef.u32UnballastTime;
}
spm_corefi_tclMsgUnballastTimeBeforeUnballastSet& spm_corefi_tclMsgUnballastTimeBeforeUnballastSet::operator=(const spm_corefi_tclMsgUnballastTimeBeforeUnballastSet& coRef)
{
   if (this == &coRef) return *this;
   u32UnballastTime = coRef.u32UnballastTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgUnballastTimeBeforeUnballastSet::spm_corefi_tclMsgUnballastTimeBeforeUnballastSet()
:u32UnballastTime(0)
 {}

tS32 spm_corefi_tclMsgUnballastTimeBeforeUnballastSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_UNBALLASTTIMEBEFOREUNBALLASTSET;
}


spm_corefi_tclMsgUnballastTimeBeforeUnballastSet::~spm_corefi_tclMsgUnballastTimeBeforeUnballastSet()
{}

tU32 spm_corefi_tclMsgUnballastTimeBeforeUnballastSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgUnballastTimeBeforeUnballastSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32UnballastTime);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgUnballastTimeBeforeUnballastSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32UnballastTime);
   return oOut;
}

tBool spm_corefi_tclMsgUnballastTimeBeforeUnballastSet::operator==(const spm_corefi_tclMsgUnballastTimeBeforeUnballastSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32UnballastTime == roRef.u32UnballastTime);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgUnballastWarningTimeGet::spm_corefi_tclMsgUnballastWarningTimeGet()
 {}

tS32 spm_corefi_tclMsgUnballastWarningTimeGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_UNBALLASTWARNINGTIMEGET;
}


spm_corefi_tclMsgUnballastWarningTimeGet::~spm_corefi_tclMsgUnballastWarningTimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgUnballastWarningTimeStatus::spm_corefi_tclMsgUnballastWarningTimeStatus(const spm_corefi_tclMsgUnballastWarningTimeStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   u32UnballastWarningTime = coRef.u32UnballastWarningTime;
}
spm_corefi_tclMsgUnballastWarningTimeStatus& spm_corefi_tclMsgUnballastWarningTimeStatus::operator=(const spm_corefi_tclMsgUnballastWarningTimeStatus& coRef)
{
   if (this == &coRef) return *this;
   u32UnballastWarningTime = coRef.u32UnballastWarningTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgUnballastWarningTimeStatus::spm_corefi_tclMsgUnballastWarningTimeStatus()
:u32UnballastWarningTime(0)
 {}

tS32 spm_corefi_tclMsgUnballastWarningTimeStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_UNBALLASTWARNINGTIMESTATUS;
}


spm_corefi_tclMsgUnballastWarningTimeStatus::~spm_corefi_tclMsgUnballastWarningTimeStatus()
{}

tU32 spm_corefi_tclMsgUnballastWarningTimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgUnballastWarningTimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32UnballastWarningTime);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgUnballastWarningTimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32UnballastWarningTime);
   return oOut;
}

tBool spm_corefi_tclMsgUnballastWarningTimeStatus::operator==(const spm_corefi_tclMsgUnballastWarningTimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32UnballastWarningTime == roRef.u32UnballastWarningTime);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgUnballastWarningTimeSet::spm_corefi_tclMsgUnballastWarningTimeSet(const spm_corefi_tclMsgUnballastWarningTimeSet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   u32UnballastWarningTime = coRef.u32UnballastWarningTime;
}
spm_corefi_tclMsgUnballastWarningTimeSet& spm_corefi_tclMsgUnballastWarningTimeSet::operator=(const spm_corefi_tclMsgUnballastWarningTimeSet& coRef)
{
   if (this == &coRef) return *this;
   u32UnballastWarningTime = coRef.u32UnballastWarningTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgUnballastWarningTimeSet::spm_corefi_tclMsgUnballastWarningTimeSet()
:u32UnballastWarningTime(0)
 {}

tS32 spm_corefi_tclMsgUnballastWarningTimeSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_UNBALLASTWARNINGTIMESET;
}


spm_corefi_tclMsgUnballastWarningTimeSet::~spm_corefi_tclMsgUnballastWarningTimeSet()
{}

tU32 spm_corefi_tclMsgUnballastWarningTimeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgUnballastWarningTimeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32UnballastWarningTime);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgUnballastWarningTimeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32UnballastWarningTime);
   return oOut;
}

tBool spm_corefi_tclMsgUnballastWarningTimeSet::operator==(const spm_corefi_tclMsgUnballastWarningTimeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32UnballastWarningTime == roRef.u32UnballastWarningTime);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgDegradedCountGet::spm_corefi_tclMsgDegradedCountGet()
 {}

tS32 spm_corefi_tclMsgDegradedCountGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DEGRADEDCOUNTGET;
}


spm_corefi_tclMsgDegradedCountGet::~spm_corefi_tclMsgDegradedCountGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgDegradedCountStatus::spm_corefi_tclMsgDegradedCountStatus(const spm_corefi_tclMsgDegradedCountStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   u32DegradedCount = coRef.u32DegradedCount;
}
spm_corefi_tclMsgDegradedCountStatus& spm_corefi_tclMsgDegradedCountStatus::operator=(const spm_corefi_tclMsgDegradedCountStatus& coRef)
{
   if (this == &coRef) return *this;
   u32DegradedCount = coRef.u32DegradedCount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgDegradedCountStatus::spm_corefi_tclMsgDegradedCountStatus()
:u32DegradedCount(0)
 {}

tS32 spm_corefi_tclMsgDegradedCountStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DEGRADEDCOUNTSTATUS;
}


spm_corefi_tclMsgDegradedCountStatus::~spm_corefi_tclMsgDegradedCountStatus()
{}

tU32 spm_corefi_tclMsgDegradedCountStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgDegradedCountStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32DegradedCount);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgDegradedCountStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32DegradedCount);
   return oOut;
}

tBool spm_corefi_tclMsgDegradedCountStatus::operator==(const spm_corefi_tclMsgDegradedCountStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32DegradedCount == roRef.u32DegradedCount);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgDegradedTimeGet::spm_corefi_tclMsgDegradedTimeGet()
 {}

tS32 spm_corefi_tclMsgDegradedTimeGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DEGRADEDTIMEGET;
}


spm_corefi_tclMsgDegradedTimeGet::~spm_corefi_tclMsgDegradedTimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgDegradedTimeStatus::spm_corefi_tclMsgDegradedTimeStatus(const spm_corefi_tclMsgDegradedTimeStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   u32DegradedTime = coRef.u32DegradedTime;
}
spm_corefi_tclMsgDegradedTimeStatus& spm_corefi_tclMsgDegradedTimeStatus::operator=(const spm_corefi_tclMsgDegradedTimeStatus& coRef)
{
   if (this == &coRef) return *this;
   u32DegradedTime = coRef.u32DegradedTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgDegradedTimeStatus::spm_corefi_tclMsgDegradedTimeStatus()
:u32DegradedTime(0)
 {}

tS32 spm_corefi_tclMsgDegradedTimeStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_DEGRADEDTIMESTATUS;
}


spm_corefi_tclMsgDegradedTimeStatus::~spm_corefi_tclMsgDegradedTimeStatus()
{}

tU32 spm_corefi_tclMsgDegradedTimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgDegradedTimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32DegradedTime);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgDegradedTimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32DegradedTime);
   return oOut;
}

tBool spm_corefi_tclMsgDegradedTimeStatus::operator==(const spm_corefi_tclMsgDegradedTimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32DegradedTime == roRef.u32DegradedTime);
   return bResult;
}

//=============================================================================

spm_corefi_tclMsgPhoneHandoverWarnTimeUpReg::spm_corefi_tclMsgPhoneHandoverWarnTimeUpReg()
 {}

tS32 spm_corefi_tclMsgPhoneHandoverWarnTimeUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMEUPREG;
}


spm_corefi_tclMsgPhoneHandoverWarnTimeUpReg::~spm_corefi_tclMsgPhoneHandoverWarnTimeUpReg()
{}

//=============================================================================

spm_corefi_tclMsgPhoneHandoverWarnTimeRelUpReg::spm_corefi_tclMsgPhoneHandoverWarnTimeRelUpReg()
 {}

tS32 spm_corefi_tclMsgPhoneHandoverWarnTimeRelUpReg::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMERELUPREG;
}


spm_corefi_tclMsgPhoneHandoverWarnTimeRelUpReg::~spm_corefi_tclMsgPhoneHandoverWarnTimeRelUpReg()
{}

//=============================================================================

spm_corefi_tclMsgPhoneHandoverWarnTimeGet::spm_corefi_tclMsgPhoneHandoverWarnTimeGet()
 {}

tS32 spm_corefi_tclMsgPhoneHandoverWarnTimeGet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMEGET;
}


spm_corefi_tclMsgPhoneHandoverWarnTimeGet::~spm_corefi_tclMsgPhoneHandoverWarnTimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgPhoneHandoverWarnTimeSet::spm_corefi_tclMsgPhoneHandoverWarnTimeSet(const spm_corefi_tclMsgPhoneHandoverWarnTimeSet& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   u32Time = coRef.u32Time;
}
spm_corefi_tclMsgPhoneHandoverWarnTimeSet& spm_corefi_tclMsgPhoneHandoverWarnTimeSet::operator=(const spm_corefi_tclMsgPhoneHandoverWarnTimeSet& coRef)
{
   if (this == &coRef) return *this;
   u32Time = coRef.u32Time;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgPhoneHandoverWarnTimeSet::spm_corefi_tclMsgPhoneHandoverWarnTimeSet()
:u32Time(0)
 {}

tS32 spm_corefi_tclMsgPhoneHandoverWarnTimeSet::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMESET;
}


spm_corefi_tclMsgPhoneHandoverWarnTimeSet::~spm_corefi_tclMsgPhoneHandoverWarnTimeSet()
{}

tU32 spm_corefi_tclMsgPhoneHandoverWarnTimeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgPhoneHandoverWarnTimeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Time);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgPhoneHandoverWarnTimeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Time);
   return oOut;
}

tBool spm_corefi_tclMsgPhoneHandoverWarnTimeSet::operator==(const spm_corefi_tclMsgPhoneHandoverWarnTimeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Time == roRef.u32Time);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
spm_corefi_tclMsgPhoneHandoverWarnTimeStatus::spm_corefi_tclMsgPhoneHandoverWarnTimeStatus(const spm_corefi_tclMsgPhoneHandoverWarnTimeStatus& coRef)
   : spm_corefi_tclMsgBaseMessage(coRef)
{
   u32Time = coRef.u32Time;
}
spm_corefi_tclMsgPhoneHandoverWarnTimeStatus& spm_corefi_tclMsgPhoneHandoverWarnTimeStatus::operator=(const spm_corefi_tclMsgPhoneHandoverWarnTimeStatus& coRef)
{
   if (this == &coRef) return *this;
   u32Time = coRef.u32Time;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

spm_corefi_tclMsgPhoneHandoverWarnTimeStatus::spm_corefi_tclMsgPhoneHandoverWarnTimeStatus()
:u32Time(0)
 {}

tS32 spm_corefi_tclMsgPhoneHandoverWarnTimeStatus::s32GetTypeId() const
{
   return (tS32) spm_corefi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMESTATUS;
}


spm_corefi_tclMsgPhoneHandoverWarnTimeStatus::~spm_corefi_tclMsgPhoneHandoverWarnTimeStatus()
{}

tU32 spm_corefi_tclMsgPhoneHandoverWarnTimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& spm_corefi_tclMsgPhoneHandoverWarnTimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Time);
   return oIn;
}

fi_tclOutContext& spm_corefi_tclMsgPhoneHandoverWarnTimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Time);
   return oOut;
}

tBool spm_corefi_tclMsgPhoneHandoverWarnTimeStatus::operator==(const spm_corefi_tclMsgPhoneHandoverWarnTimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Time == roRef.u32Time);
   return bResult;
}

