#ifndef SPM_COREFILANGUAGE_HEADER
#define SPM_COREFILANGUAGE_HEADER

class spm_corefi_tclInContext;
class spm_corefi_tclOutContext;
class spm_corefi_tclVisitorBase;

class MY_DECL spm_corefi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  spm_corefi_tclDescription(fi_tclInContext* poIn, spm_corefi_tclVisitorBase* poVisit);
  spm_corefi_tclDescription(fi_tclOutContext* poOut, spm_corefi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(spm_corefi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(spm_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ spm_corefi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  spm_corefi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<spm_corefi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<spm_corefi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline spm_corefi_tclDescription::spm_corefi_tclDescription(fi_tclInContext* poIn, spm_corefi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline spm_corefi_tclDescription::spm_corefi_tclDescription(fi_tclOutContext* poOut, spm_corefi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

