#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_STDVISITORS
#include "spm_fi_gen_if.h"

tBool spm_corefi_tclDescription::bInitMessage(spm_corefi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case spm_corefi_tclToken::EN_LAST_TOKEN:
   case spm_corefi_tclToken::EN_LIST:
   case spm_corefi_tclToken::EN_END_OF_STRUCT:
   case spm_corefi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;
   // include the expansions for the messages
   case spm_corefi_tclToken::EN_MSG_SYSTEMMODEMETHODSTART:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_E8_STATEMODES,spm_corefi_tclSemanticDomain::EN_MSG_ESYSTEMMODE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SYSTEMMODEMETHODRESULT:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_S32,spm_corefi_tclSemanticDomain::EN_MSG_S32RETURNVAL)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_DOWNLOADLOCKSTATEMETHODSTART:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_E8_DOWNLOADLOCKSTATES,spm_corefi_tclSemanticDomain::EN_MSG_ERESTRICTEDDLMODE)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STRING,spm_corefi_tclSemanticDomain::EN_MSG_STRRESTRICTEDDLSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_DOWNLOADLOCKSTATEMETHODRESULT:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_S32,spm_corefi_tclSemanticDomain::EN_MSG_S32RETURNVAL)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_UPDATELOCKMETHODSTART:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_E8_UPDATELOCKCOMMAND,spm_corefi_tclSemanticDomain::EN_MSG_ELOCKREQUEST)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STRING,spm_corefi_tclSemanticDomain::EN_MSG_STRLOCKNAME)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_UPDATELOCKMETHODRESULT:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_S32,spm_corefi_tclSemanticDomain::EN_MSG_S32RETURNVAL)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_ONOFFTRIGGERMETHODSTART:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_BOOL,spm_corefi_tclSemanticDomain::EN_MSG_BSTATE)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_SUBSTATETYPE,spm_corefi_tclSemanticDomain::EN_MSG_ESWITCHONTRIGGER)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_STARTPROCESSMETHODSTART:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32INFO)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_START_PROC_TYPE,spm_corefi_tclSemanticDomain::EN_MSG_U32TYPE)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32NICELEVELEND)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32NICELEVEL)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32AFFINITYEND)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32AFFINITY)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32PRIO)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STRING,spm_corefi_tclSemanticDomain::EN_MSG_STRLOCATION)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_STARTPROCESSMETHODRESULT:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32SPAWNDURATION)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32PROCID)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STRING,spm_corefi_tclSemanticDomain::EN_MSG_STRLOCATION)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_S32,spm_corefi_tclSemanticDomain::EN_MSG_S32RETURNVAL)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_STOPPROCESSMETHODSTART:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32PROCID)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STRING,spm_corefi_tclSemanticDomain::EN_MSG_STRLOCATION)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_STOPPROCESSMETHODRESULT:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_S32,spm_corefi_tclSemanticDomain::EN_MSG_S32RETURNVAL)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_RESTARTPROCESSMETHODSTART:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32PROCID)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STRING,spm_corefi_tclSemanticDomain::EN_MSG_STRLOCATION)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_RESTARTPROCESSMETHODRESULT:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_S32,spm_corefi_tclSemanticDomain::EN_MSG_S32RETURNVAL)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_STARTUPSYNCPOINTREACHEDMETHODSTART:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STRING,spm_corefi_tclSemanticDomain::EN_MSG_STRNEWSYNCPOINT)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_CLEARLISTMETHODSTART:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_CLEAR_LIST,spm_corefi_tclSemanticDomain::EN_MSG_ELIST2CLEAR)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SPECIFICSWVERSIONSTATISTICMETHODSTART:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32INDEX)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SPECIFICSWVERSIONSTATISTICMETHODRESULT:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_SWVERSIONSTATISTICDATA,spm_corefi_tclSemanticDomain::EN_MSG_TSWVERSIONSTATISTIC)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_RESTARTSYSTEMMETHODSTART:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_RESTART_TYPE,spm_corefi_tclSemanticDomain::EN_MSG_ERESTARTTYPE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_RESTARTSYSTEMMETHODRESULT:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_MRESULT,spm_corefi_tclSemanticDomain::EN_MSG_E32RETURNVAL)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_AUDIOSOURCECHANGEMETHODSTART:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_AUDIO_SOURCE,spm_corefi_tclSemanticDomain::EN_MSG_EAUDIOSRC)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_CHANGEBLUETOOTHSTATEMETHODSTART:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_BT_STATE,spm_corefi_tclSemanticDomain::EN_MSG_BTSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_CHANGEAUDIOSTATEMETHODSTART:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_AUDIO_STATE,spm_corefi_tclSemanticDomain::EN_MSG_AUDIOSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_CHANGESPISTATEMETHODSTART:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_SPI_STATE,spm_corefi_tclSemanticDomain::EN_MSG_SPISTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_CHANGETUNERSTATEMETHODSTART:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_TUNER_STATE,spm_corefi_tclSemanticDomain::EN_MSG_TUNERSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_CHANGEWIFISTATEMETHODSTART:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_WIFI_STATE,spm_corefi_tclSemanticDomain::EN_MSG_WIFISTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SHUTDOWNANDTERMINATECCAAPPSMETHODSTART:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_APPIDLIST,spm_corefi_tclSemanticDomain::EN_MSG_TAPPIDLIST)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODSTART:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_E8_DEFSETMODE,spm_corefi_tclSemanticDomain::EN_MSG_DEFSETSTATEMODE)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_E8_DIAGLOGDEFSETTYPE,spm_corefi_tclSemanticDomain::EN_MSG_DEFSETSTATEGROUP)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODRESULT:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U16,spm_corefi_tclSemanticDomain::EN_MSG_DEFSETSTATEFIRSTDIFFERENTPARAMETERID)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_BOOL,spm_corefi_tclSemanticDomain::EN_MSG_DEFSETSTATESUCCESSFUL)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_E8_DEFSETMODE,spm_corefi_tclSemanticDomain::EN_MSG_DEFSETSTATEMODE)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_E8_DIAGLOGDEFSETTYPE,spm_corefi_tclSemanticDomain::EN_MSG_DEFSETSTATEGROUP)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_CLEARVINMETHODRESULT:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_PREPAREDOWNLOADMETHODSTART:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_TIMEOUT)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_BOOL,spm_corefi_tclSemanticDomain::EN_MSG_SUSPENDBUSSHUTDOWN)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_CONFIGURATION)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_PREPAREDOWNLOADMETHODRESULT:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_ENDDOWNLOADMETHODRESULT:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SETONCONFIGURATIONMETHODSTART:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_CONFIGURATION)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SETONCONFIGURATIONMETHODRESULT:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SETPROCESSCONFIGURATIONMETHODSTART:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_CONFIGURATION)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SETPROCESSCONFIGURATIONMETHODRESULT:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_ENTERTAINDEMUTEMETHODRESULT:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_S32,spm_corefi_tclSemanticDomain::EN_MSG_S32RETURNVAL)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_ENTERTAINMUTEREQUESTMETHODRESULT:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_S32,spm_corefi_tclSemanticDomain::EN_MSG_S32RETURNVAL)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_WELCOMEAUDIOACTIVATIONMETHODSTART:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_BOOL,spm_corefi_tclSemanticDomain::EN_MSG_BACTIVATESTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_WELCOMEAUDIOACTIVATIONMETHODRESULT:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_S32,spm_corefi_tclSemanticDomain::EN_MSG_S32RETURNVAL)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SYSTEMSTATESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_SYSTEM_STATES,spm_corefi_tclSemanticDomain::EN_MSG_SYSTEMSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_DOWNLOADLOCKSTATESSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_RESTRICTEDDLLOCK,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_MSG_LISTRESTRICTEDLOCK)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_UPDATELOCKSTATESSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_UPDATELOCKSTATE,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_MSG_LLOCKS)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_ACTIVEONOFFTRIGGERSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_SUBSTATETYPE,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_MSG_TONOFFTRIGGERLIST)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SUBSTATESSET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_BOOL,spm_corefi_tclSemanticDomain::EN_MSG_SUBSTATEDATA)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_SUBSTATETYPE,spm_corefi_tclSemanticDomain::EN_MSG_SUBSTATETYPE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SUBSTATESSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_INTERNSUBSTATE)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_HWSUBSTATE)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_SUBSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_HISTORYTRIGGERSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_HISTORYTRIGGER,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_MSG_TTRIGGEREDSTATES)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_INSERTSTATESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_CD_INSERT_STATE,spm_corefi_tclSemanticDomain::EN_MSG_INSERTSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_MEDIAEJECTSTATESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_MEDIA_EJECT_STATE,spm_corefi_tclSemanticDomain::EN_MSG_MEDIAEJECTSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_PHONEMUTESTATESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_PHONE_MUTE_STATE,spm_corefi_tclSemanticDomain::EN_MSG_PHONEMUTESTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_ONTIPPERSTATESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_KEY_STATE,spm_corefi_tclSemanticDomain::EN_MSG_ONTIPPERSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_IGNITIONCYCLESSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_IGNITIONCYCLE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SYSPWRMODESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_SYSPWRMODE,spm_corefi_tclSemanticDomain::EN_MSG_SYSPWRMODE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SYSPWRSAVEMODESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_B32_SYSPWRSAVEMODE,spm_corefi_tclSemanticDomain::EN_MSG_SYSPWRSAVEMODE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_MAPDOWNLOADLOCKSTATESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U16,spm_corefi_tclSemanticDomain::EN_MSG_U16APPIDLOCKOWNER)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_STANDBYTIMESET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_STANDBYTIME)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_STANDBYTIMESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_STANDBYTIME)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_PERSITENTSTANDBYTIMESET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_PERSITENTSTANDBYTIME)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_PERSITENTSTANDBYTIMESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_PERSITENTSTANDBYTIME)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_IGNITIONOFFTIMESET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_IGNITIONOFFTIME)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_IGNITIONOFFTIMESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_IGNITIONOFFTIME)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_DOOROPENTIMESET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_DOOROPENTIME)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_DOOROPENTIMESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_DOOROPENTIME)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_CLOCKDISPLAYTIMESET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_CLOCKDISPLAYTIME)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_CLOCKDISPLAYTIMESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_CLOCKDISPLAYTIME)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SYSTEMSTATETIMEGET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_SYSTEM_STATES,spm_corefi_tclSemanticDomain::EN_MSG_TSYSTEMSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SYSTEMSTATETIMESET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_TSTATETIMERVALUE)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_SYSTEM_STATES,spm_corefi_tclSemanticDomain::EN_MSG_TSYSTEMSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SYSTEMSTATETIMESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_TSTATETIMERVALUE)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_SYSTEM_STATES,spm_corefi_tclSemanticDomain::EN_MSG_TSYSTEMSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_PROCESSLISTSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_PROCESSINFO,spm_corefi_tclSemanticDomain::EN_MSG_TPROCESSES)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_WAKEUPREASONSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_WAKEUP_REASON,spm_corefi_tclSemanticDomain::EN_MSG_WAKEUPREASON)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_STARTUPREASONSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_STARTUP_REASON,spm_corefi_tclSemanticDomain::EN_MSG_STARTUPREASON)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_CONNECTTOBATTERYSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U16,spm_corefi_tclSemanticDomain::EN_MSG_CONNECTTOBATTERYCOUNT)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_BOOL,spm_corefi_tclSemanticDomain::EN_MSG_CONNECTTOBATTERYSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_CODEREQUESTSTATESET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_CODE_REQUEST,spm_corefi_tclSemanticDomain::EN_MSG_CODEREQUESTSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_CODEREQUESTSTATESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_CODE_REQUEST,spm_corefi_tclSemanticDomain::EN_MSG_CODEREQUESTSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_ACTIVESTARTUPSYNCPOINTSSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STRING,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_MSG_TSTARTUPSYNCPOINTLIST)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_CVMEVENTSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_CVM_EVENT,spm_corefi_tclSemanticDomain::EN_MSG_CVMEVENT)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_UBATSENSESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U16,spm_corefi_tclSemanticDomain::EN_MSG_UBATSENSE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_COPROSTATESET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_PROCESSOR_STATE,spm_corefi_tclSemanticDomain::EN_MSG_COPROSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_COPROSTATESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_PROCESSOR_STATE,spm_corefi_tclSemanticDomain::EN_MSG_COPROSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_DEVICEPOWERONTIMESET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_DEVICEPOWERONTIME)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_DEVICEPOWERONTIMESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_DEVICEPOWERONTIME)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_LASTSYSTEMRUNTIMESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32RUNTIME)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_CURRENTSYSTEMRUNTIMESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32RUNTIME)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_RESETLISTSET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_RESETRESETLIST)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_RESETLISTSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_MSG_FGSRESETBYHMI)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_MSG_HMIRESETBYHMIDIAG)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_MSG_HMIRESETBYHMIDOWNLOAD)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_MSG_HMIRESETBYHMIEXTERN)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_MSG_HMIRESETBYHMIEXCEPTION)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_MSG_HMIRESETBYHMIAPP)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_MSG_HMIRESETBYHMIWDG)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_MSG_HMIRESETBYCOPROSHUTDOWN)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_MSG_HMIRESETBYCOPRORUN)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_MSG_HMIRESETBYCOPROSTARTUP)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_MSG_COPRORESETBYUNDERVOLTAGE)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_MSG_COPRORESETBYHMI)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U16,spm_corefi_tclSemanticDomain::EN_MSG_DATEYEAR)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_MSG_DATEMONTH)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_MSG_DATEDAY)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_MSG_DATEMINUTE)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_MSG_DATEHOUR)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_E8_LCMRESETREASON,spm_corefi_tclSemanticDomain::EN_MSG_LASTRESETREASON)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_RESETCOUNTERSET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_RESETCOUNTER)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_RESETCOUNTERSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32SCCWARMSTARTCOUNT)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32SCCDURINGSWCOUNT)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32SCCDURINGPLLOSZCOUNT)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32SCCDURINGLPWCOUNT)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32SCCAPPMODECHANGECOUNT)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32SCCCOLDSTARTCOUNT)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32SCCPOWERONCOUNT)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32SCCHWWDTCOUNT)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32APUNKNOWNCOUNT)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32APSCCCOUNT)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32APPOWEROFFCOUNT)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32APPOWERLOSSCOUNT)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32APPOWERONCOUNT)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32APWARMSTARTCOUNT)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32APLCMINTERN)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32APUSER)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32APOVERTEMPERATURE)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32APDOWNLOADERROR)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32APDOWNLOAD)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32APECURESET)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32APSOFTWARE)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32APAPPLICATIONERROR)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_E8_LCMRESETREASON,spm_corefi_tclSemanticDomain::EN_MSG_TLASTRESETREASON)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_IMEDATE,spm_corefi_tclSemanticDomain::EN_MSG_TLASTRESETDATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_TRANSPORTMODELISTSET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_TRANSPORTLIST)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_TRANSPORTMODELISTSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_TRANSPORTMODELIST,spm_corefi_tclSemanticDomain::EN_MSG_TRANSPORTMODELIST)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_RESETHISTORYSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_RESETELEMENT,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_MSG_TRESETLIST)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_WAKEUPHISTORYSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_WAKEUPELEMENT,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_MSG_TWAKEUPLIST)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_STATEHISTORYSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STATECHANGEELEMENT,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_MSG_TSTATELIST)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY01STATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STATECHANGEELEMENT,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_MSG_TSTATELIST)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY02STATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STATECHANGEELEMENT,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_MSG_TSTATELIST)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY03STATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STATECHANGEELEMENT,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_MSG_TSTATELIST)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY04STATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STATECHANGEELEMENT,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_MSG_TSTATELIST)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY05STATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STATECHANGEELEMENT,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_MSG_TSTATELIST)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SWITCHONHISTORYSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SWITCHONELEMENT,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_MSG_TSWITCHONLIST)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_DEVICEONCOUNTERSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32DEVICEUSERONCOUNT)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32DEVICEWAKEUPCOUNT)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_VOLTAGEEVENTCOUNTERSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_VOLTAGEEVENTCOUNTER,spm_corefi_tclSemanticDomain::EN_MSG_TVOLTAGEEVENTCOUNTER)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_VOLTAGERANGEHISTOGRAMSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_VOLTAGERANGE,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_MSG_LISTVOLTAGERANGEHISTOGRAM)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_CPUUSAGESTATISTICSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_SYSTEMSTATISTICSDATA,spm_corefi_tclSemanticDomain::EN_MSG_TCPUUSAGESTATISTICSDATA)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_RAMUSAGESTATISTICSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_SYSTEMSTATISTICSDATA,spm_corefi_tclSemanticDomain::EN_MSG_TRAMUSAGESTATISTICSDATA)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_STARTUPTIMESTATISTICSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_SYSTEMSTATISTICSDATA,spm_corefi_tclSemanticDomain::EN_MSG_TSTARTUPTIMESTATISTICSDATA)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SWVERSIONSTATISTICSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_SWVERSIONSTATISTICDATA,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_MSG_LISTSWVERSIONSTATISTIC)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_RUNLEVELSTATESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_RUNLEVEL,spm_corefi_tclSemanticDomain::EN_MSG_ERUNLEVEL)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_RESTARTSET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_RESTART_TYPE,spm_corefi_tclSemanticDomain::EN_MSG_RESTART)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_RESTARTSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_RESTART_TYPE,spm_corefi_tclSemanticDomain::EN_MSG_RESTART)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_LIFESIGNSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_LIFESIGN)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_HMISTATESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_HMI_STATE,spm_corefi_tclSemanticDomain::EN_MSG_HMISTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SYSTEMPOWERBEHAVIOURSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_SYSPWR_BEHAVIOUR,spm_corefi_tclSemanticDomain::EN_MSG_ESYSTEMPOWERBEHAVIOUR)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_DIMSTATESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_DIM_STATE,spm_corefi_tclSemanticDomain::EN_MSG_DIMSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_DIMMINGSTATESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_B32_DIM_STATE,spm_corefi_tclSemanticDomain::EN_MSG_DIMSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_BLUETOOTHSTATESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_BT_STATE,spm_corefi_tclSemanticDomain::EN_MSG_BTSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_AUDIOSTATESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_AUDIO_STATE,spm_corefi_tclSemanticDomain::EN_MSG_AUDIOSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SPISTATESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_SPI_STATE,spm_corefi_tclSemanticDomain::EN_MSG_SPISTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_TUNERSTATESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_TUNER_STATE,spm_corefi_tclSemanticDomain::EN_MSG_TUNERSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_WIFISTATESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_WIFI_STATE,spm_corefi_tclSemanticDomain::EN_MSG_WIFISTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_ONOFFREASONSET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_ONOFFREASON,spm_corefi_tclSemanticDomain::EN_MSG_ONOFFREASON)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_ONOFFREASONSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_ONOFFREASON,spm_corefi_tclSemanticDomain::EN_MSG_ONOFFREASON)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_WAKEUPLISTSET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_WAKEUPLIST)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_WAKEUPLISTSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E8_WAKEUP_LIST_REASON,spm_corefi_tclSemanticDomain::EN_MSG_WAKEUPREASON10)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E8_WAKEUP_LIST_REASON,spm_corefi_tclSemanticDomain::EN_MSG_WAKEUPREASON9)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E8_WAKEUP_LIST_REASON,spm_corefi_tclSemanticDomain::EN_MSG_WAKEUPREASON8)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E8_WAKEUP_LIST_REASON,spm_corefi_tclSemanticDomain::EN_MSG_WAKEUPREASON7)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E8_WAKEUP_LIST_REASON,spm_corefi_tclSemanticDomain::EN_MSG_WAKEUPREASON6)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E8_WAKEUP_LIST_REASON,spm_corefi_tclSemanticDomain::EN_MSG_WAKEUPREASON5)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E8_WAKEUP_LIST_REASON,spm_corefi_tclSemanticDomain::EN_MSG_WAKEUPREASON4)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E8_WAKEUP_LIST_REASON,spm_corefi_tclSemanticDomain::EN_MSG_WAKEUPREASON3)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E8_WAKEUP_LIST_REASON,spm_corefi_tclSemanticDomain::EN_MSG_WAKEUPREASON2)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E8_WAKEUP_LIST_REASON,spm_corefi_tclSemanticDomain::EN_MSG_WAKEUPREASON1)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_STARTUPFINISHEDSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_BOOL,spm_corefi_tclSemanticDomain::EN_MSG_STARTUPFINISHEDSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SYSSTATESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_SYS_STATE,spm_corefi_tclSemanticDomain::EN_MSG_SYSSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_MOSTSTATESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_BOOL,spm_corefi_tclSemanticDomain::EN_MSG_OVERTEMPERATUREMOSTOFF)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_TLA_STATE,spm_corefi_tclSemanticDomain::EN_MSG_TLASTATE)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_FIRSTRECEIVETIME)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_MOST_CONFIG_STATE,spm_corefi_tclSemanticDomain::EN_MSG_MOSTCONFIGURATIONSTATE)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_MOST_EVENT,spm_corefi_tclSemanticDomain::EN_MSG_MOSTEVENT)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_MOSTVERSIONSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STRING,spm_corefi_tclSemanticDomain::EN_MSG_MOSTVERSION)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_RVCSTATESET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_BOOL,spm_corefi_tclSemanticDomain::EN_MSG_STATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_RVCSTATESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_BOOL,spm_corefi_tclSemanticDomain::EN_MSG_STATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_TRIGGERMOSTREMOTERESETSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_TRIGGER)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_PARTNUMBERGET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STRING,spm_corefi_tclSemanticDomain::EN_MSG_PART)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_PARTNUMBERSET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_NUMBER)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STRING,spm_corefi_tclSemanticDomain::EN_MSG_PART)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_PARTNUMBERSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_PARTNUMBER)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_PARTNUMBERSSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_PARTNUMBERLIST,spm_corefi_tclSemanticDomain::EN_MSG_PARTS)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_ALPHACODEGET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STRING,spm_corefi_tclSemanticDomain::EN_MSG_PART)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_ALPHACODESET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_MSG_ALPHACODE2)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_MSG_ALPHACODE1)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STRING,spm_corefi_tclSemanticDomain::EN_MSG_PART)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_ALPHACODESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_MSG_ALPHACODE2)) && bResult;
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_MSG_ALPHACODE1)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_ALPHACODESSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_ALPHACODELIST,spm_corefi_tclSemanticDomain::EN_MSG_PARTS)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_MANUFACTURERSENABLECOUNTERSET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_MSG_MEC)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_MANUFACTURERSENABLECOUNTERSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_MSG_MEC)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_NOCALIBRATIONSTATESET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_BOOL,spm_corefi_tclSemanticDomain::EN_MSG_STATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_NOCALIBRATIONSTATESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_BOOL,spm_corefi_tclSemanticDomain::EN_MSG_STATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SECURITYCOMMERRORSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U16,spm_corefi_tclSemanticDomain::EN_MSG_COMMERRORCOUNT)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SECURITYMORETHAN10VINSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U16,spm_corefi_tclSemanticDomain::EN_MSG_MORETHAN10VINCOUNT)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SECURITYINVALIDVINSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U16,spm_corefi_tclSemanticDomain::EN_MSG_INVALIDVINCOUNT)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SECURITYCURRENTVINSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_VIN,spm_corefi_tclSemanticDomain::EN_MSG_CURRENTVIN)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SECURITYVINHISTORYSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_VINHISTORY,spm_corefi_tclSemanticDomain::EN_MSG_VINHISTORY)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_VINSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STRING,spm_corefi_tclSemanticDomain::EN_MSG_VEHICLEIDENTIFICATIONNUMBER)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_SECURITYSTATESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_SECURITY_STATE,spm_corefi_tclSemanticDomain::EN_MSG_STATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_VEHICLEIDSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32VEHICLEID)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_DISPLAYVARIANTSET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_DISPLAYVARIANTNUMBER)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_DISPLAYVARIANTSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_DISPLAYVARIANTNUMBER)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_REDUCTIONLEVELSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_REDUCTION_LEVEL,spm_corefi_tclSemanticDomain::EN_MSG_REDUCTIONLEVELSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_STARTUPSTATESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_STARTUP_STATE,spm_corefi_tclSemanticDomain::EN_MSG_STARTUPSTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_ENTERTAINMUTESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_BOOL,spm_corefi_tclSemanticDomain::EN_MSG_BMUTESTATE)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_WELCOMEAUDIOSTATESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_BOOL,spm_corefi_tclSemanticDomain::EN_MSG_BENABLED)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_UNBALLASTTIMEFROMENGINESTOPPEDSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32TIMEFROMENGINESTOPPED)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_UNBALLASTTIMEBEFOREUNBALLASTSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32UNBALLASTTIME)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_UNBALLASTTIMEBEFOREUNBALLASTSET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32UNBALLASTTIME)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_UNBALLASTWARNINGTIMESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32UNBALLASTWARNINGTIME)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_UNBALLASTWARNINGTIMESET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32UNBALLASTWARNINGTIME)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_DEGRADEDCOUNTSTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32DEGRADEDCOUNT)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_DEGRADEDTIMESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32DEGRADEDTIME)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMESET:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32TIME)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMESTATUS:
   {
      bResult = oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MSG_U32TIME)) && bResult;
   } break;
   case spm_corefi_tclToken::EN_MSG_ONOFFTRIGGERMETHODRESULT:
   case spm_corefi_tclToken::EN_MSG_STARTUPSYNCPOINTREACHEDMETHODRESULT:
   case spm_corefi_tclToken::EN_MSG_CLEARLISTMETHODRESULT:
   case spm_corefi_tclToken::EN_MSG_AUDIOSOURCECHANGEMETHODRESULT:
   case spm_corefi_tclToken::EN_MSG_CHANGEBLUETOOTHSTATEMETHODRESULT:
   case spm_corefi_tclToken::EN_MSG_CHANGEAUDIOSTATEMETHODRESULT:
   case spm_corefi_tclToken::EN_MSG_CHANGESPISTATEMETHODRESULT:
   case spm_corefi_tclToken::EN_MSG_CHANGETUNERSTATEMETHODRESULT:
   case spm_corefi_tclToken::EN_MSG_CHANGEWIFISTATEMETHODRESULT:
   case spm_corefi_tclToken::EN_MSG_SHUTDOWNANDTERMINATECCAAPPSMETHODRESULT:
   case spm_corefi_tclToken::EN_MSG_CLEARVINMETHODSTART:
   case spm_corefi_tclToken::EN_MSG_ENDDOWNLOADMETHODSTART:
   case spm_corefi_tclToken::EN_MSG_ENTERTAINDEMUTEMETHODSTART:
   case spm_corefi_tclToken::EN_MSG_ENTERTAINMUTEREQUESTMETHODSTART:
   case spm_corefi_tclToken::EN_MSG_SYSTEMSTATEUPREG:
   case spm_corefi_tclToken::EN_MSG_SYSTEMSTATERELUPREG:
   case spm_corefi_tclToken::EN_MSG_SYSTEMSTATEGET:
   case spm_corefi_tclToken::EN_MSG_DOWNLOADLOCKSTATESUPREG:
   case spm_corefi_tclToken::EN_MSG_DOWNLOADLOCKSTATESRELUPREG:
   case spm_corefi_tclToken::EN_MSG_DOWNLOADLOCKSTATESGET:
   case spm_corefi_tclToken::EN_MSG_UPDATELOCKSTATESUPREG:
   case spm_corefi_tclToken::EN_MSG_UPDATELOCKSTATESRELUPREG:
   case spm_corefi_tclToken::EN_MSG_UPDATELOCKSTATESGET:
   case spm_corefi_tclToken::EN_MSG_ACTIVEONOFFTRIGGERUPREG:
   case spm_corefi_tclToken::EN_MSG_ACTIVEONOFFTRIGGERRELUPREG:
   case spm_corefi_tclToken::EN_MSG_ACTIVEONOFFTRIGGERGET:
   case spm_corefi_tclToken::EN_MSG_SUBSTATESUPREG:
   case spm_corefi_tclToken::EN_MSG_SUBSTATESRELUPREG:
   case spm_corefi_tclToken::EN_MSG_SUBSTATESGET:
   case spm_corefi_tclToken::EN_MSG_HISTORYTRIGGERUPREG:
   case spm_corefi_tclToken::EN_MSG_HISTORYTRIGGERRELUPREG:
   case spm_corefi_tclToken::EN_MSG_HISTORYTRIGGERGET:
   case spm_corefi_tclToken::EN_MSG_INSERTSTATEUPREG:
   case spm_corefi_tclToken::EN_MSG_INSERTSTATERELUPREG:
   case spm_corefi_tclToken::EN_MSG_INSERTSTATEGET:
   case spm_corefi_tclToken::EN_MSG_MEDIAEJECTSTATEUPREG:
   case spm_corefi_tclToken::EN_MSG_MEDIAEJECTSTATERELUPREG:
   case spm_corefi_tclToken::EN_MSG_MEDIAEJECTSTATEGET:
   case spm_corefi_tclToken::EN_MSG_PHONEMUTESTATEUPREG:
   case spm_corefi_tclToken::EN_MSG_PHONEMUTESTATERELUPREG:
   case spm_corefi_tclToken::EN_MSG_PHONEMUTESTATEGET:
   case spm_corefi_tclToken::EN_MSG_ONTIPPERSTATEUPREG:
   case spm_corefi_tclToken::EN_MSG_ONTIPPERSTATERELUPREG:
   case spm_corefi_tclToken::EN_MSG_ONTIPPERSTATEGET:
   case spm_corefi_tclToken::EN_MSG_IGNITIONCYCLESUPREG:
   case spm_corefi_tclToken::EN_MSG_IGNITIONCYCLESRELUPREG:
   case spm_corefi_tclToken::EN_MSG_IGNITIONCYCLESGET:
   case spm_corefi_tclToken::EN_MSG_SYSPWRMODEUPREG:
   case spm_corefi_tclToken::EN_MSG_SYSPWRMODERELUPREG:
   case spm_corefi_tclToken::EN_MSG_SYSPWRMODEGET:
   case spm_corefi_tclToken::EN_MSG_SYSPWRSAVEMODEGET:
   case spm_corefi_tclToken::EN_MSG_MAPDOWNLOADLOCKSTATEUPREG:
   case spm_corefi_tclToken::EN_MSG_MAPDOWNLOADLOCKSTATERELUPREG:
   case spm_corefi_tclToken::EN_MSG_MAPDOWNLOADLOCKSTATEGET:
   case spm_corefi_tclToken::EN_MSG_STANDBYTIMEGET:
   case spm_corefi_tclToken::EN_MSG_PERSITENTSTANDBYTIMEGET:
   case spm_corefi_tclToken::EN_MSG_IGNITIONOFFTIMEGET:
   case spm_corefi_tclToken::EN_MSG_DOOROPENTIMEGET:
   case spm_corefi_tclToken::EN_MSG_CLOCKDISPLAYTIMEGET:
   case spm_corefi_tclToken::EN_MSG_PROCESSLISTUPREG:
   case spm_corefi_tclToken::EN_MSG_PROCESSLISTRELUPREG:
   case spm_corefi_tclToken::EN_MSG_PROCESSLISTGET:
   case spm_corefi_tclToken::EN_MSG_WAKEUPREASONGET:
   case spm_corefi_tclToken::EN_MSG_STARTUPREASONGET:
   case spm_corefi_tclToken::EN_MSG_CONNECTTOBATTERYGET:
   case spm_corefi_tclToken::EN_MSG_CODEREQUESTSTATEUPREG:
   case spm_corefi_tclToken::EN_MSG_CODEREQUESTSTATERELUPREG:
   case spm_corefi_tclToken::EN_MSG_CODEREQUESTSTATEGET:
   case spm_corefi_tclToken::EN_MSG_ACTIVESTARTUPSYNCPOINTSUPREG:
   case spm_corefi_tclToken::EN_MSG_ACTIVESTARTUPSYNCPOINTSRELUPREG:
   case spm_corefi_tclToken::EN_MSG_ACTIVESTARTUPSYNCPOINTSGET:
   case spm_corefi_tclToken::EN_MSG_CVMEVENTUPREG:
   case spm_corefi_tclToken::EN_MSG_CVMEVENTRELUPREG:
   case spm_corefi_tclToken::EN_MSG_CVMEVENTGET:
   case spm_corefi_tclToken::EN_MSG_UBATSENSEGET:
   case spm_corefi_tclToken::EN_MSG_COPROSTATEUPREG:
   case spm_corefi_tclToken::EN_MSG_COPROSTATERELUPREG:
   case spm_corefi_tclToken::EN_MSG_COPROSTATEGET:
   case spm_corefi_tclToken::EN_MSG_DEVICEPOWERONTIMEGET:
   case spm_corefi_tclToken::EN_MSG_LASTSYSTEMRUNTIMEGET:
   case spm_corefi_tclToken::EN_MSG_CURRENTSYSTEMRUNTIMEGET:
   case spm_corefi_tclToken::EN_MSG_RESETLISTGET:
   case spm_corefi_tclToken::EN_MSG_RESETCOUNTERUPREG:
   case spm_corefi_tclToken::EN_MSG_RESETCOUNTERRELUPREG:
   case spm_corefi_tclToken::EN_MSG_RESETCOUNTERGET:
   case spm_corefi_tclToken::EN_MSG_TRANSPORTMODELISTGET:
   case spm_corefi_tclToken::EN_MSG_RESETHISTORYSET:
   case spm_corefi_tclToken::EN_MSG_RESETHISTORYGET:
   case spm_corefi_tclToken::EN_MSG_WAKEUPHISTORYSET:
   case spm_corefi_tclToken::EN_MSG_WAKEUPHISTORYGET:
   case spm_corefi_tclToken::EN_MSG_STATEHISTORYSET:
   case spm_corefi_tclToken::EN_MSG_STATEHISTORYGET:
   case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY01SET:
   case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY01GET:
   case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY02SET:
   case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY02GET:
   case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY03SET:
   case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY03GET:
   case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY04SET:
   case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY04GET:
   case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY05SET:
   case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY05GET:
   case spm_corefi_tclToken::EN_MSG_SWITCHONHISTORYSET:
   case spm_corefi_tclToken::EN_MSG_SWITCHONHISTORYGET:
   case spm_corefi_tclToken::EN_MSG_DEVICEONCOUNTERGET:
   case spm_corefi_tclToken::EN_MSG_VOLTAGEEVENTCOUNTERGET:
   case spm_corefi_tclToken::EN_MSG_VOLTAGERANGEHISTOGRAMGET:
   case spm_corefi_tclToken::EN_MSG_CPUUSAGESTATISTICGET:
   case spm_corefi_tclToken::EN_MSG_RAMUSAGESTATISTICGET:
   case spm_corefi_tclToken::EN_MSG_STARTUPTIMESTATISTICGET:
   case spm_corefi_tclToken::EN_MSG_SWVERSIONSTATISTICGET:
   case spm_corefi_tclToken::EN_MSG_RUNLEVELSTATEUPREG:
   case spm_corefi_tclToken::EN_MSG_RUNLEVELSTATERELUPREG:
   case spm_corefi_tclToken::EN_MSG_RUNLEVELSTATEGET:
   case spm_corefi_tclToken::EN_MSG_RESTARTUPREG:
   case spm_corefi_tclToken::EN_MSG_RESTARTRELUPREG:
   case spm_corefi_tclToken::EN_MSG_RESTARTGET:
   case spm_corefi_tclToken::EN_MSG_LIFESIGNUPREG:
   case spm_corefi_tclToken::EN_MSG_LIFESIGNRELUPREG:
   case spm_corefi_tclToken::EN_MSG_LIFESIGNGET:
   case spm_corefi_tclToken::EN_MSG_HMISTATEUPREG:
   case spm_corefi_tclToken::EN_MSG_HMISTATERELUPREG:
   case spm_corefi_tclToken::EN_MSG_HMISTATEGET:
   case spm_corefi_tclToken::EN_MSG_SYSTEMPOWERBEHAVIOURUPREG:
   case spm_corefi_tclToken::EN_MSG_SYSTEMPOWERBEHAVIOURRELUPREG:
   case spm_corefi_tclToken::EN_MSG_SYSTEMPOWERBEHAVIOURGET:
   case spm_corefi_tclToken::EN_MSG_DIMSTATEUPREG:
   case spm_corefi_tclToken::EN_MSG_DIMSTATERELUPREG:
   case spm_corefi_tclToken::EN_MSG_DIMSTATEGET:
   case spm_corefi_tclToken::EN_MSG_DIMMINGSTATEUPREG:
   case spm_corefi_tclToken::EN_MSG_DIMMINGSTATERELUPREG:
   case spm_corefi_tclToken::EN_MSG_DIMMINGSTATEGET:
   case spm_corefi_tclToken::EN_MSG_BLUETOOTHSTATEUPREG:
   case spm_corefi_tclToken::EN_MSG_BLUETOOTHSTATERELUPREG:
   case spm_corefi_tclToken::EN_MSG_BLUETOOTHSTATEGET:
   case spm_corefi_tclToken::EN_MSG_AUDIOSTATEUPREG:
   case spm_corefi_tclToken::EN_MSG_AUDIOSTATERELUPREG:
   case spm_corefi_tclToken::EN_MSG_AUDIOSTATEGET:
   case spm_corefi_tclToken::EN_MSG_SPISTATEUPREG:
   case spm_corefi_tclToken::EN_MSG_SPISTATERELUPREG:
   case spm_corefi_tclToken::EN_MSG_SPISTATEGET:
   case spm_corefi_tclToken::EN_MSG_TUNERSTATEUPREG:
   case spm_corefi_tclToken::EN_MSG_TUNERSTATERELUPREG:
   case spm_corefi_tclToken::EN_MSG_TUNERSTATEGET:
   case spm_corefi_tclToken::EN_MSG_WIFISTATEUPREG:
   case spm_corefi_tclToken::EN_MSG_WIFISTATERELUPREG:
   case spm_corefi_tclToken::EN_MSG_WIFISTATEGET:
   case spm_corefi_tclToken::EN_MSG_ONOFFREASONGET:
   case spm_corefi_tclToken::EN_MSG_ONOFFREASONUPREG:
   case spm_corefi_tclToken::EN_MSG_ONOFFREASONRELUPREG:
   case spm_corefi_tclToken::EN_MSG_WAKEUPLISTGET:
   case spm_corefi_tclToken::EN_MSG_STARTUPFINISHEDUPREG:
   case spm_corefi_tclToken::EN_MSG_STARTUPFINISHEDRELUPREG:
   case spm_corefi_tclToken::EN_MSG_STARTUPFINISHEDGET:
   case spm_corefi_tclToken::EN_MSG_SYSSTATEUPREG:
   case spm_corefi_tclToken::EN_MSG_SYSSTATERELUPREG:
   case spm_corefi_tclToken::EN_MSG_SYSSTATEGET:
   case spm_corefi_tclToken::EN_MSG_MOSTSTATEUPREG:
   case spm_corefi_tclToken::EN_MSG_MOSTSTATERELUPREG:
   case spm_corefi_tclToken::EN_MSG_MOSTSTATEGET:
   case spm_corefi_tclToken::EN_MSG_MOSTVERSIONGET:
   case spm_corefi_tclToken::EN_MSG_RVCSTATEGET:
   case spm_corefi_tclToken::EN_MSG_TRIGGERMOSTREMOTERESETGET:
   case spm_corefi_tclToken::EN_MSG_TRIGGERMOSTREMOTERESETSET:
   case spm_corefi_tclToken::EN_MSG_TRIGGERMOSTREMOTERESETUPREG:
   case spm_corefi_tclToken::EN_MSG_TRIGGERMOSTREMOTERESETRELUPREG:
   case spm_corefi_tclToken::EN_MSG_PARTNUMBERSGET:
   case spm_corefi_tclToken::EN_MSG_ALPHACODESGET:
   case spm_corefi_tclToken::EN_MSG_MANUFACTURERSENABLECOUNTERGET:
   case spm_corefi_tclToken::EN_MSG_NOCALIBRATIONSTATEGET:
   case spm_corefi_tclToken::EN_MSG_SECURITYCOMMERRORGET:
   case spm_corefi_tclToken::EN_MSG_SECURITYMORETHAN10VINGET:
   case spm_corefi_tclToken::EN_MSG_SECURITYINVALIDVINGET:
   case spm_corefi_tclToken::EN_MSG_SECURITYCURRENTVINGET:
   case spm_corefi_tclToken::EN_MSG_SECURITYVINHISTORYGET:
   case spm_corefi_tclToken::EN_MSG_VINGET:
   case spm_corefi_tclToken::EN_MSG_SECURITYSTATEUPREG:
   case spm_corefi_tclToken::EN_MSG_SECURITYSTATERELUPREG:
   case spm_corefi_tclToken::EN_MSG_SECURITYSTATEGET:
   case spm_corefi_tclToken::EN_MSG_VEHICLEIDUPREG:
   case spm_corefi_tclToken::EN_MSG_VEHICLEIDRELUPREG:
   case spm_corefi_tclToken::EN_MSG_VEHICLEIDGET:
   case spm_corefi_tclToken::EN_MSG_DISPLAYVARIANTGET:
   case spm_corefi_tclToken::EN_MSG_REDUCTIONLEVELUPREG:
   case spm_corefi_tclToken::EN_MSG_REDUCTIONLEVELRELUPREG:
   case spm_corefi_tclToken::EN_MSG_REDUCTIONLEVELGET:
   case spm_corefi_tclToken::EN_MSG_STARTUPSTATEUPREG:
   case spm_corefi_tclToken::EN_MSG_STARTUPSTATERELUPREG:
   case spm_corefi_tclToken::EN_MSG_STARTUPSTATEGET:
   case spm_corefi_tclToken::EN_MSG_ENTERTAINMUTEUPREG:
   case spm_corefi_tclToken::EN_MSG_ENTERTAINMUTERELUPREG:
   case spm_corefi_tclToken::EN_MSG_ENTERTAINMUTEGET:
   case spm_corefi_tclToken::EN_MSG_WELCOMEAUDIOSTATEGET:
   case spm_corefi_tclToken::EN_MSG_UNBALLASTTIMEFROMENGINESTOPPEDGET:
   case spm_corefi_tclToken::EN_MSG_UNBALLASTTIMEBEFOREUNBALLASTGET:
   case spm_corefi_tclToken::EN_MSG_UNBALLASTWARNINGTIMEGET:
   case spm_corefi_tclToken::EN_MSG_DEGRADEDCOUNTGET:
   case spm_corefi_tclToken::EN_MSG_DEGRADEDTIMEGET:
   case spm_corefi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMEUPREG:
   case spm_corefi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMERELUPREG:
   case spm_corefi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMEGET:
   case spm_corefi_tclToken::EN_BINCONTAINER:
   case spm_corefi_tclToken::EN_IMEDATE:
   case spm_corefi_tclToken::EN_WVERSIONINFO:
   case spm_corefi_tclToken::EN_B32_SUBSTATE0:
   case spm_corefi_tclToken::EN_B32_SUBSTATE1:
   case spm_corefi_tclToken::EN_B32_SUBSTATE2:
   case spm_corefi_tclToken::EN_B32_SUBSTATE3:
   case spm_corefi_tclToken::EN_SPM_E32_SUBSTATETYPE:
   case spm_corefi_tclToken::EN_SPM_E32_ONOFFREASON:
   case spm_corefi_tclToken::EN_SPM_E32_SYSTEM_STATES:
   case spm_corefi_tclToken::EN_SPM_E32_SYSPWR_BEHAVIOUR:
   case spm_corefi_tclToken::EN_SPM_E32_HMI_STATE:
   case spm_corefi_tclToken::EN_SPM_E32_DIM_STATE:
   case spm_corefi_tclToken::EN_SPM_B32_DIM_STATE:
   case spm_corefi_tclToken::EN_SPM_E32_BT_STATE:
   case spm_corefi_tclToken::EN_SPM_E32_WIFI_STATE:
   case spm_corefi_tclToken::EN_SPM_E32_AUDIO_STATE:
   case spm_corefi_tclToken::EN_SPM_E32_SPI_STATE:
   case spm_corefi_tclToken::EN_SPM_E32_TUNER_STATE:
   case spm_corefi_tclToken::EN_SPM_E32_AUDIO_SOURCE:
   case spm_corefi_tclToken::EN_SPM_E32_CD_INSERT_STATE:
   case spm_corefi_tclToken::EN_SPM_E32_SYS_STATE:
   case spm_corefi_tclToken::EN_SPM_E32_MOST_EVENT:
   case spm_corefi_tclToken::EN_SPM_E32_MOST_CONFIG_STATE:
   case spm_corefi_tclToken::EN_SPM_E32_TLA_STATE:
   case spm_corefi_tclToken::EN_SPM_E32_PROCESSOR_STATE:
   case spm_corefi_tclToken::EN_SPM_E32_STARTUP_STATE:
   case spm_corefi_tclToken::EN_SPM_HISTORYTRIGGER:
   case spm_corefi_tclToken::EN_SPM_E32_RESTART_TYPE:
   case spm_corefi_tclToken::EN_SPM_E32_CODE_REQUEST:
   case spm_corefi_tclToken::EN_SPM_E32_WAKEUP_REASON:
   case spm_corefi_tclToken::EN_SPM_E32_MEDIA_EJECT_STATE:
   case spm_corefi_tclToken::EN_SPM_E32_KEY_STATE:
   case spm_corefi_tclToken::EN_SPM_E32_SECURITY_STATE:
   case spm_corefi_tclToken::EN_SPM_E32_STARTUP_REASON:
   case spm_corefi_tclToken::EN_SPM_E32_PHONE_MUTE_STATE:
   case spm_corefi_tclToken::EN_E8_LCMRESETREASON:
   case spm_corefi_tclToken::EN_SPM_E32_CVM_EVENT:
   case spm_corefi_tclToken::EN_SPM_E32_SYSPWRMODE:
   case spm_corefi_tclToken::EN_SPM_E8_WAKEUP_LIST_REASON:
   case spm_corefi_tclToken::EN_SPM_TRANSPORTMODE:
   case spm_corefi_tclToken::EN_SPM_TRANSPORTMODELIST:
   case spm_corefi_tclToken::EN_E8_STATEMODES:
   case spm_corefi_tclToken::EN_E8_STATEENTRYTYPE:
   case spm_corefi_tclToken::EN_SUBSTATEENTRY:
   case spm_corefi_tclToken::EN_E8_DOWNLOADLOCKSTATES:
   case spm_corefi_tclToken::EN_E8_PROCESSSTATE:
   case spm_corefi_tclToken::EN_PROCESSELEMENT:
   case spm_corefi_tclToken::EN_SPM_PROCESSINFO:
   case spm_corefi_tclToken::EN_SPM_VIN:
   case spm_corefi_tclToken::EN_SPM_VINHISTORY:
   case spm_corefi_tclToken::EN_RESETELEMENT:
   case spm_corefi_tclToken::EN_WAKEUPELEMENT:
   case spm_corefi_tclToken::EN_STATECHANGEELEMENT:
   case spm_corefi_tclToken::EN_SWITCHONELEMENT:
   case spm_corefi_tclToken::EN_SPM_E32_START_PROC_TYPE:
   case spm_corefi_tclToken::EN_SPM_E32_MRESULT:
   case spm_corefi_tclToken::EN_SPM_E32_RUNLEVEL:
   case spm_corefi_tclToken::EN_SPM_B32_SYSPWRSAVEMODE:
   case spm_corefi_tclToken::EN_SPM_PARTNUMBERITEM:
   case spm_corefi_tclToken::EN_SPM_PARTNUMBERLIST:
   case spm_corefi_tclToken::EN_SPM_ALPHACODEITEM:
   case spm_corefi_tclToken::EN_SPM_ALPHACODELIST:
   case spm_corefi_tclToken::EN_SPM_E32_REDUCTION_LEVEL:
   case spm_corefi_tclToken::EN_SPM_E32_CLEAR_LIST:
   case spm_corefi_tclToken::EN_SPM_APPIDLIST:
   case spm_corefi_tclToken::EN_SPM_RESTRICTEDDLLOCK:
   case spm_corefi_tclToken::EN_E8_UPDATELOCKCOMMAND:
   case spm_corefi_tclToken::EN_E8_UPDATELOCKSTATE:
   case spm_corefi_tclToken::EN_SPM_UPDATELOCKSTATE:
   case spm_corefi_tclToken::EN_SPM_VOLTAGEEVENTCOUNTER:
   case spm_corefi_tclToken::EN_SPM_VOLTAGERANGE:
   case spm_corefi_tclToken::EN_SPM_SYSTEMSTATISTICSDATA:
   case spm_corefi_tclToken::EN_SPM_RESETINFOSTATISTICDATA:
   case spm_corefi_tclToken::EN_SPM_SWVERSIONSTATISTICDATA:
   case spm_corefi_tclToken::EN_E8_DEFSETMODE:
   case spm_corefi_tclToken::EN_E8_DIAGLOGDEFSETTYPE:
   case spm_corefi_tclToken::EN_U8:   
   case spm_corefi_tclToken::EN_S8:   
   case spm_corefi_tclToken::EN_U16:   
   case spm_corefi_tclToken::EN_S16:   
   case spm_corefi_tclToken::EN_U24:   
   case spm_corefi_tclToken::EN_S24:   
   case spm_corefi_tclToken::EN_U32:   
   case spm_corefi_tclToken::EN_S32:   
   case spm_corefi_tclToken::EN_U64:   
   case spm_corefi_tclToken::EN_S64:   
   case spm_corefi_tclToken::EN_F32:   
   case spm_corefi_tclToken::EN_F64:   
   case spm_corefi_tclToken::EN_BOOL:   
   case spm_corefi_tclToken::EN_STRING:   
   case spm_corefi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(spm_corefi_tclKnot(enMsgToken,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool spm_corefi_tclDescription::bDoIt(spm_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool spm_corefi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      spm_corefi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      spm_corefi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      spm_corefi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(spm_corefi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(spm_corefi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(spm_corefi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case spm_corefi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == spm_corefi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_LIST: 
      {
         spm_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            spm_corefi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(spm_corefi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            spm_corefi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(spm_corefi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case spm_corefi_tclToken::EN_U8: 
      {
         spm_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case spm_corefi_tclToken::EN_U16: 
      {
         spm_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_U24: 
      {
         spm_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_U32: 
      {
         spm_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_U64: 
      {
         spm_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_S8: 
      {
         spm_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_S16: 
      {
         spm_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_S24: 
      {
         spm_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_S32: 
      {
         spm_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_S64: 
      {
         spm_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_F32: 
      {
         spm_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_F64: 
      {
         spm_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_BOOL: 
      {
         spm_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_STRING: 
      {
         spm_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         spm_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case spm_corefi_tclToken::EN_MSG_SYSTEMMODEMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_SYSTEMMODEMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_DOWNLOADLOCKSTATEMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_DOWNLOADLOCKSTATEMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_UPDATELOCKMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_UPDATELOCKMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_ONOFFTRIGGERMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_ONOFFTRIGGERMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_STARTPROCESSMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_STARTPROCESSMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_STOPPROCESSMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_STOPPROCESSMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_RESTARTPROCESSMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_RESTARTPROCESSMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_STARTUPSYNCPOINTREACHEDMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_STARTUPSYNCPOINTREACHEDMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_CLEARLISTMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_CLEARLISTMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_SPECIFICSWVERSIONSTATISTICMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_SPECIFICSWVERSIONSTATISTICMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_RESTARTSYSTEMMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_RESTARTSYSTEMMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_AUDIOSOURCECHANGEMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_AUDIOSOURCECHANGEMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_CHANGEBLUETOOTHSTATEMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_CHANGEBLUETOOTHSTATEMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_CHANGEAUDIOSTATEMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_CHANGEAUDIOSTATEMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_CHANGESPISTATEMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_CHANGESPISTATEMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_CHANGETUNERSTATEMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_CHANGETUNERSTATEMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_CHANGEWIFISTATEMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_CHANGEWIFISTATEMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_SHUTDOWNANDTERMINATECCAAPPSMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_SHUTDOWNANDTERMINATECCAAPPSMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_CLEARVINMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_CLEARVINMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_PREPAREDOWNLOADMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_PREPAREDOWNLOADMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_ENDDOWNLOADMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_ENDDOWNLOADMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_SETONCONFIGURATIONMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_SETONCONFIGURATIONMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_SETPROCESSCONFIGURATIONMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_SETPROCESSCONFIGURATIONMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_ENTERTAINDEMUTEMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_ENTERTAINDEMUTEMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_ENTERTAINMUTEREQUESTMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_ENTERTAINMUTEREQUESTMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_WELCOMEAUDIOACTIVATIONMETHODSTART:
      case spm_corefi_tclToken::EN_MSG_WELCOMEAUDIOACTIVATIONMETHODRESULT:
      case spm_corefi_tclToken::EN_MSG_SYSTEMSTATEUPREG:
      case spm_corefi_tclToken::EN_MSG_SYSTEMSTATERELUPREG:
      case spm_corefi_tclToken::EN_MSG_SYSTEMSTATEGET:
      case spm_corefi_tclToken::EN_MSG_SYSTEMSTATESTATUS:
      case spm_corefi_tclToken::EN_MSG_DOWNLOADLOCKSTATESSTATUS:
      case spm_corefi_tclToken::EN_MSG_DOWNLOADLOCKSTATESUPREG:
      case spm_corefi_tclToken::EN_MSG_DOWNLOADLOCKSTATESRELUPREG:
      case spm_corefi_tclToken::EN_MSG_DOWNLOADLOCKSTATESGET:
      case spm_corefi_tclToken::EN_MSG_UPDATELOCKSTATESSTATUS:
      case spm_corefi_tclToken::EN_MSG_UPDATELOCKSTATESUPREG:
      case spm_corefi_tclToken::EN_MSG_UPDATELOCKSTATESRELUPREG:
      case spm_corefi_tclToken::EN_MSG_UPDATELOCKSTATESGET:
      case spm_corefi_tclToken::EN_MSG_ACTIVEONOFFTRIGGERSTATUS:
      case spm_corefi_tclToken::EN_MSG_ACTIVEONOFFTRIGGERUPREG:
      case spm_corefi_tclToken::EN_MSG_ACTIVEONOFFTRIGGERRELUPREG:
      case spm_corefi_tclToken::EN_MSG_ACTIVEONOFFTRIGGERGET:
      case spm_corefi_tclToken::EN_MSG_SUBSTATESSET:
      case spm_corefi_tclToken::EN_MSG_SUBSTATESSTATUS:
      case spm_corefi_tclToken::EN_MSG_SUBSTATESUPREG:
      case spm_corefi_tclToken::EN_MSG_SUBSTATESRELUPREG:
      case spm_corefi_tclToken::EN_MSG_SUBSTATESGET:
      case spm_corefi_tclToken::EN_MSG_HISTORYTRIGGERSTATUS:
      case spm_corefi_tclToken::EN_MSG_HISTORYTRIGGERUPREG:
      case spm_corefi_tclToken::EN_MSG_HISTORYTRIGGERRELUPREG:
      case spm_corefi_tclToken::EN_MSG_HISTORYTRIGGERGET:
      case spm_corefi_tclToken::EN_MSG_INSERTSTATESTATUS:
      case spm_corefi_tclToken::EN_MSG_INSERTSTATEUPREG:
      case spm_corefi_tclToken::EN_MSG_INSERTSTATERELUPREG:
      case spm_corefi_tclToken::EN_MSG_INSERTSTATEGET:
      case spm_corefi_tclToken::EN_MSG_MEDIAEJECTSTATESTATUS:
      case spm_corefi_tclToken::EN_MSG_MEDIAEJECTSTATEUPREG:
      case spm_corefi_tclToken::EN_MSG_MEDIAEJECTSTATERELUPREG:
      case spm_corefi_tclToken::EN_MSG_MEDIAEJECTSTATEGET:
      case spm_corefi_tclToken::EN_MSG_PHONEMUTESTATESTATUS:
      case spm_corefi_tclToken::EN_MSG_PHONEMUTESTATEUPREG:
      case spm_corefi_tclToken::EN_MSG_PHONEMUTESTATERELUPREG:
      case spm_corefi_tclToken::EN_MSG_PHONEMUTESTATEGET:
      case spm_corefi_tclToken::EN_MSG_ONTIPPERSTATESTATUS:
      case spm_corefi_tclToken::EN_MSG_ONTIPPERSTATEUPREG:
      case spm_corefi_tclToken::EN_MSG_ONTIPPERSTATERELUPREG:
      case spm_corefi_tclToken::EN_MSG_ONTIPPERSTATEGET:
      case spm_corefi_tclToken::EN_MSG_IGNITIONCYCLESSTATUS:
      case spm_corefi_tclToken::EN_MSG_IGNITIONCYCLESUPREG:
      case spm_corefi_tclToken::EN_MSG_IGNITIONCYCLESRELUPREG:
      case spm_corefi_tclToken::EN_MSG_IGNITIONCYCLESGET:
      case spm_corefi_tclToken::EN_MSG_SYSPWRMODESTATUS:
      case spm_corefi_tclToken::EN_MSG_SYSPWRMODEUPREG:
      case spm_corefi_tclToken::EN_MSG_SYSPWRMODERELUPREG:
      case spm_corefi_tclToken::EN_MSG_SYSPWRMODEGET:
      case spm_corefi_tclToken::EN_MSG_SYSPWRSAVEMODESTATUS:
      case spm_corefi_tclToken::EN_MSG_SYSPWRSAVEMODEGET:
      case spm_corefi_tclToken::EN_MSG_MAPDOWNLOADLOCKSTATESTATUS:
      case spm_corefi_tclToken::EN_MSG_MAPDOWNLOADLOCKSTATEUPREG:
      case spm_corefi_tclToken::EN_MSG_MAPDOWNLOADLOCKSTATERELUPREG:
      case spm_corefi_tclToken::EN_MSG_MAPDOWNLOADLOCKSTATEGET:
      case spm_corefi_tclToken::EN_MSG_STANDBYTIMESET:
      case spm_corefi_tclToken::EN_MSG_STANDBYTIMESTATUS:
      case spm_corefi_tclToken::EN_MSG_STANDBYTIMEGET:
      case spm_corefi_tclToken::EN_MSG_PERSITENTSTANDBYTIMESET:
      case spm_corefi_tclToken::EN_MSG_PERSITENTSTANDBYTIMESTATUS:
      case spm_corefi_tclToken::EN_MSG_PERSITENTSTANDBYTIMEGET:
      case spm_corefi_tclToken::EN_MSG_IGNITIONOFFTIMESET:
      case spm_corefi_tclToken::EN_MSG_IGNITIONOFFTIMESTATUS:
      case spm_corefi_tclToken::EN_MSG_IGNITIONOFFTIMEGET:
      case spm_corefi_tclToken::EN_MSG_DOOROPENTIMESET:
      case spm_corefi_tclToken::EN_MSG_DOOROPENTIMESTATUS:
      case spm_corefi_tclToken::EN_MSG_DOOROPENTIMEGET:
      case spm_corefi_tclToken::EN_MSG_CLOCKDISPLAYTIMESET:
      case spm_corefi_tclToken::EN_MSG_CLOCKDISPLAYTIMESTATUS:
      case spm_corefi_tclToken::EN_MSG_CLOCKDISPLAYTIMEGET:
      case spm_corefi_tclToken::EN_MSG_SYSTEMSTATETIMEGET:
      case spm_corefi_tclToken::EN_MSG_SYSTEMSTATETIMESET:
      case spm_corefi_tclToken::EN_MSG_SYSTEMSTATETIMESTATUS:
      case spm_corefi_tclToken::EN_MSG_PROCESSLISTSTATUS:
      case spm_corefi_tclToken::EN_MSG_PROCESSLISTUPREG:
      case spm_corefi_tclToken::EN_MSG_PROCESSLISTRELUPREG:
      case spm_corefi_tclToken::EN_MSG_PROCESSLISTGET:
      case spm_corefi_tclToken::EN_MSG_WAKEUPREASONSTATUS:
      case spm_corefi_tclToken::EN_MSG_WAKEUPREASONGET:
      case spm_corefi_tclToken::EN_MSG_STARTUPREASONSTATUS:
      case spm_corefi_tclToken::EN_MSG_STARTUPREASONGET:
      case spm_corefi_tclToken::EN_MSG_CONNECTTOBATTERYSTATUS:
      case spm_corefi_tclToken::EN_MSG_CONNECTTOBATTERYGET:
      case spm_corefi_tclToken::EN_MSG_CODEREQUESTSTATESET:
      case spm_corefi_tclToken::EN_MSG_CODEREQUESTSTATESTATUS:
      case spm_corefi_tclToken::EN_MSG_CODEREQUESTSTATEUPREG:
      case spm_corefi_tclToken::EN_MSG_CODEREQUESTSTATERELUPREG:
      case spm_corefi_tclToken::EN_MSG_CODEREQUESTSTATEGET:
      case spm_corefi_tclToken::EN_MSG_ACTIVESTARTUPSYNCPOINTSSTATUS:
      case spm_corefi_tclToken::EN_MSG_ACTIVESTARTUPSYNCPOINTSUPREG:
      case spm_corefi_tclToken::EN_MSG_ACTIVESTARTUPSYNCPOINTSRELUPREG:
      case spm_corefi_tclToken::EN_MSG_ACTIVESTARTUPSYNCPOINTSGET:
      case spm_corefi_tclToken::EN_MSG_CVMEVENTSTATUS:
      case spm_corefi_tclToken::EN_MSG_CVMEVENTUPREG:
      case spm_corefi_tclToken::EN_MSG_CVMEVENTRELUPREG:
      case spm_corefi_tclToken::EN_MSG_CVMEVENTGET:
      case spm_corefi_tclToken::EN_MSG_UBATSENSEGET:
      case spm_corefi_tclToken::EN_MSG_UBATSENSESTATUS:
      case spm_corefi_tclToken::EN_MSG_COPROSTATESET:
      case spm_corefi_tclToken::EN_MSG_COPROSTATESTATUS:
      case spm_corefi_tclToken::EN_MSG_COPROSTATEUPREG:
      case spm_corefi_tclToken::EN_MSG_COPROSTATERELUPREG:
      case spm_corefi_tclToken::EN_MSG_COPROSTATEGET:
      case spm_corefi_tclToken::EN_MSG_DEVICEPOWERONTIMESET:
      case spm_corefi_tclToken::EN_MSG_DEVICEPOWERONTIMESTATUS:
      case spm_corefi_tclToken::EN_MSG_DEVICEPOWERONTIMEGET:
      case spm_corefi_tclToken::EN_MSG_LASTSYSTEMRUNTIMESTATUS:
      case spm_corefi_tclToken::EN_MSG_LASTSYSTEMRUNTIMEGET:
      case spm_corefi_tclToken::EN_MSG_CURRENTSYSTEMRUNTIMESTATUS:
      case spm_corefi_tclToken::EN_MSG_CURRENTSYSTEMRUNTIMEGET:
      case spm_corefi_tclToken::EN_MSG_RESETLISTSET:
      case spm_corefi_tclToken::EN_MSG_RESETLISTSTATUS:
      case spm_corefi_tclToken::EN_MSG_RESETLISTGET:
      case spm_corefi_tclToken::EN_MSG_RESETCOUNTERSET:
      case spm_corefi_tclToken::EN_MSG_RESETCOUNTERSTATUS:
      case spm_corefi_tclToken::EN_MSG_RESETCOUNTERUPREG:
      case spm_corefi_tclToken::EN_MSG_RESETCOUNTERRELUPREG:
      case spm_corefi_tclToken::EN_MSG_RESETCOUNTERGET:
      case spm_corefi_tclToken::EN_MSG_TRANSPORTMODELISTSET:
      case spm_corefi_tclToken::EN_MSG_TRANSPORTMODELISTSTATUS:
      case spm_corefi_tclToken::EN_MSG_TRANSPORTMODELISTGET:
      case spm_corefi_tclToken::EN_MSG_RESETHISTORYSET:
      case spm_corefi_tclToken::EN_MSG_RESETHISTORYSTATUS:
      case spm_corefi_tclToken::EN_MSG_RESETHISTORYGET:
      case spm_corefi_tclToken::EN_MSG_WAKEUPHISTORYSET:
      case spm_corefi_tclToken::EN_MSG_WAKEUPHISTORYSTATUS:
      case spm_corefi_tclToken::EN_MSG_WAKEUPHISTORYGET:
      case spm_corefi_tclToken::EN_MSG_STATEHISTORYSET:
      case spm_corefi_tclToken::EN_MSG_STATEHISTORYSTATUS:
      case spm_corefi_tclToken::EN_MSG_STATEHISTORYGET:
      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY01SET:
      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY01STATUS:
      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY01GET:
      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY02SET:
      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY02STATUS:
      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY02GET:
      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY03SET:
      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY03STATUS:
      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY03GET:
      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY04SET:
      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY04STATUS:
      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY04GET:
      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY05SET:
      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY05STATUS:
      case spm_corefi_tclToken::EN_MSG_ERRSTATEHISTORY05GET:
      case spm_corefi_tclToken::EN_MSG_SWITCHONHISTORYSET:
      case spm_corefi_tclToken::EN_MSG_SWITCHONHISTORYSTATUS:
      case spm_corefi_tclToken::EN_MSG_SWITCHONHISTORYGET:
      case spm_corefi_tclToken::EN_MSG_DEVICEONCOUNTERSTATUS:
      case spm_corefi_tclToken::EN_MSG_DEVICEONCOUNTERGET:
      case spm_corefi_tclToken::EN_MSG_VOLTAGEEVENTCOUNTERSTATUS:
      case spm_corefi_tclToken::EN_MSG_VOLTAGEEVENTCOUNTERGET:
      case spm_corefi_tclToken::EN_MSG_VOLTAGERANGEHISTOGRAMSTATUS:
      case spm_corefi_tclToken::EN_MSG_VOLTAGERANGEHISTOGRAMGET:
      case spm_corefi_tclToken::EN_MSG_CPUUSAGESTATISTICSTATUS:
      case spm_corefi_tclToken::EN_MSG_CPUUSAGESTATISTICGET:
      case spm_corefi_tclToken::EN_MSG_RAMUSAGESTATISTICSTATUS:
      case spm_corefi_tclToken::EN_MSG_RAMUSAGESTATISTICGET:
      case spm_corefi_tclToken::EN_MSG_STARTUPTIMESTATISTICSTATUS:
      case spm_corefi_tclToken::EN_MSG_STARTUPTIMESTATISTICGET:
      case spm_corefi_tclToken::EN_MSG_SWVERSIONSTATISTICSTATUS:
      case spm_corefi_tclToken::EN_MSG_SWVERSIONSTATISTICGET:
      case spm_corefi_tclToken::EN_MSG_RUNLEVELSTATEUPREG:
      case spm_corefi_tclToken::EN_MSG_RUNLEVELSTATERELUPREG:
      case spm_corefi_tclToken::EN_MSG_RUNLEVELSTATEGET:
      case spm_corefi_tclToken::EN_MSG_RUNLEVELSTATESTATUS:
      case spm_corefi_tclToken::EN_MSG_RESTARTSET:
      case spm_corefi_tclToken::EN_MSG_RESTARTSTATUS:
      case spm_corefi_tclToken::EN_MSG_RESTARTUPREG:
      case spm_corefi_tclToken::EN_MSG_RESTARTRELUPREG:
      case spm_corefi_tclToken::EN_MSG_RESTARTGET:
      case spm_corefi_tclToken::EN_MSG_LIFESIGNSTATUS:
      case spm_corefi_tclToken::EN_MSG_LIFESIGNUPREG:
      case spm_corefi_tclToken::EN_MSG_LIFESIGNRELUPREG:
      case spm_corefi_tclToken::EN_MSG_LIFESIGNGET:
      case spm_corefi_tclToken::EN_MSG_HMISTATESTATUS:
      case spm_corefi_tclToken::EN_MSG_HMISTATEUPREG:
      case spm_corefi_tclToken::EN_MSG_HMISTATERELUPREG:
      case spm_corefi_tclToken::EN_MSG_HMISTATEGET:
      case spm_corefi_tclToken::EN_MSG_SYSTEMPOWERBEHAVIOURSTATUS:
      case spm_corefi_tclToken::EN_MSG_SYSTEMPOWERBEHAVIOURUPREG:
      case spm_corefi_tclToken::EN_MSG_SYSTEMPOWERBEHAVIOURRELUPREG:
      case spm_corefi_tclToken::EN_MSG_SYSTEMPOWERBEHAVIOURGET:
      case spm_corefi_tclToken::EN_MSG_DIMSTATESTATUS:
      case spm_corefi_tclToken::EN_MSG_DIMSTATEUPREG:
      case spm_corefi_tclToken::EN_MSG_DIMSTATERELUPREG:
      case spm_corefi_tclToken::EN_MSG_DIMSTATEGET:
      case spm_corefi_tclToken::EN_MSG_DIMMINGSTATESTATUS:
      case spm_corefi_tclToken::EN_MSG_DIMMINGSTATEUPREG:
      case spm_corefi_tclToken::EN_MSG_DIMMINGSTATERELUPREG:
      case spm_corefi_tclToken::EN_MSG_DIMMINGSTATEGET:
      case spm_corefi_tclToken::EN_MSG_BLUETOOTHSTATESTATUS:
      case spm_corefi_tclToken::EN_MSG_BLUETOOTHSTATEUPREG:
      case spm_corefi_tclToken::EN_MSG_BLUETOOTHSTATERELUPREG:
      case spm_corefi_tclToken::EN_MSG_BLUETOOTHSTATEGET:
      case spm_corefi_tclToken::EN_MSG_AUDIOSTATESTATUS:
      case spm_corefi_tclToken::EN_MSG_AUDIOSTATEUPREG:
      case spm_corefi_tclToken::EN_MSG_AUDIOSTATERELUPREG:
      case spm_corefi_tclToken::EN_MSG_AUDIOSTATEGET:
      case spm_corefi_tclToken::EN_MSG_SPISTATESTATUS:
      case spm_corefi_tclToken::EN_MSG_SPISTATEUPREG:
      case spm_corefi_tclToken::EN_MSG_SPISTATERELUPREG:
      case spm_corefi_tclToken::EN_MSG_SPISTATEGET:
      case spm_corefi_tclToken::EN_MSG_TUNERSTATESTATUS:
      case spm_corefi_tclToken::EN_MSG_TUNERSTATEUPREG:
      case spm_corefi_tclToken::EN_MSG_TUNERSTATERELUPREG:
      case spm_corefi_tclToken::EN_MSG_TUNERSTATEGET:
      case spm_corefi_tclToken::EN_MSG_WIFISTATESTATUS:
      case spm_corefi_tclToken::EN_MSG_WIFISTATEUPREG:
      case spm_corefi_tclToken::EN_MSG_WIFISTATERELUPREG:
      case spm_corefi_tclToken::EN_MSG_WIFISTATEGET:
      case spm_corefi_tclToken::EN_MSG_ONOFFREASONSET:
      case spm_corefi_tclToken::EN_MSG_ONOFFREASONGET:
      case spm_corefi_tclToken::EN_MSG_ONOFFREASONSTATUS:
      case spm_corefi_tclToken::EN_MSG_ONOFFREASONUPREG:
      case spm_corefi_tclToken::EN_MSG_ONOFFREASONRELUPREG:
      case spm_corefi_tclToken::EN_MSG_WAKEUPLISTSET:
      case spm_corefi_tclToken::EN_MSG_WAKEUPLISTGET:
      case spm_corefi_tclToken::EN_MSG_WAKEUPLISTSTATUS:
      case spm_corefi_tclToken::EN_MSG_STARTUPFINISHEDUPREG:
      case spm_corefi_tclToken::EN_MSG_STARTUPFINISHEDRELUPREG:
      case spm_corefi_tclToken::EN_MSG_STARTUPFINISHEDGET:
      case spm_corefi_tclToken::EN_MSG_STARTUPFINISHEDSTATUS:
      case spm_corefi_tclToken::EN_MSG_SYSSTATEUPREG:
      case spm_corefi_tclToken::EN_MSG_SYSSTATERELUPREG:
      case spm_corefi_tclToken::EN_MSG_SYSSTATEGET:
      case spm_corefi_tclToken::EN_MSG_SYSSTATESTATUS:
      case spm_corefi_tclToken::EN_MSG_MOSTSTATEUPREG:
      case spm_corefi_tclToken::EN_MSG_MOSTSTATERELUPREG:
      case spm_corefi_tclToken::EN_MSG_MOSTSTATEGET:
      case spm_corefi_tclToken::EN_MSG_MOSTSTATESTATUS:
      case spm_corefi_tclToken::EN_MSG_MOSTVERSIONGET:
      case spm_corefi_tclToken::EN_MSG_MOSTVERSIONSTATUS:
      case spm_corefi_tclToken::EN_MSG_RVCSTATESET:
      case spm_corefi_tclToken::EN_MSG_RVCSTATEGET:
      case spm_corefi_tclToken::EN_MSG_RVCSTATESTATUS:
      case spm_corefi_tclToken::EN_MSG_TRIGGERMOSTREMOTERESETGET:
      case spm_corefi_tclToken::EN_MSG_TRIGGERMOSTREMOTERESETSET:
      case spm_corefi_tclToken::EN_MSG_TRIGGERMOSTREMOTERESETUPREG:
      case spm_corefi_tclToken::EN_MSG_TRIGGERMOSTREMOTERESETRELUPREG:
      case spm_corefi_tclToken::EN_MSG_TRIGGERMOSTREMOTERESETSTATUS:
      case spm_corefi_tclToken::EN_MSG_PARTNUMBERGET:
      case spm_corefi_tclToken::EN_MSG_PARTNUMBERSET:
      case spm_corefi_tclToken::EN_MSG_PARTNUMBERSTATUS:
      case spm_corefi_tclToken::EN_MSG_PARTNUMBERSGET:
      case spm_corefi_tclToken::EN_MSG_PARTNUMBERSSTATUS:
      case spm_corefi_tclToken::EN_MSG_ALPHACODEGET:
      case spm_corefi_tclToken::EN_MSG_ALPHACODESET:
      case spm_corefi_tclToken::EN_MSG_ALPHACODESTATUS:
      case spm_corefi_tclToken::EN_MSG_ALPHACODESGET:
      case spm_corefi_tclToken::EN_MSG_ALPHACODESSTATUS:
      case spm_corefi_tclToken::EN_MSG_MANUFACTURERSENABLECOUNTERGET:
      case spm_corefi_tclToken::EN_MSG_MANUFACTURERSENABLECOUNTERSET:
      case spm_corefi_tclToken::EN_MSG_MANUFACTURERSENABLECOUNTERSTATUS:
      case spm_corefi_tclToken::EN_MSG_NOCALIBRATIONSTATEGET:
      case spm_corefi_tclToken::EN_MSG_NOCALIBRATIONSTATESET:
      case spm_corefi_tclToken::EN_MSG_NOCALIBRATIONSTATESTATUS:
      case spm_corefi_tclToken::EN_MSG_SECURITYCOMMERRORGET:
      case spm_corefi_tclToken::EN_MSG_SECURITYCOMMERRORSTATUS:
      case spm_corefi_tclToken::EN_MSG_SECURITYMORETHAN10VINGET:
      case spm_corefi_tclToken::EN_MSG_SECURITYMORETHAN10VINSTATUS:
      case spm_corefi_tclToken::EN_MSG_SECURITYINVALIDVINGET:
      case spm_corefi_tclToken::EN_MSG_SECURITYINVALIDVINSTATUS:
      case spm_corefi_tclToken::EN_MSG_SECURITYCURRENTVINGET:
      case spm_corefi_tclToken::EN_MSG_SECURITYCURRENTVINSTATUS:
      case spm_corefi_tclToken::EN_MSG_SECURITYVINHISTORYGET:
      case spm_corefi_tclToken::EN_MSG_SECURITYVINHISTORYSTATUS:
      case spm_corefi_tclToken::EN_MSG_VINGET:
      case spm_corefi_tclToken::EN_MSG_VINSTATUS:
      case spm_corefi_tclToken::EN_MSG_SECURITYSTATEUPREG:
      case spm_corefi_tclToken::EN_MSG_SECURITYSTATERELUPREG:
      case spm_corefi_tclToken::EN_MSG_SECURITYSTATEGET:
      case spm_corefi_tclToken::EN_MSG_SECURITYSTATESTATUS:
      case spm_corefi_tclToken::EN_MSG_VEHICLEIDUPREG:
      case spm_corefi_tclToken::EN_MSG_VEHICLEIDRELUPREG:
      case spm_corefi_tclToken::EN_MSG_VEHICLEIDGET:
      case spm_corefi_tclToken::EN_MSG_VEHICLEIDSTATUS:
      case spm_corefi_tclToken::EN_MSG_DISPLAYVARIANTGET:
      case spm_corefi_tclToken::EN_MSG_DISPLAYVARIANTSET:
      case spm_corefi_tclToken::EN_MSG_DISPLAYVARIANTSTATUS:
      case spm_corefi_tclToken::EN_MSG_REDUCTIONLEVELUPREG:
      case spm_corefi_tclToken::EN_MSG_REDUCTIONLEVELRELUPREG:
      case spm_corefi_tclToken::EN_MSG_REDUCTIONLEVELGET:
      case spm_corefi_tclToken::EN_MSG_REDUCTIONLEVELSTATUS:
      case spm_corefi_tclToken::EN_MSG_STARTUPSTATEUPREG:
      case spm_corefi_tclToken::EN_MSG_STARTUPSTATERELUPREG:
      case spm_corefi_tclToken::EN_MSG_STARTUPSTATEGET:
      case spm_corefi_tclToken::EN_MSG_STARTUPSTATESTATUS:
      case spm_corefi_tclToken::EN_MSG_ENTERTAINMUTEUPREG:
      case spm_corefi_tclToken::EN_MSG_ENTERTAINMUTERELUPREG:
      case spm_corefi_tclToken::EN_MSG_ENTERTAINMUTEGET:
      case spm_corefi_tclToken::EN_MSG_ENTERTAINMUTESTATUS:
      case spm_corefi_tclToken::EN_MSG_WELCOMEAUDIOSTATEGET:
      case spm_corefi_tclToken::EN_MSG_WELCOMEAUDIOSTATESTATUS:
      case spm_corefi_tclToken::EN_MSG_UNBALLASTTIMEFROMENGINESTOPPEDGET:
      case spm_corefi_tclToken::EN_MSG_UNBALLASTTIMEFROMENGINESTOPPEDSTATUS:
      case spm_corefi_tclToken::EN_MSG_UNBALLASTTIMEBEFOREUNBALLASTGET:
      case spm_corefi_tclToken::EN_MSG_UNBALLASTTIMEBEFOREUNBALLASTSTATUS:
      case spm_corefi_tclToken::EN_MSG_UNBALLASTTIMEBEFOREUNBALLASTSET:
      case spm_corefi_tclToken::EN_MSG_UNBALLASTWARNINGTIMEGET:
      case spm_corefi_tclToken::EN_MSG_UNBALLASTWARNINGTIMESTATUS:
      case spm_corefi_tclToken::EN_MSG_UNBALLASTWARNINGTIMESET:
      case spm_corefi_tclToken::EN_MSG_DEGRADEDCOUNTGET:
      case spm_corefi_tclToken::EN_MSG_DEGRADEDCOUNTSTATUS:
      case spm_corefi_tclToken::EN_MSG_DEGRADEDTIMEGET:
      case spm_corefi_tclToken::EN_MSG_DEGRADEDTIMESTATUS:
      case spm_corefi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMEUPREG:
      case spm_corefi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMERELUPREG:
      case spm_corefi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMEGET:
      case spm_corefi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMESET:
      case spm_corefi_tclToken::EN_MSG_PHONEHANDOVERWARNTIMESTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case spm_corefi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         spm_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_IMEDATE:
      {
      if (poVisitor->bDoExpandTimeDate(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_U8SECOND));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_U8MINUTE));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_U8HOUR));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_U8DAY));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_U8MONTH));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_S16,spm_corefi_tclSemanticDomain::EN_S16YEAR));
      }
      else
      {
         spm_fi_tclTimeDate oTimeDate;
         if (!bDoIt(oTimeDate))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            oTimeDate.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            oTimeDate.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_WVERSIONINFO:
      {
      if (poVisitor->bDoExpandSwVersionInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STRING,spm_corefi_tclSemanticDomain::EN_TSWCUSTOMERVERSION));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STRING,spm_corefi_tclSemanticDomain::EN_TSWBUILDVERSION));
      }
      else
      {
         spm_fi_tclSwVersionInfo oSwVersionInfo;
         if (!bDoIt(oSwVersionInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            oSwVersionInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            oSwVersionInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_B32_SUBSTATE0:
      {
         spm_fi_tcl_b32_SubState0 o_b32_SubState0;
         if (!bDoIt(o_b32_SubState0))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_B32_SUBSTATE1:
      {
         spm_fi_tcl_b32_SubState1 o_b32_SubState1;
         if (!bDoIt(o_b32_SubState1))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_B32_SUBSTATE2:
      {
         spm_fi_tcl_b32_SubState2 o_b32_SubState2;
         if (!bDoIt(o_b32_SubState2))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_B32_SUBSTATE3:
      {
         spm_fi_tcl_b32_SubState3 o_b32_SubState3;
         if (!bDoIt(o_b32_SubState3))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_SUBSTATETYPE:
      {
         spm_fi_tcl_SPM_e32_SubStateType o_SPM_e32_SubStateType;
         if (!bDoIt(o_SPM_e32_SubStateType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_ONOFFREASON:
      {
         spm_fi_tcl_SPM_e32_OnOffReason o_SPM_e32_OnOffReason;
         if (!bDoIt(o_SPM_e32_OnOffReason))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_SYSTEM_STATES:
      {
         spm_fi_tcl_SPM_e32_SYSTEM_STATES o_SPM_e32_SYSTEM_STATES;
         if (!bDoIt(o_SPM_e32_SYSTEM_STATES))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_SYSPWR_BEHAVIOUR:
      {
         spm_fi_tcl_SPM_e32_SYSPWR_BEHAVIOUR o_SPM_e32_SYSPWR_BEHAVIOUR;
         if (!bDoIt(o_SPM_e32_SYSPWR_BEHAVIOUR))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_HMI_STATE:
      {
         spm_fi_tcl_SPM_e32_HMI_STATE o_SPM_e32_HMI_STATE;
         if (!bDoIt(o_SPM_e32_HMI_STATE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_DIM_STATE:
      {
         spm_fi_tcl_SPM_e32_DIM_STATE o_SPM_e32_DIM_STATE;
         if (!bDoIt(o_SPM_e32_DIM_STATE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_B32_DIM_STATE:
      {
         spm_fi_tcl_SPM_b32_DIM_STATE o_SPM_b32_DIM_STATE;
         if (!bDoIt(o_SPM_b32_DIM_STATE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_BT_STATE:
      {
         spm_fi_tcl_SPM_e32_BT_STATE o_SPM_e32_BT_STATE;
         if (!bDoIt(o_SPM_e32_BT_STATE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_WIFI_STATE:
      {
         spm_fi_tcl_SPM_e32_WIFI_STATE o_SPM_e32_WIFI_STATE;
         if (!bDoIt(o_SPM_e32_WIFI_STATE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_AUDIO_STATE:
      {
         spm_fi_tcl_SPM_e32_AUDIO_STATE o_SPM_e32_AUDIO_STATE;
         if (!bDoIt(o_SPM_e32_AUDIO_STATE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_SPI_STATE:
      {
         spm_fi_tcl_SPM_e32_SPI_STATE o_SPM_e32_SPI_STATE;
         if (!bDoIt(o_SPM_e32_SPI_STATE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_TUNER_STATE:
      {
         spm_fi_tcl_SPM_e32_TUNER_STATE o_SPM_e32_TUNER_STATE;
         if (!bDoIt(o_SPM_e32_TUNER_STATE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_AUDIO_SOURCE:
      {
         spm_fi_tcl_SPM_e32_AUDIO_SOURCE o_SPM_e32_AUDIO_SOURCE;
         if (!bDoIt(o_SPM_e32_AUDIO_SOURCE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_CD_INSERT_STATE:
      {
         spm_fi_tcl_SPM_e32_CD_INSERT_STATE o_SPM_e32_CD_INSERT_STATE;
         if (!bDoIt(o_SPM_e32_CD_INSERT_STATE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_SYS_STATE:
      {
         spm_fi_tcl_SPM_e32_SYS_STATE o_SPM_e32_SYS_STATE;
         if (!bDoIt(o_SPM_e32_SYS_STATE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_MOST_EVENT:
      {
         spm_fi_tcl_SPM_e32_MOST_EVENT o_SPM_e32_MOST_EVENT;
         if (!bDoIt(o_SPM_e32_MOST_EVENT))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_MOST_CONFIG_STATE:
      {
         spm_fi_tcl_SPM_e32_MOST_CONFIG_STATE o_SPM_e32_MOST_CONFIG_STATE;
         if (!bDoIt(o_SPM_e32_MOST_CONFIG_STATE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_TLA_STATE:
      {
         spm_fi_tcl_SPM_e32_TLA_STATE o_SPM_e32_TLA_STATE;
         if (!bDoIt(o_SPM_e32_TLA_STATE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_PROCESSOR_STATE:
      {
         spm_fi_tcl_SPM_e32_PROCESSOR_STATE o_SPM_e32_PROCESSOR_STATE;
         if (!bDoIt(o_SPM_e32_PROCESSOR_STATE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_STARTUP_STATE:
      {
         spm_fi_tcl_SPM_e32_STARTUP_STATE o_SPM_e32_STARTUP_STATE;
         if (!bDoIt(o_SPM_e32_STARTUP_STATE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_HISTORYTRIGGER:
      {
      if (poVisitor->bDoExpand_SPM_HistoryTrigger(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_SUBSTATETYPE,spm_corefi_tclSemanticDomain::EN_ETRIGGERTYPE));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_U32TIMESTAMP));
      }
      else
      {
         spm_fi_tcl_SPM_HistoryTrigger o_SPM_HistoryTrigger;
         if (!bDoIt(o_SPM_HistoryTrigger))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_HistoryTrigger.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_HistoryTrigger.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_RESTART_TYPE:
      {
         spm_fi_tcl_SPM_e32_RESTART_TYPE o_SPM_e32_RESTART_TYPE;
         if (!bDoIt(o_SPM_e32_RESTART_TYPE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_CODE_REQUEST:
      {
         spm_fi_tcl_SPM_e32_CODE_REQUEST o_SPM_e32_CODE_REQUEST;
         if (!bDoIt(o_SPM_e32_CODE_REQUEST))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_WAKEUP_REASON:
      {
         spm_fi_tcl_SPM_e32_WAKEUP_REASON o_SPM_e32_WAKEUP_REASON;
         if (!bDoIt(o_SPM_e32_WAKEUP_REASON))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_MEDIA_EJECT_STATE:
      {
         spm_fi_tcl_SPM_e32_MEDIA_EJECT_STATE o_SPM_e32_MEDIA_EJECT_STATE;
         if (!bDoIt(o_SPM_e32_MEDIA_EJECT_STATE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_KEY_STATE:
      {
         spm_fi_tcl_SPM_e32_KEY_STATE o_SPM_e32_KEY_STATE;
         if (!bDoIt(o_SPM_e32_KEY_STATE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_SECURITY_STATE:
      {
         spm_fi_tcl_SPM_e32_SECURITY_STATE o_SPM_e32_SECURITY_STATE;
         if (!bDoIt(o_SPM_e32_SECURITY_STATE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_STARTUP_REASON:
      {
         spm_fi_tcl_SPM_e32_STARTUP_REASON o_SPM_e32_STARTUP_REASON;
         if (!bDoIt(o_SPM_e32_STARTUP_REASON))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_PHONE_MUTE_STATE:
      {
         spm_fi_tcl_SPM_e32_PHONE_MUTE_STATE o_SPM_e32_PHONE_MUTE_STATE;
         if (!bDoIt(o_SPM_e32_PHONE_MUTE_STATE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_E8_LCMRESETREASON:
      {
         spm_fi_tcl_e8_LcmResetReason o_e8_LcmResetReason;
         if (!bDoIt(o_e8_LcmResetReason))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_CVM_EVENT:
      {
         spm_fi_tcl_SPM_e32_CVM_EVENT o_SPM_e32_CVM_EVENT;
         if (!bDoIt(o_SPM_e32_CVM_EVENT))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_SYSPWRMODE:
      {
         spm_fi_tcl_SPM_e32_SYSPWRMODE o_SPM_e32_SYSPWRMODE;
         if (!bDoIt(o_SPM_e32_SYSPWRMODE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E8_WAKEUP_LIST_REASON:
      {
         spm_fi_tcl_SPM_e8_WAKEUP_LIST_REASON o_SPM_e8_WAKEUP_LIST_REASON;
         if (!bDoIt(o_SPM_e8_WAKEUP_LIST_REASON))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_TRANSPORTMODE:
      {
      if (poVisitor->bDoExpand_SPM_TransPortMode(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MINUTE));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_HOUR));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_DAY));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MONTH));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_YEAR));
      }
      else
      {
         spm_fi_tcl_SPM_TransPortMode o_SPM_TransPortMode;
         if (!bDoIt(o_SPM_TransPortMode))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_TransPortMode.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_TransPortMode.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_SPM_TRANSPORTMODELIST:
      {
      if (poVisitor->bDoExpand_SPM_TransPortModeList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_TRANSPORTMODE,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_TRANSPORTMODELIST));
      }
      else
      {
         spm_fi_tcl_SPM_TransPortModeList o_SPM_TransPortModeList;
         if (!bDoIt(o_SPM_TransPortModeList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_TransPortModeList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_TransPortModeList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_E8_STATEMODES:
      {
         spm_fi_tcl_e8_StateModes o_e8_StateModes;
         if (!bDoIt(o_e8_StateModes))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_E8_STATEENTRYTYPE:
      {
         spm_fi_tcl_e8_StateEntryType o_e8_StateEntryType;
         if (!bDoIt(o_e8_StateEntryType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SUBSTATEENTRY:
      {
      if (poVisitor->bDoExpand_SubStateEntry(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_B32_SUBSTATE3,spm_corefi_tclSemanticDomain::EN_TSUBSTATEDATA3));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_B32_SUBSTATE3,spm_corefi_tclSemanticDomain::EN_TSUBSTATEMASK3));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_B32_SUBSTATE2,spm_corefi_tclSemanticDomain::EN_TSUBSTATEDATA2));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_B32_SUBSTATE2,spm_corefi_tclSemanticDomain::EN_TSUBSTATEMASK2));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_B32_SUBSTATE1,spm_corefi_tclSemanticDomain::EN_TSUBSTATEDATA1));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_B32_SUBSTATE1,spm_corefi_tclSemanticDomain::EN_TSUBSTATEMASK1));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_B32_SUBSTATE0,spm_corefi_tclSemanticDomain::EN_TSUBSTATEDATA0));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_B32_SUBSTATE0,spm_corefi_tclSemanticDomain::EN_TSUBSTATEMASK0));
      }
      else
      {
         spm_fi_tcl_SubStateEntry o_SubStateEntry;
         if (!bDoIt(o_SubStateEntry))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SubStateEntry.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SubStateEntry.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_E8_DOWNLOADLOCKSTATES:
      {
         spm_fi_tcl_e8_DownloadLockStates o_e8_DownloadLockStates;
         if (!bDoIt(o_e8_DownloadLockStates))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_E8_PROCESSSTATE:
      {
         spm_fi_tcl_e8_ProcessState o_e8_ProcessState;
         if (!bDoIt(o_e8_ProcessState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_PROCESSELEMENT:
      {
      if (poVisitor->bDoExpand_ProcessElement(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_IMEDATE,spm_corefi_tclSemanticDomain::EN_TSWITCHONDATE));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_U32STARTTIMESINCESTART));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_E8_PROCESSSTATE,spm_corefi_tclSemanticDomain::EN_EPROCSTATE));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STRING,spm_corefi_tclSemanticDomain::EN_TCONFIGUREDPROCESSNAME));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STRING,spm_corefi_tclSemanticDomain::EN_TPROCESSNAME));
      }
      else
      {
         spm_fi_tcl_ProcessElement o_ProcessElement;
         if (!bDoIt(o_ProcessElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ProcessElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ProcessElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_SPM_PROCESSINFO:
      {
      if (poVisitor->bDoExpand_SPM_ProcessInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_PROCESSELEMENT,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_TPROCESSES));
      }
      else
      {
         spm_fi_tcl_SPM_ProcessInfo o_SPM_ProcessInfo;
         if (!bDoIt(o_SPM_ProcessInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_ProcessInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_ProcessInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_SPM_VIN:
      {
      if (poVisitor->bDoExpand_SPM_Vin(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_VIN));
      }
      else
      {
         spm_fi_tcl_SPM_Vin o_SPM_Vin;
         if (!bDoIt(o_SPM_Vin))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_Vin.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_Vin.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_SPM_VINHISTORY:
      {
      if (poVisitor->bDoExpand_SPM_VinHistory(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_VIN,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_VINHISTORY));
      }
      else
      {
         spm_fi_tcl_SPM_VinHistory o_SPM_VinHistory;
         if (!bDoIt(o_SPM_VinHistory))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_VinHistory.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_VinHistory.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_RESETELEMENT:
      {
      if (poVisitor->bDoExpand_ResetElement(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_E8_LCMRESETREASON,spm_corefi_tclSemanticDomain::EN_ERESET));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_WVERSIONINFO,spm_corefi_tclSemanticDomain::EN_TSWVERSIONINFO));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_IMEDATE,spm_corefi_tclSemanticDomain::EN_TRESETDATE));
      }
      else
      {
         spm_fi_tcl_ResetElement o_ResetElement;
         if (!bDoIt(o_ResetElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ResetElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ResetElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_WAKEUPELEMENT:
      {
      if (poVisitor->bDoExpand_WakeupElement(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_WAKEUP_REASON,spm_corefi_tclSemanticDomain::EN_EWAKEUPREASON));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_IMEDATE,spm_corefi_tclSemanticDomain::EN_TWAKEUPDATE));
      }
      else
      {
         spm_fi_tcl_WakeupElement o_WakeupElement;
         if (!bDoIt(o_WakeupElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WakeupElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_WakeupElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_STATECHANGEELEMENT:
      {
      if (poVisitor->bDoExpand_StateChangeElement(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SUBSTATEENTRY,spm_corefi_tclSemanticDomain::EN_TSUBSTATES));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_E8_LCMRESETREASON,spm_corefi_tclSemanticDomain::EN_TRESET));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_WAKEUP_REASON,spm_corefi_tclSemanticDomain::EN_TWAKEUP));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_E8_STATEENTRYTYPE,spm_corefi_tclSemanticDomain::EN_TELEMTYPE));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_SYSTEM_STATES,spm_corefi_tclSemanticDomain::EN_TSYSSTATE));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_IMEDATE,spm_corefi_tclSemanticDomain::EN_TWAKEUPDATE));
      }
      else
      {
         spm_fi_tcl_StateChangeElement o_StateChangeElement;
         if (!bDoIt(o_StateChangeElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StateChangeElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_StateChangeElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_SWITCHONELEMENT:
      {
      if (poVisitor->bDoExpand_SwitchOnElement(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_E32_SUBSTATETYPE,spm_corefi_tclSemanticDomain::EN_ESWITCHONREASON));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_IMEDATE,spm_corefi_tclSemanticDomain::EN_TSWITCHONDATE));
      }
      else
      {
         spm_fi_tcl_SwitchOnElement o_SwitchOnElement;
         if (!bDoIt(o_SwitchOnElement))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SwitchOnElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SwitchOnElement.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_START_PROC_TYPE:
      {
         spm_fi_tcl_SPM_e32_START_PROC_TYPE o_SPM_e32_START_PROC_TYPE;
         if (!bDoIt(o_SPM_e32_START_PROC_TYPE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_MRESULT:
      {
         spm_fi_tcl_SPM_e32_MRESULT o_SPM_e32_MRESULT;
         if (!bDoIt(o_SPM_e32_MRESULT))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_RUNLEVEL:
      {
         spm_fi_tcl_SPM_e32_RUNLEVEL o_SPM_e32_RUNLEVEL;
         if (!bDoIt(o_SPM_e32_RUNLEVEL))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_B32_SYSPWRSAVEMODE:
      {
         spm_fi_tcl_SPM_b32_SYSPWRSAVEMODE o_SPM_b32_SYSPWRSAVEMODE;
         if (!bDoIt(o_SPM_b32_SYSPWRSAVEMODE))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_PARTNUMBERITEM:
      {
      if (poVisitor->bDoExpand_SPM_PartnumberItem(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_NUMBER));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STRING,spm_corefi_tclSemanticDomain::EN_PART));
      }
      else
      {
         spm_fi_tcl_SPM_PartnumberItem o_SPM_PartnumberItem;
         if (!bDoIt(o_SPM_PartnumberItem))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_PartnumberItem.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_PartnumberItem.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_SPM_PARTNUMBERLIST:
      {
      if (poVisitor->bDoExpand_SPM_PartnumberList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_PARTNUMBERITEM,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_ITEMS));
      }
      else
      {
         spm_fi_tcl_SPM_PartnumberList o_SPM_PartnumberList;
         if (!bDoIt(o_SPM_PartnumberList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_PartnumberList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_PartnumberList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_SPM_ALPHACODEITEM:
      {
      if (poVisitor->bDoExpand_SPM_AlphacodeItem(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_ALPHACODE2));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U8,spm_corefi_tclSemanticDomain::EN_ALPHACODE1));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STRING,spm_corefi_tclSemanticDomain::EN_PART));
      }
      else
      {
         spm_fi_tcl_SPM_AlphacodeItem o_SPM_AlphacodeItem;
         if (!bDoIt(o_SPM_AlphacodeItem))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_AlphacodeItem.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_AlphacodeItem.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_SPM_ALPHACODELIST:
      {
      if (poVisitor->bDoExpand_SPM_AlphacodeList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_ALPHACODEITEM,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_ITEMS));
      }
      else
      {
         spm_fi_tcl_SPM_AlphacodeList o_SPM_AlphacodeList;
         if (!bDoIt(o_SPM_AlphacodeList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_AlphacodeList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_AlphacodeList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_REDUCTION_LEVEL:
      {
         spm_fi_tcl_SPM_e32_REDUCTION_LEVEL o_SPM_e32_REDUCTION_LEVEL;
         if (!bDoIt(o_SPM_e32_REDUCTION_LEVEL))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_E32_CLEAR_LIST:
      {
         spm_fi_tcl_SPM_e32_CLEAR_LIST o_SPM_e32_CLEAR_LIST;
         if (!bDoIt(o_SPM_e32_CLEAR_LIST))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_APPIDLIST:
      {
      if (poVisitor->bDoExpand_SPM_AppIdList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U16,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_TAPPIDLIST));
      }
      else
      {
         spm_fi_tcl_SPM_AppIdList o_SPM_AppIdList;
         if (!bDoIt(o_SPM_AppIdList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_AppIdList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_AppIdList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_SPM_RESTRICTEDDLLOCK:
      {
      if (poVisitor->bDoExpand_SPM_RestrictedDlLock(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U16,spm_corefi_tclSemanticDomain::EN_U16APPIDLOCKREQUESTER));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U16,spm_corefi_tclSemanticDomain::EN_U16APPIDLOCKOWNER));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STRING,spm_corefi_tclSemanticDomain::EN_STRRESTRICTEDLOCKAREA));
      }
      else
      {
         spm_fi_tcl_SPM_RestrictedDlLock o_SPM_RestrictedDlLock;
         if (!bDoIt(o_SPM_RestrictedDlLock))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_RestrictedDlLock.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_RestrictedDlLock.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_E8_UPDATELOCKCOMMAND:
      {
         spm_fi_tcl_e8_UpdateLockCommand o_e8_UpdateLockCommand;
         if (!bDoIt(o_e8_UpdateLockCommand))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_E8_UPDATELOCKSTATE:
      {
         spm_fi_tcl_e8_UpdateLockState o_e8_UpdateLockState;
         if (!bDoIt(o_e8_UpdateLockState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_SPM_UPDATELOCKSTATE:
      {
      if (poVisitor->bDoExpand_SPM_UpdateLockState(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U16,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_LU16LOCKUSERS));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U16,spm_corefi_tclSemanticDomain::EN_U16LOCKOWNER));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_E8_UPDATELOCKSTATE,spm_corefi_tclSemanticDomain::EN_ELOCKSTATE));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STRING,spm_corefi_tclSemanticDomain::EN_STRLOCKNAME));
      }
      else
      {
         spm_fi_tcl_SPM_UpdateLockState o_SPM_UpdateLockState;
         if (!bDoIt(o_SPM_UpdateLockState))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_UpdateLockState.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_UpdateLockState.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_SPM_VOLTAGEEVENTCOUNTER:
      {
      if (poVisitor->bDoExpand_SPM_VoltageEventCounter(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_CRHIGHVOLTAGECOUNT));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_HIGHVOLTAGECOUNT));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_CRLOWVOLTAGECOUNT));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_LOWVOLTAGECOUNT));
      }
      else
      {
         spm_fi_tcl_SPM_VoltageEventCounter o_SPM_VoltageEventCounter;
         if (!bDoIt(o_SPM_VoltageEventCounter))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_VoltageEventCounter.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_VoltageEventCounter.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_SPM_VOLTAGERANGE:
      {
      if (poVisitor->bDoExpand_SPM_VoltageRange(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_OPERATIONTIME));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U16,spm_corefi_tclSemanticDomain::EN_VOLTAGEVALUE));
      }
      else
      {
         spm_fi_tcl_SPM_VoltageRange o_SPM_VoltageRange;
         if (!bDoIt(o_SPM_VoltageRange))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_VoltageRange.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_VoltageRange.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_SPM_SYSTEMSTATISTICSDATA:
      {
      if (poVisitor->bDoExpand_SPM_SystemStatisticsData(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_BOOL,spm_corefi_tclSemanticDomain::EN_STATISTICDATADISABLED));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MINVALUE));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_AVGVALUE));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_MAXVALUE));
      }
      else
      {
         spm_fi_tcl_SPM_SystemStatisticsData o_SPM_SystemStatisticsData;
         if (!bDoIt(o_SPM_SystemStatisticsData))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_SystemStatisticsData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_SystemStatisticsData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_SPM_RESETINFOSTATISTICDATA:
      {
      if (poVisitor->bDoExpand_SPM_ResetInfoStatisticData(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_U32SCCWARMSTARTCOUNT));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_U32SCCDURINGSWCOUNT));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_U32SCCDURINGPLLOSZCOUNT));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_U32SCCDURINGLPWCOUNT));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_U32SCCAPPMODECHANGECOUNT));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_U32SCCCOLDSTARTCOUNT));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_U32SCCPOWERONCOUNT));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_U32SCCHWWDTCOUNT));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_U32APUNKNOWNCOUNT));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_U32APSCCCOUNT));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_U32APPOWEROFFCOUNT));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_U32APPOWERLOSSCOUNT));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_U32APPOWERONCOUNT));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_U32APWARMSTARTCOUNT));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_U32APLCMINTERN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_U32APUSER));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_U32APOVERTEMPERATURE));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_U32APDOWNLOADERROR));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_U32APDOWNLOAD));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_U32APECURESET));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_U32APSOFTWARE));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_U32APAPPLICATIONERROR));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_E8_LCMRESETREASON,spm_corefi_tclSemanticDomain::EN_TLASTRESETREASON));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_IMEDATE,spm_corefi_tclSemanticDomain::EN_TLASTRESETDATE));
      }
      else
      {
         spm_fi_tcl_SPM_ResetInfoStatisticData o_SPM_ResetInfoStatisticData;
         if (!bDoIt(o_SPM_ResetInfoStatisticData))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_ResetInfoStatisticData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_ResetInfoStatisticData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_SPM_SWVERSIONSTATISTICDATA:
      {
      if (poVisitor->bDoExpand_SPM_SWVersionStatisticData(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_END_OF_STRUCT,spm_corefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_SYSTEMSTATISTICSDATA,spm_corefi_tclSemanticDomain::EN_TSTARTUPTIME));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_SYSTEMSTATISTICSDATA,spm_corefi_tclSemanticDomain::EN_TRAMUSAGE));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_SYSTEMSTATISTICSDATA,spm_corefi_tclSemanticDomain::EN_TCPUUSAGE));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_U32,spm_corefi_tclSemanticDomain::EN_U32SYSTEMOPERATIONTIME));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STATECHANGEELEMENT,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_TERRSTATEHISTORY05LIST));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STATECHANGEELEMENT,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_TERRSTATEHISTORY04LIST));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STATECHANGEELEMENT,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_TERRSTATEHISTORY03LIST));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STATECHANGEELEMENT,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_TERRSTATEHISTORY02LIST));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STATECHANGEELEMENT,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_TERRSTATEHISTORY01LIST));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STATECHANGEELEMENT,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_TSTATEHISTORYLIST));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SWITCHONELEMENT,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_TSWITCHONLIST));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_WAKEUPELEMENT,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_TWAKEUPHISTORYLIST));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_RESETELEMENT,spm_corefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_LIST,spm_corefi_tclSemanticDomain::EN_TRESETHISTORYLIST));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_SPM_RESETINFOSTATISTICDATA,spm_corefi_tclSemanticDomain::EN_TRESETINFO));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STRING,spm_corefi_tclSemanticDomain::EN_STRCUSTOMERVERSION));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STRING,spm_corefi_tclSemanticDomain::EN_STRBUILDVERSIONCUSTOMER));
         (tVoid) oPath.bGoDown(spm_corefi_tclKnot(spm_corefi_tclToken::EN_STRING,spm_corefi_tclSemanticDomain::EN_STRBUILDVERSION));
      }
      else
      {
         spm_fi_tcl_SPM_SWVersionStatisticData o_SPM_SWVersionStatisticData;
         if (!bDoIt(o_SPM_SWVersionStatisticData))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_SWVersionStatisticData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SPM_SWVersionStatisticData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case spm_corefi_tclToken::EN_E8_DEFSETMODE:
      {
         spm_fi_tcl_e8_DefSetMode o_e8_DefSetMode;
         if (!bDoIt(o_e8_DefSetMode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_E8_DIAGLOGDEFSETTYPE:
      {
         spm_fi_tcl_e8_DiaglogDefsetType o_e8_DiaglogDefsetType;
         if (!bDoIt(o_e8_DiaglogDefsetType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case spm_corefi_tclToken::EN_UNKNOWN:
      case spm_corefi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

