/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef SPEAUD_MAINFITYPES_HEADER
#define SPEAUD_MAINFITYPES_HEADER


class speaud_mainfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for speaud_main_fi message types

fi_tclMessageBase* speaud_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class speaud_mainfi_tclMsgBaseMessage : public speaud_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   speaud_mainfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class speaud_mainfi_tclMsgInternMsgUpReg : public speaud_mainfi_tclMsgBaseMessage
{
public:

   speaud_mainfi_tclMsgInternMsgUpReg();

   virtual ~speaud_mainfi_tclMsgInternMsgUpReg();

   inline tBool operator==(const speaud_mainfi_tclMsgInternMsgUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class speaud_mainfi_tclMsgInternMsgRelUpReg : public speaud_mainfi_tclMsgBaseMessage
{
public:

   speaud_mainfi_tclMsgInternMsgRelUpReg();

   virtual ~speaud_mainfi_tclMsgInternMsgRelUpReg();

   inline tBool operator==(const speaud_mainfi_tclMsgInternMsgRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class speaud_mainfi_tclMsgInternMsgStatus : public speaud_mainfi_tclMsgBaseMessage
{
public:

   speaud_mainfi_tclMsgInternMsgStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   speaud_mainfi_tclMsgInternMsgStatus& operator=(const speaud_mainfi_tclMsgInternMsgStatus& coRef);
   speaud_mainfi_tclMsgInternMsgStatus(const speaud_mainfi_tclMsgInternMsgStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   speaud_fi_tcl_e8_SPEAUD_TEST eTest;
   virtual ~speaud_mainfi_tclMsgInternMsgStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const speaud_mainfi_tclMsgInternMsgStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
