/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define SPEAUD_FI_S_IMPORT_INTERFACE_SPEAUD_MAINFI_TYPES
#define SPEAUD_FI_S_IMPORT_INTERFACE_SPEAUD_MAINFI_FUNCTIONIDS
#define SPEAUD_FI_S_IMPORT_INTERFACE_SPEAUD_MAINFI_SERVICEINFO
#include "speaud_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for speaud_main_fi message types

fi_tclMessageBase* speaud_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case speaud_mainfi_tclToken::EN_MSG_INTERNMSGUPREG:
         return OSAL_NEW speaud_mainfi_tclMsgInternMsgUpReg;

      case speaud_mainfi_tclToken::EN_MSG_INTERNMSGRELUPREG:
         return OSAL_NEW speaud_mainfi_tclMsgInternMsgRelUpReg;

      case speaud_mainfi_tclToken::EN_MSG_INTERNMSGSTATUS:
         return OSAL_NEW speaud_mainfi_tclMsgInternMsgStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all speaud_mainfifi messages

// common functions

tU16 speaud_mainfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return SPEAUD_MAINFI_C_U16_SERVICE_ID;
}

tU16 speaud_mainfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 speaud_mainfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& speaud_mainfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& speaud_mainfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 speaud_mainfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& speaud_mainfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& speaud_mainfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

speaud_mainfi_tclMsgInternMsgUpReg::speaud_mainfi_tclMsgInternMsgUpReg()
 {}

tS32 speaud_mainfi_tclMsgInternMsgUpReg::s32GetTypeId() const
{
   return (tS32) speaud_mainfi_tclToken::EN_MSG_INTERNMSGUPREG;
}


speaud_mainfi_tclMsgInternMsgUpReg::~speaud_mainfi_tclMsgInternMsgUpReg()
{}

//=============================================================================

speaud_mainfi_tclMsgInternMsgRelUpReg::speaud_mainfi_tclMsgInternMsgRelUpReg()
 {}

tS32 speaud_mainfi_tclMsgInternMsgRelUpReg::s32GetTypeId() const
{
   return (tS32) speaud_mainfi_tclToken::EN_MSG_INTERNMSGRELUPREG;
}


speaud_mainfi_tclMsgInternMsgRelUpReg::~speaud_mainfi_tclMsgInternMsgRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
speaud_mainfi_tclMsgInternMsgStatus::speaud_mainfi_tclMsgInternMsgStatus(const speaud_mainfi_tclMsgInternMsgStatus& coRef)
   : speaud_mainfi_tclMsgBaseMessage(coRef)
{
   eTest = coRef.eTest;
}
speaud_mainfi_tclMsgInternMsgStatus& speaud_mainfi_tclMsgInternMsgStatus::operator=(const speaud_mainfi_tclMsgInternMsgStatus& coRef)
{
   if (this == &coRef) return *this;
   eTest = coRef.eTest;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

speaud_mainfi_tclMsgInternMsgStatus::speaud_mainfi_tclMsgInternMsgStatus()
:eTest()
 {}

tS32 speaud_mainfi_tclMsgInternMsgStatus::s32GetTypeId() const
{
   return (tS32) speaud_mainfi_tclToken::EN_MSG_INTERNMSGSTATUS;
}


speaud_mainfi_tclMsgInternMsgStatus::~speaud_mainfi_tclMsgInternMsgStatus()
{}

tU32 speaud_mainfi_tclMsgInternMsgStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& speaud_mainfi_tclMsgInternMsgStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eTest);
   return oIn;
}

fi_tclOutContext& speaud_mainfi_tclMsgInternMsgStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eTest);
   return oOut;
}

tBool speaud_mainfi_tclMsgInternMsgStatus::operator==(const speaud_mainfi_tclMsgInternMsgStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eTest == roRef.eTest);
   return bResult;
}

