#ifndef SENSOR_PVFILANGUAGE_HEADER
#define SENSOR_PVFILANGUAGE_HEADER

class sensor_pvfi_tclInContext;
class sensor_pvfi_tclOutContext;
class sensor_pvfi_tclVisitorBase;

class MY_DECL sensor_pvfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  sensor_pvfi_tclDescription(fi_tclInContext* poIn, sensor_pvfi_tclVisitorBase* poVisit);
  sensor_pvfi_tclDescription(fi_tclOutContext* poOut, sensor_pvfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(sensor_pvfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(sensor_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ sensor_pvfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--Lesen oder Schreiben?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  sensor_pvfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<sensor_pvfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<sensor_pvfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline sensor_pvfi_tclDescription::sensor_pvfi_tclDescription(fi_tclInContext* poIn, sensor_pvfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline sensor_pvfi_tclDescription::sensor_pvfi_tclDescription(fi_tclOutContext* poOut, sensor_pvfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

