#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_PVFI_STDVISITORS
#include "sensor_fi_if.h"

tBool sensor_pvfi_tclDescription::bInitMessage(sensor_pvfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case sensor_pvfi_tclToken::EN_LAST_TOKEN:
   case sensor_pvfi_tclToken::EN_LIST:
   case sensor_pvfi_tclToken::EN_END_OF_STRUCT:
   case sensor_pvfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case sensor_pvfi_tclToken::EN_MSG_POSITIONSTATUS:
   {
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_E8_TIMEZONE_SOURCE,sensor_pvfi_tclSemanticDomain::EN_MSG_TIMEZONESOURCE)) && bResult;
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_PV_TIMEZONE,sensor_pvfi_tclSemanticDomain::EN_MSG_TIMEZONE)) && bResult;
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_E8_COUNTRYCODE_SOURCE,sensor_pvfi_tclSemanticDomain::EN_MSG_COUNTRYCODESOURCE)) && bResult;
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_E16_PV_ISOCOUNTRYCODE,sensor_pvfi_tclSemanticDomain::EN_MSG_COUNTRYCODE)) && bResult;
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_E8_POSITION_SOURCE,sensor_pvfi_tclSemanticDomain::EN_MSG_POSSOURCE)) && bResult;
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_F64,sensor_pvfi_tclSemanticDomain::EN_MSG_POSLONGITUDE)) && bResult;
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_F64,sensor_pvfi_tclSemanticDomain::EN_MSG_POSLATITUDE)) && bResult;
   } break;
   case sensor_pvfi_tclToken::EN_MSG_VELOCITYSTATUS:
   {
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_E8_VELOCITY_SOURCE,sensor_pvfi_tclSemanticDomain::EN_MSG_VELOCITIYSOURCE)) && bResult;
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_U16,sensor_pvfi_tclSemanticDomain::EN_MSG_VELOCITYVALUE)) && bResult;
   } break;
   case sensor_pvfi_tclToken::EN_MSG_DEADRECKONING_INFOSTATUS:
   {
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_B16_DEADRECKONING_INFO_VALIDITY,sensor_pvfi_tclSemanticDomain::EN_MSG_DRINFOVALIDITY)) && bResult;
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_E8_DEADRECKONING_INFO_SOURCE,sensor_pvfi_tclSemanticDomain::EN_MSG_DRINFOSOURCE)) && bResult;
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_F32,sensor_pvfi_tclSemanticDomain::EN_MSG_DRACCELERATIONZ)) && bResult;
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_F32,sensor_pvfi_tclSemanticDomain::EN_MSG_DRACCELERATIONY)) && bResult;
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_F32,sensor_pvfi_tclSemanticDomain::EN_MSG_DRACCELERATIONX)) && bResult;
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_F32,sensor_pvfi_tclSemanticDomain::EN_MSG_DRTURNRATEZ)) && bResult;
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_F32,sensor_pvfi_tclSemanticDomain::EN_MSG_DRTURNRATEY)) && bResult;
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_F32,sensor_pvfi_tclSemanticDomain::EN_MSG_DRTURNRATEX)) && bResult;
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_F32,sensor_pvfi_tclSemanticDomain::EN_MSG_DRALTITUDE)) && bResult;
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_F32,sensor_pvfi_tclSemanticDomain::EN_MSG_DRSPEED)) && bResult;
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_F32,sensor_pvfi_tclSemanticDomain::EN_MSG_DRHEADING)) && bResult;
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_F64,sensor_pvfi_tclSemanticDomain::EN_MSG_DRLONGITUDE)) && bResult;
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_F64,sensor_pvfi_tclSemanticDomain::EN_MSG_DRLATITUDE)) && bResult;
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_U32,sensor_pvfi_tclSemanticDomain::EN_MSG_DRSYSTEMTIME)) && bResult;
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_U64,sensor_pvfi_tclSemanticDomain::EN_MSG_DRTIMESTAMP)) && bResult;
   } break;
   case sensor_pvfi_tclToken::EN_MSG_MOUNTINGSTATUS:
   {
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_E8_MOUNTING_SOURCE,sensor_pvfi_tclSemanticDomain::EN_MSG_SOURCE)) && bResult;
      bResult = oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_MOUNT_ANGLES,sensor_pvfi_tclSemanticDomain::EN_MSG_ANGLES)) && bResult;
   } break;
   case sensor_pvfi_tclToken::EN_MSG_POSITIONGET:
   case sensor_pvfi_tclToken::EN_MSG_POSITIONUPREG:
   case sensor_pvfi_tclToken::EN_MSG_POSITIONRELUPREG:
   case sensor_pvfi_tclToken::EN_MSG_VELOCITYGET:
   case sensor_pvfi_tclToken::EN_MSG_VELOCITYUPREG:
   case sensor_pvfi_tclToken::EN_MSG_VELOCITYRELUPREG:
   case sensor_pvfi_tclToken::EN_MSG_DEADRECKONING_INFOGET:
   case sensor_pvfi_tclToken::EN_MSG_DEADRECKONING_INFOUPREG:
   case sensor_pvfi_tclToken::EN_MSG_DEADRECKONING_INFORELUPREG:
   case sensor_pvfi_tclToken::EN_MSG_MOUNTINGGET:
   case sensor_pvfi_tclToken::EN_MSG_MOUNTINGUPREG:
   case sensor_pvfi_tclToken::EN_MSG_MOUNTINGRELUPREG:
   case sensor_pvfi_tclToken::EN_BINCONTAINER:
   case sensor_pvfi_tclToken::EN_E8_VELOCITY_SOURCE:
   case sensor_pvfi_tclToken::EN_E8_POSITION_SOURCE:
   case sensor_pvfi_tclToken::EN_E8_COUNTRYCODE_SOURCE:
   case sensor_pvfi_tclToken::EN_E8_TIMEZONE_SOURCE:
   case sensor_pvfi_tclToken::EN_E8_DEADRECKONING_INFO_SOURCE:
   case sensor_pvfi_tclToken::EN_B16_DEADRECKONING_INFO_VALIDITY:
   case sensor_pvfi_tclToken::EN_S32_PV_SECOND:
   case sensor_pvfi_tclToken::EN_E8_PV_DST_STATE:
   case sensor_pvfi_tclToken::EN_PV_TIMEZONE:
   case sensor_pvfi_tclToken::EN_E16_PV_ISOCOUNTRYCODE:
   case sensor_pvfi_tclToken::EN_MOUNT_ANGLES:
   case sensor_pvfi_tclToken::EN_E8_MOUNTING_SOURCE:
   case sensor_pvfi_tclToken::EN_U8:   
   case sensor_pvfi_tclToken::EN_S8:   
   case sensor_pvfi_tclToken::EN_U16:   
   case sensor_pvfi_tclToken::EN_S16:   
   case sensor_pvfi_tclToken::EN_U24:   
   case sensor_pvfi_tclToken::EN_S24:   
   case sensor_pvfi_tclToken::EN_U32:   
   case sensor_pvfi_tclToken::EN_S32:   
   case sensor_pvfi_tclToken::EN_U64:   
   case sensor_pvfi_tclToken::EN_S64:   
   case sensor_pvfi_tclToken::EN_F32:   
   case sensor_pvfi_tclToken::EN_F64:   
   case sensor_pvfi_tclToken::EN_BOOL:   
   case sensor_pvfi_tclToken::EN_STRING:   
   case sensor_pvfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(sensor_pvfi_tclKnot(enMsgToken,sensor_pvfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool sensor_pvfi_tclDescription::bDoIt(sensor_fi_tclVisitableTypeBase& oTypeBase)
{
   // --Lesen oder Schreiben?
   if (enType==EN_PARSING)
   {
     // --Erst einlesen, dann Besucher bergeben.
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --Erst Besucher bergeben, dann ausgeben
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool sensor_pvfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      sensor_pvfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      sensor_pvfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      sensor_pvfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == sensor_pvfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(sensor_pvfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(sensor_pvfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(sensor_pvfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case sensor_pvfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == sensor_pvfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case sensor_pvfi_tclToken::EN_LIST: 
      {
         sensor_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            sensor_pvfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(sensor_pvfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            sensor_pvfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(sensor_pvfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case sensor_pvfi_tclToken::EN_U8: 
      {
         sensor_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case sensor_pvfi_tclToken::EN_U16: 
      {
         sensor_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_pvfi_tclToken::EN_U24: 
      {
         sensor_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_pvfi_tclToken::EN_U32: 
      {
         sensor_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_pvfi_tclToken::EN_U64: 
      {
         sensor_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_pvfi_tclToken::EN_S8: 
      {
         sensor_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_pvfi_tclToken::EN_S16: 
      {
         sensor_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_pvfi_tclToken::EN_S24: 
      {
         sensor_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_pvfi_tclToken::EN_S32: 
      {
         sensor_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_pvfi_tclToken::EN_S64: 
      {
         sensor_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_pvfi_tclToken::EN_F32: 
      {
         sensor_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_pvfi_tclToken::EN_F64: 
      {
         sensor_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_pvfi_tclToken::EN_BOOL: 
      {
         sensor_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_pvfi_tclToken::EN_STRING: 
      {
         sensor_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_pvfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         sensor_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case sensor_pvfi_tclToken::EN_MSG_POSITIONGET:
      case sensor_pvfi_tclToken::EN_MSG_POSITIONUPREG:
      case sensor_pvfi_tclToken::EN_MSG_POSITIONRELUPREG:
      case sensor_pvfi_tclToken::EN_MSG_POSITIONSTATUS:
      case sensor_pvfi_tclToken::EN_MSG_VELOCITYGET:
      case sensor_pvfi_tclToken::EN_MSG_VELOCITYUPREG:
      case sensor_pvfi_tclToken::EN_MSG_VELOCITYRELUPREG:
      case sensor_pvfi_tclToken::EN_MSG_VELOCITYSTATUS:
      case sensor_pvfi_tclToken::EN_MSG_DEADRECKONING_INFOGET:
      case sensor_pvfi_tclToken::EN_MSG_DEADRECKONING_INFOUPREG:
      case sensor_pvfi_tclToken::EN_MSG_DEADRECKONING_INFORELUPREG:
      case sensor_pvfi_tclToken::EN_MSG_DEADRECKONING_INFOSTATUS:
      case sensor_pvfi_tclToken::EN_MSG_MOUNTINGGET:
      case sensor_pvfi_tclToken::EN_MSG_MOUNTINGUPREG:
      case sensor_pvfi_tclToken::EN_MSG_MOUNTINGRELUPREG:
      case sensor_pvfi_tclToken::EN_MSG_MOUNTINGSTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case sensor_pvfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_END_OF_STRUCT,sensor_pvfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_U8,sensor_pvfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_LIST,sensor_pvfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         sensor_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sensor_pvfi_tclToken::EN_E8_VELOCITY_SOURCE:
      {
         sensor_fi_tcl_e8_velocity_source o_e8_velocity_source;
         if (!bDoIt(o_e8_velocity_source))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_pvfi_tclToken::EN_E8_POSITION_SOURCE:
      {
         sensor_fi_tcl_e8_position_source o_e8_position_source;
         if (!bDoIt(o_e8_position_source))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_pvfi_tclToken::EN_E8_COUNTRYCODE_SOURCE:
      {
         sensor_fi_tcl_e8_countrycode_source o_e8_countrycode_source;
         if (!bDoIt(o_e8_countrycode_source))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_pvfi_tclToken::EN_E8_TIMEZONE_SOURCE:
      {
         sensor_fi_tcl_e8_timezone_source o_e8_timezone_source;
         if (!bDoIt(o_e8_timezone_source))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_pvfi_tclToken::EN_E8_DEADRECKONING_INFO_SOURCE:
      {
         sensor_fi_tcl_e8_deadreckoning_info_source o_e8_deadreckoning_info_source;
         if (!bDoIt(o_e8_deadreckoning_info_source))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_pvfi_tclToken::EN_B16_DEADRECKONING_INFO_VALIDITY:
      {
         sensor_fi_tcl_b16_deadreckoning_info_validity o_b16_deadreckoning_info_validity;
         if (!bDoIt(o_b16_deadreckoning_info_validity))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_pvfi_tclToken::EN_S32_PV_SECOND:
      {
         sensor_fi_tcl_s32_pv_Second o_s32_pv_Second;
         if (!bDoIt(o_s32_pv_Second))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_pvfi_tclToken::EN_E8_PV_DST_STATE:
      {
         sensor_fi_tcl_e8_pv_DST_State o_e8_pv_DST_State;
         if (!bDoIt(o_e8_pv_DST_State))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_pvfi_tclToken::EN_PV_TIMEZONE:
      {
      if (poVisitor->bDoExpand_pv_TimeZone(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_END_OF_STRUCT,sensor_pvfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_S32_PV_SECOND,sensor_pvfi_tclSemanticDomain::EN_DSTDIFFERENCE));
         (tVoid) oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_E8_PV_DST_STATE,sensor_pvfi_tclSemanticDomain::EN_DST_STATE));
         (tVoid) oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_S32_PV_SECOND,sensor_pvfi_tclSemanticDomain::EN_TIMEZONEDIFFERENCE));
      }
      else
      {
         sensor_fi_tcl_pv_TimeZone o_pv_TimeZone;
         if (!bDoIt(o_pv_TimeZone))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_pv_TimeZone.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_pv_TimeZone.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sensor_pvfi_tclToken::EN_E16_PV_ISOCOUNTRYCODE:
      {
         sensor_fi_tcl_e16_pv_ISOCountryCode o_e16_pv_ISOCountryCode;
         if (!bDoIt(o_e16_pv_ISOCountryCode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_pvfi_tclToken::EN_MOUNT_ANGLES:
      {
      if (poVisitor->bDoExpand_mount_angles(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_END_OF_STRUCT,sensor_pvfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_U8,sensor_pvfi_tclSemanticDomain::EN_ANGTZ));
         (tVoid) oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_U8,sensor_pvfi_tclSemanticDomain::EN_ANGTY));
         (tVoid) oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_U8,sensor_pvfi_tclSemanticDomain::EN_ANGTX));
         (tVoid) oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_U8,sensor_pvfi_tclSemanticDomain::EN_ANGSZ));
         (tVoid) oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_U8,sensor_pvfi_tclSemanticDomain::EN_ANGSY));
         (tVoid) oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_U8,sensor_pvfi_tclSemanticDomain::EN_ANGSX));
         (tVoid) oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_U8,sensor_pvfi_tclSemanticDomain::EN_ANGRZ));
         (tVoid) oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_U8,sensor_pvfi_tclSemanticDomain::EN_ANGRY));
         (tVoid) oPath.bGoDown(sensor_pvfi_tclKnot(sensor_pvfi_tclToken::EN_U8,sensor_pvfi_tclSemanticDomain::EN_ANGRX));
      }
      else
      {
         sensor_fi_tcl_mount_angles o_mount_angles;
         if (!bDoIt(o_mount_angles))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_mount_angles.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_mount_angles.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sensor_pvfi_tclToken::EN_E8_MOUNTING_SOURCE:
      {
         sensor_fi_tcl_e8_mounting_source o_e8_mounting_source;
         if (!bDoIt(o_e8_mounting_source))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sensor_pvfi_tclToken::EN_UNKNOWN:
      case sensor_pvfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

