/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef SENSOR_LOCATIONFITYPES_HEADER
#define SENSOR_LOCATIONFITYPES_HEADER


class sensor_locationfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for sensor_location_fi message types

fi_tclMessageBase* sensor_locationfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class sensor_locationfi_tclMsgBaseMessage : public sensor_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   sensor_locationfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class sensor_locationfi_tclMsgSavePersistentMethodStart : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgSavePersistentMethodStart();

   virtual ~sensor_locationfi_tclMsgSavePersistentMethodStart();

   inline tBool operator==(const sensor_locationfi_tclMsgSavePersistentMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgSavePersistentMethodResult : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgSavePersistentMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_locationfi_tclMsgSavePersistentMethodResult& operator=(const sensor_locationfi_tclMsgSavePersistentMethodResult& coRef);
   sensor_locationfi_tclMsgSavePersistentMethodResult(const sensor_locationfi_tclMsgSavePersistentMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSuccess;
   virtual ~sensor_locationfi_tclMsgSavePersistentMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_locationfi_tclMsgSavePersistentMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgUpdateDiagLogMethodStart : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgUpdateDiagLogMethodStart();

   virtual ~sensor_locationfi_tclMsgUpdateDiagLogMethodStart();

   inline tBool operator==(const sensor_locationfi_tclMsgUpdateDiagLogMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgUpdateDiagLogMethodResult : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgUpdateDiagLogMethodResult();

   virtual ~sensor_locationfi_tclMsgUpdateDiagLogMethodResult();

   inline tBool operator==(const sensor_locationfi_tclMsgUpdateDiagLogMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgFactorySettingsMethodStart : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgFactorySettingsMethodStart();

   virtual ~sensor_locationfi_tclMsgFactorySettingsMethodStart();

   inline tBool operator==(const sensor_locationfi_tclMsgFactorySettingsMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgFactorySettingsMethodResult : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgFactorySettingsMethodResult();

   virtual ~sensor_locationfi_tclMsgFactorySettingsMethodResult();

   inline tBool operator==(const sensor_locationfi_tclMsgFactorySettingsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart& operator=(const sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart& coRef);
   sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart(const sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sensor_fi_tcl_e8_DefSetGroups DefSetGroup;
   sensor_fi_tcl_e8_DefSetMode DefSetMode;
   virtual ~sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult& operator=(const sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult& coRef);
   sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult(const sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sensor_fi_tcl_e8_DefSetGroups DefSetGroup;
   sensor_fi_tcl_e8_DefSetMode DefSetMode;
   tBool DefSetStateSuccessful;
   virtual ~sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGyro3dGetHwInfoMethodStart : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGyro3dGetHwInfoMethodStart();

   virtual ~sensor_locationfi_tclMsgGyro3dGetHwInfoMethodStart();

   inline tBool operator==(const sensor_locationfi_tclMsgGyro3dGetHwInfoMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult& operator=(const sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult& coRef);
   sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult(const sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sensor_fi_tcl_3dGyroHwInfo Gyro3dHwInfo;
   virtual ~sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgAcc3dGetHwInfoMethodStart : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgAcc3dGetHwInfoMethodStart();

   virtual ~sensor_locationfi_tclMsgAcc3dGetHwInfoMethodStart();

   inline tBool operator==(const sensor_locationfi_tclMsgAcc3dGetHwInfoMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult& operator=(const sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult& coRef);
   sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult(const sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sensor_fi_tcl_3dAccHwInfo Acc3dHwInfo;
   virtual ~sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGyroSelfTestMethodStart : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGyroSelfTestMethodStart();

   virtual ~sensor_locationfi_tclMsgGyroSelfTestMethodStart();

   inline tBool operator==(const sensor_locationfi_tclMsgGyroSelfTestMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGyroSelfTestMethodResult : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGyroSelfTestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_locationfi_tclMsgGyroSelfTestMethodResult& operator=(const sensor_locationfi_tclMsgGyroSelfTestMethodResult& coRef);
   sensor_locationfi_tclMsgGyroSelfTestMethodResult(const sensor_locationfi_tclMsgGyroSelfTestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSuccess;
   virtual ~sensor_locationfi_tclMsgGyroSelfTestMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_locationfi_tclMsgGyroSelfTestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgAccSelfTestMethodStart : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgAccSelfTestMethodStart();

   virtual ~sensor_locationfi_tclMsgAccSelfTestMethodStart();

   inline tBool operator==(const sensor_locationfi_tclMsgAccSelfTestMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgAccSelfTestMethodResult : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgAccSelfTestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_locationfi_tclMsgAccSelfTestMethodResult& operator=(const sensor_locationfi_tclMsgAccSelfTestMethodResult& coRef);
   sensor_locationfi_tclMsgAccSelfTestMethodResult(const sensor_locationfi_tclMsgAccSelfTestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSuccess;
   virtual ~sensor_locationfi_tclMsgAccSelfTestMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_locationfi_tclMsgAccSelfTestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgOdometerData_UpdateGet : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgOdometerData_UpdateGet();

   virtual ~sensor_locationfi_tclMsgOdometerData_UpdateGet();

   inline tBool operator==(const sensor_locationfi_tclMsgOdometerData_UpdateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgOdometerData_UpdateUpReg : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgOdometerData_UpdateUpReg();

   virtual ~sensor_locationfi_tclMsgOdometerData_UpdateUpReg();

   inline tBool operator==(const sensor_locationfi_tclMsgOdometerData_UpdateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgOdometerData_UpdateRelUpReg : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgOdometerData_UpdateRelUpReg();

   virtual ~sensor_locationfi_tclMsgOdometerData_UpdateRelUpReg();

   inline tBool operator==(const sensor_locationfi_tclMsgOdometerData_UpdateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgOdometerData_UpdateStatus : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgOdometerData_UpdateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_locationfi_tclMsgOdometerData_UpdateStatus& operator=(const sensor_locationfi_tclMsgOdometerData_UpdateStatus& coRef);
   sensor_locationfi_tclMsgOdometerData_UpdateStatus(const sensor_locationfi_tclMsgOdometerData_UpdateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sensor_fi_tcl_OdometerData, std::allocator<sensor_fi_tcl_OdometerData> > OdometerData;
   tBool FirstOdomValueIsInitial;
   virtual ~sensor_locationfi_tclMsgOdometerData_UpdateStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_locationfi_tclMsgOdometerData_UpdateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgAbsDataGet : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgAbsDataGet();

   virtual ~sensor_locationfi_tclMsgAbsDataGet();

   inline tBool operator==(const sensor_locationfi_tclMsgAbsDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgAbsDataUpReg : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgAbsDataUpReg();

   virtual ~sensor_locationfi_tclMsgAbsDataUpReg();

   inline tBool operator==(const sensor_locationfi_tclMsgAbsDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgAbsDataRelUpReg : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgAbsDataRelUpReg();

   virtual ~sensor_locationfi_tclMsgAbsDataRelUpReg();

   inline tBool operator==(const sensor_locationfi_tclMsgAbsDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgAbsDataStatus : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgAbsDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_locationfi_tclMsgAbsDataStatus& operator=(const sensor_locationfi_tclMsgAbsDataStatus& coRef);
   sensor_locationfi_tclMsgAbsDataStatus(const sensor_locationfi_tclMsgAbsDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sensor_fi_tcl_AbsData, std::allocator<sensor_fi_tcl_AbsData> > AbsData;
   virtual ~sensor_locationfi_tclMsgAbsDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_locationfi_tclMsgAbsDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGyro3dData_UpdateGet : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGyro3dData_UpdateGet();

   virtual ~sensor_locationfi_tclMsgGyro3dData_UpdateGet();

   inline tBool operator==(const sensor_locationfi_tclMsgGyro3dData_UpdateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGyro3dData_UpdateUpReg : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGyro3dData_UpdateUpReg();

   virtual ~sensor_locationfi_tclMsgGyro3dData_UpdateUpReg();

   inline tBool operator==(const sensor_locationfi_tclMsgGyro3dData_UpdateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGyro3dData_UpdateRelUpReg : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGyro3dData_UpdateRelUpReg();

   virtual ~sensor_locationfi_tclMsgGyro3dData_UpdateRelUpReg();

   inline tBool operator==(const sensor_locationfi_tclMsgGyro3dData_UpdateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGyro3dData_UpdateStatus : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGyro3dData_UpdateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_locationfi_tclMsgGyro3dData_UpdateStatus& operator=(const sensor_locationfi_tclMsgGyro3dData_UpdateStatus& coRef);
   sensor_locationfi_tclMsgGyro3dData_UpdateStatus(const sensor_locationfi_tclMsgGyro3dData_UpdateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sensor_fi_tcl_3dGyroData, std::allocator<sensor_fi_tcl_3dGyroData> > Gyro3dData;
   virtual ~sensor_locationfi_tclMsgGyro3dData_UpdateStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_locationfi_tclMsgGyro3dData_UpdateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgAcc3dData_UpdateGet : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgAcc3dData_UpdateGet();

   virtual ~sensor_locationfi_tclMsgAcc3dData_UpdateGet();

   inline tBool operator==(const sensor_locationfi_tclMsgAcc3dData_UpdateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgAcc3dData_UpdateUpReg : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgAcc3dData_UpdateUpReg();

   virtual ~sensor_locationfi_tclMsgAcc3dData_UpdateUpReg();

   inline tBool operator==(const sensor_locationfi_tclMsgAcc3dData_UpdateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgAcc3dData_UpdateRelUpReg : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgAcc3dData_UpdateRelUpReg();

   virtual ~sensor_locationfi_tclMsgAcc3dData_UpdateRelUpReg();

   inline tBool operator==(const sensor_locationfi_tclMsgAcc3dData_UpdateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgAcc3dData_UpdateStatus : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgAcc3dData_UpdateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_locationfi_tclMsgAcc3dData_UpdateStatus& operator=(const sensor_locationfi_tclMsgAcc3dData_UpdateStatus& coRef);
   sensor_locationfi_tclMsgAcc3dData_UpdateStatus(const sensor_locationfi_tclMsgAcc3dData_UpdateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sensor_fi_tcl_3dAccData, std::allocator<sensor_fi_tcl_3dAccData> > Acc3dData;
   virtual ~sensor_locationfi_tclMsgAcc3dData_UpdateStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_locationfi_tclMsgAcc3dData_UpdateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGyroTemperatureGet : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGyroTemperatureGet();

   virtual ~sensor_locationfi_tclMsgGyroTemperatureGet();

   inline tBool operator==(const sensor_locationfi_tclMsgGyroTemperatureGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGyroTemperatureUpReg : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGyroTemperatureUpReg();

   virtual ~sensor_locationfi_tclMsgGyroTemperatureUpReg();

   inline tBool operator==(const sensor_locationfi_tclMsgGyroTemperatureUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGyroTemperatureRelUpReg : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGyroTemperatureRelUpReg();

   virtual ~sensor_locationfi_tclMsgGyroTemperatureRelUpReg();

   inline tBool operator==(const sensor_locationfi_tclMsgGyroTemperatureRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGyroTemperatureStatus : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGyroTemperatureStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_locationfi_tclMsgGyroTemperatureStatus& operator=(const sensor_locationfi_tclMsgGyroTemperatureStatus& coRef);
   sensor_locationfi_tclMsgGyroTemperatureStatus(const sensor_locationfi_tclMsgGyroTemperatureStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tF32 GyroTemperature;
   virtual ~sensor_locationfi_tclMsgGyroTemperatureStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_locationfi_tclMsgGyroTemperatureStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGnssSatSystemGet : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGnssSatSystemGet();

   virtual ~sensor_locationfi_tclMsgGnssSatSystemGet();

   inline tBool operator==(const sensor_locationfi_tclMsgGnssSatSystemGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGnssSatSystemSet : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGnssSatSystemSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_locationfi_tclMsgGnssSatSystemSet& operator=(const sensor_locationfi_tclMsgGnssSatSystemSet& coRef);
   sensor_locationfi_tclMsgGnssSatSystemSet(const sensor_locationfi_tclMsgGnssSatSystemSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sensor_fi_tcl_b8_GnssSatSys TargetGnssSatSys;
   virtual ~sensor_locationfi_tclMsgGnssSatSystemSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_locationfi_tclMsgGnssSatSystemSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGnssSatSystemStatus : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGnssSatSystemStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_locationfi_tclMsgGnssSatSystemStatus& operator=(const sensor_locationfi_tclMsgGnssSatSystemStatus& coRef);
   sensor_locationfi_tclMsgGnssSatSystemStatus(const sensor_locationfi_tclMsgGnssSatSystemStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sensor_fi_tcl_b8_GnssSatSys ActualGnssSatSys;
   virtual ~sensor_locationfi_tclMsgGnssSatSystemStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_locationfi_tclMsgGnssSatSystemStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGnssWnEpochGet : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGnssWnEpochGet();

   virtual ~sensor_locationfi_tclMsgGnssWnEpochGet();

   inline tBool operator==(const sensor_locationfi_tclMsgGnssWnEpochGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGnssWnEpochSet : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGnssWnEpochSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_locationfi_tclMsgGnssWnEpochSet& operator=(const sensor_locationfi_tclMsgGnssWnEpochSet& coRef);
   sensor_locationfi_tclMsgGnssWnEpochSet(const sensor_locationfi_tclMsgGnssWnEpochSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sensor_fi_tcl_TimeDate TargetWnDate;
   virtual ~sensor_locationfi_tclMsgGnssWnEpochSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_locationfi_tclMsgGnssWnEpochSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGnssWnEpochStatus : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGnssWnEpochStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_locationfi_tclMsgGnssWnEpochStatus& operator=(const sensor_locationfi_tclMsgGnssWnEpochStatus& coRef);
   sensor_locationfi_tclMsgGnssWnEpochStatus(const sensor_locationfi_tclMsgGnssWnEpochStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sensor_fi_tcl_TimeDate ActualWnDate;
   virtual ~sensor_locationfi_tclMsgGnssWnEpochStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_locationfi_tclMsgGnssWnEpochStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGnssConfigDataGet : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGnssConfigDataGet();

   virtual ~sensor_locationfi_tclMsgGnssConfigDataGet();

   inline tBool operator==(const sensor_locationfi_tclMsgGnssConfigDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGnssConfigDataUpReg : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGnssConfigDataUpReg();

   virtual ~sensor_locationfi_tclMsgGnssConfigDataUpReg();

   inline tBool operator==(const sensor_locationfi_tclMsgGnssConfigDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGnssConfigDataRelUpReg : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGnssConfigDataRelUpReg();

   virtual ~sensor_locationfi_tclMsgGnssConfigDataRelUpReg();

   inline tBool operator==(const sensor_locationfi_tclMsgGnssConfigDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGnssConfigDataStatus : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGnssConfigDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_locationfi_tclMsgGnssConfigDataStatus& operator=(const sensor_locationfi_tclMsgGnssConfigDataStatus& coRef);
   sensor_locationfi_tclMsgGnssConfigDataStatus(const sensor_locationfi_tclMsgGnssConfigDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sensor_fi_tcl_GnssConfigData GnssConfigData;
   virtual ~sensor_locationfi_tclMsgGnssConfigDataStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_locationfi_tclMsgGnssConfigDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGnssDataGet : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGnssDataGet();

   virtual ~sensor_locationfi_tclMsgGnssDataGet();

   inline tBool operator==(const sensor_locationfi_tclMsgGnssDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGnssDataUpReg : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGnssDataUpReg();

   virtual ~sensor_locationfi_tclMsgGnssDataUpReg();

   inline tBool operator==(const sensor_locationfi_tclMsgGnssDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGnssDataRelUpReg : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGnssDataRelUpReg();

   virtual ~sensor_locationfi_tclMsgGnssDataRelUpReg();

   inline tBool operator==(const sensor_locationfi_tclMsgGnssDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgGnssDataStatus : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgGnssDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_locationfi_tclMsgGnssDataStatus& operator=(const sensor_locationfi_tclMsgGnssDataStatus& coRef);
   sensor_locationfi_tclMsgGnssDataStatus(const sensor_locationfi_tclMsgGnssDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sensor_fi_tcl_GnssData GnssData;
   virtual ~sensor_locationfi_tclMsgGnssDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_locationfi_tclMsgGnssDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgAllSensorDataUpReg : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgAllSensorDataUpReg();

   virtual ~sensor_locationfi_tclMsgAllSensorDataUpReg();

   inline tBool operator==(const sensor_locationfi_tclMsgAllSensorDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgAllSensorDataRelUpReg : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgAllSensorDataRelUpReg();

   virtual ~sensor_locationfi_tclMsgAllSensorDataRelUpReg();

   inline tBool operator==(const sensor_locationfi_tclMsgAllSensorDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgAllSensorDataStatus : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgAllSensorDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_locationfi_tclMsgAllSensorDataStatus& operator=(const sensor_locationfi_tclMsgAllSensorDataStatus& coRef);
   sensor_locationfi_tclMsgAllSensorDataStatus(const sensor_locationfi_tclMsgAllSensorDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sensor_fi_tcl_AllSensorData SensorDataBlock;
   virtual ~sensor_locationfi_tclMsgAllSensorDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_locationfi_tclMsgAllSensorDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgVdsVersionInfoGet : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgVdsVersionInfoGet();

   virtual ~sensor_locationfi_tclMsgVdsVersionInfoGet();

   inline tBool operator==(const sensor_locationfi_tclMsgVdsVersionInfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgVdsVersionInfoStatus : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgVdsVersionInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_locationfi_tclMsgVdsVersionInfoStatus& operator=(const sensor_locationfi_tclMsgVdsVersionInfoStatus& coRef);
   sensor_locationfi_tclMsgVdsVersionInfoStatus(const sensor_locationfi_tclMsgVdsVersionInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sensor_fi_tcl_VdsVersionInfo VdsVersion;
   virtual ~sensor_locationfi_tclMsgVdsVersionInfoStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_locationfi_tclMsgVdsVersionInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgAccTemperatureGet : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgAccTemperatureGet();

   virtual ~sensor_locationfi_tclMsgAccTemperatureGet();

   inline tBool operator==(const sensor_locationfi_tclMsgAccTemperatureGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgAccTemperatureUpReg : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgAccTemperatureUpReg();

   virtual ~sensor_locationfi_tclMsgAccTemperatureUpReg();

   inline tBool operator==(const sensor_locationfi_tclMsgAccTemperatureUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgAccTemperatureRelUpReg : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgAccTemperatureRelUpReg();

   virtual ~sensor_locationfi_tclMsgAccTemperatureRelUpReg();

   inline tBool operator==(const sensor_locationfi_tclMsgAccTemperatureRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgAccTemperatureStatus : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgAccTemperatureStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_locationfi_tclMsgAccTemperatureStatus& operator=(const sensor_locationfi_tclMsgAccTemperatureStatus& coRef);
   sensor_locationfi_tclMsgAccTemperatureStatus(const sensor_locationfi_tclMsgAccTemperatureStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tF32 AccTemperature;
   virtual ~sensor_locationfi_tclMsgAccTemperatureStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_locationfi_tclMsgAccTemperatureStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgDiagGnssSatSystemGet : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgDiagGnssSatSystemGet();

   virtual ~sensor_locationfi_tclMsgDiagGnssSatSystemGet();

   inline tBool operator==(const sensor_locationfi_tclMsgDiagGnssSatSystemGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgDiagGnssSatSystemSet : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgDiagGnssSatSystemSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_locationfi_tclMsgDiagGnssSatSystemSet& operator=(const sensor_locationfi_tclMsgDiagGnssSatSystemSet& coRef);
   sensor_locationfi_tclMsgDiagGnssSatSystemSet(const sensor_locationfi_tclMsgDiagGnssSatSystemSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sensor_fi_tcl_b8_GnssSatSys TargetGnssSatSys;
   virtual ~sensor_locationfi_tclMsgDiagGnssSatSystemSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_locationfi_tclMsgDiagGnssSatSystemSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sensor_locationfi_tclMsgDiagGnssSatSystemStatus : public sensor_locationfi_tclMsgBaseMessage
{
public:

   sensor_locationfi_tclMsgDiagGnssSatSystemStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sensor_locationfi_tclMsgDiagGnssSatSystemStatus& operator=(const sensor_locationfi_tclMsgDiagGnssSatSystemStatus& coRef);
   sensor_locationfi_tclMsgDiagGnssSatSystemStatus(const sensor_locationfi_tclMsgDiagGnssSatSystemStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sensor_fi_tcl_b8_GnssSatSys ActualGnssSatSys;
   virtual ~sensor_locationfi_tclMsgDiagGnssSatSystemStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sensor_locationfi_tclMsgDiagGnssSatSystemStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
