#ifndef SENSOR_LOCATIONFILANGUAGE_HEADER
#define SENSOR_LOCATIONFILANGUAGE_HEADER

class sensor_locationfi_tclInContext;
class sensor_locationfi_tclOutContext;
class sensor_locationfi_tclVisitorBase;

class MY_DECL sensor_locationfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  sensor_locationfi_tclDescription(fi_tclInContext* poIn, sensor_locationfi_tclVisitorBase* poVisit);
  sensor_locationfi_tclDescription(fi_tclOutContext* poOut, sensor_locationfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(sensor_locationfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(sensor_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ sensor_locationfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--Lesen oder Schreiben?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  sensor_locationfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<sensor_locationfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<sensor_locationfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline sensor_locationfi_tclDescription::sensor_locationfi_tclDescription(fi_tclInContext* poIn, sensor_locationfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline sensor_locationfi_tclDescription::sensor_locationfi_tclDescription(fi_tclOutContext* poOut, sensor_locationfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

