#include "precompiled.hh"
#include "alltypefactory.h"

fi_tclTypeBase* sds_fi_poGetFIObject(tU16 u16ServiceId, tU16 u16FunctionId, tU8 u8Opcode)
{
   fi_tclMessageBase* poType
   = sds_fi_poGetMessageBaseObject(u16ServiceId, u16FunctionId, u8Opcode);
   if (poType)
      return &poType->rfoGetTypeBase();
   else
      return OSAL_NULL;
}

fi_tclMessageBase* sds_fi_poGetMessageBaseObject(tU16 u16ServiceId, tU16 u16FunctionId, tU8 u8Opcode)
{
   switch(u16ServiceId)
   {
      case SDS_VOICECONTROLFI_C_U16_SERVICE_ID:
         return sds_voicecontrolfi_poGetMessageBaseObject(u16FunctionId, u8Opcode); 

      case SDS_TTSFI_C_U16_SERVICE_ID:
         return sds_ttsfi_poGetMessageBaseObject(u16FunctionId, u8Opcode); 

      case SDS_REC_RECOGSERVICEFI_C_U16_SERVICE_ID:
         return sds_rec_recogservicefi_poGetMessageBaseObject(u16FunctionId, u8Opcode); 

      case SDS_REC_VOCONSERVICEFI_C_U16_SERVICE_ID:
         return sds_rec_voconservicefi_poGetMessageBaseObject(u16FunctionId, u8Opcode); 

      case SDS_SPEECHDPFI_C_U16_SERVICE_ID:
         return sds_speechdpfi_poGetMessageBaseObject(u16FunctionId, u8Opcode); 

      case SDS_PROMPTPLAYERFI_C_U16_SERVICE_ID:
         return sds_promptplayerfi_poGetMessageBaseObject(u16FunctionId, u8Opcode); 

      case SDS_TRANSCRIPTIONSERVICEFI_C_U16_SERVICE_ID:
         return sds_transcriptionservicefi_poGetMessageBaseObject(u16FunctionId, u8Opcode); 

      case SDS_TEST_BASEAPPFI_C_U16_SERVICE_ID:
         return sds_test_baseappfi_poGetMessageBaseObject(u16FunctionId, u8Opcode); 

      case SDS_MSTTESTCOMPONENTFI_C_U16_SERVICE_ID:
         return sds_msttestcomponentfi_poGetMessageBaseObject(u16FunctionId, u8Opcode); 

      default: 
         return OSAL_NULL;
   }
}

